/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.trax;

import com.icl.saxon.trax.ProcessorException;
import com.icl.saxon.trax.ProcessorFactoryException;
import com.icl.saxon.trax.Templates;
import com.icl.saxon.trax.TemplatesBuilder;
import com.icl.saxon.trax.URIResolver;
import java.io.IOException;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class Processor {
    private static String platformDefaultFactoryName = "com.icl.saxon.StyleSheet";
    private XMLReader reader;
    private URIResolver resolver;
    ErrorHandler errorHandler;

    public static void setPlatformDefaultProcessor(String string) {
        platformDefaultFactoryName = string;
    }

    public static Processor newInstance(String string) throws ProcessorFactoryException {
        Processor processor = null;
        try {
            String string2 = System.getProperty("trax.processor." + string);
            if (null == string2) {
                string2 = platformDefaultFactoryName;
            }
            if (null == string2) {
                throw new ProcessorFactoryException("Can't find system property trax.processor.xslt", null);
            }
            Class<?> clazz = Class.forName(string2);
            processor = (Processor)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProcessorFactoryException("Transformation Processor can not be accessed!", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessorFactoryException("Not able to create Transformation Processor!", instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProcessorFactoryException("Transformation Processor not found!", classNotFoundException);
        }
        return processor;
    }

    public abstract Templates process(InputSource var1) throws ProcessorException, SAXException, IOException;

    public abstract Templates processFromNode(Node var1) throws ProcessorException;

    public abstract Templates processMultiple(InputSource[] var1) throws ProcessorException;

    public abstract InputSource[] getAssociatedStylesheets(InputSource var1, String var2, String var3, String var4) throws ProcessorException;

    public abstract TemplatesBuilder getTemplatesBuilder() throws ProcessorException;

    public void setXMLReader(XMLReader xMLReader) {
        this.reader = xMLReader;
    }

    public XMLReader getXMLReader() {
        return this.reader;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("Null error handler");
        }
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

