dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.


dnl  This file is free software; you can redistribute it and/or
dnl  modify it under the terms and conditions of the GNU Library
dnl  General Public License as published by the Free Software
dnl  Fondation; either version 2 of the License, or (at your option)
dnl  any later version.
dnl
dnl  This library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Library General Public License for more details.
dnl
dnl  You should have received a copy of the GNU General Public License
dnl  along with this library; see the file COPYING.LIB.  If not, write
dnl  to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
dnl  Boston, MA 02111-1307, USA.
dnl
dnl  IMPORTANT NOTE:
dnl  Please do not modify this file unless you expect your changes to be
dnl  carried into every other module in the repository.  If you decide
dnl  that you really want to modify it, contact cbyam@virginia.edu,
dnl  mention that you have and that the modified file should be committed
dnl  to every module.
dnl
dnl  Single module modifications are best placed in configure.in or
dnl  configure.in.in if present.
dnl
dnl  acinclude.m4
dnl     macros autoconf uses when building configure from configure.in
dnl
dnl  $Id: acinclude.m4,v 1.14 2001/05/01 00:21:55 kg4ijb Exp $
dnl
dnl    aclocal.m4 -> acinclude.m4
dnl    Make changes to the configure scripts here and not to aclocal.m4
dnl    if you want the them to remain permanent.
dnl


dnl ----------------------------------------------------------------------
dnl XASTIR_MSG_CONFIGURE_START()
dnl
AC_DEFUN(XASTIR_MSG_CONFIGURE_START, [dnl
AC_MSG_RESULT()
AC_MSG_RESULT(=======================================================)
AC_MSG_RESULT(This is Xastir's GNU configure script.)
AC_MSG_RESULT(It's going to run a bunch of strange tests to hopefully)
AC_MSG_RESULT(make your compile work without much twiddling.)
AC_MSG_RESULT(=======================================================)
AC_MSG_RESULT()
])dnl

dnl ----------------------------------------------------------------------
dnl
dnl XASTIR_MSG_CONFIGURE_END()
dnl
AC_DEFUN(XASTIR_MSG_CONFIGURE_END, [dnl
AC_MSG_RESULT()
AC_MSG_RESULT(=====================================================================)
AC_MSG_RESULT(Configure is done.)
AC_MSG_RESULT()
if test -f "./$XASTIREXEC"
then
  AC_MSG_RESULT([Type 'make clean' and then type 'make'])
else
  AC_MSG_RESULT([Type 'make' to create the executable then 'make install' as root.])
fi
AC_MSG_RESULT(=====================================================================)
AC_MSG_RESULT()
])dnl


dnl ------------------------------------------------------------------------
dnl Find a file (or one of more files in a list of dirs)
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])


dnl ----------------------------------------------------------------------
dnl
dnl XASTIR_FIND_PATH(program-name, variable-name, list of directories,
dnl       if-not-found, test-parameter)
dnl
AC_DEFUN(XASTIR_FIND_PATH,
[
  AC_MSG_CHECKING([for $1])
  if test -n "$$2"; then
    aprsd_cv_path="$$2";
  else
    xastir_cache=`echo $1 | sed 'y%./+-%__p_%'`

    AC_CACHE_VAL(xastir_cv_path$xastir_cache,
    [
    xastir_cv_path="NONE"
    dirs="$3"
    xastir_save_IFS=$IFS
    IFS=':'
    for dir in $PATH; do
      dirs="$dirs $dir"
    done
    IFS=$xastir_save_IFS

    for dir in $dirs; do
      if test -x "$dir/$1"; then
        if test -n "$5"
        then
          evalstr="$dir/$1 $5 2>&1 "
          if eval $evalstr; then
            xastir_cv_path="$dir/$1"
            break
          fi
        else
          xastir_cv_path="$dir/$1"
          break
        fi
      fi
    done

    eval "xastir_cv_path_$aprsd_cache=$xastir_cv_path"

    ])
    eval "xastir_cv_path=\"`echo '$xastir_cv_path_'$xastir_cache`\""

  fi

if test
  -z "$xastir_cv_path" || test "xastir_cv_path" = NONE;
then AC_MSG_RESULT(not found)
  $4
else
  AC_MSG_RESULT($xastir_cv_path)
  $2=$xastir_cv_path
fi
])





dnl ----------------------------------------------------------------------
#
# Check to make sure that the build environment is sane.
#
AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])




dnl ----------------------------------------------------------------------
# Like AC_CONFIG_HEADER, but automatically create stamp file.
AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

dnl ----------------------------------------------------------------------
dnl  XASTIR_CHECK_CCPIPE()
dnl
dnl  Checks whether the compiler supports the `-pipe' flag, which
dnl  speeds up the compilation.
AC_DEFUN(XASTIR_CHECK_CCPIPE, [dnl
if test -z "$no_pipe"
then
  if test -n "$GCC"
  then
    AC_CACHE_CHECK(whether the compiler understands -pipe, xastir_cv_var_ccpipe,
    [dnl
      ac_old_cflags=$CFLAGS
      ac_old_CC="$CC"
      CFLAGS="$CFLAGS -pipe"
      AC_TRY_COMPILE(,, xastir_cv_var_ccpipe="yes", xastir_cv_var_ccpipe="no")
      CC="$ac_old_CC"
    ])
    if test "x$xastir_cv_var_ccpipe" = "xno"; then
      CFLAGS="$ac_old_cflags"
    fi
  fi
fi
])dnl


AC_DEFUN([AM_WITH_DMALLOC],
[AC_MSG_CHECKING(whether to dmalloc library)
AC_ARG_WITH(dmalloc,
[  --with-dmalloc[=ARG]    Compile with dmalloc library],
if test "$withval" = "" -o "$withval" = "yes"; then
  ac_cv_dmalloc="/usr/local"
  AC_DEFINE(WITH_DMALLOC, 1, [Define if using dmalloc debugging malloc package])
else
  ac_cv_dmalloc="$withval"
  AC_DEFINE(WITH_DMALLOC, 0, [Define if using dmalloc debugging malloc package])
fi
AC_MSG_RESULT(yes)
CPPFLAGS="$CPPFLAGS -DDEBUG_DMALLOC -DDMALLOC_FUNC_CHECK -I$ac_cv_dmalloc/include"
LDFLAGS="$LDFLAGS -L$ac_cv_dmalloc/lib"
LIBS="$LIBS -ldmalloc"
,AC_MSG_RESULT(no))
])



dnl ----------------------------------------------------------------------
dnl
AC_DEFUN(CHECK_AX25,
[
  AC_ARG_WITH(ax25,
  [ --with-ax25=DIR directory path of ax25 installation [checks
      /usr/include and /usr/local/include]
  --without-ax25 to disable ax25 support completely],
  [if test "$withval" != no ; then
    AC_MSG_CHECKING([for AX25])
  else
    AC_MSG_RESULT([No AX25 support requested])
  fi], [

  LIBS_AX25=""

  ac_new_ax25_incdirs="/usr/include/netax25 /usr/local/include/netax25"
  ac_old_ax25_incdirs="/usr/include/ax25 /usr/local/include/ax25"
  ac_ax25_libdirs="/usr/lib /usr/local/lib"

  AC_FIND_FILE(axlib.h, $ac_new_ax25_incdirs, ac_new_ax25_incdir)
  AC_FIND_FILE(libax25.so, $ac_ax25_libdirs, ac_ax25_libdir)
  if test ! "$ac_new_ax25_incdir" = "NO"; then
    #CFLAGS="$CFLAGS $ac_new_ax25_incdir"
    AC_DEFINE_UNQUOTED(WITH_AX25, 1, [Define if you have AX25])
    AC_DEFINE_UNQUOTED(WITH_NEW_AX25, 1, [Define if you have "new" AX25])
    AC_CHECK_LIB(ax25, ax25_aton_entry, LIBS_AX25="-lax25")
    AC_SUBST(LIBS_AX25)
    AC_MSG_RESULT(["New" AX25 found: libraries: $ac_ax25_libdir, headers: $ac_new_ax25_incdir])
  fi

  AC_FIND_FILE(axconfig.h, $ac_old_ax25_incdirs, ac_old_ax25_incdir)
  if test ! "$ac_old_ax25_incdir" = "NO"; then
    #CFLAGS="$CFLAGS $ac_old_ax25_incdir"
    AC_DEFINE_UNQUOTED(WITH_AX25, 1, [Define if you have AX25])
    AC_DEFINE_UNQUOTED(WITH_OLD_AX25, 1, [Define if you have AX25])
    AC_CHECK_LIB(ax25, convert_call_entry, LIBS_AX25="-lax25")
    AC_SUBST(LIBS_AX25)
    AC_MSG_RESULT(["OLD" AX25 found: libraries: , headers: $ac_old_ax25_incdir])
  fi
  LIBS="$LIBS $LIBS_AX25"
  ])
])


dnl ----------------------------------------------------------------------
dnl  XASTIR_CHECK_GEOTIFF_LIBS()
dnl
AC_DEFUN(XASTIR_CHECK_GEOTIFF_LIBS, [dnl
if test "$IRIX" = "yes"
then
  AC_MSG_WARN(Skipping library tests because they CONFUSE Irix.)
else
  AC_CHECK_LIB(tiff, TIFFClose, XASTIR_TIFF_LIB="-ltiff")
  AC_CHECK_LIB(geotiff, GTIFNew, XASTIR_GEOTIFF_LIB="-lgeotiff")
  AC_CHECK_LIB(proj, pj_init, XASTIR_PROJ_LIB="-lproj")
  if test "$XASTIR_PROJ_LIB" = "-lproj"
  then
    if test "$XASTIR_TIFF_LIB" = "-ltiff"
    then
      if test "$XASTIR_GEOTIFF_LIB" = "-lgeotiff"
      then
        CFLAGS="-DUSE_GEOTIFF ${CFLAGS}"
        LIBS="${XASTIR_GEOTIFF_LIB} ${XASTIR_PROJ_LIB} ${LIBS} ${XASTIR_TIFF_LIB} "
        AC_SUBST(CFLAGS)
        AC_MSG_RESULT(GeoTIFF support found and will be compiled in.)
      fi
    fi
  fi
fi
])dnl



dnl ----------------------------------------------------------------------
dnl  XASTIR_CHECK_FESTIVAL()
dnl
AC_DEFUN(XASTIR_CHECK_FESTIVAL, [dnl
  AC_MSG_CHECKING([for Festival Speech Synthesizer Support])
if test -f "/usr/bin/festival" || test -f "/usr/local/bin/festival"; then
  AC_MSG_RESULT(Found.)
  CFLAGS="-DHAVE_FESTIVAL ${CFLAGS}"
  AC_SUBST(CFLAGS)
else
  AC_MSG_RESULT(not found.)
fi
])dnl



dnl ------------------------------------------------------------------------
dnl Find the header files and libraries for X-Windows. Extended the
dnl macro AC_PATH_X
dnl ------------------------------------------------------------------------
dnl
AC_DEFUN(XASTIR_PATH_X,
[
AC_REQUIRE([AC_PROG_CPP])dnl
AC_REQUIRE([XASTIR_MISC_TESTS])dnl
AC_MSG_CHECKING(for X)
# AC_LANG_SAVE
# AC_LANG_C
AC_CACHE_VAL(xastir_cv_have_x,
[# One or both of the vars are not set, and there is no cached value.
if test "{$x_includes+set}" = set || test "$x_includes" = NONE; then
   xastir_x_includes=NO
else
   xastir_x_includes=$x_includes
fi
if test "{$x_libraries+set}" = set || test "$x_libraries" = NONE; then
   xastir_x_libraries=NO
else
   xastir_x_libraries=$x_libraries
fi

# below we use the standard autoconf calls
ac_x_libraries=$xastir_x_libraries
ac_x_includes=$xastir_x_includes

AC_PATH_X_DIRECT
dnl AC_PATH_X_XMKMF picks /usr/lib as the path for the X libraries.
dnl Unfortunately, if compiling with the N32 ABI, this is not the correct
dnl location. The correct location is /usr/lib32 or an undefined value
dnl (the linker is smart enough to pick the correct default library).
dnl Things work just fine if you use just AC_PATH_X_DIRECT.
case "$host" in
mips-sgi-irix6*)
  ;;
*)
  AC_PATH_X_XMKMF
  if test -z "$ac_x_includes"; then
    ac_x_includes="."
  fi
  if test -z "$ac_x_libraries"; then
    ac_x_libraries="/usr/lib"
  fi
esac
#from now on we use our own again

# when the user already gave --x-includes, we ignore
# what the standard autoconf macros told us.
if test "$xastir_x_includes" = NO; then
  xastir_x_includes=$ac_x_includes
fi

# for --x-libraries too
if test "$xastir_x_libraries" = NO; then
  xastir_x_libraries=$ac_x_libraries
fi

if test "$xastir_x_includes" = NO; then
  AC_MSG_ERROR([Can't find X includes. Please check your installation and add the correct paths!])
fi

if test "$xastir_x_libraries" = NO; then
  AC_MSG_ERROR([Can't find X libraries. Please check your installation and add the correct paths!])
fi

# Record where we found X for the cache.
xastir_cv_have_x="have_x=yes \
         xastir_x_includes=$xastir_x_includes xastir_x_libraries=$xastir_x_libraries"
])dnl
eval "$xastir_cv_have_x"

if test "$have_x" != yes; then
  AC_MSG_RESULT($have_x)
  no_x=yes
else
  AC_MSG_RESULT([libraries $xastir_x_libraries, headers $xastir_x_includes])
fi

if test -z "$xastir_x_includes" || test "x$xastir_x_includes" = xNONE; then
  X_INCLUDES=""
  x_includes="."; dnl better than nothing :-
 else
  x_includes=$xastir_x_includes
  X_INCLUDES="-I$x_includes"
fi

if test -z "$xastir_x_libraries" || test "x$xastir_x_libraries" = xNONE; then
  X_LDFLAGS=""
  x_libraries="/usr/lib"; dnl better than nothing :-
 else
  x_libraries=$xastir_x_libraries
  X_LDFLAGS="-L$x_libraries"
fi
all_includes="$X_INCLUDES"
all_libraries="$X_LDFLAGS"

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)
AC_SUBST(x_libraries)
AC_SUBST(x_includes)

# Check for libraries that X11R6 Xt/Xaw programs need.
ac_save_LDFLAGS="$LDFLAGS"
LDFLAGS="$LDFLAGS $X_LDFLAGS"
# SM needs ICE to (dynamically) link under SunOS 4.x (so we have to
# check for ICE first), but we must link in the order -lSM -lICE or
# we get undefined symbols.  So assume we have SM if we have ICE.
# These have to be linked with before -lX11, unlike the other
# libraries we check for below, so use a different variable.
#  --interran@uluru.Stanford.EDU, kb@cs.umb.edu.
AC_CHECK_LIB(ICE, IceConnectionNumber,
  [LIBSM="-llibSM -lICE"], , $X_EXTRA_LIBS)
AC_SUBST(LIBSM)
LDFLAGS="$ac_save_LDFLAGS"

AC_SUBST(X_PRE_LIBS)

LIB_X11='-lX11 $(LIBSOCKET)'
AC_SUBST(LIB_X11)

AC_MSG_CHECKING(for libXext)
AC_CACHE_VAL(xastir_cv_have_libXext,
[
xastir_ldflags_safe="$LDFLAGS"
xastir_libs_safe="$LIBS"

LDFLAGS="$LDFLAGS $X_LDFLAGS $USER_LDFLAGS"
LIBS="-lXext -lX11 $LIBSOCKET"

AC_TRY_LINK([
#include <stdio.h>
],
[
printf("hello Xext\n");
],
xastir_cv_have_libXext=yes,
xastir_cv_have_libXext=no
   )

LDFLAGS=$xastir_ldflags_safe
LIBS=$xastir_libs_safe
 ])

AC_MSG_RESULT($xastir_cv_have_libXext)

if test "$xastir_cv_have_libXext" = "no"; then
  AC_MSG_ERROR([We need a working libXext to proceed. Since configure
can't find it itself, we stop here assuming that make wouldn't find
them either.])
fi

])

# AC_LANG_RESTORE
])


dnl ----------------------------------------------------------------------
dnl
dnl AC_FIND_MOTIF : find OSF/Motif or LessTif, and provide variables
dnl	to easily use them in a Makefile.
dnl
dnl Adapted from a macro by Andreas Zeller.
dnl
dnl The variables provided are :
dnl	link_motif		(e.g. -L/usr/lesstif/lib -lXm)
dnl	include_motif		(e.g. -I/usr/lesstif/lib)
dnl	motif_libraries		(e.g. /usr/lesstif/lib)
dnl	motif_includes		(e.g. /usr/lesstif/include)
dnl
dnl The link_motif and include_motif variables should be fit to put on
dnl your application's link line in your Makefile.
dnl
dnl Oleo CVS Id: motif.m4,v 1.9 1999/04/09 11:46:49 danny
dnl LessTif CVS $Id: acinclude.m4,v 1.14 2001/05/01 00:21:55 kg4ijb Exp $
dnl
AC_DEFUN(AC_FIND_MOTIF,
[
AC_REQUIRE([AC_PATH_XTRA])
motif_includes=
motif_libraries=
dnl AC_ARG_WITH(motif,
dnl [  --without-motif         do not use Motif widgets])
dnl Treat --without-motif like
dnl --without-motif-includes --without-motif-libraries.
dnl if test "$with_motif" = "no"
dnl then
dnl   motif_includes=none
dnl   motif_libraries=none
dnl fi

AC_ARG_WITH(motif-includes,
[  --with-motif-includes=DIR    Motif include files are in DIR],
motif_includes="$withval")

AC_ARG_WITH(motif-libraries,
[  --with-motif-libraries=DIR   Motif libraries are in DIR],
motif_libraries="$withval")

AC_MSG_CHECKING(for Motif)

#
#
# Search the include files.
#
if test "$motif_includes" = ""; then
AC_CACHE_VAL(ac_cv_motif_includes,
[
ac_motif_save_LIBS="$LIBS"
ac_motif_save_INCLUDES="$INCLUDES"
ac_motif_save_CPPFLAGS="$CPPFLAGS"
ac_motif_save_LDFLAGS="$LDFLAGS"
#
LIBS="$X_PRE_LIBS -lXm -lXt -lX11 -Xpm $X_EXTRA_LIBS $LIBS"
INCLUDES="$X_CFLAGS $INCLUDES"
CPPFLAGS="$X_CFLAGS $CPPFLAGS"
LDFLAGS="$X_LIBS $LDFLAGS"
#
ac_cv_motif_includes="none"
AC_TRY_COMPILE([#include <Xm/Xm.h>],[int a;],
[
# Xm/Xm.h is in the standard search path.
ac_cv_motif_includes=
],
[
# Xm/Xm.h is not in the standard search path.
# Locate it and put its directory in `motif_includes'
#
# /usr/include/Motif* are used on HP-UX (Motif).
# /usr/include/X11* are used on HP-UX (X and Athena).
# /usr/dt is used on Solaris (Motif).
# /usr/openwin is used on Solaris (X and Athena).
# Other directories are just guesses.
for dir in "$x_includes" "${prefix}/include" /usr/include /usr/local/include \
           /usr/include/Motif2.0 /usr/include/Motif1.2 /usr/include/Motif1.1 \
           /usr/include/X11R6 /usr/include/X11R5 /usr/include/X11R4 \
           /usr/dt/include /usr/openwin/include \
           /usr/dt/*/include /opt/*/include /usr/include/Motif* \
           "${prefix}"/*/include /usr/*/include /usr/local/*/include \
           "${prefix}"/include/* /usr/include/* /usr/local/include/*; do
if test -f "$dir/Xm/Xm.h"; then
ac_cv_motif_includes="$dir"
break
fi
done
])
#
LIBS="$ac_motif_save_LIBS"
INCLUDES="$ac_motif_save_INCLUDES"
CPPFLAGS="$ac_motif_save_CPPFLAGS"
LDFLAGS="$ac_motif_save_LDFLAGS"
])
motif_includes="$ac_cv_motif_includes"
fi
#
#
# Now for the libraries.
#
if test "$motif_libraries" = ""; then
AC_CACHE_VAL(ac_cv_motif_libraries,
[
ac_motif_save_LIBS="$LIBS"
ac_motif_save_INCLUDES="$INCLUDES"
ac_motif_save_CPPFLAGS="$CPPFLAGS"
ac_motif_save_LDFLAGS="$LDFLAGS"
#
LIBS="$X_PRE_LIBS -lXm -lXt -lX11 $X_EXTRA_LIBS $LIBS"
INCLUDES="$X_CFLAGS $INCLUDES"
CPPFLAGS="$X_CFLAGS $CPPFLAGS"
LDFLAGS="$X_LIBS $LDFLAGS"
#
ac_cv_motif_libraries="none"
AC_TRY_LINK([#include <Xm/Xm.h>],[XtToolkitInitialize();],
[
# libXm.a is in the standard search path.
ac_cv_motif_libraries=
],
[
# libXm.a is not in the standard search path.
# Locate it and put its directory in `motif_libraries'
#
# /usr/lib/Motif* are used on HP-UX (Motif).
# /usr/lib/X11* are used on HP-UX (X and Athena).
# /usr/dt is used on Solaris (Motif).
# /usr/lesstif is used on Linux (Lesstif).
# /usr/openwin is used on Solaris (X and Athena).
# Other directories are just guesses.
for dir in "$x_libraries" "${prefix}/lib" /usr/lib /usr/local/lib \
           /usr/lib/Motif2.0 /usr/lib/Motif1.2 /usr/lib/Motif1.1 \
           /usr/lib/X11R6 /usr/lib/X11R5 /usr/lib/X11R4 /usr/lib/X11 \
           /usr/dt/lib /usr/openwin/lib \
           /usr/dt/*/lib /opt/*/lib /usr/lib/Motif* \
           /usr/lesstif*/lib /usr/lib/Lesstif* \
           "${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
           "${prefix}"/lib/* /usr/lib/* /usr/local/lib/*; do
if test -d "$dir" && test "`ls $dir/libXm.* 2> /dev/null`" != ""; then
ac_cv_motif_libraries="$dir"
break
fi
done
])
#
LIBS="$ac_motif_save_LIBS"
INCLUDES="$ac_motif_save_INCLUDES"
CPPFLAGS="$ac_motif_save_CPPFLAGS"
LDFLAGS="$ac_motif_save_LDFLAGS"
])
#
motif_libraries="$ac_cv_motif_libraries"
fi
#
# Provide an easier way to link
#
if test "$motif_includes" = "none" -o "$motif_libraries" = "none"; then
        with_motif="no"
else
        with_motif="yes"
fi

if test "$with_motif" != "no"; then
        if test "$motif_libraries" = ""; then
                link_motif="-lXm"
                MOTIF_LIBS="-lXm"
        else
                link_motif="-L$motif_libraries -lXm"
                MOTIF_LIBS="-L$motif_libraries -lXm"
        fi
        if test "$motif_includes" != ""; then
                include_motif="-I$motif_includes"
                MOTIF_CFLAGS="-I$motif_includes"
        fi
	AC_DEFINE(HAVE_MOTIF)
else
        with_motif="no"
fi
#
AC_SUBST(link_motif)
AC_SUBST(include_motif)
AC_SUBST(MOTIF_CFLAGS)
AC_SUBST(MOTIF_LIBS)
AC_DEFINE(STIPPLE,[True])
#
#
#
motif_libraries_result="$motif_libraries"
motif_includes_result="$motif_includes"
test "$motif_libraries_result" = "" && motif_libraries_result="in default path"
test "$motif_includes_result" = "" && motif_includes_result="in default path"
test "$motif_libraries_result" = "none" && motif_libraries_result="(none)"
test "$motif_includes_result" = "none" && motif_includes_result="(none)"
AC_MSG_RESULT(
  [libraries $motif_libraries_result, headers $motif_includes_result])
])dnl

dnl ----------------------------------------------------------------------
dnl
dnl AC_FIND_XBAE : find libXbae, and provide variables
dnl	to easily use them in a Makefile.
dnl
dnl Adapted from a macro by Andreas Zeller.
dnl
dnl The variables provided are :
dnl	link_xbae		(e.g. -L/usr/lesstif/lib -lXm)
dnl	include_xbae		(e.g. -I/usr/lesstif/lib)
dnl	xbae_libraries		(e.g. /usr/lesstif/lib)
dnl	xbae_includes		(e.g. /usr/lesstif/include)
dnl
dnl The link_xbae and include_xbae variables should be fit to put on
dnl your application's link line in your Makefile.
dnl
AC_DEFUN(AC_FIND_XBAE,
[
AC_REQUIRE([AC_FIND_MOTIF])
xbae_includes=
xbae_libraries=
AC_ARG_WITH(xbae,
[  --without-xbae         do not use Xbae widgets])
dnl Treat --without-xbae like
dnl --without-xbae-includes --without-xbae-libraries.
if test "$with_xbae" = "no"
then
    xbae_includes=no
    xbae_libraries=no
fi
AC_ARG_WITH(xbae-includes,
    [  --with-xbae-includes=DIR    Xbae include files are in DIR], xbae_includes="$withval")
AC_ARG_WITH(xbae-libraries,
    [  --with-xbae-libraries=DIR   Xbae libraries are in DIR], xbae_libraries="$withval")
if test "$xbae_includes" = "no" && test "$xbae_libraries" = "no"
then
    with_xbae="no"
fi

AC_MSG_CHECKING([for Xbae])
if test "$with_xbae" != "no"
then
    #
    #
    # Search the include files.
    #
    if test "$xbae_includes" = ""
    then
	AC_CACHE_VAL(ac_cv_xbae_includes,
	[
	ac_xbae_save_CFLAGS="$CFLAGS"
	ac_xbae_save_CPPFLAGS="$CPPFLAGS"
	#
	CFLAGS="$MOTIF_CFLAGS $X_CFLAGS $CFLAGS"
	CPPFLAGS="$MOTIF_CFLAGS $X_CFLAGS $CPPFLAGS"
	#
	AC_TRY_COMPILE([#include <Xbae/Matrix.h>],[int a;],
	[
	# Xbae/Matrix.h is in the standard search path.
	ac_cv_xbae_includes=
	],
	[
	# Xbae/Matrix.h is not in the standard search path.
	# Locate it and put its directory in `xbae_includes'
	#
	# Other directories are just guesses.
	for dir in "$x_includes" "${prefix}/include" /usr/include /usr/local/include \
		   /usr/include/Motif2.0 /usr/include/Motif1.2 /usr/include/Motif1.1 \
		   /usr/include/X11R6 /usr/include/X11R5 /usr/include/X11R4 \
		   /usr/dt/include /usr/openwin/include \
		   /usr/dt/*/include /opt/*/include /usr/include/Xbae* \
		   "${prefix}"/*/include /usr/*/include /usr/local/*/include \
		   "${prefix}"/include/* /usr/include/* /usr/local/include/*
	do
	    if test -f "$dir/Xbae/Matrix.h"
	    then
		ac_cv_xbae_includes="$dir"
		break
	    fi
	done
	])
	#
	CFLAGS="$ac_xbae_save_CFLAGS"
	CPPFLAGS="$ac_xbae_save_CPPFLAGS"
	])
	xbae_includes="$ac_cv_xbae_includes"
    fi

    if test -z "$xbae_includes"
    then
	xbae_includes_result="default path"
	XBAE_CFLAGS=""
    else
	if test "$xbae_includes" = "no"
	then
	    xbae_includes_result="told not to use them"
	    XBAE_CFLAGS=""
	else
	    xbae_includes_result="$xbae_includes"
	    XBAE_CFLAGS="-I$xbae_includes"
	fi
    fi
    #
    #
    # Now for the libraries.
    #
    if test "$xbae_libraries" = ""
    then
	AC_CACHE_VAL(ac_cv_xbae_libraries,
	[
	ac_xbae_save_LIBS="$LIBS"
	ac_xbae_save_CFLAGS="$CFLAGS"
	ac_xbae_save_CPPFLAGS="$CPPFLAGS"
	#
	LIBS="-lXbae $MOTIF_LIBS $X_LIBS $X_PRE_LIBS -lXt -lX11 $X_EXTRA_LIBS $LIBS"
	CFLAGS="$XBAE_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $CFLAGS"
	CPPFLAGS="$XBAE_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $CPPFLAGS"
	#
	AC_TRY_LINK([#include <Xbae/Matrix.h>],[Widget w; XbaeMatrixDeselectAll(w);],
	[
	# libXbae.a is in the standard search path.
	ac_cv_xbae_libraries=
	],
	[
	# libXbae.a is not in the standard search path.
	# Locate it and put its directory in `xbae_libraries'
	#
	# Other directories are just guesses.
	for dir in "$x_libraries" "${prefix}/lib" /usr/lib /usr/local/lib \
		   /usr/lib/Xbae \
		   /usr/lib/X11R6 /usr/lib/X11R5 /usr/lib/X11R4 /usr/lib/X11 \
		   /usr/dt/lib /usr/openwin/lib \
		   /usr/dt/*/lib /opt/*/lib /usr/lib/Xbae* \
		   /usr/lesstif*/lib /usr/lib/Lesstif* \
		   "${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
		   "${prefix}"/lib/* /usr/lib/* /usr/local/lib/*; do
	    for ext in "sl" "so" "a"; do
		if test -d "$dir" && test -f "$dir/libXbae.$ext"; then
		    ac_cv_xbae_libraries="$dir"
		    break 2
		fi
	    done
	done
	])
	#
	LIBS="$ac_xbae_save_LIBS"
	CFLAGS="$ac_xbae_save_CFLAGS"
	CPPFLAGS="$ac_xbae_save_CPPFLAGS"
	])
	#
	xbae_libraries="$ac_cv_xbae_libraries"
    fi
    if test -z "$xbae_libraries"
    then
	xbae_libraries_result="default path"
	XBAE_LIBS="-lXbae"
    else
	if test "$xbae_libraries" = "no"
	then
	    xbae_libraries_result="told not to use it"
	    XBAE_LIBS=""
	else
	    xbae_libraries_result="$xbae_libraries"
	    XBAE_LIBS="-L$xbae_libraries -lXbae"
	fi
    fi
#
# Make sure, whatever we found out, we can link.
#
    ac_xbae_save_LIBS="$LIBS"
    ac_xbae_save_CFLAGS="$CFLAGS"
    ac_xbae_save_CPPFLAGS="$CPPFLAGS"
    #
    LIBS="$XBAE_LIBS $MOTIF_LIBS $X_LIBS $X_PRE_LIBS -lXt -lX11 -lXpm $X_EXTRA_LIBS $LIBS"
    CFLAGS="$XBAE_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $CFLAGS"
    CPPFLAGS="$XBAE_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $CPPFLAGS"

    AC_TRY_LINK([#include <Xbae/Matrix.h>],[Widget w; XbaeMatrixDeselectAll(w);],
	[
	#
	# link passed
	#
	AC_DEFINE(HAVE_XBAE)
	],
	[
	#
	# link failed
	#
	xbae_libraries_result="test link failed"
	xbae_includes_result="test link failed"
	with_xbae="no"
	XBAE_CFLAGS=""
	XBAE_LIBS=""
	]) dnl AC_TRY_LINK

    LIBS="$ac_xbae_save_LIBS"
    CFLAGS="$ac_xbae_save_CFLAGS"
    CPPFLAGS="$ac_xbae_save_CPPFLAGS"
else
    xbae_libraries_result="told not to use it"
    xbae_includes_result="told not to use them"
    XBAE_CFLAGS=""
    XBAE_LIBS=""
fi
AC_MSG_RESULT([libraries $xbae_libraries_result, headers $xbae_includes_result])
AC_SUBST(XBAE_CFLAGS)
AC_SUBST(XBAE_LIBS)
])dnl AC_DEFN

dnl ----------------------------------------------------------------------
dnl
dnl AC_FIND_XLT : find libXlt, and provide variables
dnl	to easily use them in a Makefile.
dnl
dnl Adapted from a macro by Andreas Zeller.
dnl
dnl The variables provided are :
dnl	link_xlt		(e.g. -L/usr/lesstif/lib -lXm)
dnl	include_xlt		(e.g. -I/usr/lesstif/lib)
dnl	xlt_libraries		(e.g. /usr/lesstif/lib)
dnl	xlt_includes		(e.g. /usr/lesstif/include)
dnl
dnl The link_xlt and include_xlt variables should be fit to put on
dnl your application's link line in your Makefile.
dnl
AC_DEFUN(AC_FIND_XLT,
[
AC_REQUIRE([AC_FIND_MOTIF])
AC_REQUIRE([AC_FIND_XPM])
xlt_includes=
xlt_libraries=
AC_ARG_WITH(xlt,
[  --without-xlt         do not use Xlt widgets])
dnl Treat --without-xlt like
dnl --without-xlt-includes --without-xlt-libraries.
if test "$with_xlt" = "no"
then
    xlt_includes=no
    xlt_libraries=no
fi
AC_ARG_WITH(xlt-includes,
    [  --with-xlt-includes=DIR    Xlt include files are in DIR], xlt_includes="$withval")
AC_ARG_WITH(xlt-libraries,
    [  --with-xlt-libraries=DIR   Xlt libraries are in DIR], xlt_libraries="$withval")
if test "$xlt_includes" = "no" && test "$xlt_libraries" = "no"
then
    with_xlt="no"
fi

AC_MSG_CHECKING([for Xlt])
if test "$with_xlt" != "no"
then
    #
    #
    # Search the include files.
    #
    if test "$xlt_includes" = ""
    then
	AC_CACHE_VAL(ac_cv_xlt_includes,
	[
	ac_xlt_save_CFLAGS="$CFLAGS"
	ac_xlt_save_CPPFLAGS="$CPPFLAGS"
	#
	CFLAGS="$MOTIF_CFLAGS $X_CFLAGS $XPM_CFLAGS $CFLAGS"
	CPPFLAGS="$MOTIF_CFLAGS $X_CFLAGS $XPM_CFLAGS $CPPFLAGS"
	#
	AC_TRY_COMPILE([#include <Xlt/Xlt.h>],[int a;],
	[
	# Xlt/Xlt.h is in the standard search path.
	ac_cv_xlt_includes=
	],
	[
	# Xlt/Xlt.h is not in the standard search path.
	# Locate it and put its directory in `xlt_includes'
	#
	# Other directories are just guesses.
	for dir in "$x_includes" "${prefix}/include" /usr/include /usr/local/include \
		   /usr/include/Motif2.0 /usr/include/Motif1.2 /usr/include/Motif1.1 \
		   /usr/include/X11R6 /usr/include/X11R5 /usr/include/X11R4 \
		   /usr/dt/include /usr/openwin/include \
		   /usr/dt/*/include /opt/*/include /usr/include/Xlt* \
		   "${prefix}"/*/include /usr/*/include /usr/local/*/include \
		   "${prefix}"/include/* /usr/include/* /usr/local/include/*
	do
	    if test -f "$dir/Xlt/Xlt.h"
	    then
		ac_cv_xlt_includes="$dir"
		break
	    fi
	done
	])
	#
	CFLAGS="$ac_xlt_save_CFLAGS"
	CPPFLAGS="$ac_xlt_save_CPPFLAGS"
	])
	xlt_includes="$ac_cv_xlt_includes"
    fi

    if test -z "$xlt_includes"
    then
	xlt_includes_result="default path"
	XLT_CFLAGS=""
    else
	if test "$xlt_includes" = "no"
	then
	    xlt_includes_result="told not to use them"
	    XLT_CFLAGS=""
	else
	    xlt_includes_result="$xlt_includes"
	    XLT_CFLAGS="-I$xlt_includes"
	fi
    fi
    #
    #
    # Now for the libraries.
    #
    if test "$xlt_libraries" = ""
    then
	AC_CACHE_VAL(ac_cv_xlt_libraries,
	[
	ac_xlt_save_LIBS="$LIBS"
	ac_xlt_save_CFLAGS="$CFLAGS"
	ac_xlt_save_CPPFLAGS="$CPPFLAGS"
	#
	LIBS="-lXlt $MOTIF_LIBS $X_LIBS $X_PRE_LIBS -lXt $XPM_LIBS -lX11 $X_EXTRA_LIBS $LIBS"
	CFLAGS="$XLT_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $XPM_CFLAGS $CFLAGS"
	CPPFLAGS="$XLT_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $XPM_CFLAGS $CPPFLAGS"
	#
	AC_TRY_LINK([#include <Xlt/Xlt.h>],[Widget w; XltRedirectStdErr(w);],
	[
	# libXlt.a is in the standard search path.
	ac_cv_xlt_libraries=
	],
	[
	# libXlt.a is not in the standard search path.
	# Locate it and put its directory in `xlt_libraries'
	#
	# Other directories are just guesses.
	for dir in "$x_libraries" "${prefix}/lib" /usr/lib /usr/local/lib \
		   /usr/lib/Xlt2.0 /usr/lib/Xlt1.2 /usr/lib/Xlt1.1 \
		   /usr/lib/X11R6 /usr/lib/X11R5 /usr/lib/X11R4 /usr/lib/X11 \
		   /usr/dt/lib /usr/openwin/lib \
		   /usr/dt/*/lib /opt/*/lib /usr/lib/Xlt* \
		   /usr/lesstif*/lib /usr/lib/Lesstif* \
		   "${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
		   "${prefix}"/lib/* /usr/lib/* /usr/local/lib/*; do
	    for ext in "sl" "so" "a"; do
		if test -d "$dir" && test -f "$dir/libXlt.$ext"; then
		    ac_cv_xlt_libraries="$dir"
		    break 2
		fi
	    done
	done
	])
	#
	LIBS="$ac_xlt_save_LIBS"
	CFLAGS="$ac_xlt_save_CFLAGS"
	CPPFLAGS="$ac_xlt_save_CPPFLAGS"
	])
	#
	xlt_libraries="$ac_cv_xlt_libraries"
    fi
    if test -z "$xlt_libraries"
    then
	xlt_libraries_result="default path"
	XLT_LIBS="-lXlt"
    else
	if test "$xlt_libraries" = "no"
	then
	    xlt_libraries_result="told not to use it"
	    XLT_LIBS=""
	else
	    xlt_libraries_result="$xlt_libraries"
	    XLT_LIBS="-L$xlt_libraries -lXlt"
	fi
    fi
#
# Make sure, whatever we found out, we can link.
#
    ac_xlt_save_LIBS="$LIBS"
    ac_xlt_save_CFLAGS="$CFLAGS"
    ac_xlt_save_CPPFLAGS="$CPPFLAGS"
    #
    LIBS="$XLT_LIBS $MOTIF_LIBS $X_LIBS $X_PRE_LIBS -lXt $XPM_LIBS -lX11 $X_EXTRA_LIBS $LIBS"
    CFLAGS="$XLT_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $XPM_CFLAGS $CFLAGS"
    CPPFLAGS="$XLT_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $XPM_CFLAGS $CPPFLAGS"

    AC_TRY_LINK([#include <Xlt/Xlt.h>],[Widget w; XltRedirectStdErr(w);],
	[
	#
	# link passed
	#
	AC_DEFINE(HAVE_XLT)
	],
	[
	#
	# link failed
	#
	xlt_libraries_result="test link failed"
	xlt_includes_result="test link failed"
	with_xlt="no"
	XLT_CFLAGS=""
	XLT_LIBS=""
	]) dnl AC_TRY_LINK

    LIBS="$ac_xlt_save_LIBS"
    CFLAGS="$ac_xlt_save_CFLAGS"
    CPPFLAGS="$ac_xlt_save_CPPFLAGS"
else
    xlt_libraries_result="told not to use it"
    xlt_includes_result="told not to use them"
    XLT_CFLAGS=""
    XLT_LIBS=""
fi
AC_MSG_RESULT([libraries $xlt_libraries_result, headers $xlt_includes_result])
AC_SUBST(XLT_CFLAGS)
AC_SUBST(XLT_LIBS)
])dnl AC_DEFN

dnl ----------------------------------------------------------------------
dnl
dnl AC_FIND_XPM : find libXpm, and provide variables
dnl	to easily use them in a Makefile.
dnl
dnl Adapted from a macro by Andreas Zeller.
dnl
dnl The variables provided are :
dnl	link_xpm		(e.g. -L/usr/lesstif/lib -lXm)
dnl	include_xpm		(e.g. -I/usr/lesstif/lib)
dnl	xpm_libraries		(e.g. /usr/lesstif/lib)
dnl	xpm_includes		(e.g. /usr/lesstif/include)
dnl
dnl The link_xpm and include_xpm variables should be fit to put on
dnl your application's link line in your Makefile.
dnl
AC_DEFUN(AC_FIND_XPM,
[
AC_REQUIRE([AC_PATH_XTRA])
xpm_includes=
xpm_libraries=
AC_ARG_WITH(xpm,
[  --without-xpm         do not use Xpm])
dnl Treat --without-xpm like
dnl --without-xpm-includes --without-xpm-libraries.
if test "$with_xpm" = "no"
then
    xpm_includes=no
    xpm_libraries=no
fi
AC_ARG_WITH(xpm-includes,
    [  --with-xpm-includes=DIR    Xpm include files are in DIR], xpm_includes="$withval")
AC_ARG_WITH(xpm-libraries,
    [  --with-xpm-libraries=DIR   Xpm libraries are in DIR], xpm_libraries="$withval")
if test "$xpm_includes" = "no" && test "$xpm_libraries" = "no"
then
    with_xpm="no"
fi

AC_MSG_CHECKING([for Xpm])
if test "$with_xpm" != "no"
then
    #
    #
    # Search the include files.
    #
    if test "$xpm_includes" = ""
    then
	AC_CACHE_VAL(ac_cv_xpm_includes,
	[
	ac_xpm_save_CFLAGS="$CFLAGS"
	ac_xpm_save_CPPFLAGS="$CPPFLAGS"
	#
	CFLAGS="$X_CFLAGS $CFLAGS"
	CPPFLAGS="$X_CFLAGS $CPPFLAGS"
	#
	AC_TRY_COMPILE([#include <X11/xpm.h>],[int a;],
	[
	# X11/xpm.h is in the standard search path.
	ac_cv_xpm_includes=
	],
	[
	# X11/xpm.h is not in the standard search path.
	# Locate it and put its directory in `xpm_includes'
	#
	# Other directories are just guesses.
	for dir in "$x_includes" "${prefix}/include" /usr/include /usr/local/include \
		   /usr/include/Motif2.0 /usr/include/Motif1.2 /usr/include/Motif1.1 \
		   /usr/include/X11R6 /usr/include/X11R5 /usr/include/X11R4 \
		   /usr/dt/include /usr/openwin/include \
		   /usr/dt/*/include /opt/*/include /usr/include/Xpm* \
		   "${prefix}"/*/include /usr/*/include /usr/local/*/include \
		   "${prefix}"/include/* /usr/include/* /usr/local/include/*
	do
	    if test -f "$dir/X11/xpm.h"
	    then
		ac_cv_xpm_includes="$dir"
		break
	    fi
	done
	])
	#
	CFLAGS="$ac_xpm_save_CFLAGS"
	CPPFLAGS="$ac_xpm_save_CPPFLAGS"
	])
	xpm_includes="$ac_cv_xpm_includes"
    fi

    if test -z "$xpm_includes"
    then
	xpm_includes_result="default path"
	XPM_CFLAGS=""
    else
	if test "$xpm_includes" = "no"
	then
	    xpm_includes_result="told not to use them"
	    XPM_CFLAGS=""
	else
	    xpm_includes_result="$xpm_includes"
	    XPM_CFLAGS="-I$xpm_includes"
	fi
    fi
    #
    #
    # Now for the libraries.
    #
    if test "$xpm_libraries" = ""
    then
	AC_CACHE_VAL(ac_cv_xpm_libraries,
	[
	ac_xpm_save_LIBS="$LIBS"
	ac_xpm_save_CFLAGS="$CFLAGS"
	ac_xpm_save_CPPFLAGS="$CPPFLAGS"
	#
	LIBS="-lXpm $X_LIBS -lX11 $X_EXTRA_LIBS $LIBS"
	CFLAGS="$XPM_CFLAGS $X_CFLAGS $CFLAGS"
	CPPFLAGS="$XPM_CFLAGS $X_CFLAGS $CPPFLAGS"
	#
	AC_TRY_LINK([#include <X11/xpm.h>],[XpmAttributesSize();],
	[
	# libXpm.a is in the standard search path.
	ac_cv_xpm_libraries=
	],
	[
	# libXpm.a is not in the standard search path.
	# Locate it and put its directory in `xpm_libraries'
	#
	# Other directories are just guesses.
	for dir in "$x_libraries" "${prefix}/lib" /usr/lib /usr/local/lib \
		   /usr/lib/Xlt2.0 /usr/lib/Xlt1.2 /usr/lib/Xlt1.1 \
		   /usr/lib/X11R6 /usr/lib/X11R5 /usr/lib/X11R4 /usr/lib/X11 \
		   /usr/dt/lib /usr/openwin/lib \
		   /usr/dt/*/lib /opt/*/lib /usr/lib/Xpm* \
		   /usr/lesstif*/lib /usr/lib/Lesstif* \
		   "${prefix}"/*/lib /usr/*/lib /usr/local/*/lib \
		   "${prefix}"/lib/* /usr/lib/* /usr/local/lib/*; do
	    for ext in "sl" "so" "a"; do
		if test -d "$dir" && test -f "$dir/libXpm.$ext"; then
		    ac_cv_xpm_libraries="$dir"
		    break 2
		fi
	    done
	done
	])
	#
	LIBS="$ac_xpm_save_LIBS"
	CFLAGS="$ac_xpm_save_CFLAGS"
	CPPFLAGS="$ac_xpm_save_CPPFLAGS"
	])
	#
	xpm_libraries="$ac_cv_xpm_libraries"
    fi
    if test -z "$xpm_libraries"
    then
	xpm_libraries_result="default path"
	XPM_LIBS="-lXpm"
    else
	if test "$xpm_libraries" = "no"
	then
	    xpm_libraries_result="told not to use it"
	    XPM_LIBS=""
	else
	    xpm_libraries_result="$xpm_libraries"
	    XPM_LIBS="-L$xpm_libraries -lXpm"
	fi
    fi
#
# Make sure, whatever we found out, we can link.
#
    ac_xpm_save_LIBS="$LIBS"
    ac_xpm_save_CFLAGS="$CFLAGS"
    ac_xpm_save_CPPFLAGS="$CPPFLAGS"
    #
    LIBS="$XPM_LIBS -lXpm $X_LIBS -lX11 $X_EXTRA_LIBS $LIBS"
    CFLAGS="$XPM_CFLAGS $X_CFLAGS $CFLAGS"
    CPPFLAGS="$XPM_CFLAGS $X_CFLAGS $CPPFLAGS"

    AC_TRY_LINK([#include <X11/xpm.h>],[XpmAttributesSize();],
	[
	#
	# link passed
	#
	AC_DEFINE(HAVE_XPM)
	],
	[
	#
	# link failed
	#
	xpm_libraries_result="test link failed"
	xpm_includes_result="test link failed"
	with_xpm="no"
	XPM_CFLAGS=""
	XPM_LIBS=""
	]) dnl AC_TRY_LINK

    LIBS="$ac_xpm_save_LIBS"
    CFLAGS="$ac_xpm_save_CFLAGS"
    CPPFLAGS="$ac_xpm_save_CPPFLAGS"
else
    xpm_libraries_result="told not to use it"
    xpm_includes_result="told not to use them"
    XPM_CFLAGS=""
    XPM_LIBS=""
fi
AC_MSG_RESULT([libraries $xpm_libraries_result, headers $xpm_includes_result])
AC_SUBST(XPM_CFLAGS)
AC_SUBST(XPM_LIBS)
])dnl AC_DEFN


dnl ----------------------------------------------------------------------
dnl From Jim Meyering.
dnl FIXME: migrate into libit.
dnl
AC_DEFUN(AM_FUNC_OBSTACK,
[AC_CACHE_CHECK([for obstacks], am_cv_func_obstack,
 [AC_TRY_LINK([#include "obstack.h"],
	      [struct obstack *mem;obstack_free(mem,(char *) 0)],
	      am_cv_func_obstack=yes,
	      am_cv_func_obstack=no)])
 if test $am_cv_func_obstack = yes; then
   AC_DEFINE(HAVE_OBSTACK,1,[Define if libc includes obstacks])
 else
   LIBOBJS="$LIBOBJS obstack.o"
 fi
])




dnl ----------------------------------------------------------------------
dnl
AC_DEFUN(XASTIR_CHECK_MOTIF,
[
dnl There are cases where motif may be installed on a system, but X may not
dnl be (Default on hppa1.1-hp-hpux10.20) therefore this must all be wrapped
if test "$no_x" = ""; then
 dnl
 dnl Motif (LessTif)
 dnl
 AC_ARG_WITH(motif,
 [  --without-motif		  Do not use Motif, even if detected],
 [		case "${withval}" in
 		  y | ye | yes )	usemotif=yes ;;
 		  n | no )		usemotif=no ;;
 		  * )			usemotif=yes ;;
 		esac],
 [		with_motif=yes])

 dnl
 dnl If you ask not to have Xbae then you can't have Motif either.
 dnl And the other way around.
 dnl
 dnl To make sure people know about this, we'll be harsh and abort.
 dnl
 if test "$with_Xbae" = "no" -a "$with_motif" = "yes" ; then
 	AC_MSG_ERROR(Cannot build Motif/LessTif interface without Xbae)
 fi
 if test "$with_Xbae" = "yes" -a "$with_motif" = "no" ; then
 	AC_MSG_ERROR(Cannot use Xbae without Motif/LessTif)
 fi

 dnl
 dnl Just in case I misunderstood something - make sure nothing slips through.
 dnl
 test "$with_Xbae" = "no" && with_motif="no"
 test "$with_motif" = "no" && with_Xbae="no"

 dnl
 dnl Checks for Motif
 dnl These should not happen if --without-motif has been used.
 dnl
 dnl if test "$with_motif" = "yes"; then
   AC_FIND_MOTIF
   AC_FIND_XBAE
   AC_FIND_XLT
     CFLAGS="$XLT_CFLAGS $MOTIF_CFLAGS $X_CFLAGS $CFLAGS"
     LIBS="$XLT_LIBS $MOTIF_LIBS $X_LIBS $X_PRE_LIBS -lXt -lX11 -lXext $X_EXTRA_LIBS $LIBS"
   AC_CHECK_LIB(Xpm, main)
 dnl fi
fi dnl "$no_x" = "yes"

])dnl

dnl ======================================================================
dnl
AC_DEFUN(XASTIR_MISC_TESTS,
[
   AC_LANG_C
   dnl Checks for libraries.
   AC_CHECK_LIB(compat, main, [LIBCOMPAT="-lcompat"]) dnl for FreeBSD
   AC_SUBST(LIBCOMPAT)
   xastir_have_crypt=
   AC_CHECK_LIB(crypt, crypt, [LIBCRYPT="-lcrypt"; xastir_have_crypt=yes],
      AC_CHECK_LIB(c, crypt, [xastir_have_crypt=yes], [
        AC_MSG_WARN([you have no crypt in either libcrypt or libc.
You should install libcrypt from another source or configure with PAM
support])
	xastir_have_crypt=no
      ]))
   AC_SUBST(LIBCRYPT)
   if test $xastir_have_crypt = yes; then
      AC_DEFINE_UNQUOTED(HAVE_CRYPT, 1, [Defines if your system has the crypt function])
   fi
   AC_CHECK_KSIZE_T
   AC_LANG_C
   AC_CHECK_LIB(dnet, dnet_ntoa, [X_EXTRA_LIBS="$X_EXTRA_LIBS -ldnet"])
   if test $ac_cv_lib_dnet_dnet_ntoa = no; then
      AC_CHECK_LIB(dnet_stub, dnet_ntoa,
        [X_EXTRA_LIBS="$X_EXTRA_LIBS -ldnet_stub"])
   fi
   AC_CHECK_FUNC(inet_ntoa)
   if test $ac_cv_func_inet_ntoa = no; then
     AC_CHECK_LIB(nsl, inet_ntoa, X_EXTRA_LIBS="$X_EXTRA_LIBS -lnsl")
   fi
   AC_CHECK_FUNC(connect)
   if test $ac_cv_func_connect = no; then
      AC_CHECK_LIB(socket, connect, X_EXTRA_LIBS="-lsocket $X_EXTRA_LIBS", ,
        $X_EXTRA_LIBS)
   fi

   AC_CHECK_FUNC(remove)
   if test $ac_cv_func_remove = no; then
      AC_CHECK_LIB(posix, remove, X_EXTRA_LIBS="$X_EXTRA_LIBS -lposix")
   fi

   # BSDI BSD/OS 2.1 needs -lipc for XOpenDisplay.
   AC_CHECK_FUNC(shmat)
   if test $ac_cv_func_shmat = no; then
     AC_CHECK_LIB(ipc, shmat, X_EXTRA_LIBS="$X_EXTRA_LIBS -lipc")
   fi

   LIBSOCKET="$X_EXTRA_LIBS"
   AC_SUBST(LIBSOCKET)
   AC_SUBST(X_EXTRA_LIBS)
   AC_CHECK_LIB(ucb, killpg, [LIBUCB="-lucb"]) dnl for Solaris2.4
   AC_SUBST(LIBUCB)

   case $host in  dnl this *is* LynxOS specific
   *-*-lynxos* )
        AC_MSG_CHECKING([LynxOS header file wrappers])
        [CFLAGS="$CFLAGS -D__NO_INCLUDE_WARN__"]
        AC_MSG_RESULT(disabled)
        AC_CHECK_LIB(bsd, gethostbyname, [LIBSOCKET="-lbsd"]) dnl for LynxOS
         ;;
   *-*-*bsd* )
        AC_MSG_CHECKING([*BSD specific headers])
        [LIBS="$LIBS -lc_r"]
        AC_MSG_RESULT(ok)
        ;;
    esac

   XASTIR_CHECK_TYPES
   XASTIR_CHECK_LIBDL
# AC_CHECK_BOOL
])


dnl ======================================================================
dnl
AC_DEFUN(XASTIR_CHECK_LIBDL,
[
AC_CHECK_LIB(dl, dlopen, [
LIBDL="-ldl"
ac_cv_have_dlfcn=yes
])

AC_CHECK_LIB(dld, shl_unload, [
LIBDL="-ldld"
ac_cv_have_shload=yes
])

AC_SUBST(LIBDL)
])


dnl ======================================================================
dnl Check for the type of the third argument of getsockname
AC_DEFUN(AC_CHECK_KSIZE_T,
[AC_MSG_CHECKING(for the third argument of getsockname)
AC_CACHE_VAL(ac_cv_ksize_t,
# AC_LANG_SAVE
# AC_LANG_CPLUSPLUS
[AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/socket.h>
],[
socklen_t a=0;
getsockname(0,(struct sockaddr*)0, &a);
],
ac_cv_ksize_t=socklen_t,
ac_cv_ksize_t=)
if test -z "$ac_cv_ksize_t"; then
ac_safe_cxxflags="$CXXFLAGS"
if test "$GCC" = "yes"; then
  CXXFLAGS="-Werror $CXXFLAGS"
fi
AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/socket.h>
],[
int a=0;
getsockname(0,(struct sockaddr*)0, &a);
],
ac_cv_ksize_t=int,
ac_cv_ksize_t=size_t)
CXXFLAGS="$ac_safe_cxxflags"
fi
# AC_LANG_RESTORE
])

if test -z "$ac_cv_ksize_t"; then
  ac_cv_ksize_t=int
fi

AC_MSG_RESULT($ac_cv_ksize_t)
AC_DEFINE_UNQUOTED(ksize_t, $ac_cv_ksize_t,
      [Define the type of the third argument for getsockname]
)

])


dnl ======================================================================
dnl
AC_DEFUN(XASTIR_CHECK_TYPES,
[  AC_CHECK_SIZEOF(int, 4)dnl
  AC_CHECK_SIZEOF(long, 4)dnl
  AC_CHECK_SIZEOF(char *, 4)dnl
])dnl

dnl ======================================================================
dnl
AC_DEFUN(XASTIR_CHECK_LIBPTHREAD,
[
AC_CHECK_LIB(pthread, pthread_create, [LIBPTHREAD="-lpthread"] )
AC_SUBST(LIBPTHREAD)
])


dnl ======================================================================
# AC_CHECK_LIBM - check for math library
AC_DEFUN(AC_CHECK_LIBM,
[AC_REQUIRE([AC_CANONICAL_HOST])dnl
LIBM=
case "$host" in
*-*-beos* | *-*-cygwin*)
  # These system don't have libm
  ;;
*-ncr-sysv4.3*)
  AC_CHECK_LIB(mw, _mwvalidcheckl, LIBM="-lmw")
  AC_CHECK_LIB(m, main, LIBM="$LIBM -lm")
  ;;
*)
  AC_CHECK_LIB(m, main, LIBM="-lm")
  ;;
esac
  LIBS=$LIBM
])


# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

# Add --enable-maintainer-mode option to configure.
# From Jim Meyering

# serial 1

AC_DEFUN(AM_MAINTAINER_MODE,
[AC_MSG_CHECKING([whether to enable maintainer-specific portions of Makefiles])
  dnl maintainer-mode is disabled by default
  AC_ARG_ENABLE(maintainer-mode,
[  --enable-maintainer-mode enable make rules and dependencies not useful
                          (and sometimes confusing) to the casual installer],
      USE_MAINTAINER_MODE=$enableval,
      USE_MAINTAINER_MODE=no)
  AC_MSG_RESULT($USE_MAINTAINER_MODE)
  AM_CONDITIONAL(MAINTAINER_MODE, test $USE_MAINTAINER_MODE = yes)
  MAINT=$MAINTAINER_MODE_TRUE
  AC_SUBST(MAINT)dnl
]
)

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

