/*
 * $Id: hostname.c,v 1.10 2001/05/01 14:33:43 kg4ijb Exp $
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000,2001  The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <Xm/XmAll.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include <signal.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <setjmp.h>
#include <netinet/in.h>
#include <sys/wait.h>

#include "xastir.h"
#include "main.h"
#include "lang.h"


#ifndef __LCLINT__
static  sigjmp_buf ret_place;       /* Jump address if alarm */
#endif // __LCLINT__


/*************************************************************************/
/* Time out on connect                                                   */
/* In case there is a problem in getting the hostname or connecting      */
/* (see  setjmp below).                                                  */
/*************************************************************************/

static void host_time_out( /*@unused@*/ int sig) {
#ifndef __LCLINT__
    siglongjmp(ret_place,0);
#endif // __LCLINT__
}


/*************************************************************************/
/* do a nice host lookup (don't thread!!)                                */
/*                                                                       */
/* host: name to lookup                                                  */
/* ip: buffer for ip's must be 400 bytes at least                        */
/* time: time in seconds to wait                                         */
/*                                                                       */
/* return the ip or ip's of the host name                                */
/* or these strings:                                                     */
/* NOHOST  for no host by that name found                                */
/* NOIP    for host found but no ip address available                    */
/* TIMEOUT for time execeded                                             */
/*************************************************************************/

char *host_lookup(char *host, char *ip, int time) {
    /*struct sockaddr_in address;*/
    char **names, **addrs;
    static struct hostent *hostinfo;
    void *previous_loc;
    pid_t host_pid;
    int status;
    char ip_addr[400];
    char temp[40];
    int fp[2];
    char buf[401];
    int ip_found;
    int first;
    int tm;
    int ips;
    int i;
    char ttemp[60];
    int wait_host;

    if (debug_level & 256)
        printf("Start Host lookup\n");

    memset(ip_addr,(int)'\0',sizeof(ip_addr));
    memset(buf,(int)'\0',sizeof(buf));

    busy_cursor(appshell);

    if (pipe(fp)==0) {
        host_pid = fork();

        if (debug_level & 256)
            printf("Host fork\n");

        if (host_pid!=-1) {
            if (host_pid==0) {
                if (debug_level & 256)
                    printf("Set alarm \n");

                previous_loc = signal(SIGALRM, host_time_out);

                if (sigsetjmp(ret_place,-1)!=0) {
                    (void)alarm(0);
                    (void)signal(SIGALRM, previous_loc);
                    /* return  net connection time out */
                    (void)write(fp[1],"TIMEOUT",sizeof(buf)-1);
                    exit(EXIT_FAILURE);
                }
                (void)alarm(time);

                /*hostinfo = gethostbyname2(host,AF_INET); some systems don't have this*/
                hostinfo = gethostbyname(host);

                if (hostinfo) {
                    names = hostinfo -> h_aliases;
                    ip_found=0;

                    /* look at all names */
                    ips=0;
                    first=0;
                    if (!*names)
                        first=1;

                    while (*names || first) {
                        if (hostinfo -> h_addrtype == AF_INET) {
                            ip_found=1;
                            addrs = hostinfo -> h_addr_list;
                            while (*addrs) {
                                sprintf(temp,"%s",inet_ntoa(*(struct in_addr *)*addrs));
                                if (debug_level & 256)
                                    printf("IP [%s]\n",temp);

                                if (strlen(temp)>7) {
                                    /* IP found */
                                    if((strlen(ip_addr)+strlen(temp))<sizeof(ip_addr)) {
                                        if (ips>0)
                                            strcat(ip_addr," ");

                                        strcat(ip_addr,temp);
                                        ips++;
                                    }
                                }
                                addrs++;
                            }
                        }
                        if (first) {
                            *names=NULL;
                            first=0;
                        } else
                            names++;
                    }
                    if (ip_found==0) {
                        /* Host not found */
                        strcpy(ip_addr,"NOIP");

                        if (debug_level & 256)
                            printf("Host NO IP");

                    }
                } else {
                    /* Host not found */
                    strcpy(ip_addr,"NOHOST");

                    if (debug_level & 256)
                        printf("NO HOST\n");

                }
                if (debug_level & 256)
                    printf("Clear alarm 1\n");

                (void)alarm(0);
                (void)signal(SIGALRM,previous_loc);

                if (debug_level & 256)
                    printf("Clear alarm 2\n");

                (void)write(fp[1],ip_addr,sizeof(buf)-1);
                exit(EXIT_FAILURE);
            } else {
                /* parent */
                tm=1;
                wait_host=1;
                while (wait_host!=-1) {
                    sprintf(ttemp,langcode("BBARSTA031"),tm++);
                    statusline(ttemp,1);        // Looking up hostname...

                    for (i=0; i < 60 && wait_host!=-1; i++) {
                        wait_host=waitpid(host_pid,&status,WNOHANG);
                        /* update display while waiting */
                        XmUpdateDisplay(XtParent(da));
                        //usleep(500);
                        sched_yield();
                    }
                }
                (void)read(fp[0],buf,sizeof(buf)-1);
                strcpy(ip,buf);
            }
        }
    }
    return(ip);
}

