/*
 * $Id: igate.c,v 1.9 2001/05/01 14:33:43 kg4ijb Exp $
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000,2001  The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <termios.h>
#include <pthread.h>
#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <Xm/XmAll.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>

#include "igate.h"
#include "main.h"
#include "xastir.h"
#include "interface.h"
#include "xa_config.h"
#include "util.h"


time_t last_nws_stations_file_time = 0;
int NWS_stations = 0;
int max_NWS_stations = 0;
NWS_Data *NWS_station_data;


/****************************************************************/
/* ouptut data to inet interfaces                               */
/* line: data to send out                                       */
/* port: port data came from                                    */
/****************************************************************/
void output_igate_net(char *line, int port, int third_party) {
    char data_txt[MAX_LINE_SIZE+5];
    char temp[MAX_LINE_SIZE+5];
    char *call_sign;
    char *path;
    char *message;
    int len,i,x;

    call_sign=NULL;
    path=NULL;
    message=NULL;

    /* should we output as an Igate?  */
    if (operate_as_an_igate>0) {
        /* log traffic */
        if (log_igate) {
            sprintf(temp,"IGATE RF->NET(%c):%s",third_party ? 'T':'N',line);
            log_data(LOGFILE_IGATE,temp);
        }

        strcpy(temp,line);
        call_sign=strtok(temp,">");
        if (call_sign!=NULL) {
            path=strtok(NULL,":");
            if (path!=NULL) {
                message=strtok(NULL,"");
                if (message !=NULL) {
                    /* Check if we need to skip third party messages */
                    if (message[0]!='}') {
                        len=(int)strlen(call_sign);
                        for (i=0;i<len;i++) {
                            /* just incase we see a star get rid of it */
                            if (call_sign[i]=='*') {
                                call_sign[i]='\0';
                                i=len+1;
                            }
                        }
                        if (strcmp(call_sign,my_callsign)!=0) {
                            /* OK should I filter out more here.. get rid of all data */
                            /* or Look in the path for things line "AP" "GPS" "ID" etc..? */

                            if (devices[port].igate_options>0) {
                                sprintf(data_txt,"%s%c%c",line,'\r','\n');

                                /* write data out to net interfaces */
                                for (x=0; x<MAX_IFACE_DEVICES;x++) {
                                    if (port_data[x].device_type==DEVICE_NET_STREAM && x!=port && port_data[x].status==DEVICE_UP) {
                                        sprintf(temp,"Transmit IGate RF-NET packet on device:%d\n",x);

                                        /* log output */
                                        if (log_igate)
                                            log_data(LOGFILE_IGATE,temp);

                                        if (debug_level & 2)
                                            printf(temp);

                                        /* ok write this data out to the Inet port */
                                        output_my_data(data_txt,x,1);
                                    }
                                }
                            } else {
                                sprintf(temp,"REJECT No RF to Net from input port [%d]\n",port);
                                if (log_igate)
                                    log_data(LOGFILE_IGATE,temp);

                                if (debug_level & 2)
                                    printf(temp);
                            }
                        } else {
                            sprintf(temp,"REJECT from my call\n");
                            if (log_igate)
                                log_data(LOGFILE_IGATE,temp);

                            if (debug_level & 2)
                                printf(temp);
                        }
                    } else {
                        sprintf(temp,"REJECT Third party traffic\n");
                        if (log_igate)
                            log_data(LOGFILE_IGATE,temp);

                        if (debug_level & 2)
                            printf(temp);

                    }
                }
            }
        }
    }
}


/****************************************************************/
/* ouptut data to tnc interfaces                                */
/* from: type of port heard from                                */
/* call: call sign heard fro                                    */
/* line: data to gate to rf                                     */
/* port: port data came from                                    */
/****************************************************************/
void output_igate_rf(char *from, char *call, char *path, char *line, int port, int third_party) {
    char temp[MAX_LINE_SIZE+20];
    int x;

    /* should we output as an Igate?  */
    if (operate_as_an_igate>1) {
        /* log traffic */
        if (log_igate) {
            sprintf(temp,"IGATE NET->RF(%c):%s",third_party ? 'T':'N',line);
            log_data(LOGFILE_IGATE,temp);
        }

        /* check for TCPXX* in string! */
        if (strstr(path,"TCPXX*")==NULL) {
            /* no unregistered net user found in string */
            if (heard_via_tnc_in_past_hour(call)==1 && !heard_via_tnc_in_past_hour(from)) {
                /* station we are going to is heard via tnc but station sending shouldn't be heard via TNC */
                /* write data out to interfaces */
                for (x=0; x<MAX_IFACE_DEVICES;x++) {
                    if (x!=port) {
                        switch (port_data[x].device_type) {
                            case DEVICE_SERIAL_TNC_HSP_GPS:

                            case DEVICE_SERIAL_TNC:

                            case DEVICE_AX25_TNC:
                                if (devices[x].igate_options>1 && port_data[x].status==DEVICE_UP) {
                                    sprintf(temp,"Transmit IGate NET->RF packet on device:%d",x);

                                    /* log output */
                                    if (log_igate)
                                        log_data(LOGFILE_IGATE,temp);

                                    if (debug_level & 2)
                                        printf(temp);

                                    /* ok write this data out to the RF port */
                                    output_my_data(line,x,0);
                                } else {
                                    sprintf(temp,"REJECT Inet-> RF on port [%d]\n",x);
                                    if (log_igate)
                                        log_data(LOGFILE_IGATE,temp);

                                    if (debug_level & 2)
                                        printf(temp);
                                }
                                break;

                            default:
                                break;
                        }
                    }
                }
            } else {
                sprintf(temp,"REJECT (NOT IN DATABASE, not heard on TNC in an hour, or RF to RF talk)\n");
                if (log_igate)
                    log_data(LOGFILE_IGATE,temp);

                if (debug_level & 2)
                    printf(temp);
            }
        } else {
            sprintf(temp,"REJECT unregistered net user!\n");
            if (log_igate)
                log_data(LOGFILE_IGATE,temp);

            if (debug_level & 2)
                printf(temp);
        }
    }
}


void add_NWS_stations(void) {
    void *tmp_ptr;

    if (NWS_stations>=max_NWS_stations) {
        if ((tmp_ptr = realloc(NWS_station_data, sizeof(NWS_Data)*(max_NWS_stations+11)))) {
            NWS_station_data = tmp_ptr;
            max_NWS_stations += 10;
        }
    }
}

/****************************************************************/
/* Load NWS stations file                                       */
/* file: file to read                                           */
/****************************************************************/
void load_NWS_stations(char *file) {
    FILE *f;
    char line[40];

    f = fopen(file,"r");
    if (f!=NULL) {
        while (!feof(f)) {
            if (strlen(get_line(f,line,39))>0) {
                /* look for comment */
                if (line[0] != '#' ) {
                    NWS_stations++;
                    add_NWS_stations();
                    if (NWS_station_data != NULL) {
                        /* add data */
                        (void)sscanf(line,"%s",NWS_station_data[NWS_stations-1].call);
                        printf("LINE:%s\n",line);
                    } else {
                        printf("Can't allocate data space for NWS station\n");
                    }
                }
            }
        }
        (void)fclose(f);
    }
    else
        printf("Couldn't open NWS stations file: %s\n", file);
}

/****************************************************************/
/* check NWS stations file                                      */
/* call: call to check                                          */
/* returns 1 for found                                          */
/****************************************************************/
int check_NWS_stations(char *call) {
    int ok,i;

    ok=0;
    for (i=0; i<NWS_stations && !ok; i++) {
        if (strcasecmp(call,NWS_station_data[i].call)==0) {
            ok=1; /* match found */
            //printf("NWS-MATCH:(%s) (%s)\n",NWS_station_data[i].call,call);
        }
    }
    return(ok);
}

/****************************************************************/
/* output NWS data to tnc interfaces                            */
/* from: type of port heard from                                */
/* call: call sign heard fro                                    */
/* line: data to gate to rf                                     */
/* port: port data came from                                    */
/****************************************************************/
void output_nws_igate_rf(char *from, char *path, char *line, int port, int third_party) {
    char temp[MAX_LINE_SIZE+20];
    int x;

    /* should we output as an Igate?  */
    if (operate_as_an_igate>1) {
        /* log traffic */
        if (log_igate) {
            sprintf(temp,"NWS IGATE NET->RF(%c):%s",third_party ? 'T':'N',line);
            log_data(LOGFILE_IGATE,temp);
        }

        /* check for TCPXX* in string! */
        if (strstr(path,"TCPXX*")==NULL) {
            /* no unregistered net user found in string */
            /* see if we can gate NWS messages */
            if (filethere(get_user_base_dir("data/nws-stations.txt"))) {
                /* check to see if the nws-stations file is newer than last read */
                if (last_nws_stations_file_time < file_time(get_user_base_dir("data/nws-stations.txt"))) {
                    last_nws_stations_file_time = file_time(get_user_base_dir("data/nws-stations.txt"));
                    load_NWS_stations(get_user_base_dir("data/nws-stations.txt"));
                    //printf("NWS Station file time is old\n");
                }
                if (check_NWS_stations(from)){
                    //printf("SENDING NWS VIA TNC!!!!\n");
                    /* write data out to interfaces */
                    for (x=0; x<MAX_IFACE_DEVICES;x++) {
                        if (x!=port) {
                            switch (port_data[x].device_type) {
                                case DEVICE_SERIAL_TNC_HSP_GPS:

                                case DEVICE_SERIAL_TNC:

                                case DEVICE_AX25_TNC:
                                    if (devices[x].igate_options>1 && port_data[x].status==DEVICE_UP) {
                                        sprintf(temp,"Transmit IGate NET->RF packet on device:%d",x);
                                        /* log output */
                                        if (log_igate)
                                            log_data(LOGFILE_IGATE,temp);

                                        if (debug_level & 2)
                                            printf(temp);

                                        /* ok write this data out to the RF port */
                                        output_my_data(line,x,0);
                                    } else {
                                        sprintf(temp,"REJECT Inet-> RF on port [%d]\n",x);
                                        if (log_igate)
                                            log_data(LOGFILE_IGATE,temp);

                                        if (debug_level & 2)
                                            printf(temp);
                                    }
                                    break;

                                default:
                                    break;
                            }
                        }
                    }
                } else { /* end check for NWS station */
                    sprintf(temp,"REJECT no matching station in the nws-stations.txt file!\n");
                    if (log_igate)
                        log_data(LOGFILE_IGATE,temp);

                    if (debug_level & 2)
                        printf(temp);
                }
            } else { /* end check for NWS file check */
                sprintf(temp,"REJECT no nws-stations.txt file!\n");
                if (log_igate)
                    log_data(LOGFILE_IGATE,temp);

                if (debug_level & 2)
                    printf(temp);
            }
        } else {
            sprintf(temp,"REJECT unregistered net user!\n");
            if (log_igate)
                log_data(LOGFILE_IGATE,temp);

            if (debug_level & 2)
                printf(temp);
        }
    }
}

