/*
 * $Id: main.c,v 1.106 2001/05/01 14:33:44 kg4ijb Exp $
 *
 * XASTIR, Amateur Station Tracking and Information Reporting
 * Copyright (C) 1999,2000  Frank Giannandrea
 * Copyright (C) 2000,2001  The Xastir Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Look at the README for more information on the program.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <ctype.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <unistd.h>
#include <dirent.h>
#include <signal.h>
#include <termios.h>
#include <pwd.h>
#include <pthread.h>
#include <locale.h>

#ifdef USE_IMAGEMAGICK
#include <time.h>
#include <sys/types.h>
#include <magick/api.h>
#endif

#ifdef  HAVE_LIBINTL_H
#include <libintl.h>
#define _(x)        gettext(x)
#else
#define _(x)        (x)
#endif

#include "xastir.h"
#include "draw_symbols.h"
#include "main.h"
#include "xa_config.h"
#include "maps.h"
#include "alert.h"
#include "db.h"
#include "interface.h"
#include "wx.h"
#include "popup.h"
#include "track_gui.h"
#include "list_gui.h"
#include "util.h"
#include "color.h"
#include "gps.h"
#include "bulletin_gui.h"


#include <Xm/XmAll.h>

#include <X11/cursorfont.h>


#define DOS_HDR_LINES 8

#define GRID_MORE 513

#define STATUSLINE_ACTIVE 10            /* status line is cleared after 10 seconds */
#define REDRAW_PAUSE       2            /* delay between concecutive redraws in seconds (file load) */

#define XmFONTLIST_DEFAULT_MY "fixed"

#define LINE_WIDTH 1

//#define DEBUG_TEST 1

#define ARROWS     1

FILE *file_wx_test;

int dtr_on=1;

/* language in use */
char lang_to_use[30];

/* version info in main.h */
int altnet;
char altnet_call[MAX_CALL];

void da_input(Widget w, XtPointer client_data, XtPointer call_data);
void da_resize(Widget w, XtPointer client_data, XtPointer call_data);
void da_expose(Widget w, XtPointer client_data, XtPointer call_data);

int debug_level;

//Widget hidden_shell = (Widget) NULL;
Widget appshell = (Widget) NULL;
Widget form = (Widget) NULL;
Widget da = (Widget) NULL;
Widget text;
Widget text2;
Widget text3;
Widget text4;
Widget iface_da;
Widget menubar;

Widget help_index_dialog            = (Widget)NULL;
Widget help_view_dialog             = (Widget)NULL;
Widget map_chooser_dialog           = (Widget)NULL;
Widget configure_station_dialog     = (Widget)NULL;
Widget configure_audio_alarm_dialog = (Widget)NULL;
Widget configure_speech_dialog      = (Widget)NULL;
Widget object_dialog                = (Widget)NULL;
Widget left_menu_popup              = (Widget)NULL;    // Button one or left mouse button
//Widget middle_menu_popup=(Widget)NULL;  // Button two or middle mouse button
//Widget right_menu_popup=(Widget)NULL;   // Button three or right mouse button


int Station_transmit_type;
int Igate_type;

Widget Display_data_dialog  = (Widget)NULL;
Widget Display_data_text;
int Display_packet_data_type;


Widget configure_defaults_dialog = (Widget)NULL;
int old_station_item;
int clear_station_item;

/* help index */
Widget help_list;

Widget grid_on, grid_off;
Widget map_auto_on, map_auto_off;
Widget map_levels_on, map_levels_off;
Widget map_fill_on, map_fill_off;
Widget map_bgcolor[11];

#ifdef USE_GEOTIFF
Widget map_intensity[11];
#endif /* USE_GEOTIFF */

Widget map_station_label0,map_station_label1;
Widget map_wx_alerts_0,map_wx_alerts_1;
Widget tnc_logging_on, tnc_logging_off;
Widget net_logging_on, net_logging_off;
Widget igate_logging_on, igate_logging_off;
Widget wx_logging_on, wx_logging_off;
Widget alt_on, alt_off;
Widget call_on, call_off;
Widget trails_on, trails_off;
Widget phg_on, phg_off;
Widget wx_on, wx_off;
Widget symbols_on, symbols_off;
Widget symrot_on, symrot_off;
Widget course_on, course_off;
Widget speed_on, speed_off;
Widget dist_course_on, dist_course_off;
Widget units_choice_on, units_choice_off;
Widget read_selection_dialog = (Widget)NULL;

// config station values
Widget station_config_call_data, station_config_slat_data_deg, station_config_slat_data_min,
       station_config_slat_data_ns, station_config_slong_data_deg, station_config_slong_data_min,
       station_config_slong_data_ew, station_config_group_data, station_config_symbol_data,
       station_config_icon, station_config_comment_data, station_config_power_data,
       station_config_height_data, station_config_gain_data, station_config_direction_data;
Pixmap CS_icon0, CS_icon;

// object dialog values
Widget object_name_data,
       object_lat_data_deg, object_lat_data_min, object_lat_data_ns, 
       object_lon_data_deg, object_lon_data_min, object_lon_data_ew,
       object_group_data, object_symbol_data, object_icon, 
       object_comment_data;
Pixmap Ob_icon0, Ob_icon;

/* defaults*/
Widget raw_wx_tx;
Widget compressed_posit_tx;
Widget altnet_active;
Widget altnet_text;

/* config audio alarm values */
Widget audio_alarm_config_play_data,
       audio_alarm_config_play_on_new_station, audio_alarm_config_play_ons_data,
       audio_alarm_config_play_on_new_message, audio_alarm_config_play_onm_data,
       audio_alarm_config_play_on_prox, audio_alarm_config_play_onpx_data,
       audio_alarm_config_play_on_bando, audio_alarm_config_play_onbo_data,
       prox_min_data, prox_max_data, bando_min_data, bando_max_data,
       audio_alarm_config_play_on_wx_alert, audio_alarm_config_wx_alert_data;

/* config speech values */
Widget speech_config_play_on_new_station,
       speech_config_play_on_new_message_alert,
       speech_config_play_on_new_message_body,
       speech_config_play_on_prox,
       speech_config_play_on_bando,
       speech_config_play_on_new_wx_alert;

/* map chooser */
Widget map_list;

static void UpdateTime( XtPointer clientData, XtIntervalId id );
void pos_dialog(Widget w);

static void Zoom_in(Widget w, XtPointer clientData, XtPointer calldata);
static void Zoom_in_no_pan(Widget w, XtPointer clientData, XtPointer calldata);
static void Zoom_out(Widget w, XtPointer clientData, XtPointer calldata);
static void Zoom_out_no_pan(Widget w, XtPointer clientData, XtPointer calldata);
static void Zoom_level(Widget w, XtPointer clientData, XtPointer calldata);

static void Pan_ctr(Widget w, XtPointer clientData, XtPointer calldata);
static void Pan_up(Widget w, XtPointer clientData, XtPointer calldata);
static void Pan_down(Widget w, XtPointer clientData, XtPointer calldata);
static void Pan_left(Widget w, XtPointer clientData, XtPointer calldata);
static void Pan_right(Widget w, XtPointer clientData, XtPointer calldata);

static void Set_Del_Object(Widget w, XtPointer clientData, XtPointer calldata);

static void Menu_Quit(Widget w, XtPointer clientData, XtPointer calldata);

static void Grid_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Grid_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Map_auto_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Map_auto_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Map_levels_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Map_levels_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Map_fill_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Map_fill_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Map_background(Widget w, XtPointer clientData, XtPointer calldata);

#ifdef USE_GEOTIFF
static void Map_intensity(Widget w, XtPointer clientData, XtPointer calldata);
#endif /* USE_GEOTIFF */

static void Map_station_label(Widget w, XtPointer clientData, XtPointer calldata);
static void Map_wx_alerts(Widget w, XtPointer clientData, XtPointer calldata);

static void TNC_Logging_on(Widget w, XtPointer clientData, XtPointer calldata);
static void TNC_Logging_off(Widget w, XtPointer clientData, XtPointer calldata);
static void TNC_Transmit_now(Widget w, XtPointer clientData, XtPointer calldata);

static void Net_Logging_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Net_Logging_off(Widget w, XtPointer clientData, XtPointer calldata);

static void IGate_Logging_on(Widget w, XtPointer clientData, XtPointer calldata);
static void IGate_Logging_off(Widget w, XtPointer clientData, XtPointer calldata);

static void WX_Logging_on(Widget w, XtPointer clientData, XtPointer calldata);
static void WX_Logging_off(Widget w, XtPointer clientData, XtPointer calldata);

void on_off_switch(int switchpos, Widget first, Widget second);

static void Call_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Call_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Alt_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Alt_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Course_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Course_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Speed_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Speed_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Dist_course_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Dist_course_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Units_choice_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Units_choice_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Station_trails_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Station_trails_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Station_phg_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Station_phg_off(Widget w, XtPointer clientData, XtPointer calldata);

static void WX_on(Widget w, XtPointer clientData, XtPointer calldata);
static void WX_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Symbols_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Symbols_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Sym_rot_on(Widget w, XtPointer clientData, XtPointer calldata);
static void Sym_rot_off(Widget w, XtPointer clientData, XtPointer calldata);

static void Help_About(Widget w, XtPointer clientData, XtPointer callData);
static void Help_Index(Widget w, XtPointer clientData, XtPointer callData);

static void Map_chooser(Widget w, XtPointer clientData, XtPointer callData);

static void Configure_station(Widget w, XtPointer clientData, XtPointer callData);

static void Configure_audio_alarms(Widget w, XtPointer clientData, XtPointer callData);

static void Configure_speech(Widget w, XtPointer clientData, XtPointer callData);

static void Configure_defaults(Widget w, XtPointer clientData, XtPointer callData);

static void Stations_Clear(Widget w, XtPointer clientData, XtPointer callData);

#if DEBUG_TEST
static void Test(Widget w, XtPointer clientData, XtPointer callData);
#endif // DEBUG_TEST

static void Save_Config(Widget w, XtPointer clientData, XtPointer callData);

static void Read_File_Selection(Widget w, XtPointer clientData, XtPointer callData);

static void Display_data(Widget w, XtPointer clientData, XtPointer callData);

/* GLOBAL DEFINES */
GC gc=0;            // Used for drawing maps
GC gc2=0;           // Used for drawing symbols
GC gc_tint=0;           // Used for tinting maps
Pixmap  pixmap;
Pixmap  pixmap_alerts;
Pixmap  pixmap_final;
XastirGlobal Global;

char *database_ptr;             /* database pointers */

long mid_x_long_offset;         // Longitude at center of map
long mid_y_lat_offset;          // Latitude  at center of map
long new_mid_x, new_mid_y;      // Check values used before applying real change
long x_long_offset;             // Longitude at top NW corner of map screen
long y_lat_offset;              // Latitude  at top NW corner of map screen
long size;                      // Size or zoom (in 1/100 sec per pixel)
long new_size;                  // Check value used before real change
long screen_width;              // Screen width,  map area without border (in pixel)
long screen_height;             // Screen height, map area without border (in pixel)
float d_screen_distance;        /* Diag screen distance */
float x_screen_distance;        /* x screen distance */

char user_dir[1000];            /* user directory file */
int delay_time;                 /* used to delay display data */
int colors[256];                /* screen colors */
int trail_colors[32];           /* station trail colors, duh */
int current_trail_color;        /* what color to draw station trails with */
int max_trail_colors = 32; 
int map_background_color;       /* Background color for maps */
int map_color_fill;             /* Whether or not to fill in map polygons with solid color */

int letter_style;               /* Station Letter style */
int wx_alert_style;             /* WX alert map style */

int symbol_callsign_display;    // Switch for Callsign display
int symbol_alt_display;         // Switch for Altitude display
int symbol_course_display;      // Switch for Course display
int symbol_speed_display;       // Switch for Speed display
int symbol_dist_course_display; // Switch for Distance and Course display
int symbol_weather_display;     // Switch for Weather info display
int symbol_display;             // Switch for Symbols display
int symbol_rotate;              // Switch for rotated symbols display
int station_trails;             // Switch for Trail display
int show_phg;                   // Switch for Power/Height/Gain Circle display
int long_lat_grid;              // Switch for Map Lat and Long grid display

int redo_list;                  // Station List update request
int redraw_on_new_data;         // Station redraw request
int wait_to_redraw;             /* wait to redraw until system is up */
int display_up;                 /* display up? */
int display_up_first;           /* display up first */

time_t max_transmit_time;       /* max time between transmits */
time_t last_alert_redraw;       /* last time alert caused a redraw */
time_t sec_next_gps;            /* next gps check */
time_t gps_time;                /* gps delay time */  
time_t GPS_time;                /* gps time out */
time_t last_statusline;         // last update of statusline or 0 if inactive
time_t sec_old;                 /* station old after */
time_t sec_clear;               /* station cleared after */
time_t sec_remove;              /* Station removed after */
time_t sec_next_raw_wx;         /* raw wx transmit data */

int transmit_raw_wx;            /* transmit raw wx data? */

int transmit_compressed_posit;  /* transmit location in compressed format? */

int output_station_type;        /* Broadcast station type */

int Configure_station_pos_amb;  /* Broadcast station position ambiguity */

int units_english_metric;       /* units are in english if 1 or metric if 0 */

long max_vectors_allowed;       /* max map vectors allowed */
long max_text_labels_allowed;   /* max map text labels allowed */
long max_symbol_labels_allowed; /* max map symbol labels allowed */

int map_color_levels;           /* toggle use of map_color_levels */
int map_auto_maps;              /* toggle use of auto_maps */

time_t net_last_time;           /* reconnect last time in seconds */
time_t net_next_time;           /* reconnect Next update delay time */

time_t last_time;               /* last time in seconds */
time_t next_time;               /* Next update delay time */

time_t next_redraw;             /* Next update time */
time_t last_redraw;             /* Time of last redraw */

char aprs_station_message_type; /* aprs station message type message capable or not */

int transmit_now;               /* set to transmit now (push on moment) */
int operate_as_an_igate;        /* toggle igate operations for net connections */
unsigned igate_msgs_tx;         /* current total of igate messages transmitted */

int log_tnc_data;               /* log data */
int log_net_data;               /* log data */
int log_igate;                  /* toggle to allow igate logging */
int log_wx;                     /* toggle to allow wx logging */

time_t WX_ALERTS_REFRESH_TIME;  /* Minimum WX alert map refresh time in seconds */

/* button zoom */
int menu_x;
int menu_y;

/* file showing */
int read_file;
FILE *read_file_ptr;
int read_file_delay;
int read_file_delay_count;

// Data for own station
char my_callsign[MAX_CALL+1];
char my_lat[MAX_LAT];
char my_long[MAX_LONG];
char my_group;
char my_symbol;
char my_phg[MAX_PHG+1];
char my_comment[MAX_COMMENT+1];
int  my_last_course;
int  my_last_speed;
long my_last_altitude;
time_t my_last_altitude_time;

/* Symbols */
SymbolData symbol_data[MAX_SYMBOLS];

/* sound run */
pid_t last_sound_pid;

/* Default directories */

char AUTO_MAP_DIR[400];
char ALERT_MAP_DIR[400];
char WIN_MAP_DIR[400];
char WIN_MAP_DATA[400];
char SYMBOLS_DIR[400];
char HELP_FILE[400];
char SOUND_DIR[400];

char LOGFILE_TNC[400];
char LOGFILE_NET[400];
char LOGFILE_IGATE[400];
char LOGFILE_WX[400];

/* sound data */
char sound_command[90];
int  sound_play_new_station;
char sound_new_station[90];
int  sound_play_new_message;
char sound_new_message[90];

int  sound_play_prox_message;
char sound_prox_message[90];
char prox_min[30];
char prox_max[30];
int  sound_play_band_open_message;
char sound_band_open_message[90];
char bando_min[30];
char bando_max[30];
int  sound_play_wx_alert_message;
char sound_wx_alert_message[90];


//#ifdef HAVE_FESTIVAL
/* WARNING - new station is initialized to FALSE for a reason            */
/* If you're tempted to make it something that can be saved and restored */
/* beware, Speech cannot keep up with the initial flow of data from an   */
/* Internet connection that has buffered data. An unbuffered connection  */
/* yes, but not a buffered one.  Ken,  N7IPB                             */
int festival_speak_new_station = FALSE;
int festival_speak_proximity_alert;
int festival_speak_band_opening;
int festival_speak_new_message_alert;
int festival_speak_new_message_body;
int festival_speak_new_wx_alert;
//#endif

static int      input_x = 0;
static int      input_y = 0;

XtAppContext app_context;
Display *display;       /*  Display             */

/* dialog popup last */
int last_popup_x;
int last_popup_y;

// Init values for Objects dialog
char last_object[9+1];
char last_obj_grp;
char last_obj_sym;




////////////////////////////////////////////////////////////////////////////////////////////////////

void HandlePendingEvents( XtAppContext app) {
    XEvent event;

    while(XtAppPending(app)) {
        XtAppNextEvent(app,&event);
        (void)XtDispatchEvent(&event);
    }
}



Boolean unbusy_cursor(XtPointer clientdata) {
    Widget w = (Widget)clientdata;

    (void)XUndefineCursor(XtDisplay(w),XtWindow(w));
    return((Boolean)TRUE);
}



void busy_cursor(Widget w) {
    static Cursor cs = (Cursor)NULL;

    if(!cs)
        cs=XCreateFontCursor(XtDisplay(w),XC_watch);

    (void)XDefineCursor(XtDisplay(w),XtWindow(w),cs);
    (void)XFlush(XtDisplay(w));
    (void)XtAppAddWorkProc(XtWidgetToApplicationContext(w),unbusy_cursor,(XtPointer)w);
}



void create_image(Widget w) {
    Dimension width, height, margin_width, margin_height;
    long lat_offset_temp;
    long long_offset_temp;
    char temp_course[20];
    unsigned char   unit_type;
    unsigned char medium_dashed[2] = {(unsigned char)5,(unsigned char)5};
    long pos1_lat, pos1_lon, pos2_lat, pos2_lon;

    busy_cursor(w);

    if (debug_level & 4)
        printf("Create image start\n");

    /* First get the various dimensions */
    XtVaGetValues(w,
              XmNwidth,         &width,
              XmNheight,        &height,
              XmNmarginWidth,   &margin_width,
              XmNmarginHeight,  &margin_height,
              XmNunitType,      &unit_type,
              0);

    (void)XSetDashes(XtDisplay(w), gc, 0, medium_dashed , 2);

    screen_width  = (long)width;
    screen_height = (long)height;
    long_offset_temp = x_long_offset = mid_x_long_offset - (screen_width  * size / 2);  // NW corner
    lat_offset_temp  = y_lat_offset  = mid_y_lat_offset  - (screen_height * size / 2);

    /* map default background color */
    switch (map_background_color){
        case 0 :
            colors[0xfd] = (int)GetPixelByName(appshell,"gray73");
            break;

        case 1 :
            colors[0xfd] = (int)GetPixelByName(w,"MistyRose");
            break;

        case 2 :
            colors[0xfd] = (int)GetPixelByName(w,"NavyBlue");
            break;

        case 3 :
            colors[0xfd] = (int)GetPixelByName(w,"SteelBlue");
            break;

        case 4 :
            colors[0xfd] = (int)GetPixelByName(w,"MediumSeaGreen");
            break;

        case 5 :
            colors[0xfd] = (int)GetPixelByName(w,"PaleGreen");
            break;

        case 6 :
            colors[0xfd] = (int)GetPixelByName(w,"PaleGoldenrod");
            break;

        case 7 :
            colors[0xfd] = (int)GetPixelByName(w,"LightGoldenrodYellow");
            break;

        case 8 :
            colors[0xfd] = (int)GetPixelByName(w,"RosyBrown");
            break;

        case 9 :
            colors[0xfd] = (int)GetPixelByName(w,"firebrick");
            break;

        case 10 :
            colors[0xfd] = (int)GetPixelByName(w,"white");
            break;

        default:
            colors[0xfd] = (int)GetPixelByName(appshell,"gray73");
            map_background_color=0;
            break;
    }

    (void)XSetForeground(XtDisplay(w),gc,colors[0xfd]);
    (void)XSetBackground(XtDisplay(w),gc,colors[0xfd]);

    (void)XFillRectangle(XtDisplay(w), pixmap,gc,0,0,screen_width,screen_height);

    statusline(langcode("BBARSTA003"),1);       // Loading Maps

    if (display_up_first != 0) {
        if (map_auto_maps)
            load_auto_maps(w,AUTO_MAP_DIR);
        else
            load_maps(w);
    }


    if (!wx_alert_style)
        statusline("Loading Weather Alert Maps",1);

    // Update to screen
    (void)XCopyArea(XtDisplay(da),pixmap,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);

    /* copy map data to alert pixmap */
    (void)XCopyArea(XtDisplay(w),pixmap,pixmap_alerts,gc,0,0,screen_width,screen_height,0,0);

    if (!wx_alert_style)
        load_alert_maps(w, ALERT_MAP_DIR);  // These write onto pixmap_alerts

    // Update to screen
    (void)XCopyArea(XtDisplay(da),pixmap_alerts,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);

    /* copy map and alert data to final pixmap */
    (void)XCopyArea(XtDisplay(w),pixmap_alerts,pixmap_final,gc,0,0,screen_width,screen_height,0,0);

    wx_alert_update_list();

    /* Compute distance */
    if (lat_offset_temp<0l)
        lat_offset_temp=0l;                     // max 90N
    else
        if (lat_offset_temp>64800000l)
            lat_offset_temp=64800000l;          // max 90S

    if(long_offset_temp<0l)
        long_offset_temp=0l;                    // max 180W
    else
        if (long_offset_temp>129600000l)
            long_offset_temp=129600000l;        // max 180E

    pos1_lat = lat_offset_temp;
    pos1_lon = long_offset_temp;
    pos2_lat = lat_offset_temp;      // ??
    pos2_lon = long_offset_temp+(50.0*size);

//    long_offset_temp = long_offset_temp+(50*size);  // ??

    if(pos2_lat < 0l)     // ??
        pos2_lat = 0l;
    else
        if (pos2_lat > 64799999l)
            pos2_lat = 64799999l;

    if (pos2_lon < 0l)
        pos2_lon = 0l;
    else
        if (pos2_lon > 129599999l)
            pos2_lon = 129599999l;

    x_screen_distance = (float)calc_distance_course(pos1_lat, pos1_lon, pos2_lat, pos2_lon, temp_course);
    display_file(w);                    // display stations (symbols, info, trails)
    draw_grid(w);                       // Draw grid if enabled
    last_alert_redraw=sec_now();        // set last time of screen redraw
    if (debug_level & 4)
        printf("Create image stop\n");
}



// Routine used to refresh image WITHOUT reading regular map files
// from disk.  It uses the map data already in "pixmap", then adds
// the weather alert map data to it, leaving the combined data in
// "pixmap_alerts".
void refresh_image(Widget w) {
    Dimension width, height, margin_width, margin_height;
    long lat_offset_temp;
    long long_offset_temp;
    char temp_course[20];
    unsigned char   unit_type;
    unsigned char medium_dashed[2] = {(unsigned char)5,(unsigned char)5};
    long pos1_lat, pos1_lon, pos2_lat, pos2_lon;

    busy_cursor(w);

    if (debug_level & 4)
        printf("Refresh image start\n");

    /* First get the various dimensions */
    XtVaGetValues(w,
              XmNwidth,         &width,
              XmNheight,        &height,
              XmNmarginWidth,   &margin_width,
              XmNmarginHeight,  &margin_height,
              XmNunitType,      &unit_type,
              0);

    (void)XSetDashes(XtDisplay(w), gc, 0, medium_dashed , 2);

    screen_width  = (long)width;
    screen_height = (long)height;

    long_offset_temp = x_long_offset = mid_x_long_offset - (screen_width * size / 2);
    y_lat_offset     = mid_y_lat_offset - (screen_height * size / 2);
    lat_offset_temp  = mid_y_lat_offset;

    (void)XSetForeground(XtDisplay(w),gc,colors[0xfd]);
    (void)XSetBackground(XtDisplay(w),gc,colors[0xfd]);

    if (!wx_alert_style)
        statusline("Loading Weather Alert Maps",1);

    /* copy over map data to alert pixmap */
    (void)XCopyArea(XtDisplay(w),pixmap,pixmap_alerts,gc,0,0,screen_width,screen_height,0,0);

    if (!wx_alert_style)
        load_alert_maps(w, ALERT_MAP_DIR);          // These write onto pixmap_alerts

    /* copy over map and alert data to final pixmap */
    (void)XCopyArea(XtDisplay(w),pixmap_alerts,pixmap_final,gc,0,0,screen_width,screen_height,0,0);

//    statusline("Weather Alert Maps Loaded",1);

    wx_alert_update_list();

    /* Compute distance */
    if (lat_offset_temp<0l)
        lat_offset_temp=0l;                     // max 90N
    else
        if (lat_offset_temp>64800000l)
            lat_offset_temp=64800000l;          // max 90S

    if(long_offset_temp<0l)
        long_offset_temp=0l;                    // max 180W
    else
        if (long_offset_temp>129600000l)
            long_offset_temp=129600000l;        // max 180E

    pos1_lat = lat_offset_temp;
    pos1_lon = long_offset_temp;
    pos2_lat = lat_offset_temp;      // ??
    pos2_lon = long_offset_temp+(50.0*size);

//    long_offset_temp = long_offset_temp+(50*size);  // ??

    if(pos2_lat < 0l)     // ??
        pos2_lat = 0l;
    else
        if (pos2_lat > 64799999l)
            pos2_lat = 64799999l;

    if (pos2_lon < 0l)
        pos2_lon = 0l;
    else
        if (pos2_lon > 129599999l)
            pos2_lon = 129599999l;

    x_screen_distance = (float)calc_distance_course(pos1_lat, pos1_lon, pos2_lat, pos2_lon, temp_course);

    /* display icons */
    display_file(w);

    /* draw grid if enabled */
    draw_grid(w);

    /* set last time of screen redraw*/
    last_alert_redraw=sec_now();

    if (debug_level & 4)
        printf("Refresh image stop\n");
}



void redraw_symbols(Widget w) {

    /* copy over map and alert data to final pixmap */
    if(!wait_to_redraw) {
        (void)XCopyArea(XtDisplay(w),pixmap_alerts,pixmap_final,gc,0,0,screen_width,screen_height,0,0);
        display_file(w);        // display stations (symbols, info, trails)
        draw_grid(w);           // draw grid if enabled
        (void)XCopyArea(XtDisplay(w),pixmap_final,XtWindow(w),gc,0,0,screen_width,screen_height,0,0);
    }
}



static void TrackMouse( /*@unused@*/ Widget w, XtPointer clientData, XEvent *event, /*@unused@*/ Boolean *flag) {
    char my_text[100];
    char str_lat[20];
    char str_long[20];
    long x,y;

    Widget textarea = (Widget) clientData;

    x = (mid_x_long_offset - ((screen_width  * size)/2) + (event->xmotion.x * size));
    y = (mid_y_lat_offset  - ((screen_height * size)/2) + (event->xmotion.y * size));

    if (x < 0)
        x = 0l;                 // 180W

    if (x > 129600000l)
        x = 129600000l;         // 180E

    if (y < 0)
        y = 0l;                 //  90N

    if (y > 64800000l)
        y = 64800000l;          //  90S

    convert_lat_l2s(y,str_lat, CONVERT_HP_NORMAL);
    convert_lon_l2s(x,str_long,CONVERT_HP_NORMAL);
    sprintf(my_text,"%s %s",str_lat,str_long);
    XmTextFieldSetString(textarea,my_text);
    XtManageChild(textarea);
}



static void ClearTrackMouse( /*@unused@*/ Widget w, XtPointer clientData, /*@unused@*/ XEvent *event, /*@unused@*/ Boolean *flag) {

    Widget textarea = (Widget) clientData;
    XmTextFieldSetString(textarea," ");
    XtManageChild(textarea);
}


/* 
 *  Delete tracks of all stations 
 */
void Tracks_All_Clear( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    DataRow *p_station;

    p_station = n_first;
    while (p_station != 0) {
        if (delete_trail(p_station))
        redraw_on_new_data=2;
        p_station = p_station->n_next;
    }
}


/*
 *  Display text in the status line, text is removed after timeout
 */
void statusline(char *status_text,int update) {

    XmTextFieldSetString (text, status_text);
    last_statusline = sec_now();
    if (update != 0)
        XmUpdateDisplay(text);          // do an immediate update
}


/*
 *  Check for statusline timeout and remove statusline text
 */
void check_statusline_timeout(void) {
    char status_text;

    if (last_statusline != 0 && (last_statusline < sec_now() - STATUSLINE_ACTIVE)) {
        status_text = '\0';
        XmTextFieldSetString(text, &status_text);       // clear statusline
        last_statusline = 0;                            // now inactive
    }
}


/*
 *  Display current zoom factor
 */
void display_zoom_status(void) {
    char zoom[30];
    char siz_str[6];

    if (size < 9000)
        sprintf(siz_str,"%ld",size);
    else
        sprintf(siz_str,"%ldk",size/1024);
    if (track_station_on == 1)
        sprintf(zoom,langcode("BBARZM0002"),siz_str);   // set tracking indicator
    else
        sprintf(zoom,langcode("BBARZM0001"),siz_str);
    XmTextFieldSetString(text4,zoom);
}



void create_appshell ( /*@unused@*/ Display *display, char *app_name, /*@unused@*/ int app_argc, char ** app_argv) {
    Atom WM_DELETE_WINDOW;
    Widget children[8];         /* Children to manage */
    Arg al[64];                 /* Arg List */
    register unsigned int ac = 0;        /* Arg Count */
    /*popup menu widgets */
    Widget zoom_in, zoom_out, zoom_sub, zoom_level, zl1, zl2, zl3, zl4, zl5, zl6, zl7;
    Widget pan_ctr, last_loc, station_info, set_object;
    //Widget pan_up, pan_down, pan_left, pan_right;
    /*menu widgets */
    Widget sep;
    Widget filepane, configpane, mappane, viewpane, displaypane, messagepane, ifacepane, qpane, helppane;
    Widget station_clear_button, tracks_clear_button,
       save_button,file_button, open_file_button, exit_button,
       view_button, view_messages_button, bullet_button, packet_data_button, mobile_button, stations_button,
       localstations_button, laststations_button,
       weather_button, wx_station_button, locate_button, jump_button, alert_button,
       config_button, defaults_button, station_button,
       map_button, Option_Map_auto_Pane, map_auto_button, map_chooser_button, map_grid_button, Option_Grid_Pane,
       map_levels_button, map_fill_button, Option_Map_Levels_Pane, Option_Map_Fill_Pane,
       Map_background_color_Pane, map_background_button,
#ifdef USE_GEOTIFF
       Map_intensity_Pane, map_intensity_button,
#endif // USE_GEOTIFF
       Map_station_label_Pane, map_station_label_button,
       Map_wx_alerts_Pane, map_wx_alerts_button,
       display_button, call_pane, call_button, alt_pane, alt_button, course_pane, course_button, speed_pane, speed_button, dist_course_pane, dist_course_button,  units_choice_pane, units_choice_button,
       device_config_button,
       iface_button, iface_connect_button, tnc_logging_pane, tnc_logging, iface_transmit_now,
       net_logging_pane, net_logging,
       igate_logging_pane, igate_logging,
       wx_logging_pane, wx_logging,
       test_button, aa_button, speech_button,
       auto_msg_pane, auto_msg_button, auto_msg_set_button,
       message_button, send_message_to_button, open_messages_group_button, clear_messages_button,
       station_trails_pane, station_trails_button,
       station_phg_pane, station_phg_button,
       wx_pane, wx_button, symbols_pane, symbols_button, symrot_pane, symrot_button,
       track_button,
       queries_button, General_q_button, IGate_q_button, WX_q_button,

#ifdef ARROWS
       pan_up_menu, pan_down_menu, pan_left_menu, pan_right_menu,
#endif // ARROWS

       help_button, help_about, help_help;
    char *title, *t;

    if(debug_level & 8)
        printf("Create appshell start\n");


    t = _("X Amateur Station Tracking and Information Reporting");
    title = (char *)malloc(strlen(t) + 40 + strlen(PACKAGE));
    strcpy(title, "XASTIR ");
    strcat(title, " - ");
    strcat(title, t);
    strcat(title, " @ ");
    (void)gethostname(&title[strlen(title)], 28);
    
    colors[0xff] = (int)GetPixelByName(Global.top,"gray73");

    XtSetArg(al[ac], XmNallowShellResize, TRUE);     ac++;
    XtSetArg(al[ac], XmNtitle,            title);    ac++;
    XtSetArg(al[ac], XmNargv,             app_argv); ac++;
    XtSetArg(al[ac], XmNminWidth,         640);      ac++;
    XtSetArg(al[ac], XmNminHeight,        380);      ac++;
    XtSetArg(al[ac], XmNdefaultPosition,  FALSE);    ac++;

    appshell= XtCreatePopupShell (app_name,topLevelShellWidgetClass,Global.top, al, ac);

    form = XtVaCreateManagedWidget("Form",xmFormWidgetClass,appshell,
                                      XmNbackground, colors[0xff],
                                      NULL);

    /* Menu Bar */
    ac = 0;
    XtSetArg(al[ac],XmNshadowThickness, 1);                     ac++;
    XtSetArg(al[ac],XmNalignment,       XmALIGNMENT_BEGINNING); ac++;
    XtSetArg(al[ac],XmNleftAttachment,  XmATTACH_FORM);         ac++;
    XtSetArg(al[ac],XmNtopAttachment,   XmATTACH_FORM);         ac++;
    XtSetArg(al[ac],XmNrightAttachment, XmATTACH_FORM);         ac++;
    XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_NONE);         ac++;
    XtSetArg(al[ac],XmNbackground,      colors[0xff]);          ac++;
    menubar = XmCreateMenuBar(form,"menubar",al,ac);

    /*set args for color */
    ac = 0;
    XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;
    filepane    = XmCreatePulldownMenu(menubar,"filepane",   al, ac);
    viewpane    = XmCreatePulldownMenu(menubar,"viewpane",   al, ac);
    configpane  = XmCreatePulldownMenu(menubar,"configpane", al, ac);
    mappane     = XmCreatePulldownMenu(menubar,"mappane",    al, ac);
    displaypane = XmCreatePulldownMenu(menubar,"displaymap", al, ac);
    messagepane = XmCreatePulldownMenu(menubar,"messagepane",al, ac);
    ifacepane   = XmCreatePulldownMenu(menubar,"ifacepane",  al, ac);
    qpane       = XmCreatePulldownMenu(menubar,"qpane",      al, ac);
    helppane    = XmCreatePulldownMenu(menubar,"helppane",   al, ac);

    /* menu bar */
    file_button = XtVaCreateManagedWidget(langcode("MENUTB0001"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId, filepane,XmNmnemonic,langcode_hotkey("MENUTB0001"),XmNbackground,colors[0xff],NULL);
    view_button = XtVaCreateManagedWidget(langcode("MENUTB0002"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,viewpane,XmNmnemonic,langcode_hotkey("MENUTB0002"),XmNbackground,colors[0xff],NULL);
    config_button = XtVaCreateManagedWidget(langcode("MENUTB0003"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,configpane,XmNmnemonic,langcode_hotkey("MENUTB0003"),XmNbackground,colors[0xff],NULL);
    map_button = XtVaCreateManagedWidget(langcode("MENUTB0004"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,mappane,XmNmnemonic,langcode_hotkey("MENUTB0004"),XmNbackground,colors[0xff],NULL);
    display_button = XtVaCreateManagedWidget(langcode("MENUTB0005"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,displaypane,XmNmnemonic,langcode_hotkey("MENUTB0005"),XmNbackground,colors[0xff],NULL);
    message_button = XtVaCreateManagedWidget(langcode("MENUTB0006"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,messagepane,XmNmnemonic,langcode_hotkey("MENUTB0006"),XmNbackground,colors[0xff],NULL);
    iface_button = XtVaCreateManagedWidget(langcode("MENUTB0010"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,ifacepane,XmNmnemonic,langcode_hotkey("MENUTB0010"),XmNbackground,colors[0xff],NULL);
    queries_button = XtVaCreateManagedWidget(langcode("MENUTB0011"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,qpane,XmNmnemonic,langcode_hotkey("MENUTB0011"),XmNbackground,colors[0xff],NULL);


#ifdef ARROWS
    pan_left_menu=XtVaCreateManagedWidget("arrow1_menu",xmArrowButtonGadgetClass, menubar,
        XmNarrowDirection,  XmARROW_LEFT,
        NULL);
    XtAddCallback(pan_left_menu,XmNactivateCallback,Pan_left,NULL);

    pan_up_menu=XtVaCreateManagedWidget("arrow2_menu",xmArrowButtonGadgetClass, menubar,
        XmNarrowDirection,  XmARROW_UP,
        NULL);
    XtAddCallback(pan_up_menu,XmNactivateCallback,Pan_up,NULL);

    pan_down_menu=XtVaCreateManagedWidget("arrow3_menu",xmArrowButtonGadgetClass, menubar,
        XmNarrowDirection,  XmARROW_DOWN,
        NULL);
    XtAddCallback(pan_down_menu,XmNactivateCallback,Pan_down,NULL);

    pan_right_menu=XtVaCreateManagedWidget("arrow4_menu",xmArrowButtonGadgetClass, menubar,
        XmNarrowDirection,  XmARROW_RIGHT,
        NULL);
    XtAddCallback(pan_right_menu,XmNactivateCallback,Pan_right,NULL);
#endif // ARROWS


    help_button = XtVaCreateManagedWidget(langcode("MENUTB0009"),xmCascadeButtonGadgetClass,menubar,
                    XmNsubMenuId,helppane,XmNmnemonic,langcode_hotkey("MENUTB0009"),XmNbackground,colors[0xff],NULL);
    XtVaSetValues (menubar,XmNmenuHelpWidget,help_button,NULL);
    /* end bar */

    /* Queries */
    General_q_button = XtVaCreateManagedWidget(langcode("PULDQUS001"),xmPushButtonGadgetClass,qpane,
                        XmNmnemonic,langcode_hotkey("PULDQUS001"),XmNbackground,colors[0xff],NULL);
    IGate_q_button = XtVaCreateManagedWidget(langcode("PULDQUS002"),xmPushButtonGadgetClass,qpane,
                        XmNmnemonic,langcode_hotkey("PULDQUS002"),XmNbackground,colors[0xff],NULL);
    WX_q_button = XtVaCreateManagedWidget(langcode("PULDQUS003"),xmPushButtonGadgetClass,qpane,
                        XmNmnemonic,langcode_hotkey("PULDQUS003"),XmNbackground,colors[0xff],NULL);

    /* File */
    station_clear_button = XtVaCreateManagedWidget(langcode("PULDNFI001"),xmPushButtonGadgetClass,filepane,
                                XmNmnemonic,langcode_hotkey("PULDNFI001"),XmNbackground,colors[0xff],NULL);
    tracks_clear_button = XtVaCreateManagedWidget(langcode("PULDNFI005"),xmPushButtonGadgetClass,filepane,
                                XmNbackground,colors[0xff],NULL);
    open_file_button = XtVaCreateManagedWidget(langcode("PULDNFI002"),xmPushButtonGadgetClass,filepane,
                                XmNmnemonic,langcode_hotkey("PULDNFI002"),XmNbackground,colors[0xff],NULL);
    save_button = XtVaCreateManagedWidget(langcode("PULDNFI006"),xmPushButtonGadgetClass,filepane,
                                XmNmnemonic,langcode_hotkey("PULDNFI006"),XmNbackground,colors[0xff],NULL);
    (void)XtVaCreateManagedWidget("sep1",xmSeparatorGadgetClass,filepane,XmNbackground,colors[0xff],NULL);
    test_button = XtVaCreateManagedWidget(langcode("PULDNFI003"), xmPushButtonWidgetClass, filepane,
                        XmNmnemonic, langcode_hotkey("PULDNFI003"), XmNbackground, colors[0xff], NULL);
    exit_button = XtVaCreateManagedWidget(langcode("PULDNFI004"),xmPushButtonWidgetClass,filepane,
                        XmNmnemonic,langcode_hotkey("PULDNFI004"),XmNbackground,colors[0xff],NULL);

    /* View */
    bullet_button = XtVaCreateManagedWidget(langcode("PULDNVI001"),xmPushButtonGadgetClass,viewpane,
                        XmNmnemonic,langcode_hotkey("PULDNVI001"),XmNbackground,colors[0xff],NULL);
    packet_data_button = XtVaCreateManagedWidget(langcode("PULDNVI002"),xmPushButtonGadgetClass,viewpane,
                        XmNmnemonic,langcode_hotkey("PULDNVI002"),XmNbackground,colors[0xff],NULL);
    mobile_button = XtVaCreateManagedWidget(langcode("PULDNVI003"),xmPushButtonGadgetClass,viewpane,
                        XmNmnemonic,langcode_hotkey("PULDNVI003"),XmNbackground,colors[0xff],NULL);
    stations_button = XtVaCreateManagedWidget(langcode("PULDNVI004"),xmPushButtonGadgetClass,viewpane,
                            XmNmnemonic,langcode_hotkey("PULDNVI004"),XmNbackground,colors[0xff],NULL);
    localstations_button = XtVaCreateManagedWidget(langcode("PULDNVI009"),xmPushButtonGadgetClass,viewpane,
                                XmNmnemonic,langcode_hotkey("PULDNVI009"),XmNbackground,colors[0xff],NULL);
    laststations_button = XtVaCreateManagedWidget(langcode("PULDNVI012"),xmPushButtonGadgetClass,viewpane,
                                XmNmnemonic,langcode_hotkey("PULDNVI012"),XmNbackground,colors[0xff],NULL);
    weather_button = XtVaCreateManagedWidget(langcode("PULDNVI005"),xmPushButtonGadgetClass,
                            viewpane,XmNmnemonic,langcode_hotkey("PULDNVI005"),XmNbackground,colors[0xff],NULL);
    wx_station_button = XtVaCreateManagedWidget(langcode("PULDNVI008"),xmPushButtonGadgetClass,
                                viewpane,XmNmnemonic,langcode_hotkey("PULDNVI008"),XmNbackground,colors[0xff],NULL);
    alert_button = XtVaCreateManagedWidget(langcode("PULDNVI007"),xmPushButtonGadgetClass,viewpane,
                        XmNmnemonic,langcode_hotkey("PULDNVI007"),XmNbackground,colors[0xff],NULL);
    view_messages_button = XtVaCreateManagedWidget(langcode("PULDNVI011"),xmPushButtonGadgetClass,viewpane,
                                XmNmnemonic,langcode_hotkey("PULDNVI011"),XmNbackground,colors[0xff],NULL);
    locate_button = XtVaCreateManagedWidget(langcode("PULDNVI006"),xmPushButtonGadgetClass,viewpane,
                        XmNmnemonic,langcode_hotkey("PULDNVI006"),XmNbackground,colors[0xff],NULL);
    jump_button = XtVaCreateManagedWidget(langcode("PULDNVI010"),xmPushButtonGadgetClass,viewpane,
                        XmNmnemonic,langcode_hotkey("PULDNVI010"),XmNbackground,colors[0xff],NULL);

    /* Configure */
    defaults_button = XtVaCreateManagedWidget(langcode("PULDNCF001"),xmPushButtonGadgetClass,configpane,
                            XmNmnemonic,langcode_hotkey("PULDNCF001"),XmNbackground,colors[0xff],NULL);
    device_config_button = XtVaCreateManagedWidget(langcode("PULDNCF008"),xmPushButtonGadgetClass,configpane,
                                XmNmnemonic,langcode_hotkey("PULDNCF008"),XmNbackground,colors[0xff],NULL);
    station_button = XtVaCreateManagedWidget(langcode("PULDNCF004"),xmPushButtonGadgetClass,configpane,
                            XmNmnemonic,langcode_hotkey("PULDNCF004"),XmNbackground,colors[0xff],NULL);
    aa_button = XtVaCreateManagedWidget(langcode("PULDNCF006"),xmPushButtonGadgetClass,configpane,
                    XmNmnemonic,langcode_hotkey("PULDNCF006"),XmNbackground,colors[0xff],NULL);

    speech_button = XtVaCreateManagedWidget(langcode("PULDNCF007"),xmPushButtonGadgetClass,configpane,
                    XmNmnemonic,langcode_hotkey("PULDNCF007"),XmNbackground,colors[0xff],NULL);

    units_choice_pane = XmCreatePulldownMenu(configpane,"units_choice",al,ac);
    units_choice_button = XtVaCreateManagedWidget(langcode("PULDNDP006"),xmCascadeButtonWidgetClass,configpane,
                            XmNsubMenuId,units_choice_pane,XmNmnemonic,langcode_hotkey("PULDNDP006"),XmNbackground,colors[0xff],NULL);
    units_choice_on = XtVaCreateManagedWidget(langcode("PULDNUT001"),xmPushButtonGadgetClass,units_choice_pane,
                            XmNbackground,colors[0xff],NULL);
    units_choice_off = XtVaCreateManagedWidget(langcode("PULDNUT002"),xmPushButtonGadgetClass,units_choice_pane,
                            XmNbackground,colors[0xff],NULL);

    /* Maps */
    map_chooser_button = XtVaCreateManagedWidget(langcode("PULDNMP001"),xmPushButtonGadgetClass,mappane,
                            XmNmnemonic,langcode_hotkey("PULDNMP001"),XmNbackground,colors[0xff],NULL);
    Option_Map_auto_Pane = XmCreatePulldownMenu(mappane,"auto_map_levels",al,ac);
    map_auto_button = XtVaCreateManagedWidget(langcode("PULDNMP002"),xmCascadeButtonWidgetClass,mappane,
                        XmNsubMenuId,Option_Map_auto_Pane,XmNmnemonic,langcode_hotkey("PULDNMP002"),XmNbackground,colors[0xff],NULL);
    map_auto_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,Option_Map_auto_Pane,
                        XmNbackground,colors[0xff],NULL);
    map_auto_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,Option_Map_auto_Pane,
                        XmNbackground,colors[0xff],NULL);

    (void)XtVaCreateManagedWidget("sep2",xmSeparatorGadgetClass,mappane,XmNbackground,colors[0xff],NULL);
    Option_Grid_Pane = XmCreatePulldownMenu(mappane,"Option_grid",al,ac);
    map_grid_button = XtVaCreateManagedWidget(langcode("PULDNMP003"),xmCascadeButtonWidgetClass,mappane,
                        XmNsubMenuId, Option_Grid_Pane,XmNmnemonic,langcode_hotkey("PULDNMP003"),XmNbackground,colors[0xff],NULL);
    grid_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,Option_Grid_Pane,
                    XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    grid_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,Option_Grid_Pane,
                    XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    Option_Map_Levels_Pane = XmCreatePulldownMenu(mappane,"Option_map_levels",al,ac);
    map_levels_button = XtVaCreateManagedWidget(langcode("PULDNMP004"),xmCascadeButtonWidgetClass,mappane,
                            XmNsubMenuId, Option_Map_Levels_Pane,XmNmnemonic,langcode_hotkey("PULDNMP004"),XmNbackground,colors[0xff],NULL);
    map_levels_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,Option_Map_Levels_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    map_levels_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,Option_Map_Levels_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    Option_Map_Fill_Pane = XmCreatePulldownMenu(mappane,"Option_color_fill",al,ac);
    map_fill_button = XtVaCreateManagedWidget(langcode("PULDNMP009"),xmCascadeButtonWidgetClass,mappane,
                            XmNsubMenuId, Option_Map_Fill_Pane,XmNmnemonic,langcode_hotkey("PULDNMP009"),XmNbackground,colors[0xff],NULL);
    map_fill_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,Option_Map_Fill_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    map_fill_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,Option_Map_Fill_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    Map_background_color_Pane = XmCreatePulldownMenu(mappane,"map_background_color",al,ac);
    map_background_button = XtVaCreateManagedWidget(langcode("PULDNMP005"),xmCascadeButtonWidgetClass,mappane,
                                XmNsubMenuId, Map_background_color_Pane,XmNmnemonic,
                                langcode_hotkey("PULDNMP005"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[10] = XtVaCreateManagedWidget(langcode("PULDNMBC11"),xmPushButtonGadgetClass,Map_background_color_Pane,
                            XmNmnemonic,langcode_hotkey("PULDNMBC11"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[0] = XtVaCreateManagedWidget(langcode("PULDNMBC01"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC01"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[1] = XtVaCreateManagedWidget(langcode("PULDNMBC02"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC02"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[2] = XtVaCreateManagedWidget(langcode("PULDNMBC03"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC03"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[3] = XtVaCreateManagedWidget(langcode("PULDNMBC04"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC04"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[4] = XtVaCreateManagedWidget(langcode("PULDNMBC05"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC05"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[5] = XtVaCreateManagedWidget(langcode("PULDNMBC06"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC06"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[6] = XtVaCreateManagedWidget(langcode("PULDNMBC07"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC07"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[7] = XtVaCreateManagedWidget(langcode("PULDNMBC08"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC08"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[8] = XtVaCreateManagedWidget(langcode("PULDNMBC09"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC09"),XmNbackground,colors[0xff],NULL);
    map_bgcolor[9] = XtVaCreateManagedWidget(langcode("PULDNMBC10"),xmPushButtonGadgetClass,Map_background_color_Pane,
                        XmNmnemonic,langcode_hotkey("PULDNMBC10"),XmNbackground,colors[0xff],NULL);

#ifdef USE_GEOTIFF
    Map_intensity_Pane = XmCreatePulldownMenu(mappane,"map_intensity",al,ac);
    map_intensity_button = XtVaCreateManagedWidget(langcode("PULDNMP008"),xmCascadeButtonWidgetClass,mappane,
                                XmNsubMenuId, Map_intensity_Pane,XmNmnemonic,
                                langcode_hotkey("PULDNMP008"),XmNbackground,colors[0xff],NULL);
    map_intensity[0] = XtVaCreateManagedWidget("0%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"0%",XmNbackground,colors[0xff],NULL);
    map_intensity[1] = XtVaCreateManagedWidget("10%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"10%",XmNbackground,colors[0xff],NULL);
    map_intensity[2] = XtVaCreateManagedWidget("20%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"20%",XmNbackground,colors[0xff],NULL);
    map_intensity[3] = XtVaCreateManagedWidget("30%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"30%",XmNbackground,colors[0xff],NULL);
    map_intensity[4] = XtVaCreateManagedWidget("40%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"40%",XmNbackground,colors[0xff],NULL);
    map_intensity[5] = XtVaCreateManagedWidget("50%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"50%",XmNbackground,colors[0xff],NULL);
    map_intensity[6] = XtVaCreateManagedWidget("60%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"60%",XmNbackground,colors[0xff],NULL);
    map_intensity[7] = XtVaCreateManagedWidget("70%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"70%",XmNbackground,colors[0xff],NULL);
    map_intensity[8] = XtVaCreateManagedWidget("80%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"80%",XmNbackground,colors[0xff],NULL);
    map_intensity[9] = XtVaCreateManagedWidget("90%",xmPushButtonGadgetClass,Map_intensity_Pane,
                        XmNmnemonic,"90%",XmNbackground,colors[0xff],NULL);
    map_intensity[10] = XtVaCreateManagedWidget("100%",xmPushButtonGadgetClass,Map_intensity_Pane,
                            XmNmnemonic,"100%",XmNbackground,colors[0xff],NULL);
#endif  /* USE_GEOTIFF */

    Map_station_label_Pane = XmCreatePulldownMenu(mappane,"map_station_label",al,ac);
    map_station_label_button = XtVaCreateManagedWidget(langcode("PULDNMP006"),xmCascadeButtonWidgetClass,mappane,
                                    XmNsubMenuId, Map_station_label_Pane,XmNmnemonic,langcode_hotkey("PULDNMP006"),
                                    XmNbackground,colors[0xff],NULL);
    map_station_label0 = XtVaCreateManagedWidget(langcode("PULDNMSL01"),xmPushButtonGadgetClass,Map_station_label_Pane,
                                XmNmnemonic,langcode_hotkey("PULDNSLC01"),XmNbackground,colors[0xff],NULL);
    map_station_label1 = XtVaCreateManagedWidget(langcode("PULDNMSL02"),xmPushButtonGadgetClass,Map_station_label_Pane,
                                XmNmnemonic,langcode_hotkey("PULDNMSL02"),XmNbackground,colors[0xff],NULL);

    Map_wx_alerts_Pane = XmCreatePulldownMenu(mappane,"map_wx_alerts",al,ac);
    map_wx_alerts_button = XtVaCreateManagedWidget(langcode("PULDNMP007"),xmCascadeButtonWidgetClass,mappane,
                                XmNsubMenuId, Map_wx_alerts_Pane,XmNmnemonic,langcode_hotkey("PULDNMP007"),
                                XmNbackground,colors[0xff],NULL);
    map_wx_alerts_0 = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,Map_wx_alerts_Pane,
                            XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    map_wx_alerts_1 = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,Map_wx_alerts_Pane,
                            XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    /* Display */
    track_button = XtVaCreateManagedWidget(langcode("PULDNDP001"),xmPushButtonGadgetClass,displaypane,
                        XmNmnemonic,langcode_hotkey("PULDNDP001"),XmNbackground,colors[0xff],NULL);
    (void)XtVaCreateManagedWidget("sep3",xmSeparatorGadgetClass,displaypane,XmNbackground,colors[0xff],NULL);
    call_pane = XmCreatePulldownMenu(displaypane,"callpane",al,ac);
    call_button = XtVaCreateManagedWidget(langcode("PULDNDP010"),xmCascadeButtonWidgetClass,displaypane,
                        XmNsubMenuId,call_pane,XmNmnemonic,langcode_hotkey("PULDNDP010"),XmNbackground,colors[0xff],NULL);
    call_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,call_pane,
                        XmNbackground,colors[0xff],NULL);
    call_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,call_pane,
                        XmNbackground,colors[0xff],NULL);

    alt_pane = XmCreatePulldownMenu(displaypane,"Altitudepane",al,ac);
    alt_button = XtVaCreateManagedWidget(langcode("PULDNDP002"),xmCascadeButtonWidgetClass,displaypane,
                    XmNsubMenuId,alt_pane,XmNmnemonic,langcode_hotkey("PULDNDP002"),XmNbackground,colors[0xff],NULL);
    alt_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,alt_pane,XmNbackground,colors[0xff],NULL);
    alt_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,alt_pane,XmNbackground,colors[0xff],NULL);

    course_pane = XmCreatePulldownMenu(displaypane,"Coursepane",al,ac);
    course_button = XtVaCreateManagedWidget(langcode("PULDNDP003"),xmCascadeButtonWidgetClass,displaypane,
                        XmNsubMenuId,course_pane,XmNmnemonic,langcode_hotkey("PULDNDP003"),XmNbackground,colors[0xff],NULL);
    course_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,course_pane,
                        XmNbackground,colors[0xff],NULL);
    course_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,course_pane,
                        XmNbackground,colors[0xff],NULL);

    speed_pane = XmCreatePulldownMenu(displaypane,"speedpane",al,ac);
    speed_button = XtVaCreateManagedWidget(langcode("PULDNDP004"),xmCascadeButtonWidgetClass,displaypane,
                        XmNsubMenuId,speed_pane,XmNmnemonic,langcode_hotkey("PULDNDP004"),XmNbackground,colors[0xff],NULL);
    speed_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,speed_pane,
                        XmNbackground,colors[0xff],NULL);
    speed_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,speed_pane,
                        XmNbackground,colors[0xff],NULL);

    dist_course_pane = XmCreatePulldownMenu(displaypane,"my_dist_coursepane",al,ac);
    dist_course_button = XtVaCreateManagedWidget(langcode("PULDNDP005"),xmCascadeButtonWidgetClass,displaypane,
                            XmNsubMenuId,dist_course_pane,XmNmnemonic,langcode_hotkey("PULDNDP005"),
                            XmNbackground,colors[0xff],NULL);
    dist_course_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,dist_course_pane,
                            XmNbackground,colors[0xff],NULL);
    dist_course_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,dist_course_pane,
                            XmNbackground,colors[0xff],NULL);

    station_trails_pane = XmCreatePulldownMenu(displaypane,"station_trails",al,ac);
    station_trails_button = XtVaCreateManagedWidget(langcode("PULDNDP007"),xmCascadeButtonWidgetClass,displaypane,
                                XmNsubMenuId,station_trails_pane,XmNmnemonic,langcode_hotkey("PULDNDP007"),
                                XmNbackground,colors[0xff],NULL);
    trails_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,station_trails_pane,
                        XmNbackground,colors[0xff],NULL);
    trails_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,station_trails_pane,
                        XmNbackground,colors[0xff],NULL);

    station_phg_pane = XmCreatePulldownMenu(displaypane,"station_phg",al,ac);
    station_phg_button = XtVaCreateManagedWidget(langcode("PULDNDP008"),xmCascadeButtonWidgetClass,displaypane,
                                XmNsubMenuId,station_phg_pane,XmNmnemonic,langcode_hotkey("PULDNDP008"),
                                XmNbackground,colors[0xff],NULL);
    phg_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,station_phg_pane,
                    XmNbackground,colors[0xff],NULL);
    phg_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,station_phg_pane,
                    XmNbackground,colors[0xff],NULL);

    wx_pane = XmCreatePulldownMenu(displaypane,"station_wx",al,ac);
    wx_button = XtVaCreateManagedWidget(langcode("PULDNDP009"),xmCascadeButtonWidgetClass,displaypane,
                    XmNsubMenuId,wx_pane,XmNmnemonic,langcode_hotkey("PULDNDP009"),XmNbackground,colors[0xff],NULL);
    wx_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,wx_pane,
                    XmNbackground,colors[0xff],NULL);
    wx_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,wx_pane,
                    XmNbackground,colors[0xff],NULL);

    symbols_pane = XmCreatePulldownMenu(displaypane,"Symbolspane",al,ac);
    symbols_button = XtVaCreateManagedWidget(langcode("PULDNDP012"),xmCascadeButtonWidgetClass,displaypane,
                    XmNsubMenuId,symbols_pane,XmNmnemonic,langcode_hotkey("PULDNDP012"),XmNbackground,colors[0xff],NULL);
    symbols_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,symbols_pane,XmNbackground,colors[0xff],NULL);
    symbols_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,symbols_pane,XmNbackground,colors[0xff],NULL);


    symrot_pane = XmCreatePulldownMenu(displaypane,"SymbRotpane",al,ac);
    symrot_button = XtVaCreateManagedWidget(langcode("PULDNDP011"),xmCascadeButtonWidgetClass,displaypane,
                    XmNsubMenuId,symrot_pane,XmNmnemonic,langcode_hotkey("PULDNDP011"),XmNbackground,colors[0xff],NULL);
    symrot_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,symrot_pane,XmNbackground,colors[0xff],NULL);
    symrot_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,symrot_pane,XmNbackground,colors[0xff],NULL);

    /* Messages */
    send_message_to_button = XtVaCreateManagedWidget(langcode("PULDNMG001"),xmPushButtonGadgetClass,messagepane,
                                XmNmnemonic,langcode_hotkey("PULDNMG001"),XmNbackground,colors[0xff],NULL);
    open_messages_group_button = XtVaCreateManagedWidget(langcode("PULDNMG002"),xmPushButtonGadgetClass,messagepane,
                                    XmNmnemonic,langcode_hotkey("PULDNMG002"),XmNbackground,colors[0xff],NULL);
    clear_messages_button= XtVaCreateManagedWidget(langcode("PULDNMG003"),xmPushButtonGadgetClass,messagepane,
                                XmNmnemonic,langcode_hotkey("PULDNMG003"),XmNbackground,colors[0xff],NULL);
    (void)XtVaCreateManagedWidget("sep4",xmSeparatorGadgetClass,messagepane,XmNbackground,colors[0xff],NULL);
    auto_msg_set_button = XtVaCreateManagedWidget(langcode("PULDNMG004"),xmPushButtonGadgetClass,messagepane,
                                XmNmnemonic,langcode_hotkey("PULDNMG004"),XmNbackground,colors[0xff],NULL);

    auto_msg_pane = XmCreatePulldownMenu(messagepane,"auto_msg",al,ac);
    auto_msg_button = XtVaCreateManagedWidget(langcode("PULDNMG005"),xmCascadeButtonWidgetClass,messagepane,
                            XmNsubMenuId,auto_msg_pane,XmNmnemonic,langcode_hotkey("PULDNMG005"),
                            XmNbackground,colors[0xff],NULL);
    auto_msg_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonWidgetClass,auto_msg_pane,
                        XmNbackground,colors[0xff],NULL);
    auto_msg_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonWidgetClass,auto_msg_pane,
                        XmNbackground,colors[0xff],NULL);

    /* Interface */
    iface_transmit_now = XtVaCreateManagedWidget(langcode("PULDNTNC01"),xmPushButtonGadgetClass,ifacepane,
                            XmNmnemonic,langcode_hotkey("PULDNTNC01"),XmNbackground,colors[0xff],NULL);
    iface_connect_button = XtVaCreateManagedWidget(langcode("PULDNTNT04"),xmPushButtonGadgetClass,ifacepane,
                            XmNmnemonic,langcode_hotkey("PULDNTNT04"),XmNbackground,colors[0xff],NULL);

    (void)XtVaCreateManagedWidget("sep5",xmSeparatorGadgetClass,ifacepane,XmNbackground,colors[0xff],NULL);

    tnc_logging_pane = XmCreatePulldownMenu(ifacepane,"tnc_logging_pane",al,ac);
    tnc_logging = XtVaCreateManagedWidget(langcode("PULDNTNT02"),xmCascadeButtonWidgetClass,ifacepane,
                        XmNsubMenuId, tnc_logging_pane,XmNmnemonic,langcode_hotkey("PULDNTNT02"),XmNbackground,colors[0xff],NULL);
    tnc_logging_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,tnc_logging_pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    tnc_logging_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,tnc_logging_pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    net_logging_pane = XmCreatePulldownMenu(ifacepane,"net_logging_pane",al,ac);
    net_logging = XtVaCreateManagedWidget(langcode("PULDNTNT03"),xmCascadeButtonWidgetClass,ifacepane,
                        XmNsubMenuId, net_logging_pane,XmNmnemonic,langcode_hotkey("PULDNTNT03"),XmNbackground,colors[0xff],NULL);
    net_logging_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,net_logging_pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    net_logging_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,net_logging_pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    igate_logging_pane = XmCreatePulldownMenu(ifacepane,"igate_logging_pane",al,ac);
    igate_logging = XtVaCreateManagedWidget(langcode("PULDNTNT05"),xmCascadeButtonWidgetClass,ifacepane,
                        XmNsubMenuId, igate_logging_pane,XmNmnemonic,langcode_hotkey("PULDNTNT05"),XmNbackground,colors[0xff],NULL);
    igate_logging_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,igate_logging_pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    igate_logging_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,igate_logging_pane,
                        XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    wx_logging_pane = XmCreatePulldownMenu(ifacepane,"wx_logging_pane",al,ac);
    wx_logging = XtVaCreateManagedWidget(langcode("PULDNTNT06"),xmCascadeButtonWidgetClass,ifacepane,
                    XmNsubMenuId, wx_logging_pane,XmNmnemonic,langcode_hotkey("PULDNTNT06"),XmNbackground,colors[0xff],NULL);
    wx_logging_on = XtVaCreateManagedWidget(langcode("PULDNOT001"),xmPushButtonGadgetClass,wx_logging_pane,
                    XmNmnemonic,langcode_hotkey("PULDNOT001"),XmNbackground,colors[0xff],NULL);
    wx_logging_off = XtVaCreateManagedWidget(langcode("PULDNOT002"),xmPushButtonGadgetClass,wx_logging_pane,
                    XmNmnemonic,langcode_hotkey("PULDNOT002"),XmNbackground,colors[0xff],NULL);

    /* Help*/
    help_about = XtVaCreateManagedWidget(langcode("PULDNHEL01"),xmPushButtonGadgetClass,helppane,
                    XmNmnemonic,langcode_hotkey("PULDNHEL01"),XmNbackground,colors[0xff],NULL);
    help_help = XtVaCreateManagedWidget(langcode("PULDNHEL02"),xmPushButtonGadgetClass,helppane,
                    XmNmnemonic,langcode_hotkey("PULDNHEL02"),XmNbackground,colors[0xff],NULL);

    /* view */
    XtAddCallback(stations_button,      XmNactivateCallback,Station_List,"0");
    XtAddCallback(mobile_button,        XmNactivateCallback,Station_List,"1");
    XtAddCallback(weather_button,       XmNactivateCallback,Station_List,"2");
    XtAddCallback(localstations_button, XmNactivateCallback,Station_List,"3");
    XtAddCallback(laststations_button,  XmNactivateCallback,Station_List,"4");

    /* button callbacks */
    XtAddCallback(General_q_button,     XmNactivateCallback,General_query,"");
    XtAddCallback(IGate_q_button,       XmNactivateCallback,IGate_query,NULL);
    XtAddCallback(WX_q_button,          XmNactivateCallback,WX_query,NULL);
    XtAddCallback(station_clear_button, XmNactivateCallback,Stations_Clear,NULL);
    XtAddCallback(tracks_clear_button,  XmNactivateCallback,Tracks_All_Clear,NULL);
    XtAddCallback(exit_button,          XmNactivateCallback,Menu_Quit,NULL);
    on_off_switch(long_lat_grid,grid_on,grid_off);
    XtAddCallback(grid_on,              XmNactivateCallback,Grid_on,NULL);
    XtAddCallback(grid_off,             XmNactivateCallback,Grid_off,NULL);
    on_off_switch(map_auto_maps,map_auto_on,map_auto_off);
    XtAddCallback(map_auto_on,          XmNactivateCallback,Map_auto_on,NULL);
    XtAddCallback(map_auto_off,         XmNactivateCallback,Map_auto_off,NULL);
    XtAddCallback(map_chooser_button,   XmNactivateCallback,Map_chooser,NULL);

    on_off_switch(map_color_levels,map_levels_on,map_levels_off);
    XtAddCallback(map_levels_on,        XmNactivateCallback,Map_levels_on,NULL);
    XtAddCallback(map_levels_off,       XmNactivateCallback,Map_levels_off,NULL);

    on_off_switch(map_color_fill,map_fill_on,map_fill_off);
    XtAddCallback(map_fill_on, XmNactivateCallback,Map_fill_on,NULL);
    XtAddCallback(map_fill_off, XmNactivateCallback,Map_fill_off,NULL);

    XtSetSensitive(map_bgcolor[map_background_color],FALSE);
    XtAddCallback(map_bgcolor[10], XmNactivateCallback,Map_background,"10");
    XtAddCallback(map_bgcolor[0],  XmNactivateCallback,Map_background,"0");
    XtAddCallback(map_bgcolor[1],  XmNactivateCallback,Map_background,"1");
    XtAddCallback(map_bgcolor[2],  XmNactivateCallback,Map_background,"2");
    XtAddCallback(map_bgcolor[3],  XmNactivateCallback,Map_background,"3");
    XtAddCallback(map_bgcolor[4],  XmNactivateCallback,Map_background,"4");
    XtAddCallback(map_bgcolor[5],  XmNactivateCallback,Map_background,"5");
    XtAddCallback(map_bgcolor[6],  XmNactivateCallback,Map_background,"6");
    XtAddCallback(map_bgcolor[7],  XmNactivateCallback,Map_background,"7");
    XtAddCallback(map_bgcolor[8],  XmNactivateCallback,Map_background,"8");
    XtAddCallback(map_bgcolor[9],  XmNactivateCallback,Map_background,"9");

#ifdef USE_GEOTIFF
    XtSetSensitive(map_intensity[(int)(geotiff_map_intensity * 10.0)],FALSE);
    XtAddCallback(map_intensity[0],  XmNactivateCallback,Map_intensity,"0.0");
    XtAddCallback(map_intensity[1],  XmNactivateCallback,Map_intensity,"0.1");
    XtAddCallback(map_intensity[2],  XmNactivateCallback,Map_intensity,"0.2");
    XtAddCallback(map_intensity[3],  XmNactivateCallback,Map_intensity,"0.3");
    XtAddCallback(map_intensity[4],  XmNactivateCallback,Map_intensity,"0.4");
    XtAddCallback(map_intensity[5],  XmNactivateCallback,Map_intensity,"0.5");
    XtAddCallback(map_intensity[6],  XmNactivateCallback,Map_intensity,"0.6");
    XtAddCallback(map_intensity[7],  XmNactivateCallback,Map_intensity,"0.7");
    XtAddCallback(map_intensity[8],  XmNactivateCallback,Map_intensity,"0.8");
    XtAddCallback(map_intensity[9],  XmNactivateCallback,Map_intensity,"0.9");
    XtAddCallback(map_intensity[10], XmNactivateCallback,Map_intensity,"1.0");
#endif /* USE_GEOTIFF */

    on_off_switch(letter_style,map_station_label1,map_station_label0);
    XtAddCallback(map_station_label0,   XmNactivateCallback,Map_station_label,"0");
    XtAddCallback(map_station_label1,   XmNactivateCallback,Map_station_label,"1");
    on_off_switch(wx_alert_style,map_wx_alerts_1,map_wx_alerts_0);
    XtAddCallback(map_wx_alerts_0,      XmNactivateCallback,Map_wx_alerts,"0");
    XtAddCallback(map_wx_alerts_1,      XmNactivateCallback,Map_wx_alerts,"1");

    XtAddCallback(defaults_button,      XmNactivateCallback,Configure_defaults,NULL);
    XtAddCallback(aa_button,            XmNactivateCallback,Configure_audio_alarms,NULL);
    XtAddCallback(speech_button,        XmNactivateCallback,Configure_speech,NULL);
    XtAddCallback(station_button,       XmNactivateCallback,Configure_station,NULL);

    XtAddCallback(help_about,           XmNactivateCallback,Help_About,NULL);
    XtAddCallback(help_help,            XmNactivateCallback,Help_Index,NULL);

    /* Interface */
    XtAddCallback(device_config_button, XmNactivateCallback,Configure_interface,NULL);

    /* TNC */
    XtAddCallback(iface_transmit_now,   XmNactivateCallback,TNC_Transmit_now,NULL);
    on_off_switch(log_tnc_data,tnc_logging_on,tnc_logging_off);
    XtAddCallback(tnc_logging_on,       XmNactivateCallback,TNC_Logging_on,NULL);
    XtAddCallback(tnc_logging_off,      XmNactivateCallback,TNC_Logging_off,NULL);

    /* NET */
    on_off_switch(log_net_data,net_logging_on,net_logging_off);
    XtAddCallback(net_logging_on,       XmNactivateCallback,Net_Logging_on,NULL);
    XtAddCallback(net_logging_off,      XmNactivateCallback,Net_Logging_off,NULL);

    /* igate */
    on_off_switch(log_igate,igate_logging_on,igate_logging_off);
    XtAddCallback(igate_logging_on,     XmNactivateCallback,IGate_Logging_on,NULL);
    XtAddCallback(igate_logging_off,    XmNactivateCallback,IGate_Logging_off,NULL);

    /* igate */
    on_off_switch(log_wx,wx_logging_on,wx_logging_off);
    XtAddCallback(wx_logging_on,        XmNactivateCallback,WX_Logging_on,NULL);
    XtAddCallback(wx_logging_off,       XmNactivateCallback,WX_Logging_off,NULL);

    /* Display */
    on_off_switch(symbol_callsign_display,call_on,call_off);
    XtAddCallback(call_on,              XmNactivateCallback,Call_on,NULL);
    XtAddCallback(call_off,             XmNactivateCallback,Call_off,NULL);
    on_off_switch(symbol_alt_display,alt_on,alt_off);
    XtAddCallback(alt_on,               XmNactivateCallback,Alt_on,NULL);
    XtAddCallback(alt_off,              XmNactivateCallback,Alt_off,NULL);
    on_off_switch(symbol_course_display,course_on,course_off);
    XtAddCallback(course_on,            XmNactivateCallback,Course_on,NULL);
    XtAddCallback(course_off,           XmNactivateCallback,Course_off,NULL);

    on_off_switch(symbol_speed_display,speed_on,speed_off);
    XtAddCallback(speed_on,             XmNactivateCallback,Speed_on,NULL);
    XtAddCallback(speed_off,            XmNactivateCallback,Speed_off,NULL);
    on_off_switch(symbol_dist_course_display,dist_course_on,dist_course_off);
    XtAddCallback(dist_course_on,       XmNactivateCallback,Dist_course_on,NULL);
    XtAddCallback(dist_course_off,      XmNactivateCallback,Dist_course_off,NULL);

    on_off_switch(units_english_metric,units_choice_on,units_choice_off);
    XtAddCallback(units_choice_on,      XmNactivateCallback,Units_choice_on,NULL);
    XtAddCallback(units_choice_off,     XmNactivateCallback,Units_choice_off,NULL);

    on_off_switch(station_trails,trails_on,trails_off);
    XtAddCallback(trails_on,            XmNactivateCallback,Station_trails_on,NULL);
    XtAddCallback(trails_off,           XmNactivateCallback,Station_trails_off,NULL);

    on_off_switch(show_phg,phg_on,phg_off);
    XtAddCallback(phg_on,               XmNactivateCallback,Station_phg_on,NULL);
    XtAddCallback(phg_off,              XmNactivateCallback,Station_phg_off,NULL);

    XtAddCallback(track_button,         XmNactivateCallback,Track_station,NULL);

    on_off_switch(symbol_weather_display,wx_on,wx_off);
    XtAddCallback(wx_on,                XmNactivateCallback,WX_on,NULL);
    XtAddCallback(wx_off,               XmNactivateCallback,WX_off,NULL);

    on_off_switch(symbol_display,symbols_on,symbols_off);
    XtAddCallback(symbols_on,           XmNactivateCallback,Symbols_on, NULL);
    XtAddCallback(symbols_off,          XmNactivateCallback,Symbols_off,NULL);

    on_off_switch(symbol_rotate,symrot_on,symrot_off);
    XtAddCallback(symrot_on,            XmNactivateCallback,Sym_rot_on, NULL);
    XtAddCallback(symrot_off,           XmNactivateCallback,Sym_rot_off,NULL);

    on_off_switch(auto_reply,auto_msg_on,auto_msg_off);
    XtAddCallback(auto_msg_on,          XmNactivateCallback,Auto_msg_on,NULL);
    XtAddCallback(auto_msg_off,         XmNactivateCallback,Auto_msg_off,NULL);
    XtAddCallback(auto_msg_set_button,XmNactivateCallback,Auto_msg_set,NULL);

    XtAddCallback(iface_connect_button, XmNactivateCallback,control_interface,NULL);

    XtAddCallback(open_file_button,     XmNactivateCallback,Read_File_Selection,NULL);

    XtAddCallback(bullet_button,        XmNactivateCallback,Bulletins,NULL);
    XtAddCallback(packet_data_button,   XmNactivateCallback,Display_data,NULL);
    XtAddCallback(locate_button,        XmNactivateCallback,Locate_station,NULL);
    XtAddCallback(alert_button,         XmNactivateCallback,Display_Wx_Alert,NULL);
    XtAddCallback(view_messages_button, XmNactivateCallback,view_all_messages,NULL);
    XtAddCallback(wx_station_button,    XmNactivateCallback,WX_station,NULL);
    XtAddCallback(jump_button,          XmNactivateCallback, Jump_location, NULL);

    XtAddCallback(send_message_to_button,       XmNactivateCallback,Send_message,NULL);
    XtAddCallback(open_messages_group_button,   XmNactivateCallback,Send_message,"*");
    XtAddCallback(clear_messages_button,        XmNactivateCallback,Clear_messages,NULL);
    XtAddCallback(save_button,                  XmNactivateCallback,Save_Config,NULL);
#if DEBUG_TEST
    XtAddCallback(test_button,          XmNactivateCallback,Test,NULL);
#else // DEBUG_TEST
    XtAddCallback(test_button,          XmNactivateCallback,NULL,NULL);
    XtSetSensitive(test_button, FALSE);
#endif // DEBUG_TEST

#define FONT_WIDTH 9

    /* Create bottom text area */
    text = XtVaCreateManagedWidget("text_output", xmTextFieldWidgetClass, form,
                                XmNeditable,            FALSE,
                                XmNcursorPositionVisible, FALSE,
                                XmNsensitive,           STIPPLE,
                                XmNshadowThickness,     1,
                                XmNcolumns,             30,
                                XmNwidth,               ((30*FONT_WIDTH)+2),
                                XmNbackground,          colors[0xff],
                                XmNtopOffset,           4,
                                XmNtopAttachment,       XmATTACH_NONE,
                                XmNbottomAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,      XmATTACH_FORM,
                                XmNrightAttachment,     XmATTACH_NONE,
                                XmNbackground,          colors[0xff],
                                NULL);

    text2 = XtVaCreateManagedWidget("text_output2", xmTextFieldWidgetClass, form,
                                XmNeditable,            FALSE,
                                XmNcursorPositionVisible, FALSE,
                                XmNsensitive,           STIPPLE,
                                XmNshadowThickness,     1,
                                XmNcolumns,             21,
                                XmNwidth,               ((21*FONT_WIDTH)+2),
                                XmNbackground,          colors[0xff],
                                XmNtopAttachment,       XmATTACH_NONE,
                                XmNbottomAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,      XmATTACH_WIDGET,
                                XmNleftWidget,          text,
                                XmNrightAttachment,     XmATTACH_NONE,
                                XmNbackground,          colors[0xff],
                                NULL);

    text3 = XtVaCreateManagedWidget("text_output3", xmTextFieldWidgetClass, form,
                                XmNeditable,            FALSE,
                                XmNcursorPositionVisible, FALSE,
                                XmNsensitive,           STIPPLE,
                                XmNshadowThickness,     1,
                                XmNcolumns,             14,
                                XmNwidth,               ((14*FONT_WIDTH)+2),
                                XmNbackground,          colors[0xff],
                                XmNtopAttachment,       XmATTACH_NONE,
                                XmNbottomAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,      XmATTACH_WIDGET,
                                XmNleftWidget,          text2,
                                XmNrightAttachment,     XmATTACH_NONE,
                                XmNbackground,          colors[0xff],
                                NULL);

    text4 = XtVaCreateManagedWidget("text_output4", xmTextFieldWidgetClass, form,
                                XmNeditable,            FALSE,
                                XmNcursorPositionVisible, FALSE,
                                XmNsensitive,           STIPPLE,
                                XmNshadowThickness,     1,
                                XmNcolumns,             12,
                                XmNwidth,               ((12*FONT_WIDTH)+2),
                                XmNbackground,          colors[0xff],
                                XmNtopAttachment,       XmATTACH_NONE,
                                XmNbottomAttachment,    XmATTACH_FORM,
                                XmNleftAttachment,      XmATTACH_WIDGET,
                                XmNleftWidget,          text3,
                                XmNrightAttachment,     XmATTACH_NONE,
                                XmNbackground,          colors[0xff],
                                NULL);

    iface_da = XtVaCreateManagedWidget("iface", xmDrawingAreaWidgetClass,form,
                                XmNwidth,               20*(MAX_IFACE_DEVICES/2),
                                XmNheight,              20,
                                XmNunitType,            XmPIXELS,
                                XmNtopAttachment,       XmATTACH_NONE,
                                XmNbottomAttachment,    XmATTACH_FORM,
                                XmNbottomOffset,        5,
                                XmNleftAttachment,      XmATTACH_WIDGET,
                                XmNleftWidget,          text4,
                                XmNrightAttachment,     XmATTACH_NONE,
                                XmNbackground,          colors[0xff],
                                NULL);

    sep = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass,form,
                                XmNorientation,         XmHORIZONTAL,
                                XmNtopAttachment,       XmATTACH_NONE,
                                XmNbottomAttachment,    XmATTACH_WIDGET,
                                XmNbottomWidget,        text,
                                XmNleftAttachment,      XmATTACH_FORM,
                                XmNrightAttachment,     XmATTACH_FORM,
                                XmNbackground,          colors[0xff],
                                NULL);

    /* Do drawing map area */
    da = XtVaCreateManagedWidget("da", xmDrawingAreaWidgetClass,form,
                                XmNwidth,               screen_width,
                                XmNheight,              screen_height,
                                XmNunitType,            XmPIXELS,
                                XmNtopAttachment,       XmATTACH_WIDGET,
                                XmNtopWidget,           menubar,
                                XmNbottomAttachment,    XmATTACH_WIDGET,
                                XmNbottomWidget,        sep,
                                XmNleftAttachment,      XmATTACH_FORM,
                                XmNrightAttachment,     XmATTACH_FORM,
                                XmNbackground,          colors[0xff],
                                NULL);



    // Left menu popup (left mouse button or button 1)
    left_menu_popup = XmCreatePopupMenu(da,"Menu Popup",al,ac);
    XtVaSetValues(left_menu_popup, XmNwhichButton, 1, NULL);
    // "Options"
    (void)XtCreateManagedWidget(langcode("POPUPMA001"),xmLabelWidgetClass,left_menu_popup,al,ac);
    (void)XtCreateManagedWidget("sep",xmSeparatorWidgetClass,left_menu_popup,al,ac);

    // "Center"
    pan_ctr=XtCreateManagedWidget(langcode("POPUPMA00c"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    XtAddCallback(pan_ctr,XmNactivateCallback,Pan_ctr,NULL);

    // "Station info"
    station_info=XtCreateManagedWidget(langcode("POPUPMA015"),xmPushButtonGadgetClass,left_menu_popup,NULL,0);
    XtAddCallback(station_info,XmNactivateCallback,Station_info,NULL);

    // Zoom in"
    zoom_in=XtCreateManagedWidget(langcode("POPUPMA002"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    XtAddCallback(zoom_in,XmNactivateCallback,Zoom_in,NULL);

    // Zoom out" 
    zoom_out=XtCreateManagedWidget(langcode("POPUPMA003"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    XtAddCallback(zoom_out,XmNactivateCallback,Zoom_out,NULL);

    // "Zoom level"
    zoom_sub=XmCreatePulldownMenu(left_menu_popup,"zoom sub",al,ac);
    zoom_level=XtVaCreateManagedWidget(langcode("POPUPMA004"),xmCascadeButtonGadgetClass,left_menu_popup,
    XmNsubMenuId,zoom_sub,XmNbackground,colors[0xff],NULL);

    // "1"
    zl1=XtCreateManagedWidget(langcode("POPUPMA005"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl1,XmNactivateCallback,Zoom_level,"1");
    // "16"
    zl2=XtCreateManagedWidget(langcode("POPUPMA006"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl2,XmNactivateCallback,Zoom_level,"2");
    // "64"
    zl3=XtCreateManagedWidget(langcode("POPUPMA007"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl3,XmNactivateCallback,Zoom_level,"3");
    // "256"
    zl4=XtCreateManagedWidget(langcode("POPUPMA008"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl4,XmNactivateCallback,Zoom_level,"4");
    // "1024"
    zl5=XtCreateManagedWidget(langcode("POPUPMA009"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl5,XmNactivateCallback,Zoom_level,"5");
    // "8192"
    zl6=XtCreateManagedWidget(langcode("POPUPMA010"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl6,XmNactivateCallback,Zoom_level,"6");
    // Entire World"
    zl7=XtCreateManagedWidget(langcode("POPUPMA017"),xmPushButtonGadgetClass,zoom_sub,al,ac);
    XtAddCallback(zl7,XmNactivateCallback,Zoom_level,"7");

    // "Last map pos/zoom"
    last_loc=XtCreateManagedWidget(langcode("POPUPMA016"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    XtAddCallback(last_loc,XmNactivateCallback,Last_location,NULL);

    // "Object"
    set_object=XtCreateManagedWidget(langcode("POPUPMA018"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    XtAddCallback(set_object,XmNactivateCallback,Set_Del_Object,NULL);

/*
    XtCreateManagedWidget("sep",xmSeparatorWidgetClass,left_menu_popup,al,ac);

    //pan_up=XtCreateManagedWidget(langcode("POPUPMA011"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    pan_up=XtVaCreateManagedWidget("arrow1",xmArrowButtonGadgetClass, left_menu_popup,
        XmNarrowDirection,  XmARROW_UP,
        NULL);
    XtAddCallback(pan_up,XmNactivateCallback,Pan_up,NULL);

    //pan_left=XtCreateManagedWidget(langcode("POPUPMA013"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    pan_left=XtVaCreateManagedWidget("arrow3",xmArrowButtonGadgetClass, left_menu_popup,
        XmNarrowDirection,  XmARROW_LEFT,
        NULL);
    XtAddCallback(pan_left,XmNactivateCallback,Pan_left,NULL);

    //pan_right=XtCreateManagedWidget(langcode("POPUPMA014"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    pan_right=XtVaCreateManagedWidget("arrow4",xmArrowButtonGadgetClass, left_menu_popup,
        XmNarrowDirection,  XmARROW_RIGHT,
        NULL);
    XtAddCallback(pan_right,XmNactivateCallback,Pan_right,NULL);

    //pan_down=XtCreateManagedWidget(langcode("POPUPMA012"),xmPushButtonGadgetClass,left_menu_popup,al,ac);
    pan_down=XtVaCreateManagedWidget("arrow2",xmArrowButtonGadgetClass, left_menu_popup,
        XmNarrowDirection,  XmARROW_DOWN,
        NULL);
    XtAddCallback(pan_down,XmNactivateCallback,Pan_down,NULL);
*/





    /* mouse tracking */
    XtAddEventHandler(da,LeaveWindowMask,FALSE,ClearTrackMouse,(XtPointer)text2);
    XtAddEventHandler(da,PointerMotionMask,FALSE,TrackMouse,(XtPointer)text2);

    ac = 0;
    children[ac++] = text;
    children[ac++] = text2;
    children[ac++] = menubar;
    children[ac++] = da;

    XtManageChildren(children, ac);
    ac = 0;
    XtManageChild(form);

    WM_DELETE_WINDOW = XmInternAtom(XtDisplay(appshell),"WM_DELETE_WINDOW", FALSE);
    XmAddWMProtocolCallback(appshell, WM_DELETE_WINDOW, Window_Quit, (XtPointer) NULL);

    XmTextFieldSetString(text,"");
    XtManageChild(text);

    display_zoom_status();

    XtManageChild(text);

    (void)XtCreateManagedWidget("MAIN",xmMainWindowWidgetClass,appshell,NULL,0);

    XtRealizeWidget (appshell);
    XtVaSetValues(appshell,XmNx,1,XmNy,1,NULL);
    XtPopup(appshell,XtGrabNone);

    create_gc(da);
    (void)XSetForeground(XtDisplay(da),gc,colors[0xff]);
    (void)XSetBackground(XtDisplay(da),gc,colors[0xff]);

    (void)XFillRectangle(XtDisplay(appshell),XtWindow(da),gc,0,0,screen_width,screen_height);

    XtVaSetValues(appshell,
                XmNwidth,       screen_width,
                XmNheight,      (screen_height+60+2),   // DK7IN: added 2 because height had been smaller everytime
                NULL);

    XtAddCallback (da, XmNinputCallback,  da_input,NULL);
    XtAddCallback (da, XmNresizeCallback, da_resize,NULL);
    XtAddCallback (da, XmNexposeCallback, da_expose,(XtPointer)text);
    UpdateTime( (XtPointer) da , (XtIntervalId) NULL );

    if(debug_level & 8)
        printf("Create appshell stop\n");
}



void create_gc(Widget w) {
    XGCValues values;
    Display *my_display = XtDisplay(w);
    int mask = 0;
    Pixmap pix;

    if (debug_level & 8)
        printf("Create gc start\n");

    if (gc != 0)
        return;

    /* Allocate colors */
    colors[0x00] = (int)GetPixelByName(w,"DarkGreen");  // was darkgreen (same)
    colors[0x01] = (int)GetPixelByName(w,"purple");
    colors[0x02] = (int)GetPixelByName(w,"DarkGreen");  // was darkgreen (same)
    colors[0x03] = (int)GetPixelByName(w,"cyan");
    colors[0x04] = (int)GetPixelByName(w,"brown");
    colors[0x05] = (int)GetPixelByName(w,"plum");       // light magenta
    colors[0x06] = (int)GetPixelByName(w,"orange");
    colors[0x07] = (int)GetPixelByName(w,"darkgray");
    colors[0x08] = (int)GetPixelByName(w,"black");
    colors[0x09] = (int)GetPixelByName(w,"blue");
    colors[0x0a] = (int)GetPixelByName(w,"green");              // PHG (old)
    colors[0x0b] = (int)GetPixelByName(w,"mediumorchid"); // light purple
    colors[0x0c] = (int)GetPixelByName(w,"red");
    colors[0x0d] = (int)GetPixelByName(w,"magenta");
    colors[0x0e] = (int)GetPixelByName(w,"yellow");
    colors[0x0f] = (int)GetPixelByName(w,"white");              // 
    colors[0x10] = (int)GetPixelByName(w,"black");
    colors[0x11] = (int)GetPixelByName(w,"black");
    colors[0x12] = (int)GetPixelByName(w,"black");
    colors[0x13] = (int)GetPixelByName(w,"black");
    colors[0x14] = (int)GetPixelByName(w,"lightgray");
    colors[0x15] = (int)GetPixelByName(w,"magenta");
    colors[0x16] = (int)GetPixelByName(w,"mediumorchid"); // light purple
    colors[0x17] = (int)GetPixelByName(w,"lightblue");
    colors[0x18] = (int)GetPixelByName(w,"purple");
    colors[0x19] = (int)GetPixelByName(w,"orange2");    // light orange
    colors[0x20] = (int)GetPixelByName(w,"white");

    colors[0x40] = (int)GetPixelByName(w,"yellow");     // symbols ...
    colors[0x41] = (int)GetPixelByName(w,"DarkOrange3");
    colors[0x42] = (int)GetPixelByName(w,"purple");
    colors[0x43] = (int)GetPixelByName(w,"gray80");
    colors[0x44] = (int)GetPixelByName(w,"red3");
    colors[0x45] = (int)GetPixelByName(w,"brown1");
    colors[0x46] = (int)GetPixelByName(w,"brown3");
    colors[0x47] = (int)GetPixelByName(w,"blue4");
    colors[0x48] = (int)GetPixelByName(w,"DeepSkyBlue");
    colors[0x49] = (int)GetPixelByName(w,"DarkGreen");
    colors[0x4a] = (int)GetPixelByName(w,"red2");
    colors[0x4b] = (int)GetPixelByName(w,"green3");
    colors[0x4c] = (int)GetPixelByName(w,"MediumBlue");
    colors[0x4d] = (int)GetPixelByName(w,"white");
    colors[0x4e] = (int)GetPixelByName(w,"gray53");
    colors[0x4f] = (int)GetPixelByName(w,"gray35");
    colors[0x50] = (int)GetPixelByName(w,"gray27");
    colors[0x51] = (int)GetPixelByName(w,"black");      // ... symbols

    colors[0x52] = (int)GetPixelByName(w,"LimeGreen");  // PHG, symbols

    colors[0xfe] = (int)GetPixelByName(w,"pink");

    /* map solid colors */
    colors[0x60] = (int)GetPixelByName(w,"HotPink");
    colors[0x61] = (int)GetPixelByName(w,"RoyalBlue");
    colors[0x62] = (int)GetPixelByName(w,"orange3");
    colors[0x63] = (int)GetPixelByName(w,"yellow2");
    colors[0x64] = (int)GetPixelByName(w,"ForestGreen");
    colors[0x65] = (int)GetPixelByName(w,"DodgerBlue");
    colors[0x66] = (int)GetPixelByName(w,"cyan2");
    colors[0x67] = (int)GetPixelByName(w,"plum2");
    colors[0x68] = (int)GetPixelByName(w,"MediumBlue"); // was blue3 (the same!)
    colors[0x69] = (int)GetPixelByName(w,"gray86");

    /* tracking trail colors */
    trail_colors[0x00] = (int)GetPixelByName(w,"yellow");       /* Reserved for all my_callsign* stations */
    trail_colors[0x01] = (int)GetPixelByName(w,"blue");
    trail_colors[0x02] = (int)GetPixelByName(w,"green");
    trail_colors[0x03] = (int)GetPixelByName(w,"red");
    trail_colors[0x04] = (int)GetPixelByName(w,"magenta");
    trail_colors[0x05] = (int)GetPixelByName(w,"black");
    trail_colors[0x06] = (int)GetPixelByName(w,"white");
    trail_colors[0x07] = (int)GetPixelByName(w,"DarkOrchid");
    trail_colors[0x08] = (int)GetPixelByName(w,"purple");      // very similar to DarkOrchid...
    trail_colors[0x09] = (int)GetPixelByName(w,"OrangeRed");
    trail_colors[0x0a] = (int)GetPixelByName(w,"brown");
    trail_colors[0x0b] = (int)GetPixelByName(w,"DarkGreen");    // was darkgreen (same)
    trail_colors[0x0c] = (int)GetPixelByName(w,"MediumBlue");
    trail_colors[0x0d] = (int)GetPixelByName(w,"ForestGreen");
    trail_colors[0x0e] = (int)GetPixelByName(w,"chartreuse");
    trail_colors[0x0f] = (int)GetPixelByName(w,"cornsilk");
    trail_colors[0x10] = (int)GetPixelByName(w,"LightCyan");
    trail_colors[0x11] = (int)GetPixelByName(w,"cyan");
    trail_colors[0x12] = (int)GetPixelByName(w,"DarkSlateGray");
    trail_colors[0x13] = (int)GetPixelByName(w,"NavyBlue");
    trail_colors[0x14] = (int)GetPixelByName(w,"DarkOrange3");
    trail_colors[0x15] = (int)GetPixelByName(w,"gray27");
    trail_colors[0x16] = (int)GetPixelByName(w,"RoyalBlue");
    trail_colors[0x17] = (int)GetPixelByName(w,"yellow2");
    trail_colors[0x18] = (int)GetPixelByName(w,"DodgerBlue");
    trail_colors[0x19] = (int)GetPixelByName(w,"cyan2");
    trail_colors[0x1a] = (int)GetPixelByName(w,"MediumBlue"); // was blue3 (the same!)
    trail_colors[0x1b] = (int)GetPixelByName(w,"gray86");
    trail_colors[0x1c] = (int)GetPixelByName(w,"SteelBlue");
    trail_colors[0x1d] = (int)GetPixelByName(w,"PaleGreen");
    trail_colors[0x1e] = (int)GetPixelByName(w,"RosyBrown");
    trail_colors[0x1f] = (int)GetPixelByName(w,"DeepSkyBlue");

    values.background=GetPixelByName(w,"darkgray");

    gc = XCreateGC(my_display, XtWindow(w), mask, &values);

    gc_tint = XCreateGC(my_display, XtWindow(w), mask, &values);

    pix =  XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 20, 20, 1);
    values.function = GXcopy;
    gc2 = XCreateGC(XtDisplay(w), pix,GCForeground|GCBackground|GCFunction, &values);

    pixmap=XCreatePixmap(XtDisplay(w),
                        DefaultRootWindow(XtDisplay(w)),
                        screen_width,screen_height,
                        DefaultDepthOfScreen(XtScreen(w)));

    pixmap_final=XCreatePixmap(XtDisplay(w),
                        DefaultRootWindow(XtDisplay(w)),
                        screen_width,screen_height,
                        DefaultDepthOfScreen(XtScreen(w)));

    pixmap_alerts=XCreatePixmap(XtDisplay(w),
                        DefaultRootWindow(XtDisplay(w)),
                        screen_width,screen_height,
                        DefaultDepthOfScreen(XtScreen(w)));

    display_up=1;

    wait_to_redraw=0;

    if (debug_level & 8)
        printf("Create gc stop\n");
}



void da_expose(Widget w, /*@unused@*/ XtPointer client_data, XtPointer call_data) {
    Dimension width, height, margin_width, margin_height;
    XmDrawingAreaCallbackStruct *db = (XmDrawingAreaCallbackStruct *)call_data;
    XExposeEvent *event = (XExposeEvent *) db->event;
    unsigned char   unit_type;

    /* Call a routine to create a Graphics Context */
    create_gc(w);
    /*printf("Expose event\n");*/
    /* First get the various dimensions */
    XtVaGetValues(w,
                XmNwidth, &width,
                XmNheight, &height,
                XmNmarginWidth, &margin_width,
                XmNmarginHeight, &margin_height,
                XmNunitType, &unit_type,
                0);

    (void)XCopyArea(XtDisplay(w),pixmap_final,XtWindow(w),gc,event->x,event->y,event->width,event->height,event->x,event->y);
}



void da_resize(Widget w, /*@unused@*/ XtPointer client_data, /*@unused@*/ XtPointer call_data) {
    Dimension width, height;

    if (XtIsRealized(w)){
        /* First get the various dimensions */
        XtVaGetValues(w,
            XmNwidth,   &width,
            XmNheight,  &height,
            0);

        screen_width  = (long)width;
        screen_height = (long)height;
        XtVaSetValues(w,
            XmNwidth,   screen_width,
            XmNheight,  screen_height,
            NULL);

        /*  printf("Size x:%ld, y:%ld\n",screen_width,screen_height);*/
        if (pixmap)
            (void)XFreePixmap(XtDisplay(w),pixmap);

        if(pixmap_final)
            (void)XFreePixmap(XtDisplay(w),pixmap_final);

        if(pixmap_alerts)
            (void)XFreePixmap(XtDisplay(w),pixmap_alerts);

        pixmap=XCreatePixmap(XtDisplay(w),
                    DefaultRootWindow(XtDisplay(w)),
                    width,height,
                    DefaultDepthOfScreen(XtScreen(w)));

        pixmap_final=XCreatePixmap(XtDisplay(w),
                    DefaultRootWindow(XtDisplay(w)),
                    width,height,
                    DefaultDepthOfScreen(XtScreen(w)));

        pixmap_alerts=XCreatePixmap(XtDisplay(w),
                    DefaultRootWindow(XtDisplay(w)),
                    width,height,
                    DefaultDepthOfScreen(XtScreen(w)));

        setup_in_view();    // flag stations that are in screen view
        create_image(w);
        (void)XCopyArea(XtDisplay(w),pixmap_final,XtWindow(w),gc,0,0,screen_width,screen_height,0,0);
    }
}



void da_input(Widget w, XtPointer client_data, XtPointer call_data) {
    XEvent *event = ((XmDrawingAreaCallbackStruct *) call_data)->event;
    Dimension width, height;
    int redraw;
    char buffer[20];
    int bufsize = 20;
    KeySym key;
    XComposeStatus compose;

    XtVaGetValues(w,
            XmNwidth, &width,
            XmNheight, &height,
            0);

    /*printf("input event %d %d\n",event->type,ButtonPress);*/
    redraw=0;
    input_x = event->xbutton.x;
    input_y = event->xbutton.y;

    if (event->type == ButtonRelease) {
        //printf("ButtonRelease %d %d\n",event->xbutton.button,Button3);

        if (event->xbutton.button == Button1) {     // Left Button
            // Can't catch a ButtonRelease here 'cuz we have a popup on ButtonPress
        }

        if (event->xbutton.button == Button3) {      // Right Button
            menu_x=input_x;
            menu_y=input_y;
            Zoom_out( w, client_data, call_data );
        }

        if (event->xbutton.button == Button2) {     // Middle Button
            menu_x=input_x;
            menu_y=input_y;
            Zoom_in( w, client_data, call_data );
        }

        if (redraw) {
            create_image(w);
            (void)XCopyArea(XtDisplay(w),pixmap_final,XtWindow(w),gc,0,0,screen_width,screen_height,0,0);
            /*printf("Current x %ld y %ld\n",mid_x_long_offset,mid_y_lat_offset);*/
        }

    }
    if (event->type == ButtonPress) {
        //printf("ButtonPress %d %d\n",event->xbutton.button,Button3);

        if (event->xbutton.button == Button1) {     // Left Button
            menu_x=input_x;
            menu_y=input_y;
            if (left_menu_popup!=NULL) {
                XmMenuPosition(left_menu_popup,(XButtonPressedEvent *)event);
                XtManageChild(left_menu_popup);
            }
        }

        if (event->xbutton.button == Button3) {      // Right Button
            // Nothing attached here.
        }

        if(event->xbutton.button == Button2) {      // Middle button or both right/left buttons
            // Nothing attached here.
        }

        if (redraw) {
            create_image(w);
            (void)XCopyArea(XtDisplay(w),pixmap_final,XtWindow(w),gc,0,0,screen_width,screen_height,0,0);
            /*printf("Current x %ld y %ld\n",mid_x_long_offset,mid_y_lat_offset);*/
        }
    }
    if (event->type == KeyPress) {

        // We want to branch from the keysym instead of the keycode
        (void)XLookupString( (XKeyEvent *)event, buffer, bufsize, &key, &compose );
        //printf("main.c:da_input():keycode %d\tkeysym %ld\t%s\n", event->xkey.keycode, key, buffer);

        // keycode 99, keysym 65365 is PageUp
        if (key == 65365) {
            menu_x=input_x;
            menu_y=input_y;
            Zoom_out_no_pan( w, client_data, call_data );
        }

        // keycode 105, keysym 65366 is PageDown
        if (key == 65366) {
            menu_x=input_x;
            menu_y=input_y;
            Zoom_in_no_pan( w, client_data, call_data );
        }

        // keycode 100, keysym 65361 is left-arrow
        if (key == 65361) {
            menu_x=input_x;
            menu_y=input_y;
            Pan_left( w, client_data, call_data );
        }

        // keycode 102, keysym 65363 is right-arrow
        if (key == 65363) {
            menu_x=input_x;
            menu_y=input_y;
            Pan_right( w, client_data, call_data );
        }

        // keycode 98, keysym 65362 is up-arrow
        if (key == 65362) {
            menu_x=input_x;
            menu_y=input_y;
            Pan_up( w, client_data, call_data );
        }

        // keycode 105, keysym 65364 is down-arrow
        if (key == 65364) {
            menu_x=input_x;
            menu_y=input_y;
            Pan_down( w, client_data, call_data );
        }

        if (redraw) {
            create_image(w);
            (void)XCopyArea(XtDisplay(w),pixmap_final,XtWindow(w),gc,0,0,screen_width,screen_height,0,0);
            /*printf("Current x %ld y %ld\n",mid_x_long_offset,mid_y_lat_offset);*/
        }

    } else {
        if (event->type == MotionNotify) {
            input_x = event->xmotion.x;
            input_y = event->xmotion.y;
            /*printf("da_input2 x %d y %d\n",input_x,input_y);*/
        }
    }
}


// DK7IN: this function is unused...
//void wait_sec(int dt) {
//    time_t ct;
//    
//    ct = sec_now() + dt;
//    while (ct < sec_now()) {
//    }
//}



// This is the periodic process that updates the maps/symbols/tracks.
// At the end of the function it schedules itself to be run again.
void UpdateTime( XtPointer clientData, /*@unused@*/ XtIntervalId id ) {
    Widget w = (Widget) clientData;
    time_t nexttime;
    int do_time;
    int max;
    static int last_alert_on_screen;

    do_time = 0;
    nexttime = 10;  // Start UpdateTime again 10 milliseconds after we've completed

    (void)sound_done();

    if(display_up) {
        if(display_up_first == 0) {             // very first call, do initialization
            display_up_first = 1;
            statusline("Loading symbols...",1);
            load_pixmap_symbol_file("symbols.dat");
            statusline("Initialize my station...",1);
            my_station_add(my_callsign,my_group,my_symbol,my_long,my_lat,my_phg,my_comment);
            statusline("Start interfaces...",1);
            startup_all_or_defined_port(-1);    // start interfaces
            da_resize(w, NULL,NULL);            // make sure the size is right after startup
            set_last_position();                // init last map position
        } else {
            popup_time_out_check();             // clear popup windows after timeout
            check_statusline_timeout();         // clear statusline after timeout
            check_station_remove();             // remove old stations
            check_message_remove();             // remove old mesages

            //if ( (new_message_data > 0) && ( (delay_time % 2) == 0) )
            update_messages(0);                 // Check Messages, no forced update

            /* check on Redraw requests */
            if (((redraw_on_new_data > 1) || (redraw_on_new_data && (sec_now() > last_redraw + REDRAW_PAUSE)) ||
                    (sec_now() > next_redraw)  ) && !wait_to_redraw) {
                //printf("Redraw on new data \n");

                // check if alert_redraw_on_update is set and it has been at least xx seconds since
                // last weather alert redraw.
                if ( alert_redraw_on_update
                        && ( sec_now() > ( last_alert_redraw + WX_ALERTS_REFRESH_TIME ) ) ) {

                    refresh_image(da);  // Much faster than create_image.

                    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);

                    // Here we use alert_redraw_on_update as a temp holding place for the
                    // count of active alerts.
                    if ((alert_redraw_on_update = alert_on_screen()) > last_alert_on_screen)
                        if (sound_play_wx_alert_message)
                            play_sound(sound_command, sound_wx_alert_message);

                    last_alert_on_screen = alert_redraw_on_update;
                    alert_redraw_on_update = 0;
                }
                else
                    redraw_symbols(w);

                redraw_on_new_data = 0;
                next_redraw = sec_now()+60;     // redraw every minute, do we need that?
                last_redraw = sec_now();

                // This assures that we periodically check for expired alerts
                // and schedule a screen update if we find any.
                if (alert_display_request())                            // should nor be placed in redraw loop !!???
                    alert_redraw_on_update = redraw_on_new_data = 1;    // ????

            }

            /* Look for packet data and check port status */
            if (delay_time > 15) {
                display_packet_data();
                interface_status(w);
                delay_time = 0;
                /* check station lists */
                update_station_scroll_list();   // maybe update lists
            }
            delay_time++;

            /* check gps start up, GPS on GPSPORT */
            if(sec_now() > sec_next_gps) {
                sec_next_gps = sec_now()+gps_time;
                /*printf("Check GPS\n");*/
                /* set dtr lines down */
                dtr_all_set(1);
                if(gps_stop_now)
                    gps_stop_now = 0;
            }

            /* Check to reestablish a connection */
            if(sec_now() > net_next_time) {
                net_last_time = sec_now();
                net_next_time = net_last_time+120;
                /*printf("Checking for reconnects\n");*/
                check_ports();
            }

            /* Check to see if it is time to spit out data */
            if(!wait_to_redraw) {
                if (last_time == 0) {
                    /* first update */
                    next_time = 120;
                    last_time = sec_now();
                    do_time = 1;
                } else {
                    /* check for update */
                    /*printf("Checking --- time %ld time to update %ld\n",sec_now(),last_time+next_time);*/
                    if(sec_now() >= (last_time + next_time)) {
                        next_time += next_time;
                        if (next_time > max_transmit_time)
                            next_time = max_transmit_time;

                        last_time = sec_now();
                        do_time = 1;
                    }
                }
                if (do_time || transmit_now) {
                    transmit_now = 0;
                    /* output to ALL net/tnc ports */
                    /*printf("Output data\n");*/
                    output_my_aprs_data();
                }
            }

            /* Time to put out raw WX data ? */
            if (sec_now() > sec_next_raw_wx) {
                sec_next_raw_wx = sec_now()+600;
                if (transmit_raw_wx)
                    tx_raw_wx_data();
                /* check wx data last received */
                wx_last_data_check();
            }

            /* is it time to spit out messages? */
            check_and_transmit_messages(sec_now());

            /* get data from interface */
            max=0;
            while (max < 20 && !XtAppPending(app_context)) {

if (begin_critical_section(&data_lock, "main.c:UpdateTime(1)" ) > 0)
    printf("data_lock\n");

                if (data_avail) {
                    switch (port_data[data_port].device_type) {
                        /* NET Data stream */
                        case DEVICE_NET_STREAM:
                            if (log_net_data)
                                log_data(LOGFILE_NET,(char *)data);

                            packet_data_add(langcode("WPUPDPD006"),(char *)data);
                            decode_ax25_line((char *)data,'I',data_port);
                            break;

                        /* TNC Devices */
                        case DEVICE_SERIAL_TNC:

                        case DEVICE_AX25_TNC:
                            if (log_tnc_data)
                                log_data(LOGFILE_TNC,(char *)data);

                            packet_data_add(langcode("WPUPDPD005"),(char *)data);
                            decode_ax25_line((char *)data,'T',data_port);
                            break;

                        case DEVICE_SERIAL_TNC_HSP_GPS:
                            if (port_data[data_port].dtr==1) // get GPS data
                                gps_data_find((char *)data,data_port);
                            else {
                                /* get TNC data */
                                if (log_tnc_data)
                                    log_data(LOGFILE_TNC,(char *)data);

                                packet_data_add(langcode("WPUPDPD005"),(char *)data);
                                decode_ax25_line((char *)data,'T',data_port);
                            }
                            break;

                        /* GPS Devices */
                        case DEVICE_SERIAL_GPS:

                        case DEVICE_NET_GPSD:
                            /*printf("GPS Data <%s>\n",data);*/
                            gps_data_find((char *)data,data_port);
                            break;

                        /* WX Devices */
                        case DEVICE_SERIAL_WX:

                        case DEVICE_NET_WX:
                            if (log_wx)
                                log_data(LOGFILE_WX,(char *)data);

                            wx_decode(data,data_port);
                            break;

                        default:
                            printf("Data from unknown source\n");
                            break;
                    }
                    data_avail=0;
                    max++;
                } else
                    max=20;

if (end_critical_section(&data_lock, "main.c:UpdateTime(2)" ) > 0)
    printf("data_lock\n");

            }
            /* END- get data from interface */
            /* READ FILE IF OPENED */
            if (read_file) {
//                if (read_file_delay_count >= read_file_delay) { // allow some delay between stations
                    read_file_line(read_file_ptr);
//                    read_file_delay_count = 0;
//                } else
//                    read_file_delay_count++;
            }
            /* END- READ FILE IF OPENED */
        }
    }
    (void)XtAppAddTimeOut(XtWidgetToApplicationContext(w),nexttime,(XtTimerCallbackProc)
    UpdateTime,(XtPointer)w);
}



void quit(int sig) {
    if(debug_level & 15)
        printf("Caught %d\n",sig);

    save_data();

    /* shutdown all interfaces */
    shutdown_all_active_or_defined_port(-1);

    if (debug_level)
        printf("Exiting..\n");

    exit (sig);
}



/* handle segfault signal */
void segfault(/*@unused@*/ int sig) {
    fprintf(stderr, "Caught Segfault! Xastir will terminate\n");
    quit(-1);
}



/*********************  dialog position *************************/

void pos_dialog(Widget w) {
    static Position x,y;
    Dimension wd, ht;

    XtVaGetValues(appshell, XmNx, &x, XmNy, &y, NULL);
    XtVaGetValues(appshell, XmNwidth, &wd, XmNheight, &ht, NULL);

    if(last_popup_x < x  || last_popup_y < y) {
        last_popup_x = x+20;
        last_popup_y = y+20;
    } else {
        last_popup_x += 10;
        last_popup_y += 10;
    }

    if ((last_popup_y+50) > (y+(ht/4))) {
        last_popup_x = (x+20);
        last_popup_y = (y+20);
    }

    if ((last_popup_x+50) > (x+(wd/4))) {
        last_popup_x = (x+10);
        last_popup_y = (y+10);
    }
    XtVaSetValues(w,XmNx,last_popup_x,XmNy,last_popup_y,NULL);
}



/*********************  fix dialog size *************************/

void fix_dialog_size(Widget w) {
    Dimension wd, ht;

    if (XtIsRealized(w)){
        XtVaGetValues(w,
                  XmNwidth, &wd,
                  XmNheight, &ht,
                  0);

        XtVaSetValues(w,
                  XmNminWidth,wd,
                  XmNminHeight,ht,
                  XmNmaxWidth,wd,
                  XmNmaxHeight,ht,
                  NULL);
    }
}



void fix_dialog_vsize(Widget w) {
    Dimension ht;

    if (XtIsRealized(w)){
        XtVaGetValues(w,
                  XmNheight, &ht,
                  0);

        XtVaSetValues(w,
                  XmNminHeight,ht,
                  XmNmaxHeight,ht,
                  NULL);
    }
}



/**************************************** Button CallBacks *************************************/
/***********************************************************************************************/

void on_off_switch(int switchpos, Widget first, Widget second) {
    if(switchpos) {
        XtSetSensitive(first,FALSE);
        XtSetSensitive(second,TRUE);
    } else {
        XtSetSensitive(first,TRUE);
        XtSetSensitive(second,FALSE);
    }
}



void check_range(void) {                        // keep map inside screen borders
    Dimension width, height;

    XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);

    if ((width*new_size) > 129600000l)
        new_mid_x = 129600000l/2;                                // center between 180W and 180E
    else
        if ((new_mid_x - (width*new_size)/2) < 0)
            new_mid_x = (width*new_size)/2;                      // left border max 180W
        else
            if ((new_mid_x + (width*new_size)/2) > 129600000l)
                new_mid_x = 129600000l-((width*new_size)/2);     // right border max 180E

    if ((height*new_size) > 64800000l)
        new_mid_y  =  64800000l/2;                               // center between 90N and 90S
    else
        if ((new_mid_y - (height*new_size)/2) < 0)
            new_mid_y  = (height*new_size)/2;                    // upper border max 90N
        else
            if ((new_mid_y + (height*new_size)/2) > 64800000l)
                new_mid_y = 64800000l-((height*new_size)/2);     // lower border max 90S
}
        


void display_pan_zoom_image(void) {
    Dimension width, height;

    XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
    check_range();        // keep map inside screen borders
    if (new_mid_x != mid_x_long_offset || new_mid_y != mid_y_lat_offset || new_size != size) {
        set_last_position();
        mid_x_long_offset = new_mid_x;
        mid_y_lat_offset  = new_mid_y;
        size = new_size;
        setup_in_view();    // update "in view" flag for all stations
        create_image(da);
    } else
        refresh_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    display_zoom_status();
}



void display_zoom_image(void) {
    Dimension width, height;

    XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
    check_range();        // keep map inside screen borders
    if (new_mid_x != mid_x_long_offset || new_mid_y != mid_y_lat_offset || new_size != size) {
        set_last_position();
        //mid_x_long_offset = new_mid_x;
        //mid_y_lat_offset  = new_mid_y;
        size = new_size;
        setup_in_view();    // update "in view" flag for all stations
        create_image(da);
    } else
        refresh_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    display_zoom_status();
}



void Zoom_in( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
        new_mid_y = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);
        new_size = size / 2;
        if (new_size < 1)
            new_size = 1;               // don't go further in
        display_pan_zoom_image();       // check range and do display
    }
}



void Zoom_in_no_pan( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
        new_mid_y = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);
        new_size = size / 2;
        if (new_size < 1)
            new_size = 1;               // don't go further in
        display_zoom_image();       // check range and do display
    }
}



void Zoom_out(  /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
        new_mid_y = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);
        if (width*size < 129600000l || height*size < 64800000l)
            new_size = size * 2;
        else
            new_size = size;       // don't zoom out if whole world could be shown
        display_pan_zoom_image();  // check range and do display
    }
}



void Zoom_out_no_pan( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
        new_mid_y = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);
        if (width*size < 129600000l || height*size < 64800000l)
            new_size = size * 2;
        else
            new_size = size;       // don't zoom out if whole world could be shown
        display_zoom_image();  // check range and do display
    }
}



void Zoom_level( /*@unused@*/ Widget w, XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;
    int level;

    level=atoi((char *)clientData);
    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
        new_mid_y = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);
        switch(level) {
            case(1):
                new_size = 1;
                break;

            case(2):
                new_size = 16;
                break;

            case(3):
                new_size = 64;
                break;

            case(4):
                new_size = 256;
                break;

            case(5):
                new_size = 1024;
                break;

            case(6):
                new_size = 8192;
                break;

            case(7):
                new_size = 262144;
                break;

            default:
                break;
        }
        display_pan_zoom_image();  // check range and do display
        // Change to display_zoom_image() if we want no panning
    }
}



void Pan_ctr( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
        new_mid_y = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);
        new_size  = size;
        display_pan_zoom_image();  // check range and do display
    }
}



void Pan_up( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset;
        new_mid_y = mid_y_lat_offset  - (height*size/4);
        new_size  = size;
        display_pan_zoom_image();  // check range and do display
    }
}



void Pan_down( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset;
        new_mid_y = mid_y_lat_offset  + (height*size/4);
        new_size  = size;
        display_pan_zoom_image();  // check range and do display
    }
}



void Pan_left( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset - (width*size/4);
        new_mid_y = mid_y_lat_offset;
        new_size  = size;
        display_pan_zoom_image();  // check range and do display
    }
}



void Pan_right( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;

    if(display_up) {
        XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
        new_mid_x = mid_x_long_offset + (width*size/4);
        new_mid_y = mid_y_lat_offset;
        new_size  = size;
        display_pan_zoom_image();  // check range and do display
    }
}



void Window_Quit( /*@unused@*/ Widget w, /*@unused@*/ XtPointer client, /*@unused@*/ XtPointer calldata) {
    quit(0);
}



void Menu_Quit( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    quit(0);
}



void Grid_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    long_lat_grid=1;   /* toggle use of map lat and long grid */
    statusline(langcode("BBARSTA005"),1);       // Map Lat/Long Grid On
    redraw_symbols(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    on_off_switch(long_lat_grid,grid_on,grid_off);
}

void Grid_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    long_lat_grid=0;              /* toggle use of map lat and long grid */
    statusline(langcode("BBARSTA006"),1);       // Map Lat/Long Grid Off
    redraw_symbols(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    on_off_switch(long_lat_grid,grid_on,grid_off);
}



void Map_auto_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    map_auto_maps=1;              /* toggle use of auto maps */
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    statusline(langcode("BBARSTA007"),1);       // The use of Auto Maps is now on
    on_off_switch(map_auto_maps,map_auto_on,map_auto_off);
}

void Map_auto_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    map_auto_maps=0;              /* toggle use of auto map */
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    statusline(langcode("BBARSTA008"),1);       // The use of Auto Maps is now off
    on_off_switch(map_auto_maps,map_auto_on,map_auto_off);
}



void Map_levels_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    map_color_levels=1;              /* toggle use of map color levels */
    statusline(langcode("BBARSTA009"),1);       // The use of Map Levels is now On
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    on_off_switch(map_color_levels,map_levels_on,map_levels_off);
}

void Map_levels_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    map_color_levels=0;              /* toggle use of map color levels */
    statusline(langcode("BBARSTA010"),1);       // The use of Map Levels is now Off
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    on_off_switch(map_color_levels,map_levels_on,map_levels_off);
}



void Map_fill_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    map_color_fill=1;              /* toggle use of map color fill */
    statusline(langcode("BBARSTA009"),1);       // The use of Map Color Fill is now On
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    on_off_switch(map_color_fill,map_fill_on,map_fill_off);
}

void Map_fill_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    map_color_fill=0;              /* toggle use of map color fill */
    statusline(langcode("BBARSTA010"),1);       // The use of Map Color Fill is now Off
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    on_off_switch(map_color_fill,map_fill_on,map_fill_off);
}



void Map_background( /*@unused@*/ Widget w, XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    int bgcolor;
    int i;

    bgcolor=atoi((char *)clientData);

    if(display_up){
        for (i=0;i<11;i++){
            if (i == bgcolor)
                XtSetSensitive(map_bgcolor[i],FALSE);
            else
                XtSetSensitive(map_bgcolor[i],TRUE);
        }
        map_background_color=bgcolor;
        create_image(da);
        (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    }
}



#ifdef USE_GEOTIFF
void Map_intensity(Widget w, XtPointer clientData, XtPointer calldata) {
    float my_intensity;
    int i;

    my_intensity=atof((char *)clientData);

    if(display_up){
        for (i=0;i<11;i++){
            if (i == (int)(my_intensity * 10.0) )
                XtSetSensitive(map_intensity[i],FALSE);
            else
                XtSetSensitive(map_intensity[i],TRUE);
        }

        geotiff_map_intensity=my_intensity;
        create_image(da);
        XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    }
}
#endif /* USE_GEOTIFF */



void Map_station_label( /*@unused@*/ Widget w, XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    int style;

    style=atoi((char *)clientData);

    if(display_up){
        letter_style = style;
        on_off_switch(letter_style,map_station_label1,map_station_label0);
        redraw_symbols(da);
        (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    }
}



void Map_wx_alerts( /*@unused@*/ Widget w, XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    int style;

    style=atoi((char *)clientData);
    if (display_up){
        wx_alert_style = style;
        on_off_switch(wx_alert_style,map_wx_alerts_1,map_wx_alerts_0);
        refresh_image(da);
        (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
    }
}



void TNC_Transmit_now( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    transmit_now = 1;              /* toggle transmission of station now*/
}



void TNC_Logging_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_tnc_data = 1;              /* toggle logging of TNC Data */
    on_off_switch(log_tnc_data,tnc_logging_on,tnc_logging_off);
}

void TNC_Logging_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_tnc_data = 0;              /* toggle logging of TNC Data */
    on_off_switch(log_tnc_data,tnc_logging_on,tnc_logging_off);
}



void Net_Logging_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_net_data = 1;              /* toggle logging of net Data */
    on_off_switch(log_net_data,net_logging_on,net_logging_off);
}

void Net_Logging_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_net_data = 0;              /* toggle logging of net Data */
    on_off_switch(log_net_data,net_logging_on,net_logging_off);
}



void IGate_Logging_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_igate = 1;              /* toggle logging of igate Data */
    on_off_switch(log_igate,igate_logging_on,igate_logging_off);
}

void IGate_Logging_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_igate = 0;              /* toggle logging of igate Data */
    on_off_switch(log_igate,igate_logging_on,igate_logging_off);
}



void WX_Logging_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_wx = 1;              /* toggle logging of igate Data */
    on_off_switch(log_wx,wx_logging_on,wx_logging_off);
}

void WX_Logging_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    log_wx = 0;              /* toggle logging of igate Data */
    on_off_switch(log_wx,wx_logging_on,wx_logging_off);
}



void Call_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_callsign_display = 1;        // display callsign of station
    redraw_on_new_data = 2;             // show it immediately
    on_off_switch(symbol_callsign_display,call_on,call_off);
}

void Call_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_callsign_display = 0;              /* toggle call of station */
    redraw_on_new_data = 2;
    on_off_switch(symbol_callsign_display,call_on,call_off);
}



void Alt_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_alt_display = 1;              /* toggle alt of station */
    redraw_on_new_data = 2;
    on_off_switch(symbol_alt_display,alt_on,alt_off);
}

void Alt_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_alt_display = 0;              /* toggle alt of station */
    redraw_on_new_data = 2;
    on_off_switch(symbol_alt_display,alt_on,alt_off);
}



void Course_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_course_display = 1;              /* toggle course of station */
    redraw_on_new_data = 2;
    on_off_switch(symbol_course_display,course_on,course_off);
}

void Course_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_course_display=0;              /* toggle course of station */
    redraw_on_new_data=2;
    on_off_switch(symbol_course_display,course_on,course_off);
}



void Speed_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_speed_display=1;              /* toggle speed of station */
    redraw_on_new_data=2;
    on_off_switch(symbol_speed_display,speed_on,speed_off);
}

void Speed_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_speed_display=0;              /* toggle speed of station */
    redraw_on_new_data=2;
    on_off_switch(symbol_speed_display,speed_on,speed_off);
}



void Dist_course_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_dist_course_display=1;              /* toggle my distance and course to station */
    redraw_on_new_data=2;
    on_off_switch(symbol_dist_course_display,dist_course_on,dist_course_off);
}

void Dist_course_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_dist_course_display=0;              /* toggle my distance and course to station */
    redraw_on_new_data=2;
    on_off_switch(symbol_dist_course_display,dist_course_on,dist_course_off);
}



void Units_choice_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    units_english_metric=1;              /* toggle units to english*/
    redraw_on_new_data=2;
    fill_wx_data();
    on_off_switch(units_english_metric,units_choice_on,units_choice_off);
}

void Units_choice_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    units_english_metric=0;              /* toggle units to metric */
    redraw_on_new_data=2;
    fill_wx_data();
    on_off_switch(units_english_metric,units_choice_on,units_choice_off);
}



void Station_trails_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    station_trails=1;              /* toggle display of station trails*/
    redraw_on_new_data=2;
    on_off_switch(station_trails,trails_on,trails_off);
}

void Station_trails_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    station_trails=0;              /* toggle display of station trails */
    redraw_on_new_data=2;
    on_off_switch(station_trails,trails_on,trails_off);
}



void Station_phg_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    show_phg=1;              /* toggle display of station pg*/
    redraw_on_new_data=2;
    on_off_switch(show_phg,phg_on,phg_off);
}

void Station_phg_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    show_phg=0;              /* toggle display of station pg */
    redraw_on_new_data=2;
    on_off_switch(show_phg,phg_on,phg_off);
}


/*
 *  Toggle Weather Info Display
 */
void WX_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_weather_display = 1;         // enable weather info display
    redraw_on_new_data = 2;             // redraw immediately
    on_off_switch(symbol_weather_display,wx_on,wx_off);
}

void WX_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_weather_display = 0;         // enable weather info display
    redraw_on_new_data = 2;             // redraw immediately
    on_off_switch(symbol_weather_display,wx_on,wx_off);
}


/*
 *  Toggle Symbol Display
 */
void Symbols_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_display = 1;                 // enable symbol display
    redraw_on_new_data = 2;             // redraw immediately
    on_off_switch(symbol_display,symbols_on,symbols_off);
}

void Symbols_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_display = 0;                 // disable symbol display
    redraw_on_new_data = 2;             // redraw immediately
    on_off_switch(symbol_display,symbols_on,symbols_off);
}


/*
 *  Toggle Symbol Rotation
 */
void Sym_rot_on( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_rotate = 1;                  // enable symbol rotation
    redraw_on_new_data = 2;             // redraw immediately
    on_off_switch(symbol_rotate,symrot_on,symrot_off);
}

void Sym_rot_off( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    symbol_rotate = 0;                  // disable symbol rotation
    redraw_on_new_data = 2;             // redraw immediately
    on_off_switch(symbol_rotate,symrot_on,symrot_off);
}



void Help_About( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget d;
    XmString xms, xa, xb;
    Arg al[10];
    unsigned int ac;
#define ABOUT_MSG "X Amateur Station Tracking and Information Reporting\n\nhttp://www.xastir.org\n\n1999-2001, The Xastir Group"

    xb = XmStringCreateLtoR("\nXastir ver. " VERSION "\n\n" ABOUT_MSG, XmFONTLIST_DEFAULT_TAG);

    xa = XmStringCreateLtoR(_("\n\n\nLibraries used: \n"), XmFONTLIST_DEFAULT_TAG);
    xms = XmStringConcat(xb, xa);
    XmStringFree(xa);
    XmStringFree(xb);

    xa = XmStringCreateLtoR("\n", XmFONTLIST_DEFAULT_TAG);
    xb = XmStringConcat(xms, xa);
    XmStringFree(xa);
    xa = XmStringCreateLtoR(XmVERSION_STRING, XmFONTLIST_DEFAULT_TAG);
    xms = XmStringConcat(xb, xa);
    XmStringFree(xa);
    XmStringFree(xb);

    xa = XmStringCreateLtoR("\n", XmFONTLIST_DEFAULT_TAG);
    xb = XmStringConcat(xms, xa);
    XmStringFree(xa);
#if (XbaeVERSION <= 4)
#if (XbaeVERSION > 7)
    xa = XmStringCreateLtoR(XbaeGetVersionTxt(), XmFONTLIST_DEFAULT_TAG);
#else
    xa = XmStringCreateLtoR("Ancient version of XbaeMatrix", XmFONTLIST_DEFAULT_TAG);
#endif
#else
    xa = XmStringCreateLtoR(XbaeGetVersionTxt(), XmFONTLIST_DEFAULT_TAG);
#endif
    xms = XmStringConcat(xb, xa);
    XmStringFree(xa);
    XmStringFree(xb);

    ac = 0;
    XtSetArg(al[ac], XmNmessageString, xms); ac++;
    d = XmCreateInformationDialog(Global.top, "About Xastir", al, ac);
    XmStringFree(xms);
    XtDestroyWidget(XmMessageBoxGetChild(d, (unsigned char)XmDIALOG_CANCEL_BUTTON));
    XtDestroyWidget(XmMessageBoxGetChild(d, (unsigned char)XmDIALOG_HELP_BUTTON));
    XtManageChild(d);
    fix_dialog_size(d);
}



Widget GetTopShell(Widget w) {
    while(w && !XtIsWMShell(w))
        w = XtParent(w);

    return(w);
}



/*********************** Display incoming data*******************************/
/****************************************************************************/

void Display_data_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    XtDestroyWidget(shell);
    Display_data_dialog = (Widget)NULL;
}



void  Display_packet_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if(state->set)
        Display_packet_data_type = atoi(which);
    else
        Display_packet_data_type = 0;

    redraw_on_new_packet_data=1;
}



void Display_data( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget pane, my_form, button_close, option_box, tnc_data, net_data, tnc_net_data;
    unsigned int n;
    Arg args[20];
    Atom delw;

    if (!Display_data_dialog) {
        Display_data_dialog = XtVaCreatePopupShell(langcode("WPUPDPD001"),xmDialogShellWidgetClass,Global.top,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, Display_data_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 5,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);
        n=0;
        XtSetArg(args[n], XmNrows, 15); n++;
        XtSetArg(args[n], XmNcolumns, 100); n++;
        XtSetArg(args[n], XmNeditable, FALSE); n++;
        XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
        XtSetArg(args[n], XmNwordWrap, TRUE); n++;
        XtSetArg(args[n], XmNbackground, colors[0xff]); n++;
        XtSetArg(args[n], XmNscrollHorizontal, TRUE); n++;
        XtSetArg(args[n], XmNscrollVertical, FALSE); n++;
        XtSetArg(args[n], XmNcursorPositionVisible, FALSE); n++;
        XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNtopOffset, 5); n++;
        XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
        XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNleftOffset, 5); n++;
        XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
        XtSetArg(args[n], XmNrightOffset, 5); n++;

        Display_data_text=NULL;
        Display_data_text = XmCreateScrolledText(my_form,"text",args,n);

        /* set colors */
        n=0;
        XtSetArg(args[n],XmNbackground, colors[0xff]); n++;
        option_box = XmCreateRadioBox(my_form,"option box",args,n);

        XtVaSetValues(option_box,
                  XmNpacking, XmPACK_TIGHT,
                  XmNorientation, XmHORIZONTAL,
                  XmNtopAttachment,XmATTACH_WIDGET,
                  XmNtopWidget, XtParent(Display_data_text),
                  XmNbottomAttachment,XmATTACH_NONE,
                  XmNleftAttachment, XmATTACH_FORM,
                  XmNleftOffset, 5,
                  XmNrightAttachment,XmATTACH_FORM,
                  XmNrightOffset, 5,
                  NULL);

        tnc_data = XtVaCreateManagedWidget(langcode("WPUPDPD002"),xmToggleButtonGadgetClass,
                        option_box,
                        XmNbackground, colors[0xff],
                        NULL);

        XtAddCallback(tnc_data,XmNvalueChangedCallback,Display_packet_toggle,"1");

        net_data = XtVaCreateManagedWidget(langcode("WPUPDPD003"),xmToggleButtonGadgetClass,
                        option_box,
                        XmNbackground, colors[0xff],
                        NULL);

        XtAddCallback(net_data,XmNvalueChangedCallback,Display_packet_toggle,"2");

        tnc_net_data = XtVaCreateManagedWidget(langcode("WPUPDPD004"),xmToggleButtonGadgetClass,
                            option_box,
                            XmNbackground, colors[0xff],
                            NULL);

        XtAddCallback(tnc_net_data,XmNvalueChangedCallback,Display_packet_toggle,"0");

        button_close = XtVaCreateManagedWidget(langcode("UNIOP00003"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, option_box,
                                      XmNtopOffset, 2,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 3,
                                      XmNbackground, colors[0xff],
                                      NULL);

        XtAddCallback(button_close, XmNactivateCallback, Display_data_destroy_shell, Display_data_dialog);

        pos_dialog(Display_data_dialog);

        delw = XmInternAtom(XtDisplay(Display_data_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(Display_data_dialog, delw, Display_data_destroy_shell, (XtPointer)Display_data_dialog);

        switch (Display_packet_data_type) {
            case(0):
                XmToggleButtonSetState(tnc_net_data,TRUE,FALSE);
                break;

            case(1):
                XmToggleButtonSetState(tnc_data,TRUE,FALSE);
                break;

            case(2):
                XmToggleButtonSetState(net_data,TRUE,FALSE);
                break;

            default:
                XmToggleButtonSetState(tnc_net_data,TRUE,FALSE);
                break;
        }

        XtManageChild(my_form);
        XtManageChild(option_box);
        XtManageChild(Display_data_text);
        XtVaSetValues(Display_data_text, XmNbackground, colors[0x0f], NULL);
        XtManageChild(pane);

        redraw_on_new_packet_data=1;
        XtPopup(Display_data_dialog,XtGrabNone);
        fix_dialog_size(Display_data_dialog);
    }  else
        (void)XRaiseWindow(XtDisplay(Display_data_dialog), XtWindow(Display_data_dialog));

}




/****************************** Help menu ***********************************/
/****************************************************************************/

void help_view_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    XtDestroyWidget(shell);
    help_view_dialog = (Widget)NULL;
}



void help_index_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;

    if (help_view_dialog)
        help_view_destroy_shell(help_view_dialog, help_view_dialog, NULL);

    help_view_dialog = (Widget)NULL;

    XtPopdown(shell);
    XtDestroyWidget(shell);
    help_index_dialog = (Widget)NULL;
}



void help_view( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget pane, my_form, button_close,help_text;
    int i,x,y;
    unsigned int n;
    char *temp;
    char title[200];
    char temp2[200];
    char temp3[200];
    FILE *f;
    XmString *list;
    int open;
    Arg args[20];
    int data_on,pos;
    int found;
    Atom delw;

    data_on=0;
    pos=0;
    found=0;

    XtVaGetValues(help_list,
               XmNitemCount,&i,
               XmNitems,&list,
               NULL);

    for (x=1; x<=i;x++) {
        if (XmListPosSelected(help_list,x)) {
            found=1;
            if (XmStringGetLtoR(list[(x-1)],XmFONTLIST_DEFAULT_TAG,&temp))
                x=i+1;
        }
    }
    open=0;

    if (found) {
        if (help_view_dialog) {
            XtVaGetValues(help_view_dialog, XmNx, &x, XmNy, &y, NULL);
            help_view_destroy_shell(help_view_dialog, help_view_dialog, NULL);
            help_view_dialog = (Widget)NULL;
            open=1;
        }
        if (!help_view_dialog) {
            sprintf(title,"Help - %s",temp);
            help_view_dialog = XtVaCreatePopupShell(title,xmDialogShellWidgetClass,Global.top,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  NULL);
            pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, help_view_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

            my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 5,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);

            n=0;
            XtSetArg(args[n], XmNrows, 20); n++;
            XtSetArg(args[n], XmNcolumns, 80); n++;
            XtSetArg(args[n], XmNeditable, FALSE); n++;
            XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
            XtSetArg(args[n], XmNwordWrap, TRUE); n++;
            XtSetArg(args[n], XmNbackground, colors[0xff]); n++;
            XtSetArg(args[n], XmNscrollHorizontal, FALSE); n++;
            XtSetArg(args[n], XmNcursorPositionVisible, FALSE); n++;
            XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
            XtSetArg(args[n], XmNtopOffset, 5); n++;
            XtSetArg(args[n], XmNbottomAttachment, XmATTACH_NONE); n++;
            XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
            XtSetArg(args[n], XmNleftOffset, 5); n++;
            XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
            XtSetArg(args[n], XmNrightOffset, 5); n++;

            help_text=NULL;
            help_text = XmCreateScrolledText(my_form,"help text",args,n);

            f=fopen(HELP_FILE,"r");
            if (f!=NULL) {
                while(!feof(f)) {
                    (void)get_line(f,temp2,200);
                    if (strncmp(temp2,"HELP-INDEX>",11)==0) {
                        if(strcmp((temp2+11),temp)==0)
                            data_on=1;
                        else
                            data_on=0;
                    } else {
                        if (data_on) {
                            sprintf(temp3,"%s\n",temp2);
                            XmTextInsert(help_text,pos,temp3);
                            pos += strlen(temp3);
                            XmTextShowPosition(help_text,0);
                        }
                    }
                }
                (void)fclose(f);
            }
            else
                printf("Couldn't open file: %s\n", HELP_FILE);

            button_close = XtVaCreateManagedWidget(langcode("UNIOP00003"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, XtParent(help_text),
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 3,
                                      NULL);

            XtAddCallback(button_close, XmNactivateCallback, help_view_destroy_shell, help_view_dialog);

            if (!open)
                pos_dialog(help_view_dialog);
            else
                XtVaSetValues(help_view_dialog, XmNx, x, XmNy, y, NULL);

            delw = XmInternAtom(XtDisplay(help_view_dialog),"WM_DELETE_WINDOW", FALSE);
            XmAddWMProtocolCallback(help_view_dialog, delw, help_view_destroy_shell, (XtPointer)help_view_dialog);

            XtManageChild(my_form);
            XtManageChild(help_text);
            XtVaSetValues(help_text, XmNbackground, colors[0x0f], NULL);
            XtManageChild(pane);

            XtPopup(help_view_dialog,XtGrabNone);
            fix_dialog_size(help_view_dialog);
            XmTextShowPosition(help_text,0);
        }
    }

}



void Help_Index( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget  pane, my_form, button_ok, button_cancel;
    int n;
    char temp[600];
    FILE *f;
    Arg al[20];           /* Arg List */
    unsigned int ac = 0;           /* Arg Count */
    Atom delw;
    XmString str_ptr;

    if(!help_index_dialog) {
        help_index_dialog = XtVaCreatePopupShell(langcode("WPUPHPI001"),xmDialogShellWidgetClass,appshell,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  XmNresize, FALSE,
                                  NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, help_index_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 5,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);

        /*set args for color */
        ac=0;
        XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;
        XtSetArg(al[ac], XmNvisibleItemCount, 11); ac++;
        XtSetArg(al[ac], XmNtraversalOn, FALSE); ac++;
        XtSetArg(al[ac], XmNshadowThickness, 3); ac++;
        XtSetArg(al[ac], XmNbackground, colors[0x0ff]); ac++;
        XtSetArg(al[ac], XmNselectionPolicy, XmSINGLE_SELECT); ac++;
        XtSetArg(al[ac], XmNscrollBarPlacement, XmBOTTOM_RIGHT); ac++;
        XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNtopOffset, 5); ac++;
        XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
        XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNrightOffset, 5); ac++;
        XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
        XtSetArg(al[ac], XmNleftOffset, 5); ac++;

        help_list = XmCreateScrolledList(my_form,"list",al,ac);

        n=1;
        f=fopen(HELP_FILE,"r");
        if (f!=NULL) {
            while (!feof(f)) {
                (void)get_line(f,temp,600);
                if (strncmp(temp,"HELP-INDEX>",11)==0) {
                    XmListAddItem(help_list, str_ptr = XmStringCreateLtoR((temp+11),XmFONTLIST_DEFAULT_TAG),n++);
                    XmStringFree(str_ptr);
                }
            }
            (void)fclose(f);
        }
        else
            printf("Couldn't open file: %s\n", HELP_FILE);

        button_ok = XtVaCreateManagedWidget(langcode("WPUPHPI002"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, XtParent(help_list),
                                      XmNtopOffset,5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset,5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 1,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 2,
                                      NULL);

        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00003"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, XtParent(help_list),
                                      XmNtopOffset,5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset,5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 3,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 4,
                                      NULL);

        XtAddCallback(button_cancel, XmNactivateCallback, help_index_destroy_shell, help_index_dialog);
        XtAddCallback(button_ok, XmNactivateCallback, help_view, NULL);

        pos_dialog(help_index_dialog);

        delw = XmInternAtom(XtDisplay(help_index_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(help_index_dialog, delw, help_index_destroy_shell, (XtPointer)help_index_dialog);

        XtManageChild(my_form);
        XtManageChild(help_list);
        XtVaSetValues(help_list, XmNbackground, colors[0x0f], NULL);
        XtManageChild(pane);

        XtPopup(help_index_dialog,XtGrabNone);
        fix_dialog_size(help_index_dialog);
    } else {
        XtPopup(help_index_dialog,XtGrabNone);
        (void)XRaiseWindow(XtDisplay(help_index_dialog), XtWindow(help_index_dialog));
    }
}




/************************** Clear stations *******************************/
/*************************************************************************/

void Stations_Clear( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {

    delete_all_stations();
    my_station_add(my_callsign,my_group,my_symbol,my_long,my_lat,my_phg,my_comment);
    current_trail_color = 0x00;  // restart
    redraw_on_new_data=2;
}




/************************* Map Chooser ***********************************/
/*************************************************************************/

void map_chooser_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    XtDestroyWidget(shell);
    map_chooser_dialog = (Widget)NULL;
}



void map_chooser_select_maps(Widget widget, XtPointer clientData, XtPointer callData) {
    int i,x;
    char *temp;
    XmString *list;
    FILE *f;

    //WE7U.  It'd be nice to turn off auto-maps here.

    XtVaGetValues(map_list,
               XmNitemCount,&i,
               XmNitems,&list,
               NULL);

    f=fopen(WIN_MAP_DATA,"w+");
    if (f!=NULL) {
        for(x=1; x<=i;x++) {
            if(XmListPosSelected(map_list,x)) {
                if(XmStringGetLtoR(list[(x-1)],XmFONTLIST_DEFAULT_TAG,&temp))
                    fprintf(f,"%s\n",temp);
            }
        }
        (void)fclose(f);
    }
    else
        printf("Couldn't open file: %s\n", WIN_MAP_DATA);

    map_chooser_destroy_shell(widget,clientData,callData);
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
}



void map_chooser_select_vector_maps(Widget widget, XtPointer clientData, XtPointer callData) {
    int i,x;
    char *temp;
    char *ext;
    XmString *list;
    FILE *f;

    XtVaGetValues(map_list,
               XmNitemCount,&i,
               XmNitems,&list,
               NULL);

    f=fopen(WIN_MAP_DATA,"w+");
    if (f!=NULL) {
        for(x=1; x<=i;x++) {
            if(XmStringGetLtoR(list[(x-1)],XmFONTLIST_DEFAULT_TAG,&temp))
            {
                ext = get_map_ext (temp);
                if ( (ext != NULL) && (strcasecmp (ext, "map") == 0) )
                    fprintf(f,"%s\n",temp);
            }
        }
        (void)fclose(f);
    }
    else
        printf("Couldn't open file: %s\n", WIN_MAP_DATA);

    map_chooser_destroy_shell(widget,clientData,callData);
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
}



void map_chooser_select_250k_maps(Widget widget, XtPointer clientData, XtPointer callData) {
    int i,x,length;
    char *temp;
    char *ext;
    XmString *list;
    FILE *f;

    XtVaGetValues(map_list,
               XmNitemCount,&i,
               XmNitems,&list,
               NULL);

    f=fopen(WIN_MAP_DATA,"w+");
    if (f!=NULL) {
        for(x=1; x<=i;x++) {
            if(XmStringGetLtoR(list[(x-1)],XmFONTLIST_DEFAULT_TAG,&temp))
            {
                ext = get_map_ext (temp);
                length = (int)strlen(temp);
                if ( (ext != NULL) && (strcasecmp (ext, "tif") == 0)
                    && (length >= 12)   // "o48122h3.tif", we might have subdirectories also
                    && ( (temp[length - 12] == 'c') || (temp[length - 12] == 'C') ) )
                    fprintf(f,"%s\n",temp);
            }
        }
        (void)fclose(f);
    }
    else
        printf("Couldn't open file: %s\n", WIN_MAP_DATA);

    map_chooser_destroy_shell(widget,clientData,callData);
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
}



void map_chooser_select_100k_maps(Widget widget, XtPointer clientData, XtPointer callData) {
    int i,x,length;
    char *temp;
    char *ext;
    XmString *list;
    FILE *f;

    XtVaGetValues(map_list,
               XmNitemCount,&i,
               XmNitems,&list,
               NULL);

    f=fopen(WIN_MAP_DATA,"w+");
    if (f!=NULL)
    {
        for(x=1; x<=i;x++)
        {
            if(XmStringGetLtoR(list[(x-1)],XmFONTLIST_DEFAULT_TAG,&temp))
            {
                ext = get_map_ext (temp);
                length = (int)strlen(temp);
                if ( (ext != NULL) && (strcasecmp (ext, "tif") == 0)
                    && (length >= 12)   // "o48122h3.tif", we might have subdirectories also
                    && ( (temp[length - 12] == 'f') || (temp[length - 12] == 'F') ) )
                    fprintf(f,"%s\n",temp);
            }
        }
        (void)fclose(f);
    }
    else
        printf("Couldn't open file: %s\n", WIN_MAP_DATA);

    map_chooser_destroy_shell(widget,clientData,callData);
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
}



void map_chooser_select_24k_maps(Widget widget, XtPointer clientData, XtPointer callData) {
    int i,x,length;
    char *temp;
    char *ext;
    XmString *list;
    FILE *f;

    XtVaGetValues(map_list,
               XmNitemCount,&i,
               XmNitems,&list,
               NULL);

    f=fopen(WIN_MAP_DATA,"w+");
    if (f!=NULL) {
        for(x=1; x<=i;x++)
        {
            if(XmStringGetLtoR(list[(x-1)],XmFONTLIST_DEFAULT_TAG,&temp))
            {
                ext = get_map_ext (temp);
                length = (int)strlen(temp);
                if ( (ext != NULL) && (strcasecmp (ext, "tif") == 0)
                    && (length >= 12)   // "o48122h3.tif", we might have subdirectories also
                    && ( (temp[length - 12] == 'o') || (temp[length - 12] == 'O') ) )
                    fprintf(f,"%s\n",temp);
            }
        }
        (void)fclose(f);
    }
    else
        printf("Couldn't open file: %s\n", WIN_MAP_DATA);

    map_chooser_destroy_shell(widget,clientData,callData);
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
}



void map_chooser_deselect_maps(Widget widget, XtPointer clientData, XtPointer callData) {
    FILE *f;

    // Empty the file (no maps listed as selected)
    f=fopen(WIN_MAP_DATA,"w+");
    if(f!=NULL)
        (void)fclose(f);
    else
        printf("Couldn't zero file: %s\n", WIN_MAP_DATA);

    map_chooser_destroy_shell(widget,clientData,callData);
    create_image(da);
    (void)XCopyArea(XtDisplay(da),pixmap_final,XtWindow(da),gc,0,0,screen_width,screen_height,0,0);
}



void dir_sort(char *dir) {
    struct dirent *dl;
    DIR *dm;
    char fullpath[8000];
    struct stat nfile;
    const time_t *ftime;
    int my_size;

    my_size=strlen(WIN_MAP_DIR)+1;
    dm = opendir(dir);
    if(!dm)
        //perror("maps");
        perror(dir);
    else {
        while((dl = readdir(dm))) {
            sprintf(fullpath,"%s/%s",dir,dl->d_name);
            if (stat(fullpath,&nfile)==0) {
                ftime=(time_t *)&nfile.st_ctime;
                switch (nfile.st_mode & S_IFMT) {
                    case(S_IFDIR):
                        /*printf("file %c letter %c\n",dl->d_name[0],letter);*/
                        if((strcmp(dl->d_name,".") !=0) && (strcmp(dl->d_name,"..") !=0))
                            dir_sort(fullpath);

                        break;

                    case(S_IFREG):
                        /*printf("FILE %d<%s>\n",*item,fullpath+my_size);*/
                        (void)sort_input_database(get_user_base_dir("data/sort_maps_db.dat"),(fullpath+my_size),1000);
                        break;

                    default:
                        break;
                }
            }
        }
    }
    (void)closedir(dm);
}



void sort_list(char *filename,int size, Widget list, int *item) {
    FILE *f_data;
    FILE *f_pointer;
    char fill[2000];
    long file_ptr;
    long ptr;
    char ptr_filename[400];
    XmString str_ptr;

    sprintf(ptr_filename,"%s-ptr",filename);
    f_pointer=fopen(ptr_filename,"r");
    f_data=fopen(filename,"r");
    if (f_pointer!=NULL && f_data !=NULL) {
        while (!feof(f_pointer)) {
            ptr=ftell(f_pointer);
            if (fread(&file_ptr,sizeof(file_ptr),1,f_pointer)==1) {
                (void)fseek(f_data,file_ptr,SEEK_SET);
                if (fread(fill,(size_t)size,1,f_data)==1) {
                    XmListAddItem(list, str_ptr = XmStringCreateLtoR(fill,XmFONTLIST_DEFAULT_TAG),*item);
                    XmStringFree(str_ptr);
                    (*item)++;
                }
            }
        }
    }
    if(f_pointer!=NULL)
        (void)fclose(f_pointer);
    else
        printf("Couldn't open file: %s\n", ptr_filename);


    if(f_data!=NULL)
        (void)fclose(f_data);
    else
        printf("Couldn't open file: %s\n", filename);
}



void Map_chooser( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget  pane, my_form, button_none, button_V, button_ok,
            button_cancel, mess, button_C, button_F, button_O;
    Atom delw;
    int n,i;
    FILE *f;
    char temp[600];
    XmString str_ptr;
    Arg al[10];                    /* Arg List */
    register unsigned int ac = 0;           /* Arg Count */


    i=0;
    if (!map_chooser_dialog) {
        map_chooser_dialog = XtVaCreatePopupShell(langcode("WPUPMCP001"),xmDialogShellWidgetClass,Global.top,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, map_chooser_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 7,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);

        /*set args for color */
        ac=0;
        XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;
        XtSetArg(al[ac], XmNvisibleItemCount, 13); ac++;
        XtSetArg(al[ac], XmNtraversalOn, FALSE); ac++;
        XtSetArg(al[ac], XmNshadowThickness, 3); ac++;
        XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;
        XtSetArg(al[ac], XmNselectionPolicy, XmMULTIPLE_SELECT); ac++;
        XtSetArg(al[ac], XmNscrollBarPlacement, XmBOTTOM_RIGHT); ac++;

        map_list = XmCreateScrolledList(my_form,"list",al,ac);

        n=1;
        clear_sort_file(get_user_base_dir("data/sort_maps_db.dat"));
        dir_sort(WIN_MAP_DIR);
        sort_list(get_user_base_dir("data/sort_maps_db.dat"),1000,map_list,&n);

        (void)filecreate(WIN_MAP_DATA);   // Create empty file if it doesn't exist
        f=fopen(WIN_MAP_DATA,"r");
        if (f!=NULL) {
            while(!feof(f)) {
                (void)get_line(f,temp,600);
                i=XmListItemPos(map_list, str_ptr = XmStringCreateLtoR(temp,XmFONTLIST_DEFAULT_TAG));
                XmStringFree(str_ptr);
                if (i!=0)
                    XmListSelectPos(map_list,i,TRUE);
            }
            (void)fclose(f);
        }
        else
            printf("Couldn't open file: %s\n", WIN_MAP_DATA);

        mess = XtVaCreateManagedWidget(langcode("WPUPMCP002"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_FORM,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset, 5,
                                      XmNrightAttachment, XmATTACH_FORM,
                                      XmNrightOffset, 5,
                                      XmNbackground, colors[0xff],
                                      NULL);

        XtVaSetValues(XtParent(map_list),
                    XmNtopAttachment, XmATTACH_WIDGET,
                    XmNtopWidget,mess,
                    XmNtopOffset, 5,
                    XmNbottomAttachment, XmATTACH_NONE,
                    XmNrightAttachment, XmATTACH_FORM,
                    XmNrightOffset, 5,
                    XmNleftAttachment, XmATTACH_FORM,
                    XmNleftOffset, 5,
                    NULL);

// "None"
        button_none = XtVaCreateManagedWidget(langcode("PULDNMMC01"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 0,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 1,
                                        XmNbackground, colors[0xff],
                                        NULL);


// "Vector Maps"
        button_V = XtVaCreateManagedWidget(langcode("PULDNMMC02"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 1,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 2,
                                        XmNbackground, colors[0xff],
                                        NULL);

// "250k Topos"
        button_C = XtVaCreateManagedWidget(langcode("PULDNMMC03"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 2,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 3,
                                        XmNbackground, colors[0xff],
#ifndef USE_GEOTIFF
                                        XmNsensitive, FALSE,
#endif /* USE_GEOTIFF */
                                        NULL);

// "100k Topos"
        button_F = XtVaCreateManagedWidget(langcode("PULDNMMC04"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 3,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 4,
                                        XmNbackground, colors[0xff],
#ifndef USE_GEOTIFF
                                        XmNsensitive, FALSE,
#endif /* USE_GEOTIFF */
                                        NULL);

// "24k Topos"
        button_O = XtVaCreateManagedWidget(langcode("PULDNMMC05"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 4,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 5,
                                        XmNbackground, colors[0xff],
#ifndef USE_GEOTIFF
                                        XmNsensitive, FALSE,
#endif /* USE_GEOTIFF */
                                        NULL);

// "OK"
        button_ok = XtVaCreateManagedWidget(langcode("UNIOP00001"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 5,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 6,
                                        XmNbackground, colors[0xff],
                                        NULL);

// "Cancel"
        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget,XtParent(map_list),
                                        XmNtopOffset,5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 6,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 7,
                                        XmNbackground, colors[0xff],
                                        NULL);

        XtAddCallback(button_cancel, XmNactivateCallback, map_chooser_destroy_shell, map_chooser_dialog);
        XtAddCallback(button_ok, XmNactivateCallback, map_chooser_select_maps, map_chooser_dialog);
        XtAddCallback(button_none, XmNactivateCallback, map_chooser_deselect_maps, map_chooser_dialog);
        XtAddCallback(button_V, XmNactivateCallback, map_chooser_select_vector_maps, map_chooser_dialog);
#ifdef USE_GEOTIFF
        XtAddCallback(button_C, XmNactivateCallback, map_chooser_select_250k_maps, map_chooser_dialog);
        XtAddCallback(button_F, XmNactivateCallback, map_chooser_select_100k_maps, map_chooser_dialog);
        XtAddCallback(button_O, XmNactivateCallback, map_chooser_select_24k_maps, map_chooser_dialog);
#endif /* USE_GEOTIFF */

        pos_dialog(map_chooser_dialog);

        delw = XmInternAtom(XtDisplay(map_chooser_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(map_chooser_dialog, delw, map_chooser_destroy_shell, (XtPointer)map_chooser_dialog);

        XtManageChild(my_form);
        XtManageChild(map_list);
        XtVaSetValues(map_list, XmNbackground, colors[0x0f], NULL);
        XtManageChild(pane);

        XtPopup(map_chooser_dialog,XtGrabNone);
        fix_dialog_size(map_chooser_dialog);
    } else {
        (void)XRaiseWindow(XtDisplay(map_chooser_dialog), XtWindow(map_chooser_dialog));
    }
}



/****** Read in file **********/

void read_file_selection_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtDestroyWidget(shell);
    read_selection_dialog = (Widget)NULL;
}



void read_file_selection_now(Widget w, XtPointer clientData, XtPointer callData) {
    char *file;
    XmFileSelectionBoxCallbackStruct *cbs =(XmFileSelectionBoxCallbackStruct*)callData;

    if(XmStringGetLtoR(cbs->value,XmFONTLIST_DEFAULT_TAG,&file)) {
        /*printf("FILE is %s\n",file);*/
        if (!read_file) {
            /* do read file start */
            read_file_ptr=fopen(file,"r");
            if (read_file_ptr!=NULL) {
                read_file=1;
                read_file_delay_count=0;
                read_file_delay=0;
            }
            else
                printf("Couldn't open file: %s\n", file);
        }
    }
    read_file_selection_destroy_shell(w, clientData, callData);

    // Note that we leave the file in the "open" state.  UpdateTime()
    // comes along shortly and reads the file.
}



void Read_File_Selection( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Arg al[10];                    /* Arg List */
    register unsigned int ac = 0;           /* Arg Count */
    Widget fs;

    if (read_selection_dialog!=NULL)
        read_file_selection_destroy_shell(read_selection_dialog, read_selection_dialog, NULL);

    if(read_selection_dialog==NULL) {
        /*set args for color */
        ac=0;
        XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;
        read_selection_dialog = XmCreateFileSelectionDialog(Global.top,"filesb",al,ac);

        fs=XmFileSelectionBoxGetChild(read_selection_dialog,(unsigned char)XmDIALOG_TEXT);
        XtVaSetValues(fs,XmNbackground, colors[0x0f],NULL);

        fs=XmFileSelectionBoxGetChild(read_selection_dialog,(unsigned char)XmDIALOG_FILTER_TEXT);
        XtVaSetValues(fs,XmNbackground, colors[0x0f],NULL);

        fs=XmFileSelectionBoxGetChild(read_selection_dialog,(unsigned char)XmDIALOG_DIR_LIST);
        XtVaSetValues(fs,XmNbackground, colors[0x0f],NULL);

        fs=XmFileSelectionBoxGetChild(read_selection_dialog,(unsigned char)XmDIALOG_LIST);
        XtVaSetValues(fs,XmNbackground, colors[0x0f],NULL);

        XtAddCallback(read_selection_dialog, XmNcancelCallback,read_file_selection_destroy_shell,read_selection_dialog);
        XtAddCallback(read_selection_dialog, XmNokCallback,read_file_selection_now,read_selection_dialog);

        XtManageChild(read_selection_dialog);
    }
}



#if DEBUG_TEST
void Test(Widget w, XtPointer clientData, XtPointer callData) {
    mdisplay_file(0);
    //mem_display();
    alert_print_list();
}
#endif // DEBUG_TEST



/****** Save Config data **********/

void Save_Config( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    save_data();
}





///////////////////////////////////   Configure Defaults Dialog   //////////////////////////////////


void defaults_old_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if (state->set)
        old_station_item = atoi(which);
    else
        old_station_item = 0;

}



void defaults_clear_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if(state->set)
        clear_station_item = atoi(which);
    else
        clear_station_item = 0;

}



void Configure_defaults_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    XtDestroyWidget(shell);
    configure_defaults_dialog = (Widget)NULL;
}



void Configure_defaults_change_data(Widget widget, XtPointer clientData, XtPointer callData) {
    switch(old_station_item) {
        case(1):
            sec_old=(time_t)900l;
            break;

        case(2):
            sec_old=(time_t)1800l;
            break;

        case(3):
            sec_old=(time_t)2700l;
            break;

        case(4):
            sec_old=(time_t)3600l;
            break;

        case(5):
            sec_old=(time_t)5400l;
            break;

        case(6):
            sec_old=(time_t)7200l;
            break;

        default:
            break;
    }

    switch (clear_station_item) {
        case(1):
            sec_clear=(time_t)21600l;
            break;

        case(2):
            sec_clear=(time_t)43200l;
            break;

        case(3):
            sec_clear=(time_t)86400l;
            break;

        case(4):
            sec_clear=(time_t)172800l;
            break;

        case(5):
            sec_clear=(time_t)604800l;
            break;

        default:
            break;
    }
    sec_remove = sec_clear*2;
    if (sec_remove < (time_t)(24*3600))
        sec_remove = (time_t)(24*3600);

    switch(GPS_time) {
        case(10):
            gps_time=(time_t)10l;
            break;

        case(20):
            gps_time=(time_t)20l;
            break;

        case(30):
            gps_time=(time_t)30l;
            break;

        case(60):
            gps_time=(time_t)60l;
            break;

        case(120):
            gps_time=(time_t)120l;
            break;

        case(300):
            gps_time=(time_t)300l;
            break;

        case(600):
            gps_time=(time_t)600l;
            break;

        default:
            gps_time=(time_t)30l;
            break;
    }

    output_station_type = Station_transmit_type;
    if ((output_station_type >= 1) && (output_station_type <= 3)) {
        next_time = 60;
        max_transmit_time = (time_t)120l;       // shorter beacon interval for mobile stations
    } else {
        max_transmit_time = (time_t)900l;
    }

    transmit_raw_wx = (int)XmToggleButtonGetState(raw_wx_tx);

    transmit_compressed_posit = (int)XmToggleButtonGetState(compressed_posit_tx);

    altnet = (int)(XmToggleButtonGetState(altnet_active));

    strcpy(altnet_call, XmTextGetString(altnet_text));
    (void)remove_trailing_spaces(altnet_call);
    if (strlen(altnet_call)==0) {
        altnet = FALSE;
        strcpy(altnet_call, "XASTIR");
    }

    operate_as_an_igate=Igate_type;

    redraw_on_new_data=2;
    Configure_defaults_destroy_shell(widget,clientData,callData);
}



/* GPS sample time radio buttons */
void gps_time_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if(state->set)
        GPS_time = (time_t)atoi(which);
    else
        GPS_time = (time_t)30l;

}



/* Station_transmit type radio buttons */
void station_type_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if(state->set)
        Station_transmit_type = atoi(which);
    else
        Station_transmit_type = 0;

}



/* Igate type radio buttons */
void igate_type_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if(state->set)
        Igate_type = atoi(which);
    else
        Igate_type = 0;
}



void Configure_defaults( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget  pane, my_form, button_ok, button_cancel, frame, frame2, frame3, frame4, frame5,
                time, time_box,
                time_15, time_30, time_45, time_60, time_90, time_120,
                time2, time_box2,
                time_6h, time_12h, time_24h, time_48h, time_168h,
                time3, time_box3,
                toption1, toption2, toption3, toption4, toption5, toption6, toption7,
                station_type, type_box,
                styp1, styp2, styp3, styp4, styp5, styp6,
                igate_option, igate_box,
                igtyp0, igtyp1, igtyp2;
    Atom delw;
    Arg al[2];                    /* Arg List */
    register unsigned int ac = 0;           /* Arg Count */

    if (!configure_defaults_dialog) {
            configure_defaults_dialog = XtVaCreatePopupShell(langcode("WPUPCFD001"),xmDialogShellWidgetClass,Global.top,
                                    XmNdeleteResponse,XmDESTROY,
                                    XmNdefaultPosition, FALSE,
                                    NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, configure_defaults_dialog,
                            XmNbackground, colors[0xff],
                            NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                                XmNfractionBase, 5,
                                XmNbackground, colors[0xff],
                                XmNautoUnmanage, FALSE,
                                XmNshadowThickness, 1,
                                NULL);


        frame = XtVaCreateManagedWidget("frame", xmFrameWidgetClass, my_form,
                                        XmNtopAttachment,XmATTACH_FORM,
                                        XmNtopOffset,10,
                                        XmNbottomAttachment,XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset, 10,
                                        XmNrightAttachment,XmATTACH_FORM,
                                        XmNrightOffset, 10,
                                        XmNbackground, colors[0xff],
                                        NULL);

        time = XtVaCreateManagedWidget(langcode("WPUPCFD002"),xmLabelWidgetClass,frame,
                                        XmNchildType, XmFRAME_TITLE_CHILD,
                                        XmNbackground, colors[0xff],
                                        NULL);
        /*set args for color */
        ac=0;
        XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;

        time_box = XmCreateRadioBox(frame,"Time box",al,ac);

        XtVaSetValues(time_box,
                    XmNnumColumns,4,
                    NULL);


        time_15 = XtVaCreateManagedWidget(langcode("WPUPCFD003"),xmToggleButtonGadgetClass,
                                            time_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_15,XmNvalueChangedCallback,defaults_old_toggle,"1");


        time_30 = XtVaCreateManagedWidget(langcode("WPUPCFD004"),xmToggleButtonGadgetClass,
                                            time_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_30,XmNvalueChangedCallback,defaults_old_toggle,"2");


        time_45 = XtVaCreateManagedWidget(langcode("WPUPCFD005"),xmToggleButtonGadgetClass,
                                            time_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_45,XmNvalueChangedCallback,defaults_old_toggle,"3");


        time_60 = XtVaCreateManagedWidget(langcode("WPUPCFD006"),xmToggleButtonGadgetClass,
                                            time_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_60,XmNvalueChangedCallback,defaults_old_toggle,"4");


        time_90 = XtVaCreateManagedWidget(langcode("WPUPCFD007"),xmToggleButtonGadgetClass,
                                            time_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_90,XmNvalueChangedCallback,defaults_old_toggle,"5");


        time_120 = XtVaCreateManagedWidget(langcode("WPUPCFD008"),xmToggleButtonGadgetClass,
                                            time_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_120,XmNvalueChangedCallback,defaults_old_toggle,"6");


        frame2 = XtVaCreateManagedWidget("frame2", xmFrameWidgetClass, my_form,
                                        XmNtopAttachment,XmATTACH_WIDGET,
                                        XmNtopWidget, frame,
                                        XmNtopOffset,10,
                                        XmNbottomAttachment,XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset, 10,
                                        XmNrightAttachment,XmATTACH_FORM,
                                        XmNrightOffset, 10,
                                        XmNbackground, colors[0xff],
                                        NULL);

        time2 = XtVaCreateManagedWidget(langcode("WPUPCFD009"),xmLabelWidgetClass,frame2,
                                        XmNchildType, XmFRAME_TITLE_CHILD,
                                        XmNbackground, colors[0xff],
                                        NULL);

        time_box2 = XmCreateRadioBox(frame2,"Time box2",al,ac);

        XtVaSetValues(time_box2,
                    XmNnumColumns,5,
                    NULL);

        time_6h = XtVaCreateManagedWidget(langcode("WPUPCFD010"),xmToggleButtonGadgetClass,
                                            time_box2,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_6h,XmNvalueChangedCallback,defaults_clear_toggle,"1");


        time_12h = XtVaCreateManagedWidget(langcode("WPUPCFD011"),xmToggleButtonGadgetClass,
                                            time_box2,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_12h,XmNvalueChangedCallback,defaults_clear_toggle,"2");


        time_24h = XtVaCreateManagedWidget(langcode("WPUPCFD012"),xmToggleButtonGadgetClass,
                                            time_box2,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_24h,XmNvalueChangedCallback,defaults_clear_toggle,"3");


        time_48h = XtVaCreateManagedWidget(langcode("WPUPCFD013"),xmToggleButtonGadgetClass,
                                            time_box2,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_48h,XmNvalueChangedCallback,defaults_clear_toggle,"4");


        time_168h = XtVaCreateManagedWidget(langcode("WPUPCFD014"),xmToggleButtonGadgetClass,
                                            time_box2,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(time_168h,XmNvalueChangedCallback,defaults_clear_toggle,"5");


        frame3 = XtVaCreateManagedWidget("frame3", xmFrameWidgetClass, my_form,
                                        XmNtopAttachment,XmATTACH_WIDGET,
                                        XmNtopWidget, frame2,
                                        XmNtopOffset,10,
                                        XmNbottomAttachment,XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset, 10,
                                        XmNrightAttachment,XmATTACH_FORM,
                                        XmNrightOffset, 10,
                                        XmNbackground, colors[0xff],
                                        NULL);

        time3  = XtVaCreateManagedWidget(langcode("WPUPCFG008"),xmLabelWidgetClass,frame3,
                                        XmNchildType, XmFRAME_TITLE_CHILD,
                                        XmNbackground, colors[0xff],
                                        NULL);

        time_box3 = XmCreateRadioBox(frame3,"Time Options box",al,ac);

        XtVaSetValues(time_box3,
                    XmNnumColumns,4,
                    NULL);

        toption1 = XtVaCreateManagedWidget(langcode("WPUPCFG009"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption1,XmNvalueChangedCallback,gps_time_toggle,"10");


        toption2 = XtVaCreateManagedWidget(langcode("WPUPCFG010"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption2,XmNvalueChangedCallback,gps_time_toggle,"20");


        toption3 = XtVaCreateManagedWidget(langcode("WPUPCFG011"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption3,XmNvalueChangedCallback,gps_time_toggle,"30");

        toption4 = XtVaCreateManagedWidget(langcode("WPUPCFG012"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption4,XmNvalueChangedCallback,gps_time_toggle,"60");

        toption5 = XtVaCreateManagedWidget(langcode("WPUPCFG013"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption5,XmNvalueChangedCallback,gps_time_toggle,"120");

        toption6 = XtVaCreateManagedWidget(langcode("WPUPCFG014"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption6,XmNvalueChangedCallback,gps_time_toggle,"300");

        toption7 = XtVaCreateManagedWidget(langcode("WPUPCFG015"),xmToggleButtonGadgetClass,
                                            time_box3,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(toption7,XmNvalueChangedCallback,gps_time_toggle,"600");


        frame4 = XtVaCreateManagedWidget("frame4", xmFrameWidgetClass, my_form,
                                        XmNtopAttachment,XmATTACH_WIDGET,
                                        XmNtopWidget, frame3,
                                        XmNtopOffset,10,
                                        XmNbottomAttachment,XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset, 10,
                                        XmNrightAttachment,XmATTACH_FORM,
                                        XmNrightOffset, 10,
                                        XmNbackground, colors[0xff],
                                        NULL);

        station_type  = XtVaCreateManagedWidget(langcode("WPUPCFD015"),xmLabelWidgetClass,frame4,
                                        XmNchildType, XmFRAME_TITLE_CHILD,
                                        XmNbackground, colors[0xff],
                                        NULL);

        type_box = XmCreateRadioBox(frame4,"Transmit Options box",al,ac);

        XtVaSetValues(type_box,
                    XmNnumColumns,2,
                    NULL);

        styp1 = XtVaCreateManagedWidget(langcode("WPUPCFD016"),xmToggleButtonGadgetClass,
                                            type_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(styp1,XmNvalueChangedCallback,station_type_toggle,"0");

        styp2 = XtVaCreateManagedWidget(langcode("WPUPCFD017"),xmToggleButtonGadgetClass,
                                            type_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(styp2,XmNvalueChangedCallback,station_type_toggle,"1");

        styp3 = XtVaCreateManagedWidget(langcode("WPUPCFD018"),xmToggleButtonGadgetClass,
                                            type_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(styp3,XmNvalueChangedCallback,station_type_toggle,"2");

        styp4 = XtVaCreateManagedWidget(langcode("WPUPCFD019"),xmToggleButtonGadgetClass,
                                            type_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(styp4,XmNvalueChangedCallback,station_type_toggle,"3");

        styp5 = XtVaCreateManagedWidget(langcode("WPUPCFD021"),xmToggleButtonGadgetClass,
                                            type_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(styp5,XmNvalueChangedCallback,station_type_toggle,"4");

        styp6 = XtVaCreateManagedWidget(langcode("WPUPCFD022"),xmToggleButtonGadgetClass,
                                            type_box,
                                            XmNbackground, colors[0xff],
                                            NULL);
        XtAddCallback(styp6,XmNvalueChangedCallback,station_type_toggle,"5");

        compressed_posit_tx = XtVaCreateManagedWidget(langcode("WPUPCFD024"),xmToggleButtonWidgetClass,my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget, frame4,
                                        XmNtopOffset, 10,
                                        XmNbottomAttachment, XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset,10,
                                        XmNrightAttachment, XmATTACH_NONE,
                                        XmNbackground, colors[0xff],
                                        NULL);

        raw_wx_tx  = XtVaCreateManagedWidget(langcode("WPUPCFD023"),xmToggleButtonWidgetClass,my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget, compressed_posit_tx,
                                        XmNbottomAttachment, XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset, 10,
                                        XmNrightAttachment, XmATTACH_NONE,
                                        XmNbackground, colors[0xff],
                                        NULL);

        altnet_active  = XtVaCreateManagedWidget(langcode("WPUPCFD025"),xmToggleButtonWidgetClass,my_form,
                            XmNtopAttachment, XmATTACH_WIDGET,
                            XmNtopWidget, frame4,
                            XmNtopOffset, 10,
                            XmNbottomAttachment, XmATTACH_NONE,
                            XmNleftAttachment, XmATTACH_NONE,
                            XmNrightAttachment, XmATTACH_FORM,
                            XmNrightOffset, 100,
                            XmNbackground, colors[0xff],
                            NULL);

        altnet_text = XtVaCreateManagedWidget("Altnet_text", xmTextFieldWidgetClass, my_form,
                            XmNeditable,   TRUE,
                            XmNcursorPositionVisible, TRUE,
                            XmNsensitive, TRUE,
                            XmNshadowThickness,    1,
                            XmNcolumns, 9,
                            XmNwidth, ((10*7)+2),
                            XmNmaxLength, 9,
                            XmNbackground, colors[0x0f],
                            XmNtopAttachment,XmATTACH_WIDGET,
                            XmNtopWidget, altnet_active,
                            XmNbottomAttachment,XmATTACH_NONE,
                            XmNleftAttachment, XmATTACH_NONE,
                            XmNrightAttachment,XmATTACH_FORM,
                            XmNrightOffset, 160,
                            NULL);

        frame5 = XtVaCreateManagedWidget("frame5", xmFrameWidgetClass, my_form,
                                        XmNtopAttachment,XmATTACH_WIDGET,
                                        XmNtopWidget, raw_wx_tx,
                                        XmNtopOffset,3,
                                        XmNbottomAttachment,XmATTACH_NONE,
                                        XmNleftAttachment, XmATTACH_FORM,
                                        XmNleftOffset, 10,
                                        XmNrightAttachment,XmATTACH_FORM,
                                        XmNrightOffset, 10,
                                        XmNbackground, colors[0xff],
                                        NULL);

        igate_option  = XtVaCreateManagedWidget(langcode("IGPUPCF000"),xmLabelWidgetClass,frame5,
                                        XmNchildType, XmFRAME_TITLE_CHILD,
                                        XmNbackground, colors[0xff],
                                        NULL);

        igate_box = XmCreateRadioBox(frame5,"Igate Options box",al,ac);

        XtVaSetValues(igate_box,
                    XmNnumColumns,2,
                    NULL);

        igtyp0 = XtVaCreateManagedWidget(langcode("IGPUPCF001"),xmToggleButtonGadgetClass,
                                            igate_box,
                                            XmNbackground, colors[0xff],
                                            NULL);

        XtAddCallback(igtyp0,XmNvalueChangedCallback,igate_type_toggle,"0");

        igtyp1 = XtVaCreateManagedWidget(langcode("IGPUPCF002"),xmToggleButtonGadgetClass,
                                            igate_box,
                                            XmNbackground, colors[0xff],
                                            NULL);

        XtAddCallback(igtyp1,XmNvalueChangedCallback,igate_type_toggle ,"1");

        igtyp2 = XtVaCreateManagedWidget(langcode("IGPUPCF003"),xmToggleButtonGadgetClass,
                                            igate_box,
                                            XmNbackground, colors[0xff],
                                            NULL);

        XtAddCallback(igtyp2,XmNvalueChangedCallback,igate_type_toggle,"2");

        button_ok = XtVaCreateManagedWidget(langcode("UNIOP00001"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget, frame5,
                                        XmNtopOffset, 5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 1,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 2,
                                        XmNbackground, colors[0xff],
                                        NULL);


        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, my_form,
                                        XmNtopAttachment, XmATTACH_WIDGET,
                                        XmNtopWidget, frame5,
                                        XmNtopOffset, 5,
                                        XmNbottomAttachment, XmATTACH_FORM,
                                        XmNbottomOffset, 5,
                                        XmNleftAttachment, XmATTACH_POSITION,
                                        XmNleftPosition, 3,
                                        XmNrightAttachment, XmATTACH_POSITION,
                                        XmNrightPosition, 4,
                                        XmNbackground, colors[0xff],
                                        NULL);

        XtAddCallback(button_ok, XmNactivateCallback, Configure_defaults_change_data, configure_defaults_dialog);
        XtAddCallback(button_cancel, XmNactivateCallback, Configure_defaults_destroy_shell, configure_defaults_dialog);

        switch (sec_old) {
            case(900l):
                XmToggleButtonSetState(time_15,TRUE,FALSE);
                old_station_item=1;
                break;

            case(1800l):
                XmToggleButtonSetState(time_30,TRUE,FALSE);
                old_station_item=2;
                break;

            case(2700l):
                XmToggleButtonSetState(time_45,TRUE,FALSE);
                old_station_item=3;
                break;

            case(3600l):
                XmToggleButtonSetState(time_60,TRUE,FALSE);
                old_station_item=4;
                break;

            case(5400l):
                XmToggleButtonSetState(time_90,TRUE,FALSE);
                old_station_item=5;
                break;

            case(7200l):
                XmToggleButtonSetState(time_120,TRUE,FALSE);
                old_station_item=6;
                break;

            default:
                XmToggleButtonSetState(time_120,TRUE,FALSE);
                old_station_item=6;
                break;
        }

        switch(sec_clear) {
            case(21600l):
                XmToggleButtonSetState(time_6h,TRUE,FALSE);
                clear_station_item=1;
                break;

            case(43200l):
                XmToggleButtonSetState(time_12h,TRUE,FALSE);
                clear_station_item=2;
                break;

            case(86400l):
                XmToggleButtonSetState(time_24h,TRUE,FALSE);
                clear_station_item=3;
                break;

            case(172800l):
                XmToggleButtonSetState(time_48h,TRUE,FALSE);
                clear_station_item=4;
                break;

            case(604800l):
                XmToggleButtonSetState(time_168h,TRUE,FALSE);
                clear_station_item=5;
                break;

            default:
                XmToggleButtonSetState(time_168h,TRUE,FALSE);
                clear_station_item=5;
                break;
        }

        switch(gps_time) {
            case(10):
                XmToggleButtonSetState(toption1,TRUE,FALSE);
                GPS_time=(time_t)10l;
                break;

            case(20):
                XmToggleButtonSetState(toption2,TRUE,FALSE);
                GPS_time=(time_t)20l;
                break;

            case(30):
                XmToggleButtonSetState(toption3,TRUE,FALSE);
                GPS_time=(time_t)30l;
                break;

            case(60):
                XmToggleButtonSetState(toption4,TRUE,FALSE);
                GPS_time=(time_t)60l;
                break;

            case(120):
                XmToggleButtonSetState(toption5,TRUE,FALSE);
                GPS_time=(time_t)120l;
                break;

            case(300):
                XmToggleButtonSetState(toption6,TRUE,FALSE);
                GPS_time=(time_t)300l;
                break;

            case(600):
                XmToggleButtonSetState(toption7,TRUE,FALSE);
                GPS_time=(time_t)600l;
                break;

            default:
                XmToggleButtonSetState(toption1,TRUE,FALSE);
                GPS_time=30;
                break;
        }

        switch(output_station_type) {
            case(0):
                XmToggleButtonSetState(styp1,TRUE,FALSE);
                Station_transmit_type=0;
                break;

            case(1):
                XmToggleButtonSetState(styp2,TRUE,FALSE);
                Station_transmit_type=1;
                break;

            case(2):
                XmToggleButtonSetState(styp3,TRUE,FALSE);
                Station_transmit_type=2;
                break;

            case(3):
                XmToggleButtonSetState(styp4,TRUE,FALSE);
                Station_transmit_type=3;
                break;

            case(4):
                XmToggleButtonSetState(styp5,TRUE,FALSE);
                Station_transmit_type=4;
                break;

            case(5):
                XmToggleButtonSetState(styp6,TRUE,FALSE);
                Station_transmit_type=5;
                break;

            default:
                XmToggleButtonSetState(styp1,TRUE,FALSE);
                Station_transmit_type=0;
                break;

        }

        if (transmit_raw_wx)
            XmToggleButtonSetState(raw_wx_tx,TRUE,FALSE);
        else
            XmToggleButtonSetState(raw_wx_tx,FALSE,FALSE);

        if(transmit_compressed_posit)
            XmToggleButtonSetState(compressed_posit_tx,TRUE,FALSE);
        else
            XmToggleButtonSetState(compressed_posit_tx,FALSE,FALSE);

        XmToggleButtonSetState(altnet_active, altnet, FALSE);
        XmTextSetString(altnet_text, altnet_call);

        switch(operate_as_an_igate) {
            case(0):
                XmToggleButtonSetState(igtyp0,TRUE,FALSE);
                Igate_type=0;
                break;

            case(1):
                XmToggleButtonSetState(igtyp1,TRUE,FALSE);
                Igate_type=1;
                break;

            case(2):
                XmToggleButtonSetState(igtyp2,TRUE,FALSE);
                Igate_type=2;
                break;

            default:
                XmToggleButtonSetState(igtyp0,TRUE,FALSE);
                Igate_type=0;
                break;
        }
        pos_dialog(configure_defaults_dialog);

        delw = XmInternAtom(XtDisplay(configure_defaults_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(configure_defaults_dialog, delw, Configure_defaults_destroy_shell, (XtPointer)configure_defaults_dialog);

        XtManageChild(my_form);
        XtManageChild(time_box);
        XtManageChild(time_box2);
        XtManageChild(time_box3);
        XtManageChild(type_box);
        XtManageChild(igate_box);
        XtManageChild(pane);

        XtPopup(configure_defaults_dialog,XtGrabNone);
        fix_dialog_size(configure_defaults_dialog);
    } else
        (void)XRaiseWindow(XtDisplay(configure_defaults_dialog), XtWindow(configure_defaults_dialog));
}





/////////////////////////////////   Configure Audio Alarms Dialog   ////////////////////////////////


void Configure_audio_alarm_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    XtDestroyWidget(shell);
    configure_audio_alarm_dialog = (Widget)NULL;
}



void Configure_audio_alarm_change_data(Widget widget, XtPointer clientData, XtPointer callData) {
    strcpy(sound_command,XmTextFieldGetString(audio_alarm_config_play_data));
    (void)remove_trailing_spaces(sound_command);
    strcpy(sound_new_station,XmTextFieldGetString(audio_alarm_config_play_ons_data));
    (void)remove_trailing_spaces(sound_new_station);
    strcpy(sound_new_message,XmTextFieldGetString(audio_alarm_config_play_onm_data));
    (void)remove_trailing_spaces(sound_new_message);
    strcpy(sound_prox_message,XmTextFieldGetString(audio_alarm_config_play_onpx_data));
    (void)remove_trailing_spaces(sound_prox_message);
    strcpy(prox_min,XmTextFieldGetString(prox_min_data));
    (void)remove_trailing_spaces(prox_min);
    strcpy(prox_max,XmTextFieldGetString(prox_max_data));
    (void)remove_trailing_spaces(prox_max);
    strcpy(sound_band_open_message,XmTextFieldGetString(audio_alarm_config_play_onbo_data));
    (void)remove_trailing_spaces(sound_band_open_message);
    strcpy(bando_min,XmTextFieldGetString(bando_min_data));
    (void)remove_trailing_spaces(bando_min);
    strcpy(bando_max,XmTextFieldGetString(bando_max_data));
    (void)remove_trailing_spaces(bando_max);
    strcpy(sound_wx_alert_message,XmTextFieldGetString(audio_alarm_config_wx_alert_data));
    (void)remove_trailing_spaces(sound_wx_alert_message);

    if(XmToggleButtonGetState(audio_alarm_config_play_on_new_station))
        sound_play_new_station=1;
    else
        sound_play_new_station=0;

    if(XmToggleButtonGetState(audio_alarm_config_play_on_new_message))
        sound_play_new_message=1;
    else
        sound_play_new_message=0;

    if(XmToggleButtonGetState(audio_alarm_config_play_on_prox))
        sound_play_prox_message=1;
    else
        sound_play_prox_message=0;

    if(XmToggleButtonGetState(audio_alarm_config_play_on_bando))
        sound_play_band_open_message=1;
    else
        sound_play_band_open_message=0;

    if(XmToggleButtonGetState(audio_alarm_config_play_on_wx_alert))
        sound_play_wx_alert_message=1;
    else
        sound_play_wx_alert_message=0;

    Configure_audio_alarm_destroy_shell(widget,clientData,callData);
}



void Configure_audio_alarms( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget  pane, my_form, button_ok, button_cancel,
                audio_play, file1, file2,
                min1, min2, max1, max2,
                minb1, minb2, maxb1, maxb2,
                sep;
    Atom delw;

    if (!configure_audio_alarm_dialog) {
        configure_audio_alarm_dialog = XtVaCreatePopupShell(langcode("WPUPCFA001"),xmDialogShellWidgetClass,Global.top,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, configure_audio_alarm_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 5,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);

        audio_play = XtVaCreateManagedWidget(langcode("WPUPCFA002"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_FORM,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_data = XtVaCreateManagedWidget("Play Command", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 25,
                                      XmNwidth, ((25*7)+2),
                                      XmNmaxLength, 80,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_FORM,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget, audio_play,
                                      XmNrightAttachment,XmATTACH_FORM,
                                      XmNrightOffset, 10,
                                      NULL);


        file1 = XtVaCreateManagedWidget(langcode("WPUPCFA003"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_play,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        file2 = XtVaCreateManagedWidget(langcode("WPUPCFA004"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_play,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_on_new_station  = XtVaCreateManagedWidget(langcode("WPUPCFA005"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, file1,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_ons_data = XtVaCreateManagedWidget("Play Command NS", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 25,
                                      XmNwidth, ((25*7)+2),
                                      XmNmaxLength, 80,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, file2,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNleftWidget, audio_alarm_config_play_on_new_station,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        audio_alarm_config_play_on_new_message  = XtVaCreateManagedWidget(langcode("WPUPCFA006"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_new_station,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_onm_data = XtVaCreateManagedWidget("Play Command NM", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 25,
                                      XmNwidth, ((25*7)+2),
                                      XmNmaxLength, 80,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_new_station,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        audio_alarm_config_play_on_prox  = XtVaCreateManagedWidget(langcode("WPUPCFA007"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_new_message,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_onpx_data = XtVaCreateManagedWidget("Play Command PROX", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 25,
                                      XmNwidth, ((25*7)+2),
                                      XmNmaxLength, 80,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_new_message,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        min1 = XtVaCreateManagedWidget(langcode("WPUPCFA009"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_prox,
                                      XmNtopOffset, 8,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset, 30,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        prox_min_data = XtVaCreateManagedWidget("prox min", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 10,
                                      XmNwidth, ((10*7)+2),
                                      XmNmaxLength, 20,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_onpx_data,
                                      XmNtopOffset, 2,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNleftOffset, 20,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        min2 = XtVaCreateManagedWidget(units_english_metric?langcode("UNIOP00004"):langcode("UNIOP00005"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_prox,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget, prox_min_data,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        max1 = XtVaCreateManagedWidget(langcode("WPUPCFA010"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, min1,
                                      XmNtopOffset, 12,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset, 30,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        prox_max_data = XtVaCreateManagedWidget("prox max", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 10,
                                      XmNwidth, ((10*7)+2),
                                      XmNmaxLength, 20,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, prox_min_data,
                                      XmNtopOffset, 2,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNleftOffset, 20,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        max2 = XtVaCreateManagedWidget(units_english_metric?langcode("UNIOP00004"):langcode("UNIOP00005"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, min1,
                                      XmNtopOffset, 14,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget, prox_max_data,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_on_bando  = XtVaCreateManagedWidget(langcode("WPUPCFA008"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, max1,
                                      XmNtopOffset, 12,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_onbo_data = XtVaCreateManagedWidget("Play Command BAND", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 25,
                                      XmNwidth, ((25*7)+2),
                                      XmNmaxLength, 80,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, prox_max_data,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        minb1 = XtVaCreateManagedWidget(langcode("WPUPCFA009"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_bando,
                                      XmNtopOffset, 12,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset, 30,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        bando_min_data = XtVaCreateManagedWidget("bando min", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 12,
                                      XmNwidth, ((10*7)+2),
                                      XmNmaxLength, 20,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_onbo_data,
                                      XmNtopOffset, 2,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNleftOffset, 20,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        minb2 = XtVaCreateManagedWidget(units_english_metric?langcode("UNIOP00004"):langcode("UNIOP00005"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_bando,
                                      XmNtopOffset, 14,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget, bando_min_data,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        maxb1 = XtVaCreateManagedWidget(langcode("WPUPCFA010"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, minb1,
                                      XmNtopOffset, 12,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset, 30,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        bando_max_data = XtVaCreateManagedWidget("bando max", xmTextFieldWidgetClass, my_form,
                                      XmNeditable,   TRUE,
                                      XmNcursorPositionVisible, TRUE,
                                      XmNsensitive, TRUE,
                                      XmNshadowThickness,    1,
                                      XmNcolumns, 10,
                                      XmNwidth, ((10*7)+2),
                                      XmNmaxLength, 20,
                                      XmNbackground, colors[0x0f],
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, bando_min_data,
                                      XmNtopOffset, 2,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 2,
                                      XmNleftOffset, 20,
                                      XmNrightAttachment,XmATTACH_NONE,
                                      NULL);

        maxb2 = XtVaCreateManagedWidget(units_english_metric?langcode("UNIOP00004"):langcode("UNIOP00005"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, minb1,
                                      XmNtopOffset, 14,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_WIDGET,
                                      XmNleftWidget, bando_max_data,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        audio_alarm_config_play_on_wx_alert  = XtVaCreateManagedWidget(langcode("WPUPCFA011"),xmToggleButtonWidgetClass,my_form,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, maxb2,
                                XmNtopOffset, 12,
                                XmNbottomAttachment, XmATTACH_NONE,
                                XmNleftAttachment, XmATTACH_POSITION,
                                XmNleftPosition, 0,
                                XmNleftOffset, 10,
                                XmNrightAttachment, XmATTACH_NONE,
                                XmNbackground, colors[0xff],
                                NULL);

        audio_alarm_config_wx_alert_data = XtVaCreateManagedWidget("Play Command WxAlert", xmTextFieldWidgetClass, my_form,
                                XmNeditable, TRUE,
                                XmNcursorPositionVisible, TRUE,
                                XmNsensitive, TRUE,
                                XmNshadowThickness, 1,
                                XmNcolumns, 25,
                                XmNwidth, ((25*7)+2),
                                XmNmaxLength, 80,
                                XmNbackground, colors[0x0f],
                                XmNtopAttachment,XmATTACH_WIDGET,
                                XmNtopWidget, bando_max_data,
                                XmNtopOffset, 5,
                                XmNbottomAttachment, XmATTACH_NONE,
                                XmNleftAttachment, XmATTACH_POSITION,
                                XmNleftPosition, 2,
                                XmNrightAttachment, XmATTACH_NONE,
                                NULL);

        sep = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass,my_form,
                                      XmNorientation, XmHORIZONTAL,
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, audio_alarm_config_play_on_wx_alert,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNrightAttachment,XmATTACH_FORM,
                                      XmNbackground, colors[0xff],
                                      NULL);

        button_ok = XtVaCreateManagedWidget(langcode("UNIOP00001"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 1,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 2,
                                      XmNbackground, colors[0xff],
                                      NULL);

        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 3,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 4,
                                      XmNbackground, colors[0xff],
                                      NULL);

        XtAddCallback(button_ok, XmNactivateCallback, Configure_audio_alarm_change_data, configure_audio_alarm_dialog);
        XtAddCallback(button_cancel, XmNactivateCallback, Configure_audio_alarm_destroy_shell, configure_audio_alarm_dialog);

        pos_dialog(configure_audio_alarm_dialog);

        delw = XmInternAtom(XtDisplay(configure_audio_alarm_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(configure_audio_alarm_dialog, delw, Configure_audio_alarm_destroy_shell,
                (XtPointer)configure_audio_alarm_dialog);

        XmTextFieldSetString(audio_alarm_config_play_data,sound_command);
        XmTextFieldSetString(audio_alarm_config_play_ons_data,sound_new_station);
        XmTextFieldSetString(audio_alarm_config_play_onm_data,sound_new_message);
        XmTextFieldSetString(audio_alarm_config_play_onpx_data,sound_prox_message);
        XmTextFieldSetString(prox_min_data,prox_min);
        XmTextFieldSetString(prox_max_data,prox_max);
        XmTextFieldSetString(audio_alarm_config_play_onbo_data,sound_band_open_message);
        XmTextFieldSetString(bando_min_data,bando_min);
        XmTextFieldSetString(bando_max_data,bando_max);
        XmTextFieldSetString(audio_alarm_config_wx_alert_data, sound_wx_alert_message);

        if(sound_play_new_station)
            XmToggleButtonSetState(audio_alarm_config_play_on_new_station,TRUE,FALSE);
        else
            XmToggleButtonSetState(audio_alarm_config_play_on_new_station,FALSE,FALSE);

        if(sound_play_new_message)
            XmToggleButtonSetState(audio_alarm_config_play_on_new_message,TRUE,FALSE);
        else
            XmToggleButtonSetState(audio_alarm_config_play_on_new_message,FALSE,FALSE);

        if(sound_play_prox_message)
            XmToggleButtonSetState(audio_alarm_config_play_on_prox,TRUE,FALSE);
        else
            XmToggleButtonSetState(audio_alarm_config_play_on_prox,FALSE,FALSE);

        if(sound_play_band_open_message)
            XmToggleButtonSetState(audio_alarm_config_play_on_bando,TRUE,FALSE);
        else
            XmToggleButtonSetState(audio_alarm_config_play_on_bando,FALSE,FALSE);

        if (sound_play_wx_alert_message)
            XmToggleButtonSetState(audio_alarm_config_play_on_wx_alert, TRUE, FALSE);
        else
            XmToggleButtonSetState(audio_alarm_config_play_on_wx_alert, FALSE, FALSE);

        XtManageChild(my_form);
        XtManageChild(pane);

        XtPopup(configure_audio_alarm_dialog,XtGrabNone);
        fix_dialog_size(configure_audio_alarm_dialog);
    } else
        (void)XRaiseWindow(XtDisplay(configure_audio_alarm_dialog), XtWindow(configure_audio_alarm_dialog));

}





/////////////////////////////////////   Configure Speech Dialog   //////////////////////////////////


//WE7U
void Configure_speech_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    XtDestroyWidget(shell);
    configure_speech_dialog = (Widget)NULL;
}


void Configure_speech_change_data(Widget widget, XtPointer clientData, XtPointer callData) {

    if(XmToggleButtonGetState(speech_config_play_on_new_station))
        festival_speak_new_station=1;
    else
        festival_speak_new_station=0;

    if(XmToggleButtonGetState(speech_config_play_on_new_message_alert))
        festival_speak_new_message_alert=1;
    else
        festival_speak_new_message_alert=0;

    if(XmToggleButtonGetState(speech_config_play_on_new_message_body))
        festival_speak_new_message_body=1;
    else
        festival_speak_new_message_body=0;

    if(XmToggleButtonGetState(speech_config_play_on_prox))
        festival_speak_proximity_alert=1;
    else
        festival_speak_proximity_alert=0;

    if(XmToggleButtonGetState(speech_config_play_on_bando))
        festival_speak_band_opening=1;
    else
        festival_speak_band_opening=0;

    if(XmToggleButtonGetState(speech_config_play_on_new_wx_alert))
        festival_speak_new_wx_alert=1;
    else
        festival_speak_new_wx_alert=0;

    Configure_speech_destroy_shell(widget,clientData,callData);
}



//Make it helpful - Gray the config selections, but add a choice
//that basicly pops up a box that says where to get Festival, have
//it be ungrayed if Festival isn't installed.

void Configure_speech( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget  pane, my_form, button_ok, button_cancel, file1, sep;
    Atom delw;

    if (!configure_speech_dialog) {
        configure_speech_dialog = XtVaCreatePopupShell(langcode("WPUPCFSP01"),xmDialogShellWidgetClass,Global.top,
                                  XmNdeleteResponse,XmDESTROY,
                                  XmNdefaultPosition, FALSE,
                                  NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, configure_speech_dialog,
                          XmNbackground, colors[0xff],
                          NULL);

        my_form =  XtVaCreateWidget("form2",xmFormWidgetClass, pane,
                            XmNfractionBase, 5,
                            XmNbackground, colors[0xff],
                            XmNautoUnmanage, FALSE,
                            XmNshadowThickness, 1,
                            NULL);

        file1 = XtVaCreateManagedWidget(langcode("WPUPCFSP02"),xmLabelWidgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_FORM,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset, 10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
                                      NULL);

        speech_config_play_on_new_station  = XtVaCreateManagedWidget(langcode("WPUPCFSP03"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, file1,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
#ifndef HAVE_FESTIVAL
                                      XmNsensitive, FALSE,
#endif /* HAVE_FESTIVAL */
                                      NULL);

        speech_config_play_on_new_message_alert  = XtVaCreateManagedWidget(langcode("WPUPCFSP04"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, speech_config_play_on_new_station,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
#ifndef HAVE_FESTIVAL
                                      XmNsensitive, FALSE,
#endif /* HAVE_FESTIVAL */
                                      NULL);

        speech_config_play_on_new_message_body  = XtVaCreateManagedWidget(langcode("WPUPCFSP05"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, speech_config_play_on_new_message_alert,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
#ifndef HAVE_FESTIVAL
                                      XmNsensitive, FALSE,
#endif /* HAVE_FESTIVAL */
                                      NULL);

        speech_config_play_on_prox  = XtVaCreateManagedWidget(langcode("WPUPCFSP06"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, speech_config_play_on_new_message_body,
                                      XmNtopOffset, 10,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
#ifndef HAVE_FESTIVAL
                                      XmNsensitive, FALSE,
#endif /* HAVE_FESTIVAL */
                                      NULL);

        speech_config_play_on_bando  = XtVaCreateManagedWidget(langcode("WPUPCFSP07"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, speech_config_play_on_prox,
                                      XmNtopOffset, 12,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
#ifndef HAVE_FESTIVAL
                                      XmNsensitive, FALSE,
#endif /* HAVE_FESTIVAL */
                                      NULL);

        speech_config_play_on_new_wx_alert  = XtVaCreateManagedWidget(langcode("WPUPCFSP08"),xmToggleButtonWidgetClass,my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, speech_config_play_on_bando,
                                      XmNtopOffset, 12,
                                      XmNbottomAttachment, XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 0,
                                      XmNleftOffset ,10,
                                      XmNrightAttachment, XmATTACH_NONE,
                                      XmNbackground, colors[0xff],
//#ifndef HAVE_FESTIVAL
                                      XmNsensitive, FALSE,
//#endif /* HAVE_FESTIVAL */
                                      NULL);


        sep = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass,my_form,
                                      XmNorientation, XmHORIZONTAL,
                                      XmNtopAttachment,XmATTACH_WIDGET,
                                      XmNtopWidget, speech_config_play_on_new_wx_alert,
                                      XmNtopOffset, 20,
                                      XmNbottomAttachment,XmATTACH_NONE,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNrightAttachment,XmATTACH_FORM,
                                      XmNbackground, colors[0xff],
                                      NULL);

        button_ok = XtVaCreateManagedWidget(langcode("UNIOP00001"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 1,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 2,
                                      XmNbackground, colors[0xff],
                                      NULL);

        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, my_form,
                                      XmNtopAttachment, XmATTACH_WIDGET,
                                      XmNtopWidget, sep,
                                      XmNtopOffset, 5,
                                      XmNbottomAttachment, XmATTACH_FORM,
                                      XmNbottomOffset, 5,
                                      XmNleftAttachment, XmATTACH_POSITION,
                                      XmNleftPosition, 3,
                                      XmNrightAttachment, XmATTACH_POSITION,
                                      XmNrightPosition, 4,
                                      XmNbackground, colors[0xff],
                                      NULL);

        XtAddCallback(button_ok, XmNactivateCallback, Configure_speech_change_data, configure_speech_dialog);
        XtAddCallback(button_cancel, XmNactivateCallback, Configure_speech_destroy_shell, configure_speech_dialog);

        pos_dialog(configure_speech_dialog);

        delw = XmInternAtom(XtDisplay(configure_speech_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(configure_speech_dialog, delw, Configure_speech_destroy_shell,
                (XtPointer)configure_speech_dialog);


        if(festival_speak_new_station)
            XmToggleButtonSetState(speech_config_play_on_new_station,TRUE,FALSE);
        else
            XmToggleButtonSetState(speech_config_play_on_new_station,FALSE,FALSE);

        if(festival_speak_new_message_alert)
            XmToggleButtonSetState(speech_config_play_on_new_message_alert,TRUE,FALSE);
        else
            XmToggleButtonSetState(speech_config_play_on_new_message_alert,FALSE,FALSE);

        if(festival_speak_new_message_body)
            XmToggleButtonSetState(speech_config_play_on_new_message_body,TRUE,FALSE);
        else
            XmToggleButtonSetState(speech_config_play_on_new_message_body,FALSE,FALSE);

        if(festival_speak_proximity_alert)
            XmToggleButtonSetState(speech_config_play_on_prox,TRUE,FALSE);
        else
            XmToggleButtonSetState(speech_config_play_on_prox,FALSE,FALSE);

        if(festival_speak_band_opening)
            XmToggleButtonSetState(speech_config_play_on_bando,TRUE,FALSE);
        else
            XmToggleButtonSetState(speech_config_play_on_bando,FALSE,FALSE);

        if(festival_speak_new_wx_alert)
            XmToggleButtonSetState(speech_config_play_on_new_wx_alert,TRUE,FALSE);
        else
            XmToggleButtonSetState(speech_config_play_on_new_wx_alert,FALSE,FALSE);

        XtManageChild(my_form);
        XtManageChild(pane);

        XtPopup(configure_speech_dialog,XtGrabNone);
        fix_dialog_size(configure_speech_dialog);
    } else
        (void)XRaiseWindow(XtDisplay(configure_speech_dialog), XtWindow(configure_speech_dialog));

}





/////////////////////////////////////////   Object Dialog   //////////////////////////////////////////


/*
 *  Destroy Object Dialog Popup Window
 */
void Object_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    (void)XFreePixmap(XtDisplay(appshell),Ob_icon0);
    (void)XFreePixmap(XtDisplay(appshell),Ob_icon);
    XtDestroyWidget(shell);
    object_dialog = (Widget)NULL;
}


/*
 *  Setup APRS Information Field for Objects
 */
int Setup_object_data(char *line) {
    char lat_str[MAX_LAT];
    char lon_str[MAX_LONG];
    char comment[34+1];                 // max 34 characters of comment
    char time[7+1];
    struct tm *day_time;
    time_t sec;

    sprintf(line,"%s",XmTextFieldGetString(object_name_data));
    (void)remove_trailing_spaces(line);
    (void)to_upper(line);
    if (!valid_object(line))
        return(0);

    strcpy(last_object,line);

    strcpy(line,XmTextFieldGetString(object_lat_data_ns));
    if((char)toupper((int)line[0]) == 'S')
        line[0] = 'S';
    else
        line[0] = 'N';
    sprintf(lat_str,"%02d%05.2f%c",atoi(XmTextFieldGetString(object_lat_data_deg)),
        atof(XmTextFieldGetString(object_lat_data_min)),line[0]);

    strcpy(line,XmTextFieldGetString(object_lon_data_ew));
    if((char)toupper((int)line[0]) == 'E')
        line[0] = 'E';
    else
        line[0] = 'W';
    sprintf(lon_str,"%03d%05.2f%c",atoi(XmTextFieldGetString(object_lon_data_deg)),
        atof(XmTextFieldGetString(object_lon_data_min)),line[0]);

    strcpy(line,XmTextFieldGetString(object_group_data));
    last_obj_grp = line[0];
    if(isalpha((int)last_obj_grp))
        last_obj_grp = toupper((int)line[0]);          // todo: toupper in dialog

    strcpy(line,XmTextFieldGetString(object_symbol_data));
    last_obj_sym = line[0];

    strcpy(comment,XmTextFieldGetString(object_comment_data));
    (void)remove_trailing_spaces(comment);

    sec = sec_now();
    day_time = gmtime(&sec);
    sprintf(time,"%02d%02d%02dz",day_time->tm_mday,day_time->tm_hour,day_time->tm_min);
    
    sprintf(line,";%-9s*%s%s%c%s%c%s",last_object,time,lat_str,last_obj_grp,lon_str,last_obj_sym,comment);
    return(1);
}


/*
 *  Set an Object
 */
void Object_change_data_set(/*@unused@*/ Widget widget, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    char line[43+1+40];                 // ???
    
    if (Setup_object_data(line)) {
        output_my_data(line,-1,0);              // transmit object data
        Object_destroy_shell(widget,clientData,callData);
    } else {
        // error message
    }
}


/*
 *  Delete an Object
 */
void Object_change_data_del(/*@unused@*/ Widget widget, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    char line[43+1+40];                 // ???
    
    if (Setup_object_data(line)) {
        line[10] = '_';                         // mark as deleted object
        output_my_data(line,-1,0);              // transmit object data
        Object_destroy_shell(widget,clientData,callData);
    }
}


/*
 *  Update symbol picture for changed symbol or table
 */
void updateObjectPictureCallback(/*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    char table, overlay;
    char symb, group;

    XtVaSetValues(object_icon, XmNlabelPixmap, Ob_icon0, NULL);         // clear old icon
    XtManageChild(object_icon);

    group = (XmTextFieldGetString(object_group_data))[0];
    symb  = (XmTextFieldGetString(object_symbol_data))[0];
    if (group == '/' || group == '\\') {
        table   = group;
        overlay = ' ';
    } else {
        table   = '\\';
        overlay = group;
    }
    symbol(object_icon,0,table,symb,overlay,Ob_icon,0,0,0,' ');         // create icon

    XtVaSetValues(object_icon,XmNlabelPixmap,Ob_icon,NULL);             // draw new icon
    XtManageChild(object_icon);
}


/*
 *  Setup Object Dialog
 */
void Set_Del_Object( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer calldata) {
    Dimension width, height;
    long lat,lon;
    char lat_str[MAX_LAT];
    char lon_str[MAX_LONG];
    static Widget ob_pane, ob_form,
                ob_name,
                ob_lat, ob_lat_deg, ob_lat_min, ob_lat_ns,
                ob_lon, ob_lon_deg, ob_lon_min, ob_lon_ew,
                ob_frame, ob_form1, ob_ts, ob_group, ob_symbol, 
                ob_comment,
                ob_sep, ob_button_set, ob_button_del,ob_button_cancel;
    char temp_data[40];
    Atom delw;

    // get default position for object, the position we have clicked at
    XtVaGetValues(da,XmNwidth, &width,XmNheight, &height,0);
    lon = mid_x_long_offset - ((width*size)/2)  + (menu_x*size);
    lat = mid_y_lat_offset  - ((height*size)/2) + (menu_y*size);

    if(object_dialog)           // it is already open
        (void)XRaiseWindow(XtDisplay(object_dialog), XtWindow(object_dialog));
    else {                      // create new popup window
        object_dialog = XtVaCreatePopupShell(langcode("POPUPOB001"),xmDialogShellWidgetClass,Global.top,
                            XmNdeleteResponse,          XmDESTROY,
                            XmNdefaultPosition,         FALSE,
                            NULL);

        ob_pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, object_dialog,
                            XmNbackground,              colors[0xff],
                            NULL);

        ob_form =  XtVaCreateWidget("form2",xmFormWidgetClass, ob_pane,
                            XmNfractionBase,            5,
                            XmNautoUnmanage,            FALSE,
                            XmNshadowThickness,         1,
                            XmNbackground,              colors[0xff],
                            NULL);

        // "Name"
        ob_name = XtVaCreateManagedWidget(langcode("POPUPOB002"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // object name
        object_name_data = XtVaCreateManagedWidget("name_data", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 9,
                            XmNwidth,                   ((9*7)+2),
                            XmNmaxLength,               9,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);

        // "LAT"
        ob_lat = XtVaCreateManagedWidget(langcode("WPUPCFS003"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // lat deg
        object_lat_data_deg = XtVaCreateManagedWidget("lat_deg", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 3,
                            XmNmaxLength,               2,
                            XmNtopOffset,               20,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);
        // "deg"
        ob_lat_deg = XtVaCreateManagedWidget(langcode("WPUPCFS004"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_lat_data_deg,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // lat min
        object_lat_data_min = XtVaCreateManagedWidget("lat_min", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 6,
                            XmNmaxLength,               6,
                            XmNtopOffset,               20,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_lat_deg,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);
        // "min"
        ob_lat_min = XtVaCreateManagedWidget(langcode("WPUPCFS005"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_lat_data_min,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // N/S
        object_lat_data_ns = XtVaCreateManagedWidget("lat_ns", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               20,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_lat_min,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);
        // "(N/S)"
        ob_lat_ns = XtVaCreateManagedWidget(langcode("WPUPCFS006"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_name,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_lat_data_ns,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        // "LONG"
        ob_lon = XtVaCreateManagedWidget(langcode("WPUPCFS007"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // long
        object_lon_data_deg = XtVaCreateManagedWidget("long_deg", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 3,
                            XmNmaxLength,               3,
                            XmNtopOffset,               14,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);
        // "deg"
        ob_lon_deg = XtVaCreateManagedWidget(langcode("WPUPCFS004"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_lon_data_deg,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // min
        object_lon_data_min = XtVaCreateManagedWidget("long_min", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 6,
                            XmNmaxLength,               6,
                            XmNtopOffset,               14,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_lon_deg,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);
        // "min"
        ob_lon_min = XtVaCreateManagedWidget(langcode("WPUPCFS005"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_lon_data_min,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // E/W
        object_lon_data_ew = XtVaCreateManagedWidget("long_ew", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               14,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_lon_min,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0x0f],
                            NULL);
        // "(E/W)"
        ob_lon_ew = XtVaCreateManagedWidget(langcode("WPUPCFS008"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_lon_data_ew,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

//----- Frame for table / symbol
        ob_frame = XtVaCreateManagedWidget("frame1", xmFrameWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_lon_ew,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNrightOffset,             10,
                            XmNbackground,              colors[0xff],
                            NULL);
        // "Station Symbol"
        ob_ts  = XtVaCreateManagedWidget(langcode("WPUPCFS009"),xmLabelWidgetClass,ob_frame,
                            XmNchildType,               XmFRAME_TITLE_CHILD,
                            XmNbackground,              colors[0xff],
                            NULL);

        ob_form1 =  XtVaCreateWidget("form1",xmFormWidgetClass, ob_frame,
                            XmNfractionBase,            5,
                            XmNbackground,              colors[0xff],
                            NULL);

        // "Group/overlay"
        ob_group = XtVaCreateManagedWidget(langcode("WPUPCFS010"),xmLabelWidgetClass, ob_form1,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            10,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              100,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // table
        object_group_data = XtVaCreateManagedWidget("group", xmTextFieldWidgetClass, ob_form1,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_group,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        // "Symbol"
        ob_symbol = XtVaCreateManagedWidget(langcode("WPUPCFS011"),xmLabelWidgetClass, ob_form1,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_group_data,
                            XmNleftOffset,              20,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // symbol
        object_symbol_data = XtVaCreateManagedWidget("symbol", xmTextFieldWidgetClass, ob_form1,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_symbol,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        // icon
        Ob_icon0 = XCreatePixmap(XtDisplay(appshell),RootWindowOfScreen(XtScreen(appshell)),20,20,
                    DefaultDepthOfScreen(XtScreen(appshell)));
        Ob_icon  = XCreatePixmap(XtDisplay(appshell),RootWindowOfScreen(XtScreen(appshell)),20,20,
                    DefaultDepthOfScreen(XtScreen(appshell)));
        object_icon = XtVaCreateManagedWidget("icon", xmLabelWidgetClass, ob_form1,
                            XmNlabelType,               XmPIXMAP,
                            XmNlabelPixmap,             Ob_icon,
                            XmNbackground,              colors[0xff],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              object_symbol_data,
                            XmNleftOffset,              15,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

//----- Comment Field
        // "Comment:"
        ob_comment = XtVaCreateManagedWidget(langcode("WPUPCFS017"),xmLabelWidgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_frame,
                            XmNtopOffset,               15,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        object_comment_data = XtVaCreateManagedWidget("comment", xmTextFieldWidgetClass, ob_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 43,     // max 43 without Data Extension
                            XmNwidth,                   ((43*7)+2),
                            XmNmaxLength,               43,
                            XmNtopOffset,               11,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              ob_comment,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_frame,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

//----- Buttons
        ob_sep = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass,ob_form,
                            XmNorientation,             XmHORIZONTAL,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_comment,
                            XmNtopOffset,               14,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNbackground,              colors[0xff],
                            NULL);

        ob_button_set = XtVaCreateManagedWidget(langcode("POPUPOB003"),xmPushButtonGadgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_sep,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            5,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            1,
                            XmNrightAttachment,         XmATTACH_POSITION,
                            XmNrightPosition,           2,
                            XmNbackground,              colors[0xff],
                            NULL);

        ob_button_del = XtVaCreateManagedWidget(langcode("POPUPOB004"),xmPushButtonGadgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_sep,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            5,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_POSITION,
                            XmNrightPosition,           3,
                            XmNbackground,              colors[0xff],
                            NULL);

        ob_button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, ob_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               ob_sep,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            5,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            3,
                            XmNrightAttachment,         XmATTACH_POSITION,
                            XmNrightPosition,           4,
                            XmNbackground,              colors[0xff],
                            NULL);

        XtAddCallback(ob_button_set,    XmNactivateCallback, Object_change_data_set, object_dialog);
        XtAddCallback(ob_button_del,    XmNactivateCallback, Object_change_data_del, object_dialog);
        XtAddCallback(ob_button_cancel, XmNactivateCallback, Object_destroy_shell,   object_dialog);

        // fill in current data
        XmTextFieldSetString(object_name_data,last_object);

        convert_lat_l2s(lat,lat_str,CONVERT_HP_NOSP);
        substr(temp_data,lat_str,2);
        XmTextFieldSetString(object_lat_data_deg,temp_data);
        substr(temp_data,lat_str+2,6);
        XmTextFieldSetString(object_lat_data_min,temp_data);
        substr(temp_data,lat_str+8,1);
        XmTextFieldSetString(object_lat_data_ns,temp_data);

        convert_lon_l2s(lon,lon_str,CONVERT_HP_NOSP);
        substr(temp_data,lon_str,3);
        XmTextFieldSetString(object_lon_data_deg,temp_data);
        substr(temp_data,lon_str+3,6);
        XmTextFieldSetString(object_lon_data_min,temp_data);
        substr(temp_data,lon_str+9,1);
        XmTextFieldSetString(object_lon_data_ew,temp_data);

        temp_data[0] = last_obj_grp;
        temp_data[1] = '\0';
        XmTextFieldSetString(object_group_data,temp_data);
        XtAddCallback(object_group_data, XmNvalueChangedCallback, updateObjectPictureCallback, object_dialog);

        temp_data[0] = last_obj_sym;
        temp_data[1] = '\0';
        XmTextFieldSetString(object_symbol_data,temp_data);
        XtAddCallback(object_symbol_data, XmNvalueChangedCallback, updateObjectPictureCallback, object_dialog);

        // update symbol picture
        (void)updateObjectPictureCallback((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);

        XmTextFieldSetString(object_comment_data,"");
        
        pos_dialog(object_dialog);

        delw = XmInternAtom(XtDisplay(object_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(object_dialog, delw, Object_destroy_shell, (XtPointer)object_dialog);

        XtManageChild(ob_form);
        XtManageChild(ob_form1);
        XtManageChild(ob_pane);

        XtPopup(object_dialog,XtGrabNone);
        fix_dialog_size(object_dialog);         // don't allow a resize
    }
}





////////////////////////////////////   Configure Station Dialog   /////////////////////////////////////


/*
 *  Destroy Configure Station Dialog Popup Window
 */
void Configure_station_destroy_shell( /*@unused@*/ Widget widget, XtPointer clientData, /*@unused@*/ XtPointer callData) {
    Widget shell = (Widget) clientData;
    XtPopdown(shell);
    (void)XFreePixmap(XtDisplay(appshell),CS_icon0);  // ???? DK7IN: avoid possible memory leak ?
    (void)XFreePixmap(XtDisplay(appshell),CS_icon);
    XtDestroyWidget(shell);
    configure_station_dialog = (Widget)NULL;
}



void  Configure_station_toggle( /*@unused@*/ Widget widget, XtPointer clientData, XtPointer callData) {
    char *which = (char *)clientData;
    XmToggleButtonCallbackStruct *state = (XmToggleButtonCallbackStruct *)callData;

    if(state->set)
        Configure_station_pos_amb = atoi(which);
    else
        Configure_station_pos_amb = 0;
}


/*
 *  Process changes to station data
 */
void Configure_station_change_data(Widget widget, XtPointer clientData, XtPointer callData) {
    char temp[40];
    char old_callsign[MAX_CALL+1];

    strcpy(old_callsign,my_callsign);
    /*printf("Changing Configure station data\n");*/

    sprintf(my_callsign,"%s",XmTextFieldGetString(station_config_call_data));
    (void)remove_trailing_spaces(my_callsign);
    (void)to_upper(my_callsign);

    strcpy(temp,XmTextFieldGetString(station_config_slat_data_ns));
    if((char)toupper((int)temp[0])=='S')
        temp[0]='S';
    else
        temp[0]='N';
    sprintf(my_lat,"%02d%06.3f%c",atoi(XmTextFieldGetString(station_config_slat_data_deg)),
        atof(XmTextFieldGetString(station_config_slat_data_min)),temp[0]);

    strcpy(temp,XmTextFieldGetString(station_config_slong_data_ew));
    if((char)toupper((int)temp[0])=='E')
        temp[0]='E';
    else
        temp[0]='W';
    sprintf(my_long,"%03d%06.3f%c",atoi(XmTextFieldGetString(station_config_slong_data_deg)),
        atof(XmTextFieldGetString(station_config_slong_data_min)),temp[0]);

    strcpy(temp,XmTextFieldGetString(station_config_group_data));
    my_group=temp[0];
    if(isalpha((int)my_group))
        my_group=toupper((int)temp[0]);

    strcpy(temp,XmTextFieldGetString(station_config_symbol_data));
    my_symbol=temp[0];

    strcpy(temp,XmTextFieldGetString(station_config_power_data));
    strcat(temp,XmTextFieldGetString(station_config_height_data));
    strcat(temp,XmTextFieldGetString(station_config_gain_data));
    strcat(temp,XmTextFieldGetString(station_config_direction_data));
    if(isdigit((int)temp[0]) && isdigit((int)temp[1]) && isdigit((int)temp[2]) && isdigit((int)temp[3]))
        sprintf(my_phg,"PHG%s/",temp);
    else
        my_phg[0]='\0';

    /* set station ambiguity*/
    position_amb_chars = Configure_station_pos_amb;

    strcpy(my_comment,XmTextFieldGetString(station_config_comment_data));
    (void)remove_trailing_spaces(my_comment);

    /* TO DO: KILL only my station data? */
    station_del(old_callsign);  // move to new sort location...
    my_station_add(my_callsign,my_group,my_symbol,my_long,my_lat,my_phg,my_comment);
    redraw_on_new_data=2;
    Configure_station_destroy_shell(widget,clientData,callData);
}


/*
 *  Update symbol picture for changed symbol or table
 */
void updateSymbolPictureCallback( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    char table, overlay;
    char symb, group;

    XtVaSetValues(station_config_icon, XmNlabelPixmap, CS_icon0, NULL);         // clear old icon
    XtManageChild(station_config_icon);

    group = (XmTextFieldGetString(station_config_group_data))[0];
    symb  = (XmTextFieldGetString(station_config_symbol_data))[0];
    if (group == '/' || group == '\\') {
        table   = group;
        overlay = ' ';
    } else {
        table   = '\\';
        overlay = group;
    }
    symbol(station_config_icon,0,table,symb,overlay,CS_icon,0,0,0,' ');         // create icon

    XtVaSetValues(station_config_icon,XmNlabelPixmap,CS_icon,NULL);             // draw new icon
    XtManageChild(station_config_icon);
}


//WE7U
/*
 *  Setup Configure Station dialog
 */
void Configure_station( /*@unused@*/ Widget w, /*@unused@*/ XtPointer clientData, /*@unused@*/ XtPointer callData) {
    static Widget  pane, cs_form, cs_form1, cs_form2, button_ok, button_cancel, call, frame, frame1, frame2,
                slat,
                slat_deg,  slat_min, slat_ns,
                slong,
                slong_deg, slong_min, slong_ew,
                sts, group, st_symbol, comment,
                pg, power, height, gain, direction,
                posamb,option_box,posamb0,posamb1,posamb2,posamb3,posamb4,
                sep;
    char temp_data[40];
    Atom delw;
    Arg al[2];                    /* Arg List */
    register unsigned int ac = 0;           /* Arg Count */

    if(!configure_station_dialog) {
        configure_station_dialog = XtVaCreatePopupShell(langcode("WPUPCFS001"),xmDialogShellWidgetClass,Global.top,
                            XmNdeleteResponse,          XmDESTROY,
                            XmNdefaultPosition,         FALSE,
                            NULL);

        pane = XtVaCreateWidget("pane",xmPanedWindowWidgetClass, configure_station_dialog,
                            XmNbackground,              colors[0xff],
                            NULL);

        cs_form =  XtVaCreateWidget("cs_form",xmFormWidgetClass, pane,
                            XmNfractionBase,            5,
                            XmNbackground,              colors[0xff],
                            XmNautoUnmanage,            FALSE,
                            XmNshadowThickness,         1,
                            NULL);

        call = XtVaCreateManagedWidget(langcode("WPUPCFS002"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_call_data = XtVaCreateManagedWidget("call_data", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 9,
                            XmNwidth,                   ((9*7)+2),
                            XmNmaxLength,               9,
                            XmNbackground,              colors[0x0f],
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slat = XtVaCreateManagedWidget(langcode("WPUPCFS003"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_slat_data_deg = XtVaCreateManagedWidget("lat_deg", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 3,
                            XmNmaxLength,               2,
                            XmNtopOffset,               20,
                            XmNbackground,              colors[0x0f],
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slat_deg = XtVaCreateManagedWidget(langcode("WPUPCFS004"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_slat_data_deg,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_slat_data_min = XtVaCreateManagedWidget("lat_min", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 6,
                            XmNmaxLength,               6,
                            XmNtopOffset,               20,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              slat_deg,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slat_min = XtVaCreateManagedWidget(langcode("WPUPCFS005"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_slat_data_min,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_slat_data_ns = XtVaCreateManagedWidget("lat_ns", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               20,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              slat_min,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slat_ns = XtVaCreateManagedWidget(langcode("WPUPCFS006"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               call,
                            XmNtopOffset,               25,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_slat_data_ns,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        slong = XtVaCreateManagedWidget(langcode("WPUPCFS007"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_slong_data_deg = XtVaCreateManagedWidget("long_deg", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 3,
                            XmNmaxLength,               3,
                            XmNtopOffset,               14,
                            XmNbackground,              colors[0x0f],
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            2,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slong_deg = XtVaCreateManagedWidget(langcode("WPUPCFS004"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_slong_data_deg,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_slong_data_min = XtVaCreateManagedWidget("long_min", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 6,
                            XmNmaxLength,               6,
                            XmNtopOffset,               14,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              slong_deg,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slong_min = XtVaCreateManagedWidget(langcode("WPUPCFS005"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_slong_data_min,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_slong_data_ew = XtVaCreateManagedWidget("long_ew", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               14,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              slong_min,
                            XmNleftOffset,              10,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        slong_ew = XtVaCreateManagedWidget(langcode("WPUPCFS008"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slat,
                            XmNtopOffset,               20,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_slong_data_ew,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

//----- Frame for table / symbol
        frame = XtVaCreateManagedWidget("frame1", xmFrameWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               slong_ew,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNrightOffset,             10,
                            XmNbackground,              colors[0xff],
                            NULL);
        // "Station Symbol"
        sts  = XtVaCreateManagedWidget(langcode("WPUPCFS009"),xmLabelWidgetClass,frame,
                            XmNchildType,               XmFRAME_TITLE_CHILD,
                            XmNbackground,              colors[0xff],
                            NULL);

        cs_form1 =  XtVaCreateWidget("cs_form1",xmFormWidgetClass, frame,
                            XmNfractionBase,            5,
                            XmNbackground,              colors[0xff],
                            NULL);

        // "Group/overlay"
        group = XtVaCreateManagedWidget(langcode("WPUPCFS010"),xmLabelWidgetClass, cs_form1,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            10,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              100,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);
        // table
        station_config_group_data = XtVaCreateManagedWidget("group", xmTextFieldWidgetClass, cs_form1,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              group,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        // "Symbol"
        st_symbol = XtVaCreateManagedWidget(langcode("WPUPCFS011"),xmLabelWidgetClass, cs_form1,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_group_data,
                            XmNleftOffset,              20,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        // symbol
        station_config_symbol_data = XtVaCreateManagedWidget("symbol", xmTextFieldWidgetClass, cs_form1,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              st_symbol,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        // icon
        CS_icon0 = XCreatePixmap(XtDisplay(appshell),RootWindowOfScreen(XtScreen(appshell)),20,20,
                    DefaultDepthOfScreen(XtScreen(appshell)));
        CS_icon  = XCreatePixmap(XtDisplay(appshell),RootWindowOfScreen(XtScreen(appshell)),20,20,
                    DefaultDepthOfScreen(XtScreen(appshell)));
        station_config_icon = XtVaCreateManagedWidget("icon", xmLabelWidgetClass, cs_form1,
                            XmNlabelType,               XmPIXMAP,
                            XmNlabelPixmap,             CS_icon,
                            XmNbackground,              colors[0xff],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_symbol_data,
                            XmNleftOffset,              15,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

//----- Frame for Power-Gain
        frame1 = XtVaCreateManagedWidget("frame1", xmFrameWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               frame,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNrightOffset,             10,
                            XmNbackground,              colors[0xff],
                            NULL);

        pg  = XtVaCreateManagedWidget(langcode("WPUPCFS012"),xmLabelWidgetClass,frame1,
                            XmNchildType,               XmFRAME_TITLE_CHILD,
                            XmNbackground,              colors[0xff],
                            NULL);

        cs_form2 =  XtVaCreateWidget("cs_form2",xmFormWidgetClass,frame1,
                            XmNfractionBase,            5,
                            XmNbackground,              colors[0xff],
                            NULL);


        power = XtVaCreateManagedWidget(langcode("WPUPCFS013"),xmLabelWidgetClass, cs_form2,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            10,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              5,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_power_data = XtVaCreateManagedWidget("power", xmTextFieldWidgetClass, cs_form2,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              power,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        height = XtVaCreateManagedWidget(langcode("WPUPCFS014"),xmLabelWidgetClass, cs_form2,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_power_data,
                            XmNleftOffset,              20,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_height_data = XtVaCreateManagedWidget("power", xmTextFieldWidgetClass, cs_form2,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              height,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        gain = XtVaCreateManagedWidget(langcode("WPUPCFS015"),xmLabelWidgetClass, cs_form2,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_height_data,
                            XmNleftOffset,              20,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_gain_data = XtVaCreateManagedWidget("gain", xmTextFieldWidgetClass, cs_form2,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              gain,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        direction = XtVaCreateManagedWidget(langcode("WPUPCFS016"),xmLabelWidgetClass, cs_form2,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              station_config_gain_data,
                            XmNleftOffset,              20,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);

        station_config_direction_data = XtVaCreateManagedWidget("gain", xmTextFieldWidgetClass, cs_form2,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   FALSE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 1,
                            XmNmaxLength,               1,
                            XmNtopOffset,               6,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              direction,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_FORM,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNrightOffset,             5,
                            NULL);

        comment = XtVaCreateManagedWidget(langcode("WPUPCFS017"),xmLabelWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               frame1,
                            XmNtopOffset,               15,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_NONE,
                            XmNbackground,              colors[0xff],
                            NULL);


        station_config_comment_data = XtVaCreateManagedWidget("comment", xmTextFieldWidgetClass, cs_form,
                            XmNeditable,                TRUE,
                            XmNcursorPositionVisible,   TRUE,
                            XmNsensitive,               TRUE,
                            XmNshadowThickness,         1,
                            XmNcolumns,                 60,
                            XmNwidth,                   ((60*7)+2),
                            XmNmaxLength,               MAX_COMMENT,
                            XmNtopOffset,               11,
                            XmNbackground,              colors[0x0f],
                            XmNleftAttachment,          XmATTACH_WIDGET,
                            XmNleftWidget,              comment,
                            XmNleftOffset,              5,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               frame1,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNrightAttachment,         XmATTACH_NONE,
                            NULL);

        frame2 = XtVaCreateManagedWidget("frame", xmFrameWidgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               comment,
                            XmNtopOffset,               10,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNleftOffset,              10,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNrightOffset,             10,
                            XmNbackground,              colors[0xff],
                            NULL);

        posamb  = XtVaCreateManagedWidget(langcode("WPUPCFS018"),xmLabelWidgetClass,frame2,
                            XmNchildType,               XmFRAME_TITLE_CHILD,
                            XmNbackground,              colors[0xff],
                            NULL);

        /*set args for color */
        ac=0;
        XtSetArg(al[ac], XmNbackground, colors[0xff]); ac++;

        option_box = XmCreateRadioBox(frame2,"Option box",al,ac);

        XtVaSetValues(option_box,
                  XmNnumColumns,4,
                  NULL);

        posamb0 = XtVaCreateManagedWidget(langcode("WPUPCFS019"),xmToggleButtonGadgetClass,
                            option_box,
                            XmNbackground, colors[0xff],
                            NULL);
        XtAddCallback(posamb0,XmNvalueChangedCallback,Configure_station_toggle,"0");

        posamb1 = XtVaCreateManagedWidget(units_english_metric?langcode("WPUPCFS020"):langcode("WPUPCFS024"),xmToggleButtonGadgetClass,
                            option_box,
                            XmNbackground, colors[0xff],
                            NULL);
        XtAddCallback(posamb1,XmNvalueChangedCallback,Configure_station_toggle,"1");


        posamb2 = XtVaCreateManagedWidget(units_english_metric?langcode("WPUPCFS021"):langcode("WPUPCFS025"),xmToggleButtonGadgetClass,
                            option_box,
                            XmNbackground, colors[0xff],
                            NULL);
        XtAddCallback(posamb2,XmNvalueChangedCallback,Configure_station_toggle,"2");

        posamb3 = XtVaCreateManagedWidget(units_english_metric?langcode("WPUPCFS022"):langcode("WPUPCFS026"),xmToggleButtonGadgetClass,
                            option_box,
                            XmNbackground, colors[0xff],
                            NULL);
        XtAddCallback(posamb3,XmNvalueChangedCallback,Configure_station_toggle,"3");

        posamb4 = XtVaCreateManagedWidget(units_english_metric?langcode("WPUPCFS023"):langcode("WPUPCFS027"),xmToggleButtonGadgetClass,
                            option_box,
                            XmNbackground, colors[0xff],
                            NULL);
        XtAddCallback(posamb4,XmNvalueChangedCallback,Configure_station_toggle,"4");

        sep = XtVaCreateManagedWidget("sep", xmSeparatorGadgetClass,cs_form,
                            XmNorientation,             XmHORIZONTAL,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               frame2,
                            XmNtopOffset,               14,
                            XmNbottomAttachment,        XmATTACH_NONE,
                            XmNleftAttachment,          XmATTACH_FORM,
                            XmNrightAttachment,         XmATTACH_FORM,
                            XmNbackground,              colors[0xff],
                            NULL);

        button_ok = XtVaCreateManagedWidget(langcode("UNIOP00001"),xmPushButtonGadgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               sep,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            5,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            1,
                            XmNrightAttachment,         XmATTACH_POSITION,
                            XmNrightPosition,           2,
                            XmNbackground,              colors[0xff],
                            NULL);

        button_cancel = XtVaCreateManagedWidget(langcode("UNIOP00002"),xmPushButtonGadgetClass, cs_form,
                            XmNtopAttachment,           XmATTACH_WIDGET,
                            XmNtopWidget,               sep,
                            XmNtopOffset,               5,
                            XmNbottomAttachment,        XmATTACH_FORM,
                            XmNbottomOffset,            5,
                            XmNleftAttachment,          XmATTACH_POSITION,
                            XmNleftPosition,            3,
                            XmNrightAttachment,         XmATTACH_POSITION,
                            XmNrightPosition,           4,
                            XmNbackground,              colors[0xff],
                            NULL);

        XtAddCallback(button_ok, XmNactivateCallback, Configure_station_change_data, configure_station_dialog);
        XtAddCallback(button_cancel, XmNactivateCallback, Configure_station_destroy_shell, configure_station_dialog);

        // fill in current data
        XmTextFieldSetString(station_config_call_data,my_callsign);

        substr(temp_data,my_lat,2);
        XmTextFieldSetString(station_config_slat_data_deg,temp_data);
        substr(temp_data,my_lat+2,6);
        XmTextFieldSetString(station_config_slat_data_min,temp_data);
        substr(temp_data,my_lat+8,1);
        XmTextFieldSetString(station_config_slat_data_ns,temp_data);

        substr(temp_data,my_long,3);
        XmTextFieldSetString(station_config_slong_data_deg,temp_data);
        substr(temp_data,my_long+3,6);
        XmTextFieldSetString(station_config_slong_data_min,temp_data);
        substr(temp_data,my_long+9,1);
        XmTextFieldSetString(station_config_slong_data_ew,temp_data);

        temp_data[0] = my_group;
        temp_data[1] = '\0';
        XmTextFieldSetString(station_config_group_data,temp_data);
        XtAddCallback(station_config_group_data, XmNvalueChangedCallback, updateSymbolPictureCallback, configure_station_dialog);

        temp_data[0] = my_symbol;
        temp_data[1] = '\0';
        XmTextFieldSetString(station_config_symbol_data,temp_data);
        XtAddCallback(station_config_symbol_data, XmNvalueChangedCallback, updateSymbolPictureCallback, configure_station_dialog);

        // update symbol picture
        (void)updateSymbolPictureCallback((Widget)NULL,(XtPointer)NULL,(XtPointer)NULL);

        if (my_phg[0]=='P') {
            temp_data[0]=my_phg[3];
            temp_data[1]='\0';
            XmTextFieldSetString(station_config_power_data,temp_data);

            temp_data[0]=my_phg[4];
            temp_data[1]='\0';
            XmTextFieldSetString(station_config_height_data,temp_data);

            temp_data[0]=my_phg[5];
            temp_data[1]='\0';
            XmTextFieldSetString(station_config_gain_data,temp_data);

            temp_data[0]=my_phg[6];
            temp_data[1]='\0';
            XmTextFieldSetString(station_config_direction_data,temp_data);
        }

        XmTextFieldSetString(station_config_comment_data,my_comment);


        Configure_station_pos_amb = position_amb_chars;
        switch (Configure_station_pos_amb) {
            case(0):
                XmToggleButtonSetState(posamb0,TRUE,FALSE);
                break;

            case(1):
                XmToggleButtonSetState(posamb1,TRUE,FALSE);
                break;

            case(2):
                XmToggleButtonSetState(posamb2,TRUE,FALSE);
                break;

            case(3):
                XmToggleButtonSetState(posamb3,TRUE,FALSE);
                break;

            case(4):
                XmToggleButtonSetState(posamb4,TRUE,FALSE);
                break;

            default:
                XmToggleButtonSetState(posamb0,TRUE,FALSE);
                break;
        }

        pos_dialog(configure_station_dialog);

        delw = XmInternAtom(XtDisplay(configure_station_dialog),"WM_DELETE_WINDOW", FALSE);
        XmAddWMProtocolCallback(configure_station_dialog, delw, Configure_station_destroy_shell, (XtPointer)configure_station_dialog);

        XtManageChild(cs_form);
        XtManageChild(cs_form1);
        XtManageChild(cs_form2);
        XtManageChild(option_box);
        XtManageChild(pane);

        XtPopup(configure_station_dialog,XtGrabNone);
        fix_dialog_size(configure_station_dialog);
    } else
        (void)XRaiseWindow(XtDisplay(configure_station_dialog), XtWindow(configure_station_dialog));
}





/////////////////////////////////////////////   main   /////////////////////////////////////////////


int main(int argc, char *argv[]) {
    int ag, ag_error, trap_segfault;
    uid_t user_id;
    struct passwd *user_info;
    static char lang_to_use_or[30];
    char temp[100];

//WE7U
    // Define some overriding resources for the widgets.
    // Look at files in /usr/X11/lib/X11/app-defaults for ideas.
    String fallback_resources[] = {

        "*XmTextField.translations: #override \
        <Key>Return:    activate()\n",

        "*.Text.Translations: #override\n\
        Ctrl<Key>S:     no-op(RingBell)\n\
        Ctrl<Key>R:     no-op(RingBell)\n\
        <Key>space:     next-page()\n\
        <Key>F:         next-page()\n\
        Ctrl<Key>B:     previous-page()\n\
        <Key>B:         previous-page()\n\
        <Key>K:         scroll-one-line-down()\n\
        <Key>Y:         scroll-one-line-down()\n\
        <Key>Return:    scroll-one-line-up()\n\
        <Key>J:         scroll-one-line-up()\n\
        <Key>E:         scroll-one-line-up()\n\
        <Key>q:         quit()\n",

        "*.Text.baseTranslations: #override\n\
        <Key>space:     next-page()\n\
        <Key>F:         next-page()\n\
        Ctrl<Key>B:     previous-page()\n\
        <Key>K:         scroll-one-line-down()\n\
        <Key>Y:         scroll-one-line-down()\n\
        <Key>Return:    scroll-one-line-up()\n\
        <Key>J:         scroll-one-line-up()\n\
        <Key>E:         scroll-one-line-up()\n\
        <Key>q:         quit()\n",

        "*.vertical.Translations: #override\n\
        <Key>space: StartScroll(Forward)  NotifyScroll(FullLength) EndScroll() \n\
        <Key>Delete: StartScroll(Backward) NotifyScroll(FullLength) EndScroll() \n\
        Ctrl<Key>Up:        KbdScroll(up,50) EndScroll()\n\
        Ctrl<Key>Down:      KbdScroll(down,50) EndScroll()\n\
        <Key>Up:            KbdScroll(up,10) EndScroll()\n\
        <Key>Down:          KbdScroll(down,10) EndScroll()\n\
        <Key>Page_Up:       KbdScroll(up,90) EndScroll()\n\
        <Key>Page_Down:     KbdScroll(down,90) EndScroll()\n",

        "*.horizontal.translations:      #override \n\
        Ctrl<Key>Left:      KbdScroll(left,50) EndScroll()\n\
        Ctrl<Key>Right:     KbdScroll(right,50) EndScroll()\n\
        <Key>Left:          KbdScroll(left,10) EndScroll()\n\
        <Key>Right:         KbdScroll(right,10) EndScroll()\n",

        "*.horizontal.accelerators:      #override \n\
        Ctrl<Key>Left:      KbdScroll(left,50) EndScroll()\n\
        Ctrl<Key>Right:     KbdScroll(right,50) EndScroll()\n\
        <Key>Left:          KbdScroll(left,10) EndScroll()\n\
        <Key>Right:         KbdScroll(right,10) EndScroll()\n",

        "*.vertical.accelerators:        #override \n\
        Ctrl<Key>Up:        KbdScroll(up,50) EndScroll()\n\
        Ctrl<Key>Down:      KbdScroll(down,50) EndScroll()\n\
        <Key>Up:            KbdScroll(up,10) EndScroll()\n\
        <Key>Down:          KbdScroll(down,10) EndScroll()\n\
        <Key>Page_Up:       KbdScroll(up,90) EndScroll()\n\
        <Key>Page_Down:     KbdScroll(down,90) EndScroll()\n",

        "*.nodeText.Translations: #override \n\
        None<Key>b:     beginning-of-file() \n\
        <Key>Home:      beginning-of-file() \n\
        <Key>Delete:    previous-page() \n\
        <Key>Prior:     previous-page() \n\
        <Key>Next:      next-page() \n\
        <Key>space:     next-page() \n\
        None<Btn1Down>: select-end() info_click() \n",

        "*.arg.translations:    #override \n\
        <Key>Return: confirm() \n\
        Ctrl<Key>G:  abort() \n",

        "*.pane.text.translations:         #override \n\
        None<Key>q:     MenuPopdown(help) \n\
        None<Key>b:     beginning-of-file() \n\
        <Key>Home:      beginning-of-file() \n\
        <Key>Delete:    previous-page() \n\
        <Key>Prior:     previous-page() \n\
        <Key>Next:      next-page() \n\
        <Key>space:     next-page() \n",

        "*.dialog.value.translations:     #override \n\
        <Key>Return: confirm() \n\
        Ctrl<Key>G:  abort() \n\
        <Key>Tab: Complete()\n",

        "*.dialog.value.baseTranslations:     #override \n\
        <Key>Return: confirm() \n\
        Ctrl<Key>G:  abort() \n",

        "*.baseTranslations: #override \n\
        Ctrl<Key>q: Quit()\n\
        Ctrl<Key>c: Quit()\n\
        <Key>Return: Accept()\n",

        "*Translations: #override \n\
        <Key>q: Quit()\n\
        <Key>c: Quit()\n\
        Ctrl <Key>n: Next()\n\
        Ctrl <Key>p: Prev()\n",

        NULL
    };

#ifdef USE_IMAGEMAGICK
    MagickIncarnate(*argv);
#endif

    /* get User info */
    user_id   = getuid();
    user_info = getpwuid(user_id);
    strcpy(user_dir,user_info->pw_dir);

    /*
        printf("User %s, Dir %s\n",user_info->pw_name,user_dir);
        printf("User dir %s\n",get_user_base_dir(""));
        printf("Data dir %s\n",get_data_base_dir(""));
    */

    /* check user directories */
    if (filethere(get_user_base_dir("")) != 1) {
        printf("Making user dir\n");
        (void)mkdir(get_user_base_dir(""),S_IRWXU);
    }

    if (filethere(get_user_base_dir("config")) != 1) {
        printf("Making user config dir\n");
        (void)mkdir(get_user_base_dir("config"),S_IRWXU);
    }

    if (filethere(get_user_base_dir("data")) != 1) {
        printf("Making user data dir\n");
        (void)mkdir(get_user_base_dir("data"),S_IRWXU);
    }

    if (filethere(get_user_base_dir("logs")) != 1) {
        printf("Making user log dir\n");
        (void)mkdir(get_user_base_dir("logs"),S_IRWXU);
    }

    /* done checking user dirs */

    /* check fhs directories ?*/

    /* setup values */
    redo_list = FALSE;          // init lists

    delay_time = 0;
    packet_data_display = 0;
    redraw_on_new_packet_data = 0;
    read_file = 0;
    redraw_on_new_data = 0;
    display_up = 0;
    display_up_first = 0;
    max_transmit_time = (time_t)900l;
    sec_next_gps = 0l;
    sec_next_raw_wx = 0l;
    auto_reply = 0;
    last_time = 0l;
    next_time = (time_t)120l;
    net_last_time = 0l;
    net_next_time = (time_t)120l;
    wait_to_redraw=1;

    last_popup_x = 0;
    last_popup_y = 0;
    trap_segfault = 0;
    debug_level = 0;
    last_sound_pid = 0;

    my_last_course = 0;
    my_last_speed = 0;
    my_last_altitude = 0l;
    my_last_altitude_time = 0l;

    fcc_data_available = 0;
    rac_data_available = 0;
    strcpy(wx_station_type,"");
    last_alert_redraw = 0;
    igate_msgs_tx = 0;
    last_statusline = 0;        // inactive statusline
    
    last_object[0] = '\0';      // initialize object dialog
    last_obj_grp   = '/';
    last_obj_sym   = '!';

    clear_rain_data();          // init weather data
    clear_local_wx_data();

    next_redraw = sec_now()+60; // init redraw timing
    last_redraw = sec_now();

    strcpy(lang_to_use_or,"");
    ag_error=0;
    while ((ag = getopt(argc, argv, "v:l:012346789t")) != EOF) {
        switch (ag) {
        case 't':
            printf("Trap segfault");
        trap_segfault = (int)TRUE;
        break;
        case 'v':
                printf ("debug");
                if (optarg) {
                    debug_level = atoi(optarg);
                    printf (" level %d", debug_level);
                }
                printf ("\n");
                break;

            case 'l':
                printf ("Language is");
                if (optarg) {
                    strcpy(lang_to_use_or,"");
                    if (strcasecmp(optarg,"ENGLISH") == 0) {
                        strcpy(lang_to_use_or,"English");
                    } else if (strcasecmp(optarg,"DUTCH") == 0) {
                        strcpy(lang_to_use_or,"Dutch");
                    } else if (strcasecmp(optarg,"FRENCH") == 0) {
                        strcpy(lang_to_use_or,"French");
                    } else if (strcasecmp(optarg,"GERMAN") == 0) {
                        strcpy(lang_to_use_or,"German");
                    } else if (strcasecmp(optarg,"SPANISH") == 0) {
                        strcpy(lang_to_use_or,"Spanish");
                    } else if (strcasecmp(optarg,"ITALIAN") == 0) {
                        strcpy(lang_to_use_or,"Italian");
                    } else {
                        ag_error++;
                        printf(" INVALID");
                    }
                    if (!ag_error)
                        printf(" %s", lang_to_use_or);

                }
                printf ("\n");
                break;

            default:
                ag_error++;
                break;
        }
    }

    if (ag_error){
        printf("\nXastir Command line Options\n\n");
        printf("-v level    Set the debug level\n\n");
        printf("-lEnglish   Set English as the Language to use\n");
        printf("-lDutch     Set Dutch as the Language to use\n");
        printf("-lFrench    Set French as the Language to use\n");
        printf("-lGerman    Set German as the Language to use\n");
        printf("-lSpanish   Set Spanish as the Language to use\n");
        printf("-lItalian   Set Italian as the Language to use\n");
        printf("\n");
        exit(0);
    }

    // initialize interfaces
    init_critical_section(&port_data_lock);   // Protects the port_data[] array of structs
    init_critical_section(&output_data_lock); // Protects interface.c:channel_data() function only
    init_critical_section(&data_lock);        // Protects global data, data_port, data_avail variables
    init_critical_section(&connect_lock);     // Protects port_data[].thread_status and port_data[].connect_status
//WE7U:  We should probably protect redraw_on_new_data, alert_redraw_on_update, and
// redraw_on_new_packet_data variables as well?
// Also need to protect dialogs.

    (void)bulletin_gui_init();
    (void)db_init();
    (void)messages_gui_init();
    (void)list_gui_init();
    (void)locate_gui_init();
    (void)location_gui_init();
    (void)popup_gui_init();
    (void)track_gui_init();
    (void)view_message_gui_init();
    (void)wx_gui_init();
    (void)interface_gui_init();

    clear_all_port_data();                              // clear interface port data

    (void) signal(SIGINT,quit);                         // set signal on stop
    (void) signal(SIGQUIT,quit);
    (void) signal(SIGTERM,quit);
    (void) signal(SIGPIPE,SIG_IGN);                     // set sigpipe signal to ignore
    if (!trap_segfault)
        (void) signal(SIGSEGV,segfault);                // set segfault signal to check

    load_data_or_default();     // load program parameters or set to default values

    /* do language links */
    if (strlen(lang_to_use_or) > 0)
        strcpy(lang_to_use,lang_to_use_or);

    sprintf(temp,"help/help-%s.dat",lang_to_use);
    (void)unlink(get_user_base_dir("config/help.dat"));
    if (symlink(get_data_base_dir(temp),get_user_base_dir("config/help.dat")) == -1) {
        printf("Error creating database link\n");
        exit(0);
    }

    sprintf(temp,"config/language-%s.sys",lang_to_use);
    (void)unlink(get_user_base_dir("config/language.sys"));
    if (symlink(get_data_base_dir(temp),get_user_base_dir("config/language.sys")) == -1) {
        printf("Error creating database link\n");
        exit(0);
    }

    /* (NEW) set help file area */
    strcpy(HELP_FILE,get_user_base_dir("config/help.dat"));

#ifdef HAVE_FESTIVAL
    /* Initialize the festival speech synthesis port */
    if (SayTextInit())
    {
        printf("Error connecting to Festival speech server.\n");
        exit(0);
    }  
#endif

    if (load_color_file()) {
        if (load_language_file(get_user_base_dir("config/language.sys"))) {
            init_device_names();                // set interface names
            clear_message_windows();
            clear_popup_message_windows();
            init_station_data();                // init station storage
            init_message_data();                // init messages
            reset_outgoing_messages();

            /* set language attribs */
            (void)XtSetLanguageProc((XtAppContext) NULL, (XtLanguageProc) NULL, (XtPointer) NULL );
            XtToolkitInitialize();

            Global.top = XtVaAppInitialize(&app_context,"Xastir", NULL, 0,
                                       &argc, argv, fallback_resources,
                                       XmNmappedWhenManaged, FALSE,
                                       NULL);

            display = XtOpenDisplay(app_context, NULL, argv[0], "XApplication",NULL, 0, &argc, argv);
            if (!display) {
                printf("%s: can't open display, exiting...\n", argv[0]);
                exit (-1);
            }

            XtRealizeWidget(Global.top);
            create_appshell(display, argv[0], argc, argv);

            /* reset language attribs for numeric, program needs decimal in US for all data! */
            (void)setlocale(LC_NUMERIC, "en_US");

            /* check for ham databases */
            (void)check_fcc_data();
            (void)check_rac_data();

            XtAppMainLoop(app_context);

        } else
            printf("Error in language file! Exiting...\n");

    } else
        printf("Error in Color file! Exiting...\n");

    quit(0);
    return 0;
}
