/* plugin to control xawtv */
#include "xawtv_plugin.h"

/* externs */
extern int debug;


/* XWindow stuff */

/* Code from xawtv-remote */
int x11_error_dev_null(Display * dpy, XErrorEvent * event)
{
    if(debug)
	fprintf(stderr,"x11-error\n");
    return 0;
}

/* get_station_name() from xawtv
 * Args:
 *   - dpy = Display where xawtv is running
 *   - win = window of xawtv
 *   - station = atom that contains the station name
 *   - name = char* buffer that has engouth room for the 
 * Return:
 *   - TRUE  = xawtv's station could be read
 *   - FALSE = failed to query xawtv, probably no xawtv running
 */
gboolean get_station_name(Display* dpy, Window win, Atom station, char* dest) 
{
    Atom            type;
    int             format;
    unsigned long   nitems, bytesafter;
    unsigned char  *args = NULL;  
    int i,j;
    
    if(debug)
	printf("get_station_name()\n");

    if(XGetWindowProperty(dpy, win, station,
			  0, (65536 / sizeof(long)),
			  False, XA_STRING,
			  &type, &format, &nitems, &bytesafter,
			  &args) != 0) 
      {
	if(debug)
	  printf("XGetWindowProperty() failed\n");
	return FALSE;
      }

    for (i = 0,j=0; i < nitems && j<2; i += strlen(args + i) + 1,j++)
	if(debug)
	    printf("args[%i]=%s\n",j,args + i);

    if(debug)
	printf("Query Station name: %s\n ", args + i);

    strncpy(dest, args+i, 255);
    XFree(args);	
    
    return TRUE;
}

Window find_window(Display * dpy, Atom atom)
{
    int             i,n;
    Window          root = RootWindowOfScreen(DefaultScreenOfDisplay(dpy));
    Window          root2, parent, *kids;
    unsigned int    nkids;
    Window result = 0;

    if(debug)
	printf("find_window()\n");

    if (!XQueryTree(dpy, root, &root2, &parent, &kids, &nkids)) {
        fprintf(stderr, "XQueryTree failed on display %s\n",
                DisplayString(dpy));
        exit(2);
    }

    if (!(kids && nkids)) {
        fprintf(stderr, "root window has no children on display %s\n",
                DisplayString(dpy));
	gnome_dialog_run(GNOME_DIALOG(gnome_error_dialog(g_strdup_printf("root window has no children on display %s\n", DisplayString(dpy)))));
        exit(2);
    }
    for (n = nkids - 1; n >= 0; n--) {
        Atom            type;
        int             format;
        unsigned long   nitems, bytesafter;
        unsigned char  *args = NULL;

	/* XmuClientWindow() has a memory leak!!!! */
        Window          w = XmuClientWindow(dpy, kids[n]);
	if( w != None ) 
	    XGetWindowProperty(dpy, w, atom,
			       0, (65536 / sizeof(long)),
			       False, XA_STRING,
			       &type, &format, &nitems, &bytesafter,
			       &args);

        if (args == NULL)
            continue;
	if (debug) {
	    printf("query 0x%08lx: ",w);
	    for (i = 0; i < nitems; i += strlen(args + i) + 1)
		printf("%s ", args + i);
	    printf(" [finish] \n");
	}
        XFree(args);
	result = w;
    }
    XFree(kids);
    return result;
}


void pass_cmd(Display *dpy, Atom atom, Window win, int num, char **args)
{
    int             i, len;
    char           *pass;

    if(debug)
	printf("pass_cmd()\n");

    if (debug)
        printf("ctrl  0x%08lx: ",win);
    for (len = 0, i = 0; i < num; i++) {
        if (debug)
            printf("%s ",args[i]);
        len += strlen(args[i]) + 1;
    }
    if (debug)
        printf(" [finish] \n");
    pass = malloc(len);
    pass[0] = 0;
    for (len = 0, i = 0; i < num; i++)
	strcpy(pass + len, args[i]),
            len += strlen(args[i]) + 1;
    i = XChangeProperty(dpy, win,
			atom, XA_STRING,
			8, PropModeReplace,
			pass, len);
    XFlush(dpy);
    free(pass);
}



/* generic xawtv stuff */
/* open xawtv config file */
FILE* open_xawtvrc_file() {
  char file[255];
  FILE* f;

  if(debug)
    printf("open_xawtvrc_file()\n");
  
  strcpy(file,getenv("HOME"));
  strcat(file,"/.xawtv");
  if(debug)
    printf("trying fopen(%s)\n",file);
  f = fopen(file,"r");
  return f;
}


/* read_station() */
char* read_station(FILE* f) {
  static char str[255];

  if(debug)
    printf("get_stations()\n");
  do {
    if( fgets(str, sizeof(str), f) == NULL) 
      return NULL;
  } while ( str[0] != '[' ||
	    !strncmp(str,"[global]",strlen("[global]")) ||
	    !strncmp(str,"[defaults]",strlen("[defaults]")) ||
	    !strncmp(str,"[launch]",strlen("[launch]"))
	    );
  
  /* remove [] and \n */
  strncpy(str,&str[1],255);
  str[strlen(str)-2]= '\0';

  return str;
}
