/**************************************************
 cal.c -- Copyright(c) 1999 Jiro Sekiba <jir@hello.to>
 **************************************************/
#include<wchar.h>
#include<stdlib.h>
#include<time.h>
#include<string.h>
#include "config.h"

#ifdef DEBUG
#include<stdio.h>
#endif


#include "cal.h"
#include "holiday.h"

#define NUM_WEEK 2
#define NUM_MONTH NAME_BUF-1

wchar_t weeks_name[7][NAME_BUF]; /* weeks_name[0] is Sunday string, depends on
                                  locale(LC_CTIME)*/
wchar_t month_name[NAME_BUF];    /* month_name[0] is January..*/
int this_year,this_month,today;

void init_today()
{
  time_t t;
  struct tm *tm_today;

  time(&t);
  tm_today = localtime(&t);

  this_year  = tm_today->tm_year+1900;
  this_month = tm_today->tm_mon+1;
  today = tm_today->tm_mday;
}

int calc_offset(int year,int month)
{
  time_t t;
  struct tm lt;
  struct tm *llt;

  time(&t);
  llt = localtime(&t);
  memset(&lt,0,sizeof(struct tm));
  
  lt.tm_year = year - 1900;
  lt.tm_mon = month -1;
  lt.tm_mday = 1;
  lt.tm_sec = 0;
  lt.tm_min = 0;
  lt.tm_hour = 0;

  t = mktime(&lt);
  llt = localtime(&t);

  return llt->tm_wday;
}

int calc_lastday(int year,int month)
{
  switch (month)
  {
    case 2:
      if (year%4!=0)
      {
        return 28;
      }
      else if (year%100==0 &&
               (year/100)%4!=0 )
      {
        return 28;
      }
      else
      {
        return 29;
      }
    case 4:
    case 6:
    case 9:
    case 11:
      return 30;
    default:
      return 31;
  }
}

int calc_rows(int year, int month)
{
    int lastday, offset;
    int days,rows;
    
    offset = calc_offset(year,month);
    lastday = calc_lastday(year,month);
    days = offset + lastday;

    rows = days / 7;
    if (days % 7)
        rows++;
    return rows;
}

void init_locale_data(int year, int month, int num_week)
{
  int i;
  time_t t;
  struct tm lt;
  struct tm *llt;
  char str[NAME_BUF*2];

  if(num_week < 1 ||  NAME_BUF < num_week)
    num_week = NUM_WEEK;

  init_today();
  memset(&lt,0,sizeof(struct tm));
  lt.tm_year = 99;
  lt.tm_mon = 7;  /* It's just because 1st August 1999 is Sunday;-) */
  lt.tm_sec = 0;
  lt.tm_min = 0;
  lt.tm_hour = 0;
  for(i=0;i<7;i++)
  {
    lt.tm_mday = i+1;

    t = mktime(&lt);
    llt = localtime(&t);

    strftime(str,NAME_BUF*2,"%A",llt);
    mbstowcs(weeks_name[i],str,strlen(str));
    weeks_name[i][num_week] = 0L;
  }

  lt.tm_year = year - 1900;
  lt.tm_mon = month - 1;
  lt.tm_mday = 1;
  lt.tm_sec = 0;
  lt.tm_min = 0;
  lt.tm_hour = 0;

  t = mktime(&lt);
  llt = localtime(&t);
    
  strftime(str,NAME_BUF*2,"%B  %Y",llt);
  mbstowcs(month_name,str,strlen(str));
  month_name[NUM_MONTH] = 0L;
}

/* holiday depends on locale(LANG) */
int is_holiday(int year, int month, int day)
{
  static char *lang = NULL;
  static int (*func)(int,int,int) = NULL;

  if(!lang) /* if this function is called first time */
  {
    lang = getenv("LANG");
#ifdef DEBUG      
    printf("LANG = %s\n",lang);
#endif      
    if(strncmp((char *)lang,"ja_JP",5) == 0)
    {
      func =  (void *)&ja_JP_holiday;
    }
  }

  if(!func)  /* If there is no holiday calculate function */
      return 0;

  return (func)(year,month,day);
}
