/*
 *  This file is part of X-File Manager XFM
 *  ----------------------------------------------------------------------
  FmConfirm.c

  (c) Simon Marlow 1990-1993

  modified 2005,2006 by Bernhard R. Link (see Changelog)

  Module for creating and implementing the confirmation window
 *  ----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <xfmconfig.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/Label.h>
#include <X11/Xaw3d/Box.h>

#include "global.h"

#include "Am.h"
#include "Fm.h"

#define LABEL_WIDTH 400

/*-----------------------------------------------------------------------------
  STATIC DATA
-----------------------------------------------------------------------------*/

static Widget shell, label1, label2, label3;
static enum { DontKnow, Ok, Cancel, Abort } confirm_flag;
Boolean aborted;

/*-----------------------------------------------------------------------------
  Widget Argument Lists
-----------------------------------------------------------------------------*/

static Arg shell_args[] = {
  { XtNtitle, (XtArgVal) "Confirm" }
};

static Arg *form_args = NULL;

static Arg label_args[] = {
  { XtNfromHoriz, (XtArgVal) NULL },
  { XtNfromVert, (XtArgVal) NULL },
  { XtNlabel, (XtArgVal) NULL },
  { XtNwidth, (XtArgVal) LABEL_WIDTH },
  { XtNfont, (XtArgVal) NULL },
  { XtNresize, (XtArgVal) False },
  { XtNtop, XtChainTop },
  { XtNbottom, XtChainTop },
  { XtNleft, XtChainLeft },
  { XtNright, XtChainRight }
};

static Arg button_box_args[] = {
  { XtNfromHoriz, (XtArgVal) NULL },
  { XtNfromVert, (XtArgVal) NULL },
  { XtNtop, XtChainTop },
  { XtNbottom, XtChainTop },
  { XtNleft, XtChainLeft },
  { XtNright, XtChainLeft }
};

/*-----------------------------------------------------------------------------
  PRIVATE FUNCTIONS
-----------------------------------------------------------------------------*/

static void confirmOkCb(UNUSED(Widget w), UNUSED(void *client_data),
		        UNUSED(void *call_data))
{
  XtPopdown(shell);
  confirm_flag = Ok;
}

/*---------------------------------------------------------------------------*/

static void confirmCancelCb(UNUSED(Widget w), UNUSED(void *client_data),
			    UNUSED(void *call_data))
{
  XtPopdown(shell);
  confirm_flag = Cancel;
}

/*---------------------------------------------------------------------------*/

static void confirmAbortCb(UNUSED(Widget w), UNUSED(void *client_data),
			   UNUSED(void *call_data))
{
  XtPopdown(shell);
  confirm_flag = Abort;
}

/*-----------------------------------------------------------------------------
  Button Data
-----------------------------------------------------------------------------*/

static const ButtonRec confirm_buttons[] = {
  { "ok", "Continue", confirmOkCb },
  { "cancel", "Cancel", confirmCancelCb },
  { "abort", "Abort", confirmAbortCb },
};


/*-----------------------------------------------------------------------------
  PUBLIC FUNCTIONS
-----------------------------------------------------------------------------*/

void createConfirmPopup(void)
{
  Widget form, button_box;

  /* create shell */
  shell = XtCreatePopupShell("confirm", transientShellWidgetClass,
			     aw.shell, shell_args, XtNumber(shell_args));

  /* create outer form */
  form = XtCreateManagedWidget("form", formWidgetClass, shell,
				      form_args, XtNumber(form_args) );

  /* create label 1 */
  label_args[4].value = (XtArgVal) resources.label_font;
  label1 = XtCreateManagedWidget("label1",labelWidgetClass, form,
				 label_args, XtNumber(label_args) );

  /* create label 2 */
  label_args[1].value = (XtArgVal) label1;
  label2 = XtCreateManagedWidget("label2",labelWidgetClass, form,
				 label_args, XtNumber(label_args) );

  /* create label 3 */
  label_args[1].value = (XtArgVal) label2;
  label3 = XtCreateManagedWidget("label3",labelWidgetClass, form,
				 label_args, XtNumber(label_args) );

  /* create button box */
  button_box_args[1].value = (XtArgVal) label3;
  button_box = XtCreateManagedWidget("button box", boxWidgetClass, form,
				     button_box_args, 
				     XtNumber(button_box_args) );
  createButtons(confirm_buttons, XtNumber(confirm_buttons), button_box,
		NULL);

#ifdef ENHANCE_POP_ACCEL
  XtInstallAllAccelerators(form,form);
  XtInstallAllAccelerators(shell,form);
#endif

  XtRealizeWidget(shell);
  setWMProps(shell);
}

/*---------------------------------------------------------------------------*/

int confirm(const char *s1, const char *s2, const char *s3)
{
  XEvent e;

  XtVaSetValues(label1, XtNlabel, s1, NULL);
  XtVaSetValues(label2, XtNlabel, s2, NULL);
  XtVaSetValues(label3, XtNlabel, s3, NULL);
  popupByCursor(shell, XtGrabExclusive);

  confirm_flag = DontKnow;

  do {
    XtAppNextEvent(app_context, &e);
    XtDispatchEvent(&e);
  } while (confirm_flag == DontKnow);

  aborted = (confirm_flag == Abort);
  return (confirm_flag == Ok);
}
