// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_util.h
// *
// * Purpose: Various utilities (macros, functions, etc.)
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 8.3.2000
// *************************************************************************

#ifndef XGSM_UTIL_H
#define XGSM_UTIL_H

#include <assert.h>
#include <gtk--/optionmenu.h>
#include <gtk--/menuitem.h>
#include <gsmlib/gsm_util.h>
#include <gtk--/menu.h>
#include <gtk--/menuitem.h>
#include <gtk--/text.h>
#include <gdk--/color.h>

// Utility macros
  
// connect specified Gtk-- signal given the GtkObject
#define CONNECT_SIGNAL(objectName, objectType,                  \
                       checkMacro, signal, obj, handler)        \
            {                                                   \
               GtkWidget *foundObj =                            \
                 lookup_widget((GtkWidget*)obj->gtkobj(),       \
                               ((string)objectName).c_str());   \
               assert(checkMacro(foundObj));                    \
               Gtk::wrap((objectType*)foundObj)->signal.        \
                 connect(slot(this, &handler));                 \
            }

// lookup and wrap GtkObject
#define LOOKUP_WIDGET(widget, objectName, objectType, checkMacro, obj)  \
            {                                                           \
               GtkWidget *foundObj =                                    \
                 lookup_widget((GtkWidget*)obj->gtkobj(),               \
                               ((string)objectName).c_str());           \
               assert(checkMacro(foundObj));                            \
               widget = Gtk::wrap((objectType*)foundObj);               \
            }

// debug macros

#ifdef NDEBUG
#define DEBUG_START(level) #if 0
#define DEBUG_END #endif
#else
#define DEBUG_START(level)                      \
            if (xgsmDebugLevel >= level)            \
            {

#define DEBUG_END }
#endif

namespace Xgsm
{
  // return index of activated menu item (useful for option menus)
  extern int getActivatedMenuItem(Gtk::Menu *menu);

  // return indexed menu item
  extern Gtk::MenuItem &getMenuItemByIndex(Gtk::Menu *menu, int itemIndex);

  // return home directory of current user
  // (returns "" if the home directory could not be determined)
  extern string homeDir();

  // return true if regular file
  extern bool isFile(string filename);

  // return true if regular device
  extern bool isDevice(string filename);

  // clear Gtk::text
  extern void clearText(Gtk::Text *t, bool thaw = true);

  // return textual representation in the form #rrggbb for a GdkColor
  extern std::string colorToString(Gdk_Color &color);

#ifndef NDEBUG
  // debugging level for xgsm
  extern int xgsmDebugLevel;
#endif

  // dynamic option menu, wrapper around Gtk::OptionMenu that allows to
  // redefine the options/items easily

  class DynamicOptionMenu
  {
    struct OptionMenuItem : public gsmlib::RefBase
    {
      string _choice;
      Gtk::MenuItem *_menuItem;
      
      OptionMenuItem(string choice, Gtk::MenuItem *menuItem) :
        _choice(choice), _menuItem(menuItem) {}
    };

    Gtk::OptionMenu *_om;
    std::vector<OptionMenuItem> _menuItems;
    int _index;
    
  public:
    DynamicOptionMenu() : _om(NULL) {}

    DynamicOptionMenu(Gtk::OptionMenu *om) : _om(om), _index(0) {}

    // clear dynamic menu
    void clear();

    // adds new item to the dynamic menu
    void append(string choice, std::string currentChoice,
                SigC::Slot0<void> callback);

    std::string getActiveChoice();
  };
};

#endif // XGSM_UTIL_H
