/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

#include "interface_xlcm.h"
#include "support.h"

#include "cfg.h"
#include "widgets_xlcm.h"
#include "runtime.h"
#include "netio.h"
#include "proc_xlcm_lcp3.h"
#include "lcp3.h"
#include "startup.h"

void abortxlcm(int sig)
{
	g_print("shutting down...\n");
	proc_xlcm_lcp3_cleanup();
	exit(1);
}

void cleanup(int sig)
{
	signal(SIGQUIT, abortxlcm);
	signal(SIGTERM, abortxlcm);
	signal(SIGINT, abortxlcm);
	g_print("disconnecting from server...\n");
	if ( runtime->client_status != CLT_DISCON )
		cmd_send(CMD3_UNREG, NULL, 0);
}

int
main (int argc, char *argv[])
{
	startup_check(argc, argv);

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
  add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

	runtime_init();
	widgets_init();
	config_init();

	signal(SIGQUIT, cleanup);
	signal(SIGTERM, cleanup);
	signal(SIGINT, cleanup);

	if ( !proc_xlcm_lcp3_init() )
	{
		g_print("proc_xlcm_lcp3_init() failed!\n");
		exit(1);
	}
	cmd_send(CMD3_PUBKEYREQ, NULL, 0);

/*
if ( config->detach )
{
	pid_t pid;
	#ifndef STAY_TTY
 if ((pid = fork()) < 0)
 {
    fprintf(stderr, "unable to fork, terminating.\n");
    exit(1);
 }
 else { if (pid > 0) return(0); }
 setsid();
 if ((pid = fork()) < 0) {
     fprintf(stderr, "unable to fork, terminating.\n");
     exit(1);
 }
 else { if (pid > 0) return(0); }
	#endif // STAY_TTY
}
*/

  gtk_main ();

	g_print("gtk_main() returned...\n");
  
  return 0;
}
