// file      : tests/cxx/parser/validation/built-in/int/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test the built-in int and unsigned int types validation.
//
#include <cassert>

#include <xsde/cxx/parser/validating/int.hxx>
#include <xsde/cxx/parser/validating/unsigned-int.hxx>

using namespace xsde::cxx::parser::validating;

int
main (int argc, char* argv[])
{
  // Good.
  //
  {
    int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-2147483648");
    p._post ();
    assert (!p._error_type () && p.post_int () == -2147483648);
  }

  {
    int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_int () == 0);
  }

  {
    int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("2147483647");
    p._post ();
    assert (!p._error_type () && p.post_int () == 2147483647);
  }

  {
    unsigned_int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("0");
    p._post ();
    assert (!p._error_type () && p.post_unsigned_int () == 0);
  }

  {
    unsigned_int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("4294967295");
    p._post ();
    assert (!p._error_type () && p.post_unsigned_int () == 4294967295);
  }

  // Bad
  //

  {
    unsigned_int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-123");
    p._post ();
    assert (p._schema_error ());
  }


  // Ranges
  //
  {
    int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("-2147483649");
    p._post ();
    assert (p._schema_error ());
  }

  {
    int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("2147483648");
    p._post ();
    assert (p._schema_error ());
  }

  {
    unsigned_int_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("4294967296");
    p._post ();
    assert (p._schema_error ());
  }
}
