#! /usr/bin/perl -w


# Ham Radio log convert module logconvert.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    logconvert.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    logconvert.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 05-04-06



$exchangetype = "serial";
$standardexchange = "";

open (IN, "<", "$ENV{HOME}/.xtlf/qso.log") or die "Cannot open log file $!";
my @log = <IN>;
close (IN);

open (OUT, ">", "$ENV{HOME}/.xtlf/qso.adif") or die "Cannot open adif file $!";

@months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
$cntr = 0;

print OUT "Adif export from Xtlf-1.0.0<eoh>\n";
print OUT "<adif_ver:4>1.00\n";

foreach $logline (@log) {
	$Band = substr($logline, 0, 3);
	$Band =~ s/\s*//;
	$Mode = substr($logline, 3, 3);
	$Mode =~ s/\s*$//;
	if ($Mode eq "DIG") {
		$Mode = "RTTY";
	}
	$day = substr($logline, 7, 2);
	$month = substr($logline, 10, 3);
	$cntr = 0;
	foreach $cmpmonth (@months) {
		$cntr++;
		if ($month eq $cmpmonth) {
			last;
		} 
	}
	$month = sprintf ("0%d",$cntr);
	$month = substr($month, -2, 2);
	$year = substr($logline, 14, 2);
	$hour = substr($logline, 17,2);
	$minutes = substr($logline, 20, 2);
	$number = substr($logline, 23, 4);
	if (substr($number, 0, 1) eq "0") {
		$number = substr($number, 1, 3);
	}
	$call = substr($logline, 29, 13);
	$call =~ s/\s*$//;
	$rstsend = substr($logline, 44, 3);
	$rstsend =~ s/\s*$//;
	$rstrcvd = substr($logline, 49, 3);
	$rstrcvd =~ s/\s*$//;
	$exchange = substr($logline, 54, 20);
	$exchange =~ s/\s*$//;
	$frequency = substr($logline, 84, 5);
	chomp $frequency;
	$frequency /= 1000;
	
	$outline = sprintf("<band:%d>%sM<mode:%d>%s<qso_date:8>20%s%s%s<time_on:4>%s%s",length ($Band) + 1, $Band, 
		length ($Mode), $Mode, $year,$month,$day,$hour,$minutes); 
	
	if ($exchangetype eq "stdxchange") {
		$xchng = $standardexchange;
	} elsif ($exchangetype eq "serial") {
		$xchng = $number;
	} else {
		$xchng = $number;
	}
	$outline2 = sprintf("<stx:%d>%s\n",length($xchng), $xchng);
	
	$outline3 = sprintf("<call:%d>%s<rst_sent:%d>%s<rst_rcvd:%d>%s", length($call), $call,
		length($rstsend), $rstsend, length($rstrcvd), $rstrcvd);
		
	$outline4 = sprintf("<comment:%d>%s<freq:%d>%s<eor>\n", length($exchange), $exchange, length($frequency), $frequency);
	
	print OUT "$outline$outline2$outline3$outline4\n";
	
}
close (OUT);
