#! /usr/bin/perl -w


# Ham Radio log convert module logconvert.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    logconvert.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    logconvert.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 05-04-06



#$exchangetype = "serial", "standardexchange";
#$standardexchange = "";

############################################################################
sub make_cbr {
############################################################################
my ($inputfile, $outputfile, $exchangetype, $standardexchange) = @_;

my ($Band, $Mode, $day, $month, $cntr, $cmpmonth, $year, $hour, $minutes, $number, $call,
	$logline, $rstsend, $rstrcvd, $exchange, $frequency	);
	
	open (IN, "<", $inputfile) or die "Cannot open log file $!";
	my @log = <IN>;
	close (IN);

	makesummary($outputfile);

	open (OUT, ">>", $outputfile) or die "Cannot open cabrillo file $!";

	@months = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	$cntr = 0;

	foreach $logline (@log) {
		$Band = substr($logline, 0, 3);
		$Band =~ s/\s*//;
		$Mode = substr($logline, 3, 3);
		$Mode =~ s/\s*$//;
		if ($Mode eq "DIG") {
			$Mode = "RY";
		} elsif ($Mode eq "SSB") {
			$Mode = "PH";
		} else {
			$Mode = "CW";
		}
		$day = substr($logline, 7, 2);
		$month = substr($logline, 10, 3);
		$cntr = 0;
		foreach $cmpmonth (@months) {
			$cntr++;
			if ($month eq $cmpmonth) {
				last;
			} 
		}
		$month = sprintf ("0%d",$cntr);
		$month = substr($month, -2, 2);
		$year = "20" . substr($logline, 14, 2);
		$hour = substr ($logline, 17, 2);
		$minutes = substr($logline, 20, 2);
		$number = substr($logline, 23, 4);
		$call = substr($logline, 29, 13);
#		$call =~ s/\s*$//;
		$rstsend = substr($logline, 44, 3);
#		$rstsend =~ s/\s*$//;
		$rstrcvd = substr($logline, 49, 3);
#		$rstrcvd =~ s/\s*$//;
		$exchange = substr($logline, 54, 6);
#		$exchange =~ s/\s*$//;
		$frequency = substr($logline, 84, 7);
		$frequency = int ($frequency);
		chomp $frequency;
		$pcall = $Mycall . "             ";
		$pcall = substr($pcall, 0, 13);

		$pexchange = $standardexchange . "      ";
 		$pexchange =~ s/\#/$number/g; 
		$pexchange = substr($pexchange, 0, 6);
		
#                              --------info sent------- -------info rcvd--------
#QSO: freq  mo date       time call          rst exch   call          rst exch   t
#QSO: ***** ** yyyy-mm-dd nnnn ************* nnn ****** ************* nnn ****** n
#QSO:  3799 PH 1999-03-06 0711 HC8N          59  700    W1AW          59  CT     0
#000000000111111111122222222223333333333444444444455555555556666666666777777777788
#123456789012345678901234567890123456789012345678901234567890123456789012345678901

	my $outline = sprintf ("QSO: %5s %s %s-%s-%s %s%s %13s %3s %6s %13s %3s %6s",$frequency, $Mode, $year, $month, $day, $hour, $minutes, $pcall, $rstsend,$pexchange, $call,  $rstrcvd, $exchange);		
		print OUT "$outline\n";
		
	}
	print OUT "END-OF-LOG:\n";

	close (OUT);

}

#######################################
sub makesummary {
#######################################
	my $outputfile = shift @_;
	
	my @messages = ();
	eval {
		open ($fh, "$ENV{HOME}/.xtlf/summarydata") or die "Cannot find messages\n";
		while (<$fh>) {
			if (/=(.*)/) {
				push @messages, $1;
			}
		}
		close ($fh);
	};
	if ($@) {
		print $@;
	}

open ($fh, ">", $outputfile) or die "cannot open output file $outputfile: $!";
	print $fh "START-OF-LOG: 2.0\n";
	print $fh "ARRL-SECTION: " . $messages[1] ."\n";
	print $fh "CALLSIGN: " . $messages[0] ."\n";
	print $fh "CONTEST: " . $messages[7] ."\n";
	print $fh "CATEGORY: ";
	if ($messages[2]) { print $fh $messages[2] . " ";}
	if ($messages[3]) { print $fh $messages[3] . " ";}
	if ($messages[4]) { print $fh $messages[4] . " ";}
	if ($messages[5]) { print $fh $messages[5] . " ";}
	print $fh "\n";
	print $fh "CATEGORY-ASSISTED:" . $messages[6] ."\n";
	if ($messages[9]) { 
		print $fh "CATEGORY-OVERLAY: " . $messages[9] . "\n";
	}
	if ($messages[8]) { 
		print $fh "OPERATORS: " . $messages[8] . "\n";
	}
	print $fh "CLAIMED-SCORE: " . $totalscore . "\n";
	if ($messages[19]) { 
		print $fh "CLUB: " . $messages[19] . "\n";
	}
	print $fh "CREATED-BY: " . "Xtlf-1.0.0" ."\n";
	if ($messages[16]) { 
		print $fh "CATEGORY-DXPEDITION: " . $messages[16] . "\n";
	}
	if ($messages[17]) { 
		print $fh "CATEGORY-TIME: " . $messages[17] . "\n";
	}
	if ($messages[18]) { 
		print $fh "IOTA-ISLAND-NAME: " . $messages[18] . "\n";
	}
	if ($messages[10]) { 
		print $fh "NAME: " . $messages[10] . "\n";
	}
	if ($messages[11]) { 
		print $fh "ADDRESS: " . $messages[11] . "\n";
	}
	if ($messages[12]) { 
		print $fh "ADDRESS: " . $messages[12] . "\n";
	}
	if ($messages[13]) { 
		print $fh "ADDRESS: " . $messages[13] . "\n";
	}
	if ($messages[14]) { 
		print $fh "ADDRESS: " . $messages[14] . "\n";
	}
	if ($messages[15]) { 
		print $fh "SOAPBOX: " . $messages[15] . "\n";
	}

close ($fh);

}
1;
