/*********************************************
**********************************************
This is the main ICQ file. Currently it
logs in and sits in a loop. It can receive
messages and keeps the connection alive.
Use crtl-break to exit.

This software is provided AS IS to be used in
whatever way you see fit and is placed under
the GPL.

Used/Changed for zICQ by Omar Harriott, March 1999

Author : Matthew Smith April 19, 1998
Contributors : Nicolas Sahlqvist April 27, 1998
	Ulf Hedlund (guru@slideware.com) April 28, 1998
	Michael Ivey May 4, 1998
	Michael Holzt May 5, 1998
	Zack Allison Jun 30, 1998
	James Perkins March 11, 1999
	Omar Harriott March 19, 1999
	Chris Moore March 20, 1999

Changes :
   6-30-98 Completed port to ncurses.  Next: Colors.
   4-28-98 support for WIN32 [UH]
   4-20-98 added variable time_delay between keep_alive packets mds
   4-20-98 added instant message from server support mds
   4-21-98 changed so that long ( 250+ characters ) messages work
            new maximum is ~900 which is hopefully big enough.
            When I know more about udp maybe I can come up with
            a general solution. mds I now think ICQ has a max that is
            smaller than this so everything is ok mds I now think that
            the icq client's maximum is arbitrary and can be ignored :)
   4-23-98 Added beginnings of a user interface
   4-26-98 Changed the version to 0.2a :)
   4-27-98 Nicco added feature to use nick names to log in
   5-05-98 Authorization Messages
   5-13-98 Added time stamps for most things.
**********************************************
**********************************************/
#include "zicq.h"
#include "datatype.h"
#include <stdio.h>
#include <stdlib.h>
#include <ncurses.h>
#include <pthread.h>

#ifdef _WIN32
#include <conio.h>
#include <io.h>
#include <winsock2.h>
#include <time.h>
#else
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/time.h>
#endif
#include <fcntl.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

WINDOW* mainw; // Incoming messages, misc output
WINDOW* blist; // Buddy List
WINDOW* statz;  // Status line
WINDOW* userin; // User input

WINDOW* tempw;   // Borders
WINDOW* tempw2;
WINDOW* tempw3;

pthread_t Keep_Alive_Thread;
pthread_t User_Input_Thread;
int lines;
int next;
int time_out;
int time_out_delay = 60;
int time_delay = 60;
int sok;
char temp[1000]; // Temp for input/output

BOOL Got_Ping = FALSE;
BOOL Dosound = FALSE;
char* SPlayer;
char SFile[200];
BOOL Dobeep = TRUE;
BOOL Int_End;
BOOL Russian = FALSE;
BOOL Logging = TRUE;
BOOL Quit = FALSE;
BOOL Verbose = FALSE; /* this is needed because I leeched so code
                  from another project I'm working on. */
BOOL serv_mess[ 1024 ];
WORD last_cmd[ 1024 ]; /* command issued for the first 1024 SEQ #'s */
/******************** if we have more than 1024 SEQ this will need some hacking */
WORD seq_num = 1;  /* current sequence number */
DWORD our_ip = 0x0100007f; /* localhost for some reason */
DWORD our_port; /* the port to make tcp connections on */
/************ We don't make tcp connections yet though :( */
DWORD UIN; /* current User Id Number */
BOOL Contact_List = FALSE;
Contact_Member Contacts[ 100 ]; /* no more than 100 contacts max */
int Num_Contacts=0;
DWORD Current_Status=STATUS_OFFLINE;
DWORD last_recv_uin=0;
char passwd[100];
char server[100];
DWORD set_status;
DWORD remote_port;
BOOL Done_Login=FALSE;
BOOL auto_resp=FALSE;
char auto_rep_str[450] = { "User is away.\r\n" };
char message_cmd[16];
char info_cmd[16];
char quit_cmd[16];
char reply_cmd[16];
char again_cmd[16];
char add_cmd[16];

char list_cmd[16];
char away_cmd[16];
char na_cmd[16];
char dnd_cmd[16];
char online_cmd[16];
char occ_cmd[16];
char ffc_cmd[16];
char inv_cmd[16];
char status_cmd[16];
char auth_cmd[16];
char auto_cmd[16];
char change_cmd[16];
char search_cmd[16];

/*/////////////////////////////////////////////
// Connects to hostname on port port
// hostname can be DNS or nnn.nnn.nnn.nnn
// write out messages to the FD aux */
int Connect_Remote( char *hostname, int port, FD_T aux )
{
	int conct, length;
   int sok;
	struct sockaddr_in sin;  /* used to store inet addr stuff */
	struct hostent *host_struct; /* used in DNS llokup */

	sin.sin_addr.s_addr = inet_addr( hostname ); /* checks for n.n.n.n notation */
	if ( sin.sin_addr.s_addr  == -1 ) /* name isn't n.n.n.n so must be DNS */
	{
	   host_struct = gethostbyname( hostname );
      if ( host_struct == NULL )
      {
         if ( Verbose )
         {
            lw_wprintw(mainw, "Shakespeare couldn't spell why should I?\n" );
            lw_wprintw(mainw, " Especially something like %s\n", hostname );
            /*herror( "Can't find hostname" );*/
         }
         return 0;
      }
	   sin.sin_addr = *((struct in_addr *)host_struct->h_addr);
   }
	sin.sin_family = AF_INET; /* we're using the inet not appletalk*/
	sin.sin_port = htons( port );	/* port */
	sok = socket( AF_INET, SOCK_DGRAM, 0 );/* create the unconnected socket*/
   if ( sok == -1 )
   {
      perror( "Socket creation failed" );
      endwin();
      exit( 1 );
   }
   if ( Verbose )
   {
      lw_wprintw(mainw, "Socket created attempting to connect\n" );
   }
	conct = connect( sok, (struct sockaddr *) &sin, sizeof( sin ) );
	if ( conct == -1 )/* did we connect ?*/
	{
      if ( Verbose )
      {
   	   lw_wprintw(mainw, " Conection Refused on port %d at %s\n", port, hostname );
         #ifdef FUNNY_MSGS
            lw_wprintw(mainw, " D'oh!\n" );
         #endif
   	   perror( "connect" );
      }
	   return 0;
	}
   length = sizeof( sin ) ;
   getsockname( sok, (struct sockaddr *) &sin, &length );
   our_ip = sin.sin_addr.s_addr;
   our_port = sin.sin_port;
   if (Verbose )
   {
      #ifdef FUNNY_MSGS
         lw_wprintw(mainw, "Our port is %d, take her to sea Mr. Mordoch.\n", ntohs( sin.sin_port ) );
      #else
         lw_wprintw(mainw, "The port that will be used for tcp ( not yet implemented ) is %d\n", ntohs( sin.sin_port ) );
      #endif
   }
   if ( Verbose )
   {
      lw_wprintw(mainw, "Connected to %s, waiting for response\n", hostname );
   }
   return sok;
}


/******************************************
Handles packets that the server sends to us.
*******************************************/
void Handle_Server_Response( SOK_T sok )
{
   srv_net_icq_pak pak;
   SIMPLE_MESSAGE_PTR s_mesg;
   int s,i,len;

   s = SOCKREAD( sok, &pak.head.ver, sizeof( pak ) - 2  );
   if ( ( serv_mess[ Chars_2_Word( pak.head.seq ) ] ) )
   {
      if ( Chars_2_Word( pak.head.cmd ) != SRV_ACK ) /* ACKs don't matter */
      {
         if ( Verbose )
            lw_wprintw(mainw, "\nIgnored a message cmd  %04x\n", Chars_2_Word( pak.head.cmd )  );
         ack_srv( sok, Chars_2_Word( pak.head.seq ) ); /* LAGGGGG!! */
         return;
      }
   }
   if ( Chars_2_Word( pak.head.cmd ) != SRV_ACK )
      serv_mess[ Chars_2_Word( pak.head.seq ) ] = TRUE;
   switch ( Chars_2_Word( pak.head.cmd ) )
   {
   case SRV_UNKOWN:
	wprintw(mainw,"Server told us our connection timed out.\n");

	break;
   case SRV_BADLOG:
	wprintw(mainw,"\nServer will not let us login.\n");
	wprintw(mainw,"It might think we're still logged in.\n");
	wrefresh(mainw);
	break;
   case SRV_ACK:
      if ( Verbose )
         lw_wprintw(mainw, "The server acknowledged the %04x command.\n",
            last_cmd[ Chars_2_Word( pak.head.seq ) ] );
      break;
   case SRV_LOGIN_REPLY:
      UIN = Chars_2_DW( &pak.data[0] );
      our_ip = Chars_2_DW( &pak.data[4] );
      lw_wprintw(mainw, "\nLogin successful! UIN : %lu\n", UIN );
      lw_wprintw(mainw, " IP : %u.%u.%u.%u\t", pak.data[4], pak.data[5], pak.data[6], pak.data[7] );
      Time_Stamp();
      lw_wprintw(mainw, "\n" );
      ack_srv( sok, Chars_2_Word( pak.head.seq ) );
      snd_login_1( sok );
      snd_contact_list( sok );
      icq_change_status( sok, set_status );
      check_timeout();  // Start our timeout checking
      Prompt();
      lw_wprintw(mainw,"\n");
      break;
   case SRV_RECV_MESSAGE:
         Recv_Message( sok, pak );
      Prompt();
      break;
   case SRV_X1: /* unknown message  sent after login*/
      if ( Verbose )
         lw_wprintw(mainw, "\nAcknowleged SRV_X1 0x021C Begin messages?\n" );
      ack_srv( sok, Chars_2_Word( pak.head.seq ) );
      break;
   case SRV_X2: /* unknown message  sent after login*/
      if ( Verbose )
         lw_wprintw(mainw, "\nAcknowleged SRV_X2 0x00E6 Done old messages?\n" );
      Show_Quick_Status();
      Done_Login = TRUE;
      ack_srv( sok, Chars_2_Word( pak.head.seq ) );
      snd_got_messages( sok );
      Prompt();
      break;
   case SRV_INFO_REPLY:
      Display_Info_Reply( sok, pak );
      Prompt();
      break;
   case SRV_USER_OFFLINE:
      User_Offline( sok, pak );
      Prompt();
      break;
   case SRV_USER_ONLINE:
      User_Online( sok, pak );
      Prompt();
      break;
   case SRV_STATUS_UPDATE:
      Status_Update( sok, pak );
      Prompt();
      break;
   case SRV_GO_AWAY:
      #ifdef FUNNY_MSGS
      lw_wprintw(mainw, "\nServer sent \"Go away!!\" command.\t" );
      #else
      lw_wprintw(mainw, "\nServer has forced us to disconnect.  This may be because of a bad password.\t" );
      #endif
      Time_Stamp();
      Quit = TRUE;
      Prompt();
      break;
   case SRV_END_OF_SEARCH:
      lw_wprintw(mainw, "\nSearch done.\n" );
      ack_srv( sok, Chars_2_Word( pak.head.seq ) );
      Prompt();
      break;
   case SRV_USER_FOUND:
      Display_Search_Reply( sok, pak );
      Prompt();
      break;
   case CHAT_MESS:
	wprintw(mainw,"CHAT REQUESTED!!!\n");
	break;
   case FILE_MESS:
        lw_wprintw(mainw,"FILE REQUESTED!!!\n");
	break;
   case SRV_SYS_DELIVERED_MESS:
      s_mesg = ( SIMPLE_MESSAGE_PTR ) pak.data;
      if ( ! strcmp( s_mesg->len + 2,"zICQ-PING.PING!PING")) { // Is this our pi$
      	Got_Ping = TRUE;
#ifdef DEBUG
      	wprintw(mainw,"\nRecieved Ping.  Sending another one.\n");
      	wrefresh(mainw);
#endif
     	break;
     }


      last_recv_uin = Chars_2_DW( s_mesg->uin );
      //Print_UIN_Name( Chars_2_DW( s_mesg->uin  ) );
      wcolor_set(mainw,4,NULL);
      lw_wprintw(mainw, "%s ",Get_Nick(last_recv_uin));
      wcolor_set(mainw,1,NULL);
      lw_wprintw(mainw, "(");
      wcolor_set(mainw,4,NULL);
      lw_wprintw(mainw, "%ld",last_recv_uin);
      wcolor_set(mainw,1,NULL);
      lw_wprintw(mainw, ") ",last_recv_uin);
      wcolor_set(mainw,1,NULL);
      lw_wprintw(mainw, "- Instant Message - " );
      if ( Verbose )
         lw_wprintw(mainw, " Type = %04x\t", Chars_2_Word( s_mesg->type ) );
      Time_Stamp();
      Do_Msg( sok, Chars_2_Word( s_mesg->type ), Chars_2_Word( s_mesg->len ),
           s_mesg->len + 2,last_recv_uin);
      ack_srv( sok, Chars_2_Word( pak.head.seq ) );
      if ( 0xfe != *( ((unsigned char *) s_mesg ) + sizeof( s_mesg ) ) )
      {
         if ( ( Current_Status != STATUS_ONLINE ) && ( auto_resp ) )
         {
            icq_sendmsg( sok, Chars_2_DW( s_mesg->uin ), auto_rep_str );
            lw_wprintw(mainw, "[ Sent auto-reply message ]\n" );
         }
      }
      lw_wprintw(mainw,"\n");
      Prompt();
      break;
   case BADPASSWD:
	wprintw(mainw,"\nServer said our password was bad.");
	wrefresh(mainw);
	break;
   default: /* commands we dont handle yet */
       lw_wprintw(mainw, CLIENTCOL "\nThe response was %04X\t", Chars_2_Word( pak.head.cmd ) );
       lw_wprintw(mainw, "The version was %X\t", Chars_2_Word( pak.head.ver ) );
       Time_Stamp();
       lw_wprintw(mainw, "\nThe SEQ was %04X\t", Chars_2_Word( pak.head.seq ) );
       len = s - ( sizeof( pak.head ) - 2 );
       lw_wprintw(mainw, "The size was %d\n", len );
//       if ( Verbose )
	if ( 1 )
       {
	  lw_wprintw(mainw,"\n%ld\n",Chars_2_DW( &pak.data[0] ));
          for ( i=0; len > i; i++ )
          {
             lw_wprintw(mainw, "%02X ",( unsigned char ) pak.data[i] );
             if ( i % 10 == 9 )
             {
                lw_wprintw(mainw, "\n" );
             }
          }
       }
       lw_wprintw(mainw, NOCOL "\n" );
       Prompt();
//       zwinfix();
       ack_srv( sok, Chars_2_Word( pak.head.seq ) ); /* fake like we know what we're doing*/
       break;
   }
}

/********* NO LONGER USED ******************************/
/*******************************************************
Reads in the Contacts file
into the Contacts array.
********************************************************/
void Read_Contacts( char *file )
{
   FD_T fd;
   char *tmp;
   DWORD tmp_uin;
   char buf[ 32 ]; /* 10 digits uin + space + 20 char nickname + \000 */

   fd = open( file, O_RDONLY );
   if ( fd == -1 )
   {
      fprintf( stderr, "Open %s", file );
      perror( "" );
      Contact_List = FALSE;
      return;
   }
   Contact_List = TRUE;
   for ( ; ! M_fdnreadln( fd, buf, sizeof( buf ) ); )
   {
      if ( Num_Contacts == 100 )
         break;
      if ( ( buf[0] != '#' ) && ( buf[0] != 0 ) )
      {
         if ( isdigit( (int) buf[0] ) )
         {
            Contacts[ Num_Contacts ].uin = atoi( strtok( buf, " " ) );
            Contacts[ Num_Contacts ].status = STATUS_OFFLINE;
            Contacts[ Num_Contacts ].last_time = -1L;
            Contacts[ Num_Contacts ].current_ip = -1L;
            tmp = strtok( NULL, "" );
            if ( tmp != NULL )
               memcpy( Contacts[ Num_Contacts ].nick, tmp, sizeof( Contacts->nick )  );
            else
               Contacts[ Num_Contacts ].nick[0] = 0;
            if ( Contacts[ Num_Contacts ].nick[19] != 0 )
               Contacts[ Num_Contacts ].nick[19] = 0;
            if ( Verbose )
               lw_wprintw(mainw, "%ld = %s\n", Contacts[ Num_Contacts ].uin, Contacts[ Num_Contacts ].nick );
            Num_Contacts++;
         }
         else
         {
            tmp_uin = Contacts[ Num_Contacts - 1 ].uin;
            tmp = strtok( buf, ", \t" ); /* aliases may not have spaces */
            for ( ; tmp!=NULL; Num_Contacts++ )
            {
               Contacts[ Num_Contacts ].uin = -tmp_uin;
               Contacts[ Num_Contacts ].status = STATUS_OFFLINE;
               Contacts[ Num_Contacts ].last_time = -1L;
               Contacts[ Num_Contacts ].current_ip = -1L;
               memcpy( Contacts[ Num_Contacts ].nick, tmp, sizeof( Contacts->nick )  );
               tmp = strtok( NULL, ", \t" );
            }
         }
      }
   }
   if ( Verbose )
      lw_wprintw(mainw, "Total contacts on list %d\n", Num_Contacts );
   close( fd );
}

/**********************************************
Verifies that we are in the correct endian
***********************************************/
void Check_Endian( void )
{
   int i;
   char passwd[10];

   passwd[0] = 1;
   passwd[1] = 0;
   passwd[2] = 0;
   passwd[3] = 0;
   passwd[4] = 0;
   passwd[5] = 0;
   passwd[6] = 0;
   passwd[7] = 0;
   passwd[8] = 0;
   passwd[9] = 0;
   i = *  ( DWORD *) passwd;
   if ( i == 1 )
   {
      lw_wprintw(mainw, "Using intel byte ordering.\n" );
      Int_End = TRUE;
   }
   else
   {
      lw_wprintw(mainw, "Using motorola byte ordering.\n" );
      Int_End = FALSE;
   }
}

void zwinfix() {
  wrefresh(mainw);
  wrefresh(statz);
  wrefresh(blist);
  wrefresh(userin);
}



void resize() {
  int i;
  endwin();
  initscr(); // cycle.
   start_color(); // Start Color(?)
   cbreak(); // Don't intercept key presses
   raw();
   noecho(); // Show them what they're typing
  wrefresh(blist);
  delwin( mainw );
  delwin( blist );
  delwin( statz );
  delwin( userin );
  delwin( tempw );
  delwin( tempw2 );
  delwin( tempw3 );

  endwin();
  for (i=0;i<100;i++){
  // DELAY: Allow screen to reset.
  }
  initscr();
  start_color();
  cbreak();
  raw();
  noecho();
   init_pair(1,COLOR_WHITE,COLOR_BLACK);
   init_pair(2,COLOR_RED,COLOR_BLACK);
   init_pair(3,COLOR_CYAN,COLOR_BLACK);
   init_pair(4,COLOR_MAGENTA,COLOR_BLACK);
   init_pair(5,COLOR_GREEN,COLOR_BLACK);
   init_pair(6,COLOR_RED,COLOR_BLACK);
   init_pair(7,COLOR_BLUE,COLOR_BLACK);
   init_pair(8,COLOR_YELLOW,COLOR_BLACK);


   tempw = newwin(LINES-4,COLS-25,0,0);
   mainw = newwin(LINES-6,COLS-27,1,1); // Top left.. leave room for status etc

   tempw2 = newwin(LINES-4,25,0,COLS-25);
   blist = newwin(LINES-6,23,1,COLS-24); // Top Right

   tempw3 = newwin(4,COLS,LINES-4,0);
   statz = newwin(1,COLS-2,LINES-3,1); // One line... status info?
   userin = newwin(1,COLS-2,LINES-2,1); // Two Lines (Enough)

   idlok(tempw,TRUE); idcok(tempw,TRUE);
   idlok(mainw,TRUE); scrollok(mainw,TRUE);
   idlok(blist,TRUE); scrollok(blist,TRUE);
   idlok(statz,TRUE); scrollok(statz,TRUE);
   idlok(userin,TRUE); scrollok(userin,TRUE);
   idcok(userin,TRUE);

   wborder(tempw,0,0,0,0,0,0,0,0);
   wborder(tempw2,0,0,0,0,0,0,0,0);
   wborder(tempw3,0,0,0,0,0,0,0,0);
   wrefresh(tempw);
   wrefresh(tempw2);
   wrefresh(tempw3);
   keypad(userin,TRUE);
   zwinfix();

   lines = LINES;

}


void Get_Loop() {
   while(1){
	sleep(1);
	Get_Input( sok );
   }
}

void Keep_Loop() {
	struct tm *thetime;
	time_t p;
	p=time(NULL);
	thetime=localtime(&p);
	mvwprintw(statz,0,COLS-7,"%.02d:%.02d",thetime->tm_hour,thetime->tm_min);
	mvwprintw(userin,0,5," ");
	wrefresh(statz);
   while(1) {
      sleep(1);
      if (time( NULL) > time_out) {
	if ( Got_Ping ) {
		check_timeout();
	 } else {
   		//wprintw(mainw,"Connection timed out.\n");
		check_timeout();
		wrefresh(mainw);
	 }
	}
        if ( time( NULL ) > next )
      {
        p=time(NULL);
        thetime=localtime(&p);
        mvwprintw(statz,0,COLS-7,"%.02d:%.02d",thetime->tm_hour,thetime->tm_min);
	wrefresh(statz);
      sleep(1);
         next = time( NULL ) + time_delay;
         Keep_Alive( sok );
      }
   }
}



/******************************
Main function connects gets UIN
and passwd and logins in and sits
in a loop waiting for server responses.
******************************/
int main( int argc, char *argv[] )
{
    char* buffer;
   //int sok;
   int i;
   //int next;
   //int time_delay = 60;
   struct timeval tv;
   fd_set readfds;
#ifdef _WIN32
   WSADATA wsaData;
#endif
   time_out = time ( NULL ) + time_out_delay;
Get_Config_Info();
   initscr(); // Get ncurses started
   start_color(); // Start Color(?)
   cbreak(); // Don't intercept key presses
   raw();
   noecho(); // Show them what they're typing

   tempw = newwin(LINES-4,COLS-25,0,0);
   mainw = newwin(LINES-6,COLS-27,1,1); // Top left.. leave room for status etc

   tempw2 = newwin(LINES-4,25,0,COLS-25);
   blist = newwin(LINES-6,23,1,COLS-24); // Top Right

   tempw3 = newwin(4,COLS,LINES-4,0);
   statz = newwin(1,COLS-2,LINES-3,1); // One line... status info?
   userin = newwin(1,COLS-2,LINES-2,1); // Two Lines (Enough)



/*
   tempw = newwin(LINES-5,COLS-25,0,0);
   mainw = newwin(LINES-7,COLS-27,1,1); // Top left.. leave room for status etc

   tempw2 = newwin(LINES-5,25,0,COLS-25);
   blist = newwin(LINES-7,22,1,COLS-24); // Top Right

   tempw3 = newwin(5,COLS,LINES-5,0);
   statz = newwin(1,COLS-2,LINES-4,1); // One line... status info?
   userin = newwin(2,COLS-2,LINES-3,1); // Two Lines (Enough)
*/
   idlok(tempw,TRUE); idcok(tempw,TRUE);
   idlok(mainw,TRUE); scrollok(mainw,TRUE);
   idlok(blist,TRUE); scrollok(blist,TRUE);
   idlok(statz,TRUE); scrollok(statz,TRUE);
   idlok(userin,TRUE); scrollok(userin,TRUE);
   idcok(userin,TRUE);

   wborder(tempw,0,0,0,0,0,0,0,0);
   wborder(tempw2,0,0,0,0,0,0,0,0);
   wborder(tempw3,0,0,0,0,0,0,0,0);
   wrefresh(tempw);
   wrefresh(tempw2);
   wrefresh(tempw3);
   zwinfix();
   keypad(userin,TRUE);

   lines = LINES;

   // pair 0 = standard
   // pair 1 = Program messages.
   // pair 2 = info.
   // pair 3 = Nick
   // pair 4 = uin

   init_pair(1,COLOR_WHITE,COLOR_BLACK);
   init_pair(2,COLOR_RED,COLOR_BLACK);
   init_pair(3,COLOR_CYAN,COLOR_BLACK);
   init_pair(4,COLOR_MAGENTA,COLOR_BLACK);
   init_pair(5,COLOR_GREEN,COLOR_BLACK);
   init_pair(6,COLOR_RED,COLOR_BLACK);
   init_pair(7,COLOR_BLUE,COLOR_BLACK);
   init_pair(8,COLOR_YELLOW,COLOR_BLACK);
   wcolor_set(mainw,3,NULL);


   printw("\b\b\b\b");
   lw_wprintw(mainw, "Zack's ICQ clone compiled on %s %s Version 0.2.9\n", __TIME__, __DATE__ );
   wcolor_set(mainw,4,NULL);
#ifdef FUNNY_MSGS
   lw_wprintw(mainw, "\nNo Mirabilis client was hacked, maimed, or tortured in making of this  utility.\n" );
#else
   lw_wprintw(mainw, "\nThis program was made without any help from Mirabilis and without their consent.\n" );
   lw_wprintw(mainw, "\nNo reverse engineering or decompilation of any Mirabilis code took place\nto make this program.\n" );
#endif
   wcolor_set(mainw,5,NULL);
   lw_wprintw(mainw,"\nHas color: %s\n",has_colors() ? "Yes!" : "NO!");
   lw_wprintw(mainw,"Display is %ix%i",COLS,LINES);
   lw_wprintw(mainw,"\nSound is %s",Dosound ? "ON" : "OFF");
   if ( Dosound == TRUE) {
	lw_wprintw(mainw, " %s %s ",&SPlayer,&SFile);
   }
   lw_wprintw(mainw,"\nBeep is %s\n",Dobeep ? "ON" : "OFF");
   wcolor_set(mainw,1,NULL);
   lw_wprintw(mainw,"\nAttempting to Connect:\n");
   zwinfix();
//   Get_Config_Info();
   memset( serv_mess, FALSE, 1024 );
   if (argc > 1 )
   {
      for ( i=1; i< argc; i++ )
      {
         if ( argv[i][0] != '-' )
         ;
         else if ( (argv[i][1] == 'v' ) || (argv[i][1] == 'V' ) )
         {
            Verbose = ! Verbose;
         }
      }
   }
   Check_Endian();
#ifdef _WIN32
   i = WSAStartup( 0x0101, &wsaData );
   if ( i != 0 ) {
#ifdef FUNNY_MSGS
		perror("Windows Sockets broken blame Bill -");
#else
		perror("Sorry, can't initialize Windows Sockets...");
#endif
	    endwin();
	    exit(1);
   }
#endif
   sok = Connect_Remote( server, remote_port, STDERR );
   if ( ( sok == -1 ) || ( sok == 0 ) )
   {
   	perror("Couldn't establish connection\n" );
	endwin();
   	exit( 1 );
   }
//   pthread_create(&User_Input_Thread,NULL,Get_Loop,NULL);
   Login( sok, UIN, &passwd[0], our_ip, our_port );
   next = time( NULL );
   next += 30;
   Prompt();
   pthread_create(&Keep_Alive_Thread,NULL,Keep_Loop,NULL);
   pthread_create(&User_Input_Thread,NULL,Get_Loop,NULL);
   for ( ; !Quit; )
   {
      tv.tv_sec = 2;
      tv.tv_usec = 500000;

      FD_ZERO(&readfds);
      FD_SET(sok, &readfds);

      /* don't care about writefds and exceptfds: */
      select(sok+1, &readfds, NULL, NULL, &tv);

      if (FD_ISSET(sok, &readfds))
          Handle_Server_Response( sok );
	  else if (FD_ISSET( STDIN, &readfds ) )
      {
//         zwinfix();
//         Get_Input( sok );
      }
   }
   Quit_ICQ( sok );
   endwin();
   printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
   return 0;
}
