use Test::More tests => 26;

use Zim::Repository;
use Zim::Repository::Files;
use File::Spec;

eval 'require Zim::Win32' if $^O eq 'MSWin32';
die $@ if $@;

$Zim::CODESET = 'utf8';

# TODO: Wrap test data in a .PL file
# is no need for complete test repository in code tree

# Test a bunch of stuff in the "Files" backend

my $root = File::Spec->rel2abs( File::Spec->catdir(qw/t repository/) );
my $rep = Zim::Repository::Files->new(undef, '', $root);

is($rep->{format}, 'wiki', 'format'); # 1

print "\n## 2 file(foo:bar) resulted in: ".$rep->file('foo:bar')->path."\n";
ok($rep->file('foo:bar')->path =~ m#/t/repository/foo/bar.txt$#,
	'filename 1' ); # 2

my $page = $rep->get_page(':foo:bar');
is($page->status, 'new', 'status new page'); # 3
ok(@{$page->get_parse_tree} > 2, 'template'); # 4 
is($page->{format}, 'Zim::Formats::Wiki', 'format class'); # 5

ok($rep->file('Test:wiki')->path =~ m#/t/repository/Test/wiki.txt$#,
	'filename 2' ); # 6

print "\n## 7 - resolve_page test:WIKI => :Test:wiki\n";
$page = $rep->resolve_page('test:WIKI');
is($page->name, ':Test:wiki', 'resolve_page'); # 7

$page = $rep->get_page(':Test:foo:bar');
print "\n## 8 - resolve_link Dus => :Test:foo:Dus\n";
$page = $page->resolve_link('Dus');
is($page->name, ':Test:foo:Dus', 'resolve_link 1'); # 8

$page = $rep->get_page(':Test:foo:bar');
print "\n## 9 - resolve_link wIKi => :Test:wiki\n";
$page = $page->resolve_link('wIKi');
is($page->name, ':Test:wiki', 'resolve_link 2'); # 9

$page = $rep->get_page(':Test:foo:bar');
print "\n## 10 - resolve_link Test:Dus => :Test:Dus\n";
$page = $page->resolve_link('Test:Dus');
is($page->name, ':Test:Dus', 'resolve_link 3'); # 10

$page = $rep->get_page(':Test:foo:bar');
print "\n## 11 - resolve_link test:Dus => :Test:Dus\n";
$page = $page->resolve_link('test:Dus');
is($page->name, ':Test:Dus', 'resolve_link 4'); # 11

$page = $rep->get_page(':Test:foo:bar');
print "\n## 12 - resolve_link test:WIKI:bar => :Test:wiki:bar\n";
$page = $page->resolve_link('test:WIKI:bar');
is($page->name, ':Test:wiki:bar', 'resolve_link 5'); # 12

$page = $rep->get_page(':Test:foo:bar');
print "\n## 13 - resolve_link :Dus => :Dus\n";
$page = $page->resolve_link(':Dus');
is($page->name, ':Dus', 'resolve_link 6'); # 13

$page = $rep->get_page(':Test:foo');
print "\n## 14 - resolve_link .bar => Test:foo:bar\n";
$page = $page->resolve_link('.bar');
is($page->name, ':Test:foo:bar', 'resolve_link 7'); # 14

#$page = $rep->open_page('test:utf8-acchars');

for (
	[qw/t repository .zim.cache/],
	[qw/t repository Test bar.txt/]
) {
	my $f = Zim::File->new(@$_);
	$f->remove if $f->exists;
}

my @pages = $rep->list_pages(':');
#warn "Pages: ", map(">>$_<< ", @pages), "\n";
is_deeply(\@pages, [qw/Test:/], 'list_pages 1'); # 15

@pages = sort $rep->list_pages(':Test:');
#warn "Pages: ", map(">>$_<< ", @pages), "\n";
is_deeply(\@pages, [qw/foo: wiki/], 'list_pages 2'); # 16

# repeating previous test to catch bad caching
@pages = sort $rep->list_pages(':Test:');
#warn "Pages: ", map(">>$_<< ", @pages), "\n";
is_deeply(\@pages, [qw/foo: wiki/], 'list_pages 3'); # 17

# test caching in combo with new content
print "# sleeping 3 seconds ...\n";
sleep 3; # make sure mtime is changed
Zim::File->new(qw/t repository Test bar.txt/)->write("=== Bar ===\n\nfoo bar !\n" );
@pages = sort $rep->list_pages(':Test:');
#warn "Pages: ", map(">>$_<< ", @pages), "\n";
is_deeply(\@pages, [qw/bar foo: wiki/], 'list_pages 4'); # 18

# Test dispatching to child rep
$rep = Zim::Repository->new(undef, ':' => $root);

$page = $rep->get_page(':test:wiki');
is($page->{repository}{namespace}, ':', 'Child repository dispatch 1'); # 19

$page = $rep->get_page(':foo:bar');
is($page->{repository}{namespace}, ':', 'Child repository dispatch 2'); # 20

# add child rep
my $node = File::Spec->catdir($root, 'Foo');
$rep->add_child(':foo', 'Files', $node);

$page = $rep->get_page(':test:wiki');
is($page->{repository}{namespace}, ':', 'Child repository dispatch 3'); # 21

$page = $rep->get_page(':foo:bar');
is($page->{repository}{namespace}, ':foo:', 'Child repository dispatch 4'); # 22

$page = $rep->get_page(':Foo');
is($page->{repository}{namespace}, ':foo:', 'Child repository dispatch 5'); # 23

$page = $rep->get_page(':fooBar');
is($page->{repository}{namespace}, ':', 'Child repository dispatch 6'); # 24

ok(! -e $node, 'No pre-mature creation of repository dir'); # 25

my @res;
my $cb = sub { push @res, @_ };
$rep->search({string => "\x{2022}\x{2022} Search Me \x{2022}\x{2022}"}, $cb);
#use Data::Dumper; print Dumper \@res;
ok(scalar( grep {$$_[0] eq ':Test:foo:bar' and $$_[1] > 0} @res),
	"utf8 search pattern" ); # 26

