/* simplelist.h
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * High level routines for dealing with text files (read-only) with an item per line.
 */

//To stop multiple inclusions.
#ifndef SRC_SIMPLELIST_H
#define SRC_SIMPLELIST_H

#include "strtables.h"

extern t_st_strtable *slist_create (const char* given_filename);
extern void slist_destroy (t_st_strtable *slist_table);
extern int slist_check_if_matches (t_st_strtable *slist_table, const char *strdata);

#endif

