# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## These strings are used for errors when installing OpenSearch engines, e.g.
## via "Add Search Engine" on the address bar or search bar.
## Variables
## $location-url (String) - the URL of the OpenSearch engine that was attempted to be installed.

opensearch-error-duplicate-title = Faddina de installatzione
opensearch-error-duplicate-desc = { -brand-short-name } no at pòdidu installare su plugin de chirca dae { $location-url } ca esistit giai unu motore cun su pròpiu nòmine.
opensearch-error-format-title = Formadu non vàlidu
opensearch-error-format-desc = { -brand-short-name } no at pòdidu installare su motore de chirca dae: { $location-url }
opensearch-error-download-title = Faddina de iscarrigamentu
opensearch-error-download-desc = { -brand-short-name } no at pòdidu iscarrigare su cumplementu de chirca dae: { $location-url }

##

searchbar-submit =
    .tooltiptext = Imbia sa chirca
# This string is displayed in the search box when the input field is empty
searchbar-input =
    .placeholder = Chirca
searchbar-icon =
    .tooltiptext = Chirca

## Infobar shown when search engine is removed and replaced.
## Variables
## $oldEngine (String) - the search engine to be removed.
## $newEngine (String) - the search engine to replace the removed search engine.

removed-search-engine-message = <strong>Su motore de chirca predefinidu tuo est cambiadu.</strong> { $oldEngine } no est prus a disponimentu comente motore de chirca predefinidu in { -brand-short-name }. { $newEngine } est immoe su motore de chirca predefinidu tuo. Pro torrare a cambiare su motore de chirca predefinidu tuo, bae a is cunfiguratziones. <label data-l10n-name="remove-search-engine-article">Àteras informatziones</label>
removed-search-engine-message2 = <strong>Su motore de chirca predefinidu tuo est cambiadu.</strong> { $oldEngine } no est prus a disponimentu comente motore de chirca predefinidu in { -brand-short-name }. { $newEngine } est immoe su motore de chirca predefinidu tuo. Pro torrare a cambiare su motore de chirca predefinidu tuo, bae a is cunfiguratziones.
remove-search-engine-button = Andat bene

## Infobar shown when default search engine is reset due to an issue reading the settings file.
## Variables
## $newEngine (String) - the name of the new default search engine.


## Infobar shown when user is prompted to install search engine.
## Variables
## $engineName (String) - the name of the search engine to install.

install-search-engine = Boles agiùnghere { $engineName } a is motores de chirca?
install-search-engine-add = Agiunghe
install-search-engine-no = Nono

## These strings are used for the add engine dialog when adding a custom search engine
## in settings or when adding an HTML form as a search engine.

add-engine-window =
    .title = Agiunghe unu motore de chirca
    .style = min-width: 32em;
add-engine-button = Agiunghe unu motore personalizadu
add-engine-name = Chirca su nòmine de su motore
add-engine-keyword = Faeddu crae
add-engine-url = URL de su motore. Imprea %s in logu de su tèrmine de chirca
add-engine-dialog =
    .buttonlabelaccept = Agiunghe su motore
    .buttonaccesskeyaccept = A
engine-name-exists = Esistit giai unu motore cun custu nòmine
engine-keyword-exists = Esistit giai unu motore cun custu faeddu crae
