      SUBROUTINE DONEST(IOUNIT,D,E,W1,W2,IND,NT,EIGMIN,EIGMAX,COND)
C***BEGIN PROLOGUE  DONEST
C***REFER TO  DPPCG,DPCGCA
C***ROUTINES CALLED  SRATQR
C***REVISION DATE  860901   (YYMMDD)
C***END PROLOGUE  DONEST
C
C     THIS SUBROUTINE COMPUTES THE SMALLEST AND LARGEST EIGENVALUES OF
C     A SYMMETRIC POSITIVE DEFINITE TRIDIAGONAL MATRIX OF ORDER NT. THE
C     DIAGONAL IS STORED IN THE ARRAY D AND THE SUB-DIAG IS STORED IN
C     THE LAST NT-1 POSITIONS OF THE ARRAY E.  EIGMIN AND EIGMAX ARE
C     UPDATED WITH EACH CALL TO DONEST.  ONCE THESE ARE DETERMINED, AN
C     ESTIMATE FOR THE CONDITION NUMBER IS COMPUTED.  THE ARRAYS D AND
C     E ARE UNALTERED.  TWO DBLE WORK ARRAYS (W1, W2) AND ONE INTEGER
C     WORK ARRAY (IND) MUST BE PASSED.
C
C     *** DECLARATIONS ***
      IMPLICIT  DOUBLE PRECISION(A-H,O-Z)
      PARAMETER (M=1, IDEF=1)
      DIMENSION D(NT),E(NT),W1(NT),W2(NT),IND(NT)
      LOGICAL TYPE
C
C***FIRST EXECUTABLE STATEMENT  DONEST
 1    CONTINUE
C
C     *** FIND SMALLEST EIGENVALUE ***
      EPS1 = 0.0D0
      TYPE = .TRUE.
      DO 10 I = 2, NT
         W1(I) = E(I)**2
 10   CONTINUE
      CALL SRATQR(NT,EPS1,D,E,W1,M,W2,IND,W1,TYPE,IDEF,IERR)
      IF (IERR .NE. 0) THEN
         WRITE(IOUNIT,15) IERR
 15      FORMAT(/, ' WARNING IN DONEST: SRATQR RETURNED IERR = ', I5, /)
      ELSE
         EIGMIN = DMIN1(EIGMIN,W2(1))
      END IF
C
C     *** FIND LARGEST EIGENVALUE ***
      EPS1 = 0.0D0
      TYPE = .FALSE.
      DO 20 I = 2, NT
         W1(I) = E(I)**2
 20   CONTINUE
      CALL SRATQR(NT,EPS1,D,E,W1,M,W2,IND,W1,TYPE,IDEF,IERR)
      IF (IERR .NE. 0) THEN
         WRITE(IOUNIT,15) IERR
      ELSE
         EIGMAX = DMAX1(EIGMAX,W2(1))
      END IF
C
C     *** UPDATE CONDITION NUMBER ESTIMATE ***
      COND = DMAX1(1.0D0, EIGMAX/EIGMIN, COND)
      IF (IOUNIT .GT. 0) WRITE(IOUNIT,50) EIGMIN, EIGMAX, COND
 50   FORMAT(4X, ' MIN, MAX EIGENVALUES = ', D12.5, ' AND ', D12.5, /,
     2       4X, ' CONDITION NUMBER     = ', D12.5, /)
C
      RETURN
      END
