/* PROGRAM:     eggsh
 * FILE:        $Header: /home/egg/src/RCS/storage.h,v 1.3 1998/12/31 22:11:05 ghn Exp $
 * PURPOSE:     Definitions for data storage functions
 * AUTHOR:      Greg Nelson
 * DATE:        98-05-09
 *
 * REVISED:
 * $Log: storage.h,v $
 * Revision 1.3  1998/12/31 22:11:05  ghn
 *  Rev 5 code: includes multi-reg support, HTML, etc.
 *
 * Revision 1.2  1998/08/01 17:19:48  ghn
 * Added ResetDatabase function.
 *
 * Revision 1.1  1998/07/21 11:35:10  ghn
 * Initial revision
 *
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

typedef struct dbase {
  FILE *fp;
  int16 eggind;
  char fn[256];
} DBRec;

/* The initialization provides a way to specify a format for the
   database file names.  If the argument is null, it uses a default
   from the environment, or a compiled default.  This string is used
   as an argument to strftime(3) which replaces certain characters
   with corresponding fields of the date and time.  This provides an
   automatic way of generating a logical new filename on a periodic
   basis.

   The other function of the initialization is to clear static
   variable used to incrementally collect records for SaveRecord until
   a complete packet is available for storage to disk. */ 
extern int32 InitStorage(char *path);

/* Save packet is the basic save function.  It does not take a
   filename, relying on the datafmt variable created during
   initialization to generate an appropriate filename.  The
   date for the saved data is based on the timestamp of the packet's
   first record. */
extern int32 SavePacket(EggCarton *cart);

/* Open database for reading, positioning to specified location.
   If eggid is less than zero, it will load any packet. */
extern int32 OpenDatabase(DBRec *db, uint32 tindex, int16 eggid);

/* Close database */
extern int32 CloseDatabase(DBRec *db);

/* Reset database allows us to open same file name again. */
extern int32 ResetDatabase(DBRec *dbp);

/* Load next packet following a particular time index and egg id.  If
   eggid is less than zero, it will load any packet.  This is
   essentially a shortcut for getting one packet. */

extern int32 LoadPacket(uint32 tindex, int16 eggid, EggCarton *cart);

