#!/bin/sh
# Edit this to add a language, then run this script
LANGS="cs de el es fr pt_BR ru sv"

echo Creating Makefile.am...

cat > Makefile.am <<EOF
###################################################################
# THIS FILE IS AUTOGENERATED DO NOT EDIT.  EDIT make-makefile-am.sh
###################################################################

EOF

FIGUREBASENAMES=""
CFIGURES=""
for n in `ls C/figures/*.png 2>/dev/null` ; do
	CFIGURES="$CFIGURES $n"
	FIGUREBASENAMES="$FIGUREBASENAMES `basename $n`"
done

CHTMLS=`ls C/html/*.html 2>/dev/null`
CHTMLS=`echo $CHTMLS`
EXTRAFILES="$CHTMLS $CFIGURES C/genius.xml C/legal.xml"

CHTMLS=`echo $CHTMLS | sed 's/ / \\\\\n  /g'`
echo C

cat >> Makefile.am <<EOF

#########################################################
#C

THE_CFIGURES = $CFIGURES

manualxmlCdir = \$(datadir)/genius/help/C
manualxmlC_DATA = C/genius.xml C/legal.xml
manualxmlCfiguresdir = \$(datadir)/genius/help/C/figures
manualxmlCfigures_DATA = \$(THE_CFIGURES)

manualhtmlCdir = \$(datadir)/genius/help/C/html
manualhtmlC_DATA = $CHTMLS
manualhtmlCfiguresdir = \$(datadir)/genius/help/C/html/figures
manualhtmlCfigures_DATA = \$(THE_CFIGURES)


EOF

for lang in $LANGS ; do 
	echo $lang
	LANGBASENAMES=""
	for n in `ls $lang/figures/*.png 2>/dev/null` ; do
		LANGBASENAMES="$LANGBASENAMES `basename $n`"
	done
	LANGBASENAMES=`echo $LANGBASENAMES $FIGUREBASENAMES | sed 's/ /\n/g' | sort | uniq`
	LANGBASENAMES=`echo $LANGBASENAMES`

	THEFIGURES=""


	for b in $LANGBASENAMES ; do
		if test -e $lang/figures/$b ; then
			THEFIGURES="$THEFIGURES $lang/figures/$b"
			EXTRAFILES="$EXTRAFILES $lang/figures/$b"
		else
			THEFIGURES="$THEFIGURES C/figures/$b"
		fi
	done

	LANGHTMLS=`ls $lang/html/*.html 2>/dev/null`
	LANGHTMLS=`echo $LANGHTMLS`
	EXTRAFILES="$EXTRAFILES $LANGHTMLS $lang/genius.xml"
	LANGHTMLS=`echo $LANGHTMLS | sed 's/ / \\\\\n  /g'`

cat >> Makefile.am <<EOF
#########################################################
#$lang

THE_${lang}FIGURES = $THEFIGURES

manualxml${lang}dir = \$(datadir)/genius/help/${lang}
manualxml${lang}_DATA = ${lang}/genius.xml
manualxml${lang}figuresdir = \$(datadir)/genius/help/${lang}/figures
manualxml${lang}figures_DATA = \$(THE_${lang}FIGURES)

manualhtml${lang}dir = \$(datadir)/genius/help/${lang}/html
manualhtml${lang}_DATA = $LANGHTMLS
manualhtml${lang}figuresdir = \$(datadir)/genius/help/${lang}/html/figures
manualhtml${lang}figures_DATA = \$(THE_${lang}FIGURES)


EOF
done

EXTRAFILES=`echo make-makefile-am.sh update-po.sh update-xml-to-txt-html.sh genius.txt $EXTRAFILES | sed 's/ / \\\\\n  /g'`
cat >> Makefile.am <<EOF

#########################################################
# Text version of the manual

manualdir = \$(datadir)/genius
manual_DATA = genius.txt

#########################################################
# Aaaaand here's all the files ...


EXTRA_DIST = $EXTRAFILES
EOF

echo done
