/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.jni;

import geotrans3.exception.CoordinateConversionException;
import geotrans3.jni.JNIDatumLibrary;
import geotrans3.jni.JNIEllipsoidLibrary;
import geotrans3.misc.Info;
import geotrans3.misc.StringHandler;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class FillList {
    private JNIDatumLibrary datumLibrary;
    private JNIEllipsoidLibrary ellipsoidLibrary;
    private StringHandler stringHandler;
    private long datumCount;

    public FillList(JNIDatumLibrary jNIDatumLibrary, JNIEllipsoidLibrary jNIEllipsoidLibrary, JComboBox jComboBox, int n) {
        this.datumLibrary = jNIDatumLibrary;
        this.ellipsoidLibrary = jNIEllipsoidLibrary;
        this.stringHandler = new StringHandler();
        this.datumCount = 0L;
        if (n == 0) {
            this.fillDatumList(jComboBox);
        } else {
            this.fillEllipsoidList(jComboBox);
        }
    }

    private void fillDatumList(JComboBox jComboBox) {
        try {
            jComboBox.setModel(new DefaultComboBoxModel());
            String string = "";
            String string2 = "";
            this.datumCount = this.datumLibrary.getDatumCount();
            int n = 0;
            while ((long)n < this.datumCount) {
                Info info = this.datumLibrary.getDatumInfo(n);
                jComboBox.addItem(info.getCode() + ":  " + info.getName());
                ++n;
            }
            jComboBox.setSelectedIndex((int)this.datumLibrary.getDatumIndex("WGE"));
        }
        catch (Exception exception) {
            this.stringHandler.displayErrorMsg(new JFrame(), exception.getMessage());
        }
    }

    private void fillEllipsoidList(JComboBox jComboBox) {
        try {
            String string = "";
            String string2 = "";
            long l = this.ellipsoidLibrary.getEllipsoidCount();
            int n = 0;
            while ((long)n < l) {
                Info info = this.ellipsoidLibrary.getEllipsoidInfo(n);
                jComboBox.addItem(info.getCode() + ":  " + info.getName());
                ++n;
            }
            jComboBox.setSelectedIndex((int)this.ellipsoidLibrary.getEllipsoidIndex("WE"));
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(new JFrame(), coordinateConversionException.getMessage());
        }
    }

    public void addDatum(JComboBox jComboBox) {
        try {
            long l = this.datumLibrary.getDatumCount();
            int n = (int)l - 1;
            Info info = this.datumLibrary.getDatumInfo(n);
            jComboBox.insertItemAt(info.getCode() + ":  " + info.getName(), n);
            ++this.datumCount;
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(new JFrame(), coordinateConversionException.getMessage());
        }
    }

    public void deleteDatum(JComboBox jComboBox, int n) {
        try {
            long l = this.datumLibrary.getDatumCount();
            if (this.datumCount > l) {
                jComboBox.removeItemAt(n);
                --this.datumCount;
            }
        }
        catch (CoordinateConversionException coordinateConversionException) {
            this.stringHandler.displayErrorMsg(new JFrame(), coordinateConversionException.getMessage());
        }
    }
}

