// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/securityposture/v1/sha_constraints.proto

package securityposturepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible enablement states of a service or module.
type EnablementState int32

const (
	// Default value. This value is unused.
	EnablementState_ENABLEMENT_STATE_UNSPECIFIED EnablementState = 0
	// State is enabled.
	EnablementState_ENABLED EnablementState = 1
	// State is disabled.
	EnablementState_DISABLED EnablementState = 2
)

// Enum value maps for EnablementState.
var (
	EnablementState_name = map[int32]string{
		0: "ENABLEMENT_STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
	}
	EnablementState_value = map[string]int32{
		"ENABLEMENT_STATE_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"DISABLED":                     2,
	}
)

func (x EnablementState) Enum() *EnablementState {
	p := new(EnablementState)
	*p = x
	return p
}

func (x EnablementState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnablementState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securityposture_v1_sha_constraints_proto_enumTypes[0].Descriptor()
}

func (EnablementState) Type() protoreflect.EnumType {
	return &file_google_cloud_securityposture_v1_sha_constraints_proto_enumTypes[0]
}

func (x EnablementState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EnablementState.Descriptor instead.
func (EnablementState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescGZIP(), []int{0}
}

// Message for Security Health Analytics built-in detector.
type SecurityHealthAnalyticsModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the module eg: BIGQUERY_TABLE_CMEK_DISABLED.
	ModuleName string `protobuf:"bytes,1,opt,name=module_name,json=moduleName,proto3" json:"module_name,omitempty"`
	// The state of enablement for the module at its level of the resource
	// hierarchy.
	ModuleEnablementState EnablementState `protobuf:"varint,2,opt,name=module_enablement_state,json=moduleEnablementState,proto3,enum=google.cloud.securityposture.v1.EnablementState" json:"module_enablement_state,omitempty"`
}

func (x *SecurityHealthAnalyticsModule) Reset() {
	*x = SecurityHealthAnalyticsModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityHealthAnalyticsModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityHealthAnalyticsModule) ProtoMessage() {}

func (x *SecurityHealthAnalyticsModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityHealthAnalyticsModule.ProtoReflect.Descriptor instead.
func (*SecurityHealthAnalyticsModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescGZIP(), []int{0}
}

func (x *SecurityHealthAnalyticsModule) GetModuleName() string {
	if x != nil {
		return x.ModuleName
	}
	return ""
}

func (x *SecurityHealthAnalyticsModule) GetModuleEnablementState() EnablementState {
	if x != nil {
		return x.ModuleEnablementState
	}
	return EnablementState_ENABLEMENT_STATE_UNSPECIFIED
}

// Message for SHA Custom Module
type SecurityHealthAnalyticsCustomModule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. The id of the custom module.
	// The id is server-generated and is not user settable.
	// It will be a numeric id containing 1-20 digits.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. The display name of the Security Health Analytics custom module.
	// This display name becomes the finding category for all findings that are
	// returned by this custom module. The display name must be between 1 and
	// 128 characters, start with a lowercase letter, and contain alphanumeric
	// characters or underscores only.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. custom module details
	Config *CustomConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// The state of enablement for the module at its level of the resource
	// hierarchy.
	ModuleEnablementState EnablementState `protobuf:"varint,4,opt,name=module_enablement_state,json=moduleEnablementState,proto3,enum=google.cloud.securityposture.v1.EnablementState" json:"module_enablement_state,omitempty"`
}

func (x *SecurityHealthAnalyticsCustomModule) Reset() {
	*x = SecurityHealthAnalyticsCustomModule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecurityHealthAnalyticsCustomModule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecurityHealthAnalyticsCustomModule) ProtoMessage() {}

func (x *SecurityHealthAnalyticsCustomModule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecurityHealthAnalyticsCustomModule.ProtoReflect.Descriptor instead.
func (*SecurityHealthAnalyticsCustomModule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescGZIP(), []int{1}
}

func (x *SecurityHealthAnalyticsCustomModule) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *SecurityHealthAnalyticsCustomModule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *SecurityHealthAnalyticsCustomModule) GetConfig() *CustomConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *SecurityHealthAnalyticsCustomModule) GetModuleEnablementState() EnablementState {
	if x != nil {
		return x.ModuleEnablementState
	}
	return EnablementState_ENABLEMENT_STATE_UNSPECIFIED
}

var File_google_cloud_securityposture_v1_sha_constraints_proto protoreflect.FileDescriptor

var file_google_cloud_securityposture_v1_sha_constraints_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x68, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x68, 0x61, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xaf, 0x01, 0x0a, 0x1d, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x68, 0x0a, 0x17, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x15, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x22, 0x9b, 0x02, 0x0a, 0x23, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a, 0x17, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x15, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x2a, 0x4e, 0x0a, 0x0f, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x4d,
	0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c,
	0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x42, 0x8b, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x53, 0x68, 0x61, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x70, 0x62, 0x3b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescOnce sync.Once
	file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescData = file_google_cloud_securityposture_v1_sha_constraints_proto_rawDesc
)

func file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescGZIP() []byte {
	file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescOnce.Do(func() {
		file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescData)
	})
	return file_google_cloud_securityposture_v1_sha_constraints_proto_rawDescData
}

var file_google_cloud_securityposture_v1_sha_constraints_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_securityposture_v1_sha_constraints_proto_goTypes = []interface{}{
	(EnablementState)(0),                        // 0: google.cloud.securityposture.v1.EnablementState
	(*SecurityHealthAnalyticsModule)(nil),       // 1: google.cloud.securityposture.v1.SecurityHealthAnalyticsModule
	(*SecurityHealthAnalyticsCustomModule)(nil), // 2: google.cloud.securityposture.v1.SecurityHealthAnalyticsCustomModule
	(*CustomConfig)(nil),                        // 3: google.cloud.securityposture.v1.CustomConfig
}
var file_google_cloud_securityposture_v1_sha_constraints_proto_depIdxs = []int32{
	0, // 0: google.cloud.securityposture.v1.SecurityHealthAnalyticsModule.module_enablement_state:type_name -> google.cloud.securityposture.v1.EnablementState
	3, // 1: google.cloud.securityposture.v1.SecurityHealthAnalyticsCustomModule.config:type_name -> google.cloud.securityposture.v1.CustomConfig
	0, // 2: google.cloud.securityposture.v1.SecurityHealthAnalyticsCustomModule.module_enablement_state:type_name -> google.cloud.securityposture.v1.EnablementState
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_securityposture_v1_sha_constraints_proto_init() }
func file_google_cloud_securityposture_v1_sha_constraints_proto_init() {
	if File_google_cloud_securityposture_v1_sha_constraints_proto != nil {
		return
	}
	file_google_cloud_securityposture_v1_sha_custom_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityHealthAnalyticsModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecurityHealthAnalyticsCustomModule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securityposture_v1_sha_constraints_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securityposture_v1_sha_constraints_proto_goTypes,
		DependencyIndexes: file_google_cloud_securityposture_v1_sha_constraints_proto_depIdxs,
		EnumInfos:         file_google_cloud_securityposture_v1_sha_constraints_proto_enumTypes,
		MessageInfos:      file_google_cloud_securityposture_v1_sha_constraints_proto_msgTypes,
	}.Build()
	File_google_cloud_securityposture_v1_sha_constraints_proto = out.File
	file_google_cloud_securityposture_v1_sha_constraints_proto_rawDesc = nil
	file_google_cloud_securityposture_v1_sha_constraints_proto_goTypes = nil
	file_google_cloud_securityposture_v1_sha_constraints_proto_depIdxs = nil
}
