//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappservice

import "time"

// APIDefinitionInfo - Information about the formal API definition for the app.
type APIDefinitionInfo struct {
	// The URL of the API definition.
	URL *string `json:"url,omitempty"`
}

// APIKVReference - Description of site key vault references.
type APIKVReference struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ApiKVReference resource specific properties
	Properties *APIKVReferenceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type APIKVReferenceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*APIKVReference `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// APIKVReferenceProperties - ApiKVReference resource specific properties
type APIKVReferenceProperties struct {
	ActiveVersion *string `json:"activeVersion,omitempty"`
	Details       *string `json:"details,omitempty"`

	// Managed service identity.
	IdentityType  *ManagedServiceIdentity `json:"identityType,omitempty"`
	Reference     *string                 `json:"reference,omitempty"`
	SecretName    *string                 `json:"secretName,omitempty"`
	SecretVersion *string                 `json:"secretVersion,omitempty"`
	Source        *string                 `json:"source,omitempty"`
	Status        *ResolveStatus          `json:"status,omitempty"`
	VaultName     *string                 `json:"vaultName,omitempty"`
}

// APIManagementConfig - Azure API management (APIM) configuration linked to the app.
type APIManagementConfig struct {
	// APIM-Api Identifier.
	ID *string `json:"id,omitempty"`
}

// AbnormalTimePeriod - Class representing Abnormal Time Period identified in diagnosis
type AbnormalTimePeriod struct {
	// End time of the downtime
	EndTime *time.Time `json:"endTime,omitempty"`

	// List of Possible Cause of downtime
	Events []*DetectorAbnormalTimePeriod `json:"events,omitempty"`

	// List of proposed solutions
	Solutions []*Solution `json:"solutions,omitempty"`

	// Start time of the downtime
	StartTime *time.Time `json:"startTime,omitempty"`
}

// Address information for domain registration.
type Address struct {
	// REQUIRED; First line of an Address.
	Address1 *string `json:"address1,omitempty"`

	// REQUIRED; The city for the address.
	City *string `json:"city,omitempty"`

	// REQUIRED; The country for the address.
	Country *string `json:"country,omitempty"`

	// REQUIRED; The postal code for the address.
	PostalCode *string `json:"postalCode,omitempty"`

	// REQUIRED; The state or province for the address.
	State *string `json:"state,omitempty"`

	// The second line of the Address. Optional.
	Address2 *string `json:"address2,omitempty"`
}

// AddressResponse - Describes main public IP address and any extra virtual IPs.
type AddressResponse struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AddressResponse resource specific properties
	Properties *AddressResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AddressResponseProperties - AddressResponse resource specific properties
type AddressResponseProperties struct {
	// Virtual Network internal IP address of the App Service Environment if it is in internal load-balancing mode.
	InternalIPAddress *string `json:"internalIpAddress,omitempty"`

	// IP addresses appearing on outbound connections.
	OutboundIPAddresses []*string `json:"outboundIpAddresses,omitempty"`

	// Main public virtual IP.
	ServiceIPAddress *string `json:"serviceIpAddress,omitempty"`

	// Additional virtual IPs.
	VipMappings []*VirtualIPMapping `json:"vipMappings,omitempty"`
}

// AllowedAudiencesValidation - The configuration settings of the Allowed Audiences validation flow.
type AllowedAudiencesValidation struct {
	// The configuration settings of the allowed list of audiences from which to validate the JWT token.
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`
}

// AllowedPrincipals - The configuration settings of the Azure Active Directory allowed principals.
type AllowedPrincipals struct {
	// The list of the allowed groups.
	Groups []*string `json:"groups,omitempty"`

	// The list of the allowed identities.
	Identities []*string `json:"identities,omitempty"`
}

// AnalysisData - Class Representing Detector Evidence used for analysis
type AnalysisData struct {
	// Additional Source Data
	Data [][]*NameValuePair `json:"data,omitempty"`

	// Detector Definition
	DetectorDefinition *DetectorDefinition `json:"detectorDefinition,omitempty"`

	// Detector Meta Data
	DetectorMetaData *ResponseMetaData `json:"detectorMetaData,omitempty"`

	// Source Metrics
	Metrics []*DiagnosticMetricSet `json:"metrics,omitempty"`

	// Name of the Detector
	Source *string `json:"source,omitempty"`
}

// AnalysisDefinition - Definition of Analysis
type AnalysisDefinition struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AnalysisDefinition resource specific properties
	Properties *AnalysisDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AnalysisDefinitionProperties - AnalysisDefinition resource specific properties
type AnalysisDefinitionProperties struct {
	// READ-ONLY; Description of the Analysis
	Description *string `json:"description,omitempty" azure:"ro"`
}

// AppCertificate - SSL certificate for an app.
type AppCertificate struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Certificate resource specific properties
	Properties *AppCertificateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AppCertificateCollection - Collection of certificates.
type AppCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AppCertificate `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AppCertificatePatchResource - ARM resource for a certificate.
type AppCertificatePatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CertificatePatchResource resource specific properties
	Properties *AppCertificatePatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AppCertificatePatchResourceProperties - CertificatePatchResource resource specific properties
type AppCertificatePatchResourceProperties struct {
	// CNAME of the certificate to be issued via free certificate
	CanonicalName *string `json:"canonicalName,omitempty"`

	// Method of domain validation for free cert
	DomainValidationMethod *string `json:"domainValidationMethod,omitempty"`

	// Host names the certificate applies to.
	HostNames []*string `json:"hostNames,omitempty"`

	// Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`

	// Certificate password.
	Password *string `json:"password,omitempty"`

	// Pfx blob.
	PfxBlob []byte `json:"pfxBlob,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// READ-ONLY; Raw bytes of .cer file
	CerBlob []byte `json:"cerBlob,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time `json:"issueDate,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Key Vault secret.
	KeyVaultSecretStatus *KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty" azure:"ro"`

	// READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty" azure:"ro"`

	// READ-ONLY; Self link.
	SelfLink *string `json:"selfLink,omitempty" azure:"ro"`

	// READ-ONLY; App name.
	SiteName *string `json:"siteName,omitempty" azure:"ro"`

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty" azure:"ro"`
}

// AppCertificateProperties - Certificate resource specific properties
type AppCertificateProperties struct {
	// CNAME of the certificate to be issued via free certificate
	CanonicalName *string `json:"canonicalName,omitempty"`

	// Method of domain validation for free cert
	DomainValidationMethod *string `json:"domainValidationMethod,omitempty"`

	// Host names the certificate applies to.
	HostNames []*string `json:"hostNames,omitempty"`

	// Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`

	// Certificate password.
	Password *string `json:"password,omitempty"`

	// Pfx blob.
	PfxBlob []byte `json:"pfxBlob,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// READ-ONLY; Raw bytes of .cer file
	CerBlob []byte `json:"cerBlob,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty" azure:"ro"`

	// READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time `json:"issueDate,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Key Vault secret.
	KeyVaultSecretStatus *KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty" azure:"ro"`

	// READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty" azure:"ro"`

	// READ-ONLY; Self link.
	SelfLink *string `json:"selfLink,omitempty" azure:"ro"`

	// READ-ONLY; App name.
	SiteName *string `json:"siteName,omitempty" azure:"ro"`

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty" azure:"ro"`
}

// AppInsightsWebAppStackSettings - App Insights Web App stack settings.
type AppInsightsWebAppStackSettings struct {
	// READ-ONLY; true if Application Insights is disabled by default for the stack; otherwise, false.
	IsDefaultOff *bool `json:"isDefaultOff,omitempty" azure:"ro"`

	// READ-ONLY; true if remote Application Insights is supported for the stack; otherwise, false.
	IsSupported *bool `json:"isSupported,omitempty" azure:"ro"`
}

type AppLogsConfiguration struct {
	Destination               *string                    `json:"destination,omitempty"`
	LogAnalyticsConfiguration *LogAnalyticsConfiguration `json:"logAnalyticsConfiguration,omitempty"`
}

// AppRegistration - The configuration settings of the app registration for providers that have app ids and app secrets
type AppRegistration struct {
	// The App ID of the app used for login.
	AppID *string `json:"appId,omitempty"`

	// The app setting name that contains the app secret.
	AppSecretSettingName *string `json:"appSecretSettingName,omitempty"`
}

// Apple - The configuration settings of the Apple provider.
type Apple struct {
	// false if the Apple provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the Apple registration.
	Registration *AppleRegistration `json:"registration,omitempty"`
}

// AppleRegistration - The configuration settings of the registration for the Apple provider
type AppleRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string `json:"clientId,omitempty"`

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`
}

// ApplicationLogsConfig - Application logs configuration.
type ApplicationLogsConfig struct {
	// Application logs to blob storage configuration.
	AzureBlobStorage *AzureBlobStorageApplicationLogsConfig `json:"azureBlobStorage,omitempty"`

	// Application logs to azure table storage configuration.
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`

	// Application logs to file system configuration.
	FileSystem *FileSystemApplicationLogsConfig `json:"fileSystem,omitempty"`
}

// ApplicationStack - Application stack.
type ApplicationStack struct {
	// Application stack dependency.
	Dependency *string `json:"dependency,omitempty"`

	// Application stack display name.
	Display *string `json:"display,omitempty"`

	// List of frameworks associated with application stack.
	Frameworks []*ApplicationStack `json:"frameworks,omitempty"`

	// true if this is the stack is deprecated; otherwise, false.
	IsDeprecated []*ApplicationStack `json:"isDeprecated,omitempty"`

	// List of major versions available.
	MajorVersions []*StackMajorVersion `json:"majorVersions,omitempty"`

	// Application stack name.
	Name *string `json:"name,omitempty"`
}

// ApplicationStackCollection - Collection of Application Stacks
type ApplicationStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ApplicationStackResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ApplicationStackResource - ARM resource for a ApplicationStack.
type ApplicationStackResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *ApplicationStack `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ArcConfiguration struct {
	ArtifactStorageAccessMode    *string                `json:"artifactStorageAccessMode,omitempty"`
	ArtifactStorageClassName     *string                `json:"artifactStorageClassName,omitempty"`
	ArtifactStorageMountPath     *string                `json:"artifactStorageMountPath,omitempty"`
	ArtifactStorageNodeName      *string                `json:"artifactStorageNodeName,omitempty"`
	ArtifactsStorageType         *StorageType           `json:"artifactsStorageType,omitempty"`
	FrontEndServiceConfiguration *FrontEndConfiguration `json:"frontEndServiceConfiguration,omitempty"`
	KubeConfig                   *string                `json:"kubeConfig,omitempty"`
}

// ArmIDWrapper - A wrapper for an ARM resource id
type ArmIDWrapper struct {
	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`
}

// ArmPlan - The plan object in Azure Resource Manager, represents a marketplace plan.
type ArmPlan struct {
	// The name.
	Name *string `json:"name,omitempty"`

	// The product.
	Product *string `json:"product,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Version of product.
	Version *string `json:"version,omitempty"`
}

// AseV3NetworkingConfiguration - Full view of networking configuration for an ASE.
type AseV3NetworkingConfiguration struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AseV3NetworkingConfiguration resource specific properties
	Properties *AseV3NetworkingConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AseV3NetworkingConfigurationProperties - AseV3NetworkingConfiguration resource specific properties
type AseV3NetworkingConfigurationProperties struct {
	// Property to enable and disable new private endpoint connection creation on ASE
	AllowNewPrivateEndpointConnections *bool `json:"allowNewPrivateEndpointConnections,omitempty"`

	// Property to enable and disable FTP on ASEV3
	FtpEnabled *bool `json:"ftpEnabled,omitempty"`

	// Customer provided Inbound IP Address. Only able to be set on Ase create.
	InboundIPAddressOverride *string `json:"inboundIpAddressOverride,omitempty"`

	// Property to enable and disable Remote Debug on ASEV3
	RemoteDebugEnabled *bool `json:"remoteDebugEnabled,omitempty"`

	// READ-ONLY
	ExternalInboundIPAddresses []*string `json:"externalInboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY
	InternalInboundIPAddresses []*string `json:"internalInboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY
	LinuxOutboundIPAddresses []*string `json:"linuxOutboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY
	WindowsOutboundIPAddresses []*string `json:"windowsOutboundIpAddresses,omitempty" azure:"ro"`
}

// AuthPlatform - The configuration settings of the platform of App Service Authentication/Authorization.
type AuthPlatform struct {
	// The path of the config file containing auth settings if they come from a file. If the path is relative, base will the site's
	// root directory.
	ConfigFilePath *string `json:"configFilePath,omitempty"`

	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool `json:"enabled,omitempty"`

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// AutoHealActions - Actions which to take by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	// Predefined action to be taken.
	ActionType *AutoHealActionType `json:"actionType,omitempty"`

	// Custom action to be taken.
	CustomAction *AutoHealCustomAction `json:"customAction,omitempty"`

	// Minimum time the process must execute before taking the action
	MinProcessExecutionTime *string `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction - Custom action to be executed when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	// Executable to be run.
	Exe *string `json:"exe,omitempty"`

	// Parameters for the executable.
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules - Rules that can be defined for auto-heal.
type AutoHealRules struct {
	// Actions to be executed when a rule is triggered.
	Actions *AutoHealActions `json:"actions,omitempty"`

	// Conditions that describe when to execute the auto-heal actions.
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
}

// AutoHealTriggers - Triggers for auto-heal.
type AutoHealTriggers struct {
	// A rule based on private bytes.
	PrivateBytesInKB *int32 `json:"privateBytesInKB,omitempty"`

	// A rule based on total requests.
	Requests *RequestsBasedTrigger `json:"requests,omitempty"`

	// A rule based on request execution time.
	SlowRequests *SlowRequestsBasedTrigger `json:"slowRequests,omitempty"`

	// A rule based on multiple Slow Requests Rule with path
	SlowRequestsWithPath []*SlowRequestsBasedTrigger `json:"slowRequestsWithPath,omitempty"`

	// A rule based on status codes.
	StatusCodes []*StatusCodesBasedTrigger `json:"statusCodes,omitempty"`

	// A rule based on status codes ranges.
	StatusCodesRange []*StatusCodesRangeBasedTrigger `json:"statusCodesRange,omitempty"`
}

// AzureActiveDirectory - The configuration settings of the Azure Active directory provider.
type AzureActiveDirectory struct {
	// false if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling. This is an internal
	// flag primarily intended to support the Azure Management Portal. Users
	// should not read or write to this property.
	IsAutoProvisioned *bool `json:"isAutoProvisioned,omitempty"`

	// The configuration settings of the Azure Active Directory login flow.
	Login *AzureActiveDirectoryLogin `json:"login,omitempty"`

	// The configuration settings of the Azure Active Directory app registration.
	Registration *AzureActiveDirectoryRegistration `json:"registration,omitempty"`

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AzureActiveDirectoryValidation `json:"validation,omitempty"`
}

// AzureActiveDirectoryLogin - The configuration settings of the Azure Active Directory login flow.
type AzureActiveDirectoryLogin struct {
	// true if the www-authenticate provider should be omitted from the request; otherwise, false.
	DisableWWWAuthenticate *bool `json:"disableWWWAuthenticate,omitempty"`

	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	LoginParameters []*string `json:"loginParameters,omitempty"`
}

// AzureActiveDirectoryRegistration - The configuration settings of the Azure Active Directory app registration.
type AzureActiveDirectoryRegistration struct {
	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string `json:"clientId,omitempty"`

	// An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property
	// acts as a replacement for the Client Secret Certificate Thumbprint. It is
	// also optional.
	ClientSecretCertificateIssuer *string `json:"clientSecretCertificateIssuer,omitempty"`

	// An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing
	// purposes. This property acts as a replacement for the Client Secret Certificate
	// Thumbprint. It is also optional.
	ClientSecretCertificateSubjectAlternativeName *string `json:"clientSecretCertificateSubjectAlternativeName,omitempty"`

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string `json:"clientSecretCertificateThumbprint,omitempty"`

	// The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://login.microsoftonline.com/v2.0/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More
	// information on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	OpenIDIssuer *string `json:"openIdIssuer,omitempty"`
}

// AzureActiveDirectoryValidation - The configuration settings of the Azure Active Directory token validation flow.
type AzureActiveDirectoryValidation struct {
	// The list of audiences that can make successful authentication/authorization requests.
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`

	// The configuration settings of the default authorization policy.
	DefaultAuthorizationPolicy *DefaultAuthorizationPolicy `json:"defaultAuthorizationPolicy,omitempty"`

	// The configuration settings of the checks that should be made while validating the JWT Claims.
	JwtClaimChecks *JwtClaimChecks `json:"jwtClaimChecks,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig - Application logs azure blob storage configuration.
type AzureBlobStorageApplicationLogsConfig struct {
	// Log level.
	Level *LogLevel `json:"level,omitempty"`

	// Retention in days. Remove blobs older than X days. 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig - Http logs to azure blob storage configuration.
type AzureBlobStorageHTTPLogsConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`

	// Retention in days. Remove blobs older than X days. 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
}

// AzureResourceErrorInfo - The azure resource error info.
type AzureResourceErrorInfo struct {
	// REQUIRED; The error code.
	Code *string `json:"code,omitempty"`

	// REQUIRED; The error message.
	Message *string `json:"message,omitempty"`

	// The error details.
	Details []*AzureResourceErrorInfo `json:"details,omitempty"`
}

// AzureStaticWebApps - The configuration settings of the Azure Static Web Apps provider.
type AzureStaticWebApps struct {
	// false if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the Azure Static Web Apps registration.
	Registration *AzureStaticWebAppsRegistration `json:"registration,omitempty"`
}

// AzureStaticWebAppsRegistration - The configuration settings of the registration for the Azure Static Web Apps provider
type AzureStaticWebAppsRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string `json:"clientId,omitempty"`
}

// AzureStorageInfoValue - Azure Files or Blob Storage access information value for dictionary storage.
type AzureStorageInfoValue struct {
	// Access key for the storage account.
	AccessKey *string `json:"accessKey,omitempty"`

	// Name of the storage account.
	AccountName *string `json:"accountName,omitempty"`

	// Path to mount the storage within the site's runtime environment.
	MountPath *string `json:"mountPath,omitempty"`

	// Name of the file share (container name, for Blob storage).
	ShareName *string `json:"shareName,omitempty"`

	// Type of storage.
	Type *AzureStorageType `json:"type,omitempty"`

	// READ-ONLY; State of the storage account.
	State *AzureStorageState `json:"state,omitempty" azure:"ro"`
}

// AzureStoragePropertyDictionaryResource - AzureStorageInfo dictionary resource.
type AzureStoragePropertyDictionaryResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Azure storage accounts.
	Properties map[string]*AzureStorageInfoValue `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AzureTableStorageApplicationLogsConfig - Application logs to Azure table storage configuration.
type AzureTableStorageApplicationLogsConfig struct {
	// REQUIRED; SAS URL to an Azure table with add/query/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`

	// Log level.
	Level *LogLevel `json:"level,omitempty"`
}

// BackupItem - Backup description.
type BackupItem struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// BackupItem resource specific properties
	Properties *BackupItemProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupItemCollection - Collection of backup items.
type BackupItemCollection struct {
	// REQUIRED; Collection of resources.
	Value []*BackupItem `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// BackupItemProperties - BackupItem resource specific properties
type BackupItemProperties struct {
	// READ-ONLY; Id of the backup.
	BackupID *int32 `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the blob which contains data for this backup.
	BlobName *string `json:"blobName,omitempty" azure:"ro"`

	// READ-ONLY; Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of the backup creation.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; List of databases included in the backup.
	Databases []*DatabaseBackupSetting `json:"databases,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when this backup finished.
	FinishedTimeStamp *time.Time `json:"finishedTimeStamp,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of a last restore operation which used this backup.
	LastRestoreTimeStamp *time.Time `json:"lastRestoreTimeStamp,omitempty" azure:"ro"`

	// READ-ONLY; Details regarding this backup. Might contain an error message.
	Log *string `json:"log,omitempty" azure:"ro"`

	// READ-ONLY; Name of this backup.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; True if this backup has been created due to a schedule being triggered.
	Scheduled *bool `json:"scheduled,omitempty" azure:"ro"`

	// READ-ONLY; Size of the backup in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty" azure:"ro"`

	// READ-ONLY; Backup status.
	Status *BackupItemStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; SAS URL for the storage account container which contains this backup.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty" azure:"ro"`

	// READ-ONLY; Size of the original web app which has been backed up.
	WebsiteSizeInBytes *int64 `json:"websiteSizeInBytes,omitempty" azure:"ro"`
}

// BackupRequest - Description of a backup which will be performed.
type BackupRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// BackupRequest resource specific properties
	Properties *BackupRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BackupRequestProperties - BackupRequest resource specific properties
type BackupRequestProperties struct {
	// REQUIRED; SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`

	// Name of the backup.
	BackupName *string `json:"backupName,omitempty"`

	// Schedule for the backup if it is executed periodically.
	BackupSchedule *BackupSchedule `json:"backupSchedule,omitempty"`

	// Databases included in the backup.
	Databases []*DatabaseBackupSetting `json:"databases,omitempty"`

	// True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// BackupSchedule - Description of a backup schedule. Describes how often should be the backup performed and what should be
// the retention policy.
type BackupSchedule struct {
	// REQUIRED; How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should
	// be set to Day)
	FrequencyInterval *int32 `json:"frequencyInterval,omitempty"`

	// REQUIRED; The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day
	// and FrequencyInterval should be set to 7)
	FrequencyUnit *FrequencyUnit `json:"frequencyUnit,omitempty"`

	// REQUIRED; True if the retention policy should always keep at least one backup in the storage account, regardless how old
	// it is; false otherwise.
	KeepAtLeastOneBackup *bool `json:"keepAtLeastOneBackup,omitempty"`

	// REQUIRED; After how many days backups should be deleted.
	RetentionPeriodInDays *int32 `json:"retentionPeriodInDays,omitempty"`

	// When the schedule should start working.
	StartTime *time.Time `json:"startTime,omitempty"`

	// READ-ONLY; Last time when this schedule was triggered.
	LastExecutionTime *time.Time `json:"lastExecutionTime,omitempty" azure:"ro"`
}

// BillingMeter - App Service billing entity that contains information about meter which the Azure billing system utilizes
// to charge users for services.
type BillingMeter struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// BillingMeter resource specific properties
	Properties *BillingMeterProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BillingMeterCollection - Collection of Billing Meters
type BillingMeterCollection struct {
	// REQUIRED; Collection of resources.
	Value []*BillingMeter `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// BillingMeterProperties - BillingMeter resource specific properties
type BillingMeterProperties struct {
	// Azure Location of billable resource
	BillingLocation *string `json:"billingLocation,omitempty"`

	// Friendly name of the meter
	FriendlyName *string `json:"friendlyName,omitempty"`

	// Meter GUID onboarded in Commerce
	MeterID *string `json:"meterId,omitempty"`

	// Meter Multiplier
	Multiplier *float64 `json:"multiplier,omitempty"`

	// App Service OS type meter used for
	OSType *string `json:"osType,omitempty"`

	// App Service ResourceType meter used for
	ResourceType *string `json:"resourceType,omitempty"`

	// Short Name from App Service Azure pricing Page
	ShortName *string `json:"shortName,omitempty"`
}

// BlobStorageTokenStore - The configuration settings of the storage of the tokens if blob storage is used.
type BlobStorageTokenStore struct {
	// The name of the app setting containing the SAS URL of the blob storage containing the tokens.
	SasURLSettingName *string `json:"sasUrlSettingName,omitempty"`
}

// Capability - Describes the capabilities/features allowed for a specific SKU.
type Capability struct {
	// Name of the SKU capability.
	Name *string `json:"name,omitempty"`

	// Reason of the SKU capability.
	Reason *string `json:"reason,omitempty"`

	// Value of the SKU capability.
	Value *string `json:"value,omitempty"`
}

// Certificate - Key Vault container for a certificate that is purchased through Azure.
type Certificate struct {
	// Key Vault resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`

	// Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`

	// READ-ONLY; Status of the Key Vault secret.
	ProvisioningState *KeyVaultSecretStatus `json:"provisioningState,omitempty" azure:"ro"`
}

// CertificateCollection - Collection of certificate order certificates.
type CertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CertificateResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CertificateDetails - SSL certificate details.
type CertificateDetails struct {
	// READ-ONLY; Certificate Issuer.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Date Certificate is valid to.
	NotAfter *time.Time `json:"notAfter,omitempty" azure:"ro"`

	// READ-ONLY; Date Certificate is valid from.
	NotBefore *time.Time `json:"notBefore,omitempty" azure:"ro"`

	// READ-ONLY; Raw certificate data.
	RawData *string `json:"rawData,omitempty" azure:"ro"`

	// READ-ONLY; Certificate Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Certificate Signature algorithm.
	SignatureAlgorithm *string `json:"signatureAlgorithm,omitempty" azure:"ro"`

	// READ-ONLY; Certificate Subject.
	Subject *string `json:"subject,omitempty" azure:"ro"`

	// READ-ONLY; Certificate Thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Certificate Version.
	Version *int32 `json:"version,omitempty" azure:"ro"`
}

// CertificateEmail - SSL certificate email.
type CertificateEmail struct {
	// Email id.
	EmailID *string `json:"emailId,omitempty"`

	// Time stamp.
	TimeStamp *time.Time `json:"timeStamp,omitempty"`
}

// CertificateOrder - SSL certificate purchase order.
type CertificateOrder struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AppServiceCertificateOrder resource specific properties
	Properties *CertificateOrderProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateOrderAction - Certificate order action.
type CertificateOrderAction struct {
	// READ-ONLY; Action type.
	ActionType *CertificateOrderActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Time at which the certificate action was performed.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`
}

// CertificateOrderCollection - Collection of certificate orders.
type CertificateOrderCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CertificateOrder `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

type CertificateOrderContact struct {
	Email     *string `json:"email,omitempty"`
	NameFirst *string `json:"nameFirst,omitempty"`
	NameLast  *string `json:"nameLast,omitempty"`
	Phone     *string `json:"phone,omitempty"`
}

// CertificateOrderPatchResource - ARM resource for a certificate order that is purchased through Azure.
type CertificateOrderPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AppServiceCertificateOrderPatchResource resource specific properties
	Properties *CertificateOrderPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateOrderPatchResourceProperties - AppServiceCertificateOrderPatchResource resource specific properties
type CertificateOrderPatchResourceProperties struct {
	// REQUIRED; Certificate product type.
	ProductType *CertificateProductType `json:"productType,omitempty"`

	// true if the certificate should be automatically renewed when it expires; otherwise, false.
	AutoRenew *bool `json:"autoRenew,omitempty"`

	// State of the Key Vault secret.
	Certificates map[string]*Certificate `json:"certificates,omitempty"`

	// Last CSR that was created for this order.
	Csr *string `json:"csr,omitempty"`

	// Certificate distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`

	// Certificate key size.
	KeySize *int32 `json:"keySize,omitempty"`

	// Duration in years (must be 1).
	ValidityInYears *int32 `json:"validityInYears,omitempty"`

	// READ-ONLY; Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons []*ResourceNotRenewableReason `json:"appServiceCertificateNotRenewableReasons,omitempty" azure:"ro"`

	// READ-ONLY; Contact info
	Contact *CertificateOrderContact `json:"contact,omitempty" azure:"ro"`

	// READ-ONLY; Domain verification token.
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration time.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`

	// READ-ONLY; Intermediate certificate.
	Intermediate *CertificateDetails `json:"intermediate,omitempty" azure:"ro"`

	// READ-ONLY; true if private key is external; otherwise, false.
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty" azure:"ro"`

	// READ-ONLY; Certificate last issuance time.
	LastCertificateIssuanceTime *time.Time `json:"lastCertificateIssuanceTime,omitempty" azure:"ro"`

	// READ-ONLY; Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *time.Time `json:"nextAutoRenewalTimeStamp,omitempty" azure:"ro"`

	// READ-ONLY; Status of certificate order.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Root certificate.
	Root *CertificateDetails `json:"root,omitempty" azure:"ro"`

	// READ-ONLY; Current serial number of the certificate.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Signed certificate.
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty" azure:"ro"`

	// READ-ONLY; Current order status.
	Status *CertificateOrderStatus `json:"status,omitempty" azure:"ro"`
}

// CertificateOrderProperties - AppServiceCertificateOrder resource specific properties
type CertificateOrderProperties struct {
	// REQUIRED; Certificate product type.
	ProductType *CertificateProductType `json:"productType,omitempty"`

	// true if the certificate should be automatically renewed when it expires; otherwise, false.
	AutoRenew *bool `json:"autoRenew,omitempty"`

	// State of the Key Vault secret.
	Certificates map[string]*Certificate `json:"certificates,omitempty"`

	// Last CSR that was created for this order.
	Csr *string `json:"csr,omitempty"`

	// Certificate distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`

	// Certificate key size.
	KeySize *int32 `json:"keySize,omitempty"`

	// Duration in years (must be 1).
	ValidityInYears *int32 `json:"validityInYears,omitempty"`

	// READ-ONLY; Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons []*ResourceNotRenewableReason `json:"appServiceCertificateNotRenewableReasons,omitempty" azure:"ro"`

	// READ-ONLY; Contact info
	Contact *CertificateOrderContact `json:"contact,omitempty" azure:"ro"`

	// READ-ONLY; Domain verification token.
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration time.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`

	// READ-ONLY; Intermediate certificate.
	Intermediate *CertificateDetails `json:"intermediate,omitempty" azure:"ro"`

	// READ-ONLY; true if private key is external; otherwise, false.
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty" azure:"ro"`

	// READ-ONLY; Certificate last issuance time.
	LastCertificateIssuanceTime *time.Time `json:"lastCertificateIssuanceTime,omitempty" azure:"ro"`

	// READ-ONLY; Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *time.Time `json:"nextAutoRenewalTimeStamp,omitempty" azure:"ro"`

	// READ-ONLY; Status of certificate order.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Root certificate.
	Root *CertificateDetails `json:"root,omitempty" azure:"ro"`

	// READ-ONLY; Current serial number of the certificate.
	SerialNumber *string `json:"serialNumber,omitempty" azure:"ro"`

	// READ-ONLY; Signed certificate.
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty" azure:"ro"`

	// READ-ONLY; Current order status.
	Status *CertificateOrderStatus `json:"status,omitempty" azure:"ro"`
}

// CertificateOrdersClientBeginCreateOrUpdateCertificateOptions contains the optional parameters for the CertificateOrdersClient.BeginCreateOrUpdateCertificate
// method.
type CertificateOrdersClientBeginCreateOrUpdateCertificateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CertificateOrdersClientBeginCreateOrUpdateOptions contains the optional parameters for the CertificateOrdersClient.BeginCreateOrUpdate
// method.
type CertificateOrdersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// CertificateOrdersClientDeleteCertificateOptions contains the optional parameters for the CertificateOrdersClient.DeleteCertificate
// method.
type CertificateOrdersClientDeleteCertificateOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientDeleteOptions contains the optional parameters for the CertificateOrdersClient.Delete method.
type CertificateOrdersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientGetCertificateOptions contains the optional parameters for the CertificateOrdersClient.GetCertificate
// method.
type CertificateOrdersClientGetCertificateOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientGetOptions contains the optional parameters for the CertificateOrdersClient.Get method.
type CertificateOrdersClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientListByResourceGroupOptions contains the optional parameters for the CertificateOrdersClient.ListByResourceGroup
// method.
type CertificateOrdersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientListCertificatesOptions contains the optional parameters for the CertificateOrdersClient.ListCertificates
// method.
type CertificateOrdersClientListCertificatesOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientListOptions contains the optional parameters for the CertificateOrdersClient.List method.
type CertificateOrdersClientListOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientReissueOptions contains the optional parameters for the CertificateOrdersClient.Reissue method.
type CertificateOrdersClientReissueOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientRenewOptions contains the optional parameters for the CertificateOrdersClient.Renew method.
type CertificateOrdersClientRenewOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientResendEmailOptions contains the optional parameters for the CertificateOrdersClient.ResendEmail
// method.
type CertificateOrdersClientResendEmailOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientResendRequestEmailsOptions contains the optional parameters for the CertificateOrdersClient.ResendRequestEmails
// method.
type CertificateOrdersClientResendRequestEmailsOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientRetrieveCertificateActionsOptions contains the optional parameters for the CertificateOrdersClient.RetrieveCertificateActions
// method.
type CertificateOrdersClientRetrieveCertificateActionsOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientRetrieveCertificateEmailHistoryOptions contains the optional parameters for the CertificateOrdersClient.RetrieveCertificateEmailHistory
// method.
type CertificateOrdersClientRetrieveCertificateEmailHistoryOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientRetrieveSiteSealOptions contains the optional parameters for the CertificateOrdersClient.RetrieveSiteSeal
// method.
type CertificateOrdersClientRetrieveSiteSealOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientUpdateCertificateOptions contains the optional parameters for the CertificateOrdersClient.UpdateCertificate
// method.
type CertificateOrdersClientUpdateCertificateOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientUpdateOptions contains the optional parameters for the CertificateOrdersClient.Update method.
type CertificateOrdersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientValidatePurchaseInformationOptions contains the optional parameters for the CertificateOrdersClient.ValidatePurchaseInformation
// method.
type CertificateOrdersClientValidatePurchaseInformationOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersClientVerifyDomainOwnershipOptions contains the optional parameters for the CertificateOrdersClient.VerifyDomainOwnership
// method.
type CertificateOrdersClientVerifyDomainOwnershipOptions struct {
	// placeholder for future optional parameters
}

// CertificateOrdersDiagnosticsClientGetAppServiceCertificateOrderDetectorResponseOptions contains the optional parameters
// for the CertificateOrdersDiagnosticsClient.GetAppServiceCertificateOrderDetectorResponse method.
type CertificateOrdersDiagnosticsClientGetAppServiceCertificateOrderDetectorResponseOptions struct {
	// The end time for the detector response.
	EndTime *time.Time
	// The start time for detector response.
	StartTime *time.Time
	// The time grain for the detector response.
	TimeGrain *string
}

// CertificateOrdersDiagnosticsClientListAppServiceCertificateOrderDetectorResponseOptions contains the optional parameters
// for the CertificateOrdersDiagnosticsClient.ListAppServiceCertificateOrderDetectorResponse method.
type CertificateOrdersDiagnosticsClientListAppServiceCertificateOrderDetectorResponseOptions struct {
	// placeholder for future optional parameters
}

// CertificatePatchResource - Key Vault container ARM resource for a certificate that is purchased through Azure.
type CertificatePatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *Certificate `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateRegistrationProviderClientListOperationsOptions contains the optional parameters for the CertificateRegistrationProviderClient.ListOperations
// method.
type CertificateRegistrationProviderClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// CertificateResource - Key Vault container ARM resource for a certificate that is purchased through Azure.
type CertificateResource struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *Certificate `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificatesClientCreateOrUpdateOptions contains the optional parameters for the CertificatesClient.CreateOrUpdate method.
type CertificatesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientDeleteOptions contains the optional parameters for the CertificatesClient.Delete method.
type CertificatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientGetOptions contains the optional parameters for the CertificatesClient.Get method.
type CertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientListByResourceGroupOptions contains the optional parameters for the CertificatesClient.ListByResourceGroup
// method.
type CertificatesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientListOptions contains the optional parameters for the CertificatesClient.List method.
type CertificatesClientListOptions struct {
	// Return only information specified in the filter (using OData syntax). For example: $filter=KeyVaultId eq 'KeyVaultId'
	Filter *string
}

// CertificatesClientUpdateOptions contains the optional parameters for the CertificatesClient.Update method.
type CertificatesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ClientRegistration - The configuration settings of the app registration for providers that have client ids and client secrets
type ClientRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string `json:"clientId,omitempty"`

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`
}

// CloningInfo - Information needed for cloning operation.
type CloningInfo struct {
	// REQUIRED; ARM resource ID of the source app. App resource ID is of the form /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
	// for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for
	// other slots.
	SourceWebAppID *string `json:"sourceWebAppId,omitempty"`

	// Application setting overrides for cloned app. If specified, these settings override the settings cloned from source app.
	// Otherwise, application settings from source app are retained.
	AppSettingsOverrides map[string]*string `json:"appSettingsOverrides,omitempty"`

	// true to clone custom hostnames from source app; otherwise, false.
	CloneCustomHostNames *bool `json:"cloneCustomHostNames,omitempty"`

	// true to clone source control from source app; otherwise, false.
	CloneSourceControl *bool `json:"cloneSourceControl,omitempty"`

	// true to configure load balancing for source and destination app.
	ConfigureLoadBalancing *bool `json:"configureLoadBalancing,omitempty"`

	// Correlation ID of cloning operation. This ID ties multiple cloning operations together to use the same snapshot.
	CorrelationID *string `json:"correlationId,omitempty"`

	// App Service Environment.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`

	// true to overwrite destination app; otherwise, false.
	Overwrite *bool `json:"overwrite,omitempty"`

	// Location of source app ex: West US or North Europe
	SourceWebAppLocation *string `json:"sourceWebAppLocation,omitempty"`

	// ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
	TrafficManagerProfileID *string `json:"trafficManagerProfileId,omitempty"`

	// Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
	TrafficManagerProfileName *string `json:"trafficManagerProfileName,omitempty"`
}

// Configuration - Non versioned Container App configuration properties that define the mutable settings of a Container app
type Configuration struct {
	// ActiveRevisionsMode controls how active revisions are handled for the Container app:Multiple: multiple revisions can be
	// active. If no value if provided, this is the defaultSingle: Only one revision
	// can be active at a time. Revision weights can not be used in this mode
	ActiveRevisionsMode *ActiveRevisionsMode `json:"activeRevisionsMode,omitempty"`

	// Ingress configurations.
	Ingress *Ingress `json:"ingress,omitempty"`

	// Collection of private container registry credentials for containers used by the Container app
	Registries []*RegistryCredentials `json:"registries,omitempty"`

	// Collection of secrets used by a Container app
	Secrets []*Secret `json:"secrets,omitempty"`
}

// ConnStringInfo - Database connection string information.
type ConnStringInfo struct {
	// Connection string value.
	ConnectionString *string `json:"connectionString,omitempty"`

	// Name of connection string.
	Name *string `json:"name,omitempty"`

	// Type of database.
	Type *ConnectionStringType `json:"type,omitempty"`
}

// ConnStringValueTypePair - Database connection string value to type pair.
type ConnStringValueTypePair struct {
	// REQUIRED; Type of database.
	Type *ConnectionStringType `json:"type,omitempty"`

	// REQUIRED; Value of pair.
	Value *string `json:"value,omitempty"`
}

// ConnectionStringDictionary - String dictionary resource.
type ConnectionStringDictionary struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Connection strings.
	Properties map[string]*ConnStringValueTypePair `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is
// made publicly available through the Whois directories as per ICANN requirements.
type Contact struct {
	// REQUIRED; Email address.
	Email *string `json:"email,omitempty"`

	// REQUIRED; First name.
	NameFirst *string `json:"nameFirst,omitempty"`

	// REQUIRED; Last name.
	NameLast *string `json:"nameLast,omitempty"`

	// REQUIRED; Phone number.
	Phone *string `json:"phone,omitempty"`

	// Mailing address.
	AddressMailing *Address `json:"addressMailing,omitempty"`

	// Fax number.
	Fax *string `json:"fax,omitempty"`

	// Job title.
	JobTitle *string `json:"jobTitle,omitempty"`

	// Middle name.
	NameMiddle *string `json:"nameMiddle,omitempty"`

	// Organization contact belongs to.
	Organization *string `json:"organization,omitempty"`
}

// Container App container definition.
type Container struct {
	// Container start command arguments.
	Args []*string `json:"args,omitempty"`

	// Container start command.
	Command []*string `json:"command,omitempty"`

	// Container environment variables.
	Env []*EnvironmentVar `json:"env,omitempty"`

	// Container image tag.
	Image *string `json:"image,omitempty"`

	// Custom container name.
	Name *string `json:"name,omitempty"`

	// Container resource requirements.
	Resources *ContainerResources `json:"resources,omitempty"`
}

// ContainerApp - Container App.
type ContainerApp struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ContainerApp resource specific properties
	Properties *ContainerAppProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerAppCollection - Container App collection ARM resource.
type ContainerAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerApp `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ContainerAppProperties - ContainerApp resource specific properties
type ContainerAppProperties struct {
	// Non versioned Container App configuration properties.
	Configuration *Configuration `json:"configuration,omitempty"`

	// Resource ID of the Container App's KubeEnvironment.
	KubeEnvironmentID *string `json:"kubeEnvironmentId,omitempty"`

	// Container App versioned application definition.
	Template *Template `json:"template,omitempty"`

	// READ-ONLY; Fully Qualified Domain Name of the latest revision of the Container App.
	LatestRevisionFqdn *string `json:"latestRevisionFqdn,omitempty" azure:"ro"`

	// READ-ONLY; Name of the latest revision of the Container App.
	LatestRevisionName *string `json:"latestRevisionName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Container App.
	ProvisioningState *ContainerAppProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ContainerAppSecret - Container App Secret.
type ContainerAppSecret struct {
	// READ-ONLY; Secret Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Secret Value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ContainerAppsClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainerAppsClient.BeginCreateOrUpdate
// method.
type ContainerAppsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsClientBeginDeleteOptions contains the optional parameters for the ContainerAppsClient.BeginDelete method.
type ContainerAppsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsClientGetOptions contains the optional parameters for the ContainerAppsClient.Get method.
type ContainerAppsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientListByResourceGroupOptions contains the optional parameters for the ContainerAppsClient.ListByResourceGroup
// method.
type ContainerAppsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientListBySubscriptionOptions contains the optional parameters for the ContainerAppsClient.ListBySubscription
// method.
type ContainerAppsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientListSecretsOptions contains the optional parameters for the ContainerAppsClient.ListSecrets method.
type ContainerAppsClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

type ContainerAppsConfiguration struct {
	// Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet
	// defined in appSubnetResourceId. Must not overlap with the IP range defined in
	// platformReservedCidr, if defined.
	AppSubnetResourceID *string `json:"appSubnetResourceId,omitempty"`

	// Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet
	// defined in appSubnetResourceId. Must not overlap with the IP range defined in
	// platformReservedCidr, if defined.
	ControlPlaneSubnetResourceID *string `json:"controlPlaneSubnetResourceId,omitempty"`

	// Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
	DaprAIInstrumentationKey *string `json:"daprAIInstrumentationKey,omitempty"`

	// CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range
	// defined in platformReservedCidr, if defined.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any
	// other Subnet IP ranges.
	PlatformReservedCidr *string `json:"platformReservedCidr,omitempty"`

	// An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
	PlatformReservedDNSIP *string `json:"platformReservedDnsIP,omitempty"`
}

// ContainerAppsRevisionsClientActivateRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.ActivateRevision
// method.
type ContainerAppsRevisionsClientActivateRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientDeactivateRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.DeactivateRevision
// method.
type ContainerAppsRevisionsClientDeactivateRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientGetRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.GetRevision
// method.
type ContainerAppsRevisionsClientGetRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientListRevisionsOptions contains the optional parameters for the ContainerAppsRevisionsClient.ListRevisions
// method.
type ContainerAppsRevisionsClientListRevisionsOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientRestartRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.RestartRevision
// method.
type ContainerAppsRevisionsClientRestartRevisionOptions struct {
	// placeholder for future optional parameters
}

type ContainerCPUStatistics struct {
	CPUUsage       *ContainerCPUUsage       `json:"cpuUsage,omitempty"`
	OnlineCPUCount *int32                   `json:"onlineCpuCount,omitempty"`
	SystemCPUUsage *int64                   `json:"systemCpuUsage,omitempty"`
	ThrottlingData *ContainerThrottlingData `json:"throttlingData,omitempty"`
}

type ContainerCPUUsage struct {
	KernelModeUsage *int64   `json:"kernelModeUsage,omitempty"`
	PerCPUUsage     []*int64 `json:"perCpuUsage,omitempty"`
	TotalUsage      *int64   `json:"totalUsage,omitempty"`
	UserModeUsage   *int64   `json:"userModeUsage,omitempty"`
}

type ContainerInfo struct {
	CurrentCPUStats   *ContainerCPUStatistics              `json:"currentCpuStats,omitempty"`
	CurrentTimeStamp  *time.Time                           `json:"currentTimeStamp,omitempty"`
	Eth0              *ContainerNetworkInterfaceStatistics `json:"eth0,omitempty"`
	ID                *string                              `json:"id,omitempty"`
	MemoryStats       *ContainerMemoryStatistics           `json:"memoryStats,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	PreviousCPUStats  *ContainerCPUStatistics              `json:"previousCpuStats,omitempty"`
	PreviousTimeStamp *time.Time                           `json:"previousTimeStamp,omitempty"`
}

type ContainerMemoryStatistics struct {
	Limit    *int64 `json:"limit,omitempty"`
	MaxUsage *int64 `json:"maxUsage,omitempty"`
	Usage    *int64 `json:"usage,omitempty"`
}

type ContainerNetworkInterfaceStatistics struct {
	RxBytes   *int64 `json:"rxBytes,omitempty"`
	RxDropped *int64 `json:"rxDropped,omitempty"`
	RxErrors  *int64 `json:"rxErrors,omitempty"`
	RxPackets *int64 `json:"rxPackets,omitempty"`
	TxBytes   *int64 `json:"txBytes,omitempty"`
	TxDropped *int64 `json:"txDropped,omitempty"`
	TxErrors  *int64 `json:"txErrors,omitempty"`
	TxPackets *int64 `json:"txPackets,omitempty"`
}

// ContainerResources - Container App container resource requirements.
type ContainerResources struct {
	// Required CPU in cores, e.g. 0.5
	CPU *float64 `json:"cpu,omitempty"`

	// Required memory, e.g. "250Mb"
	Memory *string `json:"memory,omitempty"`
}

type ContainerThrottlingData struct {
	Periods          *int32 `json:"periods,omitempty"`
	ThrottledPeriods *int32 `json:"throttledPeriods,omitempty"`
	ThrottledTime    *int32 `json:"throttledTime,omitempty"`
}

// ContentHash - The content hash.
type ContentHash struct {
	// The algorithm of the content hash.
	Algorithm *string `json:"algorithm,omitempty"`

	// The value of the content hash.
	Value *string `json:"value,omitempty"`
}

// ContentLink - The content link.
type ContentLink struct {
	// The content link URI.
	URI *string `json:"uri,omitempty"`

	// READ-ONLY; The content hash.
	ContentHash *ContentHash `json:"contentHash,omitempty" azure:"ro"`

	// READ-ONLY; The content size.
	ContentSize *int64 `json:"contentSize,omitempty" azure:"ro"`

	// READ-ONLY; The content version.
	ContentVersion *string `json:"contentVersion,omitempty" azure:"ro"`

	// READ-ONLY; The metadata.
	Metadata interface{} `json:"metadata,omitempty" azure:"ro"`
}

// ContinuousWebJob - Continuous Web Job Information.
type ContinuousWebJob struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ContinuousWebJob resource specific properties
	Properties *ContinuousWebJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContinuousWebJobCollection - Collection of Kudu continuous web job information elements.
type ContinuousWebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContinuousWebJob `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ContinuousWebJobProperties - ContinuousWebJob resource specific properties
type ContinuousWebJobProperties struct {
	// Detailed status.
	DetailedStatus *string `json:"detailed_status,omitempty"`

	// Error information.
	Error *string `json:"error,omitempty"`

	// Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`

	// Log URL.
	LogURL *string `json:"log_url,omitempty"`

	// Run command.
	RunCommand *string `json:"run_command,omitempty"`

	// Job settings.
	Settings map[string]interface{} `json:"settings,omitempty"`

	// Job status.
	Status *ContinuousWebJobStatus `json:"status,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`

	// Job type.
	WebJobType *WebJobType `json:"web_job_type,omitempty"`
}

// CookieExpiration - The configuration settings of the session cookie's expiration.
type CookieExpiration struct {
	// The convention used when determining the session cookie's expiration.
	Convention *CookieExpirationConvention `json:"convention,omitempty"`

	// The time after the request is made when the session cookie should expire.
	TimeToExpiration *string `json:"timeToExpiration,omitempty"`
}

// Correlation - The correlation property.
type Correlation struct {
	// The client tracking id.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// CorsSettings - Cross-Origin Resource Sharing (CORS) settings for the app.
type CorsSettings struct {
	// Gets or sets the list of origins that should be allowed to make cross-origin calls (for example: http://example.com:12345).
	// Use "*" to allow all.
	AllowedOrigins []*string `json:"allowedOrigins,omitempty"`

	// Gets or sets whether CORS requests with credentials are allowed. See https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requestswithcredentials
	// for more details.
	SupportCredentials *bool `json:"supportCredentials,omitempty"`
}

// CsmDeploymentStatus - Deployment status response payload.
type CsmDeploymentStatus struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CsmDeploymentStatus resource specific properties
	Properties *CsmDeploymentStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CsmDeploymentStatusCollection - Deployment status collection ARM resource.
type CsmDeploymentStatusCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmDeploymentStatus `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CsmDeploymentStatusProperties - CsmDeploymentStatus resource specific properties
type CsmDeploymentStatusProperties struct {
	// Deployment operation id.
	DeploymentID *string `json:"deploymentId,omitempty"`

	// List of errors.
	Errors []*ErrorEntity `json:"errors,omitempty"`

	// List of URLs pointing to logs for instances which failed to provision.
	FailedInstancesLogs []*string `json:"failedInstancesLogs,omitempty"`

	// Number of site instances failed to provision.
	NumberOfInstancesFailed *int32 `json:"numberOfInstancesFailed,omitempty"`

	// Number of site instances currently being provisioned.
	NumberOfInstancesInProgress *int32 `json:"numberOfInstancesInProgress,omitempty"`

	// Number of site instances provisioned successfully.
	NumberOfInstancesSuccessful *int32 `json:"numberOfInstancesSuccessful,omitempty"`

	// Deployment build status.
	Status *DeploymentBuildStatus `json:"status,omitempty"`
}

// CsmMoveResourceEnvelope - Object with a list of the resources that need to be moved and the resource group they should
// be moved to.
type CsmMoveResourceEnvelope struct {
	Resources           []*string `json:"resources,omitempty"`
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
}

// CsmOperationCollection - Collection of Azure resource manager operation metadata.
type CsmOperationCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmOperationDescription `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CsmOperationDescription - Description of an operation available for Microsoft.Web resource provider.
type CsmOperationDescription struct {
	// Meta data about operation used for display in portal.
	Display      *CsmOperationDisplay `json:"display,omitempty"`
	IsDataAction *bool                `json:"isDataAction,omitempty"`
	Name         *string              `json:"name,omitempty"`
	Origin       *string              `json:"origin,omitempty"`

	// Properties available for a Microsoft.Web resource provider operation.
	Properties *CsmOperationDescriptionProperties `json:"properties,omitempty"`
}

// CsmOperationDescriptionProperties - Properties available for a Microsoft.Web resource provider operation.
type CsmOperationDescriptionProperties struct {
	// Resource metrics service provided by Microsoft.Insights resource provider.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// CsmOperationDisplay - Meta data about operation used for display in portal.
type CsmOperationDisplay struct {
	Description *string `json:"description,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
}

// CsmPublishingCredentialsPoliciesEntity - Publishing Credentials Policies parameters.
type CsmPublishingCredentialsPoliciesEntity struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CsmPublishingCredentialsPoliciesEntity resource specific properties
	Properties *CsmPublishingCredentialsPoliciesEntityProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CsmPublishingCredentialsPoliciesEntityProperties - CsmPublishingCredentialsPoliciesEntity resource specific properties
type CsmPublishingCredentialsPoliciesEntityProperties struct {
	// REQUIRED; true to allow access to a publishing method; otherwise, false.
	Allow *bool `json:"allow,omitempty"`
}

// CsmPublishingProfileOptions - Publishing options for requested profile.
type CsmPublishingProfileOptions struct {
	// Name of the format. Valid values are: FileZilla3 WebDeploy -- default Ftp
	Format *PublishingProfileFormat `json:"format,omitempty"`

	// Include the DisasterRecover endpoint if true
	IncludeDisasterRecoveryEndpoints *bool `json:"includeDisasterRecoveryEndpoints,omitempty"`
}

// CsmSlotEntity - Deployment slot parameters.
type CsmSlotEntity struct {
	// REQUIRED; true to preserve Virtual Network to the slot during swap; otherwise, false.
	PreserveVnet *bool `json:"preserveVnet,omitempty"`

	// REQUIRED; Destination deployment slot during swap operation.
	TargetSlot *string `json:"targetSlot,omitempty"`
}

// CsmUsageQuota - Usage of the quota resource.
type CsmUsageQuota struct {
	// The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty"`

	// The resource limit.
	Limit *int64 `json:"limit,omitempty"`

	// Quota name.
	Name *LocalizableString `json:"name,omitempty"`

	// Next reset time for the resource counter.
	NextResetTime *time.Time `json:"nextResetTime,omitempty"`

	// Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty"`
}

// CsmUsageQuotaCollection - Collection of CSM usage quotas.
type CsmUsageQuotaCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmUsageQuota `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CustomDNSSuffixConfiguration - Full view of the custom domain suffix configuration for ASEv3.
type CustomDNSSuffixConfiguration struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CustomDnsSuffixConfiguration resource specific properties
	Properties *CustomDNSSuffixConfigurationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomDNSSuffixConfigurationProperties - CustomDnsSuffixConfiguration resource specific properties
type CustomDNSSuffixConfigurationProperties struct {
	// The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites
	// with the custom domain suffix.
	CertificateURL *string `json:"certificateUrl,omitempty"`

	// The default custom domain suffix to use for all sites deployed on the ASE.
	DNSSuffix *string `json:"dnsSuffix,omitempty"`

	// The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned
	// ASE identity will be used if available.
	KeyVaultReferenceIdentity *string `json:"keyVaultReferenceIdentity,omitempty"`

	// READ-ONLY
	ProvisioningDetails *string `json:"provisioningDetails,omitempty" azure:"ro"`

	// READ-ONLY
	ProvisioningState *CustomDNSSuffixProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResult - Custom domain analysis.
type CustomHostnameAnalysisResult struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CustomHostnameAnalysisResult resource specific properties
	Properties *CustomHostnameAnalysisResultProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResultProperties - CustomHostnameAnalysisResult resource specific properties
type CustomHostnameAnalysisResultProperties struct {
	// A records controller can see for this hostname.
	ARecords []*string `json:"aRecords,omitempty"`

	// Alternate CName records controller can see for this hostname.
	AlternateCNameRecords []*string `json:"alternateCNameRecords,omitempty"`

	// Alternate TXT records controller can see for this hostname.
	AlternateTxtRecords []*string `json:"alternateTxtRecords,omitempty"`

	// CName records controller can see for this hostname.
	CNameRecords []*string `json:"cNameRecords,omitempty"`

	// TXT records controller can see for this hostname.
	TxtRecords []*string `json:"txtRecords,omitempty"`

	// READ-ONLY; Name of the conflicting app on scale unit if it's within the same subscription.
	ConflictingAppResourceID *string `json:"conflictingAppResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *ErrorEntity `json:"customDomainVerificationFailureInfo,omitempty" azure:"ro"`

	// READ-ONLY; DNS verification test result.
	CustomDomainVerificationTest *DNSVerificationTestResult `json:"customDomainVerificationTest,omitempty" azure:"ro"`

	// READ-ONLY; true if there is a conflict across subscriptions; otherwise, false.
	HasConflictAcrossSubscription *bool `json:"hasConflictAcrossSubscription,omitempty" azure:"ro"`

	// READ-ONLY; true if there is a conflict on a scale unit; otherwise, false.
	HasConflictOnScaleUnit *bool `json:"hasConflictOnScaleUnit,omitempty" azure:"ro"`

	// READ-ONLY; true if hostname is already verified; otherwise, false.
	IsHostnameAlreadyVerified *bool `json:"isHostnameAlreadyVerified,omitempty" azure:"ro"`
}

// CustomHostnameSites - A hostname and its assigned sites
type CustomHostnameSites struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// CustomHostnameSites resource specific properties
	Properties *CustomHostnameSitesProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CustomHostnameSitesCollection - Collection of custom hostname sites
type CustomHostnameSitesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CustomHostnameSites `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CustomHostnameSitesProperties - CustomHostnameSites resource specific properties
type CustomHostnameSitesProperties struct {
	CustomHostname  *string       `json:"customHostname,omitempty"`
	Region          *string       `json:"region,omitempty"`
	SiteResourceIDs []*Identifier `json:"siteResourceIds,omitempty"`
}

// CustomOpenIDConnectProvider - The configuration settings of the custom Open ID Connect provider.
type CustomOpenIDConnectProvider struct {
	// false if the custom Open ID provider provider should not be enabled; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow of the custom Open ID Connect provider.
	Login *OpenIDConnectLogin `json:"login,omitempty"`

	// The configuration settings of the app registration for the custom Open ID Connect provider.
	Registration *OpenIDConnectRegistration `json:"registration,omitempty"`
}

// CustomScaleRule - Container App container Custom scaling rule.
type CustomScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Metadata properties to describe custom scale rule.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// Type of the custom scale rule eg: azure-servicebus, redis etc.
	Type *string `json:"type,omitempty"`
}

// Dapr - Container App Dapr configuration.
type Dapr struct {
	// Dapr application identifier
	AppID *string `json:"appId,omitempty"`

	// Port on which the Dapr side car
	AppPort *int32 `json:"appPort,omitempty"`

	// Collection of Dapr components
	Components []*DaprComponent `json:"components,omitempty"`

	// Boolean indicating if the Dapr side car is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// DaprComponent - Dapr component configuration
type DaprComponent struct {
	// Component metadata
	Metadata []*DaprMetadata `json:"metadata,omitempty"`

	// Component name
	Name *string `json:"name,omitempty"`

	// Component type
	Type *string `json:"type,omitempty"`

	// Component version
	Version *string `json:"version,omitempty"`
}

// DaprMetadata - Container App Dapr component metadata.
type DaprMetadata struct {
	// Metadata property name.
	Name *string `json:"name,omitempty"`

	// Name of the Container App secret from which to pull the metadata property value.
	SecretRef *string `json:"secretRef,omitempty"`

	// Metadata property value.
	Value *string `json:"value,omitempty"`
}

// DataProviderMetadata - Additional configuration for a data providers
type DataProviderMetadata struct {
	ProviderName *string `json:"providerName,omitempty"`

	// READ-ONLY; Settings for the data provider
	PropertyBag []*KeyValuePairStringObject `json:"propertyBag,omitempty" azure:"ro"`
}

// DataSource - Class representing data source used by the detectors
type DataSource struct {
	// Datasource Uri Links
	DataSourceURI []*NameValuePair `json:"dataSourceUri,omitempty"`

	// Instructions if any for the data source
	Instructions []*string `json:"instructions,omitempty"`
}

// DataTableResponseColumn - Column definition
type DataTableResponseColumn struct {
	// Name of the column
	ColumnName *string `json:"columnName,omitempty"`

	// Column Type
	ColumnType *string `json:"columnType,omitempty"`

	// Data type which looks like 'String' or 'Int32'.
	DataType *string `json:"dataType,omitempty"`
}

// DataTableResponseObject - Data Table which defines columns and raw row values
type DataTableResponseObject struct {
	// List of columns with data types
	Columns []*DataTableResponseColumn `json:"columns,omitempty"`

	// Raw row values
	Rows [][]*string `json:"rows,omitempty"`

	// Name of the table
	TableName *string `json:"tableName,omitempty"`
}

// DatabaseBackupSetting - Database backup settings.
type DatabaseBackupSetting struct {
	// REQUIRED; Database type (e.g. SqlAzure / MySql).
	DatabaseType *DatabaseType `json:"databaseType,omitempty"`

	// Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new
	// database, the database name inside is the new one.
	ConnectionString *string `json:"connectionString,omitempty"`

	// Contains a connection string name that is linked to the SiteConfig.ConnectionStrings. This is used during restore with
	// overwrite connection strings options.
	ConnectionStringName *string `json:"connectionStringName,omitempty"`
	Name                 *string `json:"name,omitempty"`
}

// DefaultAuthorizationPolicy - The configuration settings of the Azure Active Directory default authorization policy.
type DefaultAuthorizationPolicy struct {
	// The configuration settings of the Azure Active Directory allowed applications.
	AllowedApplications []*string `json:"allowedApplications,omitempty"`

	// The configuration settings of the Azure Active Directory allowed principals.
	AllowedPrincipals *AllowedPrincipals `json:"allowedPrincipals,omitempty"`
}

// DefaultErrorResponse - App Service error response.
type DefaultErrorResponse struct {
	// READ-ONLY; Error model.
	Error *DefaultErrorResponseError `json:"error,omitempty" azure:"ro"`
}

// DefaultErrorResponseError - Error model.
type DefaultErrorResponseError struct {
	Details []*DefaultErrorResponseErrorDetailsItem `json:"details,omitempty"`

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; More information to debug error.
	Innererror *string `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// DefaultErrorResponseErrorDetailsItem - Detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// DeletedAppRestoreRequest - Details about restoring a deleted app.
type DeletedAppRestoreRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DeletedAppRestoreRequest resource specific properties
	Properties *DeletedAppRestoreRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedAppRestoreRequestProperties - DeletedAppRestoreRequest resource specific properties
type DeletedAppRestoreRequestProperties struct {
	// ARM resource ID of the deleted app. Example: /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}
	DeletedSiteID *string `json:"deletedSiteId,omitempty"`

	// If true, deleted site configuration, in addition to content, will be restored.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`

	// Point in time to restore the deleted app from, formatted as a DateTime string. If unspecified, default value is the time
	// that the app was deleted.
	SnapshotTime *string `json:"snapshotTime,omitempty"`

	// If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool `json:"useDRSecondary,omitempty"`
}

// DeletedSite - A deleted app.
type DeletedSite struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DeletedSite resource specific properties
	Properties *DeletedSiteProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedSiteProperties - DeletedSite resource specific properties
type DeletedSiteProperties struct {
	// READ-ONLY; Numeric id for the deleted site
	DeletedSiteID *int32 `json:"deletedSiteId,omitempty" azure:"ro"`

	// READ-ONLY; Name of the deleted site
	DeletedSiteName *string `json:"deletedSiteName,omitempty" azure:"ro"`

	// READ-ONLY; Time in UTC when the app was deleted.
	DeletedTimestamp *string `json:"deletedTimestamp,omitempty" azure:"ro"`

	// READ-ONLY; Geo Region of the deleted site
	GeoRegionName *string `json:"geoRegionName,omitempty" azure:"ro"`

	// READ-ONLY; Kind of site that was deleted
	Kind *string `json:"kind,omitempty" azure:"ro"`

	// READ-ONLY; ResourceGroup that contained the deleted site
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Slot of the deleted site
	Slot *string `json:"slot,omitempty" azure:"ro"`

	// READ-ONLY; Subscription containing the deleted site
	Subscription *string `json:"subscription,omitempty" azure:"ro"`
}

// DeletedWebAppCollection - Collection of deleted apps.
type DeletedWebAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DeletedSite `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeletedWebAppsClientGetDeletedWebAppByLocationOptions contains the optional parameters for the DeletedWebAppsClient.GetDeletedWebAppByLocation
// method.
type DeletedWebAppsClientGetDeletedWebAppByLocationOptions struct {
	// placeholder for future optional parameters
}

// DeletedWebAppsClientListByLocationOptions contains the optional parameters for the DeletedWebAppsClient.ListByLocation
// method.
type DeletedWebAppsClientListByLocationOptions struct {
	// placeholder for future optional parameters
}

// DeletedWebAppsClientListOptions contains the optional parameters for the DeletedWebAppsClient.List method.
type DeletedWebAppsClientListOptions struct {
	// placeholder for future optional parameters
}

// Deployment - User credentials used for publishing activity.
type Deployment struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Deployment resource specific properties
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeploymentCollection - Collection of app deployments.
type DeploymentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Deployment `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DeploymentLocations - List of available locations (regions or App Service Environments) for deployment of App Service resources.
type DeploymentLocations struct {
	// Available App Service Environments with basic information.
	HostingEnvironmentDeploymentInfos []*HostingEnvironmentDeploymentInfo `json:"hostingEnvironmentDeploymentInfos,omitempty"`

	// Available App Service Environments with full descriptions of the environments.
	HostingEnvironments []*Environment `json:"hostingEnvironments,omitempty"`

	// Available regions.
	Locations []*GeoRegion `json:"locations,omitempty"`
}

// DeploymentProperties - Deployment resource specific properties
type DeploymentProperties struct {
	// True if deployment is currently active, false if completed and null if not started.
	Active *bool `json:"active,omitempty"`

	// Who authored the deployment.
	Author *string `json:"author,omitempty"`

	// Author email.
	AuthorEmail *string `json:"author_email,omitempty"`

	// Who performed the deployment.
	Deployer *string `json:"deployer,omitempty"`

	// Details on deployment.
	Details *string `json:"details,omitempty"`

	// End time.
	EndTime *time.Time `json:"end_time,omitempty"`

	// Details about deployment status.
	Message *string `json:"message,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Deployment status.
	Status *int32 `json:"status,omitempty"`
}

// DetectorAbnormalTimePeriod - Class representing Abnormal Time Period detected.
type DetectorAbnormalTimePeriod struct {
	// End time of the correlated event
	EndTime *time.Time `json:"endTime,omitempty"`

	// Message describing the event
	Message *string `json:"message,omitempty"`

	// Downtime metadata
	MetaData [][]*NameValuePair `json:"metaData,omitempty"`

	// Represents the rank of the Detector
	Priority *float64 `json:"priority,omitempty"`

	// List of proposed solutions
	Solutions []*Solution `json:"solutions,omitempty"`

	// Represents the name of the Detector
	Source *string `json:"source,omitempty"`

	// Start time of the correlated event
	StartTime *time.Time `json:"startTime,omitempty"`

	// Represents the type of the Detector
	Type *IssueType `json:"type,omitempty"`
}

// DetectorDefinition - Class representing detector definition
type DetectorDefinition struct {
	// READ-ONLY; Description of the detector
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display name of the detector
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Flag representing whether detector is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Detector Rank
	Rank *float64 `json:"rank,omitempty" azure:"ro"`
}

// DetectorDefinitionResource - ARM resource for a detector definition
type DetectorDefinitionResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *DetectorDefinition `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DetectorInfo - Definition of Detector
type DetectorInfo struct {
	// READ-ONLY; Analysis Types for which this detector should apply to.
	AnalysisType []*string `json:"analysisType,omitempty" azure:"ro"`

	// READ-ONLY; Author of the detector.
	Author *string `json:"author,omitempty" azure:"ro"`

	// READ-ONLY; Problem category. This serves for organizing group for detectors.
	Category *string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Short description of the detector and its purpose.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Id of detector
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of detector
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Defines score of a detector to power ML based matching.
	Score *float32 `json:"score,omitempty" azure:"ro"`

	// READ-ONLY; List of Support Topics for which this detector is enabled.
	SupportTopicList []*SupportTopic `json:"supportTopicList,omitempty" azure:"ro"`

	// READ-ONLY; Whether this detector is an Analysis Detector or not.
	Type *DetectorType `json:"type,omitempty" azure:"ro"`
}

// DetectorResponse - Class representing Response from Detector
type DetectorResponse struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DetectorResponse resource specific properties
	Properties *DetectorResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DetectorResponseCollection - Collection of detector responses
type DetectorResponseCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DetectorResponse `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DetectorResponseProperties - DetectorResponse resource specific properties
type DetectorResponseProperties struct {
	// Additional configuration for different data providers to be used by the UI
	DataProvidersMetadata []*DataProviderMetadata `json:"dataProvidersMetadata,omitempty"`

	// Data Set
	Dataset []*DiagnosticData `json:"dataset,omitempty"`

	// metadata for the detector
	Metadata *DetectorInfo `json:"metadata,omitempty"`

	// Indicates status of the most severe insight.
	Status *Status `json:"status,omitempty"`

	// Suggested utterances where the detector can be applicable.
	SuggestedUtterances *QueryUtterancesResults `json:"suggestedUtterances,omitempty"`
}

// DiagnosticAnalysis - Class representing a diagnostic analysis done on an application
type DiagnosticAnalysis struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DiagnosticAnalysis resource specific properties
	Properties *DiagnosticAnalysisProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticAnalysisCollection - Collection of Diagnostic Analyses
type DiagnosticAnalysisCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AnalysisDefinition `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DiagnosticAnalysisProperties - DiagnosticAnalysis resource specific properties
type DiagnosticAnalysisProperties struct {
	// List of time periods.
	AbnormalTimePeriods []*AbnormalTimePeriod `json:"abnormalTimePeriods,omitempty"`

	// End time of the period
	EndTime *time.Time `json:"endTime,omitempty"`

	// Data by each detector for detectors that did not corelate
	NonCorrelatedDetectors []*DetectorDefinition `json:"nonCorrelatedDetectors,omitempty"`

	// Data by each detector
	Payload []*AnalysisData `json:"payload,omitempty"`

	// Start time of the period
	StartTime *time.Time `json:"startTime,omitempty"`
}

// DiagnosticCategory - Class representing detector definition
type DiagnosticCategory struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DiagnosticCategory resource specific properties
	Properties *DiagnosticCategoryProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticCategoryCollection - Collection of Diagnostic Categories
type DiagnosticCategoryCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DiagnosticCategory `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DiagnosticCategoryProperties - DiagnosticCategory resource specific properties
type DiagnosticCategoryProperties struct {
	// READ-ONLY; Description of the diagnostic category
	Description *string `json:"description,omitempty" azure:"ro"`
}

// DiagnosticData - Set of data with rendering instructions
type DiagnosticData struct {
	// Properties that describe how the table should be rendered
	RenderingProperties *Rendering `json:"renderingProperties,omitempty"`

	// Data in table form
	Table *DataTableResponseObject `json:"table,omitempty"`
}

// DiagnosticDetectorCollection - Collection of Diagnostic Detectors
type DiagnosticDetectorCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DetectorDefinitionResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DiagnosticDetectorResponse - Class representing Response from Diagnostic Detectors
type DiagnosticDetectorResponse struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DiagnosticDetectorResponse resource specific properties
	Properties *DiagnosticDetectorResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticDetectorResponseProperties - DiagnosticDetectorResponse resource specific properties
type DiagnosticDetectorResponseProperties struct {
	// List of Correlated events found by the detector
	AbnormalTimePeriods []*DetectorAbnormalTimePeriod `json:"abnormalTimePeriods,omitempty"`

	// Additional Data that detector wants to send.
	Data [][]*NameValuePair `json:"data,omitempty"`

	// Detector's definition
	DetectorDefinition *DetectorDefinition `json:"detectorDefinition,omitempty"`

	// End time of the period
	EndTime *time.Time `json:"endTime,omitempty"`

	// Flag representing Issue was detected.
	IssueDetected *bool `json:"issueDetected,omitempty"`

	// Metrics provided by the detector
	Metrics []*DiagnosticMetricSet `json:"metrics,omitempty"`

	// Meta Data
	ResponseMetaData *ResponseMetaData `json:"responseMetaData,omitempty"`

	// Start time of the period
	StartTime *time.Time `json:"startTime,omitempty"`
}

// DiagnosticMetricSample - Class representing Diagnostic Metric
type DiagnosticMetricSample struct {
	// Whether the values are aggregates across all workers or not
	IsAggregated *bool `json:"isAggregated,omitempty"`

	// Maximum of the metric sampled during the time period
	Maximum *float64 `json:"maximum,omitempty"`

	// Minimum of the metric sampled during the time period
	Minimum *float64 `json:"minimum,omitempty"`

	// Role Instance. Null if this counter is not per instance This is returned and should be whichever instance name we desire
	// to be returned i.e. CPU and Memory return RDWORKERNAME (LargeDed…IN0) where
	// RDWORKERNAME is Machine name below and RoleInstance name in parenthesis
	RoleInstance *string `json:"roleInstance,omitempty"`

	// Time at which metric is measured
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// Total value of the metric. If multiple measurements are made this will have sum of all.
	Total *float64 `json:"total,omitempty"`
}

// DiagnosticMetricSet - Class representing Diagnostic Metric information
type DiagnosticMetricSet struct {
	// End time of the period
	EndTime *time.Time `json:"endTime,omitempty"`

	// Name of the metric
	Name *string `json:"name,omitempty"`

	// Start time of the period
	StartTime *time.Time `json:"startTime,omitempty"`

	// Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D
	TimeGrain *string `json:"timeGrain,omitempty"`

	// Metric's unit
	Unit *string `json:"unit,omitempty"`

	// Collection of metric values for the selected period based on the {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}
	Values []*DiagnosticMetricSample `json:"values,omitempty"`
}

// DiagnosticsClientExecuteSiteAnalysisOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteAnalysis
// method.
type DiagnosticsClientExecuteSiteAnalysisOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientExecuteSiteAnalysisSlotOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteAnalysisSlot
// method.
type DiagnosticsClientExecuteSiteAnalysisSlotOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientExecuteSiteDetectorOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteDetector
// method.
type DiagnosticsClientExecuteSiteDetectorOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientExecuteSiteDetectorSlotOptions contains the optional parameters for the DiagnosticsClient.ExecuteSiteDetectorSlot
// method.
type DiagnosticsClientExecuteSiteDetectorSlotOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions contains the optional parameters for the DiagnosticsClient.GetHostingEnvironmentDetectorResponse
// method.
type DiagnosticsClientGetHostingEnvironmentDetectorResponseOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientGetSiteAnalysisOptions contains the optional parameters for the DiagnosticsClient.GetSiteAnalysis method.
type DiagnosticsClientGetSiteAnalysisOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientGetSiteAnalysisSlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteAnalysisSlot
// method.
type DiagnosticsClientGetSiteAnalysisSlotOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientGetSiteDetectorOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetector method.
type DiagnosticsClientGetSiteDetectorOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientGetSiteDetectorResponseOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetectorResponse
// method.
type DiagnosticsClientGetSiteDetectorResponseOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientGetSiteDetectorResponseSlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetectorResponseSlot
// method.
type DiagnosticsClientGetSiteDetectorResponseSlotOptions struct {
	// End Time
	EndTime *time.Time
	// Start Time
	StartTime *time.Time
	// Time Grain
	TimeGrain *string
}

// DiagnosticsClientGetSiteDetectorSlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteDetectorSlot
// method.
type DiagnosticsClientGetSiteDetectorSlotOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientGetSiteDiagnosticCategoryOptions contains the optional parameters for the DiagnosticsClient.GetSiteDiagnosticCategory
// method.
type DiagnosticsClientGetSiteDiagnosticCategoryOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientGetSiteDiagnosticCategorySlotOptions contains the optional parameters for the DiagnosticsClient.GetSiteDiagnosticCategorySlot
// method.
type DiagnosticsClientGetSiteDiagnosticCategorySlotOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListHostingEnvironmentDetectorResponsesOptions contains the optional parameters for the DiagnosticsClient.ListHostingEnvironmentDetectorResponses
// method.
type DiagnosticsClientListHostingEnvironmentDetectorResponsesOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteAnalysesOptions contains the optional parameters for the DiagnosticsClient.ListSiteAnalyses method.
type DiagnosticsClientListSiteAnalysesOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteAnalysesSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteAnalysesSlot
// method.
type DiagnosticsClientListSiteAnalysesSlotOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteDetectorResponsesOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectorResponses
// method.
type DiagnosticsClientListSiteDetectorResponsesOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteDetectorResponsesSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectorResponsesSlot
// method.
type DiagnosticsClientListSiteDetectorResponsesSlotOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteDetectorsOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectors
// method.
type DiagnosticsClientListSiteDetectorsOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteDetectorsSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteDetectorsSlot
// method.
type DiagnosticsClientListSiteDetectorsSlotOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteDiagnosticCategoriesOptions contains the optional parameters for the DiagnosticsClient.ListSiteDiagnosticCategories
// method.
type DiagnosticsClientListSiteDiagnosticCategoriesOptions struct {
	// placeholder for future optional parameters
}

// DiagnosticsClientListSiteDiagnosticCategoriesSlotOptions contains the optional parameters for the DiagnosticsClient.ListSiteDiagnosticCategoriesSlot
// method.
type DiagnosticsClientListSiteDiagnosticCategoriesSlotOptions struct {
	// placeholder for future optional parameters
}

// Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, where instance name is dimension
// of the metric HTTP request
type Dimension struct {
	DisplayName            *string `json:"displayName,omitempty"`
	InternalName           *string `json:"internalName,omitempty"`
	Name                   *string `json:"name,omitempty"`
	ToBeExportedForShoebox *bool   `json:"toBeExportedForShoebox,omitempty"`
}

// Domain - Information about a domain.
type Domain struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Domain resource specific properties
	Properties *DomainProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainAvailabilityCheckResult - Domain availability check result.
type DomainAvailabilityCheckResult struct {
	// true if domain can be purchased using CreateDomain API; otherwise, false.
	Available *bool `json:"available,omitempty"`

	// Valid values are Regular domain: Azure will charge the full price of domain registration, SoftDeleted: Purchasing this
	// domain will simply restore it and this operation will not cost anything.
	DomainType *DomainType `json:"domainType,omitempty"`

	// Name of the domain.
	Name *string `json:"name,omitempty"`
}

// DomainCollection - Collection of domains.
type DomainCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Domain `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DomainControlCenterSsoRequest - Single sign-on request information for domain management.
type DomainControlCenterSsoRequest struct {
	// READ-ONLY; Post parameter key.
	PostParameterKey *string `json:"postParameterKey,omitempty" azure:"ro"`

	// READ-ONLY; Post parameter value. Client should use 'application/x-www-form-urlencoded' encoding for this value.
	PostParameterValue *string `json:"postParameterValue,omitempty" azure:"ro"`

	// READ-ONLY; URL where the single sign-on request is to be made.
	URL *string `json:"url,omitempty" azure:"ro"`
}

// DomainOwnershipIdentifier - Domain ownership Identifier.
type DomainOwnershipIdentifier struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DomainOwnershipIdentifier resource specific properties
	Properties *DomainOwnershipIdentifierProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainOwnershipIdentifierCollection - Collection of domain ownership identifiers.
type DomainOwnershipIdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DomainOwnershipIdentifier `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DomainOwnershipIdentifierProperties - DomainOwnershipIdentifier resource specific properties
type DomainOwnershipIdentifierProperties struct {
	// Ownership Id.
	OwnershipID *string `json:"ownershipId,omitempty"`
}

// DomainPatchResource - ARM resource for a domain.
type DomainPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// DomainPatchResource resource specific properties
	Properties *DomainPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DomainPatchResourceProperties - DomainPatchResource resource specific properties
type DomainPatchResourceProperties struct {
	// REQUIRED; Legal agreement consent.
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`

	// REQUIRED; Administrative contact.
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`

	// REQUIRED; Billing contact.
	ContactBilling *Contact `json:"contactBilling,omitempty"`

	// REQUIRED; Registrant contact.
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`

	// REQUIRED; Technical contact.
	ContactTech *Contact `json:"contactTech,omitempty"`
	AuthCode    *string  `json:"authCode,omitempty"`

	// true if the domain should be automatically renewed; otherwise, false.
	AutoRenew *bool `json:"autoRenew,omitempty"`

	// Current DNS type
	DNSType *DNSType `json:"dnsType,omitempty"`

	// Azure DNS Zone to use
	DNSZoneID *string `json:"dnsZoneId,omitempty"`

	// true if domain privacy is enabled for this domain; otherwise, false.
	Privacy *bool `json:"privacy,omitempty"`

	// Target DNS type (would be used for migration)
	TargetDNSType *DNSType `json:"targetDnsType,omitempty"`

	// READ-ONLY; Domain creation timestamp.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Reasons why domain is not renewable.
	DomainNotRenewableReasons []*ResourceNotRenewableReason `json:"domainNotRenewableReasons,omitempty" azure:"ro"`

	// READ-ONLY; Domain expiration timestamp.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when the domain was renewed last time.
	LastRenewedTime *time.Time `json:"lastRenewedTime,omitempty" azure:"ro"`

	// READ-ONLY; All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames []*HostName `json:"managedHostNames,omitempty" azure:"ro"`

	// READ-ONLY; Name servers.
	NameServers []*string `json:"nameServers,omitempty" azure:"ro"`

	// READ-ONLY; Domain provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; true if Azure can assign this domain to App Service apps; otherwise, false. This value will be true if domain
	// registration status is active and it is hosted on name servers Azure has programmatic
	// access to.
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty" azure:"ro"`

	// READ-ONLY; Domain registration status.
	RegistrationStatus *DomainStatus `json:"registrationStatus,omitempty" azure:"ro"`
}

// DomainProperties - Domain resource specific properties
type DomainProperties struct {
	// REQUIRED; Legal agreement consent.
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`

	// REQUIRED; Administrative contact.
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`

	// REQUIRED; Billing contact.
	ContactBilling *Contact `json:"contactBilling,omitempty"`

	// REQUIRED; Registrant contact.
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`

	// REQUIRED; Technical contact.
	ContactTech *Contact `json:"contactTech,omitempty"`
	AuthCode    *string  `json:"authCode,omitempty"`

	// true if the domain should be automatically renewed; otherwise, false.
	AutoRenew *bool `json:"autoRenew,omitempty"`

	// Current DNS type
	DNSType *DNSType `json:"dnsType,omitempty"`

	// Azure DNS Zone to use
	DNSZoneID *string `json:"dnsZoneId,omitempty"`

	// true if domain privacy is enabled for this domain; otherwise, false.
	Privacy *bool `json:"privacy,omitempty"`

	// Target DNS type (would be used for migration)
	TargetDNSType *DNSType `json:"targetDnsType,omitempty"`

	// READ-ONLY; Domain creation timestamp.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Reasons why domain is not renewable.
	DomainNotRenewableReasons []*ResourceNotRenewableReason `json:"domainNotRenewableReasons,omitempty" azure:"ro"`

	// READ-ONLY; Domain expiration timestamp.
	ExpirationTime *time.Time `json:"expirationTime,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp when the domain was renewed last time.
	LastRenewedTime *time.Time `json:"lastRenewedTime,omitempty" azure:"ro"`

	// READ-ONLY; All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames []*HostName `json:"managedHostNames,omitempty" azure:"ro"`

	// READ-ONLY; Name servers.
	NameServers []*string `json:"nameServers,omitempty" azure:"ro"`

	// READ-ONLY; Domain provisioning state.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; true if Azure can assign this domain to App Service apps; otherwise, false. This value will be true if domain
	// registration status is active and it is hosted on name servers Azure has programmatic
	// access to.
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty" azure:"ro"`

	// READ-ONLY; Domain registration status.
	RegistrationStatus *DomainStatus `json:"registrationStatus,omitempty" azure:"ro"`
}

// DomainPurchaseConsent - Domain purchase consent object, representing acceptance of applicable legal agreements.
type DomainPurchaseConsent struct {
	// Timestamp when the agreements were accepted.
	AgreedAt *time.Time `json:"agreedAt,omitempty"`

	// Client IP address.
	AgreedBy *string `json:"agreedBy,omitempty"`

	// List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under TopLevelDomain
	// resource.
	AgreementKeys []*string `json:"agreementKeys,omitempty"`
}

// DomainRecommendationSearchParameters - Domain recommendation search parameters.
type DomainRecommendationSearchParameters struct {
	// Keywords to be used for generating domain recommendations.
	Keywords *string `json:"keywords,omitempty"`

	// Maximum number of recommendations.
	MaxDomainRecommendations *int32 `json:"maxDomainRecommendations,omitempty"`
}

// DomainRegistrationProviderClientListOperationsOptions contains the optional parameters for the DomainRegistrationProviderClient.ListOperations
// method.
type DomainRegistrationProviderClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientBeginCreateOrUpdateOptions contains the optional parameters for the DomainsClient.BeginCreateOrUpdate method.
type DomainsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DomainsClientCheckAvailabilityOptions contains the optional parameters for the DomainsClient.CheckAvailability method.
type DomainsClientCheckAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientCreateOrUpdateOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.CreateOrUpdateOwnershipIdentifier
// method.
type DomainsClientCreateOrUpdateOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientDeleteOptions contains the optional parameters for the DomainsClient.Delete method.
type DomainsClientDeleteOptions struct {
	// Specify true to delete the domain immediately. The default is false which deletes the domain after 24 hours.
	ForceHardDeleteDomain *bool
}

// DomainsClientDeleteOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.DeleteOwnershipIdentifier
// method.
type DomainsClientDeleteOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientGetControlCenterSsoRequestOptions contains the optional parameters for the DomainsClient.GetControlCenterSsoRequest
// method.
type DomainsClientGetControlCenterSsoRequestOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientGetOptions contains the optional parameters for the DomainsClient.Get method.
type DomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientGetOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.GetOwnershipIdentifier
// method.
type DomainsClientGetOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientListByResourceGroupOptions contains the optional parameters for the DomainsClient.ListByResourceGroup method.
type DomainsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientListOptions contains the optional parameters for the DomainsClient.List method.
type DomainsClientListOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientListOwnershipIdentifiersOptions contains the optional parameters for the DomainsClient.ListOwnershipIdentifiers
// method.
type DomainsClientListOwnershipIdentifiersOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientListRecommendationsOptions contains the optional parameters for the DomainsClient.ListRecommendations method.
type DomainsClientListRecommendationsOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientRenewOptions contains the optional parameters for the DomainsClient.Renew method.
type DomainsClientRenewOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientTransferOutOptions contains the optional parameters for the DomainsClient.TransferOut method.
type DomainsClientTransferOutOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientUpdateOptions contains the optional parameters for the DomainsClient.Update method.
type DomainsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// DomainsClientUpdateOwnershipIdentifierOptions contains the optional parameters for the DomainsClient.UpdateOwnershipIdentifier
// method.
type DomainsClientUpdateOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// EnabledConfig - Enabled configuration.
type EnabledConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// EndpointDependency - A domain name that a service is reached at, including details of the current connection status.
type EndpointDependency struct {
	// The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`

	// The IP Addresses and Ports used when connecting to DomainName.
	EndpointDetails []*EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail - Current TCP connectivity information from the App Service Environment to a single endpoint.
type EndpointDetail struct {
	// An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`

	// Whether it is possible to create a TCP connection from the App Service Environment to this IpAddress at this Port.
	IsAccessible *bool `json:"isAccessible,omitempty"`

	// The time in milliseconds it takes for a TCP connection to be created from the App Service Environment to this IpAddress
	// at this Port.
	Latency *float64 `json:"latency,omitempty"`

	// The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
}

// Environment - Description of an App Service Environment.
type Environment struct {
	// REQUIRED; Description of the Virtual Network.
	VirtualNetwork *VirtualNetworkProfile `json:"virtualNetwork,omitempty"`

	// Custom settings for changing the behavior of the App Service Environment.
	ClusterSettings []*NameValuePair `json:"clusterSettings,omitempty"`

	// Full view of the custom domain suffix configuration for ASEv3.
	CustomDNSSuffixConfiguration *CustomDNSSuffixConfiguration `json:"customDnsSuffixConfiguration,omitempty"`

	// DNS suffix of the App Service Environment.
	DNSSuffix *string `json:"dnsSuffix,omitempty"`

	// Dedicated Host Count
	DedicatedHostCount *int32 `json:"dedicatedHostCount,omitempty"`

	// Scale factor for front-ends.
	FrontEndScaleFactor *int32 `json:"frontEndScaleFactor,omitempty"`

	// Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment.
	InternalLoadBalancingMode *LoadBalancingMode `json:"internalLoadBalancingMode,omitempty"`

	// Number of IP SSL addresses reserved for the App Service Environment.
	IpsslAddressCount *int32 `json:"ipsslAddressCount,omitempty"`

	// Front-end VM size, e.g. "Medium", "Large".
	MultiSize *string `json:"multiSize,omitempty"`

	// Full view of networking configuration for an ASE.
	NetworkingConfiguration *AseV3NetworkingConfiguration `json:"networkingConfiguration,omitempty"`

	// Upgrade Preference
	UpgradePreference *UpgradePreference `json:"upgradePreference,omitempty"`

	// User added ip ranges to whitelist on ASE db
	UserWhitelistedIPRanges []*string `json:"userWhitelistedIpRanges,omitempty"`

	// Whether or not this App Service Environment is zone-redundant.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; Flag that displays whether an ASE has linux workers or not
	HasLinuxWorkers *bool `json:"hasLinuxWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of VMs in the App Service Environment.
	MaximumNumberOfMachines *int32 `json:"maximumNumberOfMachines,omitempty" azure:"ro"`

	// READ-ONLY; Number of front-end instances.
	MultiRoleCount *int32 `json:"multiRoleCount,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App Service Environment.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Current status of the App Service Environment.
	Status *HostingEnvironmentStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; true if the App Service Environment is suspended; otherwise, false. The environment can be suspended, e.g. when
	// the management endpoint is no longer available (most likely because NSG blocked the
	// incoming traffic).
	Suspended *bool `json:"suspended,omitempty" azure:"ro"`

	// READ-ONLY; Whether an upgrade is available for this App Service Environment.
	UpgradeAvailability *UpgradeAvailability `json:"upgradeAvailability,omitempty" azure:"ro"`
}

// EnvironmentCollection - Collection of App Service Environments.
type EnvironmentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*EnvironmentResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// EnvironmentPatchResource - ARM resource for a app service environment.
type EnvironmentPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *Environment `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnvironmentResource - App Service Environment ARM resource.
type EnvironmentResource struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *Environment `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnvironmentVar - Container App container environment variable.
type EnvironmentVar struct {
	// Environment variable name.
	Name *string `json:"name,omitempty"`

	// Name of the Container App secret from which to pull the environment variable value.
	SecretRef *string `json:"secretRef,omitempty"`

	// Non-secret environment variable value.
	Value *string `json:"value,omitempty"`
}

// EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection
// method.
type EnvironmentsClientBeginApproveOrRejectPrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginChangeVnetOptions contains the optional parameters for the EnvironmentsClient.BeginChangeVnet method.
type EnvironmentsClientBeginChangeVnetOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdateMultiRolePool
// method.
type EnvironmentsClientBeginCreateOrUpdateMultiRolePoolOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdate
// method.
type EnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdateWorkerPool
// method.
type EnvironmentsClientBeginCreateOrUpdateWorkerPoolOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginDeleteOptions contains the optional parameters for the EnvironmentsClient.BeginDelete method.
type EnvironmentsClientBeginDeleteOptions struct {
	// Specify true to force the deletion even if the App Service Environment contains resources. The default is false.
	ForceDelete *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.BeginDeletePrivateEndpointConnection
// method.
type EnvironmentsClientBeginDeletePrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginResumeOptions contains the optional parameters for the EnvironmentsClient.BeginResume method.
type EnvironmentsClientBeginResumeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginSuspendOptions contains the optional parameters for the EnvironmentsClient.BeginSuspend method.
type EnvironmentsClientBeginSuspendOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginUpgradeOptions contains the optional parameters for the EnvironmentsClient.BeginUpgrade method.
type EnvironmentsClientBeginUpgradeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration
// method.
type EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.GetAseCustomDNSSuffixConfiguration
// method.
type EnvironmentsClientGetAseCustomDNSSuffixConfigurationOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetAseV3NetworkingConfigurationOptions contains the optional parameters for the EnvironmentsClient.GetAseV3NetworkingConfiguration
// method.
type EnvironmentsClientGetAseV3NetworkingConfigurationOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetDiagnosticsItemOptions contains the optional parameters for the EnvironmentsClient.GetDiagnosticsItem
// method.
type EnvironmentsClientGetDiagnosticsItemOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions contains the optional parameters for the EnvironmentsClient.GetInboundNetworkDependenciesEndpoints
// method.
type EnvironmentsClientGetInboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.GetMultiRolePool
// method.
type EnvironmentsClientGetMultiRolePoolOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetOptions contains the optional parameters for the EnvironmentsClient.Get method.
type EnvironmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the EnvironmentsClient.GetOutboundNetworkDependenciesEndpoints
// method.
type EnvironmentsClientGetOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the EnvironmentsClient.GetPrivateEndpointConnectionList
// method.
type EnvironmentsClientGetPrivateEndpointConnectionListOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetPrivateEndpointConnectionOptions contains the optional parameters for the EnvironmentsClient.GetPrivateEndpointConnection
// method.
type EnvironmentsClientGetPrivateEndpointConnectionOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetPrivateLinkResourcesOptions contains the optional parameters for the EnvironmentsClient.GetPrivateLinkResources
// method.
type EnvironmentsClientGetPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetVipInfoOptions contains the optional parameters for the EnvironmentsClient.GetVipInfo method.
type EnvironmentsClientGetVipInfoOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.GetWorkerPool method.
type EnvironmentsClientGetWorkerPoolOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListAppServicePlansOptions contains the optional parameters for the EnvironmentsClient.ListAppServicePlans
// method.
type EnvironmentsClientListAppServicePlansOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListByResourceGroupOptions contains the optional parameters for the EnvironmentsClient.ListByResourceGroup
// method.
type EnvironmentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListCapacitiesOptions contains the optional parameters for the EnvironmentsClient.ListCapacities method.
type EnvironmentsClientListCapacitiesOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListDiagnosticsOptions contains the optional parameters for the EnvironmentsClient.ListDiagnostics method.
type EnvironmentsClientListDiagnosticsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListMultiRoleMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRoleMetricDefinitions
// method.
type EnvironmentsClientListMultiRoleMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRolePoolInstanceMetricDefinitions
// method.
type EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListMultiRolePoolSKUsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRolePoolSKUs
// method.
type EnvironmentsClientListMultiRolePoolSKUsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListMultiRolePoolsOptions contains the optional parameters for the EnvironmentsClient.ListMultiRolePools
// method.
type EnvironmentsClientListMultiRolePoolsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListMultiRoleUsagesOptions contains the optional parameters for the EnvironmentsClient.ListMultiRoleUsages
// method.
type EnvironmentsClientListMultiRoleUsagesOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListOperationsOptions contains the optional parameters for the EnvironmentsClient.ListOperations method.
type EnvironmentsClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListOptions contains the optional parameters for the EnvironmentsClient.List method.
type EnvironmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListUsagesOptions contains the optional parameters for the EnvironmentsClient.ListUsages method.
type EnvironmentsClientListUsagesOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
	// or name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and
	// endTime eq 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// EnvironmentsClientListWebAppsOptions contains the optional parameters for the EnvironmentsClient.ListWebApps method.
type EnvironmentsClientListWebAppsOptions struct {
	// Comma separated list of app properties to include.
	PropertiesToInclude *string
}

// EnvironmentsClientListWebWorkerMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListWebWorkerMetricDefinitions
// method.
type EnvironmentsClientListWebWorkerMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListWebWorkerUsagesOptions contains the optional parameters for the EnvironmentsClient.ListWebWorkerUsages
// method.
type EnvironmentsClientListWebWorkerUsagesOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions contains the optional parameters for the EnvironmentsClient.ListWorkerPoolInstanceMetricDefinitions
// method.
type EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListWorkerPoolSKUsOptions contains the optional parameters for the EnvironmentsClient.ListWorkerPoolSKUs
// method.
type EnvironmentsClientListWorkerPoolSKUsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListWorkerPoolsOptions contains the optional parameters for the EnvironmentsClient.ListWorkerPools method.
type EnvironmentsClientListWorkerPoolsOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientRebootOptions contains the optional parameters for the EnvironmentsClient.Reboot method.
type EnvironmentsClientRebootOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientTestUpgradeAvailableNotificationOptions contains the optional parameters for the EnvironmentsClient.TestUpgradeAvailableNotification
// method.
type EnvironmentsClientTestUpgradeAvailableNotificationOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions contains the optional parameters for the EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration
// method.
type EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientUpdateAseNetworkingConfigurationOptions contains the optional parameters for the EnvironmentsClient.UpdateAseNetworkingConfiguration
// method.
type EnvironmentsClientUpdateAseNetworkingConfigurationOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientUpdateMultiRolePoolOptions contains the optional parameters for the EnvironmentsClient.UpdateMultiRolePool
// method.
type EnvironmentsClientUpdateMultiRolePoolOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientUpdateOptions contains the optional parameters for the EnvironmentsClient.Update method.
type EnvironmentsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientUpdateWorkerPoolOptions contains the optional parameters for the EnvironmentsClient.UpdateWorkerPool
// method.
type EnvironmentsClientUpdateWorkerPoolOptions struct {
	// placeholder for future optional parameters
}

// ErrorEntity - Body of the error response returned from the API.
type ErrorEntity struct {
	// Basic error code.
	Code *string `json:"code,omitempty"`

	// Error Details.
	Details []*ErrorEntity `json:"details,omitempty"`

	// Type of error.
	ExtendedCode *string `json:"extendedCode,omitempty"`

	// Inner errors.
	InnerErrors []*ErrorEntity `json:"innerErrors,omitempty"`

	// Any details of the error.
	Message *string `json:"message,omitempty"`

	// Message template.
	MessageTemplate *string `json:"messageTemplate,omitempty"`

	// Parameters for the template.
	Parameters []*string `json:"parameters,omitempty"`

	// The error target.
	Target *string `json:"target,omitempty"`
}

// ErrorInfo - The error info.
type ErrorInfo struct {
	// REQUIRED; The error code.
	Code *string `json:"code,omitempty"`
}

// ErrorProperties - Error properties indicate why the Logic service was not able to process the incoming request. The reason
// is provided in the error message.
type ErrorProperties struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse - Error response indicates Logic service is not able to process the incoming request. The error property
// contains the error details.
type ErrorResponse struct {
	// The error properties.
	Error *ErrorProperties `json:"error,omitempty"`
}

// Experiments - Routing rules in production experiments.
type Experiments struct {
	// List of ramp-up rules.
	RampUpRules []*RampUpRule `json:"rampUpRules,omitempty"`
}

// Expression - The expression.
type Expression struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo `json:"error,omitempty"`

	// The sub expressions.
	Subexpressions []*Expression `json:"subexpressions,omitempty"`

	// The text.
	Text *string `json:"text,omitempty"`

	// Anything
	Value interface{} `json:"value,omitempty"`
}

// ExpressionRoot - The expression root.
type ExpressionRoot struct {
	// The azure resource error info.
	Error *AzureResourceErrorInfo `json:"error,omitempty"`

	// The path.
	Path *string `json:"path,omitempty"`

	// The sub expressions.
	Subexpressions []*Expression `json:"subexpressions,omitempty"`

	// The text.
	Text *string `json:"text,omitempty"`

	// Anything
	Value interface{} `json:"value,omitempty"`
}

// ExpressionTraces - The expression traces.
type ExpressionTraces struct {
	Inputs []*ExpressionRoot `json:"inputs,omitempty"`

	// The link used to get the next page of recommendations.
	NextLink *string `json:"nextLink,omitempty"`

	// Anything
	Value interface{} `json:"value,omitempty"`
}

// ExtendedLocation - Extended Location.
type ExtendedLocation struct {
	// Name of extended location.
	Name *string `json:"name,omitempty"`

	// READ-ONLY; Type of extended location.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Facebook - The configuration settings of the Facebook provider.
type Facebook struct {
	// false if the Facebook provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The version of the Facebook api to be used while logging in.
	GraphAPIVersion *string `json:"graphApiVersion,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the Facebook provider.
	Registration *AppRegistration `json:"registration,omitempty"`
}

// FileSystemApplicationLogsConfig - Application logs to file system configuration.
type FileSystemApplicationLogsConfig struct {
	// Log level.
	Level *LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig - Http logs to file system configuration.
type FileSystemHTTPLogsConfig struct {
	// True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`

	// Retention in days. Remove files older than X days. 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`

	// Maximum size in megabytes that http log files can use. When reached old log files will be removed to make space for new
	// ones. Value can range between 25 and 100.
	RetentionInMb *int32 `json:"retentionInMb,omitempty"`
}

// FileSystemTokenStore - The configuration settings of the storage of the tokens if a file system is used.
type FileSystemTokenStore struct {
	// The directory in which the tokens will be stored.
	Directory *string `json:"directory,omitempty"`
}

// FlowAccessControlConfiguration - The access control configuration.
type FlowAccessControlConfiguration struct {
	// The access control configuration for workflow actions.
	Actions *FlowAccessControlConfigurationPolicy `json:"actions,omitempty"`

	// The access control configuration for accessing workflow run contents.
	Contents *FlowAccessControlConfigurationPolicy `json:"contents,omitempty"`

	// The access control configuration for invoking workflow triggers.
	Triggers *FlowAccessControlConfigurationPolicy `json:"triggers,omitempty"`

	// The access control configuration for workflow management.
	WorkflowManagement *FlowAccessControlConfigurationPolicy `json:"workflowManagement,omitempty"`
}

// FlowAccessControlConfigurationPolicy - The access control configuration policy.
type FlowAccessControlConfigurationPolicy struct {
	// The allowed caller IP address ranges.
	AllowedCallerIPAddresses []*IPAddressRange `json:"allowedCallerIpAddresses,omitempty"`

	// The authentication policies for workflow.
	OpenAuthenticationPolicies *OpenAuthenticationAccessPolicies `json:"openAuthenticationPolicies,omitempty"`
}

// FlowEndpoints - The flow endpoints configuration.
type FlowEndpoints struct {
	// The access endpoint ip address.
	AccessEndpointIPAddresses []*IPAddress `json:"accessEndpointIpAddresses,omitempty"`

	// The outgoing ip address.
	OutgoingIPAddresses []*IPAddress `json:"outgoingIpAddresses,omitempty"`
}

// FlowEndpointsConfiguration - The endpoints configuration.
type FlowEndpointsConfiguration struct {
	// The connector endpoints.
	Connector *FlowEndpoints `json:"connector,omitempty"`

	// The workflow endpoints.
	Workflow *FlowEndpoints `json:"workflow,omitempty"`
}

// ForwardProxy - The configuration settings of a forward proxy used to make the requests.
type ForwardProxy struct {
	// The convention used to determine the url of the request made.
	Convention *ForwardProxyConvention `json:"convention,omitempty"`

	// The name of the header containing the host of the request.
	CustomHostHeaderName *string `json:"customHostHeaderName,omitempty"`

	// The name of the header containing the scheme of the request.
	CustomProtoHeaderName *string `json:"customProtoHeaderName,omitempty"`
}

type FrontEndConfiguration struct {
	Kind *FrontEndServiceType `json:"kind,omitempty"`
}

// FunctionAppMajorVersion - Function App stack major version.
type FunctionAppMajorVersion struct {
	// READ-ONLY; Function App stack major version (display only).
	DisplayText *string `json:"displayText,omitempty" azure:"ro"`

	// READ-ONLY; Minor versions associated with the major version.
	MinorVersions []*FunctionAppMinorVersion `json:"minorVersions,omitempty" azure:"ro"`

	// READ-ONLY; Function App stack major version name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// FunctionAppMinorVersion - Function App stack minor version.
type FunctionAppMinorVersion struct {
	// READ-ONLY; Function App stack (display only).
	DisplayText *string `json:"displayText,omitempty" azure:"ro"`

	// READ-ONLY; Settings associated with the minor version.
	StackSettings *FunctionAppRuntimes `json:"stackSettings,omitempty" azure:"ro"`

	// READ-ONLY; Function App stack name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// FunctionAppRuntimeSettings - Function App runtime settings.
type FunctionAppRuntimeSettings struct {
	// READ-ONLY; Application Insights settings associated with the minor version.
	AppInsightsSettings *AppInsightsWebAppStackSettings `json:"appInsightsSettings,omitempty" azure:"ro"`

	// READ-ONLY; Application settings associated with the minor version.
	AppSettingsDictionary map[string]*string `json:"appSettingsDictionary,omitempty" azure:"ro"`

	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty" azure:"ro"`

	// READ-ONLY; GitHub Actions settings associated with the minor version.
	GitHubActionSettings *GitHubActionWebAppStackSettings `json:"gitHubActionSettings,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool `json:"isAutoUpdate,omitempty" azure:"ro"`

	// READ-ONLY; true if the minor version the default; otherwise, false.
	IsDefault *bool `json:"isDefault,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool `json:"isDeprecated,omitempty" azure:"ro"`

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool `json:"isEarlyAccess,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool `json:"isHidden,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool `json:"isPreview,omitempty" azure:"ro"`

	// READ-ONLY; true if remote debugging is supported for the stack; otherwise, false.
	RemoteDebuggingSupported *bool `json:"remoteDebuggingSupported,omitempty" azure:"ro"`

	// READ-ONLY; Function App stack minor version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty" azure:"ro"`

	// READ-ONLY; Configuration settings associated with the minor version.
	SiteConfigPropertiesDictionary *SiteConfigPropertiesDictionary `json:"siteConfigPropertiesDictionary,omitempty" azure:"ro"`

	// READ-ONLY; List of supported Functions extension versions.
	SupportedFunctionsExtensionVersions []*string `json:"supportedFunctionsExtensionVersions,omitempty" azure:"ro"`
}

// FunctionAppRuntimes - Function App stack runtimes.
type FunctionAppRuntimes struct {
	// READ-ONLY; Linux-specific settings associated with the minor version.
	LinuxRuntimeSettings *FunctionAppRuntimeSettings `json:"linuxRuntimeSettings,omitempty" azure:"ro"`

	// READ-ONLY; Windows-specific settings associated with the minor version.
	WindowsRuntimeSettings *FunctionAppRuntimeSettings `json:"windowsRuntimeSettings,omitempty" azure:"ro"`
}

// FunctionAppStack - Function App Stack.
type FunctionAppStack struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// FunctionAppStack resource specific properties
	Properties *FunctionAppStackProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Function App stack location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FunctionAppStackCollection - Collection of Function app Stacks
type FunctionAppStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*FunctionAppStack `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FunctionAppStackProperties - FunctionAppStack resource specific properties
type FunctionAppStackProperties struct {
	// READ-ONLY; Function App stack (display only).
	DisplayText *string `json:"displayText,omitempty" azure:"ro"`

	// READ-ONLY; List of major versions available.
	MajorVersions []*FunctionAppMajorVersion `json:"majorVersions,omitempty" azure:"ro"`

	// READ-ONLY; Function App stack preferred OS.
	PreferredOs *StackPreferredOs `json:"preferredOs,omitempty" azure:"ro"`

	// READ-ONLY; Function App stack name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// FunctionEnvelope - Function information.
type FunctionEnvelope struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// FunctionEnvelope resource specific properties
	Properties *FunctionEnvelopeProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FunctionEnvelopeCollection - Collection of Kudu function information elements.
type FunctionEnvelopeCollection struct {
	// REQUIRED; Collection of resources.
	Value []*FunctionEnvelope `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// FunctionEnvelopeProperties - FunctionEnvelope resource specific properties
type FunctionEnvelopeProperties struct {
	// Config information.
	Config interface{} `json:"config,omitempty"`

	// Config URI.
	ConfigHref *string `json:"config_href,omitempty"`

	// File list.
	Files map[string]*string `json:"files,omitempty"`

	// Function App ID.
	FunctionAppID *string `json:"function_app_id,omitempty"`

	// Function URI.
	Href *string `json:"href,omitempty"`

	// The invocation URL
	InvokeURLTemplate *string `json:"invoke_url_template,omitempty"`

	// Gets or sets a value indicating whether the function is disabled
	IsDisabled *bool `json:"isDisabled,omitempty"`

	// The function language
	Language *string `json:"language,omitempty"`

	// Script URI.
	ScriptHref *string `json:"script_href,omitempty"`

	// Script root path URI.
	ScriptRootPathHref *string `json:"script_root_path_href,omitempty"`

	// Secrets file URI.
	SecretsFileHref *string `json:"secrets_file_href,omitempty"`

	// Test data used when testing via the Azure Portal.
	TestData *string `json:"test_data,omitempty"`

	// Test data URI.
	TestDataHref *string `json:"test_data_href,omitempty"`
}

// FunctionSecrets - Function secrets.
type FunctionSecrets struct {
	// Secret key.
	Key *string `json:"key,omitempty"`

	// Trigger URL.
	TriggerURL *string `json:"trigger_url,omitempty"`
}

// GeoRegion - Geographical region.
type GeoRegion struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// GeoRegion resource specific properties
	Properties *GeoRegionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GeoRegionCollection - Collection of geographical regions.
type GeoRegionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*GeoRegion `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// GeoRegionProperties - GeoRegion resource specific properties
type GeoRegionProperties struct {
	// READ-ONLY; Region description.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Display name for region.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Display name for region.
	OrgDomain *string `json:"orgDomain,omitempty" azure:"ro"`
}

// GitHub - The configuration settings of the GitHub provider.
type GitHub struct {
	// false if the GitHub provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the GitHub provider.
	Registration *ClientRegistration `json:"registration,omitempty"`
}

// GitHubActionCodeConfiguration - The GitHub action code configuration.
type GitHubActionCodeConfiguration struct {
	// Runtime stack is used to determine the workflow file content for code base apps.
	RuntimeStack *string `json:"runtimeStack,omitempty"`

	// Runtime version is used to determine what build version to set in the workflow file.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// GitHubActionConfiguration - The GitHub action configuration.
type GitHubActionConfiguration struct {
	// GitHub Action code configuration.
	CodeConfiguration *GitHubActionCodeConfiguration `json:"codeConfiguration,omitempty"`

	// GitHub Action container configuration.
	ContainerConfiguration *GitHubActionContainerConfiguration `json:"containerConfiguration,omitempty"`

	// Workflow option to determine whether the workflow file should be generated and written to the repository.
	GenerateWorkflowFile *bool `json:"generateWorkflowFile,omitempty"`

	// This will help determine the workflow configuration to select.
	IsLinux *bool `json:"isLinux,omitempty"`
}

// GitHubActionContainerConfiguration - The GitHub action container configuration.
type GitHubActionContainerConfiguration struct {
	// The image name for the build.
	ImageName *string `json:"imageName,omitempty"`

	// The password used to upload the image to the container registry.
	Password *string `json:"password,omitempty"`

	// The server URL for the container registry where the build will be hosted.
	ServerURL *string `json:"serverUrl,omitempty"`

	// The username used to upload the image to the container registry.
	Username *string `json:"username,omitempty"`
}

// GitHubActionWebAppStackSettings - GitHub Actions Web App stack settings.
type GitHubActionWebAppStackSettings struct {
	// READ-ONLY; true if GitHub Actions is supported for the stack; otherwise, false.
	IsSupported *bool `json:"isSupported,omitempty" azure:"ro"`

	// READ-ONLY; The minor version that is supported for GitHub Actions.
	SupportedVersion *string `json:"supportedVersion,omitempty" azure:"ro"`
}

// GithubToken - Github access token for Appservice CLI github integration.
type GithubToken struct {
	// Github access token for Appservice CLI github integration
	AccessToken *string `json:"accessToken,omitempty"`

	// Error message if unable to get token
	ErrorMessage *string `json:"errorMessage,omitempty"`

	// True if valid github token received, False otherwise
	GotToken *bool `json:"gotToken,omitempty"`

	// Scope of the github access token
	Scope *string `json:"scope,omitempty"`

	// token type
	TokenType *string `json:"tokenType,omitempty"`
}

// GithubTokenRequest - Appservice Github token request content.
type GithubTokenRequest struct {
	// REQUIRED; Code string to exchange for Github Access token
	Code *string `json:"code,omitempty"`

	// REQUIRED; State string used for verification.
	State *string `json:"state,omitempty"`
}

// GlobalClientGetDeletedWebAppOptions contains the optional parameters for the GlobalClient.GetDeletedWebApp method.
type GlobalClientGetDeletedWebAppOptions struct {
	// placeholder for future optional parameters
}

// GlobalClientGetDeletedWebAppSnapshotsOptions contains the optional parameters for the GlobalClient.GetDeletedWebAppSnapshots
// method.
type GlobalClientGetDeletedWebAppSnapshotsOptions struct {
	// placeholder for future optional parameters
}

// GlobalClientGetSubscriptionOperationWithAsyncResponseOptions contains the optional parameters for the GlobalClient.GetSubscriptionOperationWithAsyncResponse
// method.
type GlobalClientGetSubscriptionOperationWithAsyncResponseOptions struct {
	// placeholder for future optional parameters
}

// GlobalCsmSKUDescription - A Global SKU Description.
type GlobalCsmSKUDescription struct {
	// Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// Min, max, and default scale values of the SKU.
	Capacity *SKUCapacity `json:"capacity,omitempty"`

	// Family code of the resource SKU.
	Family *string `json:"family,omitempty"`

	// Locations of the SKU.
	Locations []*string `json:"locations,omitempty"`

	// Name of the resource SKU.
	Name *string `json:"name,omitempty"`

	// Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`

	// Service Tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
}

// GlobalValidation - The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
type GlobalValidation struct {
	// The paths for which unauthenticated flow would not be redirected to the login page.
	ExcludedPaths []*string `json:"excludedPaths,omitempty"`

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	RedirectToProvider *string `json:"redirectToProvider,omitempty"`

	// true if the authentication flow is required any request is made; otherwise, false.
	RequireAuthentication *bool `json:"requireAuthentication,omitempty"`

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientActionV2 `json:"unauthenticatedClientAction,omitempty"`
}

// Google - The configuration settings of the Google provider.
type Google struct {
	// false if the Google provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the Google provider.
	Registration *ClientRegistration `json:"registration,omitempty"`

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AllowedAudiencesValidation `json:"validation,omitempty"`
}

// HTTPLogsConfig - Http logs configuration.
type HTTPLogsConfig struct {
	// Http logs to azure blob storage configuration.
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`

	// Http logs to file system configuration.
	FileSystem *FileSystemHTTPLogsConfig `json:"fileSystem,omitempty"`
}

// HTTPScaleRule - Container App container Custom scaling rule.
type HTTPScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Metadata properties to describe http scale rule.
	Metadata map[string]*string `json:"metadata,omitempty"`
}

// HTTPSettings - The configuration settings of the HTTP requests for authentication and authorization requests made against
// App Service Authentication/Authorization.
type HTTPSettings struct {
	// The configuration settings of a forward proxy used to make the requests.
	ForwardProxy *ForwardProxy `json:"forwardProxy,omitempty"`

	// false if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, true.
	RequireHTTPS *bool `json:"requireHttps,omitempty"`

	// The configuration settings of the paths HTTP requests.
	Routes *HTTPSettingsRoutes `json:"routes,omitempty"`
}

// HTTPSettingsRoutes - The configuration settings of the paths HTTP requests.
type HTTPSettingsRoutes struct {
	// The prefix that should precede all the authentication/authorization paths.
	APIPrefix *string `json:"apiPrefix,omitempty"`
}

// HandlerMapping - The IIS handler mappings used to define which handler processes HTTP requests with certain extension.
// For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
// extension.
type HandlerMapping struct {
	// Command-line arguments to be passed to the script processor.
	Arguments *string `json:"arguments,omitempty"`

	// Requests with this extension will be handled using the specified FastCGI application.
	Extension *string `json:"extension,omitempty"`

	// The absolute path to the FastCGI application.
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
}

// HostKeys - Functions host level keys.
type HostKeys struct {
	// Host level function keys.
	FunctionKeys map[string]*string `json:"functionKeys,omitempty"`

	// Secret key.
	MasterKey *string `json:"masterKey,omitempty"`

	// System keys.
	SystemKeys map[string]*string `json:"systemKeys,omitempty"`
}

// HostName - Details of a hostname derived from a domain.
type HostName struct {
	// Name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic
	// Manager name otherwise it will be the app name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`

	// Type of the Azure resource the hostname is assigned to.
	AzureResourceType *AzureResourceType `json:"azureResourceType,omitempty"`

	// Type of the DNS record.
	CustomHostNameDNSRecordType *CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`

	// Type of the hostname.
	HostNameType *HostNameType `json:"hostNameType,omitempty"`

	// Name of the hostname.
	Name *string `json:"name,omitempty"`

	// List of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic
	// Manager.
	SiteNames []*string `json:"siteNames,omitempty"`
}

// HostNameBinding - A hostname binding object.
type HostNameBinding struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HostNameBinding resource specific properties
	Properties *HostNameBindingProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HostNameBindingCollection - Collection of hostname bindings.
type HostNameBindingCollection struct {
	// REQUIRED; Collection of resources.
	Value []*HostNameBinding `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// HostNameBindingProperties - HostNameBinding resource specific properties
type HostNameBindingProperties struct {
	// Azure resource name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`

	// Azure resource type.
	AzureResourceType *AzureResourceType `json:"azureResourceType,omitempty"`

	// Custom DNS record type.
	CustomHostNameDNSRecordType *CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`

	// Fully qualified ARM domain resource URI.
	DomainID *string `json:"domainId,omitempty"`

	// Hostname type.
	HostNameType *HostNameType `json:"hostNameType,omitempty"`

	// SSL type
	SSLState *SSLState `json:"sslState,omitempty"`

	// App Service app name.
	SiteName *string `json:"siteName,omitempty"`

	// SSL certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`

	// READ-ONLY; Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty" azure:"ro"`
}

// HostNameSSLState - SSL-enabled hostname.
type HostNameSSLState struct {
	// Indicates whether the hostname is a standard or repository hostname.
	HostType *HostType `json:"hostType,omitempty"`

	// Hostname.
	Name *string `json:"name,omitempty"`

	// SSL type.
	SSLState *SSLState `json:"sslState,omitempty"`

	// SSL certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// Set to true to update existing hostname.
	ToUpdate *bool `json:"toUpdate,omitempty"`

	// Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty"`
}

// HostingEnvironmentDeploymentInfo - Information needed to create resources on an App Service Environment.
type HostingEnvironmentDeploymentInfo struct {
	// Location of the App Service Environment.
	Location *string `json:"location,omitempty"`

	// Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
}

// HostingEnvironmentDiagnostics - Diagnostics for an App Service Environment.
type HostingEnvironmentDiagnostics struct {
	// Diagnostics output.
	DiagnosticsOutput *string `json:"diagnosticsOutput,omitempty"`

	// Name/identifier of the diagnostics.
	Name *string `json:"name,omitempty"`
}

// HostingEnvironmentProfile - Specification for an App Service Environment to use for this resource.
type HostingEnvironmentProfile struct {
	// Resource ID of the App Service Environment.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Name of the App Service Environment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the App Service Environment.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnection - Hybrid Connection contract. This is used to configure a Hybrid Connection.
type HybridConnection struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HybridConnection resource specific properties
	Properties *HybridConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionCollection - Collection of hostname bindings.
type HybridConnectionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*HybridConnection `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// HybridConnectionKey - Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.
type HybridConnectionKey struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HybridConnectionKey resource specific properties
	Properties *HybridConnectionKeyProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionKeyProperties - HybridConnectionKey resource specific properties
type HybridConnectionKeyProperties struct {
	// READ-ONLY; The name of the send key.
	SendKeyName *string `json:"sendKeyName,omitempty" azure:"ro"`

	// READ-ONLY; The value of the send key.
	SendKeyValue *string `json:"sendKeyValue,omitempty" azure:"ro"`
}

// HybridConnectionLimits - Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.
type HybridConnectionLimits struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// HybridConnectionLimits resource specific properties
	Properties *HybridConnectionLimitsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// HybridConnectionLimitsProperties - HybridConnectionLimits resource specific properties
type HybridConnectionLimitsProperties struct {
	// READ-ONLY; The current number of Hybrid Connections.
	Current *int32 `json:"current,omitempty" azure:"ro"`

	// READ-ONLY; The maximum number of Hybrid Connections allowed.
	Maximum *int32 `json:"maximum,omitempty" azure:"ro"`
}

// HybridConnectionProperties - HybridConnection resource specific properties
type HybridConnectionProperties struct {
	// The hostname of the endpoint.
	Hostname *string `json:"hostname,omitempty"`

	// The port of the endpoint.
	Port *int32 `json:"port,omitempty"`

	// The ARM URI to the Service Bus relay.
	RelayArmURI *string `json:"relayArmUri,omitempty"`

	// The name of the Service Bus relay.
	RelayName *string `json:"relayName,omitempty"`

	// The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
	SendKeyName *string `json:"sendKeyName,omitempty"`

	// The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned normally,
	// use the POST /listKeys API instead.
	SendKeyValue *string `json:"sendKeyValue,omitempty"`

	// The name of the Service Bus namespace.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// The suffix for the service bus endpoint. By default this is .servicebus.windows.net
	ServiceBusSuffix *string `json:"serviceBusSuffix,omitempty"`
}

// IPAddress - The ip address.
type IPAddress struct {
	// The address.
	Address *string `json:"address,omitempty"`
}

// IPAddressRange - The ip address range.
type IPAddressRange struct {
	// The IP address range.
	AddressRange *string `json:"addressRange,omitempty"`
}

// IPSecurityRestriction - IP security restriction on an app.
type IPSecurityRestriction struct {
	// Allow or Deny access for this IP range.
	Action *string `json:"action,omitempty"`

	// IP restriction rule description.
	Description *string `json:"description,omitempty"`

	// IP restriction rule headers. X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
	// The matching logic is ..
	// * If the property is null or empty (default), all hosts(or lack of) are allowed.
	// * A value is compared using ordinal-ignore-case (excluding port number).
	// * Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
	// but not the root domain contoso.com or multi-level
	// foo.bar.contoso.com
	// * Unicode host names are allowed but are converted to Punycode for matching.
	// X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples). The matching logic
	// is ..
	// * If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
	// * If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
	// X-Azure-FDID and X-FD-HealthProbe. The matching logic is exact match.
	Headers map[string][]*string `json:"headers,omitempty"`

	// IP address the security restriction is valid for. It can be in form of pure ipv4 address (required SubnetMask property)
	// or CIDR notation such as ipv4/mask (leading bit match). For CIDR, SubnetMask
	// property must not be specified.
	IPAddress *string `json:"ipAddress,omitempty"`

	// IP restriction rule name.
	Name *string `json:"name,omitempty"`

	// Priority of IP restriction rule.
	Priority *int32 `json:"priority,omitempty"`

	// Subnet mask for the range of IP addresses the restriction is valid for.
	SubnetMask *string `json:"subnetMask,omitempty"`

	// (internal) Subnet traffic tag
	SubnetTrafficTag *int32 `json:"subnetTrafficTag,omitempty"`

	// Defines what this IP filter will be used for. This is to support IP filtering on proxies.
	Tag *IPFilterTag `json:"tag,omitempty"`

	// Virtual network resource id
	VnetSubnetResourceID *string `json:"vnetSubnetResourceId,omitempty"`

	// (internal) Vnet traffic tag
	VnetTrafficTag *int32 `json:"vnetTrafficTag,omitempty"`
}

// Identifier - A domain specific resource identifier.
type Identifier struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Identifier resource specific properties
	Properties *IdentifierProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IdentifierCollection - Collection of identifiers.
type IdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Identifier `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// IdentifierProperties - Identifier resource specific properties
type IdentifierProperties struct {
	// String representation of the identity.
	Value *string `json:"id,omitempty"`
}

// IdentityProviders - The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
type IdentityProviders struct {
	// The configuration settings of the Apple provider.
	Apple *Apple `json:"apple,omitempty"`

	// The configuration settings of the Azure Active directory provider.
	AzureActiveDirectory *AzureActiveDirectory `json:"azureActiveDirectory,omitempty"`

	// The configuration settings of the Azure Static Web Apps provider.
	AzureStaticWebApps *AzureStaticWebApps `json:"azureStaticWebApps,omitempty"`

	// The map of the name of the alias of each custom Open ID Connect provider to the configuration settings of the custom Open
	// ID Connect provider.
	CustomOpenIDConnectProviders map[string]*CustomOpenIDConnectProvider `json:"customOpenIdConnectProviders,omitempty"`

	// The configuration settings of the Facebook provider.
	Facebook *Facebook `json:"facebook,omitempty"`

	// The configuration settings of the GitHub provider.
	GitHub *GitHub `json:"gitHub,omitempty"`

	// The configuration settings of the Google provider.
	Google *Google `json:"google,omitempty"`

	// The configuration settings of the legacy Microsoft Account provider.
	LegacyMicrosoftAccount *LegacyMicrosoftAccount `json:"legacyMicrosoftAccount,omitempty"`

	// The configuration settings of the Twitter provider.
	Twitter *Twitter `json:"twitter,omitempty"`
}

// InboundEnvironmentEndpoint - The IP Addresses and Ports that require inbound network access to and within the subnet of
// the App Service Environment.
type InboundEnvironmentEndpoint struct {
	// Short text describing the purpose of the network traffic.
	Description *string `json:"description,omitempty"`

	// The IP addresses that network traffic will originate from in cidr notation.
	Endpoints []*string `json:"endpoints,omitempty"`

	// The ports that network traffic will arrive to the App Service Environment at.
	Ports []*string `json:"ports,omitempty"`
}

// InboundEnvironmentEndpointCollection - Collection of Inbound Environment Endpoints
type InboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*InboundEnvironmentEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// Ingress - Container App Ingress configuration.
type Ingress struct {
	// Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS
	// connections
	AllowInsecure *bool `json:"allowInsecure,omitempty"`

	// Bool indicating if app exposes an external http endpoint
	External *bool `json:"external,omitempty"`

	// Target Port in containers for traffic from ingress
	TargetPort *int32           `json:"targetPort,omitempty"`
	Traffic    []*TrafficWeight `json:"traffic,omitempty"`

	// Ingress transport protocol
	Transport *IngressTransportMethod `json:"transport,omitempty"`

	// READ-ONLY; Hostname.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// JSONSchema - The JSON schema.
type JSONSchema struct {
	// The JSON content.
	Content *string `json:"content,omitempty"`

	// The JSON title.
	Title *string `json:"title,omitempty"`
}

// JwtClaimChecks - The configuration settings of the checks that should be made while validating the JWT Claims.
type JwtClaimChecks struct {
	// The list of the allowed client applications.
	AllowedClientApplications []*string `json:"allowedClientApplications,omitempty"`

	// The list of the allowed groups.
	AllowedGroups []*string `json:"allowedGroups,omitempty"`
}

// KeyInfo - Function key info.
type KeyInfo struct {
	// Key name
	Name *string `json:"name,omitempty"`

	// Key value
	Value *string `json:"value,omitempty"`
}

type KeyValuePairStringObject struct {
	// READ-ONLY
	Key *string `json:"key,omitempty" azure:"ro"`

	// READ-ONLY; Anything
	Value interface{} `json:"value,omitempty" azure:"ro"`
}

// KubeEnvironment - A Kubernetes cluster specialized for web workloads by Azure App Service
type KubeEnvironment struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Extended Location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// KubeEnvironment resource specific properties
	Properties *KubeEnvironmentProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KubeEnvironmentCollection - Collection of Kubernetes Environments
type KubeEnvironmentCollection struct {
	// REQUIRED; Collection of resources.
	Value []*KubeEnvironment `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// KubeEnvironmentPatchResource - ARM resource for a KubeEnvironment when patching
type KubeEnvironmentPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// KubeEnvironmentPatchResource resource specific properties
	Properties *KubeEnvironmentPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KubeEnvironmentPatchResourceProperties - KubeEnvironmentPatchResource resource specific properties
type KubeEnvironmentPatchResourceProperties struct {
	AksResourceID *string `json:"aksResourceID,omitempty"`

	// Cluster configuration which enables the log daemon to export app logs to a destination. Currently only "log-analytics"
	// is supported
	AppLogsConfiguration *AppLogsConfiguration `json:"appLogsConfiguration,omitempty"`

	// Cluster configuration which determines the ARC cluster components types. Eg: Choosing between BuildService kind, FrontEnd
	// Service ArtifactsStorageType etc.
	ArcConfiguration *ArcConfiguration `json:"arcConfiguration,omitempty"`

	// Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
	ContainerAppsConfiguration *ContainerAppsConfiguration `json:"containerAppsConfiguration,omitempty"`

	// Only visible within Vnet/Subnet
	InternalLoadBalancerEnabled *bool `json:"internalLoadBalancerEnabled,omitempty"`

	// Static IP of the KubeEnvironment
	StaticIP *string `json:"staticIp,omitempty"`

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string `json:"defaultDomain,omitempty" azure:"ro"`

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string `json:"deploymentErrors,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Kubernetes Environment.
	ProvisioningState *KubeEnvironmentProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// KubeEnvironmentProfile - Specification for a Kubernetes Environment to use for this resource.
type KubeEnvironmentProfile struct {
	// Resource ID of the Kubernetes Environment.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Name of the Kubernetes Environment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the Kubernetes Environment.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// KubeEnvironmentProperties - KubeEnvironment resource specific properties
type KubeEnvironmentProperties struct {
	AksResourceID *string `json:"aksResourceID,omitempty"`

	// Cluster configuration which enables the log daemon to export app logs to a destination. Currently only "log-analytics"
	// is supported
	AppLogsConfiguration *AppLogsConfiguration `json:"appLogsConfiguration,omitempty"`

	// Cluster configuration which determines the ARC cluster components types. Eg: Choosing between BuildService kind, FrontEnd
	// Service ArtifactsStorageType etc.
	ArcConfiguration *ArcConfiguration `json:"arcConfiguration,omitempty"`

	// Cluster configuration for Container Apps Environments to configure Dapr Instrumentation Key and VNET Configuration
	ContainerAppsConfiguration *ContainerAppsConfiguration `json:"containerAppsConfiguration,omitempty"`

	// Type of Kubernetes Environment. Only supported for Container App Environments with value as Managed
	EnvironmentType *string `json:"environmentType,omitempty"`

	// Only visible within Vnet/Subnet
	InternalLoadBalancerEnabled *bool `json:"internalLoadBalancerEnabled,omitempty"`

	// Static IP of the KubeEnvironment
	StaticIP *string `json:"staticIp,omitempty"`

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string `json:"defaultDomain,omitempty" azure:"ro"`

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string `json:"deploymentErrors,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Kubernetes Environment.
	ProvisioningState *KubeEnvironmentProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// KubeEnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the KubeEnvironmentsClient.BeginCreateOrUpdate
// method.
type KubeEnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KubeEnvironmentsClientBeginDeleteOptions contains the optional parameters for the KubeEnvironmentsClient.BeginDelete method.
type KubeEnvironmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// KubeEnvironmentsClientGetOptions contains the optional parameters for the KubeEnvironmentsClient.Get method.
type KubeEnvironmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// KubeEnvironmentsClientListByResourceGroupOptions contains the optional parameters for the KubeEnvironmentsClient.ListByResourceGroup
// method.
type KubeEnvironmentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// KubeEnvironmentsClientListBySubscriptionOptions contains the optional parameters for the KubeEnvironmentsClient.ListBySubscription
// method.
type KubeEnvironmentsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// KubeEnvironmentsClientUpdateOptions contains the optional parameters for the KubeEnvironmentsClient.Update method.
type KubeEnvironmentsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// LegacyMicrosoftAccount - The configuration settings of the legacy Microsoft Account provider.
type LegacyMicrosoftAccount struct {
	// false if the legacy Microsoft Account provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the legacy Microsoft Account provider.
	Registration *ClientRegistration `json:"registration,omitempty"`

	// The configuration settings of the legacy Microsoft Account provider token validation flow.
	Validation *AllowedAudiencesValidation `json:"validation,omitempty"`
}

// LinuxJavaContainerSettings - Linux Java Container settings.
type LinuxJavaContainerSettings struct {
	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool `json:"isAutoUpdate,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool `json:"isDeprecated,omitempty" azure:"ro"`

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool `json:"isEarlyAccess,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool `json:"isHidden,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool `json:"isPreview,omitempty" azure:"ro"`

	// READ-ONLY; Java 11 version (runtime only).
	Java11Runtime *string `json:"java11Runtime,omitempty" azure:"ro"`

	// READ-ONLY; Java 8 version (runtime only).
	Java8Runtime *string `json:"java8Runtime,omitempty" azure:"ro"`
}

// LocalizableString - Localizable string object containing the name and a localized value.
type LocalizableString struct {
	// Localized name.
	LocalizedValue *string `json:"localizedValue,omitempty"`

	// Non-localized name.
	Value *string `json:"value,omitempty"`
}

type LogAnalyticsConfiguration struct {
	CustomerID *string `json:"customerId,omitempty"`
	SharedKey  *string `json:"sharedKey,omitempty"`
}

// LogSpecification - Log Definition of a single resource metric.
type LogSpecification struct {
	BlobDuration     *string `json:"blobDuration,omitempty"`
	DisplayName      *string `json:"displayName,omitempty"`
	LogFilterPattern *string `json:"logFilterPattern,omitempty"`
	Name             *string `json:"name,omitempty"`
}

// Login - The configuration settings of the login flow of users using App Service Authentication/Authorization.
type Login struct {
	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string `json:"allowedExternalRedirectUrls,omitempty"`

	// The configuration settings of the session cookie's expiration.
	CookieExpiration *CookieExpiration `json:"cookieExpiration,omitempty"`

	// The configuration settings of the nonce used in the login flow.
	Nonce *Nonce `json:"nonce,omitempty"`

	// true if the fragments from the request are preserved after the login request is made; otherwise, false.
	PreserveURLFragmentsForLogins *bool `json:"preserveUrlFragmentsForLogins,omitempty"`

	// The routes that specify the endpoints used for login and logout requests.
	Routes *LoginRoutes `json:"routes,omitempty"`

	// The configuration settings of the token store.
	TokenStore *TokenStore `json:"tokenStore,omitempty"`
}

// LoginRoutes - The routes that specify the endpoints used for login and logout requests.
type LoginRoutes struct {
	// The endpoint at which a logout request should be made.
	LogoutEndpoint *string `json:"logoutEndpoint,omitempty"`
}

// LoginScopes - The configuration settings of the login flow, including the scopes that should be requested.
type LoginScopes struct {
	// A list of the scopes that should be requested while authenticating.
	Scopes []*string `json:"scopes,omitempty"`
}

// MSDeploy ARM PUT information
type MSDeploy struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *MSDeployCore `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSDeployCore - MSDeploy ARM PUT core information
type MSDeployCore struct {
	// Sets the AppOffline rule while the MSDeploy operation executes. Setting is false by default.
	AppOffline *bool `json:"appOffline,omitempty"`

	// SQL Connection String
	ConnectionString *string `json:"connectionString,omitempty"`

	// Database Type
	DbType *string `json:"dbType,omitempty"`

	// Package URI
	PackageURI *string `json:"packageUri,omitempty"`

	// MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
	SetParameters map[string]*string `json:"setParameters,omitempty"`

	// URI of MSDeploy Parameters file. Must not be set if SetParameters is used.
	SetParametersXMLFileURI *string `json:"setParametersXmlFileUri,omitempty"`

	// Controls whether the MSDeploy operation skips the AppData directory. If set to true, the existing AppData directory on
	// the destination will not be deleted, and any App_Data directory in the source
	// will be ignored. Setting is false by default.
	SkipAppData *bool `json:"skipAppData,omitempty"`
}

// MSDeployLog - MSDeploy log
type MSDeployLog struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MSDeployLog resource specific properties
	Properties *MSDeployLogProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSDeployLogEntry - MSDeploy log entry
type MSDeployLogEntry struct {
	// READ-ONLY; Log entry message
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of log entry
	Time *time.Time `json:"time,omitempty" azure:"ro"`

	// READ-ONLY; Log entry type
	Type *MSDeployLogEntryType `json:"type,omitempty" azure:"ro"`
}

// MSDeployLogProperties - MSDeployLog resource specific properties
type MSDeployLogProperties struct {
	// READ-ONLY; List of log entry messages
	Entries []*MSDeployLogEntry `json:"entries,omitempty" azure:"ro"`
}

// MSDeployStatus - MSDeploy ARM response
type MSDeployStatus struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MSDeployStatus resource specific properties
	Properties *MSDeployStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MSDeployStatusProperties - MSDeployStatus resource specific properties
type MSDeployStatusProperties struct {
	// READ-ONLY; Whether the deployment operation has completed
	Complete *bool `json:"complete,omitempty" azure:"ro"`

	// READ-ONLY; Username of deployer
	Deployer *string `json:"deployer,omitempty" azure:"ro"`

	// READ-ONLY; End time of deploy operation
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state
	ProvisioningState *MSDeployProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Start time of deploy operation
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`
}

// ManagedServiceIdentity - Managed service identity.
type ManagedServiceIdentity struct {
	// Type of managed service identity.
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The list of user assigned identities associated with the resource. The user identity dictionary key references will be
	// ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; Principal Id of managed service identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Tenant of managed service identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MetricAvailability - Retention policy of a resource metric.
type MetricAvailability struct {
	BlobDuration *string `json:"blobDuration,omitempty"`
	TimeGrain    *string `json:"timeGrain,omitempty"`
}

// MetricSpecification - Definition of a single resource metric.
type MetricSpecification struct {
	AggregationType                  *string               `json:"aggregationType,omitempty"`
	Availabilities                   []*MetricAvailability `json:"availabilities,omitempty"`
	Category                         *string               `json:"category,omitempty"`
	Dimensions                       []*Dimension          `json:"dimensions,omitempty"`
	DisplayDescription               *string               `json:"displayDescription,omitempty"`
	DisplayName                      *string               `json:"displayName,omitempty"`
	EnableRegionalMdmAccount         *bool                 `json:"enableRegionalMdmAccount,omitempty"`
	FillGapWithZero                  *bool                 `json:"fillGapWithZero,omitempty"`
	IsInternal                       *bool                 `json:"isInternal,omitempty"`
	MetricFilterPattern              *string               `json:"metricFilterPattern,omitempty"`
	Name                             *string               `json:"name,omitempty"`
	SourceMdmAccount                 *string               `json:"sourceMdmAccount,omitempty"`
	SourceMdmNamespace               *string               `json:"sourceMdmNamespace,omitempty"`
	SupportedAggregationTypes        []*string             `json:"supportedAggregationTypes,omitempty"`
	SupportedTimeGrainTypes          []*string             `json:"supportedTimeGrainTypes,omitempty"`
	SupportsInstanceLevelAggregation *bool                 `json:"supportsInstanceLevelAggregation,omitempty"`
	Unit                             *string               `json:"unit,omitempty"`
}

// MigrateMySQLRequest - MySQL migration request.
type MigrateMySQLRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MigrateMySqlRequest resource specific properties
	Properties *MigrateMySQLRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrateMySQLRequestProperties - MigrateMySqlRequest resource specific properties
type MigrateMySQLRequestProperties struct {
	// REQUIRED; Connection string to the remote MySQL database.
	ConnectionString *string `json:"connectionString,omitempty"`

	// REQUIRED; The type of migration operation to be done
	MigrationType *MySQLMigrationType `json:"migrationType,omitempty"`
}

// MigrateMySQLStatus - MySQL migration status.
type MigrateMySQLStatus struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// MigrateMySqlStatus resource specific properties
	Properties *MigrateMySQLStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MigrateMySQLStatusProperties - MigrateMySqlStatus resource specific properties
type MigrateMySQLStatusProperties struct {
	// READ-ONLY; True if the web app has in app MySql enabled
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Status of the migration task.
	MigrationOperationStatus *OperationStatus `json:"migrationOperationStatus,omitempty" azure:"ro"`

	// READ-ONLY; Operation ID for the migration task.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// NameIdentifier - Identifies an object.
type NameIdentifier struct {
	// Name of the object.
	Name *string `json:"name,omitempty"`
}

// NameIdentifierCollection - Collection of domain name identifiers.
type NameIdentifierCollection struct {
	// REQUIRED; Collection of resources.
	Value []*NameIdentifier `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// NameValuePair - Name value pair.
type NameValuePair struct {
	// Pair name.
	Name *string `json:"name,omitempty"`

	// Pair value.
	Value *string `json:"value,omitempty"`
}

// NetworkFeatures - Full view of network features for an app (presently VNET integration and Hybrid Connections).
type NetworkFeatures struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// NetworkFeatures resource specific properties
	Properties *NetworkFeaturesProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// NetworkFeaturesProperties - NetworkFeatures resource specific properties
type NetworkFeaturesProperties struct {
	// READ-ONLY; The Hybrid Connections summary view.
	HybridConnections []*RelayServiceConnectionEntity `json:"hybridConnections,omitempty" azure:"ro"`

	// READ-ONLY; The Hybrid Connection V2 (Service Bus) view.
	HybridConnectionsV2 []*HybridConnection `json:"hybridConnectionsV2,omitempty" azure:"ro"`

	// READ-ONLY; The Virtual Network summary view.
	VirtualNetworkConnection *VnetInfo `json:"virtualNetworkConnection,omitempty" azure:"ro"`

	// READ-ONLY; The Virtual Network name.
	VirtualNetworkName *string `json:"virtualNetworkName,omitempty" azure:"ro"`
}

// NetworkTrace - Network trace
type NetworkTrace struct {
	// Detailed message of a network trace operation, e.g. error message in case of failure.
	Message *string `json:"message,omitempty"`

	// Local file path for the captured network trace file.
	Path *string `json:"path,omitempty"`

	// Current status of the network trace operation, same as Operation.Status (InProgress/Succeeded/Failed).
	Status *string `json:"status,omitempty"`
}

// Nonce - The configuration settings of the nonce used in the login flow.
type Nonce struct {
	// The time after the request is made when the nonce should expire.
	NonceExpirationInterval *string `json:"nonceExpirationInterval,omitempty"`

	// false if the nonce should not be validated while completing the login flow; otherwise, true.
	ValidateNonce *bool `json:"validateNonce,omitempty"`
}

// OpenAuthenticationAccessPolicies - AuthenticationPolicy of type Open.
type OpenAuthenticationAccessPolicies struct {
	// Open authentication policies.
	Policies map[string]*OpenAuthenticationAccessPolicy `json:"policies,omitempty"`
}

// OpenAuthenticationAccessPolicy - Open authentication access policy defined by user.
type OpenAuthenticationAccessPolicy struct {
	// The access policy claims.
	Claims []*OpenAuthenticationPolicyClaim `json:"claims,omitempty"`

	// Type of provider for OAuth.
	Type *OpenAuthenticationProviderType `json:"type,omitempty"`
}

// OpenAuthenticationPolicyClaim - Open authentication policy claim.
type OpenAuthenticationPolicyClaim struct {
	// The name of the claim.
	Name *string `json:"name,omitempty"`

	// The value of the claim.
	Value *string `json:"value,omitempty"`
}

// OpenIDConnectClientCredential - The authentication client credentials of the custom Open ID Connect provider.
type OpenIDConnectClientCredential struct {
	// The app setting that contains the client secret for the custom Open ID Connect provider.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`

	// The method that should be used to authenticate the user.
	Method *string `json:"method,omitempty"`
}

// OpenIDConnectConfig - The configuration settings of the endpoints used for the custom Open ID Connect provider.
type OpenIDConnectConfig struct {
	// The endpoint to be used to make an authorization request.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`

	// The endpoint that provides the keys necessary to validate the token.
	CertificationURI *string `json:"certificationUri,omitempty"`

	// The endpoint that issues the token.
	Issuer *string `json:"issuer,omitempty"`

	// The endpoint to be used to request a token.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`

	// The endpoint that contains all the configuration endpoints for the provider.
	WellKnownOpenIDConfiguration *string `json:"wellKnownOpenIdConfiguration,omitempty"`
}

// OpenIDConnectLogin - The configuration settings of the login flow of the custom Open ID Connect provider.
type OpenIDConnectLogin struct {
	// The name of the claim that contains the users name.
	NameClaimType *string `json:"nameClaimType,omitempty"`

	// A list of the scopes that should be requested while authenticating.
	Scopes []*string `json:"scopes,omitempty"`
}

// OpenIDConnectRegistration - The configuration settings of the app registration for the custom Open ID Connect provider.
type OpenIDConnectRegistration struct {
	// The authentication credentials of the custom Open ID Connect provider.
	ClientCredential *OpenIDConnectClientCredential `json:"clientCredential,omitempty"`

	// The client id of the custom Open ID Connect provider.
	ClientID *string `json:"clientId,omitempty"`

	// The configuration settings of the endpoints used for the custom Open ID Connect provider.
	OpenIDConnectConfiguration *OpenIDConnectConfig `json:"openIdConnectConfiguration,omitempty"`
}

// Operation - An operation on a resource.
type Operation struct {
	// Time when operation has started.
	CreatedTime *time.Time `json:"createdTime,omitempty"`

	// Any errors associate with the operation.
	Errors []*ErrorEntity `json:"errors,omitempty"`

	// Time when operation will expire.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// Applicable only for stamp operation ids.
	GeoMasterOperationID *string `json:"geoMasterOperationId,omitempty"`

	// Operation ID.
	ID *string `json:"id,omitempty"`

	// Time when operation has been updated.
	ModifiedTime *time.Time `json:"modifiedTime,omitempty"`

	// Operation name.
	Name *string `json:"name,omitempty"`

	// The current status of the operation.
	Status *OperationStatus `json:"status,omitempty"`
}

// OperationResult - The operation result definition.
type OperationResult struct {
	// The workflow scope repetition code.
	Code *string `json:"code,omitempty"`

	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// The end time of the workflow scope repetition.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Anything
	Error          interface{} `json:"error,omitempty"`
	IterationCount *int32      `json:"iterationCount,omitempty"`

	// Gets the retry histories.
	RetryHistory []*RetryHistory `json:"retryHistory,omitempty"`

	// The start time of the workflow scope repetition.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the workflow scope repetition.
	Status *WorkflowStatus `json:"status,omitempty"`

	// READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// OperationResultProperties - The run operation result properties.
type OperationResultProperties struct {
	// The workflow scope repetition code.
	Code *string `json:"code,omitempty"`

	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// The end time of the workflow scope repetition.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Anything
	Error interface{} `json:"error,omitempty"`

	// The start time of the workflow scope repetition.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the workflow scope repetition.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// OutboundEnvironmentEndpoint - Endpoints accessed for a common purpose that the App Service Environment requires outbound
// network access to.
type OutboundEnvironmentEndpoint struct {
	// The type of service accessed by the App Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active
	// Directory.
	Category *string `json:"category,omitempty"`

	// The endpoints that the App Service Environment reaches the service at.
	Endpoints []*EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointCollection - Collection of Outbound Environment Endpoints
type OutboundEnvironmentEndpointCollection struct {
	// REQUIRED; Collection of resources.
	Value []*OutboundEnvironmentEndpoint `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PerfMonCounterCollection - Collection of performance monitor counters.
type PerfMonCounterCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PerfMonResponse `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PerfMonResponse - Performance monitor API response.
type PerfMonResponse struct {
	// The response code.
	Code *string `json:"code,omitempty"`

	// The performance monitor counters.
	Data *PerfMonSet `json:"data,omitempty"`

	// The message.
	Message *string `json:"message,omitempty"`
}

// PerfMonSample - Performance monitor sample in a set.
type PerfMonSample struct {
	// Name of the server on which the measurement is made.
	InstanceName *string `json:"instanceName,omitempty"`

	// Point in time for which counter was measured.
	Time *time.Time `json:"time,omitempty"`

	// Value of counter at a certain time.
	Value *float64 `json:"value,omitempty"`
}

// PerfMonSet - Metric information.
type PerfMonSet struct {
	// End time of the period.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Unique key name of the counter.
	Name *string `json:"name,omitempty"`

	// Start time of the period.
	StartTime *time.Time `json:"startTime,omitempty"`

	// Presented time grain.
	TimeGrain *string `json:"timeGrain,omitempty"`

	// Collection of workers that are active during this time.
	Values []*PerfMonSample `json:"values,omitempty"`
}

// Plan - App Service plan.
type Plan struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Extended Location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AppServicePlan resource specific properties
	Properties *PlanProperties `json:"properties,omitempty"`

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PlanCollection - Collection of App Service plans.
type PlanCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Plan `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PlanPatchResource - ARM resource for a app service plan.
type PlanPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// AppServicePlanPatchResource resource specific properties
	Properties *PlanPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PlanPatchResourceProperties - AppServicePlanPatchResource resource specific properties
type PlanPatchResourceProperties struct {
	// ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
	ElasticScaleEnabled *bool `json:"elasticScaleEnabled,omitempty"`

	// The time when the server farm free offer expires.
	FreeOfferExpirationTime *time.Time `json:"freeOfferExpirationTime,omitempty"`

	// Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// If Hyper-V container app service plan true, false otherwise.
	HyperV *bool `json:"hyperV,omitempty"`

	// If true, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`

	// Obsolete: If Hyper-V container app service plan true, false otherwise.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Specification for the Kubernetes Environment to use for the App Service plan.
	KubeEnvironmentProfile *KubeEnvironmentProfile `json:"kubeEnvironmentProfile,omitempty"`

	// Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32 `json:"maximumElasticWorkerCount,omitempty"`

	// If true, apps assigned to this App Service plan can be scaled independently. If false, apps assigned to this App Service
	// plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`

	// If Linux app service plan true, false otherwise.
	Reserved *bool `json:"reserved,omitempty"`

	// The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *time.Time `json:"spotExpirationTime,omitempty"`

	// Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`

	// Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`

	// Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`

	// If true, this App Service Plan will perform availability zone balancing. If false, this App Service Plan will not perform
	// availability zone balancing.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances that are assigned to this App Service plan.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App Service Plan.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan status.
	Status *StatusOptions `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan subscription.
	Subscription *string `json:"subscription,omitempty" azure:"ro"`
}

// PlanProperties - AppServicePlan resource specific properties
type PlanProperties struct {
	// ServerFarm supports ElasticScale. Apps in this plan will scale as if the ServerFarm was ElasticPremium sku
	ElasticScaleEnabled *bool `json:"elasticScaleEnabled,omitempty"`

	// The time when the server farm free offer expires.
	FreeOfferExpirationTime *time.Time `json:"freeOfferExpirationTime,omitempty"`

	// Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// If Hyper-V container app service plan true, false otherwise.
	HyperV *bool `json:"hyperV,omitempty"`

	// If true, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`

	// Obsolete: If Hyper-V container app service plan true, false otherwise.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Specification for the Kubernetes Environment to use for the App Service plan.
	KubeEnvironmentProfile *KubeEnvironmentProfile `json:"kubeEnvironmentProfile,omitempty"`

	// Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32 `json:"maximumElasticWorkerCount,omitempty"`

	// If true, apps assigned to this App Service plan can be scaled independently. If false, apps assigned to this App Service
	// plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`

	// If Linux app service plan true, false otherwise.
	Reserved *bool `json:"reserved,omitempty"`

	// The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *time.Time `json:"spotExpirationTime,omitempty"`

	// Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`

	// Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`

	// Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`

	// If true, this App Service Plan will perform availability zone balancing. If false, this App Service Plan will not perform
	// availability zone balancing.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty" azure:"ro"`

	// READ-ONLY; The number of instances that are assigned to this App Service plan.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the App Service Plan.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan status.
	Status *StatusOptions `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; App Service plan subscription.
	Subscription *string `json:"subscription,omitempty" azure:"ro"`
}

// PlansClientBeginCreateOrUpdateOptions contains the optional parameters for the PlansClient.BeginCreateOrUpdate method.
type PlansClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PlansClientCreateOrUpdateVnetRouteOptions contains the optional parameters for the PlansClient.CreateOrUpdateVnetRoute
// method.
type PlansClientCreateOrUpdateVnetRouteOptions struct {
	// placeholder for future optional parameters
}

// PlansClientDeleteHybridConnectionOptions contains the optional parameters for the PlansClient.DeleteHybridConnection method.
type PlansClientDeleteHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// PlansClientDeleteOptions contains the optional parameters for the PlansClient.Delete method.
type PlansClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PlansClientDeleteVnetRouteOptions contains the optional parameters for the PlansClient.DeleteVnetRoute method.
type PlansClientDeleteVnetRouteOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetHybridConnectionOptions contains the optional parameters for the PlansClient.GetHybridConnection method.
type PlansClientGetHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetHybridConnectionPlanLimitOptions contains the optional parameters for the PlansClient.GetHybridConnectionPlanLimit
// method.
type PlansClientGetHybridConnectionPlanLimitOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetOptions contains the optional parameters for the PlansClient.Get method.
type PlansClientGetOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetRouteForVnetOptions contains the optional parameters for the PlansClient.GetRouteForVnet method.
type PlansClientGetRouteForVnetOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetServerFarmSKUsOptions contains the optional parameters for the PlansClient.GetServerFarmSKUs method.
type PlansClientGetServerFarmSKUsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetVnetFromServerFarmOptions contains the optional parameters for the PlansClient.GetVnetFromServerFarm method.
type PlansClientGetVnetFromServerFarmOptions struct {
	// placeholder for future optional parameters
}

// PlansClientGetVnetGatewayOptions contains the optional parameters for the PlansClient.GetVnetGateway method.
type PlansClientGetVnetGatewayOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListByResourceGroupOptions contains the optional parameters for the PlansClient.ListByResourceGroup method.
type PlansClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListCapabilitiesOptions contains the optional parameters for the PlansClient.ListCapabilities method.
type PlansClientListCapabilitiesOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListHybridConnectionKeysOptions contains the optional parameters for the PlansClient.ListHybridConnectionKeys
// method.
type PlansClientListHybridConnectionKeysOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListHybridConnectionsOptions contains the optional parameters for the PlansClient.ListHybridConnections method.
type PlansClientListHybridConnectionsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListOptions contains the optional parameters for the PlansClient.List method.
type PlansClientListOptions struct {
	// Specify true to return all App Service plan properties. The default is false, which returns a subset of the properties.
	// Retrieval of all properties may increase the API latency.
	Detailed *bool
}

// PlansClientListRoutesForVnetOptions contains the optional parameters for the PlansClient.ListRoutesForVnet method.
type PlansClientListRoutesForVnetOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListUsagesOptions contains the optional parameters for the PlansClient.ListUsages method.
type PlansClientListUsagesOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1'
	// or name.value eq 'Metric2').
	Filter *string
}

// PlansClientListVnetsOptions contains the optional parameters for the PlansClient.ListVnets method.
type PlansClientListVnetsOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListWebAppsByHybridConnectionOptions contains the optional parameters for the PlansClient.ListWebAppsByHybridConnection
// method.
type PlansClientListWebAppsByHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// PlansClientListWebAppsOptions contains the optional parameters for the PlansClient.ListWebApps method.
type PlansClientListWebAppsOptions struct {
	// Supported filter: $filter=state eq running. Returns only web apps that are currently running
	Filter *string
	// Skip to a web app in the list of webapps associated with app service plan. If specified, the resulting list will contain
	// web apps starting from (including) the skipToken. Otherwise, the resulting list
	// contains web apps from the start of the list
	SkipToken *string
	// List page size. If specified, results are paged.
	Top *string
}

// PlansClientRebootWorkerOptions contains the optional parameters for the PlansClient.RebootWorker method.
type PlansClientRebootWorkerOptions struct {
	// placeholder for future optional parameters
}

// PlansClientRestartWebAppsOptions contains the optional parameters for the PlansClient.RestartWebApps method.
type PlansClientRestartWebAppsOptions struct {
	// Specify true to perform a soft restart, applies the configuration settings and restarts the apps if necessary. The default
	// is false, which always restarts and reprovisions the apps
	SoftRestart *bool
}

// PlansClientUpdateOptions contains the optional parameters for the PlansClient.Update method.
type PlansClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// PlansClientUpdateVnetGatewayOptions contains the optional parameters for the PlansClient.UpdateVnetGateway method.
type PlansClientUpdateVnetGatewayOptions struct {
	// placeholder for future optional parameters
}

// PlansClientUpdateVnetRouteOptions contains the optional parameters for the PlansClient.UpdateVnetRoute method.
type PlansClientUpdateVnetRouteOptions struct {
	// placeholder for future optional parameters
}

// PremierAddOn - Premier add-on.
type PremierAddOn struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PremierAddOn resource specific properties
	Properties *PremierAddOnProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PremierAddOnOffer - Premier add-on offer.
type PremierAddOnOffer struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PremierAddOnOffer resource specific properties
	Properties *PremierAddOnOfferProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PremierAddOnOfferCollection - Collection of premier add-on offers.
type PremierAddOnOfferCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PremierAddOnOffer `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PremierAddOnOfferProperties - PremierAddOnOffer resource specific properties
type PremierAddOnOfferProperties struct {
	// Legal terms URL.
	LegalTermsURL *string `json:"legalTermsUrl,omitempty"`

	// Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`

	// Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`

	// Privacy policy URL.
	PrivacyPolicyURL *string `json:"privacyPolicyUrl,omitempty"`

	// Premier add on offer Product.
	Product *string `json:"product,omitempty"`

	// true if promotion code is required; otherwise, false.
	PromoCodeRequired *bool `json:"promoCodeRequired,omitempty"`

	// Premier add on offer Quota.
	Quota *int32 `json:"quota,omitempty"`

	// Premier add on SKU.
	SKU *string `json:"sku,omitempty"`

	// Premier add on offer Vendor.
	Vendor *string `json:"vendor,omitempty"`

	// App Service plans this offer is restricted to.
	WebHostingPlanRestrictions *AppServicePlanRestrictions `json:"webHostingPlanRestrictions,omitempty"`
}

// PremierAddOnPatchResource - ARM resource for a PremierAddOn.
type PremierAddOnPatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PremierAddOnPatchResource resource specific properties
	Properties *PremierAddOnPatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PremierAddOnPatchResourceProperties - PremierAddOnPatchResource resource specific properties
type PremierAddOnPatchResourceProperties struct {
	// Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`

	// Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`

	// Premier add on Product.
	Product *string `json:"product,omitempty"`

	// Premier add on SKU.
	SKU *string `json:"sku,omitempty"`

	// Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
}

// PremierAddOnProperties - PremierAddOn resource specific properties
type PremierAddOnProperties struct {
	// Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`

	// Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`

	// Premier add on Product.
	Product *string `json:"product,omitempty"`

	// Premier add on SKU.
	SKU *string `json:"sku,omitempty"`

	// Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
}

// PrivateAccess - Description of the parameters of Private Access for a Web Site.
type PrivateAccess struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PrivateAccess resource specific properties
	Properties *PrivateAccessProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateAccessProperties - PrivateAccess resource specific properties
type PrivateAccessProperties struct {
	// Whether private access is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`

	// The Virtual Networks (and subnets) allowed to access the site privately.
	VirtualNetworks []*PrivateAccessVirtualNetwork `json:"virtualNetworks,omitempty"`
}

// PrivateAccessSubnet - Description of a Virtual Network subnet that is useable for private site access.
type PrivateAccessSubnet struct {
	// The key (ID) of the subnet.
	Key *int32 `json:"key,omitempty"`

	// The name of the subnet.
	Name *string `json:"name,omitempty"`
}

// PrivateAccessVirtualNetwork - Description of a Virtual Network that is useable for private site access.
type PrivateAccessVirtualNetwork struct {
	// The key (ID) of the Virtual Network.
	Key *int32 `json:"key,omitempty"`

	// The name of the Virtual Network.
	Name *string `json:"name,omitempty"`

	// The ARM uri of the Virtual Network
	ResourceID *string `json:"resourceId,omitempty"`

	// A List of subnets that access is allowed to on this Virtual Network. An empty array (but not null) is interpreted to mean
	// that all subnets are allowed within this Virtual Network.
	Subnets []*PrivateAccessSubnet `json:"subnets,omitempty"`
}

type PrivateEndpointConnectionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*RemotePrivateEndpointConnectionARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PrivateLinkConnectionApprovalRequest - A request to approve or reject a private endpoint connection
type PrivateLinkConnectionApprovalRequest struct {
	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateLinkConnectionApprovalRequestResource - Private Endpoint Connection Approval ARM resource.
type PrivateLinkConnectionApprovalRequestResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *PrivateLinkConnectionApprovalRequest `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkConnectionState - The state of a private link connection
type PrivateLinkConnectionState struct {
	// ActionsRequired for a private link connection
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// Description of a private link connection
	Description *string `json:"description,omitempty"`

	// Status of a private link connection
	Status *string `json:"status,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// REQUIRED
	ID *string `json:"id,omitempty"`

	// REQUIRED; Name of a private link resource
	Name *string `json:"name,omitempty"`

	// REQUIRED; Properties of a private link resource
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// REQUIRED
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource
type PrivateLinkResourceProperties struct {
	// READ-ONLY; GroupId of a private link resource
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; RequiredMembers of a private link resource
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; RequiredZoneNames of a private link resource
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesWrapper - Wrapper for a collection of private link resources
type PrivateLinkResourcesWrapper struct {
	// REQUIRED
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// ProcessInfo - Process Information.
type ProcessInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ProcessInfo resource specific properties
	Properties *ProcessInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProcessInfoCollection - Collection of Kudu process information elements.
type ProcessInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProcessInfoProperties - ProcessInfo resource specific properties
type ProcessInfoProperties struct {
	// Child process list.
	Children []*string `json:"children,omitempty"`

	// Command line.
	CommandLine *string `json:"command_line,omitempty"`

	// Deployment name.
	DeploymentName *string `json:"deployment_name,omitempty"`

	// Description of process.
	Description *string `json:"description,omitempty"`

	// List of environment variables.
	EnvironmentVariables map[string]*string `json:"environment_variables,omitempty"`

	// File name of this process.
	FileName *string `json:"file_name,omitempty"`

	// Handle count.
	HandleCount *int32 `json:"handle_count,omitempty"`

	// HRef URI.
	Href *string `json:"href,omitempty"`

	// IIS Profile timeout (seconds).
	IisProfileTimeoutInSeconds *float64 `json:"iis_profile_timeout_in_seconds,omitempty"`

	// Is the IIS Profile running?
	IsIisProfileRunning *bool `json:"is_iis_profile_running,omitempty"`

	// Is profile running?
	IsProfileRunning *bool `json:"is_profile_running,omitempty"`

	// Is this the SCM site?
	IsScmSite *bool `json:"is_scm_site,omitempty"`

	// Is this a Web Job?
	IsWebjob *bool `json:"is_webjob,omitempty"`

	// Minidump URI.
	Minidump *string `json:"minidump,omitempty"`

	// Module count.
	ModuleCount *int32 `json:"module_count,omitempty"`

	// List of modules.
	Modules []*ProcessModuleInfo `json:"modules,omitempty"`

	// Non-paged system memory.
	NonPagedSystemMemory *int64 `json:"non_paged_system_memory,omitempty"`

	// List of open files.
	OpenFileHandles []*string `json:"open_file_handles,omitempty"`

	// Paged memory.
	PagedMemory *int64 `json:"paged_memory,omitempty"`

	// Paged system memory.
	PagedSystemMemory *int64 `json:"paged_system_memory,omitempty"`

	// Parent process.
	Parent *string `json:"parent,omitempty"`

	// Peak paged memory.
	PeakPagedMemory *int64 `json:"peak_paged_memory,omitempty"`

	// Peak virtual memory usage.
	PeakVirtualMemory *int64 `json:"peak_virtual_memory,omitempty"`

	// Peak working set.
	PeakWorkingSet *int64 `json:"peak_working_set,omitempty"`

	// Private memory size.
	PrivateMemory *int64 `json:"private_memory,omitempty"`

	// Privileged CPU time.
	PrivilegedCPUTime *string `json:"privileged_cpu_time,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Thread count.
	ThreadCount *int32 `json:"thread_count,omitempty"`

	// Thread list.
	Threads []*ProcessThreadInfo `json:"threads,omitempty"`

	// Time stamp.
	TimeStamp *time.Time `json:"time_stamp,omitempty"`

	// Total CPU time.
	TotalCPUTime *string `json:"total_cpu_time,omitempty"`

	// User CPU time.
	UserCPUTime *string `json:"user_cpu_time,omitempty"`

	// User name.
	UserName *string `json:"user_name,omitempty"`

	// Virtual memory size.
	VirtualMemory *int64 `json:"virtual_memory,omitempty"`

	// Working set.
	WorkingSet *int64 `json:"working_set,omitempty"`

	// READ-ONLY; ARM Identifier for deployment.
	Identifier *int32 `json:"identifier,omitempty" azure:"ro"`
}

// ProcessModuleInfo - Process Module Information.
type ProcessModuleInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ProcessModuleInfo resource specific properties
	Properties *ProcessModuleInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProcessModuleInfoCollection - Collection of Kudu thread information elements.
type ProcessModuleInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessModuleInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProcessModuleInfoProperties - ProcessModuleInfo resource specific properties
type ProcessModuleInfoProperties struct {
	// Base address. Used as module identifier in ARM resource URI.
	BaseAddress *string `json:"base_address,omitempty"`

	// File description.
	FileDescription *string `json:"file_description,omitempty"`

	// File name.
	FileName *string `json:"file_name,omitempty"`

	// File path.
	FilePath *string `json:"file_path,omitempty"`

	// File version.
	FileVersion *string `json:"file_version,omitempty"`

	// HRef URI.
	Href *string `json:"href,omitempty"`

	// Is debug?
	IsDebug *bool `json:"is_debug,omitempty"`

	// Module language (locale).
	Language *string `json:"language,omitempty"`

	// Module memory size.
	ModuleMemorySize *int32 `json:"module_memory_size,omitempty"`

	// Product name.
	Product *string `json:"product,omitempty"`

	// Product version.
	ProductVersion *string `json:"product_version,omitempty"`
}

// ProcessThreadInfo - Process Thread Information.
type ProcessThreadInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ProcessThreadInfo resource specific properties
	Properties *ProcessThreadInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProcessThreadInfoCollection - Collection of Kudu thread information elements.
type ProcessThreadInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ProcessThreadInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ProcessThreadInfoProperties - ProcessThreadInfo resource specific properties
type ProcessThreadInfoProperties struct {
	// Base priority.
	BasePriority *int32 `json:"base_priority,omitempty"`

	// Current thread priority.
	CurrentPriority *int32 `json:"current_priority,omitempty"`

	// HRef URI.
	Href *string `json:"href,omitempty"`

	// Thread priority level.
	PriorityLevel *string `json:"priority_level,omitempty"`

	// Process URI.
	Process *string `json:"process,omitempty"`

	// Start address.
	StartAddress *string `json:"start_address,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Thread state.
	State *string `json:"state,omitempty"`

	// Total processor time.
	TotalProcessorTime *string `json:"total_processor_time,omitempty"`

	// User processor time.
	UserProcessorTime *string `json:"user_processor_time,omitempty"`

	// Wait reason.
	WaitReason *string `json:"wait_reason,omitempty"`

	// READ-ONLY; Site extension ID.
	Identifier *int32 `json:"identifier,omitempty" azure:"ro"`
}

// ProviderClientGetAvailableStacksOnPremOptions contains the optional parameters for the ProviderClient.GetAvailableStacksOnPrem
// method.
type ProviderClientGetAvailableStacksOnPremOptions struct {
	OSTypeSelected *ProviderOsTypeSelected
}

// ProviderClientGetAvailableStacksOptions contains the optional parameters for the ProviderClient.GetAvailableStacks method.
type ProviderClientGetAvailableStacksOptions struct {
	OSTypeSelected *ProviderOsTypeSelected
}

// ProviderClientGetFunctionAppStacksForLocationOptions contains the optional parameters for the ProviderClient.GetFunctionAppStacksForLocation
// method.
type ProviderClientGetFunctionAppStacksForLocationOptions struct {
	// Stack OS Type
	StackOsType *ProviderStackOsType
}

// ProviderClientGetFunctionAppStacksOptions contains the optional parameters for the ProviderClient.GetFunctionAppStacks
// method.
type ProviderClientGetFunctionAppStacksOptions struct {
	// Stack OS Type
	StackOsType *ProviderStackOsType
}

// ProviderClientGetWebAppStacksForLocationOptions contains the optional parameters for the ProviderClient.GetWebAppStacksForLocation
// method.
type ProviderClientGetWebAppStacksForLocationOptions struct {
	// Stack OS Type
	StackOsType *ProviderStackOsType
}

// ProviderClientGetWebAppStacksOptions contains the optional parameters for the ProviderClient.GetWebAppStacks method.
type ProviderClientGetWebAppStacksOptions struct {
	// Stack OS Type
	StackOsType *ProviderStackOsType
}

// ProviderClientListOperationsOptions contains the optional parameters for the ProviderClient.ListOperations method.
type ProviderClientListOperationsOptions struct {
	// placeholder for future optional parameters
}

// ProxyOnlyResource - Azure proxy only resource. This resource is not tracked by Azure Resource Manager.
type ProxyOnlyResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicCertificate - Public certificate object
type PublicCertificate struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PublicCertificate resource specific properties
	Properties *PublicCertificateProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicCertificateCollection - Collection of public certificates
type PublicCertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*PublicCertificate `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PublicCertificateProperties - PublicCertificate resource specific properties
type PublicCertificateProperties struct {
	// Public Certificate byte array
	Blob []byte `json:"blob,omitempty"`

	// Public Certificate Location
	PublicCertificateLocation *PublicCertificateLocation `json:"publicCertificateLocation,omitempty"`

	// READ-ONLY; Certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// PublishingCredentialsPoliciesCollection - Publishing Credentials Policies entity collection ARM resource.
type PublishingCredentialsPoliciesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*CsmPublishingCredentialsPoliciesEntity `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// PushSettings - Push settings for the App.
type PushSettings struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// PushSettings resource specific properties
	Properties *PushSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PushSettingsProperties - PushSettings resource specific properties
type PushSettingsProperties struct {
	// REQUIRED; Gets or sets a flag indicating whether the Push endpoint is enabled.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`

	// Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration
	// endpoint.
	DynamicTagsJSON *string `json:"dynamicTagsJson,omitempty"`

	// Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
	TagWhitelistJSON *string `json:"tagWhitelistJson,omitempty"`

	// Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration
	// endpoint. Tags can consist of alphanumeric characters and the following: '_',
	// '@', '#', '.', ':', '-'. Validation should be performed at the PushRequestHandler.
	TagsRequiringAuth *string `json:"tagsRequiringAuth,omitempty"`
}

// QueryUtterancesResult - Result for utterances query.
type QueryUtterancesResult struct {
	// A sample utterance.
	SampleUtterance *SampleUtterance `json:"sampleUtterance,omitempty"`

	// Score of a sample utterance.
	Score *float32 `json:"score,omitempty"`
}

// QueryUtterancesResults - Suggested utterances where the detector can be applicable
type QueryUtterancesResults struct {
	// Search Query.
	Query *string `json:"query,omitempty"`

	// Array of utterance results for search query.
	Results []*QueryUtterancesResult `json:"results,omitempty"`
}

// QueueScaleRule - Container App container Azure Queue based scaling rule.
type QueueScaleRule struct {
	// Authentication secrets for the queue scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Queue length.
	QueueLength *int32 `json:"queueLength,omitempty"`

	// Queue name.
	QueueName *string `json:"queueName,omitempty"`
}

// RampUpRule - Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually
// change routing % based on performance.
type RampUpRule struct {
	// Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
	ActionHostName *string `json:"actionHostName,omitempty"`

	// Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site
	// extension for the scaffold and contracts.
	// https://www.siteextensions.net/packages/TiPCallback/
	ChangeDecisionCallbackURL *string `json:"changeDecisionCallbackUrl,omitempty"`

	// Specifies interval in minutes to reevaluate ReroutePercentage.
	ChangeIntervalInMinutes *int32 `json:"changeIntervalInMinutes,omitempty"`

	// In auto ramp up scenario this is the step to add/remove from ReroutePercentage until it reaches \nMinReroutePercentage
	// orMaxReroutePercentage. Site metrics are checked every N minutes specified in
	// ChangeIntervalInMinutes.\nCustom decision algorithm can be provided in TiPCallback site extension which URL can be specified
	// in ChangeDecisionCallbackUrl.
	ChangeStep *float64 `json:"changeStep,omitempty"`

	// Specifies upper boundary below which ReroutePercentage will stay.
	MaxReroutePercentage *float64 `json:"maxReroutePercentage,omitempty"`

	// Specifies lower boundary above which ReroutePercentage will stay.
	MinReroutePercentage *float64 `json:"minReroutePercentage,omitempty"`

	// Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string `json:"name,omitempty"`

	// Percentage of the traffic which will be redirected to ActionHostName.
	ReroutePercentage *float64 `json:"reroutePercentage,omitempty"`
}

// Recommendation - Represents a recommendation result generated by the recommendation engine.
type Recommendation struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Recommendation resource specific properties
	Properties *RecommendationProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendationCollection - Collection of recommendations.
type RecommendationCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Recommendation `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RecommendationProperties - Recommendation resource specific properties
type RecommendationProperties struct {
	// Name of action recommended by this object.
	ActionName *string `json:"actionName,omitempty"`

	// Deep link to a blade on the portal.
	BladeName *string `json:"bladeName,omitempty"`

	// List of channels that this recommendation can apply.
	Channels *Channels `json:"channels,omitempty"`

	// Timestamp when this instance was created.
	CreationTime *time.Time `json:"creationTime,omitempty"`

	// UI friendly name of the rule (may not be unique).
	DisplayName *string `json:"displayName,omitempty"`

	// True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
	Enabled *int32 `json:"enabled,omitempty"`

	// The end time in UTC of a range that the recommendation refers to.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Extension name of the portal if exists.
	ExtensionName *string `json:"extensionName,omitempty"`

	// Forward link to an external document associated with the rule.
	ForwardLink *string `json:"forwardLink,omitempty"`

	// True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`

	// Level indicating how critical this recommendation can impact.
	Level *NotificationLevel `json:"level,omitempty"`

	// Recommendation text.
	Message *string `json:"message,omitempty"`

	// When to notify this recommendation next in UTC. Null means that this will never be notified anymore.
	NextNotificationTime *time.Time `json:"nextNotificationTime,omitempty"`

	// Date and time in UTC when this notification expires.
	NotificationExpirationTime *time.Time `json:"notificationExpirationTime,omitempty"`

	// Last timestamp in UTC this instance was actually notified. Null means that this recommendation hasn't been notified yet.
	NotifiedTime *time.Time `json:"notifiedTime,omitempty"`

	// A GUID value that each recommendation object is associated with.
	RecommendationID *string `json:"recommendationId,omitempty"`

	// Full ARM resource ID string that this recommendation object is associated with.
	ResourceID *string `json:"resourceId,omitempty"`

	// Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site.
	ResourceScope *ResourceScopeType `json:"resourceScope,omitempty"`

	// Unique name of the rule.
	RuleName *string `json:"ruleName,omitempty"`

	// A metric value measured by the rule.
	Score *float64 `json:"score,omitempty"`

	// The beginning time in UTC of a range that the recommendation refers to.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The list of states of this recommendation. If it's null then it should be considered "Active".
	States []*string `json:"states,omitempty"`

	// READ-ONLY; The list of category tags that this recommendation belongs to.
	CategoryTags []*string `json:"categoryTags,omitempty" azure:"ro"`
}

// RecommendationRule - Represents a recommendation rule that the recommendation engine can perform.
type RecommendationRule struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RecommendationRule resource specific properties
	Properties *RecommendationRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RecommendationRuleProperties - RecommendationRule resource specific properties
type RecommendationRuleProperties struct {
	// Name of action that is recommended by this rule in string.
	ActionName *string `json:"actionName,omitempty"`

	// Deep link to a blade on the portal. Applicable to dynamic rule only.
	BladeName *string `json:"bladeName,omitempty"`

	// List of available channels that this rule applies.
	Channels *Channels `json:"channels,omitempty"`

	// Localized detailed description of the rule.
	Description *string `json:"description,omitempty"`

	// UI friendly name of the rule.
	DisplayName *string `json:"displayName,omitempty"`

	// Extension name of the portal if exists. Applicable to dynamic rule only.
	ExtensionName *string `json:"extensionName,omitempty"`

	// Forward link to an external document associated with the rule. Applicable to dynamic rule only.
	ForwardLink *string `json:"forwardLink,omitempty"`

	// True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`

	// Level of impact indicating how critical this rule is.
	Level *NotificationLevel `json:"level,omitempty"`

	// Localized name of the rule (Good for UI).
	Message *string `json:"message,omitempty"`

	// Recommendation ID of an associated recommendation object tied to the rule, if exists. If such an object doesn't exist,
	// it is set to null.
	RecommendationID *string `json:"recommendationId,omitempty"`

	// Unique name of the rule.
	RecommendationName *string `json:"recommendationName,omitempty"`

	// READ-ONLY; The list of category tags that this recommendation rule belongs to.
	CategoryTags []*string `json:"categoryTags,omitempty" azure:"ro"`
}

// RecommendationsClientDisableAllForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.DisableAllForHostingEnvironment
// method.
type RecommendationsClientDisableAllForHostingEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableAllForWebAppOptions contains the optional parameters for the RecommendationsClient.DisableAllForWebApp
// method.
type RecommendationsClientDisableAllForWebAppOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableRecommendationForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForHostingEnvironment
// method.
type RecommendationsClientDisableRecommendationForHostingEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableRecommendationForSiteOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForSite
// method.
type RecommendationsClientDisableRecommendationForSiteOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientDisableRecommendationForSubscriptionOptions contains the optional parameters for the RecommendationsClient.DisableRecommendationForSubscription
// method.
type RecommendationsClientDisableRecommendationForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.GetRuleDetailsByHostingEnvironment
// method.
type RecommendationsClientGetRuleDetailsByHostingEnvironmentOptions struct {
	// The GUID of the recommendation object if you query an expired one. You don't need to specify it to query an active entry.
	RecommendationID *string
	// Specify true to update the last-seen timestamp of the recommendation object.
	UpdateSeen *bool
}

// RecommendationsClientGetRuleDetailsByWebAppOptions contains the optional parameters for the RecommendationsClient.GetRuleDetailsByWebApp
// method.
type RecommendationsClientGetRuleDetailsByWebAppOptions struct {
	// The GUID of the recommendation object if you query an expired one. You don't need to specify it to query an active entry.
	RecommendationID *string
	// Specify true to update the last-seen timestamp of the recommendation object.
	UpdateSeen *bool
}

// RecommendationsClientListHistoryForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.ListHistoryForHostingEnvironment
// method.
type RecommendationsClientListHistoryForHostingEnvironmentOptions struct {
	// Specify false to return all recommendations. The default is true, which returns only expired recommendations.
	ExpiredOnly *bool
	// Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification' and startTime
	// eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[PT1H|PT1M|P1D]
	Filter *string
}

// RecommendationsClientListHistoryForWebAppOptions contains the optional parameters for the RecommendationsClient.ListHistoryForWebApp
// method.
type RecommendationsClientListHistoryForWebAppOptions struct {
	// Specify false to return all recommendations. The default is true, which returns only expired recommendations.
	ExpiredOnly *bool
	// Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification' and startTime
	// eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[PT1H|PT1M|P1D]
	Filter *string
}

// RecommendationsClientListOptions contains the optional parameters for the RecommendationsClient.List method.
type RecommendationsClientListOptions struct {
	// Specify true to return only the most critical recommendations. The default is false, which returns all recommendations.
	Featured *bool
	// Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification' and startTime
	// eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[PT1H|PT1M|P1D]
	Filter *string
}

// RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.ListRecommendedRulesForHostingEnvironment
// method.
type RecommendationsClientListRecommendedRulesForHostingEnvironmentOptions struct {
	// Specify true to return only the most critical recommendations. The default is false, which returns all recommendations.
	Featured *bool
	// Return only channels specified in the filter. Filter is specified by using OData syntax. Example: $filter=channel eq 'Api'
	// or channel eq 'Notification'
	Filter *string
}

// RecommendationsClientListRecommendedRulesForWebAppOptions contains the optional parameters for the RecommendationsClient.ListRecommendedRulesForWebApp
// method.
type RecommendationsClientListRecommendedRulesForWebAppOptions struct {
	// Specify true to return only the most critical recommendations. The default is false, which returns all recommendations.
	Featured *bool
	// Return only channels specified in the filter. Filter is specified by using OData syntax. Example: $filter=channel eq 'Api'
	// or channel eq 'Notification'
	Filter *string
}

// RecommendationsClientResetAllFiltersForHostingEnvironmentOptions contains the optional parameters for the RecommendationsClient.ResetAllFiltersForHostingEnvironment
// method.
type RecommendationsClientResetAllFiltersForHostingEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientResetAllFiltersForWebAppOptions contains the optional parameters for the RecommendationsClient.ResetAllFiltersForWebApp
// method.
type RecommendationsClientResetAllFiltersForWebAppOptions struct {
	// placeholder for future optional parameters
}

// RecommendationsClientResetAllFiltersOptions contains the optional parameters for the RecommendationsClient.ResetAllFilters
// method.
type RecommendationsClientResetAllFiltersOptions struct {
	// placeholder for future optional parameters
}

// RecurrenceSchedule - The recurrence schedule.
type RecurrenceSchedule struct {
	// The hours.
	Hours []*int32 `json:"hours,omitempty"`

	// The minutes.
	Minutes []*int32 `json:"minutes,omitempty"`

	// The month days.
	MonthDays []*int32 `json:"monthDays,omitempty"`

	// The monthly occurrences.
	MonthlyOccurrences []*RecurrenceScheduleOccurrence `json:"monthlyOccurrences,omitempty"`

	// The days of the week.
	WeekDays []*DaysOfWeek `json:"weekDays,omitempty"`
}

// RecurrenceScheduleOccurrence - The recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// The day of the week.
	Day *DayOfWeek `json:"day,omitempty"`

	// The occurrence.
	Occurrence *int32 `json:"occurrence,omitempty"`
}

// RegenerateActionParameter - The access key regenerate action content.
type RegenerateActionParameter struct {
	// The key type.
	KeyType *KeyType `json:"keyType,omitempty"`
}

// RegistryCredentials - Container App Private Registry
type RegistryCredentials struct {
	// The name of the Secret that contains the registry login password
	PasswordSecretRef *string `json:"passwordSecretRef,omitempty"`

	// Container Registry Server
	Server *string `json:"server,omitempty"`

	// Container Registry Username
	Username *string `json:"username,omitempty"`
}

// ReissueCertificateOrderRequest - Class representing certificate reissue request.
type ReissueCertificateOrderRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ReissueCertificateOrderRequest resource specific properties
	Properties *ReissueCertificateOrderRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReissueCertificateOrderRequestProperties - ReissueCertificateOrderRequest resource specific properties
type ReissueCertificateOrderRequestProperties struct {
	// Csr to be used for re-key operation.
	Csr *string `json:"csr,omitempty"`

	// Delay in hours to revoke existing certificate after the new certificate is issued.
	DelayExistingRevokeInHours *int32 `json:"delayExistingRevokeInHours,omitempty"`

	// Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`

	// Certificate Key Size.
	KeySize *int32 `json:"keySize,omitempty"`
}

// RelayServiceConnectionEntity - Hybrid Connection for an App Service app.
type RelayServiceConnectionEntity struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RelayServiceConnectionEntity resource specific properties
	Properties *RelayServiceConnectionEntityProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RelayServiceConnectionEntityProperties - RelayServiceConnectionEntity resource specific properties
type RelayServiceConnectionEntityProperties struct {
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	EntityName               *string `json:"entityName,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
}

// RemotePrivateEndpointConnection - A remote private endpoint connection
type RemotePrivateEndpointConnection struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RemotePrivateEndpointConnection resource specific properties
	Properties *RemotePrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RemotePrivateEndpointConnectionARMResource - Remote Private Endpoint Connection ARM resource.
type RemotePrivateEndpointConnectionARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RemotePrivateEndpointConnectionARMResource resource specific properties
	Properties *RemotePrivateEndpointConnectionARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RemotePrivateEndpointConnectionARMResourceProperties - RemotePrivateEndpointConnectionARMResource resource specific properties
type RemotePrivateEndpointConnectionARMResourceProperties struct {
	// Private IPAddresses mapped to the remote private endpoint
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint *ArmIDWrapper `json:"privateEndpoint,omitempty"`

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// RemotePrivateEndpointConnectionProperties - RemotePrivateEndpointConnection resource specific properties
type RemotePrivateEndpointConnectionProperties struct {
	// Private IPAddresses mapped to the remote private endpoint
	IPAddresses []*string `json:"ipAddresses,omitempty"`

	// PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint *ArmIDWrapper `json:"privateEndpoint,omitempty"`

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Rendering - Instructions for rendering the data
type Rendering struct {
	// Description of the data that will help it be interpreted
	Description *string `json:"description,omitempty"`

	// Title of data
	Title *string `json:"title,omitempty"`

	// Rendering Type
	Type *RenderingType `json:"type,omitempty"`
}

// RenewCertificateOrderRequest - Class representing certificate renew request.
type RenewCertificateOrderRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RenewCertificateOrderRequest resource specific properties
	Properties *RenewCertificateOrderRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RenewCertificateOrderRequestProperties - RenewCertificateOrderRequest resource specific properties
type RenewCertificateOrderRequestProperties struct {
	// Csr to be used for re-key operation.
	Csr *string `json:"csr,omitempty"`

	// Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`

	// Certificate Key Size.
	KeySize *int32 `json:"keySize,omitempty"`
}

// RepetitionIndex - The workflow run action repetition index.
type RepetitionIndex struct {
	// REQUIRED; The index.
	ItemIndex *int32 `json:"itemIndex,omitempty"`

	// The scope.
	ScopeName *string `json:"scopeName,omitempty"`
}

// Request - A request.
type Request struct {
	// A list of all the headers attached to the request.
	Headers interface{} `json:"headers,omitempty"`

	// The HTTP method used for the request.
	Method *string `json:"method,omitempty"`

	// The destination for the request.
	URI *string `json:"uri,omitempty"`
}

// RequestHistory - The request history.
type RequestHistory struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The request history properties.
	Properties *RequestHistoryProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RequestHistoryListResult - The list of workflow request histories.
type RequestHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow request histories.
	Value []*RequestHistory `json:"value,omitempty"`
}

// RequestHistoryProperties - The request history.
type RequestHistoryProperties struct {
	// The time the request ended.
	EndTime *time.Time `json:"endTime,omitempty"`

	// The request.
	Request *Request `json:"request,omitempty"`

	// The response.
	Response *Response `json:"response,omitempty"`

	// The time the request started.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// RequestsBasedTrigger - Trigger based on total requests.
type RequestsBasedTrigger struct {
	// Request Count.
	Count *int32 `json:"count,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource - Azure resource. This resource is tracked in Azure Resource Manager
type Resource struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceCollection - Collection of resources.
type ResourceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*string `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceHealthMetadata - Used for getting ResourceHealthCheck settings.
type ResourceHealthMetadata struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ResourceHealthMetadata resource specific properties
	Properties *ResourceHealthMetadataProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceHealthMetadataClientGetBySiteOptions contains the optional parameters for the ResourceHealthMetadataClient.GetBySite
// method.
type ResourceHealthMetadataClientGetBySiteOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthMetadataClientGetBySiteSlotOptions contains the optional parameters for the ResourceHealthMetadataClient.GetBySiteSlot
// method.
type ResourceHealthMetadataClientGetBySiteSlotOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthMetadataClientListByResourceGroupOptions contains the optional parameters for the ResourceHealthMetadataClient.ListByResourceGroup
// method.
type ResourceHealthMetadataClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthMetadataClientListBySiteOptions contains the optional parameters for the ResourceHealthMetadataClient.ListBySite
// method.
type ResourceHealthMetadataClientListBySiteOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthMetadataClientListBySiteSlotOptions contains the optional parameters for the ResourceHealthMetadataClient.ListBySiteSlot
// method.
type ResourceHealthMetadataClientListBySiteSlotOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthMetadataClientListOptions contains the optional parameters for the ResourceHealthMetadataClient.List method.
type ResourceHealthMetadataClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourceHealthMetadataCollection - Collection of resource health metadata.
type ResourceHealthMetadataCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ResourceHealthMetadata `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceHealthMetadataProperties - ResourceHealthMetadata resource specific properties
type ResourceHealthMetadataProperties struct {
	// The category that the resource matches in the RHC Policy File
	Category *string `json:"category,omitempty"`

	// Is there a health signal for the resource
	SignalAvailability *bool `json:"signalAvailability,omitempty"`
}

// ResourceMetricAvailability - Metrics availability and retention.
type ResourceMetricAvailability struct {
	// READ-ONLY; Retention period for the current time grain.
	Retention *string `json:"retention,omitempty" azure:"ro"`

	// READ-ONLY; Time grain .
	TimeGrain *string `json:"timeGrain,omitempty" azure:"ro"`
}

// ResourceMetricDefinition - Metadata for the metrics.
type ResourceMetricDefinition struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// ResourceMetricDefinition resource specific properties
	Properties *ResourceMetricDefinitionProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceMetricDefinitionCollection - Collection of metric definitions.
type ResourceMetricDefinitionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ResourceMetricDefinition `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceMetricDefinitionProperties - ResourceMetricDefinition resource specific properties
type ResourceMetricDefinitionProperties struct {
	// READ-ONLY; List of time grains supported for the metric together with retention period.
	MetricAvailabilities []*ResourceMetricAvailability `json:"metricAvailabilities,omitempty" azure:"ro"`

	// READ-ONLY; Primary aggregation type.
	PrimaryAggregationType *string `json:"primaryAggregationType,omitempty" azure:"ro"`

	// READ-ONLY; Resource metric definition properties.
	Properties map[string]*string `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Resource URI.
	ResourceURI *string `json:"resourceUri,omitempty" azure:"ro"`

	// READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// ResourceNameAvailability - Information regarding availability of a resource name.
type ResourceNameAvailability struct {
	// If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements
	// so that the user can select a valid name. If reason == AlreadyExists,
	// explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`

	// true indicates name is valid and available. false indicates the name is invalid, unavailable, or both.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists indicates that
	// the name is already in use and is therefore unavailable.
	Reason *InAvailabilityReasonType `json:"reason,omitempty"`
}

// ResourceNameAvailabilityRequest - Resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *CheckNameResourceTypes `json:"type,omitempty"`

	// Is fully qualified domain name.
	IsFqdn *bool `json:"isFqdn,omitempty"`
}

// ResourceReference - The resource reference.
type ResourceReference struct {
	// The resource id.
	ID *string `json:"id,omitempty"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Response - A response.
type Response struct {
	// Details on the location of the body content.
	BodyLink *ContentLink `json:"bodyLink,omitempty"`

	// A list of all the headers attached to the response.
	Headers interface{} `json:"headers,omitempty"`

	// The status code of the response.
	StatusCode *int32 `json:"statusCode,omitempty"`
}

// ResponseMessageEnvelopeRemotePrivateEndpointConnection - Message envelope that contains the common Azure resource manager
// properties and the resource provider specific content.
type ResponseMessageEnvelopeRemotePrivateEndpointConnection struct {
	// Azure-AsyncOperation Error info.
	Error *ErrorEntity `json:"error,omitempty"`

	// Resource Id. Typically ID is populated only for responses to GET requests. Caller is responsible for passing in this value
	// for GET requests only. For example:
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
	ID *string `json:"id,omitempty"`

	// MSI resource
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
	Location *string `json:"location,omitempty"`

	// Name of resource.
	Name *string `json:"name,omitempty"`

	// Azure resource manager plan.
	Plan *ArmPlan `json:"plan,omitempty"`

	// Resource specific properties.
	Properties *RemotePrivateEndpointConnection `json:"properties,omitempty"`

	// SKU description of the resource.
	SKU *SKUDescription `json:"sku,omitempty"`

	// Azure-AsyncOperation Status info.
	Status *string `json:"status,omitempty"`

	// Tags associated with resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// Type of resource e.g "Microsoft.Web/sites".
	Type *string `json:"type,omitempty"`

	// Logical Availability Zones the service is hosted in
	Zones []*string `json:"zones,omitempty"`
}

type ResponseMetaData struct {
	// Source of the Data
	DataSource *DataSource `json:"dataSource,omitempty"`
}

// RestoreRequest - Description of a restore request.
type RestoreRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// RestoreRequest resource specific properties
	Properties *RestoreRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RestoreRequestProperties - RestoreRequest resource specific properties
type RestoreRequestProperties struct {
	// REQUIRED; true if the restore operation can overwrite target app; otherwise, false. true is needed if trying to restore
	// over an existing app.
	Overwrite *bool `json:"overwrite,omitempty"`

	// REQUIRED; SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`

	// true if SiteConfig.ConnectionStrings should be set in new app; otherwise, false.
	AdjustConnectionStrings *bool `json:"adjustConnectionStrings,omitempty"`

	// Specify app service plan that will own restored site.
	AppServicePlan *string `json:"appServicePlan,omitempty"`

	// Name of a blob which contains the backup.
	BlobName *string `json:"blobName,omitempty"`

	// Collection of databases which should be restored. This list has to match the list of databases included in the backup.
	Databases []*DatabaseBackupSetting `json:"databases,omitempty"`

	// App Service Environment name, if needed (only when restoring an app to an App Service Environment).
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`

	// Changes a logic when restoring an app with custom domains. true to remove custom domains automatically. If false, custom
	// domains are added to the app's object when it is being restored, but that might
	// fail due to conflicts during the operation.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`

	// Ignore the databases and only restore the site content
	IgnoreDatabases *bool `json:"ignoreDatabases,omitempty"`

	// Operation type.
	OperationType *BackupRestoreOperationType `json:"operationType,omitempty"`

	// Name of an app.
	SiteName *string `json:"siteName,omitempty"`
}

// RetryHistory - The retry history.
type RetryHistory struct {
	// Gets the client request Id.
	ClientRequestID *string `json:"clientRequestId,omitempty"`

	// Gets the status code.
	Code *string `json:"code,omitempty"`

	// Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Gets the error response.
	Error *ErrorResponse `json:"error,omitempty"`

	// Gets the service request Id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty"`

	// Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty"`
}

// Revision - Container App Revision.
type Revision struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Revision resource specific properties
	Properties *RevisionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RevisionCollection - Container App Revisions collection ARM resource.
type RevisionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Revision `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RevisionProperties - Revision resource specific properties
type RevisionProperties struct {
	// READ-ONLY; Boolean describing if the Revision is Active
	Active *bool `json:"active,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp describing when the revision was created by controller
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified domain name of the revision
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; Current health State of the revision
	HealthState *RevisionHealthState `json:"healthState,omitempty" azure:"ro"`

	// READ-ONLY; Optional Field - Platform Error Message
	ProvisioningError *string `json:"provisioningError,omitempty" azure:"ro"`

	// READ-ONLY; Current provisioning State of the revision
	ProvisioningState *RevisionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Number of pods currently running for this revision
	Replicas *int32 `json:"replicas,omitempty" azure:"ro"`

	// READ-ONLY; Container App Revision Template with all possible settings and the defaults if user did not provide them. The
	// defaults are populated as they were at the creation time
	Template *Template `json:"template,omitempty" azure:"ro"`

	// READ-ONLY; Traffic weight assigned to this revision
	TrafficWeight *int32 `json:"trafficWeight,omitempty" azure:"ro"`
}

// RunActionCorrelation - The workflow run action correlation properties.
type RunActionCorrelation struct {
	// The action tracking identifier.
	ActionTrackingID *string `json:"actionTrackingId,omitempty"`

	// The client keywords.
	ClientKeywords []*string `json:"clientKeywords,omitempty"`

	// The client tracking identifier.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// RunCorrelation - The correlation properties.
type RunCorrelation struct {
	// The client keywords.
	ClientKeywords []*string `json:"clientKeywords,omitempty"`

	// The client tracking identifier.
	ClientTrackingID *string `json:"clientTrackingId,omitempty"`
}

// SKUCapacity - Description of the App Service plan scale options.
type SKUCapacity struct {
	// Default number of workers for this App Service plan SKU.
	Default *int32 `json:"default,omitempty"`

	// Maximum number of Elastic workers for this App Service plan SKU.
	ElasticMaximum *int32 `json:"elasticMaximum,omitempty"`

	// Maximum number of workers for this App Service plan SKU.
	Maximum *int32 `json:"maximum,omitempty"`

	// Minimum number of workers for this App Service plan SKU.
	Minimum *int32 `json:"minimum,omitempty"`

	// Available scale configurations for an App Service plan.
	ScaleType *string `json:"scaleType,omitempty"`
}

// SKUDescription - Description of a SKU for a scalable resource.
type SKUDescription struct {
	// Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities []*Capability `json:"capabilities,omitempty"`

	// Current number of instances assigned to the resource.
	Capacity *int32 `json:"capacity,omitempty"`

	// Family code of the resource SKU.
	Family *string `json:"family,omitempty"`

	// Locations of the SKU.
	Locations []*string `json:"locations,omitempty"`

	// Name of the resource SKU.
	Name *string `json:"name,omitempty"`

	// Min, max, and default scale values of the SKU.
	SKUCapacity *SKUCapacity `json:"skuCapacity,omitempty"`

	// Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`

	// Service tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
}

// SKUInfo - SKU discovery information.
type SKUInfo struct {
	// Min, max, and default scale values of the SKU.
	Capacity *SKUCapacity `json:"capacity,omitempty"`

	// Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`

	// Name and tier of the SKU.
	SKU *SKUDescription `json:"sku,omitempty"`
}

// SKUInfoCollection - Collection of SKU information.
type SKUInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SKUInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SKUInfos - Collection of SKU information.
type SKUInfos struct {
	// Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`

	// List of SKUs the subscription is able to use.
	SKUs []*GlobalCsmSKUDescription `json:"skus,omitempty"`
}

// SampleUtterance - Sample utterance.
type SampleUtterance struct {
	// Links attribute of sample utterance.
	Links []*string `json:"links,omitempty"`

	// Question id of sample utterance (for stackoverflow questions titles).
	Qid *string `json:"qid,omitempty"`

	// Text attribute of sample utterance.
	Text *string `json:"text,omitempty"`
}

// Scale - Container App scaling configurations.
type Scale struct {
	// Optional. Maximum number of container replicas. Defaults to 10 if not set.
	MaxReplicas *int32 `json:"maxReplicas,omitempty"`

	// Optional. Minimum number of container replicas.
	MinReplicas *int32 `json:"minReplicas,omitempty"`

	// Scaling rules.
	Rules []*ScaleRule `json:"rules,omitempty"`
}

// ScaleRule - Container App container scaling rule.
type ScaleRule struct {
	// Azure Queue based scaling.
	AzureQueue *QueueScaleRule `json:"azureQueue,omitempty"`

	// Custom scale rule.
	Custom *CustomScaleRule `json:"custom,omitempty"`

	// HTTP requests based scaling.
	HTTP *HTTPScaleRule `json:"http,omitempty"`

	// Scale Rule Name
	Name *string `json:"name,omitempty"`
}

// ScaleRuleAuth - Auth Secrets for Container App Scale Rule
type ScaleRuleAuth struct {
	// Name of the Container App secret from which to pull the auth params.
	SecretRef *string `json:"secretRef,omitempty"`

	// Trigger Parameter that uses the secret
	TriggerParameter *string `json:"triggerParameter,omitempty"`
}

// Secret - Container App Secret.
type Secret struct {
	// Secret Name.
	Name *string `json:"name,omitempty"`

	// Secret Value.
	Value *string `json:"value,omitempty"`
}

// SecretsCollection - Container App Secrets Collection ARM resource.
type SecretsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerAppSecret `json:"value,omitempty"`
}

// ServiceSpecification - Resource metrics service provided by Microsoft.Insights resource provider.
type ServiceSpecification struct {
	LogSpecifications    []*LogSpecification    `json:"logSpecifications,omitempty"`
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Site - A web app, a mobile app backend, or an API app.
type Site struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Extended Location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Managed service identity.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Site resource specific properties
	Properties *SiteProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteAuthSettings - Configuration settings for the Azure App Service Authentication / Authorization feature.
type SiteAuthSettings struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteAuthSettings resource specific properties
	Properties *SiteAuthSettingsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteAuthSettingsProperties - SiteAuthSettings resource specific properties
type SiteAuthSettingsProperties struct {
	// Gets a JSON string containing the Azure AD Acl settings.
	AADClaimsAuthorization *string `json:"aadClaimsAuthorization,omitempty"`

	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	AdditionalLoginParams []*string `json:"additionalLoginParams,omitempty"`

	// Allowed audience values to consider when validating JWTs issued by Azure Active Directory. Note that the ClientID value
	// is always considered an allowed audience, regardless of this setting.
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`

	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string `json:"allowedExternalRedirectUrls,omitempty"`

	// The path of the config file containing auth settings. If the path is relative, base will the site's root directory.
	AuthFilePath *string `json:"authFilePath,omitempty"`

	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string `json:"clientId,omitempty"`

	// The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key). This
	// setting is optional. If no client secret is configured, the OpenID Connect
	// implicit auth flow is used to authenticate end users. Otherwise, the OpenID Connect Authorization Code Flow is used to
	// authenticate end users. More information on OpenID Connect:
	// http://openid.net/specs/openid-connect-core-1_0.html
	ClientSecret *string `json:"clientSecret,omitempty"`

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string `json:"clientSecretCertificateThumbprint,omitempty"`

	// The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`

	// The ConfigVersion of the Authentication / Authorization feature in use for the current app. The setting in this value can
	// control the behavior of the control plane for Authentication / Authorization.
	ConfigVersion *string `json:"configVersion,omitempty"`

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	DefaultProvider *BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`

	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool `json:"enabled,omitempty"`

	// The App ID of the Facebook app used for login. This setting is required for enabling Facebook Login. Facebook Login documentation:
	// https://developers.facebook.com/docs/facebook-login
	FacebookAppID *string `json:"facebookAppId,omitempty"`

	// The App Secret of the Facebook app used for Facebook Login. This setting is required for enabling Facebook Login. Facebook
	// Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppSecret *string `json:"facebookAppSecret,omitempty"`

	// The app setting name that contains the app secret used for Facebook Login.
	FacebookAppSecretSettingName *string `json:"facebookAppSecretSettingName,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication. This setting is optional. Facebook
	// Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookOAuthScopes []*string `json:"facebookOAuthScopes,omitempty"`

	// The Client Id of the GitHub app used for login. This setting is required for enabling Github login
	GitHubClientID *string `json:"gitHubClientId,omitempty"`

	// The Client Secret of the GitHub app used for Github Login. This setting is required for enabling Github login.
	GitHubClientSecret *string `json:"gitHubClientSecret,omitempty"`

	// The app setting name that contains the client secret of the Github app used for GitHub Login.
	GitHubClientSecretSettingName *string `json:"gitHubClientSecretSettingName,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication. This setting is optional
	GitHubOAuthScopes []*string `json:"gitHubOAuthScopes,omitempty"`

	// The OpenID Connect Client ID for the Google web application. This setting is required for enabling Google Sign-In. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientID *string `json:"googleClientId,omitempty"`

	// The client secret associated with the Google web application. This setting is required for enabling Google Sign-In. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientSecret *string `json:"googleClientSecret,omitempty"`

	// The app setting name that contains the client secret associated with the Google web application.
	GoogleClientSecretSettingName *string `json:"googleClientSecretSettingName,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. This setting is optional. If not
	// specified, "openid", "profile", and "email" are used as default scopes. Google
	// Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleOAuthScopes []*string `json:"googleOAuthScopes,omitempty"`

	// "true" if the auth config settings should be read from a file, "false" otherwise
	IsAuthFromFile *string `json:"isAuthFromFile,omitempty"`

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://sts.windows.net/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More information
	// on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	Issuer *string `json:"issuer,omitempty"`

	// The OAuth 2.0 client ID that was created for the app used for authentication. This setting is required for enabling Microsoft
	// Account authentication. Microsoft Account OAuth documentation:
	// https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientID *string `json:"microsoftAccountClientId,omitempty"`

	// The OAuth 2.0 client secret that was created for the app used for authentication. This setting is required for enabling
	// Microsoft Account authentication. Microsoft Account OAuth documentation:
	// https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientSecret *string `json:"microsoftAccountClientSecret,omitempty"`

	// The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
	MicrosoftAccountClientSecretSettingName *string `json:"microsoftAccountClientSecretSettingName,omitempty"`

	// The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. This setting is optional. If not
	// specified, "wl.basic" is used as the default scope. Microsoft Account Scopes
	// and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
	MicrosoftAccountOAuthScopes []*string `json:"microsoftAccountOAuthScopes,omitempty"`

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`

	// The number of hours after session token expiration that a session token can be used to call the token refresh API. The
	// default is 72 hours.
	TokenRefreshExtensionHours *float64 `json:"tokenRefreshExtensionHours,omitempty"`

	// true to durably store platform-specific security tokens that are obtained during login flows; otherwise, false. The default
	// is false.
	TokenStoreEnabled *bool `json:"tokenStoreEnabled,omitempty"`

	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerKey *string `json:"twitterConsumerKey,omitempty"`

	// The OAuth 1.0a consumer secret of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerSecret *string `json:"twitterConsumerSecret,omitempty"`

	// The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	TwitterConsumerSecretSettingName *string `json:"twitterConsumerSecretSettingName,omitempty"`

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientAction `json:"unauthenticatedClientAction,omitempty"`

	// Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
	ValidateIssuer *bool `json:"validateIssuer,omitempty"`
}

// SiteAuthSettingsV2 - Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
type SiteAuthSettingsV2 struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteAuthSettingsV2 resource specific properties
	Properties *SiteAuthSettingsV2Properties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteAuthSettingsV2Properties - SiteAuthSettingsV2 resource specific properties
type SiteAuthSettingsV2Properties struct {
	// The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.
	GlobalValidation *GlobalValidation `json:"globalValidation,omitempty"`

	// The configuration settings of the HTTP requests for authentication and authorization requests made against App Service
	// Authentication/Authorization.
	HTTPSettings *HTTPSettings `json:"httpSettings,omitempty"`

	// The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.
	IdentityProviders *IdentityProviders `json:"identityProviders,omitempty"`

	// The configuration settings of the login flow of users using App Service Authentication/Authorization.
	Login *Login `json:"login,omitempty"`

	// The configuration settings of the platform of App Service Authentication/Authorization.
	Platform *AuthPlatform `json:"platform,omitempty"`
}

// SiteCloneability - Represents whether or not an app is cloneable.
type SiteCloneability struct {
	// List of blocking application characteristics.
	BlockingCharacteristics []*SiteCloneabilityCriterion `json:"blockingCharacteristics,omitempty"`

	// List of features enabled on app that prevent cloning.
	BlockingFeatures []*SiteCloneabilityCriterion `json:"blockingFeatures,omitempty"`

	// Name of app.
	Result *CloneAbilityResult `json:"result,omitempty"`

	// List of features enabled on app that are non-blocking but cannot be cloned. The app can still be cloned but the features
	// in this list will not be set up on cloned app.
	UnsupportedFeatures []*SiteCloneabilityCriterion `json:"unsupportedFeatures,omitempty"`
}

// SiteCloneabilityCriterion - An app cloneability criterion.
type SiteCloneabilityCriterion struct {
	// Description of criterion.
	Description *string `json:"description,omitempty"`

	// Name of criterion.
	Name *string `json:"name,omitempty"`
}

// SiteConfig - Configuration of an App Service app.
type SiteConfig struct {
	// Information about the formal API definition for the app.
	APIDefinition *APIDefinitionInfo `json:"apiDefinition,omitempty"`

	// Azure API management settings linked to the app.
	APIManagementConfig *APIManagementConfig `json:"apiManagementConfig,omitempty"`

	// Flag to use Managed Identity Creds for ACR pull
	AcrUseManagedIdentityCreds *bool `json:"acrUseManagedIdentityCreds,omitempty"`

	// If using user managed identity, the user managed identity ClientId
	AcrUserManagedIdentityID *string `json:"acrUserManagedIdentityID,omitempty"`

	// true if Always On is enabled; otherwise, false.
	AlwaysOn *bool `json:"alwaysOn,omitempty"`

	// App command line to launch.
	AppCommandLine *string `json:"appCommandLine,omitempty"`

	// Application settings.
	AppSettings []*NameValuePair `json:"appSettings,omitempty"`

	// true if Auto Heal is enabled; otherwise, false.
	AutoHealEnabled *bool `json:"autoHealEnabled,omitempty"`

	// Auto Heal rules.
	AutoHealRules *AutoHealRules `json:"autoHealRules,omitempty"`

	// Auto-swap slot name.
	AutoSwapSlotName *string `json:"autoSwapSlotName,omitempty"`

	// List of Azure Storage Accounts.
	AzureStorageAccounts map[string]*AzureStorageInfoValue `json:"azureStorageAccounts,omitempty"`

	// Connection strings.
	ConnectionStrings []*ConnStringInfo `json:"connectionStrings,omitempty"`

	// Cross-Origin Resource Sharing (CORS) settings.
	Cors *CorsSettings `json:"cors,omitempty"`

	// Default documents.
	DefaultDocuments []*string `json:"defaultDocuments,omitempty"`

	// true if detailed error logging is enabled; otherwise, false.
	DetailedErrorLoggingEnabled *bool `json:"detailedErrorLoggingEnabled,omitempty"`

	// Document root.
	DocumentRoot *string `json:"documentRoot,omitempty"`

	// This is work around for polymorphic types.
	Experiments *Experiments `json:"experiments,omitempty"`

	// State of FTP / FTPS service
	FtpsState *FtpsState `json:"ftpsState,omitempty"`

	// Maximum number of workers that a site can scale out to. This setting only applies to the Consumption and Elastic Premium
	// Plans
	FunctionAppScaleLimit *int32 `json:"functionAppScaleLimit,omitempty"`

	// Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled, the ScaleController
	// will not monitor event sources directly, but will instead call to the runtime
	// to get scale status.
	FunctionsRuntimeScaleMonitoringEnabled *bool `json:"functionsRuntimeScaleMonitoringEnabled,omitempty"`

	// true if HTTP logging is enabled; otherwise, false.
	HTTPLoggingEnabled *bool `json:"httpLoggingEnabled,omitempty"`

	// Handler mappings.
	HandlerMappings []*HandlerMapping `json:"handlerMappings,omitempty"`

	// Health check path
	HealthCheckPath *string `json:"healthCheckPath,omitempty"`

	// Http20Enabled: configures a web site to allow clients to connect over http2.0
	Http20Enabled *bool `json:"http20Enabled,omitempty"`

	// IP security restrictions for main.
	IPSecurityRestrictions []*IPSecurityRestriction `json:"ipSecurityRestrictions,omitempty"`

	// Java container.
	JavaContainer *string `json:"javaContainer,omitempty"`

	// Java container version.
	JavaContainerVersion *string `json:"javaContainerVersion,omitempty"`

	// Java version.
	JavaVersion *string `json:"javaVersion,omitempty"`

	// Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string `json:"keyVaultReferenceIdentity,omitempty"`

	// Site limits.
	Limits *SiteLimits `json:"limits,omitempty"`

	// Linux App Framework and version
	LinuxFxVersion *string `json:"linuxFxVersion,omitempty"`

	// Site load balancing.
	LoadBalancing *SiteLoadBalancing `json:"loadBalancing,omitempty"`

	// true to enable local MySQL; otherwise, false.
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`

	// HTTP logs directory size limit.
	LogsDirectorySizeLimit *int32 `json:"logsDirectorySizeLimit,omitempty"`

	// Managed pipeline mode.
	ManagedPipelineMode *ManagedPipelineMode `json:"managedPipelineMode,omitempty"`

	// Managed Service Identity Id
	ManagedServiceIdentityID *int32 `json:"managedServiceIdentityId,omitempty"`

	// MinTlsVersion: configures the minimum version of TLS required for SSL requests
	MinTLSVersion *SupportedTLSVersions `json:"minTlsVersion,omitempty"`

	// Number of minimum instance count for a site This setting only applies to the Elastic Plans
	MinimumElasticInstanceCount *int32 `json:"minimumElasticInstanceCount,omitempty"`

	// .NET Framework version.
	NetFrameworkVersion *string `json:"netFrameworkVersion,omitempty"`

	// Version of Node.js.
	NodeVersion *string `json:"nodeVersion,omitempty"`

	// Number of workers.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty"`

	// Version of PHP.
	PhpVersion *string `json:"phpVersion,omitempty"`

	// Version of PowerShell.
	PowerShellVersion *string `json:"powerShellVersion,omitempty"`

	// Number of preWarmed instances. This setting only applies to the Consumption and Elastic Plans
	PreWarmedInstanceCount *int32 `json:"preWarmedInstanceCount,omitempty"`

	// Property to allow or block all public traffic.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// Publishing user name.
	PublishingUsername *string `json:"publishingUsername,omitempty"`

	// Push endpoint settings.
	Push *PushSettings `json:"push,omitempty"`

	// Version of Python.
	PythonVersion *string `json:"pythonVersion,omitempty"`

	// true if remote debugging is enabled; otherwise, false.
	RemoteDebuggingEnabled *bool `json:"remoteDebuggingEnabled,omitempty"`

	// Remote debugging version.
	RemoteDebuggingVersion *string `json:"remoteDebuggingVersion,omitempty"`

	// true if request tracing is enabled; otherwise, false.
	RequestTracingEnabled *bool `json:"requestTracingEnabled,omitempty"`

	// Request tracing expiration time.
	RequestTracingExpirationTime *time.Time `json:"requestTracingExpirationTime,omitempty"`

	// IP security restrictions for scm.
	ScmIPSecurityRestrictions []*IPSecurityRestriction `json:"scmIpSecurityRestrictions,omitempty"`

	// IP security restrictions for scm to use main.
	ScmIPSecurityRestrictionsUseMain *bool `json:"scmIpSecurityRestrictionsUseMain,omitempty"`

	// ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
	ScmMinTLSVersion *SupportedTLSVersions `json:"scmMinTlsVersion,omitempty"`

	// SCM type.
	ScmType *ScmType `json:"scmType,omitempty"`

	// Tracing options.
	TracingOptions *string `json:"tracingOptions,omitempty"`

	// true to use 32-bit worker process; otherwise, false.
	Use32BitWorkerProcess *bool `json:"use32BitWorkerProcess,omitempty"`

	// Virtual applications.
	VirtualApplications []*VirtualApplication `json:"virtualApplications,omitempty"`

	// Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`

	// The number of private ports assigned to this app. These will be assigned dynamically on runtime.
	VnetPrivatePortsCount *int32 `json:"vnetPrivatePortsCount,omitempty"`

	// Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined
	// Routes applied.
	VnetRouteAllEnabled *bool `json:"vnetRouteAllEnabled,omitempty"`

	// true if WebSocket is enabled; otherwise, false.
	WebSocketsEnabled *bool `json:"webSocketsEnabled,omitempty"`

	// Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITETIMEZONE
	// app setting takes precedence over this config. For Linux, expects
	// tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/Listoftzdatabasetimezones).
	// For Windows, expects one of the time zones listed under HKEY
	// LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones
	WebsiteTimeZone *string `json:"websiteTimeZone,omitempty"`

	// Xenon App Framework and version
	WindowsFxVersion *string `json:"windowsFxVersion,omitempty"`

	// Explicit Managed Service Identity Id
	XManagedServiceIdentityID *int32 `json:"xManagedServiceIdentityId,omitempty"`

	// READ-ONLY; Site MachineKey.
	MachineKey *SiteMachineKey `json:"machineKey,omitempty" azure:"ro"`
}

// SiteConfigPropertiesDictionary - Site config properties dictionary.
type SiteConfigPropertiesDictionary struct {
	// READ-ONLY; JavaVersion configuration setting.
	JavaVersion *string `json:"javaVersion,omitempty" azure:"ro"`

	// READ-ONLY; LinuxFxVersion configuration setting.
	LinuxFxVersion *string `json:"linuxFxVersion,omitempty" azure:"ro"`

	// READ-ONLY; PowerShellVersion configuration setting.
	PowerShellVersion *string `json:"powerShellVersion,omitempty" azure:"ro"`

	// READ-ONLY; true if use32BitWorkerProcess should be set to true for the stack; otherwise, false.
	Use32BitWorkerProcess *bool `json:"use32BitWorkerProcess,omitempty" azure:"ro"`
}

// SiteConfigResource - Web app configuration ARM resource.
type SiteConfigResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *SiteConfig `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteConfigResourceCollection - Collection of site configurations.
type SiteConfigResourceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteConfigResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SiteConfigurationSnapshotInfo - A snapshot of a web app configuration.
type SiteConfigurationSnapshotInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteConfigurationSnapshotInfo resource specific properties
	Properties *SiteConfigurationSnapshotInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteConfigurationSnapshotInfoCollection - Collection of metadata for the app configuration snapshots that can be restored.
type SiteConfigurationSnapshotInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteConfigurationSnapshotInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SiteConfigurationSnapshotInfoProperties - SiteConfigurationSnapshotInfo resource specific properties
type SiteConfigurationSnapshotInfoProperties struct {
	// READ-ONLY; The id of the snapshot
	SnapshotID *int32 `json:"snapshotId,omitempty" azure:"ro"`

	// READ-ONLY; The time the snapshot was taken.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// SiteExtensionInfo - Site Extension Information.
type SiteExtensionInfo struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteExtensionInfo resource specific properties
	Properties *SiteExtensionInfoProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteExtensionInfoCollection - Collection of Kudu site extension information elements.
type SiteExtensionInfoCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SiteExtensionInfo `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SiteExtensionInfoProperties - SiteExtensionInfo resource specific properties
type SiteExtensionInfoProperties struct {
	// List of authors.
	Authors []*string `json:"authors,omitempty"`

	// Site Extension comment.
	Comment *string `json:"comment,omitempty"`

	// Detailed description.
	Description *string `json:"description,omitempty"`

	// Count of downloads.
	DownloadCount *int32 `json:"download_count,omitempty"`

	// Site extension ID.
	ExtensionID *string `json:"extension_id,omitempty"`

	// Site extension type.
	ExtensionType *SiteExtensionType `json:"extension_type,omitempty"`

	// Extension URL.
	ExtensionURL *string `json:"extension_url,omitempty"`

	// Feed URL.
	FeedURL *string `json:"feed_url,omitempty"`

	// Icon URL.
	IconURL *string `json:"icon_url,omitempty"`

	// Installed timestamp.
	InstalledDateTime *time.Time `json:"installed_date_time,omitempty"`

	// Installer command line parameters.
	InstallerCommandLineParams *string `json:"installer_command_line_params,omitempty"`

	// License URL.
	LicenseURL *string `json:"license_url,omitempty"`

	// true if the local version is the latest version; false otherwise.
	LocalIsLatestVersion *bool `json:"local_is_latest_version,omitempty"`

	// Local path.
	LocalPath *string `json:"local_path,omitempty"`

	// Project URL.
	ProjectURL *string `json:"project_url,omitempty"`

	// Provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Published timestamp.
	PublishedDateTime *time.Time `json:"published_date_time,omitempty"`

	// Summary description.
	Summary *string `json:"summary,omitempty"`
	Title   *string `json:"title,omitempty"`

	// Version information.
	Version *string `json:"version,omitempty"`
}

// SiteLimits - Metric limits set on an app.
type SiteLimits struct {
	// Maximum allowed disk size usage in MB.
	MaxDiskSizeInMb *int64 `json:"maxDiskSizeInMb,omitempty"`

	// Maximum allowed memory usage in MB.
	MaxMemoryInMb *int64 `json:"maxMemoryInMb,omitempty"`

	// Maximum allowed CPU usage percentage.
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
}

// SiteLogsConfig - Configuration of App Service site logs.
type SiteLogsConfig struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteLogsConfig resource specific properties
	Properties *SiteLogsConfigProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteLogsConfigProperties - SiteLogsConfig resource specific properties
type SiteLogsConfigProperties struct {
	// Application logs configuration.
	ApplicationLogs *ApplicationLogsConfig `json:"applicationLogs,omitempty"`

	// Detailed error messages configuration.
	DetailedErrorMessages *EnabledConfig `json:"detailedErrorMessages,omitempty"`

	// Failed requests tracing configuration.
	FailedRequestsTracing *EnabledConfig `json:"failedRequestsTracing,omitempty"`

	// HTTP logs configuration.
	HTTPLogs *HTTPLogsConfig `json:"httpLogs,omitempty"`
}

// SiteMachineKey - MachineKey of an app.
type SiteMachineKey struct {
	// Algorithm used for decryption.
	Decryption *string `json:"decryption,omitempty"`

	// Decryption key.
	DecryptionKey *string `json:"decryptionKey,omitempty"`

	// MachineKey validation.
	Validation *string `json:"validation,omitempty"`

	// Validation key.
	ValidationKey *string `json:"validationKey,omitempty"`
}

// SitePatchResource - ARM resource for a site.
type SitePatchResource struct {
	// Managed service identity.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SitePatchResource resource specific properties
	Properties *SitePatchResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SitePatchResourceProperties - SitePatchResource resource specific properties
type SitePatchResourceProperties struct {
	// true to enable client affinity; false to stop sending session affinity cookies, which route client requests in the same
	// session to the same instance. Default is true.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`

	// true to enable client certificate authentication (TLS mutual authentication); otherwise, false. Default is false.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`

	// client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string `json:"clientCertExclusionPaths,omitempty"`

	// This composes with ClientCertEnabled setting.
	// * ClientCertEnabled: false means ClientCert is ignored.
	// * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
	// * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
	ClientCertMode *ClientCertMode `json:"clientCertMode,omitempty"`

	// If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`

	// Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`

	// Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
	CustomDomainVerificationID *string `json:"customDomainVerificationId,omitempty"`

	// Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`

	// true if the app is enabled; otherwise, false. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`

	// HttpsOnly: configures a web site to accept only https requests. Issues redirect for http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSSLStates []*HostNameSSLState `json:"hostNameSslStates,omitempty"`

	// true to disable the public hostnames of the app; otherwise, false. If true, the app is only accessible via API management
	// process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`

	// App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// Hyper-V sandbox.
	HyperV *bool `json:"hyperV,omitempty"`

	// Obsolete: Hyper-V sandbox.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string `json:"keyVaultReferenceIdentity,omitempty"`

	// Site redundancy mode
	RedundancyMode *RedundancyMode `json:"redundancyMode,omitempty"`

	// true if reserved; otherwise, false.
	Reserved *bool `json:"reserved,omitempty"`

	// true to stop SCM (KUDU) site when the app is stopped; otherwise, false. The default is false.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`

	// Checks if Customer provided storage account is required
	StorageAccountRequired *bool `json:"storageAccountRequired,omitempty"`

	// Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration. This must be of
	// the form
	// /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`

	// READ-ONLY; Management information availability state for the app.
	AvailabilityState *SiteAvailabilityState `json:"availabilityState,omitempty" azure:"ro"`

	// READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty" azure:"ro"`

	// READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise, the app
	// is not served on those hostnames.
	EnabledHostNames []*string `json:"enabledHostNames,omitempty" azure:"ro"`

	// READ-ONLY; Hostnames associated with the app.
	HostNames []*string `json:"hostNames,omitempty" azure:"ro"`

	// READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *string `json:"inProgressOperationId,omitempty" azure:"ro"`

	// READ-ONLY; true if the app is a default container; otherwise, false.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty" azure:"ro"`

	// READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUTC *time.Time `json:"lastModifiedTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of workers. This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants
	// that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all
	// tenants except dataComponent. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the app.
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *time.Time `json:"suspendedTill,omitempty" azure:"ro"`

	// READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty" azure:"ro"`

	// READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames []*string `json:"trafficManagerHostNames,omitempty" azure:"ro"`

	// READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only.
	UsageState *UsageState `json:"usageState,omitempty" azure:"ro"`
}

// SitePhpErrorLogFlag - Used for getting PHP error logging flag.
type SitePhpErrorLogFlag struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SitePhpErrorLogFlag resource specific properties
	Properties *SitePhpErrorLogFlagProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SitePhpErrorLogFlagProperties - SitePhpErrorLogFlag resource specific properties
type SitePhpErrorLogFlagProperties struct {
	// Local log_errors setting.
	LocalLogErrors *string `json:"localLogErrors,omitempty"`

	// Local logerrorsmax_len setting.
	LocalLogErrorsMaxLength *string `json:"localLogErrorsMaxLength,omitempty"`

	// Master log_errors setting.
	MasterLogErrors *string `json:"masterLogErrors,omitempty"`

	// Master logerrorsmax_len setting.
	MasterLogErrorsMaxLength *string `json:"masterLogErrorsMaxLength,omitempty"`
}

// SiteProperties - Site resource specific properties
type SiteProperties struct {
	// true to enable client affinity; false to stop sending session affinity cookies, which route client requests in the same
	// session to the same instance. Default is true.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`

	// true to enable client certificate authentication (TLS mutual authentication); otherwise, false. Default is false.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`

	// client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string `json:"clientCertExclusionPaths,omitempty"`

	// This composes with ClientCertEnabled setting.
	// * ClientCertEnabled: false means ClientCert is ignored.
	// * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
	// * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted.
	ClientCertMode *ClientCertMode `json:"clientCertMode,omitempty"`

	// If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`

	// Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`

	// Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
	CustomDomainVerificationID *string `json:"customDomainVerificationId,omitempty"`

	// Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`

	// true if the app is enabled; otherwise, false. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`

	// HttpsOnly: configures a web site to accept only https requests. Issues redirect for http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`

	// Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSSLStates []*HostNameSSLState `json:"hostNameSslStates,omitempty"`

	// true to disable the public hostnames of the app; otherwise, false. If true, the app is only accessible via API management
	// process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`

	// App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`

	// Hyper-V sandbox.
	HyperV *bool `json:"hyperV,omitempty"`

	// Obsolete: Hyper-V sandbox.
	IsXenon *bool `json:"isXenon,omitempty"`

	// Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string `json:"keyVaultReferenceIdentity,omitempty"`

	// Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// Site redundancy mode
	RedundancyMode *RedundancyMode `json:"redundancyMode,omitempty"`

	// true if reserved; otherwise, false.
	Reserved *bool `json:"reserved,omitempty"`

	// true to stop SCM (KUDU) site when the app is stopped; otherwise, false. The default is false.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`

	// Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`

	// Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`

	// Checks if Customer provided storage account is required
	StorageAccountRequired *bool `json:"storageAccountRequired,omitempty"`

	// Azure Resource Manager ID of the Virtual network and subnet to be joined by Regional VNET Integration. This must be of
	// the form
	// /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`

	// To enable accessing content over virtual network
	VnetContentShareEnabled *bool `json:"vnetContentShareEnabled,omitempty"`

	// To enable pulling image over Virtual Network
	VnetImagePullEnabled *bool `json:"vnetImagePullEnabled,omitempty"`

	// Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined
	// Routes applied.
	VnetRouteAllEnabled *bool `json:"vnetRouteAllEnabled,omitempty"`

	// READ-ONLY; Management information availability state for the app.
	AvailabilityState *SiteAvailabilityState `json:"availabilityState,omitempty" azure:"ro"`

	// READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty" azure:"ro"`

	// READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise, the app
	// is not served on those hostnames.
	EnabledHostNames []*string `json:"enabledHostNames,omitempty" azure:"ro"`

	// READ-ONLY; Hostnames associated with the app.
	HostNames []*string `json:"hostNames,omitempty" azure:"ro"`

	// READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *string `json:"inProgressOperationId,omitempty" azure:"ro"`

	// READ-ONLY; true if the app is a default container; otherwise, false.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty" azure:"ro"`

	// READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUTC *time.Time `json:"lastModifiedTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; Maximum number of workers. This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants
	// that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all
	// tenants except dataComponent. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty" azure:"ro"`

	// READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty" azure:"ro"`

	// READ-ONLY; Current state of the app.
	State *string `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *time.Time `json:"suspendedTill,omitempty" azure:"ro"`

	// READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty" azure:"ro"`

	// READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames []*string `json:"trafficManagerHostNames,omitempty" azure:"ro"`

	// READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only.
	UsageState *UsageState `json:"usageState,omitempty" azure:"ro"`
}

// SiteSeal - Site seal
type SiteSeal struct {
	// REQUIRED; HTML snippet
	HTML *string `json:"html,omitempty"`
}

// SiteSealRequest - Site seal request.
type SiteSealRequest struct {
	// If true use the light color theme for site seal; otherwise, use the default color theme.
	LightTheme *bool `json:"lightTheme,omitempty"`

	// Locale of site seal.
	Locale *string `json:"locale,omitempty"`
}

// SiteSourceControl - Source control configuration for an app.
type SiteSourceControl struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SiteSourceControl resource specific properties
	Properties *SiteSourceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SiteSourceControlProperties - SiteSourceControl resource specific properties
type SiteSourceControlProperties struct {
	// Name of branch to use for deployment.
	Branch *string `json:"branch,omitempty"`

	// true to enable deployment rollback; otherwise, false.
	DeploymentRollbackEnabled *bool `json:"deploymentRollbackEnabled,omitempty"`

	// If GitHub Action is selected, than the associated configuration.
	GitHubActionConfiguration *GitHubActionConfiguration `json:"gitHubActionConfiguration,omitempty"`

	// true if this is deployed via GitHub action.
	IsGitHubAction *bool `json:"isGitHubAction,omitempty"`

	// true to limit to manual integration; false to enable continuous integration (which configures webhooks into online repos
	// like GitHub).
	IsManualIntegration *bool `json:"isManualIntegration,omitempty"`

	// true for a Mercurial repository; false for a Git repository.
	IsMercurial *bool `json:"isMercurial,omitempty"`

	// Repository or source control URL.
	RepoURL *string `json:"repoUrl,omitempty"`
}

// SlotConfigNames - Names for connection strings, application settings, and external Azure storage account configuration
// identifiers to be marked as sticky to the deployment slot and not moved during a swap operation.
// This is valid for all deployment slots in an app.
type SlotConfigNames struct {
	// List of application settings names.
	AppSettingNames []*string `json:"appSettingNames,omitempty"`

	// List of external Azure storage account identifiers.
	AzureStorageConfigNames []*string `json:"azureStorageConfigNames,omitempty"`

	// List of connection string names.
	ConnectionStringNames []*string `json:"connectionStringNames,omitempty"`
}

// SlotConfigNamesResource - Slot Config names azure resource.
type SlotConfigNamesResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *SlotConfigNames `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SlotDifference - A setting difference between two deployment slots of an app.
type SlotDifference struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SlotDifference resource specific properties
	Properties *SlotDifferenceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SlotDifferenceCollection - Collection of slot differences.
type SlotDifferenceCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SlotDifference `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SlotDifferenceProperties - SlotDifference resource specific properties
type SlotDifferenceProperties struct {
	// READ-ONLY; Description of the setting difference.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Rule that describes how to process the setting difference during a slot swap.
	DiffRule *string `json:"diffRule,omitempty" azure:"ro"`

	// READ-ONLY; Level of the difference: Information, Warning or Error.
	Level *string `json:"level,omitempty" azure:"ro"`

	// READ-ONLY; Name of the setting.
	SettingName *string `json:"settingName,omitempty" azure:"ro"`

	// READ-ONLY; The type of the setting: General, AppSetting or ConnectionString.
	SettingType *string `json:"settingType,omitempty" azure:"ro"`

	// READ-ONLY; Value of the setting in the current slot.
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty" azure:"ro"`

	// READ-ONLY; Value of the setting in the target slot.
	ValueInTargetSlot *string `json:"valueInTargetSlot,omitempty" azure:"ro"`
}

// SlotSwapStatus - The status of the last successful slot swap operation.
type SlotSwapStatus struct {
	// READ-ONLY; The destination slot of the last swap operation.
	DestinationSlotName *string `json:"destinationSlotName,omitempty" azure:"ro"`

	// READ-ONLY; The source slot of the last swap operation.
	SourceSlotName *string `json:"sourceSlotName,omitempty" azure:"ro"`

	// READ-ONLY; The time the last successful slot swap completed.
	TimestampUTC *time.Time `json:"timestampUtc,omitempty" azure:"ro"`
}

// SlowRequestsBasedTrigger - Trigger based on request execution time.
type SlowRequestsBasedTrigger struct {
	// Request Count.
	Count *int32 `json:"count,omitempty"`

	// Request Path.
	Path *string `json:"path,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`

	// Time taken.
	TimeTaken *string `json:"timeTaken,omitempty"`
}

// Snapshot - A snapshot of an app.
type Snapshot struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Snapshot resource specific properties
	Properties *SnapshotProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotCollection - Collection of snapshots which can be used to revert an app to a previous time.
type SnapshotCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Snapshot `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SnapshotProperties - Snapshot resource specific properties
type SnapshotProperties struct {
	// READ-ONLY; The time the snapshot was taken.
	Time *string `json:"time,omitempty" azure:"ro"`
}

// SnapshotRecoverySource - Specifies the web app that snapshot contents will be retrieved from.
type SnapshotRecoverySource struct {
	// ARM resource ID of the source app. /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
	// for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for
	// other slots.
	ID *string `json:"id,omitempty"`

	// Geographical location of the source web app, e.g. SouthEastAsia, SouthCentralUS
	Location *string `json:"location,omitempty"`
}

// SnapshotRestoreRequest - Details about app recovery operation.
type SnapshotRestoreRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SnapshotRestoreRequest resource specific properties
	Properties *SnapshotRestoreRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SnapshotRestoreRequestProperties - SnapshotRestoreRequest resource specific properties
type SnapshotRestoreRequestProperties struct {
	// REQUIRED; If true the restore operation can overwrite source app; otherwise, false.
	Overwrite *bool `json:"overwrite,omitempty"`

	// If true, custom hostname conflicts will be ignored when recovering to a target web app. This setting is only necessary
	// when RecoverConfiguration is enabled.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`

	// If true, site configuration, in addition to content, will be reverted.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`

	// Optional. Specifies the web app that snapshot contents will be retrieved from. If empty, the targeted web app will be used
	// as the source.
	RecoverySource *SnapshotRecoverySource `json:"recoverySource,omitempty"`

	// Point in time in which the app restore should be done, formatted as a DateTime string.
	SnapshotTime *string `json:"snapshotTime,omitempty"`

	// If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool `json:"useDRSecondary,omitempty"`
}

// Solution - Class Representing Solution for problems detected.
type Solution struct {
	// Solution Data.
	Data [][]*NameValuePair `json:"data,omitempty"`

	// Description of the solution
	Description *string `json:"description,omitempty"`

	// Display Name of the solution
	DisplayName *string `json:"displayName,omitempty"`

	// Solution Id.
	ID *float64 `json:"id,omitempty"`

	// Solution Metadata.
	Metadata [][]*NameValuePair `json:"metadata,omitempty"`

	// Order of the solution.
	Order *float64 `json:"order,omitempty"`

	// Type of Solution
	Type *SolutionType `json:"type,omitempty"`
}

// SourceControl - The source control OAuth token.
type SourceControl struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SourceControl resource specific properties
	Properties *SourceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SourceControlCollection - Collection of source controls.
type SourceControlCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SourceControl `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SourceControlProperties - SourceControl resource specific properties
type SourceControlProperties struct {
	// OAuth token expiration.
	ExpirationTime *time.Time `json:"expirationTime,omitempty"`

	// OAuth refresh token.
	RefreshToken *string `json:"refreshToken,omitempty"`

	// OAuth access token.
	Token *string `json:"token,omitempty"`

	// OAuth access token secret.
	TokenSecret *string `json:"tokenSecret,omitempty"`
}

// StackMajorVersion - Application stack major version.
type StackMajorVersion struct {
	// Example: All the function apps need AppSetting: "FUNCTIONSWORKERRUNTIME" to be set stack name
	AppSettingsDictionary map[string]interface{} `json:"appSettingsDictionary,omitempty"`

	// true if this supports Application Insights; otherwise, false.
	ApplicationInsights *bool `json:"applicationInsights,omitempty"`

	// Application stack major version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`

	// true if this is the default major version; otherwise, false.
	IsDefault *bool `json:"isDefault,omitempty"`

	// true if this stack has been deprecated, otherwise false.
	IsDeprecated *bool `json:"isDeprecated,omitempty"`

	// true if this stack should be hidden for new customers on portal, otherwise false.
	IsHidden *bool `json:"isHidden,omitempty"`

	// true if this stack is in Preview, otherwise false.
	IsPreview *bool `json:"isPreview,omitempty"`

	// Minor versions associated with the major version.
	MinorVersions []*StackMinorVersion `json:"minorVersions,omitempty"`

	// Application stack major version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`

	// Example: All Linux Function Apps, need Use32BitWorkerProcess to be set to 0
	SiteConfigPropertiesDictionary map[string]interface{} `json:"siteConfigPropertiesDictionary,omitempty"`
}

// StackMinorVersion - Application stack minor version.
type StackMinorVersion struct {
	// Application stack minor version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`

	// true if this is the default minor version; otherwise, false.
	IsDefault *bool `json:"isDefault,omitempty"`

	// true if this supports Remote Debugging, otherwise false.
	IsRemoteDebuggingEnabled *bool `json:"isRemoteDebuggingEnabled,omitempty"`

	// Application stack minor version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// StampCapacity - Stamp capacity information.
type StampCapacity struct {
	// Available capacity (# of machines, bytes of storage etc…).
	AvailableCapacity *int64 `json:"availableCapacity,omitempty"`

	// Shared/dedicated workers.
	ComputeMode *ComputeModeOptions `json:"computeMode,omitempty"`

	// If true, it includes basic apps. Basic apps are not used for capacity allocation.
	ExcludeFromCapacityAllocation *bool `json:"excludeFromCapacityAllocation,omitempty"`

	// true if capacity is applicable for all apps; otherwise, false.
	IsApplicableForAllComputeModes *bool `json:"isApplicableForAllComputeModes,omitempty"`

	// Is this a linux stamp capacity
	IsLinux *bool `json:"isLinux,omitempty"`

	// Name of the stamp.
	Name *string `json:"name,omitempty"`

	// Shared or Dedicated.
	SiteMode *string `json:"siteMode,omitempty"`

	// Total capacity (# of machines, bytes of storage etc…).
	TotalCapacity *int64 `json:"totalCapacity,omitempty"`

	// Name of the unit.
	Unit *string `json:"unit,omitempty"`

	// Size of the machines.
	WorkerSize *WorkerSizeOptions `json:"workerSize,omitempty"`

	// Size ID of machines: 0 - Small 1 - Medium 2 - Large
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
}

// StampCapacityCollection - Collection of stamp capacities.
type StampCapacityCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StampCapacity `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSite - A static site.
type StaticSite struct {
	// false if config file is locked for this static web app; otherwise, true.
	AllowConfigFileUpdates *bool `json:"allowConfigFileUpdates,omitempty"`

	// The target branch in the repository.
	Branch *string `json:"branch,omitempty"`

	// Build properties to configure on the repository.
	BuildProperties *StaticSiteBuildProperties `json:"buildProperties,omitempty"`

	// State indicating the status of the enterprise grade CDN serving traffic to the static web app.
	EnterpriseGradeCdnStatus *EnterpriseGradeCdnStatus `json:"enterpriseGradeCdnStatus,omitempty"`

	// The provider that submitted the last deployment to the primary environment of the static site.
	Provider *string `json:"provider,omitempty"`

	// State indicating whether public traffic are allowed or not for a static web app. Allowed Values: 'Enabled', 'Disabled'
	// or an empty string.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
	RepositoryToken *string `json:"repositoryToken,omitempty"`

	// URL for the repository of the static site.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`

	// State indicating whether staging environments are allowed or not allowed for a static web app.
	StagingEnvironmentPolicy *StagingEnvironmentPolicy `json:"stagingEnvironmentPolicy,omitempty"`

	// Template options for generating a new repository.
	TemplateProperties *StaticSiteTemplateOptions `json:"templateProperties,omitempty"`

	// READ-ONLY; The content distribution endpoint for the static site.
	ContentDistributionEndpoint *string `json:"contentDistributionEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The custom domains associated with this static site.
	CustomDomains []*string `json:"customDomains,omitempty" azure:"ro"`

	// READ-ONLY; The default autogenerated hostname for the static site.
	DefaultHostname *string `json:"defaultHostname,omitempty" azure:"ro"`

	// READ-ONLY; Identity to use for Key Vault Reference authentication.
	KeyVaultReferenceIdentity *string `json:"keyVaultReferenceIdentity,omitempty" azure:"ro"`

	// READ-ONLY; Backends linked to the static side
	LinkedBackends []*StaticSiteLinkedBackend `json:"linkedBackends,omitempty" azure:"ro"`

	// READ-ONLY; Private endpoint connections
	PrivateEndpointConnections []*ResponseMessageEnvelopeRemotePrivateEndpointConnection `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; User provided function apps registered with the static site
	UserProvidedFunctionApps []*StaticSiteUserProvidedFunctionApp `json:"userProvidedFunctionApps,omitempty" azure:"ro"`
}

// StaticSiteARMResource - Static Site ARM resource.
type StaticSiteARMResource struct {
	// REQUIRED; Resource Location.
	Location *string `json:"location,omitempty"`

	// Managed service identity.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *StaticSite `json:"properties,omitempty"`

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteBuildARMResource - Static Site Build ARM resource.
type StaticSiteBuildARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteBuildARMResource resource specific properties
	Properties *StaticSiteBuildARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteBuildARMResourceProperties - StaticSiteBuildARMResource resource specific properties
type StaticSiteBuildARMResourceProperties struct {
	// READ-ONLY; An identifier for the static site build.
	BuildID *string `json:"buildId,omitempty" azure:"ro"`

	// READ-ONLY; When this build was created.
	CreatedTimeUTC *time.Time `json:"createdTimeUtc,omitempty" azure:"ro"`

	// READ-ONLY; The hostname for a static site build.
	Hostname *string `json:"hostname,omitempty" azure:"ro"`

	// READ-ONLY; When this build was updated.
	LastUpdatedOn *time.Time `json:"lastUpdatedOn,omitempty" azure:"ro"`

	// READ-ONLY; Backends linked to the static side build
	LinkedBackends []*StaticSiteLinkedBackend `json:"linkedBackends,omitempty" azure:"ro"`

	// READ-ONLY; The title of a pull request that a static site build is related to.
	PullRequestTitle *string `json:"pullRequestTitle,omitempty" azure:"ro"`

	// READ-ONLY; The source branch.
	SourceBranch *string `json:"sourceBranch,omitempty" azure:"ro"`

	// READ-ONLY; The status of the static site build.
	Status *BuildStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; User provided function apps registered with the static site build
	UserProvidedFunctionApps []*StaticSiteUserProvidedFunctionApp `json:"userProvidedFunctionApps,omitempty" azure:"ro"`
}

// StaticSiteBuildCollection - Collection of static site builds.
type StaticSiteBuildCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteBuildARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSiteBuildProperties - Build properties for the static site.
type StaticSiteBuildProperties struct {
	// A custom command to run during deployment of the Azure Functions API application.
	APIBuildCommand *string `json:"apiBuildCommand,omitempty"`

	// The path to the api code within the repository.
	APILocation *string `json:"apiLocation,omitempty"`

	// Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
	AppArtifactLocation *string `json:"appArtifactLocation,omitempty"`

	// A custom command to run during deployment of the static content application.
	AppBuildCommand *string `json:"appBuildCommand,omitempty"`

	// The path to the app code within the repository.
	AppLocation *string `json:"appLocation,omitempty"`

	// Github Action secret name override.
	GithubActionSecretNameOverride *string `json:"githubActionSecretNameOverride,omitempty"`

	// The output path of the app after building.
	OutputLocation *string `json:"outputLocation,omitempty"`

	// Skip Github Action workflow generation.
	SkipGithubActionWorkflowGeneration *bool `json:"skipGithubActionWorkflowGeneration,omitempty"`
}

// StaticSiteCollection - Collection of static sites.
type StaticSiteCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSiteCustomDomainOverviewARMResource - Static Site Custom Domain Overview ARM resource.
type StaticSiteCustomDomainOverviewARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteCustomDomainOverviewARMResource resource specific properties
	Properties *StaticSiteCustomDomainOverviewARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteCustomDomainOverviewARMResourceProperties - StaticSiteCustomDomainOverviewARMResource resource specific properties
type StaticSiteCustomDomainOverviewARMResourceProperties struct {
	// READ-ONLY; The date and time on which the custom domain was created for the static site.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; The domain name for the static site custom domain.
	DomainName *string `json:"domainName,omitempty" azure:"ro"`

	// READ-ONLY
	ErrorMessage *string `json:"errorMessage,omitempty" azure:"ro"`

	// READ-ONLY; The status of the custom domain
	Status *CustomDomainStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The TXT record validation token
	ValidationToken *string `json:"validationToken,omitempty" azure:"ro"`
}

// StaticSiteCustomDomainOverviewCollection - Collection of static site custom domains.
type StaticSiteCustomDomainOverviewCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteCustomDomainOverviewARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSiteCustomDomainRequestPropertiesARMResource - Static Site Custom Domain Request Properties ARM resource.
type StaticSiteCustomDomainRequestPropertiesARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteCustomDomainRequestPropertiesARMResource resource specific properties
	Properties *StaticSiteCustomDomainRequestPropertiesARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteCustomDomainRequestPropertiesARMResourceProperties - StaticSiteCustomDomainRequestPropertiesARMResource resource
// specific properties
type StaticSiteCustomDomainRequestPropertiesARMResourceProperties struct {
	// Validation method for adding a custom domain
	ValidationMethod *string `json:"validationMethod,omitempty"`
}

// StaticSiteFunctionOverviewARMResource - Static Site Function Overview ARM resource.
type StaticSiteFunctionOverviewARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteFunctionOverviewARMResource resource specific properties
	Properties *StaticSiteFunctionOverviewARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteFunctionOverviewARMResourceProperties - StaticSiteFunctionOverviewARMResource resource specific properties
type StaticSiteFunctionOverviewARMResourceProperties struct {
	// READ-ONLY; The name for the function
	FunctionName *string `json:"functionName,omitempty" azure:"ro"`

	// READ-ONLY; The trigger type of the function
	TriggerType *TriggerTypes `json:"triggerType,omitempty" azure:"ro"`
}

// StaticSiteFunctionOverviewCollection - Collection of static site functions.
type StaticSiteFunctionOverviewCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteFunctionOverviewARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSiteLinkedBackend - Static Site Linked Backend ARM resource.
type StaticSiteLinkedBackend struct {
	// The resource id of the backend linked to the static site
	BackendResourceID *string `json:"backendResourceId,omitempty"`

	// The region of the backend linked to the static site
	Region *string `json:"region,omitempty"`

	// READ-ONLY; The date and time on which the backend was linked to the static site.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the linking process.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// StaticSiteLinkedBackendARMResource - Static Site Linked Backend ARM resource.
type StaticSiteLinkedBackendARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteLinkedBackendARMResource resource specific properties
	Properties *StaticSiteLinkedBackendARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteLinkedBackendARMResourceProperties - StaticSiteLinkedBackendARMResource resource specific properties
type StaticSiteLinkedBackendARMResourceProperties struct {
	// The resource id of the backend linked to the static site
	BackendResourceID *string `json:"backendResourceId,omitempty"`

	// The region of the backend linked to the static site
	Region *string `json:"region,omitempty"`

	// READ-ONLY; The date and time on which the backend was linked to the static site.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the linking process.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// StaticSiteLinkedBackendsCollection - Collection of static site linked backends.
type StaticSiteLinkedBackendsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteLinkedBackendARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSitePatchResource - ARM resource for a static site when patching
type StaticSitePatchResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *StaticSite `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteResetPropertiesARMResource - Static Site Reset Properties ARM resource.
type StaticSiteResetPropertiesARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteResetPropertiesARMResource resource specific properties
	Properties *StaticSiteResetPropertiesARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteResetPropertiesARMResourceProperties - StaticSiteResetPropertiesARMResource resource specific properties
type StaticSiteResetPropertiesARMResourceProperties struct {
	// The token which proves admin privileges to the repository.
	RepositoryToken *string `json:"repositoryToken,omitempty"`

	// Determines whether the repository should be updated with the new properties.
	ShouldUpdateRepository *bool `json:"shouldUpdateRepository,omitempty"`
}

// StaticSiteTemplateOptions - Template Options for the static site.
type StaticSiteTemplateOptions struct {
	// Description of the newly generated repository.
	Description *string `json:"description,omitempty"`

	// Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
	IsPrivate *bool `json:"isPrivate,omitempty"`

	// Owner of the newly generated repository.
	Owner *string `json:"owner,omitempty"`

	// Name of the newly generated repository.
	RepositoryName *string `json:"repositoryName,omitempty"`

	// URL of the template repository. The newly generated repository will be based on this one.
	TemplateRepositoryURL *string `json:"templateRepositoryUrl,omitempty"`
}

// StaticSiteUserARMResource - Static Site User ARM resource.
type StaticSiteUserARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteUserARMResource resource specific properties
	Properties *StaticSiteUserARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteUserARMResourceProperties - StaticSiteUserARMResource resource specific properties
type StaticSiteUserARMResourceProperties struct {
	// The roles for the static site user, in free-form string format
	Roles *string `json:"roles,omitempty"`

	// READ-ONLY; The display name for the static site user.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The identity provider for the static site user.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The user id for the static site user.
	UserID *string `json:"userId,omitempty" azure:"ro"`
}

// StaticSiteUserCollection - Collection of static site custom users.
type StaticSiteUserCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteUserARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSiteUserInvitationRequestResource - Static sites user roles invitation resource.
type StaticSiteUserInvitationRequestResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteUserInvitationRequestResource resource specific properties
	Properties *StaticSiteUserInvitationRequestResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteUserInvitationRequestResourceProperties - StaticSiteUserInvitationRequestResource resource specific properties
type StaticSiteUserInvitationRequestResourceProperties struct {
	// The domain name for the static site custom domain.
	Domain *string `json:"domain,omitempty"`

	// The number of hours the sas token stays valid
	NumHoursToExpiration *int32 `json:"numHoursToExpiration,omitempty"`

	// The identity provider for the static site user.
	Provider *string `json:"provider,omitempty"`

	// The roles for the static site user, in free-form string format
	Roles *string `json:"roles,omitempty"`

	// The user id for the static site user.
	UserDetails *string `json:"userDetails,omitempty"`
}

// StaticSiteUserInvitationResponseResource - Static sites user roles invitation link resource.
type StaticSiteUserInvitationResponseResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteUserInvitationResponseResource resource specific properties
	Properties *StaticSiteUserInvitationResponseResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteUserInvitationResponseResourceProperties - StaticSiteUserInvitationResponseResource resource specific properties
type StaticSiteUserInvitationResponseResourceProperties struct {
	// READ-ONLY; The expiration time of the invitation
	ExpiresOn *time.Time `json:"expiresOn,omitempty" azure:"ro"`

	// READ-ONLY; The url for the invitation link
	InvitationURL *string `json:"invitationUrl,omitempty" azure:"ro"`
}

// StaticSiteUserProvidedFunctionApp - A static site user provided function.
type StaticSiteUserProvidedFunctionApp struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteUserProvidedFunctionApp resource specific properties
	Properties *StaticSiteUserProvidedFunctionAppProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteUserProvidedFunctionAppARMResource - Static Site User Provided Function App ARM resource.
type StaticSiteUserProvidedFunctionAppARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSiteUserProvidedFunctionAppARMResource resource specific properties
	Properties *StaticSiteUserProvidedFunctionAppARMResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSiteUserProvidedFunctionAppARMResourceProperties - StaticSiteUserProvidedFunctionAppARMResource resource specific
// properties
type StaticSiteUserProvidedFunctionAppARMResourceProperties struct {
	// The region of the function app registered with the static site
	FunctionAppRegion *string `json:"functionAppRegion,omitempty"`

	// The resource id of the function app registered with the static site
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`

	// READ-ONLY; The date and time on which the function app was registered with the static site.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`
}

// StaticSiteUserProvidedFunctionAppProperties - StaticSiteUserProvidedFunctionApp resource specific properties
type StaticSiteUserProvidedFunctionAppProperties struct {
	// The region of the function app registered with the static site
	FunctionAppRegion *string `json:"functionAppRegion,omitempty"`

	// The resource id of the function app registered with the static site
	FunctionAppResourceID *string `json:"functionAppResourceId,omitempty"`

	// READ-ONLY; The date and time on which the function app was registered with the static site.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`
}

// StaticSiteUserProvidedFunctionAppsCollection - Collection of static site user provided function apps.
type StaticSiteUserProvidedFunctionAppsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*StaticSiteUserProvidedFunctionAppARMResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// StaticSiteZipDeployment - A static site zip deployment.
type StaticSiteZipDeployment struct {
	// URL for the zipped api content
	APIZipURL *string `json:"apiZipUrl,omitempty"`

	// URL for the zipped app content
	AppZipURL *string `json:"appZipUrl,omitempty"`

	// A title to label the deployment
	DeploymentTitle *string `json:"deploymentTitle,omitempty"`

	// The language of the api content, if it exists
	FunctionLanguage *string `json:"functionLanguage,omitempty"`

	// The provider submitting this deployment
	Provider *string `json:"provider,omitempty"`
}

// StaticSiteZipDeploymentARMResource - Static site zip deployment ARM resource.
type StaticSiteZipDeploymentARMResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *StaticSiteZipDeployment `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the StaticSitesClient.BeginApproveOrRejectPrivateEndpointConnection
// method.
type StaticSitesClientBeginApproveOrRejectPrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions contains the optional parameters for the StaticSitesClient.BeginCreateOrUpdateStaticSiteCustomDomain
// method.
type StaticSitesClientBeginCreateOrUpdateStaticSiteCustomDomainOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginCreateOrUpdateStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginCreateOrUpdateStaticSite
// method.
type StaticSitesClientBeginCreateOrUpdateStaticSiteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.BeginCreateZipDeploymentForStaticSiteBuild
// method.
type StaticSitesClientBeginCreateZipDeploymentForStaticSiteBuildOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginCreateZipDeploymentForStaticSite
// method.
type StaticSitesClientBeginCreateZipDeploymentForStaticSiteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the StaticSitesClient.BeginDeletePrivateEndpointConnection
// method.
type StaticSitesClientBeginDeletePrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginDeleteStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.BeginDeleteStaticSiteBuild
// method.
type StaticSitesClientBeginDeleteStaticSiteBuildOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions contains the optional parameters for the StaticSitesClient.BeginDeleteStaticSiteCustomDomain
// method.
type StaticSitesClientBeginDeleteStaticSiteCustomDomainOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginDeleteStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginDeleteStaticSite
// method.
type StaticSitesClientBeginDeleteStaticSiteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginDetachStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginDetachStaticSite
// method.
type StaticSitesClientBeginDetachStaticSiteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginLinkBackendOptions contains the optional parameters for the StaticSitesClient.BeginLinkBackend method.
type StaticSitesClientBeginLinkBackendOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginLinkBackendToBuildOptions contains the optional parameters for the StaticSitesClient.BeginLinkBackendToBuild
// method.
type StaticSitesClientBeginLinkBackendToBuildOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions contains the optional parameters for the
// StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild method.
type StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteBuildOptions struct {
	// Specify true to force the update of the auth configuration on the function app even if an AzureStaticWebApps provider is
	// already configured on the function app. The default is false.
	IsForced *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSite
// method.
type StaticSitesClientBeginRegisterUserProvidedFunctionAppWithStaticSiteOptions struct {
	// Specify true to force the update of the auth configuration on the function app even if an AzureStaticWebApps provider is
	// already configured on the function app. The default is false.
	IsForced *bool
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginValidateBackendForBuildOptions contains the optional parameters for the StaticSitesClient.BeginValidateBackendForBuild
// method.
type StaticSitesClientBeginValidateBackendForBuildOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginValidateBackendOptions contains the optional parameters for the StaticSitesClient.BeginValidateBackend
// method.
type StaticSitesClientBeginValidateBackendOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions contains the optional parameters for the StaticSitesClient.BeginValidateCustomDomainCanBeAddedToStaticSite
// method.
type StaticSitesClientBeginValidateCustomDomainCanBeAddedToStaticSiteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// StaticSitesClientCreateOrUpdateStaticSiteAppSettingsOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateStaticSiteAppSettings
// method.
type StaticSitesClientCreateOrUpdateStaticSiteAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings
// method.
type StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings
// method.
type StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsOptions contains the optional parameters for the StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings
// method.
type StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientCreateUserRolesInvitationLinkOptions contains the optional parameters for the StaticSitesClient.CreateUserRolesInvitationLink
// method.
type StaticSitesClientCreateUserRolesInvitationLinkOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientDeleteStaticSiteUserOptions contains the optional parameters for the StaticSitesClient.DeleteStaticSiteUser
// method.
type StaticSitesClientDeleteStaticSiteUserOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild
// method.
type StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteOptions contains the optional parameters for the StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite
// method.
type StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetLinkedBackendForBuildOptions contains the optional parameters for the StaticSitesClient.GetLinkedBackendForBuild
// method.
type StaticSitesClientGetLinkedBackendForBuildOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetLinkedBackendOptions contains the optional parameters for the StaticSitesClient.GetLinkedBackend method.
type StaticSitesClientGetLinkedBackendOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetLinkedBackendsForBuildOptions contains the optional parameters for the StaticSitesClient.GetLinkedBackendsForBuild
// method.
type StaticSitesClientGetLinkedBackendsForBuildOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetLinkedBackendsOptions contains the optional parameters for the StaticSitesClient.GetLinkedBackends
// method.
type StaticSitesClientGetLinkedBackendsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the StaticSitesClient.GetPrivateEndpointConnectionList
// method.
type StaticSitesClientGetPrivateEndpointConnectionListOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetPrivateEndpointConnectionOptions contains the optional parameters for the StaticSitesClient.GetPrivateEndpointConnection
// method.
type StaticSitesClientGetPrivateEndpointConnectionOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetPrivateLinkResourcesOptions contains the optional parameters for the StaticSitesClient.GetPrivateLinkResources
// method.
type StaticSitesClientGetPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.GetStaticSiteBuild
// method.
type StaticSitesClientGetStaticSiteBuildOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetStaticSiteBuildsOptions contains the optional parameters for the StaticSitesClient.GetStaticSiteBuilds
// method.
type StaticSitesClientGetStaticSiteBuildsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetStaticSiteCustomDomainOptions contains the optional parameters for the StaticSitesClient.GetStaticSiteCustomDomain
// method.
type StaticSitesClientGetStaticSiteCustomDomainOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetStaticSiteOptions contains the optional parameters for the StaticSitesClient.GetStaticSite method.
type StaticSitesClientGetStaticSiteOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetStaticSitesByResourceGroupOptions contains the optional parameters for the StaticSitesClient.GetStaticSitesByResourceGroup
// method.
type StaticSitesClientGetStaticSitesByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild
// method.
type StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetUserProvidedFunctionAppForStaticSiteOptions contains the optional parameters for the StaticSitesClient.GetUserProvidedFunctionAppForStaticSite
// method.
type StaticSitesClientGetUserProvidedFunctionAppForStaticSiteOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildOptions contains the optional parameters for the StaticSitesClient.GetUserProvidedFunctionAppsForStaticSiteBuild
// method.
type StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteOptions contains the optional parameters for the StaticSitesClient.GetUserProvidedFunctionAppsForStaticSite
// method.
type StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListOptions contains the optional parameters for the StaticSitesClient.List method.
type StaticSitesClientListOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteAppSettings
// method.
type StaticSitesClientListStaticSiteAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteBuildAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteBuildAppSettings
// method.
type StaticSitesClientListStaticSiteBuildAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteBuildFunctionAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteBuildFunctionAppSettings
// method.
type StaticSitesClientListStaticSiteBuildFunctionAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteBuildFunctionsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteBuildFunctions
// method.
type StaticSitesClientListStaticSiteBuildFunctionsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteConfiguredRolesOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteConfiguredRoles
// method.
type StaticSitesClientListStaticSiteConfiguredRolesOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteCustomDomainsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteCustomDomains
// method.
type StaticSitesClientListStaticSiteCustomDomainsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteFunctionAppSettingsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteFunctionAppSettings
// method.
type StaticSitesClientListStaticSiteFunctionAppSettingsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteFunctionsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteFunctions
// method.
type StaticSitesClientListStaticSiteFunctionsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteSecretsOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteSecrets
// method.
type StaticSitesClientListStaticSiteSecretsOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientListStaticSiteUsersOptions contains the optional parameters for the StaticSitesClient.ListStaticSiteUsers
// method.
type StaticSitesClientListStaticSiteUsersOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientPreviewWorkflowOptions contains the optional parameters for the StaticSitesClient.PreviewWorkflow method.
type StaticSitesClientPreviewWorkflowOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientResetStaticSiteAPIKeyOptions contains the optional parameters for the StaticSitesClient.ResetStaticSiteAPIKey
// method.
type StaticSitesClientResetStaticSiteAPIKeyOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientUnlinkBackendFromBuildOptions contains the optional parameters for the StaticSitesClient.UnlinkBackendFromBuild
// method.
type StaticSitesClientUnlinkBackendFromBuildOptions struct {
	// Decides if auth will be removed from backend configuration
	IsCleaningAuthConfig *bool
}

// StaticSitesClientUnlinkBackendOptions contains the optional parameters for the StaticSitesClient.UnlinkBackend method.
type StaticSitesClientUnlinkBackendOptions struct {
	// Decides if Easy Auth configuration will be removed from backend configuration
	IsCleaningAuthConfig *bool
}

// StaticSitesClientUpdateStaticSiteOptions contains the optional parameters for the StaticSitesClient.UpdateStaticSite method.
type StaticSitesClientUpdateStaticSiteOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesClientUpdateStaticSiteUserOptions contains the optional parameters for the StaticSitesClient.UpdateStaticSiteUser
// method.
type StaticSitesClientUpdateStaticSiteUserOptions struct {
	// placeholder for future optional parameters
}

// StaticSitesWorkflowPreview - Preview for the Static Site Workflow to be generated
type StaticSitesWorkflowPreview struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSitesWorkflowPreview resource specific properties
	Properties *StaticSitesWorkflowPreviewProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSitesWorkflowPreviewProperties - StaticSitesWorkflowPreview resource specific properties
type StaticSitesWorkflowPreviewProperties struct {
	// READ-ONLY; The contents for the workflow file to be generated
	Contents *string `json:"contents,omitempty" azure:"ro"`

	// READ-ONLY; The path for the workflow file to be generated
	Path *string `json:"path,omitempty" azure:"ro"`
}

// StaticSitesWorkflowPreviewRequest - Request entity for previewing the Static Site workflow
type StaticSitesWorkflowPreviewRequest struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StaticSitesWorkflowPreviewRequest resource specific properties
	Properties *StaticSitesWorkflowPreviewRequestProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StaticSitesWorkflowPreviewRequestProperties - StaticSitesWorkflowPreviewRequest resource specific properties
type StaticSitesWorkflowPreviewRequestProperties struct {
	// The target branch in the repository.
	Branch *string `json:"branch,omitempty"`

	// Build properties to configure on the repository.
	BuildProperties *StaticSiteBuildProperties `json:"buildProperties,omitempty"`

	// URL for the repository of the static site.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
}

// Status - Identify the status of the most severe insight generated by the detector.
type Status struct {
	// Descriptive message.
	Message *string `json:"message,omitempty"`

	// Level of the most severe insight generated by the detector.
	StatusID *InsightStatus `json:"statusId,omitempty"`
}

// StatusCodesBasedTrigger - Trigger based on status code.
type StatusCodesBasedTrigger struct {
	// Request Count.
	Count *int32 `json:"count,omitempty"`

	// Request Path
	Path *string `json:"path,omitempty"`

	// HTTP status code.
	Status *int32 `json:"status,omitempty"`

	// Request Sub Status.
	SubStatus *int32 `json:"subStatus,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`

	// Win32 error code.
	Win32Status *int32 `json:"win32Status,omitempty"`
}

// StatusCodesRangeBasedTrigger - Trigger based on range of status codes.
type StatusCodesRangeBasedTrigger struct {
	// Request Count.
	Count *int32  `json:"count,omitempty"`
	Path  *string `json:"path,omitempty"`

	// HTTP status code.
	StatusCodes *string `json:"statusCodes,omitempty"`

	// Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// StorageMigrationOptions - Options for app content migration.
type StorageMigrationOptions struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StorageMigrationOptions resource specific properties
	Properties *StorageMigrationOptionsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageMigrationOptionsProperties - StorageMigrationOptions resource specific properties
type StorageMigrationOptionsProperties struct {
	// REQUIRED; AzureFiles connection string.
	AzurefilesConnectionString *string `json:"azurefilesConnectionString,omitempty"`

	// REQUIRED; AzureFiles share.
	AzurefilesShare *string `json:"azurefilesShare,omitempty"`

	// true if the app should be read only during copy operation; otherwise, false.
	BlockWriteAccessToSite *bool `json:"blockWriteAccessToSite,omitempty"`

	// trueif the app should be switched over; otherwise, false.
	SwitchSiteAfterMigration *bool `json:"switchSiteAfterMigration,omitempty"`
}

// StorageMigrationResponse - Response for a migration of app content request.
type StorageMigrationResponse struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// StorageMigrationResponse resource specific properties
	Properties *StorageMigrationResponseProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StorageMigrationResponseProperties - StorageMigrationResponse resource specific properties
type StorageMigrationResponseProperties struct {
	// READ-ONLY; When server starts the migration process, it will return an operation ID identifying that particular migration
	// operation.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// StringDictionary - String dictionary resource.
type StringDictionary struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Settings.
	Properties map[string]*string `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// StringList - String list resource.
type StringList struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// List of string resources.
	Properties []*string `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SubResource - The sub resource type.
type SubResource struct {
	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// SupportTopic - Defines a unique Support Topic
type SupportTopic struct {
	// READ-ONLY; Support Topic Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Unique resource Id
	PesID *string `json:"pesId,omitempty" azure:"ro"`
}

// SwiftVirtualNetwork - Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network
// integration.
type SwiftVirtualNetwork struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// SwiftVirtualNetwork resource specific properties
	Properties *SwiftVirtualNetworkProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SwiftVirtualNetworkProperties - SwiftVirtualNetwork resource specific properties
type SwiftVirtualNetworkProperties struct {
	// The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation
	// to Microsoft.Web/serverFarms defined first.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`

	// A flag that specifies if the scale unit this Web App is on supports Swift integration.
	SwiftSupported *bool `json:"swiftSupported,omitempty"`
}

// Template - Container App versioned application definition. Defines the desired state of an immutable revision. Any changes
// to this section Will result in a new revision being created
type Template struct {
	// List of container definitions for the Container App.
	Containers []*Container `json:"containers,omitempty"`

	// Dapr configuration for the Container App.
	Dapr *Dapr `json:"dapr,omitempty"`

	// User friendly suffix that is appended to the revision name
	RevisionSuffix *string `json:"revisionSuffix,omitempty"`

	// Scaling properties for the Container App.
	Scale *Scale `json:"scale,omitempty"`
}

// TldLegalAgreement - Legal agreement for a top level domain.
type TldLegalAgreement struct {
	// REQUIRED; Unique identifier for the agreement.
	AgreementKey *string `json:"agreementKey,omitempty"`

	// REQUIRED; Agreement details.
	Content *string `json:"content,omitempty"`

	// REQUIRED; Agreement title.
	Title *string `json:"title,omitempty"`

	// URL where a copy of the agreement details is hosted.
	URL *string `json:"url,omitempty"`
}

// TldLegalAgreementCollection - Collection of top-level domain legal agreements.
type TldLegalAgreementCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TldLegalAgreement `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TokenStore - The configuration settings of the token store.
type TokenStore struct {
	// The configuration settings of the storage of the tokens if blob storage is used.
	AzureBlobStorage *BlobStorageTokenStore `json:"azureBlobStorage,omitempty"`

	// true to durably store platform-specific security tokens that are obtained during login flows; otherwise, false. The default
	// is false.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the storage of the tokens if a file system is used.
	FileSystem *FileSystemTokenStore `json:"fileSystem,omitempty"`

	// The number of hours after session token expiration that a session token can be used to call the token refresh API. The
	// default is 72 hours.
	TokenRefreshExtensionHours *float64 `json:"tokenRefreshExtensionHours,omitempty"`
}

// TopLevelDomain - A top level domain object.
type TopLevelDomain struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// TopLevelDomain resource specific properties
	Properties *TopLevelDomainProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TopLevelDomainAgreementOption - Options for retrieving the list of top level domain legal agreements.
type TopLevelDomainAgreementOption struct {
	// If true, then the list of agreements will include agreements for domain transfer as well; otherwise, false.
	ForTransfer *bool `json:"forTransfer,omitempty"`

	// If true, then the list of agreements will include agreements for domain privacy as well; otherwise, false.
	IncludePrivacy *bool `json:"includePrivacy,omitempty"`
}

// TopLevelDomainCollection - Collection of Top-level domains.
type TopLevelDomainCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TopLevelDomain `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TopLevelDomainProperties - TopLevelDomain resource specific properties
type TopLevelDomainProperties struct {
	// If true, then the top level domain supports domain privacy; otherwise, false.
	Privacy *bool `json:"privacy,omitempty"`
}

// TopLevelDomainsClientGetOptions contains the optional parameters for the TopLevelDomainsClient.Get method.
type TopLevelDomainsClientGetOptions struct {
	// placeholder for future optional parameters
}

// TopLevelDomainsClientListAgreementsOptions contains the optional parameters for the TopLevelDomainsClient.ListAgreements
// method.
type TopLevelDomainsClientListAgreementsOptions struct {
	// placeholder for future optional parameters
}

// TopLevelDomainsClientListOptions contains the optional parameters for the TopLevelDomainsClient.List method.
type TopLevelDomainsClientListOptions struct {
	// placeholder for future optional parameters
}

// TrafficWeight - Traffic weight assigned to a revision
type TrafficWeight struct {
	// Indicates that the traffic weight belongs to a latest stable revision
	LatestRevision *bool `json:"latestRevision,omitempty"`

	// Name of a revision
	RevisionName *string `json:"revisionName,omitempty"`

	// Traffic weight assigned to a revision
	Weight *int32 `json:"weight,omitempty"`
}

// TriggeredJobHistory - Triggered Web Job History. List of Triggered Web Job Run Information elements.
type TriggeredJobHistory struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// TriggeredJobHistory resource specific properties
	Properties *TriggeredJobHistoryProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggeredJobHistoryCollection - Collection of Kudu continuous web job information elements.
type TriggeredJobHistoryCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TriggeredJobHistory `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TriggeredJobHistoryProperties - TriggeredJobHistory resource specific properties
type TriggeredJobHistoryProperties struct {
	// List of triggered web job runs.
	Runs []*TriggeredJobRun `json:"runs,omitempty"`
}

// TriggeredJobRun - Triggered Web Job Run Information.
type TriggeredJobRun struct {
	// Job duration.
	Duration *string `json:"duration,omitempty"`

	// End time.
	EndTime *time.Time `json:"end_time,omitempty"`

	// Error URL.
	ErrorURL *string `json:"error_url,omitempty"`

	// Job name.
	JobName *string `json:"job_name,omitempty"`

	// Output URL.
	OutputURL *string `json:"output_url,omitempty"`

	// Start time.
	StartTime *time.Time `json:"start_time,omitempty"`

	// Job status.
	Status *TriggeredWebJobStatus `json:"status,omitempty"`

	// Job trigger.
	Trigger *string `json:"trigger,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Job ID.
	WebJobID *string `json:"web_job_id,omitempty"`

	// Job name.
	WebJobName *string `json:"web_job_name,omitempty"`
}

// TriggeredWebJob - Triggered Web Job Information.
type TriggeredWebJob struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// TriggeredWebJob resource specific properties
	Properties *TriggeredWebJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TriggeredWebJobCollection - Collection of Kudu continuous web job information elements.
type TriggeredWebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*TriggeredWebJob `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// TriggeredWebJobProperties - TriggeredWebJob resource specific properties
type TriggeredWebJobProperties struct {
	// Error information.
	Error *string `json:"error,omitempty"`

	// Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`

	// History URL.
	HistoryURL *string `json:"history_url,omitempty"`

	// Latest job run information.
	LatestRun *TriggeredJobRun `json:"latest_run,omitempty"`

	// Property to allow or block all public traffic. Allowed Values: 'Enabled', 'Disabled' or an empty string.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`

	// Run command.
	RunCommand *string `json:"run_command,omitempty"`

	// Scheduler Logs URL.
	SchedulerLogsURL *string `json:"scheduler_logs_url,omitempty"`

	// Job settings.
	Settings map[string]interface{} `json:"settings,omitempty"`

	// Checks if Customer provided storage account is required
	StorageAccountRequired *bool `json:"storageAccountRequired,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`

	// Job type.
	WebJobType *WebJobType `json:"web_job_type,omitempty"`
}

// Twitter - The configuration settings of the Twitter provider.
type Twitter struct {
	// false if the Twitter provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the app registration for the Twitter provider.
	Registration *TwitterRegistration `json:"registration,omitempty"`
}

// TwitterRegistration - The configuration settings of the app registration for the Twitter provider.
type TwitterRegistration struct {
	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	ConsumerKey *string `json:"consumerKey,omitempty"`

	// The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	ConsumerSecretSettingName *string `json:"consumerSecretSettingName,omitempty"`
}

// Usage of the quota resource.
type Usage struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Usage resource specific properties
	Properties *UsageProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UsageCollection - Collection of usages.
type UsageCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Usage `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// UsageProperties - Usage resource specific properties
type UsageProperties struct {
	// READ-ONLY; Compute mode used for this usage.
	ComputeMode *ComputeModeOptions `json:"computeMode,omitempty" azure:"ro"`

	// READ-ONLY; The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Friendly name shown in the UI.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; The resource limit.
	Limit *int64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; Next reset time for the resource counter.
	NextResetTime *time.Time `json:"nextResetTime,omitempty" azure:"ro"`

	// READ-ONLY; Name of the quota resource.
	ResourceName *string `json:"resourceName,omitempty" azure:"ro"`

	// READ-ONLY; Site mode used for this usage.
	SiteMode *string `json:"siteMode,omitempty" azure:"ro"`

	// READ-ONLY; Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// User credentials used for publishing activity.
type User struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// User resource specific properties
	Properties *UserProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UserAssignedIdentity - User Assigned identity.
type UserAssignedIdentity struct {
	// READ-ONLY; Client Id of user assigned identity
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// UserProperties - User resource specific properties
type UserProperties struct {
	// REQUIRED; Username used for publishing.
	PublishingUserName *string `json:"publishingUserName,omitempty"`

	// Password used for publishing.
	PublishingPassword *string `json:"publishingPassword,omitempty"`

	// Password hash used for publishing.
	PublishingPasswordHash *string `json:"publishingPasswordHash,omitempty"`

	// Password hash salt used for publishing.
	PublishingPasswordHashSalt *string `json:"publishingPasswordHashSalt,omitempty"`

	// Url of SCM site.
	ScmURI *string `json:"scmUri,omitempty"`
}

// ValidateProperties - App properties used for validation.
type ValidateProperties struct {
	// App Service Environment Properties
	AppServiceEnvironment *Environment `json:"appServiceEnvironment,omitempty"`

	// Target capacity of the App Service plan (number of VMs).
	Capacity *int32 `json:"capacity,omitempty"`

	// Platform (windows or linux)
	ContainerImagePlatform *string `json:"containerImagePlatform,omitempty"`

	// Repository name (image name)
	ContainerImageRepository *string `json:"containerImageRepository,omitempty"`

	// Image tag
	ContainerImageTag *string `json:"containerImageTag,omitempty"`

	// Base URL of the container registry
	ContainerRegistryBaseURL *string `json:"containerRegistryBaseUrl,omitempty"`

	// Password for to access the container registry
	ContainerRegistryPassword *string `json:"containerRegistryPassword,omitempty"`

	// Username for to access the container registry
	ContainerRegistryUsername *string `json:"containerRegistryUsername,omitempty"`

	// Name of App Service Environment where app or App Service plan should be created.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`

	// true if App Service plan is for Spot instances; otherwise, false.
	IsSpot *bool `json:"isSpot,omitempty"`

	// true if App Service plan is running as a windows container
	IsXenon *bool `json:"isXenon,omitempty"`

	// true if App Service plan is for Linux workers; otherwise, false.
	NeedLinuxWorkers *bool `json:"needLinuxWorkers,omitempty"`

	// Name of the target SKU for the App Service plan.
	SKUName *string `json:"skuName,omitempty"`

	// ARM resource ID of an App Service plan that would host the app.
	ServerFarmID *string `json:"serverFarmId,omitempty"`
}

// ValidateRequest - Resource validation request content.
type ValidateRequest struct {
	// REQUIRED; Expected location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Resource name to verify.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Properties of the resource to validate.
	Properties *ValidateProperties `json:"properties,omitempty"`

	// REQUIRED; Resource type used for verification.
	Type *ValidateResourceTypes `json:"type,omitempty"`
}

// ValidateResponse - Describes the result of resource validation.
type ValidateResponse struct {
	// Error details for the case when validation fails.
	Error *ValidateResponseError `json:"error,omitempty"`

	// Result of validation.
	Status *string `json:"status,omitempty"`
}

// ValidateResponseError - Error details for when validation fails.
type ValidateResponseError struct {
	// Validation error code.
	Code *string `json:"code,omitempty"`

	// Validation error message.
	Message *string `json:"message,omitempty"`
}

// VirtualApplication - Virtual application in an app.
type VirtualApplication struct {
	// Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`

	// true if preloading is enabled; otherwise, false.
	PreloadEnabled *bool `json:"preloadEnabled,omitempty"`

	// Virtual directories for virtual application.
	VirtualDirectories []*VirtualDirectory `json:"virtualDirectories,omitempty"`

	// Virtual path.
	VirtualPath *string `json:"virtualPath,omitempty"`
}

// VirtualDirectory - Directory for virtual application.
type VirtualDirectory struct {
	// Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`

	// Path to virtual application.
	VirtualPath *string `json:"virtualPath,omitempty"`
}

// VirtualIPMapping - Virtual IP mapping.
type VirtualIPMapping struct {
	// Is virtual IP mapping in use.
	InUse *bool `json:"inUse,omitempty"`

	// Internal HTTP port.
	InternalHTTPPort *int32 `json:"internalHttpPort,omitempty"`

	// Internal HTTPS port.
	InternalHTTPSPort *int32 `json:"internalHttpsPort,omitempty"`

	// name of the service that virtual IP is assigned to
	ServiceName *string `json:"serviceName,omitempty"`

	// Virtual IP address.
	VirtualIP *string `json:"virtualIP,omitempty"`
}

// VirtualNetworkProfile - Specification for using a Virtual Network.
type VirtualNetworkProfile struct {
	// REQUIRED; Resource id of the Virtual Network.
	ID *string `json:"id,omitempty"`

	// Subnet within the Virtual Network.
	Subnet *string `json:"subnet,omitempty"`

	// READ-ONLY; Name of the Virtual Network (read-only).
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the Virtual Network (read-only).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetGateway - The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN
// package.
type VnetGateway struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetGateway resource specific properties
	Properties *VnetGatewayProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetGatewayProperties - VnetGateway resource specific properties
type VnetGatewayProperties struct {
	// REQUIRED; The URI where the VPN package can be downloaded.
	VPNPackageURI *string `json:"vpnPackageUri,omitempty"`

	// The Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`
}

// VnetInfo - Virtual Network information contract.
type VnetInfo struct {
	// A certificate file (.cer) blob containing the public key of the private key used to authenticate a Point-To-Site VPN connection.
	CertBlob *string `json:"certBlob,omitempty"`

	// DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
	DNSServers *string `json:"dnsServers,omitempty"`

	// Flag that is used to denote if this is VNET injection
	IsSwift *bool `json:"isSwift,omitempty"`

	// The Virtual Network's resource ID.
	VnetResourceID *string `json:"vnetResourceId,omitempty"`

	// READ-ONLY; The client certificate thumbprint.
	CertThumbprint *string `json:"certThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; true if a resync is required; otherwise, false.
	ResyncRequired *bool `json:"resyncRequired,omitempty" azure:"ro"`

	// READ-ONLY; The routes that this Virtual Network connection uses.
	Routes []*VnetRoute `json:"routes,omitempty" azure:"ro"`
}

// VnetInfoResource - Virtual Network information ARM resource.
type VnetInfoResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *VnetInfo `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetParameters - The required set of inputs to validate a VNET
type VnetParameters struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetParameters resource specific properties
	Properties *VnetParametersProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetParametersProperties - VnetParameters resource specific properties
type VnetParametersProperties struct {
	// The ARM Resource ID of the subnet to validate
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`

	// The name of the VNET to be validated
	VnetName *string `json:"vnetName,omitempty"`

	// The Resource Group of the VNET to be validated
	VnetResourceGroup *string `json:"vnetResourceGroup,omitempty"`

	// The subnet name to be validated
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
}

// VnetRoute - Virtual Network route contract used to pass routing information for a Virtual Network.
type VnetRoute struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetRoute resource specific properties
	Properties *VnetRouteProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetRouteProperties - VnetRoute resource specific properties
type VnetRouteProperties struct {
	// The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
	EndAddress *string `json:"endAddress,omitempty"`

	// The type of route this is: DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
	// INHERITED - Routes inherited from the real Virtual Network routes STATIC - Static
	// route set on the app only
	// These values will be used for syncing an app's routes with those from a Virtual Network.
	RouteType *RouteType `json:"routeType,omitempty"`

	// The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
	StartAddress *string `json:"startAddress,omitempty"`
}

// VnetValidationFailureDetails - A class that describes the reason for a validation failure.
type VnetValidationFailureDetails struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetValidationFailureDetails resource specific properties
	Properties *VnetValidationFailureDetailsProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetValidationFailureDetailsProperties - VnetValidationFailureDetails resource specific properties
type VnetValidationFailureDetailsProperties struct {
	// A flag describing whether or not validation failed.
	Failed *bool `json:"failed,omitempty"`

	// A list of tests that failed in the validation.
	FailedTests []*VnetValidationTestFailure `json:"failedTests,omitempty"`

	// Text describing the validation outcome.
	Message *string `json:"message,omitempty"`

	// A list of warnings generated during validation.
	Warnings []*VnetValidationTestFailure `json:"warnings,omitempty"`
}

// VnetValidationTestFailure - A class that describes a test that failed during NSG and UDR validation.
type VnetValidationTestFailure struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// VnetValidationTestFailure resource specific properties
	Properties *VnetValidationTestFailureProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VnetValidationTestFailureProperties - VnetValidationTestFailure resource specific properties
type VnetValidationTestFailureProperties struct {
	// The details of what caused the failure, e.g. the blocking rule name, etc.
	Details *string `json:"details,omitempty"`

	// The name of the test that failed.
	TestName *string `json:"testName,omitempty"`
}

// WebAppCollection - Collection of App Service apps.
type WebAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Site `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebAppInstanceStatusCollection - Collection of app instances.
type WebAppInstanceStatusCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebSiteInstanceStatus `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebAppMajorVersion - Web App stack major version.
type WebAppMajorVersion struct {
	// READ-ONLY; Web App stack major version (display only).
	DisplayText *string `json:"displayText,omitempty" azure:"ro"`

	// READ-ONLY; Minor versions associated with the major version.
	MinorVersions []*WebAppMinorVersion `json:"minorVersions,omitempty" azure:"ro"`

	// READ-ONLY; Web App stack major version name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// WebAppMinorVersion - Web App stack minor version.
type WebAppMinorVersion struct {
	// READ-ONLY; Web App stack minor version (display only).
	DisplayText *string `json:"displayText,omitempty" azure:"ro"`

	// READ-ONLY; Settings associated with the minor version.
	StackSettings *WebAppRuntimes `json:"stackSettings,omitempty" azure:"ro"`

	// READ-ONLY; Web App stack major version name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// WebAppRuntimeSettings - Web App runtime settings.
type WebAppRuntimeSettings struct {
	// READ-ONLY; Application Insights settings associated with the minor version.
	AppInsightsSettings *AppInsightsWebAppStackSettings `json:"appInsightsSettings,omitempty" azure:"ro"`

	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty" azure:"ro"`

	// READ-ONLY; GitHub Actions settings associated with the minor version.
	GitHubActionSettings *GitHubActionWebAppStackSettings `json:"gitHubActionSettings,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool `json:"isAutoUpdate,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool `json:"isDeprecated,omitempty" azure:"ro"`

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool `json:"isEarlyAccess,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool `json:"isHidden,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool `json:"isPreview,omitempty" azure:"ro"`

	// READ-ONLY; true if remote debugging is supported for the stack; otherwise, false.
	RemoteDebuggingSupported *bool `json:"remoteDebuggingSupported,omitempty" azure:"ro"`

	// READ-ONLY; Web App stack minor version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty" azure:"ro"`
}

// WebAppRuntimes - Web App stack runtimes.
type WebAppRuntimes struct {
	// READ-ONLY; Linux-specific settings associated with the Java container minor version.
	LinuxContainerSettings *LinuxJavaContainerSettings `json:"linuxContainerSettings,omitempty" azure:"ro"`

	// READ-ONLY; Linux-specific settings associated with the minor version.
	LinuxRuntimeSettings *WebAppRuntimeSettings `json:"linuxRuntimeSettings,omitempty" azure:"ro"`

	// READ-ONLY; Windows-specific settings associated with the Java container minor version.
	WindowsContainerSettings *WindowsJavaContainerSettings `json:"windowsContainerSettings,omitempty" azure:"ro"`

	// READ-ONLY; Windows-specific settings associated with the minor version.
	WindowsRuntimeSettings *WebAppRuntimeSettings `json:"windowsRuntimeSettings,omitempty" azure:"ro"`
}

// WebAppStack - Web App stack.
type WebAppStack struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// WebAppStack resource specific properties
	Properties *WebAppStackProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Web App stack location.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebAppStackCollection - Collection of Web app Stacks
type WebAppStackCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebAppStack `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebAppStackProperties - WebAppStack resource specific properties
type WebAppStackProperties struct {
	// READ-ONLY; Web App stack (display only).
	DisplayText *string `json:"displayText,omitempty" azure:"ro"`

	// READ-ONLY; List of major versions available.
	MajorVersions []*WebAppMajorVersion `json:"majorVersions,omitempty" azure:"ro"`

	// READ-ONLY; Web App stack preferred OS.
	PreferredOs *StackPreferredOs `json:"preferredOs,omitempty" azure:"ro"`

	// READ-ONLY; Web App stack name.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// WebAppsClientAddPremierAddOnOptions contains the optional parameters for the WebAppsClient.AddPremierAddOn method.
type WebAppsClientAddPremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientAddPremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.AddPremierAddOnSlot method.
type WebAppsClientAddPremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientAnalyzeCustomHostnameOptions contains the optional parameters for the WebAppsClient.AnalyzeCustomHostname
// method.
type WebAppsClientAnalyzeCustomHostnameOptions struct {
	// Custom hostname.
	HostName *string
}

// WebAppsClientAnalyzeCustomHostnameSlotOptions contains the optional parameters for the WebAppsClient.AnalyzeCustomHostnameSlot
// method.
type WebAppsClientAnalyzeCustomHostnameSlotOptions struct {
	// Custom hostname.
	HostName *string
}

// WebAppsClientApplySlotConfigToProductionOptions contains the optional parameters for the WebAppsClient.ApplySlotConfigToProduction
// method.
type WebAppsClientApplySlotConfigToProductionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientApplySlotConfigurationSlotOptions contains the optional parameters for the WebAppsClient.ApplySlotConfigurationSlot
// method.
type WebAppsClientApplySlotConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientBackupOptions contains the optional parameters for the WebAppsClient.Backup method.
type WebAppsClientBackupOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientBackupSlotOptions contains the optional parameters for the WebAppsClient.BackupSlot method.
type WebAppsClientBackupSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions contains the optional parameters for the WebAppsClient.BeginApproveOrRejectPrivateEndpointConnection
// method.
type WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions contains the optional parameters for the WebAppsClient.BeginApproveOrRejectPrivateEndpointConnectionSlot
// method.
type WebAppsClientBeginApproveOrRejectPrivateEndpointConnectionSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateFunctionOptions contains the optional parameters for the WebAppsClient.BeginCreateFunction method.
type WebAppsClientBeginCreateFunctionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceFunctionSlot
// method.
type WebAppsClientBeginCreateInstanceFunctionSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateInstanceMSDeployOperationOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceMSDeployOperation
// method.
type WebAppsClientBeginCreateInstanceMSDeployOperationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateInstanceMSDeployOperationSlot
// method.
type WebAppsClientBeginCreateInstanceMSDeployOperationSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateMSDeployOperationOptions contains the optional parameters for the WebAppsClient.BeginCreateMSDeployOperation
// method.
type WebAppsClientBeginCreateMSDeployOperationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateMSDeployOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateMSDeployOperationSlot
// method.
type WebAppsClientBeginCreateMSDeployOperationSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdate method.
type WebAppsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSlot
// method.
type WebAppsClientBeginCreateOrUpdateSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateSourceControlOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSourceControl
// method.
type WebAppsClientBeginCreateOrUpdateSourceControlOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions contains the optional parameters for the WebAppsClient.BeginCreateOrUpdateSourceControlSlot
// method.
type WebAppsClientBeginCreateOrUpdateSourceControlSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginDeletePrivateEndpointConnectionOptions contains the optional parameters for the WebAppsClient.BeginDeletePrivateEndpointConnection
// method.
type WebAppsClientBeginDeletePrivateEndpointConnectionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions contains the optional parameters for the WebAppsClient.BeginDeletePrivateEndpointConnectionSlot
// method.
type WebAppsClientBeginDeletePrivateEndpointConnectionSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginGetProductionSiteDeploymentStatusOptions contains the optional parameters for the WebAppsClient.BeginGetProductionSiteDeploymentStatus
// method.
type WebAppsClientBeginGetProductionSiteDeploymentStatusOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions contains the optional parameters for the WebAppsClient.BeginGetSlotSiteDeploymentStatusSlot
// method.
type WebAppsClientBeginGetSlotSiteDeploymentStatusSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginInstallSiteExtensionOptions contains the optional parameters for the WebAppsClient.BeginInstallSiteExtension
// method.
type WebAppsClientBeginInstallSiteExtensionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginInstallSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.BeginInstallSiteExtensionSlot
// method.
type WebAppsClientBeginInstallSiteExtensionSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginListPublishingCredentialsOptions contains the optional parameters for the WebAppsClient.BeginListPublishingCredentials
// method.
type WebAppsClientBeginListPublishingCredentialsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginListPublishingCredentialsSlotOptions contains the optional parameters for the WebAppsClient.BeginListPublishingCredentialsSlot
// method.
type WebAppsClientBeginListPublishingCredentialsSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginMigrateMySQLOptions contains the optional parameters for the WebAppsClient.BeginMigrateMySQL method.
type WebAppsClientBeginMigrateMySQLOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginMigrateStorageOptions contains the optional parameters for the WebAppsClient.BeginMigrateStorage method.
type WebAppsClientBeginMigrateStorageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromBackupBlobOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromBackupBlob
// method.
type WebAppsClientBeginRestoreFromBackupBlobOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromBackupBlobSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromBackupBlobSlot
// method.
type WebAppsClientBeginRestoreFromBackupBlobSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromDeletedAppOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromDeletedApp
// method.
type WebAppsClientBeginRestoreFromDeletedAppOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreFromDeletedAppSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreFromDeletedAppSlot
// method.
type WebAppsClientBeginRestoreFromDeletedAppSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreOptions contains the optional parameters for the WebAppsClient.BeginRestore method.
type WebAppsClientBeginRestoreOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreSlot method.
type WebAppsClientBeginRestoreSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreSnapshotOptions contains the optional parameters for the WebAppsClient.BeginRestoreSnapshot method.
type WebAppsClientBeginRestoreSnapshotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginRestoreSnapshotSlotOptions contains the optional parameters for the WebAppsClient.BeginRestoreSnapshotSlot
// method.
type WebAppsClientBeginRestoreSnapshotSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginStartNetworkTraceOptions contains the optional parameters for the WebAppsClient.BeginStartNetworkTrace
// method.
type WebAppsClientBeginStartNetworkTraceOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginStartNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.BeginStartNetworkTraceSlot
// method.
type WebAppsClientBeginStartNetworkTraceSlotOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions contains the optional parameters for the WebAppsClient.BeginStartWebSiteNetworkTraceOperation
// method.
type WebAppsClientBeginStartWebSiteNetworkTraceOperationOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions contains the optional parameters for the WebAppsClient.BeginStartWebSiteNetworkTraceOperationSlot
// method.
type WebAppsClientBeginStartWebSiteNetworkTraceOperationSlotOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// Resumes the LRO from the provided token.
	ResumeToken string
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientBeginSwapSlotOptions contains the optional parameters for the WebAppsClient.BeginSwapSlot method.
type WebAppsClientBeginSwapSlotOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientBeginSwapSlotWithProductionOptions contains the optional parameters for the WebAppsClient.BeginSwapSlotWithProduction
// method.
type WebAppsClientBeginSwapSlotWithProductionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WebAppsClientCreateDeploymentOptions contains the optional parameters for the WebAppsClient.CreateDeployment method.
type WebAppsClientCreateDeploymentOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateDeploymentSlotOptions contains the optional parameters for the WebAppsClient.CreateDeploymentSlot method.
type WebAppsClientCreateDeploymentSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOneDeployOperationOptions contains the optional parameters for the WebAppsClient.CreateOneDeployOperation
// method.
type WebAppsClientCreateOneDeployOperationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateConfigurationOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateConfiguration
// method.
type WebAppsClientCreateOrUpdateConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateConfigurationSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateConfigurationSlot
// method.
type WebAppsClientCreateOrUpdateConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateDomainOwnershipIdentifier
// method.
type WebAppsClientCreateOrUpdateDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot
// method.
type WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateFunctionSecretOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateFunctionSecret
// method.
type WebAppsClientCreateOrUpdateFunctionSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateFunctionSecretSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateFunctionSecretSlot
// method.
type WebAppsClientCreateOrUpdateFunctionSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostNameBindingOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostNameBinding
// method.
type WebAppsClientCreateOrUpdateHostNameBindingOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostNameBindingSlot
// method.
type WebAppsClientCreateOrUpdateHostNameBindingSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostSecretOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostSecret
// method.
type WebAppsClientCreateOrUpdateHostSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHostSecretSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHostSecretSlot
// method.
type WebAppsClientCreateOrUpdateHostSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHybridConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHybridConnection
// method.
type WebAppsClientCreateOrUpdateHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateHybridConnectionSlot
// method.
type WebAppsClientCreateOrUpdateHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdatePublicCertificateOptions contains the optional parameters for the WebAppsClient.CreateOrUpdatePublicCertificate
// method.
type WebAppsClientCreateOrUpdatePublicCertificateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdatePublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdatePublicCertificateSlot
// method.
type WebAppsClientCreateOrUpdatePublicCertificateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateRelayServiceConnection
// method.
type WebAppsClientCreateOrUpdateRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateRelayServiceConnectionSlot
// method.
type WebAppsClientCreateOrUpdateRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck
// method.
type WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot
// method.
type WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionGateway
// method.
type WebAppsClientCreateOrUpdateVnetConnectionGatewayOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionGatewaySlot
// method.
type WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnection
// method.
type WebAppsClientCreateOrUpdateVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientCreateOrUpdateVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.CreateOrUpdateVnetConnectionSlot
// method.
type WebAppsClientCreateOrUpdateVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupConfigurationOptions contains the optional parameters for the WebAppsClient.DeleteBackupConfiguration
// method.
type WebAppsClientDeleteBackupConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.DeleteBackupConfigurationSlot
// method.
type WebAppsClientDeleteBackupConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupOptions contains the optional parameters for the WebAppsClient.DeleteBackup method.
type WebAppsClientDeleteBackupOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteBackupSlotOptions contains the optional parameters for the WebAppsClient.DeleteBackupSlot method.
type WebAppsClientDeleteBackupSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteContinuousWebJobOptions contains the optional parameters for the WebAppsClient.DeleteContinuousWebJob
// method.
type WebAppsClientDeleteContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.DeleteContinuousWebJobSlot
// method.
type WebAppsClientDeleteContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDeploymentOptions contains the optional parameters for the WebAppsClient.DeleteDeployment method.
type WebAppsClientDeleteDeploymentOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDeploymentSlotOptions contains the optional parameters for the WebAppsClient.DeleteDeploymentSlot method.
type WebAppsClientDeleteDeploymentSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.DeleteDomainOwnershipIdentifier
// method.
type WebAppsClientDeleteDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.DeleteDomainOwnershipIdentifierSlot
// method.
type WebAppsClientDeleteDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteFunctionOptions contains the optional parameters for the WebAppsClient.DeleteFunction method.
type WebAppsClientDeleteFunctionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteFunctionSecretOptions contains the optional parameters for the WebAppsClient.DeleteFunctionSecret method.
type WebAppsClientDeleteFunctionSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteFunctionSecretSlotOptions contains the optional parameters for the WebAppsClient.DeleteFunctionSecretSlot
// method.
type WebAppsClientDeleteFunctionSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostNameBindingOptions contains the optional parameters for the WebAppsClient.DeleteHostNameBinding
// method.
type WebAppsClientDeleteHostNameBindingOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.DeleteHostNameBindingSlot
// method.
type WebAppsClientDeleteHostNameBindingSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostSecretOptions contains the optional parameters for the WebAppsClient.DeleteHostSecret method.
type WebAppsClientDeleteHostSecretOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHostSecretSlotOptions contains the optional parameters for the WebAppsClient.DeleteHostSecretSlot method.
type WebAppsClientDeleteHostSecretSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHybridConnectionOptions contains the optional parameters for the WebAppsClient.DeleteHybridConnection
// method.
type WebAppsClientDeleteHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteHybridConnectionSlot
// method.
type WebAppsClientDeleteHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.DeleteInstanceFunctionSlot
// method.
type WebAppsClientDeleteInstanceFunctionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteInstanceProcessOptions contains the optional parameters for the WebAppsClient.DeleteInstanceProcess
// method.
type WebAppsClientDeleteInstanceProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteInstanceProcessSlotOptions contains the optional parameters for the WebAppsClient.DeleteInstanceProcessSlot
// method.
type WebAppsClientDeleteInstanceProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteOptions contains the optional parameters for the WebAppsClient.Delete method.
type WebAppsClientDeleteOptions struct {
	// Specify false if you want to keep empty App Service plan. By default, empty App Service plan is deleted.
	DeleteEmptyServerFarm *bool
	// If true, web app metrics are also deleted.
	DeleteMetrics *bool
}

// WebAppsClientDeletePremierAddOnOptions contains the optional parameters for the WebAppsClient.DeletePremierAddOn method.
type WebAppsClientDeletePremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeletePremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.DeletePremierAddOnSlot
// method.
type WebAppsClientDeletePremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteProcessOptions contains the optional parameters for the WebAppsClient.DeleteProcess method.
type WebAppsClientDeleteProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteProcessSlotOptions contains the optional parameters for the WebAppsClient.DeleteProcessSlot method.
type WebAppsClientDeleteProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeletePublicCertificateOptions contains the optional parameters for the WebAppsClient.DeletePublicCertificate
// method.
type WebAppsClientDeletePublicCertificateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeletePublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.DeletePublicCertificateSlot
// method.
type WebAppsClientDeletePublicCertificateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.DeleteRelayServiceConnection
// method.
type WebAppsClientDeleteRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteRelayServiceConnectionSlot
// method.
type WebAppsClientDeleteRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSiteExtensionOptions contains the optional parameters for the WebAppsClient.DeleteSiteExtension method.
type WebAppsClientDeleteSiteExtensionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.DeleteSiteExtensionSlot
// method.
type WebAppsClientDeleteSiteExtensionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSlotOptions contains the optional parameters for the WebAppsClient.DeleteSlot method.
type WebAppsClientDeleteSlotOptions struct {
	// Specify false if you want to keep empty App Service plan. By default, empty App Service plan is deleted.
	DeleteEmptyServerFarm *bool
	// If true, web app metrics are also deleted.
	DeleteMetrics *bool
}

// WebAppsClientDeleteSourceControlOptions contains the optional parameters for the WebAppsClient.DeleteSourceControl method.
type WebAppsClientDeleteSourceControlOptions struct {
	AdditionalFlags *string
}

// WebAppsClientDeleteSourceControlSlotOptions contains the optional parameters for the WebAppsClient.DeleteSourceControlSlot
// method.
type WebAppsClientDeleteSourceControlSlotOptions struct {
	AdditionalFlags *string
}

// WebAppsClientDeleteSwiftVirtualNetworkOptions contains the optional parameters for the WebAppsClient.DeleteSwiftVirtualNetwork
// method.
type WebAppsClientDeleteSwiftVirtualNetworkOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteSwiftVirtualNetworkSlotOptions contains the optional parameters for the WebAppsClient.DeleteSwiftVirtualNetworkSlot
// method.
type WebAppsClientDeleteSwiftVirtualNetworkSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.DeleteTriggeredWebJob
// method.
type WebAppsClientDeleteTriggeredWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.DeleteTriggeredWebJobSlot
// method.
type WebAppsClientDeleteTriggeredWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteVnetConnectionOptions contains the optional parameters for the WebAppsClient.DeleteVnetConnection method.
type WebAppsClientDeleteVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDeleteVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.DeleteVnetConnectionSlot
// method.
type WebAppsClientDeleteVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDiscoverBackupOptions contains the optional parameters for the WebAppsClient.DiscoverBackup method.
type WebAppsClientDiscoverBackupOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientDiscoverBackupSlotOptions contains the optional parameters for the WebAppsClient.DiscoverBackupSlot method.
type WebAppsClientDiscoverBackupSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGenerateNewSitePublishingPasswordOptions contains the optional parameters for the WebAppsClient.GenerateNewSitePublishingPassword
// method.
type WebAppsClientGenerateNewSitePublishingPasswordOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGenerateNewSitePublishingPasswordSlotOptions contains the optional parameters for the WebAppsClient.GenerateNewSitePublishingPasswordSlot
// method.
type WebAppsClientGenerateNewSitePublishingPasswordSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAppSettingKeyVaultReferenceOptions contains the optional parameters for the WebAppsClient.GetAppSettingKeyVaultReference
// method.
type WebAppsClientGetAppSettingKeyVaultReferenceOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAppSettingKeyVaultReferenceSlotOptions contains the optional parameters for the WebAppsClient.GetAppSettingKeyVaultReferenceSlot
// method.
type WebAppsClientGetAppSettingKeyVaultReferenceSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAppSettingsKeyVaultReferencesOptions contains the optional parameters for the WebAppsClient.GetAppSettingsKeyVaultReferences
// method.
type WebAppsClientGetAppSettingsKeyVaultReferencesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAppSettingsKeyVaultReferencesSlotOptions contains the optional parameters for the WebAppsClient.GetAppSettingsKeyVaultReferencesSlot
// method.
type WebAppsClientGetAppSettingsKeyVaultReferencesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsOptions contains the optional parameters for the WebAppsClient.GetAuthSettings method.
type WebAppsClientGetAuthSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsSlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsSlot method.
type WebAppsClientGetAuthSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsV2Options contains the optional parameters for the WebAppsClient.GetAuthSettingsV2 method.
type WebAppsClientGetAuthSettingsV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsV2SlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsV2Slot
// method.
type WebAppsClientGetAuthSettingsV2SlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsV2WithoutSecretsOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsV2WithoutSecrets
// method.
type WebAppsClientGetAuthSettingsV2WithoutSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetAuthSettingsV2WithoutSecretsSlotOptions contains the optional parameters for the WebAppsClient.GetAuthSettingsV2WithoutSecretsSlot
// method.
type WebAppsClientGetAuthSettingsV2WithoutSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupConfigurationOptions contains the optional parameters for the WebAppsClient.GetBackupConfiguration
// method.
type WebAppsClientGetBackupConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetBackupConfigurationSlot
// method.
type WebAppsClientGetBackupConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupStatusOptions contains the optional parameters for the WebAppsClient.GetBackupStatus method.
type WebAppsClientGetBackupStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetBackupStatusSlotOptions contains the optional parameters for the WebAppsClient.GetBackupStatusSlot method.
type WebAppsClientGetBackupStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationOptions contains the optional parameters for the WebAppsClient.GetConfiguration method.
type WebAppsClientGetConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSlot method.
type WebAppsClientGetConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationSnapshotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSnapshot
// method.
type WebAppsClientGetConfigurationSnapshotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetConfigurationSnapshotSlotOptions contains the optional parameters for the WebAppsClient.GetConfigurationSnapshotSlot
// method.
type WebAppsClientGetConfigurationSnapshotSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContainerLogsZipOptions contains the optional parameters for the WebAppsClient.GetContainerLogsZip method.
type WebAppsClientGetContainerLogsZipOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContainerLogsZipSlotOptions contains the optional parameters for the WebAppsClient.GetContainerLogsZipSlot
// method.
type WebAppsClientGetContainerLogsZipSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContinuousWebJobOptions contains the optional parameters for the WebAppsClient.GetContinuousWebJob method.
type WebAppsClientGetContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetContinuousWebJobSlot
// method.
type WebAppsClientGetContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDeploymentOptions contains the optional parameters for the WebAppsClient.GetDeployment method.
type WebAppsClientGetDeploymentOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDeploymentSlotOptions contains the optional parameters for the WebAppsClient.GetDeploymentSlot method.
type WebAppsClientGetDeploymentSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDiagnosticLogsConfigurationOptions contains the optional parameters for the WebAppsClient.GetDiagnosticLogsConfiguration
// method.
type WebAppsClientGetDiagnosticLogsConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDiagnosticLogsConfigurationSlotOptions contains the optional parameters for the WebAppsClient.GetDiagnosticLogsConfigurationSlot
// method.
type WebAppsClientGetDiagnosticLogsConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.GetDomainOwnershipIdentifier
// method.
type WebAppsClientGetDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.GetDomainOwnershipIdentifierSlot
// method.
type WebAppsClientGetDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFtpAllowedOptions contains the optional parameters for the WebAppsClient.GetFtpAllowed method.
type WebAppsClientGetFtpAllowedOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFtpAllowedSlotOptions contains the optional parameters for the WebAppsClient.GetFtpAllowedSlot method.
type WebAppsClientGetFtpAllowedSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFunctionOptions contains the optional parameters for the WebAppsClient.GetFunction method.
type WebAppsClientGetFunctionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFunctionsAdminTokenOptions contains the optional parameters for the WebAppsClient.GetFunctionsAdminToken
// method.
type WebAppsClientGetFunctionsAdminTokenOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetFunctionsAdminTokenSlotOptions contains the optional parameters for the WebAppsClient.GetFunctionsAdminTokenSlot
// method.
type WebAppsClientGetFunctionsAdminTokenSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHostNameBindingOptions contains the optional parameters for the WebAppsClient.GetHostNameBinding method.
type WebAppsClientGetHostNameBindingOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHostNameBindingSlotOptions contains the optional parameters for the WebAppsClient.GetHostNameBindingSlot
// method.
type WebAppsClientGetHostNameBindingSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHybridConnectionOptions contains the optional parameters for the WebAppsClient.GetHybridConnection method.
type WebAppsClientGetHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetHybridConnectionSlot
// method.
type WebAppsClientGetHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceFunctionSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceFunctionSlot
// method.
type WebAppsClientGetInstanceFunctionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceInfoOptions contains the optional parameters for the WebAppsClient.GetInstanceInfo method.
type WebAppsClientGetInstanceInfoOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceInfoSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceInfoSlot method.
type WebAppsClientGetInstanceInfoSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMSDeployLogOptions contains the optional parameters for the WebAppsClient.GetInstanceMSDeployLog
// method.
type WebAppsClientGetInstanceMSDeployLogOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMSDeployLogSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceMSDeployLogSlot
// method.
type WebAppsClientGetInstanceMSDeployLogSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMsDeployStatusOptions contains the optional parameters for the WebAppsClient.GetInstanceMsDeployStatus
// method.
type WebAppsClientGetInstanceMsDeployStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceMsDeployStatusSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceMsDeployStatusSlot
// method.
type WebAppsClientGetInstanceMsDeployStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessDumpOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessDump
// method.
type WebAppsClientGetInstanceProcessDumpOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessDumpSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessDumpSlot
// method.
type WebAppsClientGetInstanceProcessDumpSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessModuleOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessModule
// method.
type WebAppsClientGetInstanceProcessModuleOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessModuleSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessModuleSlot
// method.
type WebAppsClientGetInstanceProcessModuleSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessOptions contains the optional parameters for the WebAppsClient.GetInstanceProcess method.
type WebAppsClientGetInstanceProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetInstanceProcessSlotOptions contains the optional parameters for the WebAppsClient.GetInstanceProcessSlot
// method.
type WebAppsClientGetInstanceProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployLogOptions contains the optional parameters for the WebAppsClient.GetMSDeployLog method.
type WebAppsClientGetMSDeployLogOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployLogSlotOptions contains the optional parameters for the WebAppsClient.GetMSDeployLogSlot method.
type WebAppsClientGetMSDeployLogSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployStatusOptions contains the optional parameters for the WebAppsClient.GetMSDeployStatus method.
type WebAppsClientGetMSDeployStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMSDeployStatusSlotOptions contains the optional parameters for the WebAppsClient.GetMSDeployStatusSlot
// method.
type WebAppsClientGetMSDeployStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMigrateMySQLStatusOptions contains the optional parameters for the WebAppsClient.GetMigrateMySQLStatus
// method.
type WebAppsClientGetMigrateMySQLStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetMigrateMySQLStatusSlotOptions contains the optional parameters for the WebAppsClient.GetMigrateMySQLStatusSlot
// method.
type WebAppsClientGetMigrateMySQLStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationOptions contains the optional parameters for the WebAppsClient.GetNetworkTraceOperation
// method.
type WebAppsClientGetNetworkTraceOperationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationSlotOptions contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationSlot
// method.
type WebAppsClientGetNetworkTraceOperationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationSlotV2Options contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationSlotV2
// method.
type WebAppsClientGetNetworkTraceOperationSlotV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTraceOperationV2Options contains the optional parameters for the WebAppsClient.GetNetworkTraceOperationV2
// method.
type WebAppsClientGetNetworkTraceOperationV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesOptions contains the optional parameters for the WebAppsClient.GetNetworkTraces method.
type WebAppsClientGetNetworkTracesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesSlotOptions contains the optional parameters for the WebAppsClient.GetNetworkTracesSlot method.
type WebAppsClientGetNetworkTracesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesSlotV2Options contains the optional parameters for the WebAppsClient.GetNetworkTracesSlotV2
// method.
type WebAppsClientGetNetworkTracesSlotV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetNetworkTracesV2Options contains the optional parameters for the WebAppsClient.GetNetworkTracesV2 method.
type WebAppsClientGetNetworkTracesV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetOneDeployStatusOptions contains the optional parameters for the WebAppsClient.GetOneDeployStatus method.
type WebAppsClientGetOneDeployStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetOptions contains the optional parameters for the WebAppsClient.Get method.
type WebAppsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPremierAddOnOptions contains the optional parameters for the WebAppsClient.GetPremierAddOn method.
type WebAppsClientGetPremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.GetPremierAddOnSlot method.
type WebAppsClientGetPremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateAccessOptions contains the optional parameters for the WebAppsClient.GetPrivateAccess method.
type WebAppsClientGetPrivateAccessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateAccessSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateAccessSlot method.
type WebAppsClientGetPrivateAccessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateEndpointConnectionListOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnectionList
// method.
type WebAppsClientGetPrivateEndpointConnectionListOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateEndpointConnectionListSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnectionListSlot
// method.
type WebAppsClientGetPrivateEndpointConnectionListSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateEndpointConnectionOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnection
// method.
type WebAppsClientGetPrivateEndpointConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateEndpointConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateEndpointConnectionSlot
// method.
type WebAppsClientGetPrivateEndpointConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateLinkResourcesOptions contains the optional parameters for the WebAppsClient.GetPrivateLinkResources
// method.
type WebAppsClientGetPrivateLinkResourcesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPrivateLinkResourcesSlotOptions contains the optional parameters for the WebAppsClient.GetPrivateLinkResourcesSlot
// method.
type WebAppsClientGetPrivateLinkResourcesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessDumpOptions contains the optional parameters for the WebAppsClient.GetProcessDump method.
type WebAppsClientGetProcessDumpOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessDumpSlotOptions contains the optional parameters for the WebAppsClient.GetProcessDumpSlot method.
type WebAppsClientGetProcessDumpSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessModuleOptions contains the optional parameters for the WebAppsClient.GetProcessModule method.
type WebAppsClientGetProcessModuleOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessModuleSlotOptions contains the optional parameters for the WebAppsClient.GetProcessModuleSlot method.
type WebAppsClientGetProcessModuleSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessOptions contains the optional parameters for the WebAppsClient.GetProcess method.
type WebAppsClientGetProcessOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetProcessSlotOptions contains the optional parameters for the WebAppsClient.GetProcessSlot method.
type WebAppsClientGetProcessSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPublicCertificateOptions contains the optional parameters for the WebAppsClient.GetPublicCertificate method.
type WebAppsClientGetPublicCertificateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetPublicCertificateSlotOptions contains the optional parameters for the WebAppsClient.GetPublicCertificateSlot
// method.
type WebAppsClientGetPublicCertificateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.GetRelayServiceConnection
// method.
type WebAppsClientGetRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetRelayServiceConnectionSlot
// method.
type WebAppsClientGetRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetScmAllowedOptions contains the optional parameters for the WebAppsClient.GetScmAllowed method.
type WebAppsClientGetScmAllowedOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetScmAllowedSlotOptions contains the optional parameters for the WebAppsClient.GetScmAllowedSlot method.
type WebAppsClientGetScmAllowedSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferenceOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReference
// method.
type WebAppsClientGetSiteConnectionStringKeyVaultReferenceOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReferenceSlot
// method.
type WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferencesOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReferences
// method.
type WebAppsClientGetSiteConnectionStringKeyVaultReferencesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotOptions contains the optional parameters for the WebAppsClient.GetSiteConnectionStringKeyVaultReferencesSlot
// method.
type WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteExtensionOptions contains the optional parameters for the WebAppsClient.GetSiteExtension method.
type WebAppsClientGetSiteExtensionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSiteExtensionSlotOptions contains the optional parameters for the WebAppsClient.GetSiteExtensionSlot method.
type WebAppsClientGetSiteExtensionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSitePhpErrorLogFlagOptions contains the optional parameters for the WebAppsClient.GetSitePhpErrorLogFlag
// method.
type WebAppsClientGetSitePhpErrorLogFlagOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSitePhpErrorLogFlagSlotOptions contains the optional parameters for the WebAppsClient.GetSitePhpErrorLogFlagSlot
// method.
type WebAppsClientGetSitePhpErrorLogFlagSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSlotOptions contains the optional parameters for the WebAppsClient.GetSlot method.
type WebAppsClientGetSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSourceControlOptions contains the optional parameters for the WebAppsClient.GetSourceControl method.
type WebAppsClientGetSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSourceControlSlotOptions contains the optional parameters for the WebAppsClient.GetSourceControlSlot method.
type WebAppsClientGetSourceControlSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSwiftVirtualNetworkConnectionOptions contains the optional parameters for the WebAppsClient.GetSwiftVirtualNetworkConnection
// method.
type WebAppsClientGetSwiftVirtualNetworkConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetSwiftVirtualNetworkConnectionSlot
// method.
type WebAppsClientGetSwiftVirtualNetworkConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobHistoryOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobHistory
// method.
type WebAppsClientGetTriggeredWebJobHistoryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobHistorySlotOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobHistorySlot
// method.
type WebAppsClientGetTriggeredWebJobHistorySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJob method.
type WebAppsClientGetTriggeredWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetTriggeredWebJobSlot
// method.
type WebAppsClientGetTriggeredWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionGateway
// method.
type WebAppsClientGetVnetConnectionGatewayOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionGatewaySlot
// method.
type WebAppsClientGetVnetConnectionGatewaySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionOptions contains the optional parameters for the WebAppsClient.GetVnetConnection method.
type WebAppsClientGetVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.GetVnetConnectionSlot
// method.
type WebAppsClientGetVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebJobOptions contains the optional parameters for the WebAppsClient.GetWebJob method.
type WebAppsClientGetWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebJobSlotOptions contains the optional parameters for the WebAppsClient.GetWebJobSlot method.
type WebAppsClientGetWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebSiteContainerLogsOptions contains the optional parameters for the WebAppsClient.GetWebSiteContainerLogs
// method.
type WebAppsClientGetWebSiteContainerLogsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientGetWebSiteContainerLogsSlotOptions contains the optional parameters for the WebAppsClient.GetWebSiteContainerLogsSlot
// method.
type WebAppsClientGetWebSiteContainerLogsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientIsCloneableOptions contains the optional parameters for the WebAppsClient.IsCloneable method.
type WebAppsClientIsCloneableOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientIsCloneableSlotOptions contains the optional parameters for the WebAppsClient.IsCloneableSlot method.
type WebAppsClientIsCloneableSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListApplicationSettingsOptions contains the optional parameters for the WebAppsClient.ListApplicationSettings
// method.
type WebAppsClientListApplicationSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListApplicationSettingsSlotOptions contains the optional parameters for the WebAppsClient.ListApplicationSettingsSlot
// method.
type WebAppsClientListApplicationSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListAzureStorageAccountsOptions contains the optional parameters for the WebAppsClient.ListAzureStorageAccounts
// method.
type WebAppsClientListAzureStorageAccountsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListAzureStorageAccountsSlotOptions contains the optional parameters for the WebAppsClient.ListAzureStorageAccountsSlot
// method.
type WebAppsClientListAzureStorageAccountsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupStatusSecretsOptions contains the optional parameters for the WebAppsClient.ListBackupStatusSecrets
// method.
type WebAppsClientListBackupStatusSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupStatusSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListBackupStatusSecretsSlot
// method.
type WebAppsClientListBackupStatusSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupsOptions contains the optional parameters for the WebAppsClient.ListBackups method.
type WebAppsClientListBackupsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBackupsSlotOptions contains the optional parameters for the WebAppsClient.ListBackupsSlot method.
type WebAppsClientListBackupsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBasicPublishingCredentialsPoliciesOptions contains the optional parameters for the WebAppsClient.ListBasicPublishingCredentialsPolicies
// method.
type WebAppsClientListBasicPublishingCredentialsPoliciesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListBasicPublishingCredentialsPoliciesSlotOptions contains the optional parameters for the WebAppsClient.ListBasicPublishingCredentialsPoliciesSlot
// method.
type WebAppsClientListBasicPublishingCredentialsPoliciesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListByResourceGroupOptions contains the optional parameters for the WebAppsClient.ListByResourceGroup method.
type WebAppsClientListByResourceGroupOptions struct {
	// Specify true to include deployment slots in results. The default is false, which only gives you the production slot of
	// all apps.
	IncludeSlots *bool
}

// WebAppsClientListConfigurationSnapshotInfoOptions contains the optional parameters for the WebAppsClient.ListConfigurationSnapshotInfo
// method.
type WebAppsClientListConfigurationSnapshotInfoOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConfigurationSnapshotInfoSlotOptions contains the optional parameters for the WebAppsClient.ListConfigurationSnapshotInfoSlot
// method.
type WebAppsClientListConfigurationSnapshotInfoSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConfigurationsOptions contains the optional parameters for the WebAppsClient.ListConfigurations method.
type WebAppsClientListConfigurationsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConfigurationsSlotOptions contains the optional parameters for the WebAppsClient.ListConfigurationsSlot
// method.
type WebAppsClientListConfigurationsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConnectionStringsOptions contains the optional parameters for the WebAppsClient.ListConnectionStrings
// method.
type WebAppsClientListConnectionStringsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListConnectionStringsSlotOptions contains the optional parameters for the WebAppsClient.ListConnectionStringsSlot
// method.
type WebAppsClientListConnectionStringsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListContinuousWebJobsOptions contains the optional parameters for the WebAppsClient.ListContinuousWebJobs
// method.
type WebAppsClientListContinuousWebJobsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListContinuousWebJobsSlotOptions contains the optional parameters for the WebAppsClient.ListContinuousWebJobsSlot
// method.
type WebAppsClientListContinuousWebJobsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentLogOptions contains the optional parameters for the WebAppsClient.ListDeploymentLog method.
type WebAppsClientListDeploymentLogOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentLogSlotOptions contains the optional parameters for the WebAppsClient.ListDeploymentLogSlot
// method.
type WebAppsClientListDeploymentLogSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentsOptions contains the optional parameters for the WebAppsClient.ListDeployments method.
type WebAppsClientListDeploymentsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDeploymentsSlotOptions contains the optional parameters for the WebAppsClient.ListDeploymentsSlot method.
type WebAppsClientListDeploymentsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDomainOwnershipIdentifiersOptions contains the optional parameters for the WebAppsClient.ListDomainOwnershipIdentifiers
// method.
type WebAppsClientListDomainOwnershipIdentifiersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListDomainOwnershipIdentifiersSlotOptions contains the optional parameters for the WebAppsClient.ListDomainOwnershipIdentifiersSlot
// method.
type WebAppsClientListDomainOwnershipIdentifiersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionKeysOptions contains the optional parameters for the WebAppsClient.ListFunctionKeys method.
type WebAppsClientListFunctionKeysOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionKeysSlotOptions contains the optional parameters for the WebAppsClient.ListFunctionKeysSlot method.
type WebAppsClientListFunctionKeysSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionSecretsOptions contains the optional parameters for the WebAppsClient.ListFunctionSecrets method.
type WebAppsClientListFunctionSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListFunctionSecretsSlot
// method.
type WebAppsClientListFunctionSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListFunctionsOptions contains the optional parameters for the WebAppsClient.ListFunctions method.
type WebAppsClientListFunctionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostKeysOptions contains the optional parameters for the WebAppsClient.ListHostKeys method.
type WebAppsClientListHostKeysOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostKeysSlotOptions contains the optional parameters for the WebAppsClient.ListHostKeysSlot method.
type WebAppsClientListHostKeysSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostNameBindingsOptions contains the optional parameters for the WebAppsClient.ListHostNameBindings method.
type WebAppsClientListHostNameBindingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHostNameBindingsSlotOptions contains the optional parameters for the WebAppsClient.ListHostNameBindingsSlot
// method.
type WebAppsClientListHostNameBindingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHybridConnectionsOptions contains the optional parameters for the WebAppsClient.ListHybridConnections
// method.
type WebAppsClientListHybridConnectionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListHybridConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListHybridConnectionsSlot
// method.
type WebAppsClientListHybridConnectionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceFunctionsSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceFunctionsSlot
// method.
type WebAppsClientListInstanceFunctionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceIdentifiersOptions contains the optional parameters for the WebAppsClient.ListInstanceIdentifiers
// method.
type WebAppsClientListInstanceIdentifiersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceIdentifiersSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceIdentifiersSlot
// method.
type WebAppsClientListInstanceIdentifiersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessModulesOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessModules
// method.
type WebAppsClientListInstanceProcessModulesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessModulesSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessModulesSlot
// method.
type WebAppsClientListInstanceProcessModulesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessThreadsOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessThreads
// method.
type WebAppsClientListInstanceProcessThreadsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessThreadsSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessThreadsSlot
// method.
type WebAppsClientListInstanceProcessThreadsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessesOptions contains the optional parameters for the WebAppsClient.ListInstanceProcesses
// method.
type WebAppsClientListInstanceProcessesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListInstanceProcessesSlotOptions contains the optional parameters for the WebAppsClient.ListInstanceProcessesSlot
// method.
type WebAppsClientListInstanceProcessesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetadataOptions contains the optional parameters for the WebAppsClient.ListMetadata method.
type WebAppsClientListMetadataOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListMetadataSlotOptions contains the optional parameters for the WebAppsClient.ListMetadataSlot method.
type WebAppsClientListMetadataSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListNetworkFeaturesOptions contains the optional parameters for the WebAppsClient.ListNetworkFeatures method.
type WebAppsClientListNetworkFeaturesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListNetworkFeaturesSlotOptions contains the optional parameters for the WebAppsClient.ListNetworkFeaturesSlot
// method.
type WebAppsClientListNetworkFeaturesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListOptions contains the optional parameters for the WebAppsClient.List method.
type WebAppsClientListOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPerfMonCountersOptions contains the optional parameters for the WebAppsClient.ListPerfMonCounters method.
type WebAppsClientListPerfMonCountersOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(startTime eq 2014-01-01T00:00:00Z
	// and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListPerfMonCountersSlotOptions contains the optional parameters for the WebAppsClient.ListPerfMonCountersSlot
// method.
type WebAppsClientListPerfMonCountersSlotOptions struct {
	// Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example: $filter=(startTime eq 2014-01-01T00:00:00Z
	// and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
	// duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListPremierAddOnsOptions contains the optional parameters for the WebAppsClient.ListPremierAddOns method.
type WebAppsClientListPremierAddOnsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPremierAddOnsSlotOptions contains the optional parameters for the WebAppsClient.ListPremierAddOnsSlot
// method.
type WebAppsClientListPremierAddOnsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessModulesOptions contains the optional parameters for the WebAppsClient.ListProcessModules method.
type WebAppsClientListProcessModulesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessModulesSlotOptions contains the optional parameters for the WebAppsClient.ListProcessModulesSlot
// method.
type WebAppsClientListProcessModulesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessThreadsOptions contains the optional parameters for the WebAppsClient.ListProcessThreads method.
type WebAppsClientListProcessThreadsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessThreadsSlotOptions contains the optional parameters for the WebAppsClient.ListProcessThreadsSlot
// method.
type WebAppsClientListProcessThreadsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessesOptions contains the optional parameters for the WebAppsClient.ListProcesses method.
type WebAppsClientListProcessesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProcessesSlotOptions contains the optional parameters for the WebAppsClient.ListProcessesSlot method.
type WebAppsClientListProcessesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListProductionSiteDeploymentStatusesOptions contains the optional parameters for the WebAppsClient.ListProductionSiteDeploymentStatuses
// method.
type WebAppsClientListProductionSiteDeploymentStatusesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublicCertificatesOptions contains the optional parameters for the WebAppsClient.ListPublicCertificates
// method.
type WebAppsClientListPublicCertificatesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublicCertificatesSlotOptions contains the optional parameters for the WebAppsClient.ListPublicCertificatesSlot
// method.
type WebAppsClientListPublicCertificatesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublishingProfileXMLWithSecretsOptions contains the optional parameters for the WebAppsClient.ListPublishingProfileXMLWithSecrets
// method.
type WebAppsClientListPublishingProfileXMLWithSecretsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions contains the optional parameters for the WebAppsClient.ListPublishingProfileXMLWithSecretsSlot
// method.
type WebAppsClientListPublishingProfileXMLWithSecretsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListRelayServiceConnectionsOptions contains the optional parameters for the WebAppsClient.ListRelayServiceConnections
// method.
type WebAppsClientListRelayServiceConnectionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListRelayServiceConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListRelayServiceConnectionsSlot
// method.
type WebAppsClientListRelayServiceConnectionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSiteBackupsOptions contains the optional parameters for the WebAppsClient.ListSiteBackups method.
type WebAppsClientListSiteBackupsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSiteBackupsSlotOptions contains the optional parameters for the WebAppsClient.ListSiteBackupsSlot method.
type WebAppsClientListSiteBackupsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSiteExtensionsOptions contains the optional parameters for the WebAppsClient.ListSiteExtensions method.
type WebAppsClientListSiteExtensionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSiteExtensionsSlotOptions contains the optional parameters for the WebAppsClient.ListSiteExtensionsSlot
// method.
type WebAppsClientListSiteExtensionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSitePushSettingsOptions contains the optional parameters for the WebAppsClient.ListSitePushSettings method.
type WebAppsClientListSitePushSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSitePushSettingsSlotOptions contains the optional parameters for the WebAppsClient.ListSitePushSettingsSlot
// method.
type WebAppsClientListSitePushSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotConfigurationNamesOptions contains the optional parameters for the WebAppsClient.ListSlotConfigurationNames
// method.
type WebAppsClientListSlotConfigurationNamesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotDifferencesFromProductionOptions contains the optional parameters for the WebAppsClient.ListSlotDifferencesFromProduction
// method.
type WebAppsClientListSlotDifferencesFromProductionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotDifferencesSlotOptions contains the optional parameters for the WebAppsClient.ListSlotDifferencesSlot
// method.
type WebAppsClientListSlotDifferencesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotSiteDeploymentStatusesSlotOptions contains the optional parameters for the WebAppsClient.ListSlotSiteDeploymentStatusesSlot
// method.
type WebAppsClientListSlotSiteDeploymentStatusesSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSlotsOptions contains the optional parameters for the WebAppsClient.ListSlots method.
type WebAppsClientListSlotsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsFromDRSecondaryOptions contains the optional parameters for the WebAppsClient.ListSnapshotsFromDRSecondary
// method.
type WebAppsClientListSnapshotsFromDRSecondaryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsFromDRSecondarySlotOptions contains the optional parameters for the WebAppsClient.ListSnapshotsFromDRSecondarySlot
// method.
type WebAppsClientListSnapshotsFromDRSecondarySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsOptions contains the optional parameters for the WebAppsClient.ListSnapshots method.
type WebAppsClientListSnapshotsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSnapshotsSlotOptions contains the optional parameters for the WebAppsClient.ListSnapshotsSlot method.
type WebAppsClientListSnapshotsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncFunctionTriggersOptions contains the optional parameters for the WebAppsClient.ListSyncFunctionTriggers
// method.
type WebAppsClientListSyncFunctionTriggersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncFunctionTriggersSlotOptions contains the optional parameters for the WebAppsClient.ListSyncFunctionTriggersSlot
// method.
type WebAppsClientListSyncFunctionTriggersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncStatusOptions contains the optional parameters for the WebAppsClient.ListSyncStatus method.
type WebAppsClientListSyncStatusOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListSyncStatusSlotOptions contains the optional parameters for the WebAppsClient.ListSyncStatusSlot method.
type WebAppsClientListSyncStatusSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobHistoryOptions contains the optional parameters for the WebAppsClient.ListTriggeredWebJobHistory
// method.
type WebAppsClientListTriggeredWebJobHistoryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobHistorySlotOptions contains the optional parameters for the WebAppsClient.ListTriggeredWebJobHistorySlot
// method.
type WebAppsClientListTriggeredWebJobHistorySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobsOptions contains the optional parameters for the WebAppsClient.ListTriggeredWebJobs method.
type WebAppsClientListTriggeredWebJobsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListTriggeredWebJobsSlotOptions contains the optional parameters for the WebAppsClient.ListTriggeredWebJobsSlot
// method.
type WebAppsClientListTriggeredWebJobsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListUsagesOptions contains the optional parameters for the WebAppsClient.ListUsages method.
type WebAppsClientListUsagesOptions struct {
	// Return only information specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or
	// name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq
	// 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListUsagesSlotOptions contains the optional parameters for the WebAppsClient.ListUsagesSlot method.
type WebAppsClientListUsagesSlotOptions struct {
	// Return only information specified in the filter (using OData syntax). For example: $filter=(name.value eq 'Metric1' or
	// name.value eq 'Metric2') and startTime eq 2014-01-01T00:00:00Z and endTime eq
	// 2014-12-31T23:59:59Z and timeGrain eq duration'[Hour|Minute|Day]'.
	Filter *string
}

// WebAppsClientListVnetConnectionsOptions contains the optional parameters for the WebAppsClient.ListVnetConnections method.
type WebAppsClientListVnetConnectionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListVnetConnectionsSlotOptions contains the optional parameters for the WebAppsClient.ListVnetConnectionsSlot
// method.
type WebAppsClientListVnetConnectionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListWebJobsOptions contains the optional parameters for the WebAppsClient.ListWebJobs method.
type WebAppsClientListWebJobsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientListWebJobsSlotOptions contains the optional parameters for the WebAppsClient.ListWebJobsSlot method.
type WebAppsClientListWebJobsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientPutPrivateAccessVnetOptions contains the optional parameters for the WebAppsClient.PutPrivateAccessVnet method.
type WebAppsClientPutPrivateAccessVnetOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientPutPrivateAccessVnetSlotOptions contains the optional parameters for the WebAppsClient.PutPrivateAccessVnetSlot
// method.
type WebAppsClientPutPrivateAccessVnetSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRecoverSiteConfigurationSnapshotOptions contains the optional parameters for the WebAppsClient.RecoverSiteConfigurationSnapshot
// method.
type WebAppsClientRecoverSiteConfigurationSnapshotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRecoverSiteConfigurationSnapshotSlotOptions contains the optional parameters for the WebAppsClient.RecoverSiteConfigurationSnapshotSlot
// method.
type WebAppsClientRecoverSiteConfigurationSnapshotSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientResetProductionSlotConfigOptions contains the optional parameters for the WebAppsClient.ResetProductionSlotConfig
// method.
type WebAppsClientResetProductionSlotConfigOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientResetSlotConfigurationSlotOptions contains the optional parameters for the WebAppsClient.ResetSlotConfigurationSlot
// method.
type WebAppsClientResetSlotConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRestartOptions contains the optional parameters for the WebAppsClient.Restart method.
type WebAppsClientRestartOptions struct {
	// Specify true to apply the configuration settings and restarts the app only if necessary. By default, the API always restarts
	// and reprovisions the app.
	SoftRestart *bool
	// Specify true to block until the app is restarted. By default, it is set to false, and the API responds immediately (asynchronous).
	Synchronous *bool
}

// WebAppsClientRestartSlotOptions contains the optional parameters for the WebAppsClient.RestartSlot method.
type WebAppsClientRestartSlotOptions struct {
	// Specify true to apply the configuration settings and restarts the app only if necessary. By default, the API always restarts
	// and reprovisions the app.
	SoftRestart *bool
	// Specify true to block until the app is restarted. By default, it is set to false, and the API responds immediately (asynchronous).
	Synchronous *bool
}

// WebAppsClientRunTriggeredWebJobOptions contains the optional parameters for the WebAppsClient.RunTriggeredWebJob method.
type WebAppsClientRunTriggeredWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientRunTriggeredWebJobSlotOptions contains the optional parameters for the WebAppsClient.RunTriggeredWebJobSlot
// method.
type WebAppsClientRunTriggeredWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartContinuousWebJobOptions contains the optional parameters for the WebAppsClient.StartContinuousWebJob
// method.
type WebAppsClientStartContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.StartContinuousWebJobSlot
// method.
type WebAppsClientStartContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartOptions contains the optional parameters for the WebAppsClient.Start method.
type WebAppsClientStartOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartSlotOptions contains the optional parameters for the WebAppsClient.StartSlot method.
type WebAppsClientStartSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStartWebSiteNetworkTraceOptions contains the optional parameters for the WebAppsClient.StartWebSiteNetworkTrace
// method.
type WebAppsClientStartWebSiteNetworkTraceOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientStartWebSiteNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.StartWebSiteNetworkTraceSlot
// method.
type WebAppsClientStartWebSiteNetworkTraceSlotOptions struct {
	// The duration to keep capturing in seconds.
	DurationInSeconds *int32
	// The maximum frame length in bytes (Optional).
	MaxFrameLength *int32
	// The Blob URL to store capture file.
	SasURL *string
}

// WebAppsClientStopContinuousWebJobOptions contains the optional parameters for the WebAppsClient.StopContinuousWebJob method.
type WebAppsClientStopContinuousWebJobOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopContinuousWebJobSlotOptions contains the optional parameters for the WebAppsClient.StopContinuousWebJobSlot
// method.
type WebAppsClientStopContinuousWebJobSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopNetworkTraceOptions contains the optional parameters for the WebAppsClient.StopNetworkTrace method.
type WebAppsClientStopNetworkTraceOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.StopNetworkTraceSlot method.
type WebAppsClientStopNetworkTraceSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopOptions contains the optional parameters for the WebAppsClient.Stop method.
type WebAppsClientStopOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopSlotOptions contains the optional parameters for the WebAppsClient.StopSlot method.
type WebAppsClientStopSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopWebSiteNetworkTraceOptions contains the optional parameters for the WebAppsClient.StopWebSiteNetworkTrace
// method.
type WebAppsClientStopWebSiteNetworkTraceOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientStopWebSiteNetworkTraceSlotOptions contains the optional parameters for the WebAppsClient.StopWebSiteNetworkTraceSlot
// method.
type WebAppsClientStopWebSiteNetworkTraceSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionTriggersOptions contains the optional parameters for the WebAppsClient.SyncFunctionTriggers method.
type WebAppsClientSyncFunctionTriggersOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionTriggersSlotOptions contains the optional parameters for the WebAppsClient.SyncFunctionTriggersSlot
// method.
type WebAppsClientSyncFunctionTriggersSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionsOptions contains the optional parameters for the WebAppsClient.SyncFunctions method.
type WebAppsClientSyncFunctionsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncFunctionsSlotOptions contains the optional parameters for the WebAppsClient.SyncFunctionsSlot method.
type WebAppsClientSyncFunctionsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncRepositoryOptions contains the optional parameters for the WebAppsClient.SyncRepository method.
type WebAppsClientSyncRepositoryOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientSyncRepositorySlotOptions contains the optional parameters for the WebAppsClient.SyncRepositorySlot method.
type WebAppsClientSyncRepositorySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateApplicationSettingsOptions contains the optional parameters for the WebAppsClient.UpdateApplicationSettings
// method.
type WebAppsClientUpdateApplicationSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateApplicationSettingsSlotOptions contains the optional parameters for the WebAppsClient.UpdateApplicationSettingsSlot
// method.
type WebAppsClientUpdateApplicationSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAuthSettingsOptions contains the optional parameters for the WebAppsClient.UpdateAuthSettings method.
type WebAppsClientUpdateAuthSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAuthSettingsSlotOptions contains the optional parameters for the WebAppsClient.UpdateAuthSettingsSlot
// method.
type WebAppsClientUpdateAuthSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAuthSettingsV2Options contains the optional parameters for the WebAppsClient.UpdateAuthSettingsV2 method.
type WebAppsClientUpdateAuthSettingsV2Options struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAuthSettingsV2SlotOptions contains the optional parameters for the WebAppsClient.UpdateAuthSettingsV2Slot
// method.
type WebAppsClientUpdateAuthSettingsV2SlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAzureStorageAccountsOptions contains the optional parameters for the WebAppsClient.UpdateAzureStorageAccounts
// method.
type WebAppsClientUpdateAzureStorageAccountsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateAzureStorageAccountsSlotOptions contains the optional parameters for the WebAppsClient.UpdateAzureStorageAccountsSlot
// method.
type WebAppsClientUpdateAzureStorageAccountsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateBackupConfigurationOptions contains the optional parameters for the WebAppsClient.UpdateBackupConfiguration
// method.
type WebAppsClientUpdateBackupConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateBackupConfigurationSlotOptions contains the optional parameters for the WebAppsClient.UpdateBackupConfigurationSlot
// method.
type WebAppsClientUpdateBackupConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConfigurationOptions contains the optional parameters for the WebAppsClient.UpdateConfiguration method.
type WebAppsClientUpdateConfigurationOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConfigurationSlotOptions contains the optional parameters for the WebAppsClient.UpdateConfigurationSlot
// method.
type WebAppsClientUpdateConfigurationSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConnectionStringsOptions contains the optional parameters for the WebAppsClient.UpdateConnectionStrings
// method.
type WebAppsClientUpdateConnectionStringsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateConnectionStringsSlotOptions contains the optional parameters for the WebAppsClient.UpdateConnectionStringsSlot
// method.
type WebAppsClientUpdateConnectionStringsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDiagnosticLogsConfigOptions contains the optional parameters for the WebAppsClient.UpdateDiagnosticLogsConfig
// method.
type WebAppsClientUpdateDiagnosticLogsConfigOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDiagnosticLogsConfigSlotOptions contains the optional parameters for the WebAppsClient.UpdateDiagnosticLogsConfigSlot
// method.
type WebAppsClientUpdateDiagnosticLogsConfigSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDomainOwnershipIdentifierOptions contains the optional parameters for the WebAppsClient.UpdateDomainOwnershipIdentifier
// method.
type WebAppsClientUpdateDomainOwnershipIdentifierOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateDomainOwnershipIdentifierSlotOptions contains the optional parameters for the WebAppsClient.UpdateDomainOwnershipIdentifierSlot
// method.
type WebAppsClientUpdateDomainOwnershipIdentifierSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateFtpAllowedOptions contains the optional parameters for the WebAppsClient.UpdateFtpAllowed method.
type WebAppsClientUpdateFtpAllowedOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateFtpAllowedSlotOptions contains the optional parameters for the WebAppsClient.UpdateFtpAllowedSlot method.
type WebAppsClientUpdateFtpAllowedSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateHybridConnectionOptions contains the optional parameters for the WebAppsClient.UpdateHybridConnection
// method.
type WebAppsClientUpdateHybridConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateHybridConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateHybridConnectionSlot
// method.
type WebAppsClientUpdateHybridConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateMetadataOptions contains the optional parameters for the WebAppsClient.UpdateMetadata method.
type WebAppsClientUpdateMetadataOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateMetadataSlotOptions contains the optional parameters for the WebAppsClient.UpdateMetadataSlot method.
type WebAppsClientUpdateMetadataSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateOptions contains the optional parameters for the WebAppsClient.Update method.
type WebAppsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdatePremierAddOnOptions contains the optional parameters for the WebAppsClient.UpdatePremierAddOn method.
type WebAppsClientUpdatePremierAddOnOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdatePremierAddOnSlotOptions contains the optional parameters for the WebAppsClient.UpdatePremierAddOnSlot
// method.
type WebAppsClientUpdatePremierAddOnSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateRelayServiceConnectionOptions contains the optional parameters for the WebAppsClient.UpdateRelayServiceConnection
// method.
type WebAppsClientUpdateRelayServiceConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateRelayServiceConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateRelayServiceConnectionSlot
// method.
type WebAppsClientUpdateRelayServiceConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateScmAllowedOptions contains the optional parameters for the WebAppsClient.UpdateScmAllowed method.
type WebAppsClientUpdateScmAllowedOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateScmAllowedSlotOptions contains the optional parameters for the WebAppsClient.UpdateScmAllowedSlot method.
type WebAppsClientUpdateScmAllowedSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSitePushSettingsOptions contains the optional parameters for the WebAppsClient.UpdateSitePushSettings
// method.
type WebAppsClientUpdateSitePushSettingsOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSitePushSettingsSlotOptions contains the optional parameters for the WebAppsClient.UpdateSitePushSettingsSlot
// method.
type WebAppsClientUpdateSitePushSettingsSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSlotConfigurationNamesOptions contains the optional parameters for the WebAppsClient.UpdateSlotConfigurationNames
// method.
type WebAppsClientUpdateSlotConfigurationNamesOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSlotOptions contains the optional parameters for the WebAppsClient.UpdateSlot method.
type WebAppsClientUpdateSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSourceControlOptions contains the optional parameters for the WebAppsClient.UpdateSourceControl method.
type WebAppsClientUpdateSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSourceControlSlotOptions contains the optional parameters for the WebAppsClient.UpdateSourceControlSlot
// method.
type WebAppsClientUpdateSourceControlSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckOptions contains the optional parameters for the WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheck
// method.
type WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions contains the optional parameters for the WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheckSlot
// method.
type WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckSlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionGatewayOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnectionGateway
// method.
type WebAppsClientUpdateVnetConnectionGatewayOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionGatewaySlotOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnectionGatewaySlot
// method.
type WebAppsClientUpdateVnetConnectionGatewaySlotOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnection method.
type WebAppsClientUpdateVnetConnectionOptions struct {
	// placeholder for future optional parameters
}

// WebAppsClientUpdateVnetConnectionSlotOptions contains the optional parameters for the WebAppsClient.UpdateVnetConnectionSlot
// method.
type WebAppsClientUpdateVnetConnectionSlotOptions struct {
	// placeholder for future optional parameters
}

// WebJob - Web Job Information.
type WebJob struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// WebJob resource specific properties
	Properties *WebJobProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebJobCollection - Collection of Kudu web job information elements.
type WebJobCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WebJob `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WebJobProperties - WebJob resource specific properties
type WebJobProperties struct {
	// Error information.
	Error *string `json:"error,omitempty"`

	// Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`

	// Run command.
	RunCommand *string `json:"run_command,omitempty"`

	// Job settings.
	Settings map[string]interface{} `json:"settings,omitempty"`

	// Job URL.
	URL *string `json:"url,omitempty"`

	// Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`

	// Job type.
	WebJobType *WebJobType `json:"web_job_type,omitempty"`
}

type WebSiteInstanceStatus struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// WebSiteInstanceStatus resource specific properties
	Properties *WebSiteInstanceStatusProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WebSiteInstanceStatusProperties - WebSiteInstanceStatus resource specific properties
type WebSiteInstanceStatusProperties struct {
	// Link to the console to web app instance
	ConsoleURL *string `json:"consoleUrl,omitempty"`

	// Dictionary of
	Containers map[string]*ContainerInfo `json:"containers,omitempty"`

	// Link to the Diagnose and Solve Portal
	DetectorURL *string `json:"detectorUrl,omitempty"`

	// Link to the console to web app instance
	HealthCheckURL *string           `json:"healthCheckUrl,omitempty"`
	State          *SiteRuntimeState `json:"state,omitempty"`

	// Link to the GetStatusApi in Kudu
	StatusURL *string `json:"statusUrl,omitempty"`
}

// WebSiteManagementClientCheckNameAvailabilityOptions contains the optional parameters for the WebSiteManagementClient.CheckNameAvailability
// method.
type WebSiteManagementClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientGetPublishingUserOptions contains the optional parameters for the WebSiteManagementClient.GetPublishingUser
// method.
type WebSiteManagementClientGetPublishingUserOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientGetSourceControlOptions contains the optional parameters for the WebSiteManagementClient.GetSourceControl
// method.
type WebSiteManagementClientGetSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions contains the optional parameters for the WebSiteManagementClient.GetSubscriptionDeploymentLocations
// method.
type WebSiteManagementClientGetSubscriptionDeploymentLocationsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListBillingMetersOptions contains the optional parameters for the WebSiteManagementClient.ListBillingMeters
// method.
type WebSiteManagementClientListBillingMetersOptions struct {
	// Azure Location of billable resource
	BillingLocation *string
	// App Service OS type meters used for
	OSType *string
}

// WebSiteManagementClientListCustomHostNameSitesOptions contains the optional parameters for the WebSiteManagementClient.ListCustomHostNameSites
// method.
type WebSiteManagementClientListCustomHostNameSitesOptions struct {
	// Specific hostname
	Hostname *string
}

// WebSiteManagementClientListGeoRegionsOptions contains the optional parameters for the WebSiteManagementClient.ListGeoRegions
// method.
type WebSiteManagementClientListGeoRegionsOptions struct {
	// Specify true if you want to filter to only regions that support Linux Consumption Workers.
	LinuxDynamicWorkersEnabled *bool
	// Specify true if you want to filter to only regions that support Linux workers.
	LinuxWorkersEnabled *bool
	// Name of SKU used to filter the regions.
	SKU *SKUName
	// Specify true if you want to filter to only regions that support Xenon workers.
	XenonWorkersEnabled *bool
}

// WebSiteManagementClientListPremierAddOnOffersOptions contains the optional parameters for the WebSiteManagementClient.ListPremierAddOnOffers
// method.
type WebSiteManagementClientListPremierAddOnOffersOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListSKUsOptions contains the optional parameters for the WebSiteManagementClient.ListSKUs method.
type WebSiteManagementClientListSKUsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions contains the optional parameters for the WebSiteManagementClient.ListSiteIdentifiersAssignedToHostName
// method.
type WebSiteManagementClientListSiteIdentifiersAssignedToHostNameOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientListSourceControlsOptions contains the optional parameters for the WebSiteManagementClient.ListSourceControls
// method.
type WebSiteManagementClientListSourceControlsOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientMoveOptions contains the optional parameters for the WebSiteManagementClient.Move method.
type WebSiteManagementClientMoveOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientUpdatePublishingUserOptions contains the optional parameters for the WebSiteManagementClient.UpdatePublishingUser
// method.
type WebSiteManagementClientUpdatePublishingUserOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientUpdateSourceControlOptions contains the optional parameters for the WebSiteManagementClient.UpdateSourceControl
// method.
type WebSiteManagementClientUpdateSourceControlOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientValidateMoveOptions contains the optional parameters for the WebSiteManagementClient.ValidateMove
// method.
type WebSiteManagementClientValidateMoveOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientValidateOptions contains the optional parameters for the WebSiteManagementClient.Validate method.
type WebSiteManagementClientValidateOptions struct {
	// placeholder for future optional parameters
}

// WebSiteManagementClientVerifyHostingEnvironmentVnetOptions contains the optional parameters for the WebSiteManagementClient.VerifyHostingEnvironmentVnet
// method.
type WebSiteManagementClientVerifyHostingEnvironmentVnetOptions struct {
	// placeholder for future optional parameters
}

// WindowsJavaContainerSettings - Windows Java Container settings.
type WindowsJavaContainerSettings struct {
	// READ-ONLY; End-of-life date for the minor version.
	EndOfLifeDate *time.Time `json:"endOfLifeDate,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack version is auto-updated; otherwise, false.
	IsAutoUpdate *bool `json:"isAutoUpdate,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is deprecated; otherwise, false.
	IsDeprecated *bool `json:"isDeprecated,omitempty" azure:"ro"`

	// READ-ONLY; true if the minor version is early-access; otherwise, false.
	IsEarlyAccess *bool `json:"isEarlyAccess,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack should be hidden; otherwise, false.
	IsHidden *bool `json:"isHidden,omitempty" azure:"ro"`

	// READ-ONLY; true if the stack is in preview; otherwise, false.
	IsPreview *bool `json:"isPreview,omitempty" azure:"ro"`

	// READ-ONLY; Java container (runtime only).
	JavaContainer *string `json:"javaContainer,omitempty" azure:"ro"`

	// READ-ONLY; Java container version (runtime only).
	JavaContainerVersion *string `json:"javaContainerVersion,omitempty" azure:"ro"`
}

// WorkerPool - Worker pool of an App Service Environment.
type WorkerPool struct {
	// Shared or dedicated app hosting.
	ComputeMode *ComputeModeOptions `json:"computeMode,omitempty"`

	// Number of instances in the worker pool.
	WorkerCount *int32 `json:"workerCount,omitempty"`

	// VM size of the worker pool instances.
	WorkerSize *string `json:"workerSize,omitempty"`

	// Worker size ID for referencing this worker pool.
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`

	// READ-ONLY; Names of all instances in the worker pool (read only).
	InstanceNames []*string `json:"instanceNames,omitempty" azure:"ro"`
}

// WorkerPoolCollection - Collection of worker pools.
type WorkerPoolCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WorkerPoolResource `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WorkerPoolResource - Worker pool of an App Service Environment ARM resource.
type WorkerPoolResource struct {
	// Kind of resource.
	Kind *string `json:"kind,omitempty"`

	// Core resource properties
	Properties *WorkerPool `json:"properties,omitempty"`

	// Description of a SKU for a scalable resource.
	SKU *SKUDescription `json:"sku,omitempty"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Workflow - The workflow type.
type Workflow struct {
	// Managed service identity.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The workflow properties.
	Properties *WorkflowProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowFilter - The workflow filter.
type WorkflowFilter struct {
	// The state of workflows.
	State *WorkflowState `json:"state,omitempty"`
}

// WorkflowListResult - The list of workflows.
type WorkflowListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of workflows.
	Value []*Workflow `json:"value,omitempty"`
}

// WorkflowOutputParameter - The workflow output parameter.
type WorkflowOutputParameter struct {
	// The description.
	Description *string `json:"description,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The type.
	Type *ParameterType `json:"type,omitempty"`

	// The value.
	Value interface{} `json:"value,omitempty"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`
}

// WorkflowParameter - The workflow parameters.
type WorkflowParameter struct {
	// The description.
	Description *string `json:"description,omitempty"`

	// The metadata.
	Metadata interface{} `json:"metadata,omitempty"`

	// The type.
	Type *ParameterType `json:"type,omitempty"`

	// The value.
	Value interface{} `json:"value,omitempty"`
}

// WorkflowProperties - The workflow properties.
type WorkflowProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration `json:"accessControl,omitempty"`

	// The definition.
	Definition interface{} `json:"definition,omitempty"`

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration `json:"endpointsConfiguration,omitempty"`

	// The integration account.
	IntegrationAccount *ResourceReference `json:"integrationAccount,omitempty"`

	// The integration service environment.
	IntegrationServiceEnvironment *ResourceReference `json:"integrationServiceEnvironment,omitempty"`

	// The workflow kind.
	Kind *Kind `json:"kind,omitempty"`

	// The parameters.
	Parameters map[string]*WorkflowParameter `json:"parameters,omitempty"`

	// The state.
	State *WorkflowState `json:"state,omitempty"`

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string `json:"accessEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The sku.
	SKU *WorkflowSKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Gets the version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// WorkflowResource - The base resource type.
type WorkflowResource struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRun - The workflow run.
type WorkflowRun struct {
	// The workflow run properties.
	Properties *WorkflowRunProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRunAction - The workflow run action.
type WorkflowRunAction struct {
	// The workflow run action properties.
	Properties *WorkflowRunActionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run action name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow run action type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRunActionFilter - The workflow run action filter.
type WorkflowRunActionFilter struct {
	// The status of workflow run action.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunActionListResult - The list of workflow run actions.
type WorkflowRunActionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow run actions.
	Value []*WorkflowRunAction `json:"value,omitempty"`
}

// WorkflowRunActionProperties - The workflow run action properties.
type WorkflowRunActionProperties struct {
	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// Gets the retry histories.
	RetryHistory []*RetryHistory `json:"retryHistory,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowRunActionRepetitionDefinition - The workflow run action repetition definition.
type WorkflowRunActionRepetitionDefinition struct {
	// REQUIRED; The workflow run action repetition properties definition.
	Properties *WorkflowRunActionRepetitionProperties `json:"properties,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowRunActionRepetitionDefinitionCollection - A collection of workflow run action repetitions.
type WorkflowRunActionRepetitionDefinitionCollection struct {
	// The link used to get the next page of recommendations.
	NextLink *string                                  `json:"nextLink,omitempty"`
	Value    []*WorkflowRunActionRepetitionDefinition `json:"value,omitempty"`
}

// WorkflowRunActionRepetitionProperties - The workflow run action repetition properties definition.
type WorkflowRunActionRepetitionProperties struct {
	// The workflow scope repetition code.
	Code *string `json:"code,omitempty"`

	// The correlation properties.
	Correlation *RunActionCorrelation `json:"correlation,omitempty"`

	// The end time of the workflow scope repetition.
	EndTime *time.Time `json:"endTime,omitempty"`

	// Anything
	Error          interface{} `json:"error,omitempty"`
	IterationCount *int32      `json:"iterationCount,omitempty"`

	// The repetition indexes.
	RepetitionIndexes []*RepetitionIndex `json:"repetitionIndexes,omitempty"`

	// Gets the retry histories.
	RetryHistory []*RetryHistory `json:"retryHistory,omitempty"`

	// The start time of the workflow scope repetition.
	StartTime *time.Time `json:"startTime,omitempty"`

	// The status of the workflow scope repetition.
	Status *WorkflowStatus `json:"status,omitempty"`

	// READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowRunActionRepetitionsClientGetOptions contains the optional parameters for the WorkflowRunActionRepetitionsClient.Get
// method.
type WorkflowRunActionRepetitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsClientListExpressionTracesOptions contains the optional parameters for the WorkflowRunActionRepetitionsClient.ListExpressionTraces
// method.
type WorkflowRunActionRepetitionsClientListExpressionTracesOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsClientListOptions contains the optional parameters for the WorkflowRunActionRepetitionsClient.List
// method.
type WorkflowRunActionRepetitionsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsRequestHistoriesClientGetOptions contains the optional parameters for the WorkflowRunActionRepetitionsRequestHistoriesClient.Get
// method.
type WorkflowRunActionRepetitionsRequestHistoriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionRepetitionsRequestHistoriesClientListOptions contains the optional parameters for the WorkflowRunActionRepetitionsRequestHistoriesClient.List
// method.
type WorkflowRunActionRepetitionsRequestHistoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionScopeRepetitionsClientGetOptions contains the optional parameters for the WorkflowRunActionScopeRepetitionsClient.Get
// method.
type WorkflowRunActionScopeRepetitionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionScopeRepetitionsClientListOptions contains the optional parameters for the WorkflowRunActionScopeRepetitionsClient.List
// method.
type WorkflowRunActionScopeRepetitionsClientListOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionsClientGetOptions contains the optional parameters for the WorkflowRunActionsClient.Get method.
type WorkflowRunActionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionsClientListExpressionTracesOptions contains the optional parameters for the WorkflowRunActionsClient.ListExpressionTraces
// method.
type WorkflowRunActionsClientListExpressionTracesOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunActionsClientListOptions contains the optional parameters for the WorkflowRunActionsClient.List method.
type WorkflowRunActionsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: Status.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowRunFilter - The workflow run filter.
type WorkflowRunFilter struct {
	// The status of workflow run.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// WorkflowRunListResult - The list of workflow runs.
type WorkflowRunListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow runs.
	Value []*WorkflowRun `json:"value,omitempty"`
}

// WorkflowRunProperties - The workflow run properties.
type WorkflowRunProperties struct {
	// The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the correlation id.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs map[string]*WorkflowOutputParameter `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the response of the flow run.
	Response *WorkflowRunTrigger `json:"response,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the fired trigger.
	Trigger *WorkflowRunTrigger `json:"trigger,omitempty" azure:"ro"`

	// READ-ONLY; Gets the wait end time.
	WaitEndTime *time.Time `json:"waitEndTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reference to workflow version.
	Workflow *ResourceReference `json:"workflow,omitempty" azure:"ro"`
}

// WorkflowRunTrigger - The workflow run trigger.
type WorkflowRunTrigger struct {
	// The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Gets the inputs.
	Inputs interface{} `json:"inputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to inputs.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the outputs.
	Outputs interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to outputs.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the scheduled time.
	ScheduledTime *time.Time `json:"scheduledTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracked properties.
	TrackedProperties interface{} `json:"trackedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowRunsClientCancelOptions contains the optional parameters for the WorkflowRunsClient.Cancel method.
type WorkflowRunsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunsClientGetOptions contains the optional parameters for the WorkflowRunsClient.Get method.
type WorkflowRunsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowRunsClientListOptions contains the optional parameters for the WorkflowRunsClient.List method.
type WorkflowRunsClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: Status, StartTime, and ClientTrackingId.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowSKU - The sku type.
type WorkflowSKU struct {
	// REQUIRED; The name.
	Name *WorkflowSKUName `json:"name,omitempty"`

	// The reference to plan.
	Plan *ResourceReference `json:"plan,omitempty"`
}

// WorkflowTrigger - The workflow trigger.
type WorkflowTrigger struct {
	// The workflow trigger properties.
	Properties *WorkflowTriggerProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowTriggerCallbackURL - The workflow trigger callback URL.
type WorkflowTriggerCallbackURL struct {
	// Gets the workflow trigger callback URL query parameters.
	Queries *WorkflowTriggerListCallbackURLQueries `json:"queries,omitempty"`

	// Gets the workflow trigger callback URL relative path parameters.
	RelativePathParameters []*string `json:"relativePathParameters,omitempty"`

	// READ-ONLY; Gets the workflow trigger callback URL base path.
	BasePath *string `json:"basePath,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger callback URL HTTP method.
	Method *string `json:"method,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger callback URL relative path.
	RelativePath *string `json:"relativePath,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger callback URL.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// WorkflowTriggerFilter - The workflow trigger filter.
type WorkflowTriggerFilter struct {
	// The state of workflow trigger.
	State *WorkflowState `json:"state,omitempty"`
}

// WorkflowTriggerHistoriesClientBeginResubmitOptions contains the optional parameters for the WorkflowTriggerHistoriesClient.BeginResubmit
// method.
type WorkflowTriggerHistoriesClientBeginResubmitOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkflowTriggerHistoriesClientGetOptions contains the optional parameters for the WorkflowTriggerHistoriesClient.Get method.
type WorkflowTriggerHistoriesClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggerHistoriesClientListOptions contains the optional parameters for the WorkflowTriggerHistoriesClient.List
// method.
type WorkflowTriggerHistoriesClientListOptions struct {
	// The filter to apply on the operation. Options for filters include: Status, StartTime, and ClientTrackingId.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowTriggerHistory - The workflow trigger history.
type WorkflowTriggerHistory struct {
	// Gets the workflow trigger history properties.
	Properties *WorkflowTriggerHistoryProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger history name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger history type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowTriggerHistoryFilter - The workflow trigger history filter.
type WorkflowTriggerHistoryFilter struct {
	// The status of workflow trigger history.
	Status *WorkflowStatus `json:"status,omitempty"`
}

// WorkflowTriggerHistoryListResult - The list of workflow trigger histories.
type WorkflowTriggerHistoryListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow trigger histories.
	Value []*WorkflowTriggerHistory `json:"value,omitempty"`
}

// WorkflowTriggerHistoryProperties - The workflow trigger history properties.
type WorkflowTriggerHistoryProperties struct {
	// The run correlation.
	Correlation *Correlation `json:"correlation,omitempty"`

	// READ-ONLY; Gets the code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Gets the end time.
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the error.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The value indicating whether trigger was fired.
	Fired *bool `json:"fired,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to input parameters.
	InputsLink *ContentLink `json:"inputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the link to output parameters.
	OutputsLink *ContentLink `json:"outputsLink,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reference to workflow run.
	Run *ResourceReference `json:"run,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled time.
	ScheduledTime *time.Time `json:"scheduledTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the start time.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the tracking id.
	TrackingID *string `json:"trackingId,omitempty" azure:"ro"`
}

// WorkflowTriggerListCallbackURLQueries - Gets the workflow trigger callback URL query parameters.
type WorkflowTriggerListCallbackURLQueries struct {
	// The api version.
	APIVersion *string `json:"api-version,omitempty"`

	// The SAS timestamp.
	Se *string `json:"se,omitempty"`

	// The SAS signature.
	Sig *string `json:"sig,omitempty"`

	// The SAS permissions.
	Sp *string `json:"sp,omitempty"`

	// The SAS version.
	Sv *string `json:"sv,omitempty"`
}

// WorkflowTriggerListResult - The list of workflow triggers.
type WorkflowTriggerListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow triggers.
	Value []*WorkflowTrigger `json:"value,omitempty"`
}

// WorkflowTriggerProperties - The workflow trigger properties.
type WorkflowTriggerProperties struct {
	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the last execution time.
	LastExecutionTime *time.Time `json:"lastExecutionTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the next execution time.
	NextExecutionTime *time.Time `json:"nextExecutionTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *WorkflowTriggerProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the workflow trigger recurrence.
	Recurrence *WorkflowTriggerRecurrence `json:"recurrence,omitempty" azure:"ro"`

	// READ-ONLY; Gets the state.
	State *WorkflowState `json:"state,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status.
	Status *WorkflowStatus `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Gets the reference to workflow.
	Workflow *ResourceReference `json:"workflow,omitempty" azure:"ro"`
}

// WorkflowTriggerRecurrence - The workflow trigger recurrence.
type WorkflowTriggerRecurrence struct {
	// The end time.
	EndTime *string `json:"endTime,omitempty"`

	// The frequency.
	Frequency *RecurrenceFrequency `json:"frequency,omitempty"`

	// The interval.
	Interval *int32 `json:"interval,omitempty"`

	// The recurrence schedule.
	Schedule *RecurrenceSchedule `json:"schedule,omitempty"`

	// The start time.
	StartTime *string `json:"startTime,omitempty"`

	// The time zone.
	TimeZone *string `json:"timeZone,omitempty"`
}

// WorkflowTriggersClientBeginRunOptions contains the optional parameters for the WorkflowTriggersClient.BeginRun method.
type WorkflowTriggersClientBeginRunOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// WorkflowTriggersClientGetOptions contains the optional parameters for the WorkflowTriggersClient.Get method.
type WorkflowTriggersClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientGetSchemaJSONOptions contains the optional parameters for the WorkflowTriggersClient.GetSchemaJSON
// method.
type WorkflowTriggersClientGetSchemaJSONOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientListCallbackURLOptions contains the optional parameters for the WorkflowTriggersClient.ListCallbackURL
// method.
type WorkflowTriggersClientListCallbackURLOptions struct {
	// placeholder for future optional parameters
}

// WorkflowTriggersClientListOptions contains the optional parameters for the WorkflowTriggersClient.List method.
type WorkflowTriggersClientListOptions struct {
	// The filter to apply on the operation.
	Filter *string
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowVersion - The workflow version.
type WorkflowVersion struct {
	// The resource location.
	Location *string `json:"location,omitempty"`

	// The workflow version properties.
	Properties *WorkflowVersionProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Gets the resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkflowVersionListResult - The list of workflow versions.
type WorkflowVersionListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of workflow versions.
	Value []*WorkflowVersion `json:"value,omitempty"`
}

// WorkflowVersionProperties - The workflow version properties.
type WorkflowVersionProperties struct {
	// The access control configuration.
	AccessControl *FlowAccessControlConfiguration `json:"accessControl,omitempty"`

	// The definition.
	Definition interface{} `json:"definition,omitempty"`

	// The endpoints configuration.
	EndpointsConfiguration *FlowEndpointsConfiguration `json:"endpointsConfiguration,omitempty"`

	// The integration account.
	IntegrationAccount *ResourceReference `json:"integrationAccount,omitempty"`

	// The parameters.
	Parameters map[string]*WorkflowParameter `json:"parameters,omitempty"`

	// The state.
	State *WorkflowState `json:"state,omitempty"`

	// READ-ONLY; Gets the access endpoint.
	AccessEndpoint *string `json:"accessEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Gets the changed time.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; Gets the created time.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state.
	ProvisioningState *WorkflowProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The sku.
	SKU *WorkflowSKU `json:"sku,omitempty" azure:"ro"`

	// READ-ONLY; Gets the version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// WorkflowVersionsClientGetOptions contains the optional parameters for the WorkflowVersionsClient.Get method.
type WorkflowVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// WorkflowVersionsClientListOptions contains the optional parameters for the WorkflowVersionsClient.List method.
type WorkflowVersionsClientListOptions struct {
	// The number of items to be included in the result.
	Top *int32
}

// WorkflowsClientRegenerateAccessKeyOptions contains the optional parameters for the WorkflowsClient.RegenerateAccessKey
// method.
type WorkflowsClientRegenerateAccessKeyOptions struct {
	// placeholder for future optional parameters
}

// WorkflowsClientValidateOptions contains the optional parameters for the WorkflowsClient.Validate method.
type WorkflowsClientValidateOptions struct {
	// placeholder for future optional parameters
}
