//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatafactory

const (
	moduleName    = "armdatafactory"
	moduleVersion = "v3.0.0"
)

// AzureFunctionActivityMethod - The list of HTTP methods supported by a AzureFunctionActivity.
type AzureFunctionActivityMethod string

const (
	AzureFunctionActivityMethodDELETE  AzureFunctionActivityMethod = "DELETE"
	AzureFunctionActivityMethodGET     AzureFunctionActivityMethod = "GET"
	AzureFunctionActivityMethodHEAD    AzureFunctionActivityMethod = "HEAD"
	AzureFunctionActivityMethodOPTIONS AzureFunctionActivityMethod = "OPTIONS"
	AzureFunctionActivityMethodPOST    AzureFunctionActivityMethod = "POST"
	AzureFunctionActivityMethodPUT     AzureFunctionActivityMethod = "PUT"
	AzureFunctionActivityMethodTRACE   AzureFunctionActivityMethod = "TRACE"
)

// PossibleAzureFunctionActivityMethodValues returns the possible values for the AzureFunctionActivityMethod const type.
func PossibleAzureFunctionActivityMethodValues() []AzureFunctionActivityMethod {
	return []AzureFunctionActivityMethod{
		AzureFunctionActivityMethodDELETE,
		AzureFunctionActivityMethodGET,
		AzureFunctionActivityMethodHEAD,
		AzureFunctionActivityMethodOPTIONS,
		AzureFunctionActivityMethodPOST,
		AzureFunctionActivityMethodPUT,
		AzureFunctionActivityMethodTRACE,
	}
}

// AzureSearchIndexWriteBehaviorType - Specify the write behavior when upserting documents into Azure Search Index.
type AzureSearchIndexWriteBehaviorType string

const (
	AzureSearchIndexWriteBehaviorTypeMerge  AzureSearchIndexWriteBehaviorType = "Merge"
	AzureSearchIndexWriteBehaviorTypeUpload AzureSearchIndexWriteBehaviorType = "Upload"
)

// PossibleAzureSearchIndexWriteBehaviorTypeValues returns the possible values for the AzureSearchIndexWriteBehaviorType const type.
func PossibleAzureSearchIndexWriteBehaviorTypeValues() []AzureSearchIndexWriteBehaviorType {
	return []AzureSearchIndexWriteBehaviorType{
		AzureSearchIndexWriteBehaviorTypeMerge,
		AzureSearchIndexWriteBehaviorTypeUpload,
	}
}

// BigDataPoolReferenceType - Big data pool reference type.
type BigDataPoolReferenceType string

const (
	BigDataPoolReferenceTypeBigDataPoolReference BigDataPoolReferenceType = "BigDataPoolReference"
)

// PossibleBigDataPoolReferenceTypeValues returns the possible values for the BigDataPoolReferenceType const type.
func PossibleBigDataPoolReferenceTypeValues() []BigDataPoolReferenceType {
	return []BigDataPoolReferenceType{
		BigDataPoolReferenceTypeBigDataPoolReference,
	}
}

type BlobEventTypes string

const (
	BlobEventTypesMicrosoftStorageBlobCreated BlobEventTypes = "Microsoft.Storage.BlobCreated"
	BlobEventTypesMicrosoftStorageBlobDeleted BlobEventTypes = "Microsoft.Storage.BlobDeleted"
)

// PossibleBlobEventTypesValues returns the possible values for the BlobEventTypes const type.
func PossibleBlobEventTypesValues() []BlobEventTypes {
	return []BlobEventTypes{
		BlobEventTypesMicrosoftStorageBlobCreated,
		BlobEventTypesMicrosoftStorageBlobDeleted,
	}
}

// CassandraSourceReadConsistencyLevels - The consistency level specifies how many Cassandra servers must respond to a read
// request before returning data to the client application. Cassandra checks the specified number of Cassandra servers
// for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'.
// It is case-insensitive.
type CassandraSourceReadConsistencyLevels string

const (
	CassandraSourceReadConsistencyLevelsALL         CassandraSourceReadConsistencyLevels = "ALL"
	CassandraSourceReadConsistencyLevelsEACHQUORUM  CassandraSourceReadConsistencyLevels = "EACH_QUORUM"
	CassandraSourceReadConsistencyLevelsLOCALONE    CassandraSourceReadConsistencyLevels = "LOCAL_ONE"
	CassandraSourceReadConsistencyLevelsLOCALQUORUM CassandraSourceReadConsistencyLevels = "LOCAL_QUORUM"
	CassandraSourceReadConsistencyLevelsLOCALSERIAL CassandraSourceReadConsistencyLevels = "LOCAL_SERIAL"
	CassandraSourceReadConsistencyLevelsONE         CassandraSourceReadConsistencyLevels = "ONE"
	CassandraSourceReadConsistencyLevelsQUORUM      CassandraSourceReadConsistencyLevels = "QUORUM"
	CassandraSourceReadConsistencyLevelsSERIAL      CassandraSourceReadConsistencyLevels = "SERIAL"
	CassandraSourceReadConsistencyLevelsTHREE       CassandraSourceReadConsistencyLevels = "THREE"
	CassandraSourceReadConsistencyLevelsTWO         CassandraSourceReadConsistencyLevels = "TWO"
)

// PossibleCassandraSourceReadConsistencyLevelsValues returns the possible values for the CassandraSourceReadConsistencyLevels const type.
func PossibleCassandraSourceReadConsistencyLevelsValues() []CassandraSourceReadConsistencyLevels {
	return []CassandraSourceReadConsistencyLevels{
		CassandraSourceReadConsistencyLevelsALL,
		CassandraSourceReadConsistencyLevelsEACHQUORUM,
		CassandraSourceReadConsistencyLevelsLOCALONE,
		CassandraSourceReadConsistencyLevelsLOCALQUORUM,
		CassandraSourceReadConsistencyLevelsLOCALSERIAL,
		CassandraSourceReadConsistencyLevelsONE,
		CassandraSourceReadConsistencyLevelsQUORUM,
		CassandraSourceReadConsistencyLevelsSERIAL,
		CassandraSourceReadConsistencyLevelsTHREE,
		CassandraSourceReadConsistencyLevelsTWO,
	}
}

// CosmosDbConnectionMode - The connection mode used to access CosmosDB account. Type: string (or Expression with resultType
// string).
type CosmosDbConnectionMode string

const (
	CosmosDbConnectionModeDirect  CosmosDbConnectionMode = "Direct"
	CosmosDbConnectionModeGateway CosmosDbConnectionMode = "Gateway"
)

// PossibleCosmosDbConnectionModeValues returns the possible values for the CosmosDbConnectionMode const type.
func PossibleCosmosDbConnectionModeValues() []CosmosDbConnectionMode {
	return []CosmosDbConnectionMode{
		CosmosDbConnectionModeDirect,
		CosmosDbConnectionModeGateway,
	}
}

// CosmosDbServicePrincipalCredentialType - The service principal credential type to use in Server-To-Server authentication.
// 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or Expression with
// resultType string).
type CosmosDbServicePrincipalCredentialType string

const (
	CosmosDbServicePrincipalCredentialTypeServicePrincipalCert CosmosDbServicePrincipalCredentialType = "ServicePrincipalCert"
	CosmosDbServicePrincipalCredentialTypeServicePrincipalKey  CosmosDbServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleCosmosDbServicePrincipalCredentialTypeValues returns the possible values for the CosmosDbServicePrincipalCredentialType const type.
func PossibleCosmosDbServicePrincipalCredentialTypeValues() []CosmosDbServicePrincipalCredentialType {
	return []CosmosDbServicePrincipalCredentialType{
		CosmosDbServicePrincipalCredentialTypeServicePrincipalCert,
		CosmosDbServicePrincipalCredentialTypeServicePrincipalKey,
	}
}

// CredentialReferenceType - Credential reference type.
type CredentialReferenceType string

const (
	CredentialReferenceTypeCredentialReference CredentialReferenceType = "CredentialReference"
)

// PossibleCredentialReferenceTypeValues returns the possible values for the CredentialReferenceType const type.
func PossibleCredentialReferenceTypeValues() []CredentialReferenceType {
	return []CredentialReferenceType{
		CredentialReferenceTypeCredentialReference,
	}
}

// DataFlowComputeType - Compute type of the cluster which will execute data flow job.
type DataFlowComputeType string

const (
	DataFlowComputeTypeComputeOptimized DataFlowComputeType = "ComputeOptimized"
	DataFlowComputeTypeGeneral          DataFlowComputeType = "General"
	DataFlowComputeTypeMemoryOptimized  DataFlowComputeType = "MemoryOptimized"
)

// PossibleDataFlowComputeTypeValues returns the possible values for the DataFlowComputeType const type.
func PossibleDataFlowComputeTypeValues() []DataFlowComputeType {
	return []DataFlowComputeType{
		DataFlowComputeTypeComputeOptimized,
		DataFlowComputeTypeGeneral,
		DataFlowComputeTypeMemoryOptimized,
	}
}

// DataFlowDebugCommandType - The command type.
type DataFlowDebugCommandType string

const (
	DataFlowDebugCommandTypeExecuteExpressionQuery DataFlowDebugCommandType = "executeExpressionQuery"
	DataFlowDebugCommandTypeExecutePreviewQuery    DataFlowDebugCommandType = "executePreviewQuery"
	DataFlowDebugCommandTypeExecuteStatisticsQuery DataFlowDebugCommandType = "executeStatisticsQuery"
)

// PossibleDataFlowDebugCommandTypeValues returns the possible values for the DataFlowDebugCommandType const type.
func PossibleDataFlowDebugCommandTypeValues() []DataFlowDebugCommandType {
	return []DataFlowDebugCommandType{
		DataFlowDebugCommandTypeExecuteExpressionQuery,
		DataFlowDebugCommandTypeExecutePreviewQuery,
		DataFlowDebugCommandTypeExecuteStatisticsQuery,
	}
}

// DataFlowReferenceType - Data flow reference type.
type DataFlowReferenceType string

const (
	DataFlowReferenceTypeDataFlowReference DataFlowReferenceType = "DataFlowReference"
)

// PossibleDataFlowReferenceTypeValues returns the possible values for the DataFlowReferenceType const type.
func PossibleDataFlowReferenceTypeValues() []DataFlowReferenceType {
	return []DataFlowReferenceType{
		DataFlowReferenceTypeDataFlowReference,
	}
}

// DatasetReferenceType - Dataset reference type.
type DatasetReferenceType string

const (
	DatasetReferenceTypeDatasetReference DatasetReferenceType = "DatasetReference"
)

// PossibleDatasetReferenceTypeValues returns the possible values for the DatasetReferenceType const type.
func PossibleDatasetReferenceTypeValues() []DatasetReferenceType {
	return []DatasetReferenceType{
		DatasetReferenceTypeDatasetReference,
	}
}

// DayOfWeek - The days of the week.
type DayOfWeek string

const (
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekSunday,
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
	}
}

type DaysOfWeek string

const (
	DaysOfWeekSunday    DaysOfWeek = "Sunday"
	DaysOfWeekMonday    DaysOfWeek = "Monday"
	DaysOfWeekTuesday   DaysOfWeek = "Tuesday"
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
	DaysOfWeekThursday  DaysOfWeek = "Thursday"
	DaysOfWeekFriday    DaysOfWeek = "Friday"
	DaysOfWeekSaturday  DaysOfWeek = "Saturday"
)

// PossibleDaysOfWeekValues returns the possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{
		DaysOfWeekSunday,
		DaysOfWeekMonday,
		DaysOfWeekTuesday,
		DaysOfWeekWednesday,
		DaysOfWeekThursday,
		DaysOfWeekFriday,
		DaysOfWeekSaturday,
	}
}

// Db2AuthenticationType - AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
type Db2AuthenticationType string

const (
	Db2AuthenticationTypeBasic Db2AuthenticationType = "Basic"
)

// PossibleDb2AuthenticationTypeValues returns the possible values for the Db2AuthenticationType const type.
func PossibleDb2AuthenticationTypeValues() []Db2AuthenticationType {
	return []Db2AuthenticationType{
		Db2AuthenticationTypeBasic,
	}
}

type DependencyCondition string

const (
	DependencyConditionCompleted DependencyCondition = "Completed"
	DependencyConditionFailed    DependencyCondition = "Failed"
	DependencyConditionSkipped   DependencyCondition = "Skipped"
	DependencyConditionSucceeded DependencyCondition = "Succeeded"
)

// PossibleDependencyConditionValues returns the possible values for the DependencyCondition const type.
func PossibleDependencyConditionValues() []DependencyCondition {
	return []DependencyCondition{
		DependencyConditionCompleted,
		DependencyConditionFailed,
		DependencyConditionSkipped,
		DependencyConditionSucceeded,
	}
}

// DynamicsSinkWriteBehavior - Defines values for DynamicsSinkWriteBehavior.
type DynamicsSinkWriteBehavior string

const (
	DynamicsSinkWriteBehaviorUpsert DynamicsSinkWriteBehavior = "Upsert"
)

// PossibleDynamicsSinkWriteBehaviorValues returns the possible values for the DynamicsSinkWriteBehavior const type.
func PossibleDynamicsSinkWriteBehaviorValues() []DynamicsSinkWriteBehavior {
	return []DynamicsSinkWriteBehavior{
		DynamicsSinkWriteBehaviorUpsert,
	}
}

// EventSubscriptionStatus - Event Subscription Status.
type EventSubscriptionStatus string

const (
	EventSubscriptionStatusDeprovisioning EventSubscriptionStatus = "Deprovisioning"
	EventSubscriptionStatusDisabled       EventSubscriptionStatus = "Disabled"
	EventSubscriptionStatusEnabled        EventSubscriptionStatus = "Enabled"
	EventSubscriptionStatusProvisioning   EventSubscriptionStatus = "Provisioning"
	EventSubscriptionStatusUnknown        EventSubscriptionStatus = "Unknown"
)

// PossibleEventSubscriptionStatusValues returns the possible values for the EventSubscriptionStatus const type.
func PossibleEventSubscriptionStatusValues() []EventSubscriptionStatus {
	return []EventSubscriptionStatus{
		EventSubscriptionStatusDeprovisioning,
		EventSubscriptionStatusDisabled,
		EventSubscriptionStatusEnabled,
		EventSubscriptionStatusProvisioning,
		EventSubscriptionStatusUnknown,
	}
}

// ExpressionType - Expression type.
type ExpressionType string

const (
	ExpressionTypeExpression ExpressionType = "Expression"
)

// PossibleExpressionTypeValues returns the possible values for the ExpressionType const type.
func PossibleExpressionTypeValues() []ExpressionType {
	return []ExpressionType{
		ExpressionTypeExpression,
	}
}

// FactoryIdentityType - The identity type.
type FactoryIdentityType string

const (
	FactoryIdentityTypeSystemAssigned             FactoryIdentityType = "SystemAssigned"
	FactoryIdentityTypeSystemAssignedUserAssigned FactoryIdentityType = "SystemAssigned,UserAssigned"
	FactoryIdentityTypeUserAssigned               FactoryIdentityType = "UserAssigned"
)

// PossibleFactoryIdentityTypeValues returns the possible values for the FactoryIdentityType const type.
func PossibleFactoryIdentityTypeValues() []FactoryIdentityType {
	return []FactoryIdentityType{
		FactoryIdentityTypeSystemAssigned,
		FactoryIdentityTypeSystemAssignedUserAssigned,
		FactoryIdentityTypeUserAssigned,
	}
}

// FtpAuthenticationType - The authentication type to be used to connect to the FTP server.
type FtpAuthenticationType string

const (
	FtpAuthenticationTypeAnonymous FtpAuthenticationType = "Anonymous"
	FtpAuthenticationTypeBasic     FtpAuthenticationType = "Basic"
)

// PossibleFtpAuthenticationTypeValues returns the possible values for the FtpAuthenticationType const type.
func PossibleFtpAuthenticationTypeValues() []FtpAuthenticationType {
	return []FtpAuthenticationType{
		FtpAuthenticationTypeAnonymous,
		FtpAuthenticationTypeBasic,
	}
}

// GlobalParameterType - Global Parameter type.
type GlobalParameterType string

const (
	GlobalParameterTypeArray  GlobalParameterType = "Array"
	GlobalParameterTypeBool   GlobalParameterType = "Bool"
	GlobalParameterTypeFloat  GlobalParameterType = "Float"
	GlobalParameterTypeInt    GlobalParameterType = "Int"
	GlobalParameterTypeObject GlobalParameterType = "Object"
	GlobalParameterTypeString GlobalParameterType = "String"
)

// PossibleGlobalParameterTypeValues returns the possible values for the GlobalParameterType const type.
func PossibleGlobalParameterTypeValues() []GlobalParameterType {
	return []GlobalParameterType{
		GlobalParameterTypeArray,
		GlobalParameterTypeBool,
		GlobalParameterTypeFloat,
		GlobalParameterTypeInt,
		GlobalParameterTypeObject,
		GlobalParameterTypeString,
	}
}

// GoogleAdWordsAuthenticationType - The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication
// can only be used on self-hosted IR.
type GoogleAdWordsAuthenticationType string

const (
	GoogleAdWordsAuthenticationTypeServiceAuthentication GoogleAdWordsAuthenticationType = "ServiceAuthentication"
	GoogleAdWordsAuthenticationTypeUserAuthentication    GoogleAdWordsAuthenticationType = "UserAuthentication"
)

// PossibleGoogleAdWordsAuthenticationTypeValues returns the possible values for the GoogleAdWordsAuthenticationType const type.
func PossibleGoogleAdWordsAuthenticationTypeValues() []GoogleAdWordsAuthenticationType {
	return []GoogleAdWordsAuthenticationType{
		GoogleAdWordsAuthenticationTypeServiceAuthentication,
		GoogleAdWordsAuthenticationTypeUserAuthentication,
	}
}

// GoogleBigQueryAuthenticationType - The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication
// can only be used on self-hosted IR.
type GoogleBigQueryAuthenticationType string

const (
	GoogleBigQueryAuthenticationTypeServiceAuthentication GoogleBigQueryAuthenticationType = "ServiceAuthentication"
	GoogleBigQueryAuthenticationTypeUserAuthentication    GoogleBigQueryAuthenticationType = "UserAuthentication"
)

// PossibleGoogleBigQueryAuthenticationTypeValues returns the possible values for the GoogleBigQueryAuthenticationType const type.
func PossibleGoogleBigQueryAuthenticationTypeValues() []GoogleBigQueryAuthenticationType {
	return []GoogleBigQueryAuthenticationType{
		GoogleBigQueryAuthenticationTypeServiceAuthentication,
		GoogleBigQueryAuthenticationTypeUserAuthentication,
	}
}

// HBaseAuthenticationType - The authentication mechanism to use to connect to the HBase server.
type HBaseAuthenticationType string

const (
	HBaseAuthenticationTypeAnonymous HBaseAuthenticationType = "Anonymous"
	HBaseAuthenticationTypeBasic     HBaseAuthenticationType = "Basic"
)

// PossibleHBaseAuthenticationTypeValues returns the possible values for the HBaseAuthenticationType const type.
func PossibleHBaseAuthenticationTypeValues() []HBaseAuthenticationType {
	return []HBaseAuthenticationType{
		HBaseAuthenticationTypeAnonymous,
		HBaseAuthenticationTypeBasic,
	}
}

// HDInsightActivityDebugInfoOption - The HDInsightActivityDebugInfoOption settings to use.
type HDInsightActivityDebugInfoOption string

const (
	HDInsightActivityDebugInfoOptionAlways  HDInsightActivityDebugInfoOption = "Always"
	HDInsightActivityDebugInfoOptionFailure HDInsightActivityDebugInfoOption = "Failure"
	HDInsightActivityDebugInfoOptionNone    HDInsightActivityDebugInfoOption = "None"
)

// PossibleHDInsightActivityDebugInfoOptionValues returns the possible values for the HDInsightActivityDebugInfoOption const type.
func PossibleHDInsightActivityDebugInfoOptionValues() []HDInsightActivityDebugInfoOption {
	return []HDInsightActivityDebugInfoOption{
		HDInsightActivityDebugInfoOptionAlways,
		HDInsightActivityDebugInfoOptionFailure,
		HDInsightActivityDebugInfoOptionNone,
	}
}

// HTTPAuthenticationType - The authentication type to be used to connect to the HTTP server.
type HTTPAuthenticationType string

const (
	HTTPAuthenticationTypeAnonymous         HTTPAuthenticationType = "Anonymous"
	HTTPAuthenticationTypeBasic             HTTPAuthenticationType = "Basic"
	HTTPAuthenticationTypeClientCertificate HTTPAuthenticationType = "ClientCertificate"
	HTTPAuthenticationTypeDigest            HTTPAuthenticationType = "Digest"
	HTTPAuthenticationTypeWindows           HTTPAuthenticationType = "Windows"
)

// PossibleHTTPAuthenticationTypeValues returns the possible values for the HTTPAuthenticationType const type.
func PossibleHTTPAuthenticationTypeValues() []HTTPAuthenticationType {
	return []HTTPAuthenticationType{
		HTTPAuthenticationTypeAnonymous,
		HTTPAuthenticationTypeBasic,
		HTTPAuthenticationTypeClientCertificate,
		HTTPAuthenticationTypeDigest,
		HTTPAuthenticationTypeWindows,
	}
}

// HiveAuthenticationType - The authentication method used to access the Hive server.
type HiveAuthenticationType string

const (
	HiveAuthenticationTypeAnonymous                    HiveAuthenticationType = "Anonymous"
	HiveAuthenticationTypeUsername                     HiveAuthenticationType = "Username"
	HiveAuthenticationTypeUsernameAndPassword          HiveAuthenticationType = "UsernameAndPassword"
	HiveAuthenticationTypeWindowsAzureHDInsightService HiveAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleHiveAuthenticationTypeValues returns the possible values for the HiveAuthenticationType const type.
func PossibleHiveAuthenticationTypeValues() []HiveAuthenticationType {
	return []HiveAuthenticationType{
		HiveAuthenticationTypeAnonymous,
		HiveAuthenticationTypeUsername,
		HiveAuthenticationTypeUsernameAndPassword,
		HiveAuthenticationTypeWindowsAzureHDInsightService,
	}
}

// HiveServerType - The type of Hive server.
type HiveServerType string

const (
	HiveServerTypeHiveServer1      HiveServerType = "HiveServer1"
	HiveServerTypeHiveServer2      HiveServerType = "HiveServer2"
	HiveServerTypeHiveThriftServer HiveServerType = "HiveThriftServer"
)

// PossibleHiveServerTypeValues returns the possible values for the HiveServerType const type.
func PossibleHiveServerTypeValues() []HiveServerType {
	return []HiveServerType{
		HiveServerTypeHiveServer1,
		HiveServerTypeHiveServer2,
		HiveServerTypeHiveThriftServer,
	}
}

// HiveThriftTransportProtocol - The transport protocol to use in the Thrift layer.
type HiveThriftTransportProtocol string

const (
	HiveThriftTransportProtocolBinary HiveThriftTransportProtocol = "Binary"
	HiveThriftTransportProtocolHTTP   HiveThriftTransportProtocol = "HTTP "
	HiveThriftTransportProtocolSASL   HiveThriftTransportProtocol = "SASL"
)

// PossibleHiveThriftTransportProtocolValues returns the possible values for the HiveThriftTransportProtocol const type.
func PossibleHiveThriftTransportProtocolValues() []HiveThriftTransportProtocol {
	return []HiveThriftTransportProtocol{
		HiveThriftTransportProtocolBinary,
		HiveThriftTransportProtocolHTTP,
		HiveThriftTransportProtocolSASL,
	}
}

// ImpalaAuthenticationType - The authentication type to use.
type ImpalaAuthenticationType string

const (
	ImpalaAuthenticationTypeAnonymous           ImpalaAuthenticationType = "Anonymous"
	ImpalaAuthenticationTypeSASLUsername        ImpalaAuthenticationType = "SASLUsername"
	ImpalaAuthenticationTypeUsernameAndPassword ImpalaAuthenticationType = "UsernameAndPassword"
)

// PossibleImpalaAuthenticationTypeValues returns the possible values for the ImpalaAuthenticationType const type.
func PossibleImpalaAuthenticationTypeValues() []ImpalaAuthenticationType {
	return []ImpalaAuthenticationType{
		ImpalaAuthenticationTypeAnonymous,
		ImpalaAuthenticationTypeSASLUsername,
		ImpalaAuthenticationTypeUsernameAndPassword,
	}
}

// IntegrationRuntimeAuthKeyName - The name of the authentication key to regenerate.
type IntegrationRuntimeAuthKeyName string

const (
	IntegrationRuntimeAuthKeyNameAuthKey1 IntegrationRuntimeAuthKeyName = "authKey1"
	IntegrationRuntimeAuthKeyNameAuthKey2 IntegrationRuntimeAuthKeyName = "authKey2"
)

// PossibleIntegrationRuntimeAuthKeyNameValues returns the possible values for the IntegrationRuntimeAuthKeyName const type.
func PossibleIntegrationRuntimeAuthKeyNameValues() []IntegrationRuntimeAuthKeyName {
	return []IntegrationRuntimeAuthKeyName{
		IntegrationRuntimeAuthKeyNameAuthKey1,
		IntegrationRuntimeAuthKeyNameAuthKey2,
	}
}

// IntegrationRuntimeAutoUpdate - The state of integration runtime auto update.
type IntegrationRuntimeAutoUpdate string

const (
	IntegrationRuntimeAutoUpdateOff IntegrationRuntimeAutoUpdate = "Off"
	IntegrationRuntimeAutoUpdateOn  IntegrationRuntimeAutoUpdate = "On"
)

// PossibleIntegrationRuntimeAutoUpdateValues returns the possible values for the IntegrationRuntimeAutoUpdate const type.
func PossibleIntegrationRuntimeAutoUpdateValues() []IntegrationRuntimeAutoUpdate {
	return []IntegrationRuntimeAutoUpdate{
		IntegrationRuntimeAutoUpdateOff,
		IntegrationRuntimeAutoUpdateOn,
	}
}

// IntegrationRuntimeEdition - The edition for the SSIS Integration Runtime
type IntegrationRuntimeEdition string

const (
	IntegrationRuntimeEditionEnterprise IntegrationRuntimeEdition = "Enterprise"
	IntegrationRuntimeEditionStandard   IntegrationRuntimeEdition = "Standard"
)

// PossibleIntegrationRuntimeEditionValues returns the possible values for the IntegrationRuntimeEdition const type.
func PossibleIntegrationRuntimeEditionValues() []IntegrationRuntimeEdition {
	return []IntegrationRuntimeEdition{
		IntegrationRuntimeEditionEnterprise,
		IntegrationRuntimeEditionStandard,
	}
}

// IntegrationRuntimeEntityReferenceType - The type of this referenced entity.
type IntegrationRuntimeEntityReferenceType string

const (
	IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference IntegrationRuntimeEntityReferenceType = "IntegrationRuntimeReference"
	IntegrationRuntimeEntityReferenceTypeLinkedServiceReference      IntegrationRuntimeEntityReferenceType = "LinkedServiceReference"
)

// PossibleIntegrationRuntimeEntityReferenceTypeValues returns the possible values for the IntegrationRuntimeEntityReferenceType const type.
func PossibleIntegrationRuntimeEntityReferenceTypeValues() []IntegrationRuntimeEntityReferenceType {
	return []IntegrationRuntimeEntityReferenceType{
		IntegrationRuntimeEntityReferenceTypeIntegrationRuntimeReference,
		IntegrationRuntimeEntityReferenceTypeLinkedServiceReference,
	}
}

// IntegrationRuntimeInternalChannelEncryptionMode - It is used to set the encryption mode for node-node communication channel
// (when more than 2 self-hosted integration runtime nodes exist).
type IntegrationRuntimeInternalChannelEncryptionMode string

const (
	IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "NotEncrypted"
	IntegrationRuntimeInternalChannelEncryptionModeNotSet       IntegrationRuntimeInternalChannelEncryptionMode = "NotSet"
	IntegrationRuntimeInternalChannelEncryptionModeSSLEncrypted IntegrationRuntimeInternalChannelEncryptionMode = "SslEncrypted"
)

// PossibleIntegrationRuntimeInternalChannelEncryptionModeValues returns the possible values for the IntegrationRuntimeInternalChannelEncryptionMode const type.
func PossibleIntegrationRuntimeInternalChannelEncryptionModeValues() []IntegrationRuntimeInternalChannelEncryptionMode {
	return []IntegrationRuntimeInternalChannelEncryptionMode{
		IntegrationRuntimeInternalChannelEncryptionModeNotEncrypted,
		IntegrationRuntimeInternalChannelEncryptionModeNotSet,
		IntegrationRuntimeInternalChannelEncryptionModeSSLEncrypted,
	}
}

// IntegrationRuntimeLicenseType - License type for bringing your own license scenario.
type IntegrationRuntimeLicenseType string

const (
	IntegrationRuntimeLicenseTypeBasePrice       IntegrationRuntimeLicenseType = "BasePrice"
	IntegrationRuntimeLicenseTypeLicenseIncluded IntegrationRuntimeLicenseType = "LicenseIncluded"
)

// PossibleIntegrationRuntimeLicenseTypeValues returns the possible values for the IntegrationRuntimeLicenseType const type.
func PossibleIntegrationRuntimeLicenseTypeValues() []IntegrationRuntimeLicenseType {
	return []IntegrationRuntimeLicenseType{
		IntegrationRuntimeLicenseTypeBasePrice,
		IntegrationRuntimeLicenseTypeLicenseIncluded,
	}
}

// IntegrationRuntimeReferenceType - Type of integration runtime.
type IntegrationRuntimeReferenceType string

const (
	IntegrationRuntimeReferenceTypeIntegrationRuntimeReference IntegrationRuntimeReferenceType = "IntegrationRuntimeReference"
)

// PossibleIntegrationRuntimeReferenceTypeValues returns the possible values for the IntegrationRuntimeReferenceType const type.
func PossibleIntegrationRuntimeReferenceTypeValues() []IntegrationRuntimeReferenceType {
	return []IntegrationRuntimeReferenceType{
		IntegrationRuntimeReferenceTypeIntegrationRuntimeReference,
	}
}

// IntegrationRuntimeSsisCatalogPricingTier - The pricing tier for the catalog database. The valid values could be found in
// https://azure.microsoft.com/en-us/pricing/details/sql-database/
type IntegrationRuntimeSsisCatalogPricingTier string

const (
	IntegrationRuntimeSsisCatalogPricingTierBasic     IntegrationRuntimeSsisCatalogPricingTier = "Basic"
	IntegrationRuntimeSsisCatalogPricingTierPremium   IntegrationRuntimeSsisCatalogPricingTier = "Premium"
	IntegrationRuntimeSsisCatalogPricingTierPremiumRS IntegrationRuntimeSsisCatalogPricingTier = "PremiumRS"
	IntegrationRuntimeSsisCatalogPricingTierStandard  IntegrationRuntimeSsisCatalogPricingTier = "Standard"
)

// PossibleIntegrationRuntimeSsisCatalogPricingTierValues returns the possible values for the IntegrationRuntimeSsisCatalogPricingTier const type.
func PossibleIntegrationRuntimeSsisCatalogPricingTierValues() []IntegrationRuntimeSsisCatalogPricingTier {
	return []IntegrationRuntimeSsisCatalogPricingTier{
		IntegrationRuntimeSsisCatalogPricingTierBasic,
		IntegrationRuntimeSsisCatalogPricingTierPremium,
		IntegrationRuntimeSsisCatalogPricingTierPremiumRS,
		IntegrationRuntimeSsisCatalogPricingTierStandard,
	}
}

// IntegrationRuntimeState - The state of integration runtime.
type IntegrationRuntimeState string

const (
	IntegrationRuntimeStateAccessDenied     IntegrationRuntimeState = "AccessDenied"
	IntegrationRuntimeStateInitial          IntegrationRuntimeState = "Initial"
	IntegrationRuntimeStateLimited          IntegrationRuntimeState = "Limited"
	IntegrationRuntimeStateNeedRegistration IntegrationRuntimeState = "NeedRegistration"
	IntegrationRuntimeStateOffline          IntegrationRuntimeState = "Offline"
	IntegrationRuntimeStateOnline           IntegrationRuntimeState = "Online"
	IntegrationRuntimeStateStarted          IntegrationRuntimeState = "Started"
	IntegrationRuntimeStateStarting         IntegrationRuntimeState = "Starting"
	IntegrationRuntimeStateStopped          IntegrationRuntimeState = "Stopped"
	IntegrationRuntimeStateStopping         IntegrationRuntimeState = "Stopping"
)

// PossibleIntegrationRuntimeStateValues returns the possible values for the IntegrationRuntimeState const type.
func PossibleIntegrationRuntimeStateValues() []IntegrationRuntimeState {
	return []IntegrationRuntimeState{
		IntegrationRuntimeStateAccessDenied,
		IntegrationRuntimeStateInitial,
		IntegrationRuntimeStateLimited,
		IntegrationRuntimeStateNeedRegistration,
		IntegrationRuntimeStateOffline,
		IntegrationRuntimeStateOnline,
		IntegrationRuntimeStateStarted,
		IntegrationRuntimeStateStarting,
		IntegrationRuntimeStateStopped,
		IntegrationRuntimeStateStopping,
	}
}

// IntegrationRuntimeType - The type of integration runtime.
type IntegrationRuntimeType string

const (
	IntegrationRuntimeTypeManaged    IntegrationRuntimeType = "Managed"
	IntegrationRuntimeTypeSelfHosted IntegrationRuntimeType = "SelfHosted"
)

// PossibleIntegrationRuntimeTypeValues returns the possible values for the IntegrationRuntimeType const type.
func PossibleIntegrationRuntimeTypeValues() []IntegrationRuntimeType {
	return []IntegrationRuntimeType{
		IntegrationRuntimeTypeManaged,
		IntegrationRuntimeTypeSelfHosted,
	}
}

// IntegrationRuntimeUpdateResult - The result of the last integration runtime node update.
type IntegrationRuntimeUpdateResult string

const (
	IntegrationRuntimeUpdateResultFail    IntegrationRuntimeUpdateResult = "Fail"
	IntegrationRuntimeUpdateResultNone    IntegrationRuntimeUpdateResult = "None"
	IntegrationRuntimeUpdateResultSucceed IntegrationRuntimeUpdateResult = "Succeed"
)

// PossibleIntegrationRuntimeUpdateResultValues returns the possible values for the IntegrationRuntimeUpdateResult const type.
func PossibleIntegrationRuntimeUpdateResultValues() []IntegrationRuntimeUpdateResult {
	return []IntegrationRuntimeUpdateResult{
		IntegrationRuntimeUpdateResultFail,
		IntegrationRuntimeUpdateResultNone,
		IntegrationRuntimeUpdateResultSucceed,
	}
}

// LinkedServiceReferenceType - Linked service reference type.
type LinkedServiceReferenceType string

const (
	LinkedServiceReferenceTypeLinkedServiceReference LinkedServiceReferenceType = "LinkedServiceReference"
)

// PossibleLinkedServiceReferenceTypeValues returns the possible values for the LinkedServiceReferenceType const type.
func PossibleLinkedServiceReferenceTypeValues() []LinkedServiceReferenceType {
	return []LinkedServiceReferenceType{
		LinkedServiceReferenceTypeLinkedServiceReference,
	}
}

// ManagedIntegrationRuntimeNodeStatus - The managed integration runtime node status.
type ManagedIntegrationRuntimeNodeStatus string

const (
	ManagedIntegrationRuntimeNodeStatusAvailable   ManagedIntegrationRuntimeNodeStatus = "Available"
	ManagedIntegrationRuntimeNodeStatusRecycling   ManagedIntegrationRuntimeNodeStatus = "Recycling"
	ManagedIntegrationRuntimeNodeStatusStarting    ManagedIntegrationRuntimeNodeStatus = "Starting"
	ManagedIntegrationRuntimeNodeStatusUnavailable ManagedIntegrationRuntimeNodeStatus = "Unavailable"
)

// PossibleManagedIntegrationRuntimeNodeStatusValues returns the possible values for the ManagedIntegrationRuntimeNodeStatus const type.
func PossibleManagedIntegrationRuntimeNodeStatusValues() []ManagedIntegrationRuntimeNodeStatus {
	return []ManagedIntegrationRuntimeNodeStatus{
		ManagedIntegrationRuntimeNodeStatusAvailable,
		ManagedIntegrationRuntimeNodeStatusRecycling,
		ManagedIntegrationRuntimeNodeStatusStarting,
		ManagedIntegrationRuntimeNodeStatusUnavailable,
	}
}

// ManagedVirtualNetworkReferenceType - Managed Virtual Network reference type.
type ManagedVirtualNetworkReferenceType string

const (
	ManagedVirtualNetworkReferenceTypeManagedVirtualNetworkReference ManagedVirtualNetworkReferenceType = "ManagedVirtualNetworkReference"
)

// PossibleManagedVirtualNetworkReferenceTypeValues returns the possible values for the ManagedVirtualNetworkReferenceType const type.
func PossibleManagedVirtualNetworkReferenceTypeValues() []ManagedVirtualNetworkReferenceType {
	return []ManagedVirtualNetworkReferenceType{
		ManagedVirtualNetworkReferenceTypeManagedVirtualNetworkReference,
	}
}

// MongoDbAuthenticationType - The authentication type to be used to connect to the MongoDB database.
type MongoDbAuthenticationType string

const (
	MongoDbAuthenticationTypeAnonymous MongoDbAuthenticationType = "Anonymous"
	MongoDbAuthenticationTypeBasic     MongoDbAuthenticationType = "Basic"
)

// PossibleMongoDbAuthenticationTypeValues returns the possible values for the MongoDbAuthenticationType const type.
func PossibleMongoDbAuthenticationTypeValues() []MongoDbAuthenticationType {
	return []MongoDbAuthenticationType{
		MongoDbAuthenticationTypeAnonymous,
		MongoDbAuthenticationTypeBasic,
	}
}

// NotebookParameterType - Notebook parameter type.
type NotebookParameterType string

const (
	NotebookParameterTypeBool   NotebookParameterType = "bool"
	NotebookParameterTypeFloat  NotebookParameterType = "float"
	NotebookParameterTypeInt    NotebookParameterType = "int"
	NotebookParameterTypeString NotebookParameterType = "string"
)

// PossibleNotebookParameterTypeValues returns the possible values for the NotebookParameterType const type.
func PossibleNotebookParameterTypeValues() []NotebookParameterType {
	return []NotebookParameterType{
		NotebookParameterTypeBool,
		NotebookParameterTypeFloat,
		NotebookParameterTypeInt,
		NotebookParameterTypeString,
	}
}

// NotebookReferenceType - Synapse notebook reference type.
type NotebookReferenceType string

const (
	NotebookReferenceTypeNotebookReference NotebookReferenceType = "NotebookReference"
)

// PossibleNotebookReferenceTypeValues returns the possible values for the NotebookReferenceType const type.
func PossibleNotebookReferenceTypeValues() []NotebookReferenceType {
	return []NotebookReferenceType{
		NotebookReferenceTypeNotebookReference,
	}
}

// ODataAADServicePrincipalCredentialType - Specify the credential type (key or cert) is used for service principal.
type ODataAADServicePrincipalCredentialType string

const (
	ODataAADServicePrincipalCredentialTypeServicePrincipalCert ODataAADServicePrincipalCredentialType = "ServicePrincipalCert"
	ODataAADServicePrincipalCredentialTypeServicePrincipalKey  ODataAADServicePrincipalCredentialType = "ServicePrincipalKey"
)

// PossibleODataAADServicePrincipalCredentialTypeValues returns the possible values for the ODataAADServicePrincipalCredentialType const type.
func PossibleODataAADServicePrincipalCredentialTypeValues() []ODataAADServicePrincipalCredentialType {
	return []ODataAADServicePrincipalCredentialType{
		ODataAADServicePrincipalCredentialTypeServicePrincipalCert,
		ODataAADServicePrincipalCredentialTypeServicePrincipalKey,
	}
}

// ODataAuthenticationType - Type of authentication used to connect to the OData service.
type ODataAuthenticationType string

const (
	ODataAuthenticationTypeAADServicePrincipal    ODataAuthenticationType = "AadServicePrincipal"
	ODataAuthenticationTypeAnonymous              ODataAuthenticationType = "Anonymous"
	ODataAuthenticationTypeBasic                  ODataAuthenticationType = "Basic"
	ODataAuthenticationTypeManagedServiceIdentity ODataAuthenticationType = "ManagedServiceIdentity"
	ODataAuthenticationTypeWindows                ODataAuthenticationType = "Windows"
)

// PossibleODataAuthenticationTypeValues returns the possible values for the ODataAuthenticationType const type.
func PossibleODataAuthenticationTypeValues() []ODataAuthenticationType {
	return []ODataAuthenticationType{
		ODataAuthenticationTypeAADServicePrincipal,
		ODataAuthenticationTypeAnonymous,
		ODataAuthenticationTypeBasic,
		ODataAuthenticationTypeManagedServiceIdentity,
		ODataAuthenticationTypeWindows,
	}
}

// ParameterType - Parameter type.
type ParameterType string

const (
	ParameterTypeArray        ParameterType = "Array"
	ParameterTypeBool         ParameterType = "Bool"
	ParameterTypeFloat        ParameterType = "Float"
	ParameterTypeInt          ParameterType = "Int"
	ParameterTypeObject       ParameterType = "Object"
	ParameterTypeSecureString ParameterType = "SecureString"
	ParameterTypeString       ParameterType = "String"
)

// PossibleParameterTypeValues returns the possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{
		ParameterTypeArray,
		ParameterTypeBool,
		ParameterTypeFloat,
		ParameterTypeInt,
		ParameterTypeObject,
		ParameterTypeSecureString,
		ParameterTypeString,
	}
}

// PhoenixAuthenticationType - The authentication mechanism used to connect to the Phoenix server.
type PhoenixAuthenticationType string

const (
	PhoenixAuthenticationTypeAnonymous                    PhoenixAuthenticationType = "Anonymous"
	PhoenixAuthenticationTypeUsernameAndPassword          PhoenixAuthenticationType = "UsernameAndPassword"
	PhoenixAuthenticationTypeWindowsAzureHDInsightService PhoenixAuthenticationType = "WindowsAzureHDInsightService"
)

// PossiblePhoenixAuthenticationTypeValues returns the possible values for the PhoenixAuthenticationType const type.
func PossiblePhoenixAuthenticationTypeValues() []PhoenixAuthenticationType {
	return []PhoenixAuthenticationType{
		PhoenixAuthenticationTypeAnonymous,
		PhoenixAuthenticationTypeUsernameAndPassword,
		PhoenixAuthenticationTypeWindowsAzureHDInsightService,
	}
}

// PipelineReferenceType - Pipeline reference type.
type PipelineReferenceType string

const (
	PipelineReferenceTypePipelineReference PipelineReferenceType = "PipelineReference"
)

// PossiblePipelineReferenceTypeValues returns the possible values for the PipelineReferenceType const type.
func PossiblePipelineReferenceTypeValues() []PipelineReferenceType {
	return []PipelineReferenceType{
		PipelineReferenceTypePipelineReference,
	}
}

// PolybaseSettingsRejectType - Indicates whether the RejectValue property is specified as a literal value or a percentage.
type PolybaseSettingsRejectType string

const (
	PolybaseSettingsRejectTypePercentage PolybaseSettingsRejectType = "percentage"
	PolybaseSettingsRejectTypeValue      PolybaseSettingsRejectType = "value"
)

// PossiblePolybaseSettingsRejectTypeValues returns the possible values for the PolybaseSettingsRejectType const type.
func PossiblePolybaseSettingsRejectTypeValues() []PolybaseSettingsRejectType {
	return []PolybaseSettingsRejectType{
		PolybaseSettingsRejectTypePercentage,
		PolybaseSettingsRejectTypeValue,
	}
}

// PrestoAuthenticationType - The authentication mechanism used to connect to the Presto server.
type PrestoAuthenticationType string

const (
	PrestoAuthenticationTypeAnonymous PrestoAuthenticationType = "Anonymous"
	PrestoAuthenticationTypeLDAP      PrestoAuthenticationType = "LDAP"
)

// PossiblePrestoAuthenticationTypeValues returns the possible values for the PrestoAuthenticationType const type.
func PossiblePrestoAuthenticationTypeValues() []PrestoAuthenticationType {
	return []PrestoAuthenticationType{
		PrestoAuthenticationTypeAnonymous,
		PrestoAuthenticationTypeLDAP,
	}
}

// PublicNetworkAccess - Whether or not public network access is allowed for the data factory.
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled  PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// RecurrenceFrequency - Enumerates possible frequency option for the schedule trigger.
type RecurrenceFrequency string

const (
	RecurrenceFrequencyDay          RecurrenceFrequency = "Day"
	RecurrenceFrequencyHour         RecurrenceFrequency = "Hour"
	RecurrenceFrequencyMinute       RecurrenceFrequency = "Minute"
	RecurrenceFrequencyMonth        RecurrenceFrequency = "Month"
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	RecurrenceFrequencyWeek         RecurrenceFrequency = "Week"
	RecurrenceFrequencyYear         RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns the possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{
		RecurrenceFrequencyDay,
		RecurrenceFrequencyHour,
		RecurrenceFrequencyMinute,
		RecurrenceFrequencyMonth,
		RecurrenceFrequencyNotSpecified,
		RecurrenceFrequencyWeek,
		RecurrenceFrequencyYear,
	}
}

// RestServiceAuthenticationType - Type of authentication used to connect to the REST service.
type RestServiceAuthenticationType string

const (
	RestServiceAuthenticationTypeAADServicePrincipal    RestServiceAuthenticationType = "AadServicePrincipal"
	RestServiceAuthenticationTypeAnonymous              RestServiceAuthenticationType = "Anonymous"
	RestServiceAuthenticationTypeBasic                  RestServiceAuthenticationType = "Basic"
	RestServiceAuthenticationTypeManagedServiceIdentity RestServiceAuthenticationType = "ManagedServiceIdentity"
	RestServiceAuthenticationTypeOAuth2ClientCredential RestServiceAuthenticationType = "OAuth2ClientCredential"
)

// PossibleRestServiceAuthenticationTypeValues returns the possible values for the RestServiceAuthenticationType const type.
func PossibleRestServiceAuthenticationTypeValues() []RestServiceAuthenticationType {
	return []RestServiceAuthenticationType{
		RestServiceAuthenticationTypeAADServicePrincipal,
		RestServiceAuthenticationTypeAnonymous,
		RestServiceAuthenticationTypeBasic,
		RestServiceAuthenticationTypeManagedServiceIdentity,
		RestServiceAuthenticationTypeOAuth2ClientCredential,
	}
}

// RunQueryFilterOperand - Parameter name to be used for filter. The allowed operands to query pipeline runs are PipelineName,
// RunStart, RunEnd and Status; to query activity runs are ActivityName, ActivityRunStart,
// ActivityRunEnd, ActivityType and Status, and to query trigger runs are TriggerName, TriggerRunTimestamp and Status.
type RunQueryFilterOperand string

const (
	RunQueryFilterOperandActivityName        RunQueryFilterOperand = "ActivityName"
	RunQueryFilterOperandActivityRunEnd      RunQueryFilterOperand = "ActivityRunEnd"
	RunQueryFilterOperandActivityRunStart    RunQueryFilterOperand = "ActivityRunStart"
	RunQueryFilterOperandActivityType        RunQueryFilterOperand = "ActivityType"
	RunQueryFilterOperandLatestOnly          RunQueryFilterOperand = "LatestOnly"
	RunQueryFilterOperandPipelineName        RunQueryFilterOperand = "PipelineName"
	RunQueryFilterOperandRunEnd              RunQueryFilterOperand = "RunEnd"
	RunQueryFilterOperandRunGroupID          RunQueryFilterOperand = "RunGroupId"
	RunQueryFilterOperandRunStart            RunQueryFilterOperand = "RunStart"
	RunQueryFilterOperandStatus              RunQueryFilterOperand = "Status"
	RunQueryFilterOperandTriggerName         RunQueryFilterOperand = "TriggerName"
	RunQueryFilterOperandTriggerRunTimestamp RunQueryFilterOperand = "TriggerRunTimestamp"
)

// PossibleRunQueryFilterOperandValues returns the possible values for the RunQueryFilterOperand const type.
func PossibleRunQueryFilterOperandValues() []RunQueryFilterOperand {
	return []RunQueryFilterOperand{
		RunQueryFilterOperandActivityName,
		RunQueryFilterOperandActivityRunEnd,
		RunQueryFilterOperandActivityRunStart,
		RunQueryFilterOperandActivityType,
		RunQueryFilterOperandLatestOnly,
		RunQueryFilterOperandPipelineName,
		RunQueryFilterOperandRunEnd,
		RunQueryFilterOperandRunGroupID,
		RunQueryFilterOperandRunStart,
		RunQueryFilterOperandStatus,
		RunQueryFilterOperandTriggerName,
		RunQueryFilterOperandTriggerRunTimestamp,
	}
}

// RunQueryFilterOperator - Operator to be used for filter.
type RunQueryFilterOperator string

const (
	RunQueryFilterOperatorEquals    RunQueryFilterOperator = "Equals"
	RunQueryFilterOperatorIn        RunQueryFilterOperator = "In"
	RunQueryFilterOperatorNotEquals RunQueryFilterOperator = "NotEquals"
	RunQueryFilterOperatorNotIn     RunQueryFilterOperator = "NotIn"
)

// PossibleRunQueryFilterOperatorValues returns the possible values for the RunQueryFilterOperator const type.
func PossibleRunQueryFilterOperatorValues() []RunQueryFilterOperator {
	return []RunQueryFilterOperator{
		RunQueryFilterOperatorEquals,
		RunQueryFilterOperatorIn,
		RunQueryFilterOperatorNotEquals,
		RunQueryFilterOperatorNotIn,
	}
}

// RunQueryOrder - Sorting order of the parameter.
type RunQueryOrder string

const (
	RunQueryOrderASC  RunQueryOrder = "ASC"
	RunQueryOrderDESC RunQueryOrder = "DESC"
)

// PossibleRunQueryOrderValues returns the possible values for the RunQueryOrder const type.
func PossibleRunQueryOrderValues() []RunQueryOrder {
	return []RunQueryOrder{
		RunQueryOrderASC,
		RunQueryOrderDESC,
	}
}

// RunQueryOrderByField - Parameter name to be used for order by. The allowed parameters to order by for pipeline runs are
// PipelineName, RunStart, RunEnd and Status; for activity runs are ActivityName, ActivityRunStart,
// ActivityRunEnd and Status; for trigger runs are TriggerName, TriggerRunTimestamp and Status.
type RunQueryOrderByField string

const (
	RunQueryOrderByFieldActivityName        RunQueryOrderByField = "ActivityName"
	RunQueryOrderByFieldActivityRunEnd      RunQueryOrderByField = "ActivityRunEnd"
	RunQueryOrderByFieldActivityRunStart    RunQueryOrderByField = "ActivityRunStart"
	RunQueryOrderByFieldPipelineName        RunQueryOrderByField = "PipelineName"
	RunQueryOrderByFieldRunEnd              RunQueryOrderByField = "RunEnd"
	RunQueryOrderByFieldRunStart            RunQueryOrderByField = "RunStart"
	RunQueryOrderByFieldStatus              RunQueryOrderByField = "Status"
	RunQueryOrderByFieldTriggerName         RunQueryOrderByField = "TriggerName"
	RunQueryOrderByFieldTriggerRunTimestamp RunQueryOrderByField = "TriggerRunTimestamp"
)

// PossibleRunQueryOrderByFieldValues returns the possible values for the RunQueryOrderByField const type.
func PossibleRunQueryOrderByFieldValues() []RunQueryOrderByField {
	return []RunQueryOrderByField{
		RunQueryOrderByFieldActivityName,
		RunQueryOrderByFieldActivityRunEnd,
		RunQueryOrderByFieldActivityRunStart,
		RunQueryOrderByFieldPipelineName,
		RunQueryOrderByFieldRunEnd,
		RunQueryOrderByFieldRunStart,
		RunQueryOrderByFieldStatus,
		RunQueryOrderByFieldTriggerName,
		RunQueryOrderByFieldTriggerRunTimestamp,
	}
}

// SQLAlwaysEncryptedAkvAuthType - Sql always encrypted AKV authentication type. Type: string (or Expression with resultType
// string).
type SQLAlwaysEncryptedAkvAuthType string

const (
	SQLAlwaysEncryptedAkvAuthTypeManagedIdentity             SQLAlwaysEncryptedAkvAuthType = "ManagedIdentity"
	SQLAlwaysEncryptedAkvAuthTypeServicePrincipal            SQLAlwaysEncryptedAkvAuthType = "ServicePrincipal"
	SQLAlwaysEncryptedAkvAuthTypeUserAssignedManagedIdentity SQLAlwaysEncryptedAkvAuthType = "UserAssignedManagedIdentity"
)

// PossibleSQLAlwaysEncryptedAkvAuthTypeValues returns the possible values for the SQLAlwaysEncryptedAkvAuthType const type.
func PossibleSQLAlwaysEncryptedAkvAuthTypeValues() []SQLAlwaysEncryptedAkvAuthType {
	return []SQLAlwaysEncryptedAkvAuthType{
		SQLAlwaysEncryptedAkvAuthTypeManagedIdentity,
		SQLAlwaysEncryptedAkvAuthTypeServicePrincipal,
		SQLAlwaysEncryptedAkvAuthTypeUserAssignedManagedIdentity,
	}
}

// SalesforceSinkWriteBehavior - The write behavior for the operation. Default is Insert.
type SalesforceSinkWriteBehavior string

const (
	SalesforceSinkWriteBehaviorInsert SalesforceSinkWriteBehavior = "Insert"
	SalesforceSinkWriteBehaviorUpsert SalesforceSinkWriteBehavior = "Upsert"
)

// PossibleSalesforceSinkWriteBehaviorValues returns the possible values for the SalesforceSinkWriteBehavior const type.
func PossibleSalesforceSinkWriteBehaviorValues() []SalesforceSinkWriteBehavior {
	return []SalesforceSinkWriteBehavior{
		SalesforceSinkWriteBehaviorInsert,
		SalesforceSinkWriteBehaviorUpsert,
	}
}

// SalesforceSourceReadBehavior - The read behavior for the operation. Default is Query.
type SalesforceSourceReadBehavior string

const (
	SalesforceSourceReadBehaviorQuery    SalesforceSourceReadBehavior = "Query"
	SalesforceSourceReadBehaviorQueryAll SalesforceSourceReadBehavior = "QueryAll"
)

// PossibleSalesforceSourceReadBehaviorValues returns the possible values for the SalesforceSourceReadBehavior const type.
func PossibleSalesforceSourceReadBehaviorValues() []SalesforceSourceReadBehavior {
	return []SalesforceSourceReadBehavior{
		SalesforceSourceReadBehaviorQuery,
		SalesforceSourceReadBehaviorQueryAll,
	}
}

// SapCloudForCustomerSinkWriteBehavior - The write behavior for the operation. Default is 'Insert'.
type SapCloudForCustomerSinkWriteBehavior string

const (
	SapCloudForCustomerSinkWriteBehaviorInsert SapCloudForCustomerSinkWriteBehavior = "Insert"
	SapCloudForCustomerSinkWriteBehaviorUpdate SapCloudForCustomerSinkWriteBehavior = "Update"
)

// PossibleSapCloudForCustomerSinkWriteBehaviorValues returns the possible values for the SapCloudForCustomerSinkWriteBehavior const type.
func PossibleSapCloudForCustomerSinkWriteBehaviorValues() []SapCloudForCustomerSinkWriteBehavior {
	return []SapCloudForCustomerSinkWriteBehavior{
		SapCloudForCustomerSinkWriteBehaviorInsert,
		SapCloudForCustomerSinkWriteBehaviorUpdate,
	}
}

// SapHanaAuthenticationType - The authentication type to be used to connect to the SAP HANA server.
type SapHanaAuthenticationType string

const (
	SapHanaAuthenticationTypeBasic   SapHanaAuthenticationType = "Basic"
	SapHanaAuthenticationTypeWindows SapHanaAuthenticationType = "Windows"
)

// PossibleSapHanaAuthenticationTypeValues returns the possible values for the SapHanaAuthenticationType const type.
func PossibleSapHanaAuthenticationTypeValues() []SapHanaAuthenticationType {
	return []SapHanaAuthenticationType{
		SapHanaAuthenticationTypeBasic,
		SapHanaAuthenticationTypeWindows,
	}
}

// ScriptActivityLogDestination - The destination of logs. Type: string.
type ScriptActivityLogDestination string

const (
	ScriptActivityLogDestinationActivityOutput ScriptActivityLogDestination = "ActivityOutput"
	ScriptActivityLogDestinationExternalStore  ScriptActivityLogDestination = "ExternalStore"
)

// PossibleScriptActivityLogDestinationValues returns the possible values for the ScriptActivityLogDestination const type.
func PossibleScriptActivityLogDestinationValues() []ScriptActivityLogDestination {
	return []ScriptActivityLogDestination{
		ScriptActivityLogDestinationActivityOutput,
		ScriptActivityLogDestinationExternalStore,
	}
}

// ScriptActivityParameterDirection - The direction of the parameter.
type ScriptActivityParameterDirection string

const (
	ScriptActivityParameterDirectionInput       ScriptActivityParameterDirection = "Input"
	ScriptActivityParameterDirectionInputOutput ScriptActivityParameterDirection = "InputOutput"
	ScriptActivityParameterDirectionOutput      ScriptActivityParameterDirection = "Output"
)

// PossibleScriptActivityParameterDirectionValues returns the possible values for the ScriptActivityParameterDirection const type.
func PossibleScriptActivityParameterDirectionValues() []ScriptActivityParameterDirection {
	return []ScriptActivityParameterDirection{
		ScriptActivityParameterDirectionInput,
		ScriptActivityParameterDirectionInputOutput,
		ScriptActivityParameterDirectionOutput,
	}
}

// ScriptActivityParameterType - The type of the parameter.
type ScriptActivityParameterType string

const (
	ScriptActivityParameterTypeBoolean        ScriptActivityParameterType = "Boolean"
	ScriptActivityParameterTypeDateTime       ScriptActivityParameterType = "DateTime"
	ScriptActivityParameterTypeDateTimeOffset ScriptActivityParameterType = "DateTimeOffset"
	ScriptActivityParameterTypeDecimal        ScriptActivityParameterType = "Decimal"
	ScriptActivityParameterTypeDouble         ScriptActivityParameterType = "Double"
	ScriptActivityParameterTypeGUID           ScriptActivityParameterType = "Guid"
	ScriptActivityParameterTypeInt16          ScriptActivityParameterType = "Int16"
	ScriptActivityParameterTypeInt32          ScriptActivityParameterType = "Int32"
	ScriptActivityParameterTypeInt64          ScriptActivityParameterType = "Int64"
	ScriptActivityParameterTypeSingle         ScriptActivityParameterType = "Single"
	ScriptActivityParameterTypeString         ScriptActivityParameterType = "String"
	ScriptActivityParameterTypeTimespan       ScriptActivityParameterType = "Timespan"
)

// PossibleScriptActivityParameterTypeValues returns the possible values for the ScriptActivityParameterType const type.
func PossibleScriptActivityParameterTypeValues() []ScriptActivityParameterType {
	return []ScriptActivityParameterType{
		ScriptActivityParameterTypeBoolean,
		ScriptActivityParameterTypeDateTime,
		ScriptActivityParameterTypeDateTimeOffset,
		ScriptActivityParameterTypeDecimal,
		ScriptActivityParameterTypeDouble,
		ScriptActivityParameterTypeGUID,
		ScriptActivityParameterTypeInt16,
		ScriptActivityParameterTypeInt32,
		ScriptActivityParameterTypeInt64,
		ScriptActivityParameterTypeSingle,
		ScriptActivityParameterTypeString,
		ScriptActivityParameterTypeTimespan,
	}
}

// ScriptType - The type of the query. Type: string.
type ScriptType string

const (
	ScriptTypeNonQuery ScriptType = "NonQuery"
	ScriptTypeQuery    ScriptType = "Query"
)

// PossibleScriptTypeValues returns the possible values for the ScriptType const type.
func PossibleScriptTypeValues() []ScriptType {
	return []ScriptType{
		ScriptTypeNonQuery,
		ScriptTypeQuery,
	}
}

// SelfHostedIntegrationRuntimeNodeStatus - Status of the integration runtime node.
type SelfHostedIntegrationRuntimeNodeStatus string

const (
	SelfHostedIntegrationRuntimeNodeStatusInitializeFailed SelfHostedIntegrationRuntimeNodeStatus = "InitializeFailed"
	SelfHostedIntegrationRuntimeNodeStatusInitializing     SelfHostedIntegrationRuntimeNodeStatus = "Initializing"
	SelfHostedIntegrationRuntimeNodeStatusLimited          SelfHostedIntegrationRuntimeNodeStatus = "Limited"
	SelfHostedIntegrationRuntimeNodeStatusNeedRegistration SelfHostedIntegrationRuntimeNodeStatus = "NeedRegistration"
	SelfHostedIntegrationRuntimeNodeStatusOffline          SelfHostedIntegrationRuntimeNodeStatus = "Offline"
	SelfHostedIntegrationRuntimeNodeStatusOnline           SelfHostedIntegrationRuntimeNodeStatus = "Online"
	SelfHostedIntegrationRuntimeNodeStatusUpgrading        SelfHostedIntegrationRuntimeNodeStatus = "Upgrading"
)

// PossibleSelfHostedIntegrationRuntimeNodeStatusValues returns the possible values for the SelfHostedIntegrationRuntimeNodeStatus const type.
func PossibleSelfHostedIntegrationRuntimeNodeStatusValues() []SelfHostedIntegrationRuntimeNodeStatus {
	return []SelfHostedIntegrationRuntimeNodeStatus{
		SelfHostedIntegrationRuntimeNodeStatusInitializeFailed,
		SelfHostedIntegrationRuntimeNodeStatusInitializing,
		SelfHostedIntegrationRuntimeNodeStatusLimited,
		SelfHostedIntegrationRuntimeNodeStatusNeedRegistration,
		SelfHostedIntegrationRuntimeNodeStatusOffline,
		SelfHostedIntegrationRuntimeNodeStatusOnline,
		SelfHostedIntegrationRuntimeNodeStatusUpgrading,
	}
}

// ServiceNowAuthenticationType - The authentication type to use.
type ServiceNowAuthenticationType string

const (
	ServiceNowAuthenticationTypeBasic  ServiceNowAuthenticationType = "Basic"
	ServiceNowAuthenticationTypeOAuth2 ServiceNowAuthenticationType = "OAuth2"
)

// PossibleServiceNowAuthenticationTypeValues returns the possible values for the ServiceNowAuthenticationType const type.
func PossibleServiceNowAuthenticationTypeValues() []ServiceNowAuthenticationType {
	return []ServiceNowAuthenticationType{
		ServiceNowAuthenticationTypeBasic,
		ServiceNowAuthenticationTypeOAuth2,
	}
}

// SftpAuthenticationType - The authentication type to be used to connect to the FTP server.
type SftpAuthenticationType string

const (
	SftpAuthenticationTypeBasic        SftpAuthenticationType = "Basic"
	SftpAuthenticationTypeMultiFactor  SftpAuthenticationType = "MultiFactor"
	SftpAuthenticationTypeSSHPublicKey SftpAuthenticationType = "SshPublicKey"
)

// PossibleSftpAuthenticationTypeValues returns the possible values for the SftpAuthenticationType const type.
func PossibleSftpAuthenticationTypeValues() []SftpAuthenticationType {
	return []SftpAuthenticationType{
		SftpAuthenticationTypeBasic,
		SftpAuthenticationTypeMultiFactor,
		SftpAuthenticationTypeSSHPublicKey,
	}
}

// SparkAuthenticationType - The authentication method used to access the Spark server.
type SparkAuthenticationType string

const (
	SparkAuthenticationTypeAnonymous                    SparkAuthenticationType = "Anonymous"
	SparkAuthenticationTypeUsername                     SparkAuthenticationType = "Username"
	SparkAuthenticationTypeUsernameAndPassword          SparkAuthenticationType = "UsernameAndPassword"
	SparkAuthenticationTypeWindowsAzureHDInsightService SparkAuthenticationType = "WindowsAzureHDInsightService"
)

// PossibleSparkAuthenticationTypeValues returns the possible values for the SparkAuthenticationType const type.
func PossibleSparkAuthenticationTypeValues() []SparkAuthenticationType {
	return []SparkAuthenticationType{
		SparkAuthenticationTypeAnonymous,
		SparkAuthenticationTypeUsername,
		SparkAuthenticationTypeUsernameAndPassword,
		SparkAuthenticationTypeWindowsAzureHDInsightService,
	}
}

// SparkJobReferenceType - Synapse spark job reference type.
type SparkJobReferenceType string

const (
	SparkJobReferenceTypeSparkJobDefinitionReference SparkJobReferenceType = "SparkJobDefinitionReference"
)

// PossibleSparkJobReferenceTypeValues returns the possible values for the SparkJobReferenceType const type.
func PossibleSparkJobReferenceTypeValues() []SparkJobReferenceType {
	return []SparkJobReferenceType{
		SparkJobReferenceTypeSparkJobDefinitionReference,
	}
}

// SparkServerType - The type of Spark server.
type SparkServerType string

const (
	SparkServerTypeSharkServer       SparkServerType = "SharkServer"
	SparkServerTypeSharkServer2      SparkServerType = "SharkServer2"
	SparkServerTypeSparkThriftServer SparkServerType = "SparkThriftServer"
)

// PossibleSparkServerTypeValues returns the possible values for the SparkServerType const type.
func PossibleSparkServerTypeValues() []SparkServerType {
	return []SparkServerType{
		SparkServerTypeSharkServer,
		SparkServerTypeSharkServer2,
		SparkServerTypeSparkThriftServer,
	}
}

// SparkThriftTransportProtocol - The transport protocol to use in the Thrift layer.
type SparkThriftTransportProtocol string

const (
	SparkThriftTransportProtocolBinary SparkThriftTransportProtocol = "Binary"
	SparkThriftTransportProtocolHTTP   SparkThriftTransportProtocol = "HTTP "
	SparkThriftTransportProtocolSASL   SparkThriftTransportProtocol = "SASL"
)

// PossibleSparkThriftTransportProtocolValues returns the possible values for the SparkThriftTransportProtocol const type.
func PossibleSparkThriftTransportProtocolValues() []SparkThriftTransportProtocol {
	return []SparkThriftTransportProtocol{
		SparkThriftTransportProtocolBinary,
		SparkThriftTransportProtocolHTTP,
		SparkThriftTransportProtocolSASL,
	}
}

// SsisLogLocationType - The type of SSIS log location.
type SsisLogLocationType string

const (
	SsisLogLocationTypeFile SsisLogLocationType = "File"
)

// PossibleSsisLogLocationTypeValues returns the possible values for the SsisLogLocationType const type.
func PossibleSsisLogLocationTypeValues() []SsisLogLocationType {
	return []SsisLogLocationType{
		SsisLogLocationTypeFile,
	}
}

// SsisObjectMetadataType - The type of SSIS object metadata.
type SsisObjectMetadataType string

const (
	SsisObjectMetadataTypeEnvironment SsisObjectMetadataType = "Environment"
	SsisObjectMetadataTypeFolder      SsisObjectMetadataType = "Folder"
	SsisObjectMetadataTypePackage     SsisObjectMetadataType = "Package"
	SsisObjectMetadataTypeProject     SsisObjectMetadataType = "Project"
)

// PossibleSsisObjectMetadataTypeValues returns the possible values for the SsisObjectMetadataType const type.
func PossibleSsisObjectMetadataTypeValues() []SsisObjectMetadataType {
	return []SsisObjectMetadataType{
		SsisObjectMetadataTypeEnvironment,
		SsisObjectMetadataTypeFolder,
		SsisObjectMetadataTypePackage,
		SsisObjectMetadataTypeProject,
	}
}

// SsisPackageLocationType - The type of SSIS package location.
type SsisPackageLocationType string

const (
	SsisPackageLocationTypeFile          SsisPackageLocationType = "File"
	SsisPackageLocationTypeInlinePackage SsisPackageLocationType = "InlinePackage"
	SsisPackageLocationTypePackageStore  SsisPackageLocationType = "PackageStore"
	SsisPackageLocationTypeSSISDB        SsisPackageLocationType = "SSISDB"
)

// PossibleSsisPackageLocationTypeValues returns the possible values for the SsisPackageLocationType const type.
func PossibleSsisPackageLocationTypeValues() []SsisPackageLocationType {
	return []SsisPackageLocationType{
		SsisPackageLocationTypeFile,
		SsisPackageLocationTypeInlinePackage,
		SsisPackageLocationTypePackageStore,
		SsisPackageLocationTypeSSISDB,
	}
}

// SybaseAuthenticationType - AuthenticationType to be used for connection.
type SybaseAuthenticationType string

const (
	SybaseAuthenticationTypeBasic   SybaseAuthenticationType = "Basic"
	SybaseAuthenticationTypeWindows SybaseAuthenticationType = "Windows"
)

// PossibleSybaseAuthenticationTypeValues returns the possible values for the SybaseAuthenticationType const type.
func PossibleSybaseAuthenticationTypeValues() []SybaseAuthenticationType {
	return []SybaseAuthenticationType{
		SybaseAuthenticationTypeBasic,
		SybaseAuthenticationTypeWindows,
	}
}

// TeamDeskAuthenticationType - The authentication type to use.
type TeamDeskAuthenticationType string

const (
	TeamDeskAuthenticationTypeBasic TeamDeskAuthenticationType = "Basic"
	TeamDeskAuthenticationTypeToken TeamDeskAuthenticationType = "Token"
)

// PossibleTeamDeskAuthenticationTypeValues returns the possible values for the TeamDeskAuthenticationType const type.
func PossibleTeamDeskAuthenticationTypeValues() []TeamDeskAuthenticationType {
	return []TeamDeskAuthenticationType{
		TeamDeskAuthenticationTypeBasic,
		TeamDeskAuthenticationTypeToken,
	}
}

// TeradataAuthenticationType - AuthenticationType to be used for connection.
type TeradataAuthenticationType string

const (
	TeradataAuthenticationTypeBasic   TeradataAuthenticationType = "Basic"
	TeradataAuthenticationTypeWindows TeradataAuthenticationType = "Windows"
)

// PossibleTeradataAuthenticationTypeValues returns the possible values for the TeradataAuthenticationType const type.
func PossibleTeradataAuthenticationTypeValues() []TeradataAuthenticationType {
	return []TeradataAuthenticationType{
		TeradataAuthenticationTypeBasic,
		TeradataAuthenticationTypeWindows,
	}
}

// TriggerReferenceType - Trigger reference type.
type TriggerReferenceType string

const (
	TriggerReferenceTypeTriggerReference TriggerReferenceType = "TriggerReference"
)

// PossibleTriggerReferenceTypeValues returns the possible values for the TriggerReferenceType const type.
func PossibleTriggerReferenceTypeValues() []TriggerReferenceType {
	return []TriggerReferenceType{
		TriggerReferenceTypeTriggerReference,
	}
}

// TriggerRunStatus - Trigger run status.
type TriggerRunStatus string

const (
	TriggerRunStatusFailed     TriggerRunStatus = "Failed"
	TriggerRunStatusInprogress TriggerRunStatus = "Inprogress"
	TriggerRunStatusSucceeded  TriggerRunStatus = "Succeeded"
)

// PossibleTriggerRunStatusValues returns the possible values for the TriggerRunStatus const type.
func PossibleTriggerRunStatusValues() []TriggerRunStatus {
	return []TriggerRunStatus{
		TriggerRunStatusFailed,
		TriggerRunStatusInprogress,
		TriggerRunStatusSucceeded,
	}
}

// TriggerRuntimeState - Enumerates possible state of Triggers.
type TriggerRuntimeState string

const (
	TriggerRuntimeStateDisabled TriggerRuntimeState = "Disabled"
	TriggerRuntimeStateStarted  TriggerRuntimeState = "Started"
	TriggerRuntimeStateStopped  TriggerRuntimeState = "Stopped"
)

// PossibleTriggerRuntimeStateValues returns the possible values for the TriggerRuntimeState const type.
func PossibleTriggerRuntimeStateValues() []TriggerRuntimeState {
	return []TriggerRuntimeState{
		TriggerRuntimeStateDisabled,
		TriggerRuntimeStateStarted,
		TriggerRuntimeStateStopped,
	}
}

// TumblingWindowFrequency - Enumerates possible frequency option for the tumbling window trigger.
type TumblingWindowFrequency string

const (
	TumblingWindowFrequencyHour   TumblingWindowFrequency = "Hour"
	TumblingWindowFrequencyMinute TumblingWindowFrequency = "Minute"
	TumblingWindowFrequencyMonth  TumblingWindowFrequency = "Month"
)

// PossibleTumblingWindowFrequencyValues returns the possible values for the TumblingWindowFrequency const type.
func PossibleTumblingWindowFrequencyValues() []TumblingWindowFrequency {
	return []TumblingWindowFrequency{
		TumblingWindowFrequencyHour,
		TumblingWindowFrequencyMinute,
		TumblingWindowFrequencyMonth,
	}
}

// VariableType - Variable type.
type VariableType string

const (
	VariableTypeArray  VariableType = "Array"
	VariableTypeBool   VariableType = "Bool"
	VariableTypeString VariableType = "String"
)

// PossibleVariableTypeValues returns the possible values for the VariableType const type.
func PossibleVariableTypeValues() []VariableType {
	return []VariableType{
		VariableTypeArray,
		VariableTypeBool,
		VariableTypeString,
	}
}

// WebActivityMethod - The list of HTTP methods supported by a WebActivity.
type WebActivityMethod string

const (
	WebActivityMethodDELETE WebActivityMethod = "DELETE"
	WebActivityMethodGET    WebActivityMethod = "GET"
	WebActivityMethodPOST   WebActivityMethod = "POST"
	WebActivityMethodPUT    WebActivityMethod = "PUT"
)

// PossibleWebActivityMethodValues returns the possible values for the WebActivityMethod const type.
func PossibleWebActivityMethodValues() []WebActivityMethod {
	return []WebActivityMethod{
		WebActivityMethodDELETE,
		WebActivityMethodGET,
		WebActivityMethodPOST,
		WebActivityMethodPUT,
	}
}

// WebAuthenticationType - Type of authentication used to connect to the web table source.
type WebAuthenticationType string

const (
	WebAuthenticationTypeAnonymous         WebAuthenticationType = "Anonymous"
	WebAuthenticationTypeBasic             WebAuthenticationType = "Basic"
	WebAuthenticationTypeClientCertificate WebAuthenticationType = "ClientCertificate"
)

// PossibleWebAuthenticationTypeValues returns the possible values for the WebAuthenticationType const type.
func PossibleWebAuthenticationTypeValues() []WebAuthenticationType {
	return []WebAuthenticationType{
		WebAuthenticationTypeAnonymous,
		WebAuthenticationTypeBasic,
		WebAuthenticationTypeClientCertificate,
	}
}

// WebHookActivityMethod - The list of HTTP methods supported by a WebHook activity.
type WebHookActivityMethod string

const (
	WebHookActivityMethodPOST WebHookActivityMethod = "POST"
)

// PossibleWebHookActivityMethodValues returns the possible values for the WebHookActivityMethod const type.
func PossibleWebHookActivityMethodValues() []WebHookActivityMethod {
	return []WebHookActivityMethod{
		WebHookActivityMethodPOST,
	}
}

// ZendeskAuthenticationType - The authentication type to use.
type ZendeskAuthenticationType string

const (
	ZendeskAuthenticationTypeBasic ZendeskAuthenticationType = "Basic"
	ZendeskAuthenticationTypeToken ZendeskAuthenticationType = "Token"
)

// PossibleZendeskAuthenticationTypeValues returns the possible values for the ZendeskAuthenticationType const type.
func PossibleZendeskAuthenticationTypeValues() []ZendeskAuthenticationType {
	return []ZendeskAuthenticationType{
		ZendeskAuthenticationTypeBasic,
		ZendeskAuthenticationTypeToken,
	}
}
