//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourcehealth

import (
	"encoding/json"
	"fmt"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityStatusProperties.
func (a *AvailabilityStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &a.AvailabilityState)
			delete(rawMsg, key)
		case "detailedStatus":
			err = unpopulate(val, "DetailedStatus", &a.DetailedStatus)
			delete(rawMsg, key)
		case "healthEventCategory":
			err = unpopulate(val, "HealthEventCategory", &a.HealthEventCategory)
			delete(rawMsg, key)
		case "healthEventCause":
			err = unpopulate(val, "HealthEventCause", &a.HealthEventCause)
			delete(rawMsg, key)
		case "healthEventId":
			err = unpopulate(val, "HealthEventID", &a.HealthEventID)
			delete(rawMsg, key)
		case "healthEventType":
			err = unpopulate(val, "HealthEventType", &a.HealthEventType)
			delete(rawMsg, key)
		case "occurredTime":
			err = unpopulateTimeRFC3339(val, "OccurredTime", &a.OccurredTime)
			delete(rawMsg, key)
		case "reasonChronicity":
			err = unpopulate(val, "ReasonChronicity", &a.ReasonChronicity)
			delete(rawMsg, key)
		case "reasonType":
			err = unpopulate(val, "ReasonType", &a.ReasonType)
			delete(rawMsg, key)
		case "recentlyResolved":
			err = unpopulate(val, "RecentlyResolved", &a.RecentlyResolved)
			delete(rawMsg, key)
		case "recommendedActions":
			err = unpopulate(val, "RecommendedActions", &a.RecommendedActions)
			delete(rawMsg, key)
		case "reportedTime":
			err = unpopulateTimeRFC3339(val, "ReportedTime", &a.ReportedTime)
			delete(rawMsg, key)
		case "resolutionETA":
			err = unpopulateTimeRFC3339(val, "ResolutionETA", &a.ResolutionETA)
			delete(rawMsg, key)
		case "rootCauseAttributionTime":
			err = unpopulateTimeRFC3339(val, "RootCauseAttributionTime", &a.RootCauseAttributionTime)
			delete(rawMsg, key)
		case "serviceImpactingEvents":
			err = unpopulate(val, "ServiceImpactingEvents", &a.ServiceImpactingEvents)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &a.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityStatusPropertiesRecentlyResolved.
func (a *AvailabilityStatusPropertiesRecentlyResolved) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resolvedTime":
			err = unpopulateTimeRFC3339(val, "ResolvedTime", &a.ResolvedTime)
			delete(rawMsg, key)
		case "unavailabilitySummary":
			err = unpopulate(val, "UnavailabilitySummary", &a.UnavailabilitySummary)
			delete(rawMsg, key)
		case "unavailableOccurredTime":
			err = unpopulateTimeRFC3339(val, "UnavailableOccurredTime", &a.UnavailableOccurredTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpactedResourceStatusProperties.
func (i *ImpactedResourceStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityState":
			err = unpopulate(val, "AvailabilityState", &i.AvailabilityState)
			delete(rawMsg, key)
		case "occurredTime":
			err = unpopulateTimeRFC3339(val, "OccurredTime", &i.OccurredTime)
			delete(rawMsg, key)
		case "reasonType":
			err = unpopulate(val, "ReasonType", &i.ReasonType)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &i.Summary)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &i.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceImpactingEvent.
func (s *ServiceImpactingEvent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &s.CorrelationID)
			delete(rawMsg, key)
		case "eventStartTime":
			err = unpopulateTimeRFC3339(val, "EventStartTime", &s.EventStartTime)
			delete(rawMsg, key)
		case "eventStatusLastModifiedTime":
			err = unpopulateTimeRFC3339(val, "EventStatusLastModifiedTime", &s.EventStatusLastModifiedTime)
			delete(rawMsg, key)
		case "incidentProperties":
			err = unpopulate(val, "IncidentProperties", &s.IncidentProperties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StatusBanner.
func (s *StatusBanner) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cloud":
			err = unpopulate(val, "Cloud", &s.Cloud)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &s.LastModifiedTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &s.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
