/* ScanningListReader.c generated by valac 0.34.4, the Vala compiler
 * generated from ScanningListReader.vala, do not modify */

/*
 * Copyright (C) 2014 Stefan Ringel
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/mpegts/mpegts.h>
#include <float.h>
#include <math.h>


#define DVB_IO_TYPE_SCANNING_LIST_READER (dvb_io_scanning_list_reader_get_type ())
#define DVB_IO_SCANNING_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReader))
#define DVB_IO_SCANNING_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReaderClass))
#define DVB_IO_IS_SCANNING_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_SCANNING_LIST_READER))
#define DVB_IO_IS_SCANNING_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_SCANNING_LIST_READER))
#define DVB_IO_SCANNING_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReaderClass))

typedef struct _DVBioScanningListReader DVBioScanningListReader;
typedef struct _DVBioScanningListReaderClass DVBioScanningListReaderClass;
typedef struct _DVBioScanningListReaderPrivate DVBioScanningListReaderPrivate;

#define DVB_TYPE_PARAMETER (dvb_parameter_get_type ())
#define DVB_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PARAMETER, DVBParameter))
#define DVB_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PARAMETER, DVBParameterClass))
#define DVB_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PARAMETER))
#define DVB_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PARAMETER))
#define DVB_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PARAMETER, DVBParameterClass))

typedef struct _DVBParameter DVBParameter;
typedef struct _DVBParameterClass DVBParameterClass;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define DVB_TYPE_DVB_TPARAMETER (dvb_dvb_tparameter_get_type ())
#define DVB_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter))
#define DVB_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))
#define DVB_IS_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_TPARAMETER))
#define DVB_IS_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_TPARAMETER))
#define DVB_DVB_TPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))

typedef struct _DVBDvbTParameter DVBDvbTParameter;
typedef struct _DVBDvbTParameterClass DVBDvbTParameterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_DVB_CEUROPE_PARAMETER (dvb_dvb_ceurope_parameter_get_type ())
#define DVB_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameter))
#define DVB_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))
#define DVB_IS_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_IS_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_DVB_CEUROPE_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))

typedef struct _DVBDvbCEuropeParameter DVBDvbCEuropeParameter;
typedef struct _DVBDvbCEuropeParameterClass DVBDvbCEuropeParameterClass;

#define DVB_TYPE_DVB_SPARAMETER (dvb_dvb_sparameter_get_type ())
#define DVB_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameter))
#define DVB_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))
#define DVB_IS_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_SPARAMETER))
#define DVB_IS_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_SPARAMETER))
#define DVB_DVB_SPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))

typedef struct _DVBDvbSParameter DVBDvbSParameter;
typedef struct _DVBDvbSParameterClass DVBDvbSParameterClass;

struct _DVBioScanningListReader {
	GObject parent_instance;
	DVBioScanningListReaderPrivate * priv;
};

struct _DVBioScanningListReaderClass {
	GObjectClass parent_class;
};

struct _DVBioScanningListReaderPrivate {
	GKeyFile* file;
	gchar* path;
	GList* parameters;
};


static gpointer dvb_io_scanning_list_reader_parent_class = NULL;

GType dvb_io_scanning_list_reader_get_type (void) G_GNUC_CONST;
GType dvb_parameter_get_type (void) G_GNUC_CONST;
#define DVB_IO_SCANNING_LIST_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReaderPrivate))
enum  {
	DVB_IO_SCANNING_LIST_READER_DUMMY_PROPERTY,
	DVB_IO_SCANNING_LIST_READER_PARAMETERS
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
DVBioScanningListReader* dvb_io_scanning_list_reader_new (const gchar* keyfile);
DVBioScanningListReader* dvb_io_scanning_list_reader_construct (GType object_type, const gchar* keyfile);
void dvb_io_scanning_list_reader_read_data (DVBioScanningListReader* self, GError** error);
static void dvb_io_scanning_list_reader_read_dvb_t (DVBioScanningListReader* self, const gchar* group, GError** error);
static void dvb_io_scanning_list_reader_read_dvb_c (DVBioScanningListReader* self, const gchar* group, GError** error);
static void dvb_io_scanning_list_reader_read_dvb_s (DVBioScanningListReader* self, const gchar* group, GError** error);
GType dvb_dvb_tparameter_get_type (void) G_GNUC_CONST;
GstMpegtsTerrestrialGuardInterval dvb_getGuardIntervalEnum (const gchar* val);
GstMpegtsTerrestrialTransmissionMode dvb_getTransmissionModeEnum (const gchar* val);
GstMpegtsTerrestrialHierarchy dvb_getHierarchyEnum (const gchar* val);
GstMpegtsModulationType dvb_getModulationEnum (const gchar* val);
GstMpegtsDVBCodeRate dvb_getCodeRateEnum (const gchar* val);
DVBDvbTParameter* dvb_dvb_tparameter_new_with_parameter (guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
DVBDvbTParameter* dvb_dvb_tparameter_construct_with_parameter (GType object_type, guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
GType dvb_dvb_ceurope_parameter_get_type (void) G_GNUC_CONST;
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_new_with_parameter (guint frequency, guint symbol_rate, GstMpegtsModulationType modulation, GstMpegtsDVBCodeRate inner_fec);
DVBDvbCEuropeParameter* dvb_dvb_ceurope_parameter_construct_with_parameter (GType object_type, guint frequency, guint symbol_rate, GstMpegtsModulationType modulation, GstMpegtsDVBCodeRate inner_fec);
GType dvb_dvb_sparameter_get_type (void) G_GNUC_CONST;
GstMpegtsSatellitePolarizationType dvb_getPolarizationEnum (const gchar* val);
DVBDvbSParameter* dvb_dvb_sparameter_new_with_parameter (guint frequency, guint symbol_rate, gfloat position, GstMpegtsSatellitePolarizationType polarization, GstMpegtsDVBCodeRate inner_fec);
DVBDvbSParameter* dvb_dvb_sparameter_construct_with_parameter (GType object_type, guint frequency, guint symbol_rate, gfloat position, GstMpegtsSatellitePolarizationType polarization, GstMpegtsDVBCodeRate inner_fec);
void dvb_dvb_sparameter_set_DiseqcSource (DVBDvbSParameter* self, gint value);
GList* dvb_io_scanning_list_reader_get_Parameters (DVBioScanningListReader* self);
static void dvb_io_scanning_list_reader_finalize (GObject* obj);
static void _vala_dvb_io_scanning_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


DVBioScanningListReader* dvb_io_scanning_list_reader_construct (GType object_type, const gchar* keyfile) {
	DVBioScanningListReader * self = NULL;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (keyfile != NULL, NULL);
	self = (DVBioScanningListReader*) g_object_new (object_type, NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = keyfile;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->path);
	self->priv->path = _tmp2_;
	__g_list_free__g_object_unref0_0 (self->priv->parameters);
	self->priv->parameters = NULL;
	return self;
}


DVBioScanningListReader* dvb_io_scanning_list_reader_new (const gchar* keyfile) {
	return dvb_io_scanning_list_reader_construct (DVB_IO_TYPE_SCANNING_LIST_READER, keyfile);
}


void dvb_io_scanning_list_reader_read_data (DVBioScanningListReader* self, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GKeyFile* _tmp2_ = NULL;
	gsize _tmp3_;
	gchar** _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = self->priv->path;
	g_key_file_load_from_file (_tmp0_, _tmp1_, G_KEY_FILE_NONE, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp2_ = self->priv->file;
	_tmp4_ = g_key_file_get_groups (_tmp2_, &_tmp3_);
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp4_;
		group_collection_length1 = _tmp3_;
		for (group_it = 0; group_it < _tmp3_; group_it = group_it + 1) {
			const gchar* group = NULL;
			group = group_collection[group_it];
			{
				gchar* _tmp5_ = NULL;
				GKeyFile* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				GQuark _tmp12_ = 0U;
				static GQuark _tmp11_label0 = 0;
				static GQuark _tmp11_label1 = 0;
				static GQuark _tmp11_label2 = 0;
				_tmp6_ = self->priv->file;
				_tmp7_ = group;
				_tmp8_ = g_key_file_get_string (_tmp6_, _tmp7_, "DELIVERY_SYSTEM", &_inner_error_);
				_tmp5_ = _tmp8_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
						g_propagate_error (error, _inner_error_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						return;
					} else {
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp9_ = _tmp5_;
				_tmp5_ = NULL;
				_tmp10_ = _tmp9_;
				_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
				g_free (_tmp10_);
				if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string ("DVBT")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp13_ = NULL;
							_tmp13_ = group;
							dvb_io_scanning_list_reader_read_dvb_t (self, _tmp13_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_tmp5_);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (_tmp5_);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp11_label1) ? _tmp11_label1 : (_tmp11_label1 = g_quark_from_static_string ("DVBC/ANNEX_A")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp14_ = NULL;
							_tmp14_ = group;
							dvb_io_scanning_list_reader_read_dvb_c (self, _tmp14_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_tmp5_);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (_tmp5_);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else if (_tmp12_ == ((0 != _tmp11_label2) ? _tmp11_label2 : (_tmp11_label2 = g_quark_from_static_string ("DVBS")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp15_ = NULL;
							_tmp15_ = group;
							dvb_io_scanning_list_reader_read_dvb_s (self, _tmp15_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
									g_propagate_error (error, _inner_error_);
									_g_free0 (_tmp5_);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									return;
								} else {
									_g_free0 (_tmp5_);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
				_g_free0 (_tmp5_);
			}
		}
		group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_scanning_list_reader_read_dvb_t (DVBioScanningListReader* self, const gchar* group, GError** error) {
	guint64 _tmp0_ = 0ULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint64 _tmp3_ = 0ULL;
	guint64 _tmp4_ = 0ULL;
	GKeyFile* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint64 _tmp7_ = 0ULL;
	gchar* _tmp8_ = NULL;
	GKeyFile* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GKeyFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GKeyFile* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GKeyFile* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	GKeyFile* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	GKeyFile* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	DVBDvbTParameter* param = NULL;
	GstMpegtsTerrestrialGuardInterval _tmp32_ = 0;
	GstMpegtsTerrestrialTransmissionMode _tmp33_ = 0;
	GstMpegtsTerrestrialHierarchy _tmp34_ = 0;
	GstMpegtsModulationType _tmp35_ = 0;
	GstMpegtsDVBCodeRate _tmp36_ = 0;
	GstMpegtsDVBCodeRate _tmp37_ = 0;
	DVBDvbTParameter* _tmp38_ = NULL;
	DVBDvbTParameter* _tmp39_ = NULL;
	DVBParameter* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp1_ = self->priv->file;
	_tmp2_ = group;
	_tmp3_ = g_key_file_get_uint64 (_tmp1_, _tmp2_, "FREQUENCY", &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = self->priv->file;
	_tmp6_ = group;
	_tmp7_ = g_key_file_get_uint64 (_tmp5_, _tmp6_, "BANDWIDTH_HZ", &_inner_error_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = self->priv->file;
	_tmp10_ = group;
	_tmp11_ = g_key_file_get_string (_tmp9_, _tmp10_, "GUARD_INTERVAL", &_inner_error_);
	_tmp8_ = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = self->priv->file;
	_tmp14_ = group;
	_tmp15_ = g_key_file_get_string (_tmp13_, _tmp14_, "TRANSMISSION_MODE", &_inner_error_);
	_tmp12_ = _tmp15_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp8_);
			return;
		} else {
			_g_free0 (_tmp8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = self->priv->file;
	_tmp18_ = group;
	_tmp19_ = g_key_file_get_string (_tmp17_, _tmp18_, "HIERARCHY", &_inner_error_);
	_tmp16_ = _tmp19_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			return;
		} else {
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = self->priv->file;
	_tmp22_ = group;
	_tmp23_ = g_key_file_get_string (_tmp21_, _tmp22_, "MODULATION", &_inner_error_);
	_tmp20_ = _tmp23_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			return;
		} else {
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp25_ = self->priv->file;
	_tmp26_ = group;
	_tmp27_ = g_key_file_get_string (_tmp25_, _tmp26_, "CODE_RATE_LP", &_inner_error_);
	_tmp24_ = _tmp27_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			return;
		} else {
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp29_ = self->priv->file;
	_tmp30_ = group;
	_tmp31_ = g_key_file_get_string (_tmp29_, _tmp30_, "CODE_RATE_HP", &_inner_error_);
	_tmp28_ = _tmp31_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			return;
		} else {
			_g_free0 (_tmp24_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp32_ = dvb_getGuardIntervalEnum (_tmp8_);
	_tmp33_ = dvb_getTransmissionModeEnum (_tmp12_);
	_tmp34_ = dvb_getHierarchyEnum (_tmp16_);
	_tmp35_ = dvb_getModulationEnum (_tmp20_);
	_tmp36_ = dvb_getCodeRateEnum (_tmp24_);
	_tmp37_ = dvb_getCodeRateEnum (_tmp28_);
	_tmp38_ = dvb_dvb_tparameter_new_with_parameter ((guint) _tmp0_, (guint) _tmp4_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
	param = _tmp38_;
	_tmp39_ = param;
	_tmp40_ = _g_object_ref0 ((DVBParameter*) _tmp39_);
	self->priv->parameters = g_list_append (self->priv->parameters, _tmp40_);
	_g_object_unref0 (param);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
}


static void dvb_io_scanning_list_reader_read_dvb_c (DVBioScanningListReader* self, const gchar* group, GError** error) {
	guint64 _tmp0_ = 0ULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint64 _tmp3_ = 0ULL;
	guint64 _tmp4_ = 0ULL;
	GKeyFile* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint64 _tmp7_ = 0ULL;
	gchar* _tmp8_ = NULL;
	GKeyFile* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GKeyFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	DVBDvbCEuropeParameter* param = NULL;
	GstMpegtsModulationType _tmp16_ = 0;
	GstMpegtsDVBCodeRate _tmp17_ = 0;
	DVBDvbCEuropeParameter* _tmp18_ = NULL;
	DVBDvbCEuropeParameter* _tmp19_ = NULL;
	DVBParameter* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp1_ = self->priv->file;
	_tmp2_ = group;
	_tmp3_ = g_key_file_get_uint64 (_tmp1_, _tmp2_, "FREQUENCY", &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = self->priv->file;
	_tmp6_ = group;
	_tmp7_ = g_key_file_get_uint64 (_tmp5_, _tmp6_, "SYMBOL_RATE", &_inner_error_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = self->priv->file;
	_tmp10_ = group;
	_tmp11_ = g_key_file_get_string (_tmp9_, _tmp10_, "MODULATION", &_inner_error_);
	_tmp8_ = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = self->priv->file;
	_tmp14_ = group;
	_tmp15_ = g_key_file_get_string (_tmp13_, _tmp14_, "INNER_FEC", &_inner_error_);
	_tmp12_ = _tmp15_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp8_);
			return;
		} else {
			_g_free0 (_tmp8_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = dvb_getModulationEnum (_tmp8_);
	_tmp17_ = dvb_getCodeRateEnum (_tmp12_);
	_tmp18_ = dvb_dvb_ceurope_parameter_new_with_parameter ((guint) _tmp0_, (guint) _tmp4_, _tmp16_, _tmp17_);
	param = _tmp18_;
	_tmp19_ = param;
	_tmp20_ = _g_object_ref0 ((DVBParameter*) _tmp19_);
	self->priv->parameters = g_list_append (self->priv->parameters, _tmp20_);
	_g_object_unref0 (param);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp8_);
}


static void dvb_io_scanning_list_reader_read_dvb_s (DVBioScanningListReader* self, const gchar* group, GError** error) {
	guint64 _tmp0_ = 0ULL;
	GKeyFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	guint64 _tmp3_ = 0ULL;
	guint64 _tmp4_ = 0ULL;
	GKeyFile* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	guint64 _tmp7_ = 0ULL;
	gdouble _tmp8_ = 0.0;
	GKeyFile* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gdouble _tmp11_ = 0.0;
	gchar* _tmp12_ = NULL;
	GKeyFile* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GKeyFile* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	DVBDvbSParameter* param = NULL;
	GstMpegtsSatellitePolarizationType _tmp20_ = 0;
	GstMpegtsDVBCodeRate _tmp21_ = 0;
	DVBDvbSParameter* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GKeyFile* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	DVBDvbSParameter* _tmp32_ = NULL;
	DVBParameter* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp1_ = self->priv->file;
	_tmp2_ = group;
	_tmp3_ = g_key_file_get_uint64 (_tmp1_, _tmp2_, "FREQUENCY", &_inner_error_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = self->priv->file;
	_tmp6_ = group;
	_tmp7_ = g_key_file_get_uint64 (_tmp5_, _tmp6_, "SYMBOL_RATE", &_inner_error_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = self->priv->file;
	_tmp10_ = group;
	_tmp11_ = g_key_file_get_double (_tmp9_, _tmp10_, "ORBITAL_POSITION", &_inner_error_);
	_tmp8_ = _tmp11_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp13_ = self->priv->file;
	_tmp14_ = group;
	_tmp15_ = g_key_file_get_string (_tmp13_, _tmp14_, "POLARIZATION", &_inner_error_);
	_tmp12_ = _tmp15_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = self->priv->file;
	_tmp18_ = group;
	_tmp19_ = g_key_file_get_string (_tmp17_, _tmp18_, "INNER_FEC", &_inner_error_);
	_tmp16_ = _tmp19_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp12_);
			return;
		} else {
			_g_free0 (_tmp12_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = dvb_getPolarizationEnum (_tmp12_);
	_tmp21_ = dvb_getCodeRateEnum (_tmp16_);
	_tmp22_ = dvb_dvb_sparameter_new_with_parameter ((guint) _tmp0_, (guint) _tmp4_, (gfloat) _tmp8_, _tmp20_, _tmp21_);
	param = _tmp22_;
	_tmp24_ = self->priv->file;
	_tmp25_ = group;
	_tmp26_ = g_key_file_has_key (_tmp24_, _tmp25_, "SAT_NUMBER", &_inner_error_);
	_tmp23_ = _tmp26_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (param);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			return;
		} else {
			_g_object_unref0 (param);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (_tmp23_) {
		gint _tmp27_ = 0;
		GKeyFile* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		DVBDvbSParameter* _tmp31_ = NULL;
		_tmp28_ = self->priv->file;
		_tmp29_ = group;
		_tmp30_ = g_key_file_get_integer (_tmp28_, _tmp29_, "SAT_NUMBER", &_inner_error_);
		_tmp27_ = _tmp30_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == G_KEY_FILE_ERROR) || (_inner_error_->domain == G_FILE_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (param);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp12_);
				return;
			} else {
				_g_object_unref0 (param);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp12_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp31_ = param;
		dvb_dvb_sparameter_set_DiseqcSource (_tmp31_, _tmp27_);
	}
	_tmp32_ = param;
	_tmp33_ = _g_object_ref0 ((DVBParameter*) _tmp32_);
	self->priv->parameters = g_list_append (self->priv->parameters, _tmp33_);
	_g_object_unref0 (param);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
}


GList* dvb_io_scanning_list_reader_get_Parameters (DVBioScanningListReader* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}


static void dvb_io_scanning_list_reader_class_init (DVBioScanningListReaderClass * klass) {
	dvb_io_scanning_list_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioScanningListReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_scanning_list_reader_get_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_scanning_list_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_SCANNING_LIST_READER_PARAMETERS, g_param_spec_pointer ("Parameters", "Parameters", "Parameters", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dvb_io_scanning_list_reader_instance_init (DVBioScanningListReader * self) {
	self->priv = DVB_IO_SCANNING_LIST_READER_GET_PRIVATE (self);
}


static void dvb_io_scanning_list_reader_finalize (GObject* obj) {
	DVBioScanningListReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReader);
	_g_key_file_unref0 (self->priv->file);
	_g_free0 (self->priv->path);
	__g_list_free__g_object_unref0_0 (self->priv->parameters);
	G_OBJECT_CLASS (dvb_io_scanning_list_reader_parent_class)->finalize (obj);
}


GType dvb_io_scanning_list_reader_get_type (void) {
	static volatile gsize dvb_io_scanning_list_reader_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_scanning_list_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioScanningListReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_scanning_list_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioScanningListReader), 0, (GInstanceInitFunc) dvb_io_scanning_list_reader_instance_init, NULL };
		GType dvb_io_scanning_list_reader_type_id;
		dvb_io_scanning_list_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioScanningListReader", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_scanning_list_reader_type_id__volatile, dvb_io_scanning_list_reader_type_id);
	}
	return dvb_io_scanning_list_reader_type_id__volatile;
}


static void _vala_dvb_io_scanning_list_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioScanningListReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_SCANNING_LIST_READER, DVBioScanningListReader);
	switch (property_id) {
		case DVB_IO_SCANNING_LIST_READER_PARAMETERS:
		g_value_set_pointer (value, dvb_io_scanning_list_reader_get_Parameters (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



