---
title: Staticcheck 2021.1 release notes
linkTitle: "2021.1 (v0.2.0)"
weight: -6
---

## UI improvements {#ui-improvements}

The new `-list-checks` flag lists all available checks, showing each check's identifier and one-line description.
You can use the existing `-explain` flag to find out more about each individual check.

### Targeted Go version {#targeted-go-version}

Some checks in Staticcheck adjust their behavior based on the targeted Go version. For example, the suggestion to use `for range` instead of `for _ = range` does not apply to Go 1.3 and earlier.

In the past, the default Go version that was targeted was the version that Staticcheck had been compiled with. For most users, this meant that it targeted the latest Go release.
Going forward, we will default to the Go version declared in `go.mod` via the `go` directive.
Even though this value does not exactly correspond to the module's minimum supported Go version, it is still a better apprximation than "whatever Go version Staticcheck has been compiled with",
and should work fine for most users.

As before, the targeted Go version can be explicitly set by using the `-go` flag.

## Checks {#checks}

### New checks {#checks-new}

The following new checks have been added:

- {{< check "S1040"  >}} flags type assertions from an interface type to itself
- {{< check "SA1030" >}} flags invalid arguments to various functions in the `strconv` package
- {{< check "SA4005" >}} flags assignments to fields on value receivers that intended the receiver to be a pointer instead
- {{< check "SA4024" >}} flags pointless comparisons of the values of `len` and `cap` with zero
- {{< check "SA4025" >}} flags suspicious integer division that results in zero, such as `2 / 3`
- {{< check "SA4026" >}} flags constant expressions that try to express [negative zero](https://en.wikipedia.org/wiki/Signed_zero)
- {{< check "SA4027" >}} flags no-op attempts at modifying a `(*net/url.URL)`'s query string
- {{< check "ST1023" >}} flags variable declarations of the form `var x T = v` where the type `T` is redundant; this check is disabled by default


### Changed checks {#checks-changed}

The following checks have been improved:

- {{< check "S1025"  >}} now recommends converting byte slices to strings instead of using `fmt.Sprintf`
- {{< check "S1008"  >}} includes fewer unnecessary parentheses and double negations in its suggested fixes
- {{< check "S1017"  >}} is now able to flag calls that use string literals and integer literals
- {{< check "SA9005" >}} now includes the value's type in its output
- {{< check "ST1000" >}}, {{< check "ST1020" >}}, {{< check "ST1021" >}}, and {{< check "ST1022" >}} no longer flag effectively empty comments, including those that consist entirely of directives

## Restructured documentation {#documentation}

The documentation on [the website](https://staticcheck.dev) has been restructured and hopefully made more approachable.
Instead of being one long document, it is now split into multiple smaller articles.
In the future, more articles that look at specific aspects of Staticcheck will be added.

## Better integration with gopls {#gopls}

Several behind the scenes changes prepare this release for better integration with [gopls](https://github.com/golang/tools/blob/master/gopls/README.md).
This will include more accurate severities for diagnostics as well as numerous new refactorings.
These improvements will be part of a future gopls release.

## Deletion of rdeps {#rdeps}

The rdeps tool has been deleted.
This was a GOPATH-centric tool that allowed finding all reverse dependencies of a Go package.
Both the move to Go modules as well as the emergence of much better tooling for inspecting dependencies (such as [goda](https://github.com/loov/goda)) has made rdeps redundant.

## Staticcheck 2021.1.1 release notes {#2021.1.1}

This release adds support for new language features in Go 1.17,
namely conversions from slices to array pointers,
the unsafe.Add function,
and the unsafe.Slice function.

Additionally, it fixes the following false positives:

- {{< check "ST1000" >}} no longer flags package docs that start with whitespace if they're otherwise well-formed.
- {{< check "SA5002" >}} no longer prints one too many percent signs in its message.
- {{< check "SA4000" >}} no longer flags comparisons between floats.
- {{< check "SA4010" >}} no longer flags appends to slices that might share their backing array with other slices.
- {{< check "SA5011" >}} no longer infers possible nil pointer dereferences from comparisons done outside of control flow constructs.
  This avoids false positives when using `assert`-style functions.
  See [issue 1022]({{< issueref 1022 >}}) for a concrete example.
- {{< check "S1020"  >}} no longer flags nested if statements when the inner statement has an else branch.
- {{< check "SA5011" >}} no longer claims that indexing a nil slice will cause a nil pointer dereference.

## Staticcheck 2021.1.2 release notes {#2021.1.2}

This release fixes the following false positives:

- {{< check "SA4000" >}} no longer flags operations involving the `math/rand` package. This is to allow patterns such as `rand.Intn(2) - rand.Intn(2)`.
- {{< check "S1019" >}} no longer recommends replacing `make(map[X]Y, 0)` with `make(map[X]Y)` – the latter may allocate a small starting size.
- {{< check "SA1026" >}} now more accurately implements the behavior of `encoding/json` and `encoding/xml`, which will lead to fewer false positives involving method sets or embedding.
  It might also find bugs that it previously missed.
- Checks that are sensitive to control flow, such as {{< check "SA5011" >}}, now recognize functions from `k8s.io/klog` and `go.uber.org/zap` that affect control flow (`Panic` and `Fatal` related functions.)

Furthermore, it fixes the following crashes:

- Using `//lint:ignore U1000` on a type alias would crash.
- Converting a slice to an array pointer, where the array type is a named type, would crash.
