/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.LipEditor;
import org.lisaac.ldt.editors.LisaacEditor;
import org.lisaac.ldt.editors.LisaacScanner;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.IVariable;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;

public class PrototypeHyperLink
implements IHyperlink {
    private String fPrototypeString;
    private IRegion fRegion;

    public PrototypeHyperLink(IRegion region, String string) {
        this.fRegion = region;
        this.fPrototypeString = string;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (this.fPrototypeString != null) {
            IProject project = null;
            IWorkbenchWindow w = LisaacPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPart part = w.getPartService().getActivePart();
            if (part instanceof LisaacEditor) {
                project = ((LisaacEditor)part).getProject();
            }
            if (part instanceof LipEditor) {
                return;
            }
            if (project != null) {
                Prototype prototype = null;
                Slot slot = null;
                Position position = null;
                LisaacModel model = LisaacModel.getModel(project);
                if (LisaacScanner.isPrototypeIdentifier(this.fPrototypeString)) {
                    try {
                        prototype = model.getPrototype(this.fPrototypeString);
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                }
                try {
                    prototype = LisaacModel.getCurrentPrototype();
                    slot = prototype.getSlotFromKeyword(this.fPrototypeString, prototype.openParser(), this.fRegion.getOffset());
                }
                catch (CoreException coreException) {
                    return;
                }
                if (slot != null) {
                    prototype = slot.getPrototype();
                    position = slot.getPosition();
                } else {
                    IVariable variable = null;
                    slot = prototype.getSlot(this.fRegion.getOffset());
                    if (slot != null) {
                        variable = slot.getVariable(this.fPrototypeString, this.fRegion.getOffset());
                    }
                    if (variable != null) {
                        Position p = variable.getPosition();
                        int len = this.fPrototypeString.length();
                        if (p.length > 0) {
                            len = p.length;
                        }
                        position = new Position(0, 0, p.offset - len, len);
                    } else {
                        slot = prototype.lookupSlot(this.fPrototypeString);
                        if (slot != null) {
                            prototype = slot.getPrototype();
                            position = slot.getPosition();
                        } else {
                            prototype = null;
                        }
                    }
                }
                if (prototype != null) {
                    IProject p = project;
                    String filename = prototype.getFileName();
                    String prototypePath = prototype.getModel().getPathManager().getFullPath(prototype.getName());
                    Position selectPosition = position;
                    part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchPage page = w.getActivePage();
                            if (page == null) {
                                return;
                            }
                            if (prototypePath != null) {
                                Path location = new Path(prototypePath);
                                IPath projectLocation = p.getLocation();
                                IFile file = null;
                                if (projectLocation.isPrefixOf((IPath)location)) {
                                    location = location.removeFirstSegments(projectLocation.segmentCount());
                                    file = p.getFile((IPath)location);
                                } else {
                                    IFolder lib = p.getFolder("lib");
                                    if (lib == null) {
                                        lib = p;
                                    }
                                    file = lib.getFile((IPath)new Path(filename));
                                }
                                try {
                                    IWorkbenchPart part;
                                    IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                                    if (selectPosition != null && (part = w.getPartService().getActivePart()) instanceof LisaacEditor) {
                                        ((LisaacEditor)part).selectAndReveal(selectPosition.offset, selectPosition.length);
                                    }
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            }
            this.fPrototypeString = null;
        }
    }

    public String getHyperlinkText() {
        return this.fPrototypeString;
    }

    public String getTypeLabel() {
        return null;
    }
}

