import argparse
import os
import sys

from subprocess import call, check_call, CalledProcessError
from time import sleep
from typing import List, Tuple


def main():
    settings, rest = parse_arguments()
    if settings.wait:
        wait()
    if settings.build_llvm or settings.build_llvm_only:
        build_llvm()
    if settings.build_llvm_only:
        return
    sys.exit(test(rest))


def wait():
    # It is an easy on CPU way of keeping the docker container running
    # while the user has a terminal session in that container.
    while True:
        sleep(3600)


def parse_arguments() -> Tuple[argparse.Namespace, List[str]]:
    parser = argparse.ArgumentParser()
    parser.add_argument('--wait', action='store_true')
    parser.add_argument('--build-llvm', action='store_true')
    parser.add_argument('--build-llvm-only', action='store_true')
    return parser.parse_known_args()


def build_llvm():
    os.chdir('/build')
    try:
        if is_cmake_needed():
            cmake()
        ninja()
    except CalledProcessError:
        print("Build failed!")
        sys.exit(1)


def is_cmake_needed():
    return "build.ninja" not in os.listdir()


CMAKE_COMMAND = "cmake -G Ninja -DCMAKE_BUILD_TYPE=Release " \
    "-DCMAKE_INSTALL_PREFIX=/analyzer -DLLVM_TARGETS_TO_BUILD=X86 " \
    "-DLLVM_ENABLE_PROJECTS=\"clang;openmp\" -DLLVM_BUILD_RUNTIME=OFF " \
    "-DLLVM_ENABLE_TERMINFO=OFF -DCLANG_ENABLE_ARCMT=OFF " \
    "-DCLANG_ENABLE_STATIC_ANALYZER=ON"


def cmake():
    check_call(CMAKE_COMMAND + ' /llvm-project/llvm', shell=True)


def ninja():
    check_call("ninja install", shell=True)


def test(args: List[str]) -> int:
    os.chdir("/projects")
    return call("/scripts/SATest.py " + " ".join(args), shell=True)


if __name__ == '__main__':
    main()
