// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --check-globals --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" --global-value-regex ".offload_maptypes.*" ".offload_sizes.*" --global-hex-value-regex ".offload_maptypes.*"
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

//--------------------------------------------------
// With -DUSE.
//--------------------------------------------------

// powerpc64le-ibm-linux-gnu

// RUN: %clang_cc1 -DUSE -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-USE-PPC64LE
// RUN: %clang_cc1 -DUSE -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -DUSE -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t \
// RUN:     -verify %s -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-USE-PPC64LE

// i386-pc-linux-gnu

// RUN: %clang_cc1 -DUSE -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-USE-I386
// RUN: %clang_cc1 -DUSE -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple i386-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -DUSE -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -std=c++11 -include-pch %t -verify %s \
// RUN:     -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-USE-I386

//--------------------------------------------------
// Without -DUSE.
//--------------------------------------------------

// powerpc64le-ibm-linux-gnu

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-NOUSE-PPC64LE
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple powerpc64le-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=powerpc64le-ibm-linux-gnu -x c++ \
// RUN:     -triple powerpc64le-unknown-unknown -std=c++11 -include-pch %t \
// RUN:     -verify %s -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-NOUSE-PPC64LE

// i386-pc-linux-gnu

// RUN: %clang_cc1 -verify -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -emit-llvm %s -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-NOUSE-I386
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ -std=c++11 \
// RUN:     -triple i386-unknown-unknown -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-extensions \
// RUN:     -fopenmp-targets=i386-pc-linux-gnu -x c++ \
// RUN:     -triple i386-unknown-unknown -std=c++11 -include-pch %t -verify %s \
// RUN:     -emit-llvm -o - | \
// RUN:   FileCheck %s --check-prefixes=CHECK-NOUSE-I386

// Map flags used in @.offload_maptypes* below:
//
// TO           = 0x1
// FROM         = 0x2
// ALWAYS       = 0x4
// TARGET_PARAM = 0x20
// CLOSE        = 0x400
// OMPX_HOLD    = 0x2000
// MEMBER_OF_1  = 0x1000000000000
// MEMBER_OF_5  = 0x5000000000000

//.
// CHECK-USE-PPC64LE: @.offload_maptypes = private unnamed_addr constant [7 x i64] [i64 [[#0x2020]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]], i64 [[#0x2023]], i64 [[#0x2020]], i64 [[#0x5000000002003]], i64 [[#0x5000000002003]]]
// CHECK-USE-PPC64LE: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-USE-PPC64LE: @.offload_maptypes.1 = private unnamed_addr constant [1 x i64] [i64 [[#0x2427]]]
// CHECK-USE-PPC64LE: @.offload_maptypes.2 = private unnamed_addr constant [3 x i64] [i64 [[#0x2020]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]]]
//.
// CHECK-USE-I386: @.offload_maptypes = private unnamed_addr constant [7 x i64] [i64 [[#0x2020]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]], i64 [[#0x2023]], i64 [[#0x2020]], i64 [[#0x5000000002003]], i64 [[#0x5000000002003]]]
// CHECK-USE-I386: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-USE-I386: @.offload_maptypes.1 = private unnamed_addr constant [1 x i64] [i64 [[#0x2427]]]
// CHECK-USE-I386: @.offload_maptypes.2 = private unnamed_addr constant [3 x i64] [i64 [[#0x2020]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]]]
//.
// CHECK-NOUSE-PPC64LE: @.offload_maptypes = private unnamed_addr constant [7 x i64] [i64 [[#0x2000]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]], i64 [[#0x2003]], i64 [[#0x2000]], i64 [[#0x5000000002003]], i64 [[#0x5000000002003]]]
// CHECK-NOUSE-PPC64LE: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-NOUSE-PPC64LE: @.offload_maptypes.1 = private unnamed_addr constant [1 x i64] [i64 [[#0x2407]]]
// CHECK-NOUSE-PPC64LE: @.offload_maptypes.2 = private unnamed_addr constant [3 x i64] [i64 [[#0x2000]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]]]
//.
// CHECK-NOUSE-I386: @.offload_maptypes = private unnamed_addr constant [7 x i64] [i64 [[#0x2000]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]], i64 [[#0x2003]], i64 [[#0x2000]], i64 [[#0x5000000002003]], i64 [[#0x5000000002003]]]
// CHECK-NOUSE-I386: @.offload_sizes = private unnamed_addr constant [1 x i64] [i64 4]
// CHECK-NOUSE-I386: @.offload_maptypes.1 = private unnamed_addr constant [1 x i64] [i64 [[#0x2407]]]
// CHECK-NOUSE-I386: @.offload_maptypes.2 = private unnamed_addr constant [3 x i64] [i64 [[#0x2000]], i64 [[#0x1000000002003]], i64 [[#0x1000000002003]]]
//.
struct ST {
  int i;
  int j;
  void test_present_members();
};

// CHECK-USE-PPC64LE-LABEL: @_Z20explicit_maps_singlei(
// CHECK-USE-PPC64LE-NEXT:  entry:
// CHECK-USE-PPC64LE-NEXT:    [[II_ADDR:%.*]] = alloca i32, align 4
// CHECK-USE-PPC64LE-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK-USE-PPC64LE-NEXT:    [[ST1:%.*]] = alloca [[STRUCT_ST:%.*]], align 4
// CHECK-USE-PPC64LE-NEXT:    [[ST2:%.*]] = alloca [[STRUCT_ST]], align 4
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [7 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [7 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [7 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [7 x i64], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS3:%.*]] = alloca [1 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS4:%.*]] = alloca [1 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS5:%.*]] = alloca [1 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    store i32 [[II:%.*]], i32* [[II_ADDR]], align 4
// CHECK-USE-PPC64LE-NEXT:    [[TMP0:%.*]] = load i32, i32* [[II_ADDR]], align 4
// CHECK-USE-PPC64LE-NEXT:    store i32 [[TMP0]], i32* [[A]], align 4
// CHECK-USE-PPC64LE-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP1:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP2:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-USE-PPC64LE-NEXT:    [[TMP3:%.*]] = bitcast i32* [[TMP1]] to i8*
// CHECK-USE-PPC64LE-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP3]] to i64
// CHECK-USE-PPC64LE-NEXT:    [[TMP5:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-USE-PPC64LE-NEXT:    [[TMP6:%.*]] = sub i64 [[TMP4]], [[TMP5]]
// CHECK-USE-PPC64LE-NEXT:    [[TMP7:%.*]] = sdiv exact i64 [[TMP6]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-USE-PPC64LE-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[J2:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP8:%.*]] = getelementptr i32, i32* [[J2]], i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP9:%.*]] = bitcast i32* [[I1]] to i8*
// CHECK-USE-PPC64LE-NEXT:    [[TMP10:%.*]] = bitcast i32* [[TMP8]] to i8*
// CHECK-USE-PPC64LE-NEXT:    [[TMP11:%.*]] = ptrtoint i8* [[TMP10]] to i64
// CHECK-USE-PPC64LE-NEXT:    [[TMP12:%.*]] = ptrtoint i8* [[TMP9]] to i64
// CHECK-USE-PPC64LE-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK-USE-PPC64LE-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-USE-PPC64LE-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP16]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP18]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    store i64 [[TMP7]], i64* [[TMP19]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP20]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP22]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP24]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP25]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-USE-PPC64LE-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP28]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-USE-PPC64LE-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[J]], i32** [[TMP30]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP31]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP32]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-USE-PPC64LE-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP34]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-USE-PPC64LE-NEXT:    [[TMP36:%.*]] = bitcast i8** [[TMP35]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP36]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP37]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP38]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-USE-PPC64LE-NEXT:    [[TMP40:%.*]] = bitcast i8** [[TMP39]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP40]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-USE-PPC64LE-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[I1]], i32** [[TMP42]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-USE-PPC64LE-NEXT:    store i64 [[TMP14]], i64* [[TMP43]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP44]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-USE-PPC64LE-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP46]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-USE-PPC64LE-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[I1]], i32** [[TMP48]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP49]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP50]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK-USE-PPC64LE-NEXT:    [[TMP52:%.*]] = bitcast i8** [[TMP51]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP52]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK-USE-PPC64LE-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[J2]], i32** [[TMP54]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP55]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP56]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP60:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1:[0-9]+]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654.region_id, i32 7, i8** [[TMP57]], i8** [[TMP58]], i64* [[TMP59]], i64* getelementptr inbounds ([7 x i64], [7 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-USE-PPC64LE-NEXT:    [[TMP61:%.*]] = icmp ne i32 [[TMP60]], 0
// CHECK-USE-PPC64LE-NEXT:    br i1 [[TMP61]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-USE-PPC64LE:       omp_offload.failed:
// CHECK-USE-PPC64LE-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654(%struct.ST* [[ST1]], i32* [[A]], %struct.ST* [[ST2]]) #[[ATTR2:[0-9]+]]
// CHECK-USE-PPC64LE-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-USE-PPC64LE:       omp_offload.cont:
// CHECK-USE-PPC64LE-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP63:%.*]] = bitcast i8** [[TMP62]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP63]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP65]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS5]], i64 0, i64 0
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP66]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP69:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668.region_id, i32 1, i8** [[TMP67]], i8** [[TMP68]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.1, i32 0, i32 0), i8** null, i8** null)
// CHECK-USE-PPC64LE-NEXT:    [[TMP70:%.*]] = icmp ne i32 [[TMP69]], 0
// CHECK-USE-PPC64LE-NEXT:    br i1 [[TMP70]], label [[OMP_OFFLOAD_FAILED6:%.*]], label [[OMP_OFFLOAD_CONT7:%.*]]
// CHECK-USE-PPC64LE:       omp_offload.failed6:
// CHECK-USE-PPC64LE-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668(i32* [[A]]) #[[ATTR2]]
// CHECK-USE-PPC64LE-NEXT:    br label [[OMP_OFFLOAD_CONT7]]
// CHECK-USE-PPC64LE:       omp_offload.cont7:
// CHECK-USE-PPC64LE-NEXT:    ret void
//
// CHECK-USE-I386-LABEL: @_Z20explicit_maps_singlei(
// CHECK-USE-I386-NEXT:  entry:
// CHECK-USE-I386-NEXT:    [[II_ADDR:%.*]] = alloca i32, align 4
// CHECK-USE-I386-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK-USE-I386-NEXT:    [[ST1:%.*]] = alloca [[STRUCT_ST:%.*]], align 4
// CHECK-USE-I386-NEXT:    [[ST2:%.*]] = alloca [[STRUCT_ST]], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [7 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [7 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [7 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [7 x i64], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS3:%.*]] = alloca [1 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_PTRS4:%.*]] = alloca [1 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_MAPPERS5:%.*]] = alloca [1 x i8*], align 4
// CHECK-USE-I386-NEXT:    store i32 [[II:%.*]], i32* [[II_ADDR]], align 4
// CHECK-USE-I386-NEXT:    [[TMP0:%.*]] = load i32, i32* [[II_ADDR]], align 4
// CHECK-USE-I386-NEXT:    store i32 [[TMP0]], i32* [[A]], align 4
// CHECK-USE-I386-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP1:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-USE-I386-NEXT:    [[TMP2:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-USE-I386-NEXT:    [[TMP3:%.*]] = bitcast i32* [[TMP1]] to i8*
// CHECK-USE-I386-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP3]] to i64
// CHECK-USE-I386-NEXT:    [[TMP5:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-USE-I386-NEXT:    [[TMP6:%.*]] = sub i64 [[TMP4]], [[TMP5]]
// CHECK-USE-I386-NEXT:    [[TMP7:%.*]] = sdiv exact i64 [[TMP6]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-USE-I386-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[J2:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP8:%.*]] = getelementptr i32, i32* [[J2]], i32 1
// CHECK-USE-I386-NEXT:    [[TMP9:%.*]] = bitcast i32* [[I1]] to i8*
// CHECK-USE-I386-NEXT:    [[TMP10:%.*]] = bitcast i32* [[TMP8]] to i8*
// CHECK-USE-I386-NEXT:    [[TMP11:%.*]] = ptrtoint i8* [[TMP10]] to i64
// CHECK-USE-I386-NEXT:    [[TMP12:%.*]] = ptrtoint i8* [[TMP9]] to i64
// CHECK-USE-I386-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK-USE-I386-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-USE-I386-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP16]], align 4
// CHECK-USE-I386-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[I]], i32** [[TMP18]], align 4
// CHECK-USE-I386-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    store i64 [[TMP7]], i64* [[TMP19]], align 4
// CHECK-USE-I386-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP20]], align 4
// CHECK-USE-I386-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP22]], align 4
// CHECK-USE-I386-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[I]], i32** [[TMP24]], align 4
// CHECK-USE-I386-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP25]], align 4
// CHECK-USE-I386-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK-USE-I386-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP28]], align 4
// CHECK-USE-I386-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[J]], i32** [[TMP30]], align 4
// CHECK-USE-I386-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP31]], align 4
// CHECK-USE-I386-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP32]], align 4
// CHECK-USE-I386-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-USE-I386-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[A]], i32** [[TMP34]], align 4
// CHECK-USE-I386-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-USE-I386-NEXT:    [[TMP36:%.*]] = bitcast i8** [[TMP35]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[A]], i32** [[TMP36]], align 4
// CHECK-USE-I386-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP37]], align 4
// CHECK-USE-I386-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP38]], align 4
// CHECK-USE-I386-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-USE-I386-NEXT:    [[TMP40:%.*]] = bitcast i8** [[TMP39]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP40]], align 4
// CHECK-USE-I386-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-USE-I386-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[I1]], i32** [[TMP42]], align 4
// CHECK-USE-I386-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-USE-I386-NEXT:    store i64 [[TMP14]], i64* [[TMP43]], align 4
// CHECK-USE-I386-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP44]], align 4
// CHECK-USE-I386-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-USE-I386-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP46]], align 4
// CHECK-USE-I386-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-USE-I386-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[I1]], i32** [[TMP48]], align 4
// CHECK-USE-I386-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP49]], align 4
// CHECK-USE-I386-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 5
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP50]], align 4
// CHECK-USE-I386-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK-USE-I386-NEXT:    [[TMP52:%.*]] = bitcast i8** [[TMP51]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP52]], align 4
// CHECK-USE-I386-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK-USE-I386-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[J2]], i32** [[TMP54]], align 4
// CHECK-USE-I386-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP55]], align 4
// CHECK-USE-I386-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 6
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP56]], align 4
// CHECK-USE-I386-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP60:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1:[0-9]+]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654.region_id, i32 7, i8** [[TMP57]], i8** [[TMP58]], i64* [[TMP59]], i64* getelementptr inbounds ([7 x i64], [7 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-USE-I386-NEXT:    [[TMP61:%.*]] = icmp ne i32 [[TMP60]], 0
// CHECK-USE-I386-NEXT:    br i1 [[TMP61]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-USE-I386:       omp_offload.failed:
// CHECK-USE-I386-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654(%struct.ST* [[ST1]], i32* [[A]], %struct.ST* [[ST2]]) #[[ATTR2:[0-9]+]]
// CHECK-USE-I386-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-USE-I386:       omp_offload.cont:
// CHECK-USE-I386-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP63:%.*]] = bitcast i8** [[TMP62]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[A]], i32** [[TMP63]], align 4
// CHECK-USE-I386-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[A]], i32** [[TMP65]], align 4
// CHECK-USE-I386-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS5]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP66]], align 4
// CHECK-USE-I386-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP69:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668.region_id, i32 1, i8** [[TMP67]], i8** [[TMP68]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.1, i32 0, i32 0), i8** null, i8** null)
// CHECK-USE-I386-NEXT:    [[TMP70:%.*]] = icmp ne i32 [[TMP69]], 0
// CHECK-USE-I386-NEXT:    br i1 [[TMP70]], label [[OMP_OFFLOAD_FAILED6:%.*]], label [[OMP_OFFLOAD_CONT7:%.*]]
// CHECK-USE-I386:       omp_offload.failed6:
// CHECK-USE-I386-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668(i32* [[A]]) #[[ATTR2]]
// CHECK-USE-I386-NEXT:    br label [[OMP_OFFLOAD_CONT7]]
// CHECK-USE-I386:       omp_offload.cont7:
// CHECK-USE-I386-NEXT:    ret void
//
// CHECK-NOUSE-PPC64LE-LABEL: @_Z20explicit_maps_singlei(
// CHECK-NOUSE-PPC64LE-NEXT:  entry:
// CHECK-NOUSE-PPC64LE-NEXT:    [[II_ADDR:%.*]] = alloca i32, align 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[ST1:%.*]] = alloca [[STRUCT_ST:%.*]], align 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[ST2:%.*]] = alloca [[STRUCT_ST]], align 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [7 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [7 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [7 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [7 x i64], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS3:%.*]] = alloca [1 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS4:%.*]] = alloca [1 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS5:%.*]] = alloca [1 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    store i32 [[II:%.*]], i32* [[II_ADDR]], align 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP0:%.*]] = load i32, i32* [[II_ADDR]], align 4
// CHECK-NOUSE-PPC64LE-NEXT:    store i32 [[TMP0]], i32* [[A]], align 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP1:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP2:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP3:%.*]] = bitcast i32* [[TMP1]] to i8*
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP3]] to i64
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP5:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP6:%.*]] = sub i64 [[TMP4]], [[TMP5]]
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP7:%.*]] = sdiv exact i64 [[TMP6]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-NOUSE-PPC64LE-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[J2:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP8:%.*]] = getelementptr i32, i32* [[J2]], i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP9:%.*]] = bitcast i32* [[I1]] to i8*
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP10:%.*]] = bitcast i32* [[TMP8]] to i8*
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP11:%.*]] = ptrtoint i8* [[TMP10]] to i64
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP12:%.*]] = ptrtoint i8* [[TMP9]] to i64
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP16]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP18]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 [[TMP7]], i64* [[TMP19]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP20]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP22]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP24]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP25]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP26]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP28]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[J]], i32** [[TMP30]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP31]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP32]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP34]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP36:%.*]] = bitcast i8** [[TMP35]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP36]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP37]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP38]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP40:%.*]] = bitcast i8** [[TMP39]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP40]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[I1]], i32** [[TMP42]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 [[TMP14]], i64* [[TMP43]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP44]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP46]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[I1]], i32** [[TMP48]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP49]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 5
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP50]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP52:%.*]] = bitcast i8** [[TMP51]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP52]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[J2]], i32** [[TMP54]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP55]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 6
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP56]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP60:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1:[0-9]+]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654.region_id, i32 7, i8** [[TMP57]], i8** [[TMP58]], i64* [[TMP59]], i64* getelementptr inbounds ([7 x i64], [7 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP61:%.*]] = icmp ne i32 [[TMP60]], 0
// CHECK-NOUSE-PPC64LE-NEXT:    br i1 [[TMP61]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-NOUSE-PPC64LE:       omp_offload.failed:
// CHECK-NOUSE-PPC64LE-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654() #[[ATTR2:[0-9]+]]
// CHECK-NOUSE-PPC64LE-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-NOUSE-PPC64LE:       omp_offload.cont:
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP63:%.*]] = bitcast i8** [[TMP62]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP63]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[A]], i32** [[TMP65]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS5]], i64 0, i64 0
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP66]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP69:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668.region_id, i32 1, i8** [[TMP67]], i8** [[TMP68]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.1, i32 0, i32 0), i8** null, i8** null)
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP70:%.*]] = icmp ne i32 [[TMP69]], 0
// CHECK-NOUSE-PPC64LE-NEXT:    br i1 [[TMP70]], label [[OMP_OFFLOAD_FAILED6:%.*]], label [[OMP_OFFLOAD_CONT7:%.*]]
// CHECK-NOUSE-PPC64LE:       omp_offload.failed6:
// CHECK-NOUSE-PPC64LE-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668() #[[ATTR2]]
// CHECK-NOUSE-PPC64LE-NEXT:    br label [[OMP_OFFLOAD_CONT7]]
// CHECK-NOUSE-PPC64LE:       omp_offload.cont7:
// CHECK-NOUSE-PPC64LE-NEXT:    ret void
//
// CHECK-NOUSE-I386-LABEL: @_Z20explicit_maps_singlei(
// CHECK-NOUSE-I386-NEXT:  entry:
// CHECK-NOUSE-I386-NEXT:    [[II_ADDR:%.*]] = alloca i32, align 4
// CHECK-NOUSE-I386-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK-NOUSE-I386-NEXT:    [[ST1:%.*]] = alloca [[STRUCT_ST:%.*]], align 4
// CHECK-NOUSE-I386-NEXT:    [[ST2:%.*]] = alloca [[STRUCT_ST]], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [7 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [7 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [7 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [7 x i64], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS3:%.*]] = alloca [1 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_PTRS4:%.*]] = alloca [1 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_MAPPERS5:%.*]] = alloca [1 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    store i32 [[II:%.*]], i32* [[II_ADDR]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP0:%.*]] = load i32, i32* [[II_ADDR]], align 4
// CHECK-NOUSE-I386-NEXT:    store i32 [[TMP0]], i32* [[A]], align 4
// CHECK-NOUSE-I386-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST1]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP1:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP2:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-NOUSE-I386-NEXT:    [[TMP3:%.*]] = bitcast i32* [[TMP1]] to i8*
// CHECK-NOUSE-I386-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP3]] to i64
// CHECK-NOUSE-I386-NEXT:    [[TMP5:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-NOUSE-I386-NEXT:    [[TMP6:%.*]] = sub i64 [[TMP4]], [[TMP5]]
// CHECK-NOUSE-I386-NEXT:    [[TMP7:%.*]] = sdiv exact i64 [[TMP6]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-NOUSE-I386-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[J2:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[ST2]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP8:%.*]] = getelementptr i32, i32* [[J2]], i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP9:%.*]] = bitcast i32* [[I1]] to i8*
// CHECK-NOUSE-I386-NEXT:    [[TMP10:%.*]] = bitcast i32* [[TMP8]] to i8*
// CHECK-NOUSE-I386-NEXT:    [[TMP11:%.*]] = ptrtoint i8* [[TMP10]] to i64
// CHECK-NOUSE-I386-NEXT:    [[TMP12:%.*]] = ptrtoint i8* [[TMP9]] to i64
// CHECK-NOUSE-I386-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK-NOUSE-I386-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-NOUSE-I386-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP16]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP18:%.*]] = bitcast i8** [[TMP17]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[I]], i32** [[TMP18]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    store i64 [[TMP7]], i64* [[TMP19]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP20]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP22]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP24:%.*]] = bitcast i8** [[TMP23]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[I]], i32** [[TMP24]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP25]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP26]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    [[TMP28:%.*]] = bitcast i8** [[TMP27]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[ST1]], %struct.ST** [[TMP28]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[J]], i32** [[TMP30]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP31]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP32]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK-NOUSE-I386-NEXT:    [[TMP34:%.*]] = bitcast i8** [[TMP33]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[A]], i32** [[TMP34]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK-NOUSE-I386-NEXT:    [[TMP36:%.*]] = bitcast i8** [[TMP35]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[A]], i32** [[TMP36]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP37]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP38]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK-NOUSE-I386-NEXT:    [[TMP40:%.*]] = bitcast i8** [[TMP39]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP40]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK-NOUSE-I386-NEXT:    [[TMP42:%.*]] = bitcast i8** [[TMP41]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[I1]], i32** [[TMP42]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 4
// CHECK-NOUSE-I386-NEXT:    store i64 [[TMP14]], i64* [[TMP43]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP44]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 5
// CHECK-NOUSE-I386-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP46]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 5
// CHECK-NOUSE-I386-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[I1]], i32** [[TMP48]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 5
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP49]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 5
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP50]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 6
// CHECK-NOUSE-I386-NEXT:    [[TMP52:%.*]] = bitcast i8** [[TMP51]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[ST2]], %struct.ST** [[TMP52]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 6
// CHECK-NOUSE-I386-NEXT:    [[TMP54:%.*]] = bitcast i8** [[TMP53]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[J2]], i32** [[TMP54]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 6
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP55]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 6
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP56]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [7 x i8*], [7 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [7 x i64], [7 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP60:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1:[0-9]+]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654.region_id, i32 7, i8** [[TMP57]], i8** [[TMP58]], i64* [[TMP59]], i64* getelementptr inbounds ([7 x i64], [7 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null)
// CHECK-NOUSE-I386-NEXT:    [[TMP61:%.*]] = icmp ne i32 [[TMP60]], 0
// CHECK-NOUSE-I386-NEXT:    br i1 [[TMP61]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-NOUSE-I386:       omp_offload.failed:
// CHECK-NOUSE-I386-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l654() #[[ATTR2:[0-9]+]]
// CHECK-NOUSE-I386-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-NOUSE-I386:       omp_offload.cont:
// CHECK-NOUSE-I386-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP63:%.*]] = bitcast i8** [[TMP62]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[A]], i32** [[TMP63]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP65:%.*]] = bitcast i8** [[TMP64]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[A]], i32** [[TMP65]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_MAPPERS5]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP66]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_BASEPTRS3]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [1 x i8*], [1 x i8*]* [[DOTOFFLOAD_PTRS4]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP69:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668.region_id, i32 1, i8** [[TMP67]], i8** [[TMP68]], i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([1 x i64], [1 x i64]* @.offload_maptypes.1, i32 0, i32 0), i8** null, i8** null)
// CHECK-NOUSE-I386-NEXT:    [[TMP70:%.*]] = icmp ne i32 [[TMP69]], 0
// CHECK-NOUSE-I386-NEXT:    br i1 [[TMP70]], label [[OMP_OFFLOAD_FAILED6:%.*]], label [[OMP_OFFLOAD_CONT7:%.*]]
// CHECK-NOUSE-I386:       omp_offload.failed6:
// CHECK-NOUSE-I386-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z20explicit_maps_singlei_l668() #[[ATTR2]]
// CHECK-NOUSE-I386-NEXT:    br label [[OMP_OFFLOAD_CONT7]]
// CHECK-NOUSE-I386:       omp_offload.cont7:
// CHECK-NOUSE-I386-NEXT:    ret void
//
void explicit_maps_single(int ii) {

  // Map of a scalar.
  int a = ii;

  struct ST st1;
  struct ST st2;

  // Make sure the struct picks up ompx_hold even if another element of the
  // struct doesn't have ompx_hold.
  #pragma omp target map(tofrom : st1.i) \
                     map(ompx_hold, tofrom : a, st1.j, st2.i) \
                     map(tofrom : st2.j)
  {
#ifdef USE
    st1.i++;
    a++;
    st1.j++;
    st2.i++;
    st2.j++;
#endif
  }

  // Always Close Hold.
  #pragma omp target map(always close ompx_hold tofrom: a)
  {
#ifdef USE
    a++;
#endif
  }
}

// CHECK-USE-PPC64LE-LABEL: @_ZN2ST20test_present_membersEv(
// CHECK-USE-PPC64LE-NEXT:  entry:
// CHECK-USE-PPC64LE-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.ST*, align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK-USE-PPC64LE-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[THIS:%.*]], %struct.ST** [[THIS_ADDR]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[THIS1:%.*]] = load %struct.ST*, %struct.ST** [[THIS_ADDR]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST:%.*]], %struct.ST* [[THIS1]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[THIS1]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP0:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP1:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-USE-PPC64LE-NEXT:    [[TMP2:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-USE-PPC64LE-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-USE-PPC64LE-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK-USE-PPC64LE-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK-USE-PPC64LE-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-USE-PPC64LE-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP8]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP10]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP12]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP14]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP16]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP17]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-USE-PPC64LE-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.ST**
// CHECK-USE-PPC64LE-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP20]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-USE-PPC64LE-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32**
// CHECK-USE-PPC64LE-NEXT:    store i32* [[J]], i32** [[TMP22]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-USE-PPC64LE-NEXT:    store i64 4, i64* [[TMP23]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-USE-PPC64LE-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK-USE-PPC64LE-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-PPC64LE-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-USE-PPC64LE-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK-USE-PPC64LE-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-USE-PPC64LE:       omp_offload.failed:
// CHECK-USE-PPC64LE-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919(%struct.ST* [[THIS1]]) #[[ATTR2]]
// CHECK-USE-PPC64LE-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-USE-PPC64LE:       omp_offload.cont:
// CHECK-USE-PPC64LE-NEXT:    ret void
//
// CHECK-USE-I386-LABEL: @_ZN2ST20test_present_membersEv(
// CHECK-USE-I386-NEXT:  entry:
// CHECK-USE-I386-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.ST*, align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK-USE-I386-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK-USE-I386-NEXT:    store %struct.ST* [[THIS:%.*]], %struct.ST** [[THIS_ADDR]], align 4
// CHECK-USE-I386-NEXT:    [[THIS1:%.*]] = load %struct.ST*, %struct.ST** [[THIS_ADDR]], align 4
// CHECK-USE-I386-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST:%.*]], %struct.ST* [[THIS1]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[THIS1]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP0:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-USE-I386-NEXT:    [[TMP1:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-USE-I386-NEXT:    [[TMP2:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-USE-I386-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-USE-I386-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK-USE-I386-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK-USE-I386-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-USE-I386-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP8]], align 4
// CHECK-USE-I386-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[I]], i32** [[TMP10]], align 4
// CHECK-USE-I386-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 4
// CHECK-USE-I386-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP12]], align 4
// CHECK-USE-I386-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP14]], align 4
// CHECK-USE-I386-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[I]], i32** [[TMP16]], align 4
// CHECK-USE-I386-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP17]], align 4
// CHECK-USE-I386-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK-USE-I386-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.ST**
// CHECK-USE-I386-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP20]], align 4
// CHECK-USE-I386-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32**
// CHECK-USE-I386-NEXT:    store i32* [[J]], i32** [[TMP22]], align 4
// CHECK-USE-I386-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    store i64 4, i64* [[TMP23]], align 4
// CHECK-USE-I386-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK-USE-I386-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK-USE-I386-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-USE-I386-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-USE-I386-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK-USE-I386-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-USE-I386:       omp_offload.failed:
// CHECK-USE-I386-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919(%struct.ST* [[THIS1]]) #[[ATTR2]]
// CHECK-USE-I386-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-USE-I386:       omp_offload.cont:
// CHECK-USE-I386-NEXT:    ret void
//
// CHECK-NOUSE-PPC64LE-LABEL: @_ZN2ST20test_present_membersEv(
// CHECK-NOUSE-PPC64LE-NEXT:  entry:
// CHECK-NOUSE-PPC64LE-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.ST*, align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[THIS:%.*]], %struct.ST** [[THIS_ADDR]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[THIS1:%.*]] = load %struct.ST*, %struct.ST** [[THIS_ADDR]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST:%.*]], %struct.ST* [[THIS1]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[THIS1]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP0:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP1:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP2:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP8]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP10]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP12]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP14]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[I]], i32** [[TMP16]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP17]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.ST**
// CHECK-NOUSE-PPC64LE-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP20]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32**
// CHECK-NOUSE-PPC64LE-NEXT:    store i32* [[J]], i32** [[TMP22]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-NOUSE-PPC64LE-NEXT:    store i64 4, i64* [[TMP23]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK-NOUSE-PPC64LE-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-NOUSE-PPC64LE-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK-NOUSE-PPC64LE-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-NOUSE-PPC64LE:       omp_offload.failed:
// CHECK-NOUSE-PPC64LE-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919() #[[ATTR2]]
// CHECK-NOUSE-PPC64LE-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-NOUSE-PPC64LE:       omp_offload.cont:
// CHECK-NOUSE-PPC64LE-NEXT:    ret void
//
// CHECK-NOUSE-I386-LABEL: @_ZN2ST20test_present_membersEv(
// CHECK-NOUSE-I386-NEXT:  entry:
// CHECK-NOUSE-I386-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.ST*, align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK-NOUSE-I386-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[THIS:%.*]], %struct.ST** [[THIS_ADDR]], align 4
// CHECK-NOUSE-I386-NEXT:    [[THIS1:%.*]] = load %struct.ST*, %struct.ST** [[THIS_ADDR]], align 4
// CHECK-NOUSE-I386-NEXT:    [[I:%.*]] = getelementptr inbounds [[STRUCT_ST:%.*]], %struct.ST* [[THIS1]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[J:%.*]] = getelementptr inbounds [[STRUCT_ST]], %struct.ST* [[THIS1]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP0:%.*]] = getelementptr i32, i32* [[J]], i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP1:%.*]] = bitcast i32* [[I]] to i8*
// CHECK-NOUSE-I386-NEXT:    [[TMP2:%.*]] = bitcast i32* [[TMP0]] to i8*
// CHECK-NOUSE-I386-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK-NOUSE-I386-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK-NOUSE-I386-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK-NOUSE-I386-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK-NOUSE-I386-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP8]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[I]], i32** [[TMP10]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP12]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP14]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[I]], i32** [[TMP16]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP17]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.ST**
// CHECK-NOUSE-I386-NEXT:    store %struct.ST* [[THIS1]], %struct.ST** [[TMP20]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to i32**
// CHECK-NOUSE-I386-NEXT:    store i32* [[J]], i32** [[TMP22]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    store i64 4, i64* [[TMP23]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK-NOUSE-I386-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK-NOUSE-I386-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK-NOUSE-I386-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_mapper(%struct.ident_t* @[[GLOB1]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null)
// CHECK-NOUSE-I386-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK-NOUSE-I386-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK-NOUSE-I386:       omp_offload.failed:
// CHECK-NOUSE-I386-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2ST20test_present_membersEv_l919() #[[ATTR2]]
// CHECK-NOUSE-I386-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK-NOUSE-I386:       omp_offload.cont:
// CHECK-NOUSE-I386-NEXT:    ret void
//
void ST::test_present_members() {
  // Make sure the struct picks up ompx_hold even if another element of the
  // struct doesn't have ompx_hold.
  #pragma omp target map(tofrom : i) map(ompx_hold, tofrom : j)
  {
#ifdef USE
    i++;
    j++;
#endif
  }
}

#endif
