//start of LittleEndian.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LittleEndian.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.InputStream;
import java.io.OutputStream;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.ArrayIndexOutOfBoundsException;


/**
 * gGfBA
 * oCgz InputStream, OutputStream
 * ɃANZX郁\bh񋟂郆[eBeBNXB
 * 
 * <pre>
 * -- revision history --
 * $Log: LittleEndian.java,v $
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [change]
 *     writeByte(), readByte() PB
 * [maintenance]
 *     \[X
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class LittleEndian{


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LittleEndian()
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^BgpsB
     */
    private LittleEndian(){ }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  read from byte array
    //------------------------------------------------------------------
    //  public static final int readShort( byte[] ByteArray, int index )
    //  public static final int readInt( byte[] ByteArray, int index )
    //  public static final long readLong( byte[] ByteArray, int index )
    //------------------------------------------------------------------
    /**
     * ByteArray  index ̈ʒu gGfBA
     * 2oCglǂݏoBǂݏoꂽ 2oCgl 
     * 0x0000`0xFFFFɃ}bvB
     *
     * @param ByteArray oCgz
     * @param index     ByteArraỹf[^̊Jnʒu
     * 
     * @return ǂݏoꂽ2oCgl
     * 
     * @exception ArrayIndexOutOfBoundsException
     *                  indexn܂f[^ 
     *                  ByteArray͈͓̔ɖꍇB
     */
    public static final int readShort( byte[] ByteArray, int index ){
        return   ( ByteArray[index]       & 0xFF )
               | ( ( ByteArray[index + 1] & 0xFF ) << 8 );
    }

    /**
     * ByteArray  index ̈ʒu烊gGfBA
     * 4oCglǂݏoB
     *
     * @param ByteArray oCgz
     * @param index     ByteArraỹf[^̊Jnʒu
     * 
     * @return ǂݏoꂽ4oCgl
     * 
     * @exception ArrayIndexOutOfBoundsException
     *                  indexn܂f[^ 
     *                  ByteArray͈͓̔ɖꍇB
     */
    public static final int readInt( byte[] ByteArray, int index ){
        return   (   ByteArray[index]     & 0xFF )
               | ( ( ByteArray[index + 1] & 0xFF ) <<  8 )
               | ( ( ByteArray[index + 2] & 0xFF ) << 16 )
               | (   ByteArray[index + 3]          << 24 );
    }

    /**
     * ByteArray  index ̈ʒu烊gGfBA
     * 8oCglǂݏoB
     * 
     * @param ByteArray oCgz
     * @param index     ByteArraỹf[^̊Jnʒu
     * 
     * @return ǂݏoꂽ8oCgl
     * 
     * @exception ArrayIndexOutOfBoundsException
     *                  indexn܂f[^ 
     *                  ByteArray͈͓̔ɖꍇB
     */
    public static final long readLong( byte[] ByteArray, int index ){
        return   ( (long)LittleEndian.readInt( ByteArray, index ) & 0xFFFFFFFFL )
               | ( (long)LittleEndian.readInt( ByteArray, index + 4 ) << 32L );
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  read from InputStream
    //------------------------------------------------------------------
    //  public static final int readShort( InputStream in )
    //  public static final int readInt( InputStream in )
    //  public static final long readLong( InputStream in )
    //------------------------------------------------------------------
    /**
     * ̓Xg[ in  gGfBA
     * 2bytelǂݏoB
     * 
     * @param in ̓Xg[
     * 
     * @return ǂݏoꂽ2bytel
     * 
     * @exception EOFException
     *                   End Of StreamɒBĂA
     *                  ǂݍ݂̓r End Of StreamɒBB
     *                  ǂݍݓr̃f[^͏B
     * @exception IOException
     *                  o̓G[ꍇ
     */
    public static final int  readShort( InputStream in )
                                                throws IOException {
        int byte1 = in.read();
        int byte2 = in.read();

        if( 0 <= byte1 && 0 <= byte2 ){
            return     ( byte1 & 0xFF )
                   | ( ( byte2 & 0xFF ) << 8 );
        }else{
            throw new EOFException();
        }
    }

    /**
     * ̓Xg[ in  gGfBA
     * 4bytelǂݏoB
     * 
     * @param in ̓Xg[
     * 
     * @return ǂݏoꂽ4bytel
     * 
     * @exception EOFException
     *                   End Of StreamɒBĂA
     *                  ǂݍ݂̓r End Of StreamɒBB
     *                  ǂݍݓr̃f[^͏B
     * @exception IOException
     *                  o̓G[ꍇ
     */
    public static final int  readInt( InputStream in )
                                                throws IOException {
        int byte1 = in.read();
        int byte2 = in.read();
        int byte3 = in.read();
        int byte4 = in.read();

        if( 0 <= byte1 && 0 <= byte2 && 0 <= byte3 && 0 <= byte4 ){
            return     ( byte1 & 0xFF )
                   | ( ( byte2 & 0xFF ) <<  8 )
                   | ( ( byte3 & 0xFF ) << 16 )
                   | (   byte4          << 24 );
        }else{
            throw new EOFException();
        }
    }

    /**
     * ̓Xg[ in  gGfBA
     * 8bytelǂݏoB
     * 
     * @param in ̓Xg[
     * 
     * @return ǂݏoꂽ8bytel
     * 
     * @exception EOFException
     *                   End Of StreamɒBĂA
     *                  ǂݍ݂̓r End Of StreamɒBB
     *                  ǂݍݓr̃f[^͏B
     * @exception IOException
     *                  o̓G[ꍇ
     */
    public static final long readLong( InputStream in )
                                                throws IOException {

        return   ( (long)LittleEndian.readInt( in ) & 0xFFFFFFFFL )
               | ( (long)LittleEndian.readInt( in ) << 32 );

    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  write to byte array
    //------------------------------------------------------------------
    //  public static final void writeShort( byte[] ByteArray, int index, int value )
    //  public static final void writeInt( byte[] ByteArray, int index, int value )
    //  public static final void writeLong( byte[] ByteArray, int index, long value )
    //------------------------------------------------------------------
    /**
     * ByteArray  index ̈ʒuɃgGfBA
     * 2byteloB
     * 
     * @param ByteArray oCgz
     * @param index     ByteArraỹf[^ވʒu
     * @param value      2bytel
     * 
     * @exception ArrayIndexOutOfBoundsException
     *                  indexn܂f[^ 
     *                  ByteArray͈͓̔ɖꍇB
     */
    public static final void writeShort( byte[] ByteArray, 
                                         int    index, 
                                         int    value ){

        if( 0 <= index && index + 1 < ByteArray.length ){
            ByteArray[index]     = (byte)value;
            ByteArray[index + 1] = (byte)( value >> 8 );
        }else{
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /**
     * ByteArray  index ̈ʒuɃgGfBA
     * 4byteloB
     * 
     * @param ByteArray oCgz
     * @param index     ByteArraỹf[^ވʒu
     * @param value      4bytel
     * 
     * @exception ArrayIndexOutOfBoundsException
     *                  indexn܂f[^ 
     *                  ByteArray͈͓̔ɖꍇB
     */
    public static final void writeInt( byte[] ByteArray, 
                                       int    index, 
                                       int    value ){

        if( 0 <= index && index + 3 < ByteArray.length ){
            ByteArray[index]     = (byte)value;
            ByteArray[index + 1] = (byte)( value >>  8 );
            ByteArray[index + 2] = (byte)( value >> 16 );
            ByteArray[index + 3] = (byte)( value >> 24 );
        }else{
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    /**
     * ByteArray  index ̈ʒuɃgGfBA
     * 8byteloB
     * 
     * @param ByteArray oCgz
     * @param index     ByteArraỹf[^ވʒu
     * @param value      8bytel
     * 
     * @exception ArrayIndexOutOfBoundsException
     *                  indexn܂f[^ 
     *                  ByteArray͈͓̔ɖꍇB
     */
    public static final void writeLong( byte[] ByteArray, 
                                        int    index, 
                                        long   value ){
        if( 0 <= index && index + 7 < ByteArray.length ){
            LittleEndian.writeInt( ByteArray, index, (int)value );
            LittleEndian.writeInt( ByteArray, index + 4, (int)(value >> 32) );
        }else{
            throw new ArrayIndexOutOfBoundsException();
        }
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  write to OutputStream
    //------------------------------------------------------------------
    //  public static final void writeShort( OutputStream out, int value )
    //  public static final void writeInt( OutputStream out, int value )
    //  public static final void writeLong( OutputStream out, long value )
    //------------------------------------------------------------------
    /**
     * o̓Xg[ out  gGfBA
     * 2oCgoB
     * 
     * @param out   o̓Xg[
     * @param value o2oCgl
     *
     * @exception IOException
     *                  o̓G[ꍇ
     */
    public static final void writeShort( OutputStream out, int value )
                                                throws IOException {
        out.write( value & 0xFF );
        out.write( ( value >> 8 ) & 0xFF );
    }

    /**
     * o̓Xg[ out  gGfBA
     * 4oCgloB
     * 
     * @param out   o̓Xg[
     * @param value o1oCgl
     *
     * @exception IOException
     *                  o̓G[ꍇ
     */
    public static final void writeInt( OutputStream out, int value )
                                                throws IOException {
        out.write( value & 0xFF );
        out.write( ( value >>  8 ) & 0xFF );
        out.write( ( value >> 16 ) & 0xFF );
        out.write( value >>> 24 );
    }

    /**
     * o̓Xg[ out  gGfBA
     * 8oCgloB
     * 
     * @param out   o̓Xg[
     * @param value o1oCgl
     *
     * @exception IOException
     *                  o̓G[ꍇ
     */
    public static final void writeLong( OutputStream out, long value )
                                                throws IOException {
        int low = (int)value;
        int hi  = (int)( value >> 32 );

        out.write( low & 0xFF );
        out.write( ( low >>  8 ) & 0xFF );
        out.write( ( low >> 16 ) & 0xFF );
        out.write( low >>> 24 );
        out.write( hi & 0xFF );
        out.write( ( hi >>  8 ) & 0xFF );
        out.write( ( hi >> 16 ) & 0xFF );
        out.write( hi >>> 24 );
    }

}
//end of LittleEndian.java
