% KEY2JWK(1) key2jwk User Manual | LibJWT C Library

# NAME

**key2jwk** - Generate a JSON Web Key Set

# SYNOPSIS

| **key2jwk**  **\[options]** \<FILE\> [FILE]...

# DESCRIPTION

**key2jwk** Generates a JSON Web Key Set from one or more keys in PEM or DER
format.

This program will parse PEM/DER key files (public and private) into JSON Web
Keys and output a JWK Set. Note that HMAC keys are *guessed* based on them
not being parsed by OpenSSL. This may cause some issues. You can disable this
with the **-m** option.

_HS256_, _HS384_, and _HS512_ are assumed based on the key size and are
expected to be a file with binary data. Using file size in bytes:

_**HS256**_: size >= 32 AND size < 48

_**HS384**_: size >= 48 AND size < 64

_**HS512**_: size >= 64

The **-o** options is required for output. If the file exists, it will not be
overwritten. You can use **\-\-output -** to write to _stdout_. If you write
to _stdout_, all other messages will be written to _stderr_.

RSA keys will not have an algorithm set as they are valid for _RS256_, _RS384_,
and _RS512_, however, RSA-PSS keys will be set to _PS256_, since otherwise they
will look no different than an RSA key. RSA keys must be at least 1024 bits.

Private keys will have **sign** added to the **key_ops** array while public
keys will have the **use** attribute set to **sig**.

All keys will get a generated randomized uuidv4 **kid** attribute unless you
use the **-k** option.

Example output:

    $ key2jwk -q -o - eddsa_key_ed25519.pem
    {
      "libjwt.io:comment": "Generated by LibJWT 2.9.99",
      "libjwt.io:date": "Sun Jan 12 23:50:24 2025",
      "libjwt.io:hostname": "maClara.local",
      "keys": [
        {
          "key_ops": [
            "sign"
          ],
          "kid": "d74a55b0-631a-4dfb-8842-cecfcb50e728",
          "kty": "OKP",
          "crv": "Ed25519",
          "alg": "EdDSA",
          "d": "XY5oUZqGWVZhX7J09hG-rRnAKXiw1g_aBh-Bc52KZ_Y"
        }
      ]
    }

## Options

**\-h**, **\-\-help**
  ~ Show common options and quit.

**\-l**, **\-\-list**
  ~ List all supported algorithms that can be passed to the **-a** option
  and quit.

**\-q**, **\-\-quiet**
  ~ Do not output anything except for hard errors (and the JWKS).

**\-k**, **\-\-disable-kid**
  ~ Disable generating **kid** attribute.

**\-m**, **\-\-disable-hmac**
  ~ Disable falling back to HAMC for key files that OpenSSL cannot read.

**\-o** _FILE_, **\-\-output**=_FILE_
  ~ Use _FILE_ to write the JWKS. Use **-** to write to stdout.

# BUGS

See GitHub Issues: <https://github.com/benmcollins/libjwt/issues>

# AUTHOR

**key2jwk** written by Ben Collins <bcollins@libjwt.io>.

# SEE ALSO

**jwt-verify(1)**, **jwt-generate(1)**, **jwk2key(1)**
