/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QWidgetAction>
#include <QLineEdit>
#include <QValidator>


/////////////////////// pappsomspp includes


/////////////////////// Local includes


namespace msxps
{
namespace minexpert
{


class LabelledNumberLineEditAction : public QWidgetAction
{
  Q_OBJECT

  public:
  LabelledNumberLineEditAction(const QString &label,
                              double value,
                              double minimum,
                              double maximum,
                              double decimals = 2,
                              bool is_double = true,
                              QObject *parent = nullptr);

  virtual ~LabelledNumberLineEditAction();

  QLineEdit *getWidget() const;
  QString getLabel() const;
  QVariant getValue() const;

  private:
  QString m_label;
  double m_minimum;
  double m_maximum;
  int m_decimals = 2;
  bool m_isDouble = false;
  QLineEdit *mpa_lineEdit = nullptr;
  QValidator *mpa_validator = nullptr;
};


} // namespace minexpert

} // namespace msxps
