/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.construction;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import rene.gui.ButtonAction;
import rene.gui.CheckboxMenuItemAction;
import rene.gui.ChoiceAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.MenuItemAction;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.lister.Lister;
import rene.lister.ListerMouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.dialogs.ObjectsEditDialog;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.ExpressionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class ConstructionDisplayPanel
extends MyPanel
implements DoActionListener,
ActionListener,
ClipboardOwner {
    Lister V;
    Vector W;
    Construction C;
    ZirkelCanvas ZC;
    Choice Ch;
    CheckboxMenuItemAction Visible;
    boolean ShowVisible = true;
    CheckboxMenuItemAction Sort;
    CheckboxMenuItemAction Description;
    CheckboxMenuItemAction Size;
    CheckboxMenuItemAction Formula;
    public static String[] Choices = new String[]{"all", "points", "lines", "circles", "angles", "expressions", "other"};
    int State = 0;
    PopupMenu PM;
    Button Menu;

    public ConstructionDisplayPanel(ZirkelCanvas zirkelCanvas) {
        this.ZC = zirkelCanvas;
        this.C = this.ZC.getConstruction();
        this.V = new Lister();
        this.V.setMode(true, false, true, true);
        this.V.addActionListener(this);
        if (Global.Background != null) {
            this.V.setBackground(Global.Background);
        }
        this.V.setFont(Global.FixedFont);
        this.State = Global.getParameter("constructiondisplay.state", 0);
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new BorderLayout());
        this.Ch = new ChoiceAction(this, "choices");
        for (int i = 0; i < Choices.length; ++i) {
            this.Ch.add(Zirkel.name("constructiondisplay." + Choices[i]));
        }
        myPanel.add("Center", this.Ch);
        this.Ch.select(this.State);
        this.Menu = new ButtonAction(this, "?", "Menu");
        myPanel.add("East", this.Menu);
        this.add("North", new Panel3D(myPanel));
        this.setListerState();
        this.makePopup();
        this.add("Center", this.V);
    }

    public void reload() {
        this.V.clear();
        this.C = this.ZC.getConstruction();
        Enumeration enumeration = null;
        enumeration = Global.getParameter("constructiondisplay.sort", true) ? this.C.getSortedElements() : this.C.elements();
        this.W = new Vector();
        block9: while (enumeration.hasMoreElements()) {
            ConstructionObject constructionObject = (ConstructionObject)enumeration.nextElement();
            if (this.ShowVisible && constructionObject.mustHide(this.ZC) || Global.getParameter("restricted", false) && constructionObject.isSuperHidden()) continue;
            switch (this.State) {
                case 0: {
                    break;
                }
                case 1: {
                    if (constructionObject instanceof PointObject) break;
                    continue block9;
                }
                case 2: {
                    if (constructionObject instanceof PrimitiveLineObject && !(constructionObject instanceof FixedAngleObject)) break;
                    continue block9;
                }
                case 3: {
                    if (constructionObject instanceof PrimitiveCircleObject) break;
                    continue block9;
                }
                case 4: {
                    if (constructionObject instanceof AngleObject || constructionObject instanceof FixedAngleObject) break;
                    continue block9;
                }
                case 5: {
                    if (constructionObject instanceof ExpressionObject || constructionObject instanceof FunctionObject) break;
                    continue block9;
                }
                case 6: {
                    if (!(constructionObject instanceof PointObject) && !(constructionObject instanceof PrimitiveLineObject) && !(constructionObject instanceof PrimitiveCircleObject) && !(constructionObject instanceof AngleObject) && !(constructionObject instanceof ExpressionObject) && !(constructionObject instanceof FunctionObject)) break;
                    continue block9;
                }
            }
            this.V.addElement(constructionObject);
            this.W.addElement(constructionObject);
        }
        this.V.showLast();
        this.updateDisplay();
    }

    public void updateDisplay() {
        this.V.updateDisplay();
    }

    public void doAction(String string) {
        if (string.equals("Edit")) {
            int[] nArray = this.V.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            if (nArray.length == 1) {
                ((ConstructionObject)this.W.elementAt(nArray[0])).edit(this.ZC);
            } else {
                Vector vector = new Vector();
                for (int i = 0; i < nArray.length; ++i) {
                    vector.addElement(this.W.elementAt(nArray[i]));
                }
                ObjectsEditDialog objectsEditDialog = new ObjectsEditDialog(this.ZC.getFrame(), vector);
                objectsEditDialog.setVisible(true);
                this.ZC.validate();
            }
            this.ZC.repaint();
            this.reload();
        } else if (string.equals("EditConditions")) {
            int[] nArray = this.V.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            if (nArray.length == 1) {
                new EditConditionals(this.ZC.getFrame(), (ConstructionObject)this.W.elementAt(nArray[0]));
            } else {
                Vector vector = new Vector();
                for (int i = 0; i < nArray.length; ++i) {
                    vector.addElement(this.W.elementAt(nArray[i]));
                }
                new EditConditionals(this.ZC.getFrame(), vector);
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (string.equals("Copy")) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
                PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(byteArrayOutputStream), true);
                this.V.save(printWriter);
                printWriter.close();
                String string2 = byteArrayOutputStream.toString();
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string2);
                clipboard.setContents(stringSelection, this);
            }
            catch (Exception exception) {}
        } else if (string.equals("Delete")) {
            int[] nArray = this.V.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            Vector vector = new Vector();
            for (int i = 0; i < nArray.length; ++i) {
                vector.addElement(this.W.elementAt(nArray[i]));
            }
            this.ZC.delete(vector);
            this.ZC.repaint();
            this.ZC.reset();
            this.reload();
        } else if (string.equals("Hide")) {
            int[] nArray = this.V.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                ConstructionObject constructionObject;
                constructionObject.setHidden(!(constructionObject = (ConstructionObject)this.W.elementAt(nArray[i])).isHidden());
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (string.equals("SuperHide")) {
            int[] nArray = this.V.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                ConstructionObject constructionObject = (ConstructionObject)this.W.elementAt(nArray[i]);
                constructionObject.setSuperHidden(true);
            }
            this.ZC.repaint();
            this.updateDisplay();
        } else if (string.equals("HighLight")) {
            int[] nArray = this.V.getSelectedIndices();
            if (nArray.length == 0) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                ConstructionObject constructionObject = (ConstructionObject)this.W.elementAt(nArray[i]);
                constructionObject.setStrongSelected(true);
            }
            Graphics graphics = this.ZC.getGraphics();
            if (graphics != null) {
                this.ZC.paint(graphics);
                graphics.dispose();
                try {
                    Thread.sleep(400L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                ConstructionObject constructionObject = (ConstructionObject)this.W.elementAt(nArray[i]);
                constructionObject.setStrongSelected(false);
            }
            this.ZC.repaint();
        } else if (string.equals("Menu")) {
            this.displayPopup(this.V.L, 10, 10);
        }
        this.ZC.requestFocus();
    }

    public void itemToggleAction(String string) {
        if (string.equals("Sort")) {
            this.Sort.setState(!this.Sort.getState());
            this.itemAction("Sort", this.Sort.getState());
        } else if (string.equals("Visible")) {
            this.Visible.setState(!this.Visible.getState());
            this.itemAction("Visible", this.Visible.getState());
        }
    }

    public void itemAction(String string, boolean bl) {
        if (string.equals("Sort")) {
            Global.setParameter("constructiondisplay.sort", this.Sort.getState());
            this.reload();
        } else if (string.equals("Visible")) {
            this.ShowVisible = this.Visible.getState();
            this.reload();
        } else if (string.equals("Description")) {
            Global.setParameter("constructiondisplay.listerstate", 0);
            this.setListerState();
            this.updateDisplay();
        } else if (string.equals("Size")) {
            Global.setParameter("constructiondisplay.listerstate", 2);
            this.setListerState();
            this.updateDisplay();
        } else if (string.equals("Formula")) {
            Global.setParameter("constructiondisplay.listerstate", 1);
            this.setListerState();
            this.updateDisplay();
        } else if (bl) {
            this.State = this.Ch.getSelectedIndex();
            Global.setParameter("constructiondisplay.state", this.State);
            this.reload();
        }
    }

    public void setListerState() {
        int n = Global.getParameter("constructiondisplay.listerstate", 2);
        this.V.setState(n);
        if (this.PM != null) {
            this.Description.setState(n == 0);
            this.Size.setState(n == 2);
            this.Formula.setState(n == 1);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(Global.getParameter("options.constructiondisplay.width", 200), 400);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.V && actionEvent instanceof ListerMouseEvent) {
            ListerMouseEvent listerMouseEvent = (ListerMouseEvent)actionEvent;
            if (listerMouseEvent.rightMouse()) {
                this.displayPopup(listerMouseEvent.getEvent().getComponent(), listerMouseEvent.getEvent().getX(), listerMouseEvent.getEvent().getY());
            } else if (listerMouseEvent.clickCount() >= 2) {
                this.doAction("Edit");
            } else {
                this.doAction("HighLight");
            }
        }
    }

    public void displayPopup(Component component, int n, int n2) {
        this.PM.show(component, n, n2);
    }

    public void makePopup() {
        this.PM = new PopupMenu();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.edit"), "Edit"));
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.editconditions"), "EditConditions"));
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.hide"), "Hide"));
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.superhide"), "SuperHide"));
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.delete"), "Delete"));
        this.PM.addSeparator();
        this.Description = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.description"), "Description");
        this.Description.setState(Global.getParameter("constructiondisplay.description", false));
        this.PM.add(this.Description);
        this.Size = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.size"), "Size");
        this.Description.setState(Global.getParameter("constructiondisplay.size", true));
        this.PM.add(this.Size);
        this.Formula = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.formula"), "Formula");
        this.Description.setState(Global.getParameter("constructiondisplay.formula", false));
        this.PM.add(this.Formula);
        this.PM.addSeparator();
        this.PM.add(new MenuItemAction(this, Zirkel.name("constructiondisplay.copy"), "Copy"));
        this.V.L.add(this.PM);
        this.PM.addSeparator();
        this.Visible = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.visible"), "Visible");
        this.Visible.setState(true);
        this.PM.add(this.Visible);
        this.Sort = new CheckboxMenuItemAction(this, Zirkel.name("constructiondisplay.sorted"), "Sort");
        this.Sort.setState(Global.getParameter("constructiondisplay.sort", true));
        this.PM.add(this.Sort);
        this.setListerState();
    }

    public void showLast() {
        this.V.showLast();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void setListingBackground(Color color) {
        this.V.setListingBackground(color);
    }
}

