/*************************************************************************
 *  TinyFugue - programmable mud client
 *  Copyright (C) 1993, 1994 Ken Keys
 *
 *  TinyFugue (aka "tf") is protected under the terms of the GNU
 *  General Public License.  See the file "COPYING" for details.
 ************************************************************************/
/* $Id: port.h,v 35004.1 1995/04/30 01:05:34 hawkeye Exp $ */

#ifndef PORT_H
#define PORT_H

#ifdef hpux
# ifndef _HPUX_SOURCE
#  define _HPUX_SOURCE    /* Needed for stat() (and maybe others) on hpux 7.0 */
# endif
#endif

#ifndef _ALL_SOURCE
# define _ALL_SOURCE      /* Enables some "extensions" on AIX. */
#endif

#if __STDC__ - 0
# undef  HAVE_PROTOTYPES
# define HAVE_PROTOTYPES
#endif

#ifdef __GNUC__
# undef  HAVE_PROTOTYPES
# define HAVE_PROTOTYPES
#endif

#ifdef HAVE_PROTOTYPES
# define NDECL(f)        f(void)
# define FDECL(f, p)     f p
# ifdef HAVE_STDARG
#  define VDECL(f, p)     f p
# else
#  define VDECL(f, p)     f()
# endif
#else
# define NDECL(f)        f()
# define FDECL(f, p)     f()
# define VDECL(f, p)     f()
#endif

#ifdef HAVE_STDARG
# define VDEF(args)  args
#else
# define VDEF(args)  (va_alist)  va_dcl
#endif

/* These aren't neccessary, but may improve optimization, etc. */
#ifdef __GNUC__
# define INLINE __inline__
# if (__GNUC__ == 2 && __GNUC_MINOR__ >= 5) || (__GNUC__ > 2)
#  define GCC_2_5_OR_LATER
#  define PURE   __attribute__ ((const))
#  define NORET  __attribute__ ((noreturn))
# endif
#endif

#ifndef INLINE
# define INLINE
#endif
#ifndef PURE
# define PURE
#endif
#ifndef NORET
# define NORET
#endif


/* standard stuff */

#include <stdio.h>

#ifndef SEEK_SET
# define SEEK_SET 0
#endif


#undef GENERIC
#undef CONST

#if __STDC__ - 0
# define GENERIC void
# define CONST   const
#else
# define GENERIC char
# define CONST
#endif

#ifdef UNISTD_H
# include UNISTD_H
#endif

#ifdef STDLIB_H
# include STDLIB_H
#else
extern void free();
#endif

#include STRING_H

#ifndef HAVE_strchr
# ifdef HAVE_index
#  define strchr index
#  define strrchr rindex    /* assumed */
# endif
#endif

#ifndef HAVE_memcpy
# ifdef HAVE_bcopy
#  define memcpy(dst, src, len) bcopy((src), (dst), (len))
# endif
#endif


#ifdef HAVE_strcasecmp
# define cstrcmp   strcasecmp
#else
# ifdef HAVE_stricmp
#  define cstrcmp   stricmp
# else
#  ifdef HAVE_strcmpi
#   define cstrcmp   strcmpi
#  endif
# endif
#endif
#ifndef cstrcmp
extern int    FDECL(cstrcmp,(CONST char *s, CONST char *t));
#endif

#ifndef HAVE_strstr
  extern char *FDECL(strstr,(CONST char *s1, CONST char *s2));
#endif

#ifndef HAVE_strerror
extern int sys_nerr;
extern char *sys_errlist[];
# define strerror(n) (((n) > 0 && (n) < sys_nerr) ? sys_errlist[(n)] : \
    "unknown error")
#endif

#ifndef HAVE_fileno  /* occurs on at least one pre-POSIX SVr3-like platform */
# ifdef PLATFORM_UNIX
#  define fileno(p)  ((p)->_file)
# else
   /* Who knows what it should be elsewhere; it should already exist. */
# endif
#endif

#ifdef PLATFORM_OS2
# define HAVE_getcwd
# define getcwd _getcwd2   /* handles drive names */
# define chdir _chdir2     /* handles drive names */
#endif


extern char lowercase_values[], uppercase_values[];
#define lcase(x) ((char)lowercase_values[(unsigned char)(x)])
#define ucase(x) ((char)uppercase_values[(unsigned char)(x)])

/* ANSI allows struct assignment, but K&R1 didn't. */
#define structcpy(dst, src) \
    memcpy((GENERIC*)&(dst), (GENERIC*)&(src), sizeof(src))

/* RRAND(lo,hi) returns a random integer in the range [lo,hi].
 * RAND() returns a random integer in the range [0,TF_RAND_MAX].
 * SRAND() seeds the generator.
 * If random() exists, use it, because it is better than rand().
 * If not, we'll have to use rand(); if RAND_MAX isn't defined,
 * we'll have to use the modulus method instead of the division method.
 * Warning: RRAND() is undefined if hi < lo.
 * Warning: on Solaris 2.x, libucb contains a non-ansi rand() that does
 * not agree with RAND_MAX.  We must not link with -lucb.
 */

#ifdef HAVE_srandom
# include <math.h>
# define RAND()         (int)random()
# define SRAND(seed)    srandom(seed)
# define RRAND(lo,hi)   (RAND() % ((hi)-(lo)+1) + (lo))
#else
# ifdef HAVE_srand
#  define RAND()         rand()
#  define SRAND(seed)    srand(seed)
#  ifdef RAND_MAX
#   define RRAND(lo,hi)  ((hi)==(lo)) ? (hi) : \
                             ((RAND() / (RAND_MAX / ((hi)-(lo)+1) + 1)) + (lo))
#  else
#   define RRAND(lo,hi)  (RAND() % ((hi)-(lo)+1) + (lo))
#  endif
# else
   error "Don't have srand() or srandom()."
# endif
#endif


/* These just prevent warnings during development.  They should not be
 * used in production, since they might conflict with system headers.
 */
#ifdef MISSING_DECLS
#if 0
extern void FDECL(bzero,(void *, int));
extern int  FDECL(kill,(pid_t, int));
#else
extern int  FDECL(strcasecmp,(CONST char *, CONST char *));
extern time_t FDECL(time,(time_t *));
extern pid_t FDECL(wait,(int *));
extern int FDECL(socket,(int, int, int));
extern int FDECL(getsockopt,(int, int, int, char *, int *));
extern int FDECL(send,(int, char *, int, int));
extern int FDECL(recv,(int, char *, int, int));
#endif
extern int  VDECL(ioctl,(int, int, ...));
extern long NDECL(random);
extern int  FDECL(srandom,(unsigned));
#endif

#define TRUE 1
#define FALSE 0

#endif /* PORT_H */
