.\" $Id: tf-nroff.man,v 35000.0 1995/01/23 06:05:35 hawkeye Exp $
.TH TF 1 LOCAL
.SH NAME
tf \- TinyFugue, a MUD client
.SH SYNOPSIS
.B "tf [-f\fIfile\fB] [-lnq] [\fIworld\fB]"
.br
.B "tf [-f\fIfile\fB] \fIhost\fB \fIport\fB"
.SH DESCRIPTION
\fITinyFugue\fR (also known as "Fugue" or "TF") is a line-based client
designed for connecting to MUD servers (note: LP, DIKU, and other servers
which use prompts require "/lp on"; see /help prompts).
TinyFugue runs on UNIX-like systems, and on OS/2.
.PP
Most of the \fITF\fR documentation is in the help file, which may be read
online with the "/help" command.
This manual page may be obsolete in certain areas;
however, the helpfile will always be up to date.
.PP
\fITinyFugue\fR is larger than most MUD clients, but has many more features
and is much more flexible.
The goal is to provide the most functionality in a client that still
maintains the user-friendliness of \fITinytalk\fR.
Clients with extension languages such as \fITcltt\fR or \fIVaporTalk\fR
can do a little more in certain areas, but are considerably harder to use
and learn.
\fITF\fR provides most of these abilities in such a manner that learning to use
any one function is relatively easy.
.PP
Because I am continually adding new features and changing the code,
\fITF\fR sometimes becomes less stable in a new release.
Versions labled "alpha" are generally not as well tested as "beta" versions,
so they have the potential for more bugs.
For this reason, I leave some older versions at the ftp site where I distribute
\fITF\fR (ftp.tcp.com), which do not have all the current
features but may have fewer bugs than the most recent release.

.SH "COMMAND LINE ARGUMENTS"
With no arguments, \fITF\fR will 
try to connect to the first world defined in the configuration file(s).
.PP
With a \fBworld\fR argument, \fITF\fR will try to connect to \fBworld\fR,
as defined in the configuration file.
If \fBworld\fR is omitted, it will try to connect to the first world
defined in your configuration files.
.PP
With \fBhost\fR and \fBport\fR arguments, \fITF\fR will define a temporary
world and try to connect to it.
The \fBhost\fR may be an IP number or regular name format.
.PP
OPTIONS
.IP "-f\fIfile\fR"
Load \fIfile\fR instead of $HOME/.tfrc or $HOME/tfrc at startup.
.IP "-f"
Do not load any personal configuration file.  The library will still be loaded.
.IP "-l"
Disable automatic login.
.IP "-n"
Do not connect to any world at startup.
.IP "-q"
Quiet login (overrides %{quiet} flag).

.SH FEATURES
Among other things, \fITF\fR allows you to:
.sp
Divide the screen into two parts, for input and output, with flexible
handling of input (/visual mode).
.sp
Connect to multiple worlds and switch between them.
.sp
Wrap MUD output at the edge of the screen.
.sp
Edit text in the input buffer.
.sp
Recall previous commands.
.sp
Modify key sequences used to perform editing functions.
.sp
Bind commands to key sequences.
.sp
Define complex macros to perform MUD tasks easily.
.sp
Create triggers which automatically perform certain tasks when certain
output is received from the MUD.
.sp
Modify existing macros using either a command format or interactive
editing.
.sp
Support "portals" that automatically switch from world to world.
.sp
Hilite or color all or part of a line that matches a certain pattern.
.sp
Gag lines that match certain patterns.
.sp
Suppress frequently repeated text ("spamming").
.sp
Automatically log into a character on a world.
.sp
Send a text file to the MUD in flexible ways, or echo it locally.
.sp
Send the output of a system command to the MUD, or echo it locally.
.sp
Send text previously received from the MUD to the MUD, or echo it locally.
.sp
Repeat a MUD or \fITF\fR command a number of times.
.sp
Do the above four things at varying intervals, or at a rapid-fire rate.
.sp
Log a session to a file.
.sp
Separate LP and Diku style prompts from normal output.
.sp
Page output using a --More-- prompt.
.sp
Recall previously received text.

.SH "CONFIGURATION FILES"
.PP
\fITF\fR will attempt to read two files when starting.  The first is a public
configuration file "stdlib.tf", located in TFLIBDIR.
TFLIBDIR is defined when \fITF\fR is installed, and is often
/usr/local/lib/tf.lib, or under the home directory of the installer.
This library contains many macros
and definitions essential to the correct operation of \fITF.\fR

Next, \fITF\fR will attempt to read your personal configuration
file, $HOME/.tfrc or $HOME/tfrc, in which you can put any \fITF\fR commands you
want executed automatically at startup.  Two of the most useful
commands to use in a \fITF\fR configuration file are /addworld and /load.

For backward compatability, \fITF\fR will also try
to read the \fITinyTalk\fR configuration file.
Its name defautls to $HOME/.tinytalk, or can be defined by the TINYTALK
environment variable.
This file may start with a list of worlds that will be defined as if with
/addworld.

.SH HISTORY
Anton Rang (Tarrant) in February of 1990 released \fITinytalk\fR,
the first Tinyclient with any great number of features, including
hiliting and suppression of text, simple triggers, and separating input and
output on the screen.
Leo Plotkin (Grod) made rather extensive modifications to \fITinytalk\fR
to produce \fITinywar,\fR which was plagued with some
serious bugs and was never officially released (the phrase "Tinywar
doesn't exist" is often quoted), and is now an unsupported client.
\fITF\fR began when Greg Hudson (Explorer_Bob) merged many of the new
features of \fITinywar\fR back into \fITinyTalk,\fR
and added many new features of his own, most notably the split screen.
Some of the code in Greg's releases was contributed by Leo Plotkin.
After Greg moved on to \fIVaporTalk,\fR Ken Keys (Hawkeye) took over design
and maintenance of \fITF\fR in July 1991, and continues to make improvements
in features and performance.
.PP
The code size of \fITF\fR has surpassed 300K (unstripped),
and is signifigantly larger than \fITinytalk.\fR
It is, in fact, more than three times the size of a number of existing servers.
As of version 3.0, it has 66 builtin commands and 57 library commands,
each documented in the helpfile.
.PP
It has been stated that \fITF\fR is the most-used client in MUDdom at the
current time.
I haven't taken a poll, but I wouldn't be surprised.

.SH REVIEWS
\fITF\fR has significantly changed the tinyclient world.  It has a number of
merits and a number of flaws, and has frequently
been criticized (mostly out of boredom; nobody takes this business too
seriously) as having too many features and being too damn big.
.PP
	"Tinywar doesn't exist; TinyFugue merely shouldn't."
-- Coined by Woodlock, I believe.
.PP
	"TinyFugue is a work of art."
-- Binder, obviously after having too much to drink.
.PP
	"TinyFugue is the biggest hack since the platform it was built on."
-- Explorer_Bob, in one of his lucid moments.
.PP
The New York Times, the Christian Science Monitor and the Washington
Post all refused to comment.

.SH COPYRIGHT

Copyright (C) 1993, 1994 Ken Keys
.sp
\fITinyFugue\fR (aka "\fItf\fR") is protected under the terms of the GNU
General Public License.  See the file "COPYING" for details.
.sp
\fITF\fR is currently supported by Ken Keys, who may be contacted by e-mail at
kkeys@ucsd.edu or hawkeye@tcp.com.

.SH BACKWARD INCOMPATIBILTIES
.PP
VERSION 3.2
.PP
/rand has been replaced with rand().  Color names can no longer be user
defined (but color codes still can).  The "=" operator does comparison,
not assignment.
.PP
VERSION 3.1
.PP
Added type argument to WORLD and LOGIN hooks.
.PP
VERSION 3.0
.PP
Backslashes in macros are interpreted slightly differently than in previous
versions.  Turning on the "backslash" flag will enable the old behavior.
.PP
VERSION 2.1
.PP
The CONNECT hook is now called before the LOGIN hook.  In 2.0, CONNECT was
called after autologin.
.PP
VERSION 2.0
.PP
In versions prior to 2.0, <space> was used to scroll the pager; 2.0 uses <tab>
as the default, to allow the pager to be nonblocking.
.PP
\fITinytalk\fR style name gags and hilites are no longer supported.
You must use the '*' wildcard explicitly, as in '/hilite hawkeye*'.
.PP
\fITinytalk\fR style page and whisper hilites are no longer supported.
However, /hilite_page and /hilite_whisper macros are provided in the
default macro library.
.PP
The .tinytalk file may not be supported in the future; use .tfrc instead.
.PP
The '-' command line option in versions prior to 2.0 is no longer supported,
and has been replaced with '-l'.

.SH BUGS
.PP
When unterbamfing, the old connection should not be closed until the
new connection succeeds.
.PP
If a shell quote (/quote !) reads a partial line from the pipe, the read
will block until the rest of the line is read.

.SH WARNINGS
The Surgeon General has determined that MUDding can be detrimental to
your GPA.
