;;;; Quoting utilities
;;;
;;; /qdef   [<prefix>] <name>	- quote a (current) macro definition
;;; /qmac   [<prefix>] <name>	- quote a macro from a macro file
;;; /qworld [<prefix>] <name>	- quote a world definition
;;; /qfile  [<prefix>] <name>	- quote a file
;;; /qtf    <cmd>		- quote a tf command
;;; /qsh    <cmd>		- quote a shell command
;;; /qmud   [-w<world>] <cmd>	- quote a mud command (requires OUTPUTPREFIX
;;;				  and OUTPUTSUFFIX on the mud)
;;;
;;; <prefix> is prepended to each generated line.  The default prefix is ":|",
;;; but can be changed in /qdef, /qmac, /qworld, and /qfile.

/~loaded quoter.tf

/require lisp.tf
/require pcmd.tf

/def -i qdef = /quote -S %{-L-:|} $$(/cddr `"/list %{L-@}")

/set _qmac_files=%{HOME}/.tfrc *.tf tiny.* %{TFLIBDIR}/*.tf

/def -i qmac = \
  /setenv prog=\
      /^\\/def.* %L[ 	]*=/ { f = 1; } \
      { if (f) print \$0; } \
      /^[^;].*[^\\\\]\$/ { f = 0; }%;\
  /eval /quote -S %{-L-:|} !awk "\\\$prog" `ls %{_qmac_files} 2>/dev/null`

/def -i qworld = /quote -S %{-L-:|} `/listworlds %{L-@}

/def -i qfile = /quote -S %{-L-:|} '%{L-@}

/def -i qtf = :` %*%; /quote -S :| `%*

/def -i qsh = :! %*%; /quote -S :| !%*

/def -i qmud = \
    /let opts=%; \
    /while ( {1} =/ "-[^- ]*" ) \
        /let opts=%opts %1%; \
        /shift%; \
    /done%; \
    /let dest=${world_name}%; \
    /def %{opts} -ip5000 -msimple -t"%{outputprefix}" -1 -aGg qmud_pre = \
        /def %{opts} -i -hbackground -ag qmud_quiet%%; \
        /send -w%{dest} :| $${world_name}> %*%%; \
        /def %{opts} -ip5001 -mglob -t"*" -aGg qmud_all = \
            /send -w%{dest} :| %%%*%%; \
        /def %{opts} -ip5002 -msimple -t"%{outputsuffix}" -1 -aGg qmud_suf = \
            /edit -i -n1 qmud_quiet%%%; \
            /undef qmud_all%; \
    /pcmd %{opts} %*

